// Code generated by smithy-go-codegen DO NOT EDIT.

package outposts

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/outposts/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Use to create a list of every item in the catalog. Add filters to your request
// to return a more specific list of results. Use filters to match an item class,
// storage option, or EC2 family. If you specify multiple filters, the filters are
// joined with an AND, and the request returns only results that match all of the
// specified filters.
func (c *Client) ListCatalogItems(ctx context.Context, params *ListCatalogItemsInput, optFns ...func(*Options)) (*ListCatalogItemsOutput, error) {
	if params == nil {
		params = &ListCatalogItemsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListCatalogItems", params, optFns, c.addOperationListCatalogItemsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListCatalogItemsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListCatalogItemsInput struct {

	// A filter for EC2 family options for items in the catalog. Filter values are case
	// sensitive. If you specify multiple values for a filter, the values are joined
	// with an OR, and the request returns all results that match any of the specified
	// values.
	EC2FamilyFilter []string

	// A filter for the class of items in the catalog. Filter values are case
	// sensitive. If you specify multiple values for a filter, the values are joined
	// with an OR, and the request returns all results that match any of the specified
	// values.
	ItemClassFilter []types.CatalogItemClass

	// The maximum page size.
	MaxResults *int32

	// The pagination token.
	NextToken *string

	// A filter for the storage options of items in the catalog. Filter values are case
	// sensitive. If you specify multiple values for a filter, the values are joined
	// with an OR, and the request returns all results that match any of the specified
	// values.
	SupportedStorageFilter []types.SupportedStorageEnum

	noSmithyDocumentSerde
}

type ListCatalogItemsOutput struct {

	// Information about the catalog items.
	CatalogItems []types.CatalogItem

	// The pagination token.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListCatalogItemsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListCatalogItems{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListCatalogItems{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListCatalogItems(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// ListCatalogItemsAPIClient is a client that implements the ListCatalogItems
// operation.
type ListCatalogItemsAPIClient interface {
	ListCatalogItems(context.Context, *ListCatalogItemsInput, ...func(*Options)) (*ListCatalogItemsOutput, error)
}

var _ ListCatalogItemsAPIClient = (*Client)(nil)

// ListCatalogItemsPaginatorOptions is the paginator options for ListCatalogItems
type ListCatalogItemsPaginatorOptions struct {
	// The maximum page size.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListCatalogItemsPaginator is a paginator for ListCatalogItems
type ListCatalogItemsPaginator struct {
	options   ListCatalogItemsPaginatorOptions
	client    ListCatalogItemsAPIClient
	params    *ListCatalogItemsInput
	nextToken *string
	firstPage bool
}

// NewListCatalogItemsPaginator returns a new ListCatalogItemsPaginator
func NewListCatalogItemsPaginator(client ListCatalogItemsAPIClient, params *ListCatalogItemsInput, optFns ...func(*ListCatalogItemsPaginatorOptions)) *ListCatalogItemsPaginator {
	if params == nil {
		params = &ListCatalogItemsInput{}
	}

	options := ListCatalogItemsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListCatalogItemsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListCatalogItemsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListCatalogItems page.
func (p *ListCatalogItemsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListCatalogItemsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListCatalogItems(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListCatalogItems(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "outposts",
		OperationName: "ListCatalogItems",
	}
}
