// Code generated by smithy-go-codegen DO NOT EDIT.

package opsworks

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/opsworks/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Describes Elastic IP addresses
// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html).
// This call accepts only one resource-identifying parameter. Required Permissions:
// To use this action, an IAM user must have a Show, Deploy, or Manage permissions
// level for the stack, or an attached policy that explicitly grants permissions.
// For more information about user permissions, see Managing User Permissions
// (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *Client) DescribeElasticIps(ctx context.Context, params *DescribeElasticIpsInput, optFns ...func(*Options)) (*DescribeElasticIpsOutput, error) {
	if params == nil {
		params = &DescribeElasticIpsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeElasticIps", params, optFns, c.addOperationDescribeElasticIpsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeElasticIpsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeElasticIpsInput struct {

	// The instance ID. If you include this parameter, DescribeElasticIps returns a
	// description of the Elastic IP addresses associated with the specified instance.
	InstanceId *string

	// An array of Elastic IP addresses to be described. If you include this parameter,
	// DescribeElasticIps returns a description of the specified Elastic IP addresses.
	// Otherwise, it returns a description of every Elastic IP address.
	Ips []string

	// A stack ID. If you include this parameter, DescribeElasticIps returns a
	// description of the Elastic IP addresses that are registered with the specified
	// stack.
	StackId *string

	noSmithyDocumentSerde
}

// Contains the response to a DescribeElasticIps request.
type DescribeElasticIpsOutput struct {

	// An ElasticIps object that describes the specified Elastic IP addresses.
	ElasticIps []types.ElasticIp

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeElasticIpsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribeElasticIps{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribeElasticIps{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeElasticIps(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeElasticIps(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "opsworks",
		OperationName: "DescribeElasticIps",
	}
}
