// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
)

// A custom action to use in stateless rule actions settings. This is used in
// CustomAction.
type ActionDefinition struct {

	// Stateless inspection criteria that publishes the specified metrics to Amazon
	// CloudWatch for the matching packet. This setting defines a CloudWatch dimension
	// value to be published. You can pair this custom action with any of the standard
	// stateless rule actions. For example, you could pair this in a rule action with
	// the standard action that forwards the packet for stateful inspection. Then, when
	// a packet matches the rule, Network Firewall publishes metrics for the packet and
	// forwards it.
	PublishMetricAction *PublishMetricAction

	noSmithyDocumentSerde
}

// A single IP address specification. This is used in the MatchAttributes source
// and destination specifications.
type Address struct {

	// Specify an IP address or a block of IP addresses in Classless Inter-Domain
	// Routing (CIDR) notation. Network Firewall supports all address ranges for IPv4.
	// Examples:
	//
	// * To configure Network Firewall to inspect for the IP address
	// 192.0.2.44, specify 192.0.2.44/32.
	//
	// * To configure Network Firewall to inspect
	// for IP addresses from 192.0.2.0 to 192.0.2.255, specify 192.0.2.0/24.
	//
	// For more
	// information about CIDR notation, see the Wikipedia entry Classless Inter-Domain
	// Routing (https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
	//
	// This member is required.
	AddressDefinition *string

	noSmithyDocumentSerde
}

// The configuration and status for a single subnet that you've specified for use
// by the AWS Network Firewall firewall. This is part of the FirewallStatus.
type Attachment struct {

	// The identifier of the firewall endpoint that Network Firewall has instantiated
	// in the subnet. You use this to identify the firewall endpoint in the VPC route
	// tables, when you redirect the VPC traffic through the endpoint.
	EndpointId *string

	// The current status of the firewall endpoint in the subnet. This value reflects
	// both the instantiation of the endpoint in the VPC subnet and the sync states
	// that are reported in the Config settings. When this value is READY, the endpoint
	// is available and configured properly to handle network traffic. When the
	// endpoint isn't available for traffic, this value will reflect its state, for
	// example CREATING, DELETING, or FAILED.
	Status AttachmentStatus

	// The unique identifier of the subnet that you've specified to be used for a
	// firewall endpoint.
	SubnetId *string

	noSmithyDocumentSerde
}

// An optional, non-standard action to use for stateless packet handling. You can
// define this in addition to the standard action that you must specify. You define
// and name the custom actions that you want to be able to use, and then you
// reference them by name in your actions settings. You can use custom actions in
// the following places:
//
// * In a rule group's StatelessRulesAndCustomActions
// specification. The custom actions are available for use by name inside the
// StatelessRulesAndCustomActions where you define them. You can use them for your
// stateless rule actions to specify what to do with a packet that matches the
// rule's match attributes.
//
// * In a FirewallPolicy specification, in
// StatelessCustomActions. The custom actions are available for use inside the
// policy where you define them. You can use them for the policy's default
// stateless actions settings to specify what to do with packets that don't match
// any of the policy's stateless rules.
type CustomAction struct {

	// The custom action associated with the action name.
	//
	// This member is required.
	ActionDefinition *ActionDefinition

	// The descriptive name of the custom action. You can't change the name of a custom
	// action after you create it.
	//
	// This member is required.
	ActionName *string

	noSmithyDocumentSerde
}

// The value to use in an Amazon CloudWatch custom metric dimension. This is used
// in the PublishMetricsCustomAction. A CloudWatch custom metric dimension is a
// name/value pair that's part of the identity of a metric. AWS Network Firewall
// sets the dimension name to CustomAction and you provide the dimension value. For
// more information about CloudWatch custom metric dimensions, see Publishing
// Custom Metrics
// (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html#usingDimensions)
// in the Amazon CloudWatch User Guide
// (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html).
type Dimension struct {

	// The value to use in the custom metric dimension.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// The firewall defines the configuration settings for an AWS Network Firewall
// firewall. These settings include the firewall policy, the subnets in your VPC to
// use for the firewall endpoints, and any tags that are attached to the firewall
// AWS resource. The status of the firewall, for example whether it's ready to
// filter network traffic, is provided in the corresponding FirewallStatus. You can
// retrieve both objects by calling DescribeFirewall.
type Firewall struct {

	// The unique identifier for the firewall.
	//
	// This member is required.
	FirewallId *string

	// The Amazon Resource Name (ARN) of the firewall policy. The relationship of
	// firewall to firewall policy is many to one. Each firewall requires one firewall
	// policy association, and you can use the same firewall policy for multiple
	// firewalls.
	//
	// This member is required.
	FirewallPolicyArn *string

	// The public subnets that Network Firewall is using for the firewall. Each subnet
	// must belong to a different Availability Zone.
	//
	// This member is required.
	SubnetMappings []SubnetMapping

	// The unique identifier of the VPC where the firewall is in use.
	//
	// This member is required.
	VpcId *string

	// A flag indicating whether it is possible to delete the firewall. A setting of
	// TRUE indicates that the firewall is protected against deletion. Use this setting
	// to protect against accidentally deleting a firewall that is in use. When you
	// create a firewall, the operation initializes this flag to TRUE.
	DeleteProtection bool

	// A description of the firewall.
	Description *string

	// The Amazon Resource Name (ARN) of the firewall.
	FirewallArn *string

	// The descriptive name of the firewall. You can't change the name of a firewall
	// after you create it.
	FirewallName *string

	// A setting indicating whether the firewall is protected against a change to the
	// firewall policy association. Use this setting to protect against accidentally
	// modifying the firewall policy for a firewall that is in use. When you create a
	// firewall, the operation initializes this setting to TRUE.
	FirewallPolicyChangeProtection bool

	// A setting indicating whether the firewall is protected against changes to the
	// subnet associations. Use this setting to protect against accidentally modifying
	// the subnet associations for a firewall that is in use. When you create a
	// firewall, the operation initializes this setting to TRUE.
	SubnetChangeProtection bool

	//
	Tags []Tag

	noSmithyDocumentSerde
}

// High-level information about a firewall, returned by operations like create and
// describe. You can use the information provided in the metadata to retrieve and
// manage a firewall.
type FirewallMetadata struct {

	// The Amazon Resource Name (ARN) of the firewall.
	FirewallArn *string

	// The descriptive name of the firewall. You can't change the name of a firewall
	// after you create it.
	FirewallName *string

	noSmithyDocumentSerde
}

// The firewall policy defines the behavior of a firewall using a collection of
// stateless and stateful rule groups and other settings. You can use one firewall
// policy for multiple firewalls. This, along with FirewallPolicyResponse, define
// the policy. You can retrieve all objects for a firewall policy by calling
// DescribeFirewallPolicy.
type FirewallPolicy struct {

	// The actions to take on a packet if it doesn't match any of the stateless rules
	// in the policy. If you want non-matching packets to be forwarded for stateful
	// inspection, specify aws:forward_to_sfe. You must specify one of the standard
	// actions: aws:pass, aws:drop, or aws:forward_to_sfe. In addition, you can specify
	// custom actions that are compatible with your standard section choice. For
	// example, you could specify ["aws:pass"] or you could specify ["aws:pass",
	// “customActionName”]. For information about compatibility, see the custom action
	// descriptions under CustomAction.
	//
	// This member is required.
	StatelessDefaultActions []string

	// The actions to take on a fragmented UDP packet if it doesn't match any of the
	// stateless rules in the policy. Network Firewall only manages UDP packet
	// fragments and silently drops packet fragments for other protocols. If you want
	// non-matching fragmented UDP packets to be forwarded for stateful inspection,
	// specify aws:forward_to_sfe. You must specify one of the standard actions:
	// aws:pass, aws:drop, or aws:forward_to_sfe. In addition, you can specify custom
	// actions that are compatible with your standard section choice. For example, you
	// could specify ["aws:pass"] or you could specify ["aws:pass",
	// “customActionName”]. For information about compatibility, see the custom action
	// descriptions under CustomAction.
	//
	// This member is required.
	StatelessFragmentDefaultActions []string

	// The default actions to take on a packet that doesn't match any stateful rules.
	// The stateful default action is optional, and is only valid when using the strict
	// rule order. Valid values of the stateful default action:
	//
	// * aws:drop_strict
	//
	// *
	// aws:drop_established
	//
	// * aws:alert_strict
	//
	// * aws:alert_established
	//
	// For more
	// information, see Strict evaluation order
	// (https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-strict-rule-evaluation-order.html)
	// in the AWS Network Firewall Developer Guide.
	StatefulDefaultActions []string

	// Additional options governing how Network Firewall handles stateful rules. The
	// stateful rule groups that you use in your policy must have stateful rule options
	// settings that are compatible with these settings.
	StatefulEngineOptions *StatefulEngineOptions

	// References to the stateful rule groups that are used in the policy. These define
	// the inspection criteria in stateful rules.
	StatefulRuleGroupReferences []StatefulRuleGroupReference

	// The custom action definitions that are available for use in the firewall
	// policy's StatelessDefaultActions setting. You name each custom action that you
	// define, and then you can use it by name in your default actions specifications.
	StatelessCustomActions []CustomAction

	// References to the stateless rule groups that are used in the policy. These
	// define the matching criteria in stateless rules.
	StatelessRuleGroupReferences []StatelessRuleGroupReference

	noSmithyDocumentSerde
}

// High-level information about a firewall policy, returned by operations like
// create and describe. You can use the information provided in the metadata to
// retrieve and manage a firewall policy. You can retrieve all objects for a
// firewall policy by calling DescribeFirewallPolicy.
type FirewallPolicyMetadata struct {

	// The Amazon Resource Name (ARN) of the firewall policy.
	Arn *string

	// The descriptive name of the firewall policy. You can't change the name of a
	// firewall policy after you create it.
	Name *string

	noSmithyDocumentSerde
}

// The high-level properties of a firewall policy. This, along with the
// FirewallPolicy, define the policy. You can retrieve all objects for a firewall
// policy by calling DescribeFirewallPolicy.
type FirewallPolicyResponse struct {

	// The Amazon Resource Name (ARN) of the firewall policy. If this response is for a
	// create request that had DryRun set to TRUE, then this ARN is a placeholder that
	// isn't attached to a valid resource.
	//
	// This member is required.
	FirewallPolicyArn *string

	// The unique identifier for the firewall policy.
	//
	// This member is required.
	FirewallPolicyId *string

	// The descriptive name of the firewall policy. You can't change the name of a
	// firewall policy after you create it.
	//
	// This member is required.
	FirewallPolicyName *string

	// The number of capacity units currently consumed by the policy's stateful rules.
	ConsumedStatefulRuleCapacity *int32

	// The number of capacity units currently consumed by the policy's stateless rules.
	ConsumedStatelessRuleCapacity *int32

	// A description of the firewall policy.
	Description *string

	// The current status of the firewall policy. You can retrieve this for a firewall
	// policy by calling DescribeFirewallPolicy and providing the firewall policy's
	// name or ARN.
	FirewallPolicyStatus ResourceStatus

	// The number of firewalls that are associated with this firewall policy.
	NumberOfAssociations *int32

	// The key:value pairs to associate with the resource.
	Tags []Tag

	noSmithyDocumentSerde
}

// Detailed information about the current status of a Firewall. You can retrieve
// this for a firewall by calling DescribeFirewall and providing the firewall name
// and ARN.
type FirewallStatus struct {

	// The configuration sync state for the firewall. This summarizes the sync states
	// reported in the Config settings for all of the Availability Zones where you have
	// configured the firewall. When you create a firewall or update its configuration,
	// for example by adding a rule group to its firewall policy, Network Firewall
	// distributes the configuration changes to all zones where the firewall is in use.
	// This summary indicates whether the configuration changes have been applied
	// everywhere. This status must be IN_SYNC for the firewall to be ready for use,
	// but it doesn't indicate that the firewall is ready. The Status setting indicates
	// firewall readiness.
	//
	// This member is required.
	ConfigurationSyncStateSummary ConfigurationSyncState

	// The readiness of the configured firewall to handle network traffic across all of
	// the Availability Zones where you've configured it. This setting is READY only
	// when the ConfigurationSyncStateSummary value is IN_SYNC and the AttachmentStatus
	// values for all of the configured subnets are READY.
	//
	// This member is required.
	Status FirewallStatusValue

	// The subnets that you've configured for use by the Network Firewall firewall.
	// This contains one array element per Availability Zone where you've configured a
	// subnet. These objects provide details of the information that is summarized in
	// the ConfigurationSyncStateSummary and Status, broken down by zone and
	// configuration object.
	SyncStates map[string]SyncState

	noSmithyDocumentSerde
}

// The basic rule criteria for AWS Network Firewall to use to inspect packet
// headers in stateful traffic flow inspection. Traffic flows that match the
// criteria are a match for the corresponding StatefulRule.
type Header struct {

	// The destination IP address or address range to inspect for, in CIDR notation. To
	// match with any address, specify ANY. Specify an IP address or a block of IP
	// addresses in Classless Inter-Domain Routing (CIDR) notation. Network Firewall
	// supports all address ranges for IPv4. Examples:
	//
	// * To configure Network Firewall
	// to inspect for the IP address 192.0.2.44, specify 192.0.2.44/32.
	//
	// * To configure
	// Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255,
	// specify 192.0.2.0/24.
	//
	// For more information about CIDR notation, see the
	// Wikipedia entry Classless Inter-Domain Routing
	// (https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
	//
	// This member is required.
	Destination *string

	// The destination port to inspect for. You can specify an individual port, for
	// example 1994 and you can specify a port range, for example 1990:1994. To match
	// with any port, specify ANY.
	//
	// This member is required.
	DestinationPort *string

	// The direction of traffic flow to inspect. If set to ANY, the inspection matches
	// bidirectional traffic, both from the source to the destination and from the
	// destination to the source. If set to FORWARD, the inspection only matches
	// traffic going from the source to the destination.
	//
	// This member is required.
	Direction StatefulRuleDirection

	// The protocol to inspect for. To specify all, you can use IP, because all traffic
	// on AWS and on the internet is IP.
	//
	// This member is required.
	Protocol StatefulRuleProtocol

	// The source IP address or address range to inspect for, in CIDR notation. To
	// match with any address, specify ANY. Specify an IP address or a block of IP
	// addresses in Classless Inter-Domain Routing (CIDR) notation. Network Firewall
	// supports all address ranges for IPv4. Examples:
	//
	// * To configure Network Firewall
	// to inspect for the IP address 192.0.2.44, specify 192.0.2.44/32.
	//
	// * To configure
	// Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255,
	// specify 192.0.2.0/24.
	//
	// For more information about CIDR notation, see the
	// Wikipedia entry Classless Inter-Domain Routing
	// (https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
	//
	// This member is required.
	Source *string

	// The source port to inspect for. You can specify an individual port, for example
	// 1994 and you can specify a port range, for example 1990:1994. To match with any
	// port, specify ANY.
	//
	// This member is required.
	SourcePort *string

	noSmithyDocumentSerde
}

// A list of IP addresses and address ranges, in CIDR notation. This is part of a
// RuleVariables.
type IPSet struct {

	// The list of IP addresses and address ranges, in CIDR notation.
	//
	// This member is required.
	Definition []string

	noSmithyDocumentSerde
}

// Defines where AWS Network Firewall sends logs for the firewall for one log type.
// This is used in LoggingConfiguration. You can send each type of log to an Amazon
// S3 bucket, a CloudWatch log group, or a Kinesis Data Firehose delivery stream.
// Network Firewall generates logs for stateful rule groups. You can save alert and
// flow log types. The stateful rules engine records flow logs for all network
// traffic that it receives. It records alert logs for traffic that matches
// stateful rules that have the rule action set to DROP or ALERT.
type LogDestinationConfig struct {

	// The named location for the logs, provided in a key:value mapping that is
	// specific to the chosen destination type.
	//
	// * For an Amazon S3 bucket, provide the
	// name of the bucket, with key bucketName, and optionally provide a prefix, with
	// key prefix. The following example specifies an Amazon S3 bucket named
	// DOC-EXAMPLE-BUCKET and the prefix alerts: "LogDestination": { "bucketName":
	// "DOC-EXAMPLE-BUCKET", "prefix": "alerts" }
	//
	// * For a CloudWatch log group,
	// provide the name of the CloudWatch log group, with key logGroup. The following
	// example specifies a log group named alert-log-group: "LogDestination": {
	// "logGroup": "alert-log-group" }
	//
	// * For a Kinesis Data Firehose delivery stream,
	// provide the name of the delivery stream, with key deliveryStream. The following
	// example specifies a delivery stream named alert-delivery-stream:
	// "LogDestination": { "deliveryStream": "alert-delivery-stream" }
	//
	// This member is required.
	LogDestination map[string]string

	// The type of storage destination to send these logs to. You can send logs to an
	// Amazon S3 bucket, a CloudWatch log group, or a Kinesis Data Firehose delivery
	// stream.
	//
	// This member is required.
	LogDestinationType LogDestinationType

	// The type of log to send. Alert logs report traffic that matches a StatefulRule
	// with an action setting that sends an alert log message. Flow logs are standard
	// network traffic flow logs.
	//
	// This member is required.
	LogType LogType

	noSmithyDocumentSerde
}

// Defines how AWS Network Firewall performs logging for a Firewall.
type LoggingConfiguration struct {

	// Defines the logging destinations for the logs for a firewall. Network Firewall
	// generates logs for stateful rule groups.
	//
	// This member is required.
	LogDestinationConfigs []LogDestinationConfig

	noSmithyDocumentSerde
}

// Criteria for Network Firewall to use to inspect an individual packet in
// stateless rule inspection. Each match attributes set can include one or more
// items such as IP address, CIDR range, port number, protocol, and TCP flags.
type MatchAttributes struct {

	// The destination ports to inspect for. If not specified, this matches with any
	// destination port. This setting is only used for protocols 6 (TCP) and 17 (UDP).
	// You can specify individual ports, for example 1994 and you can specify port
	// ranges, for example 1990:1994.
	DestinationPorts []PortRange

	// The destination IP addresses and address ranges to inspect for, in CIDR
	// notation. If not specified, this matches with any destination address.
	Destinations []Address

	// The protocols to inspect for, specified using each protocol's assigned internet
	// protocol number (IANA). If not specified, this matches with any protocol.
	Protocols []int32

	// The source ports to inspect for. If not specified, this matches with any source
	// port. This setting is only used for protocols 6 (TCP) and 17 (UDP). You can
	// specify individual ports, for example 1994 and you can specify port ranges, for
	// example 1990:1994.
	SourcePorts []PortRange

	// The source IP addresses and address ranges to inspect for, in CIDR notation. If
	// not specified, this matches with any source address.
	Sources []Address

	// The TCP flags and masks to inspect for. If not specified, this matches with any
	// settings. This setting is only used for protocol 6 (TCP).
	TCPFlags []TCPFlagField

	noSmithyDocumentSerde
}

// Provides configuration status for a single policy or rule group that is used for
// a firewall endpoint. Network Firewall provides each endpoint with the rules that
// are configured in the firewall policy. Each time you add a subnet or modify the
// associated firewall policy, Network Firewall synchronizes the rules in the
// endpoint, so it can properly filter network traffic. This is part of a SyncState
// for a firewall.
type PerObjectStatus struct {

	// Indicates whether this object is in sync with the version indicated in the
	// update token.
	SyncStatus PerObjectSyncStatus

	// The current version of the object that is either in sync or pending
	// synchronization.
	UpdateToken *string

	noSmithyDocumentSerde
}

// A single port range specification. This is used for source and destination port
// ranges in the stateless rule MatchAttributes, SourcePorts, and DestinationPorts
// settings.
type PortRange struct {

	// The lower limit of the port range. This must be less than or equal to the ToPort
	// specification.
	//
	// This member is required.
	FromPort int32

	// The upper limit of the port range. This must be greater than or equal to the
	// FromPort specification.
	//
	// This member is required.
	ToPort int32

	noSmithyDocumentSerde
}

// A set of port ranges for use in the rules in a rule group.
type PortSet struct {

	// The set of port ranges.
	Definition []string

	noSmithyDocumentSerde
}

// Stateless inspection criteria that publishes the specified metrics to Amazon
// CloudWatch for the matching packet. This setting defines a CloudWatch dimension
// value to be published.
type PublishMetricAction struct {

	//
	//
	// This member is required.
	Dimensions []Dimension

	noSmithyDocumentSerde
}

// The inspection criteria and action for a single stateless rule. AWS Network
// Firewall inspects each packet for the specified matching criteria. When a packet
// matches the criteria, Network Firewall performs the rule's actions on the
// packet.
type RuleDefinition struct {

	// The actions to take on a packet that matches one of the stateless rule
	// definition's match attributes. You must specify a standard action and you can
	// add custom actions. Network Firewall only forwards a packet for stateful rule
	// inspection if you specify aws:forward_to_sfe for a rule that the packet matches,
	// or if the packet doesn't match any stateless rule and you specify
	// aws:forward_to_sfe for the StatelessDefaultActions setting for the
	// FirewallPolicy. For every rule, you must specify exactly one of the following
	// standard actions.
	//
	// * aws:pass - Discontinues all inspection of the packet and
	// permits it to go to its intended destination.
	//
	// * aws:drop - Discontinues all
	// inspection of the packet and blocks it from going to its intended
	// destination.
	//
	// * aws:forward_to_sfe - Discontinues stateless inspection of the
	// packet and forwards it to the stateful rule engine for
	// inspection.
	//
	// Additionally, you can specify a custom action. To do this, you
	// define a custom action by name and type, then provide the name you've assigned
	// to the action in this Actions setting. For information about the options, see
	// CustomAction. To provide more than one action in this setting, separate the
	// settings with a comma. For example, if you have a custom PublishMetrics action
	// that you've named MyMetricsAction, then you could specify the standard action
	// aws:pass and the custom action with [“aws:pass”, “MyMetricsAction”].
	//
	// This member is required.
	Actions []string

	// Criteria for Network Firewall to use to inspect an individual packet in
	// stateless rule inspection. Each match attributes set can include one or more
	// items such as IP address, CIDR range, port number, protocol, and TCP flags.
	//
	// This member is required.
	MatchAttributes *MatchAttributes

	noSmithyDocumentSerde
}

// The object that defines the rules in a rule group. This, along with
// RuleGroupResponse, define the rule group. You can retrieve all objects for a
// rule group by calling DescribeRuleGroup. AWS Network Firewall uses a rule group
// to inspect and control network traffic. You define stateless rule groups to
// inspect individual packets and you define stateful rule groups to inspect
// packets in the context of their traffic flow. To use a rule group, you include
// it by reference in an Network Firewall firewall policy, then you use the policy
// in a firewall. You can reference a rule group from more than one firewall
// policy, and you can use a firewall policy in more than one firewall.
type RuleGroup struct {

	// The stateful rules or stateless rules for the rule group.
	//
	// This member is required.
	RulesSource *RulesSource

	// Settings that are available for use in the rules in the rule group. You can only
	// use these for stateful rule groups.
	RuleVariables *RuleVariables

	// Additional options governing how Network Firewall handles stateful rules. The
	// policies where you use your stateful rule group must have stateful rule options
	// settings that are compatible with these settings.
	StatefulRuleOptions *StatefulRuleOptions

	noSmithyDocumentSerde
}

// High-level information about a rule group, returned by ListRuleGroups. You can
// use the information provided in the metadata to retrieve and manage a rule
// group.
type RuleGroupMetadata struct {

	// The Amazon Resource Name (ARN) of the rule group.
	Arn *string

	// The descriptive name of the rule group. You can't change the name of a rule
	// group after you create it.
	Name *string

	noSmithyDocumentSerde
}

// The high-level properties of a rule group. This, along with the RuleGroup,
// define the rule group. You can retrieve all objects for a rule group by calling
// DescribeRuleGroup.
type RuleGroupResponse struct {

	// The Amazon Resource Name (ARN) of the rule group. If this response is for a
	// create request that had DryRun set to TRUE, then this ARN is a placeholder that
	// isn't attached to a valid resource.
	//
	// This member is required.
	RuleGroupArn *string

	// The unique identifier for the rule group.
	//
	// This member is required.
	RuleGroupId *string

	// The descriptive name of the rule group. You can't change the name of a rule
	// group after you create it.
	//
	// This member is required.
	RuleGroupName *string

	// The maximum operating resources that this rule group can use. Rule group
	// capacity is fixed at creation. When you update a rule group, you are limited to
	// this capacity. When you reference a rule group from a firewall policy, Network
	// Firewall reserves this capacity for the rule group. You can retrieve the
	// capacity that would be required for a rule group before you create the rule
	// group by calling CreateRuleGroup with DryRun set to TRUE.
	Capacity *int32

	// The number of capacity units currently consumed by the rule group rules.
	ConsumedCapacity *int32

	// A description of the rule group.
	Description *string

	// The number of firewall policies that use this rule group.
	NumberOfAssociations *int32

	// Detailed information about the current status of a rule group.
	RuleGroupStatus ResourceStatus

	// The key:value pairs to associate with the resource.
	Tags []Tag

	// Indicates whether the rule group is stateless or stateful. If the rule group is
	// stateless, it contains stateless rules. If it is stateful, it contains stateful
	// rules.
	Type RuleGroupType

	noSmithyDocumentSerde
}

// Additional settings for a stateful rule. This is part of the StatefulRule
// configuration.
type RuleOption struct {

	//
	//
	// This member is required.
	Keyword *string

	//
	Settings []string

	noSmithyDocumentSerde
}

// The stateless or stateful rules definitions for use in a single rule group. Each
// rule group requires a single RulesSource. You can use an instance of this for
// either stateless rules or stateful rules.
type RulesSource struct {

	// Stateful inspection criteria for a domain list rule group.
	RulesSourceList *RulesSourceList

	// Stateful inspection criteria, provided in Suricata compatible intrusion
	// prevention system (IPS) rules. Suricata is an open-source network IPS that
	// includes a standard rule-based language for network traffic inspection. These
	// rules contain the inspection criteria and the action to take for traffic that
	// matches the criteria, so this type of rule group doesn't have a separate action
	// setting.
	RulesString *string

	// An array of individual stateful rules inspection criteria to be used together in
	// a stateful rule group. Use this option to specify simple Suricata rules with
	// protocol, source and destination, ports, direction, and rule options. For
	// information about the Suricata Rules format, see Rules Format
	// (https://suricata.readthedocs.io/en/suricata-5.0.0/rules/intro.html#).
	StatefulRules []StatefulRule

	// Stateless inspection criteria to be used in a stateless rule group.
	StatelessRulesAndCustomActions *StatelessRulesAndCustomActions

	noSmithyDocumentSerde
}

// Stateful inspection criteria for a domain list rule group. For HTTPS traffic,
// domain filtering is SNI-based. It uses the server name indicator extension of
// the TLS handshake. By default, Network Firewall domain list inspection only
// includes traffic coming from the VPC where you deploy the firewall. To inspect
// traffic from IP addresses outside of the deployment VPC, you set the HOME_NET
// rule variable to include the CIDR range of the deployment VPC plus the other
// CIDR ranges. For more information, see RuleVariables in this guide and Stateful
// domain list rule groups in AWS Network Firewall
// (https://docs.aws.amazon.com/network-firewall/latest/developerguide/stateful-rule-groups-domain-names.html)
// in the Network Firewall Developer Guide.
type RulesSourceList struct {

	// Whether you want to allow or deny access to the domains in your target list.
	//
	// This member is required.
	GeneratedRulesType GeneratedRulesType

	// The protocols you want to inspect. Specify TLS_SNI for HTTPS. Specify HTTP_HOST
	// for HTTP. You can specify either or both.
	//
	// This member is required.
	TargetTypes []TargetType

	// The domains that you want to inspect for in your traffic flows. Valid domain
	// specifications are the following:
	//
	// * Explicit names. For example,
	// abc.example.com matches only the domain abc.example.com.
	//
	// * Names that use a
	// domain wildcard, which you indicate with an initial '.'. For
	// example,.example.com matches example.com and matches all subdomains of
	// example.com, such as abc.example.com and www.example.com.
	//
	// This member is required.
	Targets []string

	noSmithyDocumentSerde
}

// Settings that are available for use in the rules in the RuleGroup where this is
// defined.
type RuleVariables struct {

	// A list of IP addresses and address ranges, in CIDR notation.
	IPSets map[string]IPSet

	// A list of port ranges.
	PortSets map[string]PortSet

	noSmithyDocumentSerde
}

// Configuration settings for the handling of the stateful rule groups in a
// firewall policy.
type StatefulEngineOptions struct {

	// Indicates how to manage the order of stateful rule evaluation for the policy.
	// DEFAULT_ACTION_ORDER is the default behavior. Stateful rules are provided to the
	// rule engine as Suricata compatible strings, and Suricata evaluates them based on
	// certain settings. For more information, see Evaluation order for stateful rules
	// (https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html)
	// in the AWS Network Firewall Developer Guide.
	RuleOrder RuleOrder

	noSmithyDocumentSerde
}

// A single Suricata rules specification, for use in a stateful rule group. Use
// this option to specify a simple Suricata rule with protocol, source and
// destination, ports, direction, and rule options. For information about the
// Suricata Rules format, see Rules Format
// (https://suricata.readthedocs.io/en/suricata-5.0.0/rules/intro.html#).
type StatefulRule struct {

	// Defines what Network Firewall should do with the packets in a traffic flow when
	// the flow matches the stateful rule criteria. For all actions, Network Firewall
	// performs the specified action and discontinues stateful inspection of the
	// traffic flow. The actions for a stateful rule are defined as follows:
	//
	// * PASS -
	// Permits the packets to go to the intended destination.
	//
	// * DROP - Blocks the
	// packets from going to the intended destination and sends an alert log message,
	// if alert logging is configured in the FirewallLoggingConfiguration.
	//
	// * ALERT -
	// Permits the packets to go to the intended destination and sends an alert log
	// message, if alert logging is configured in the FirewallLoggingConfiguration. You
	// can use this action to test a rule that you intend to use to drop traffic. You
	// can enable the rule with ALERT action, verify in the logs that the rule is
	// filtering as you want, then change the action to DROP.
	//
	// This member is required.
	Action StatefulAction

	// The stateful inspection criteria for this rule, used to inspect traffic flows.
	//
	// This member is required.
	Header *Header

	// Additional options for the rule. These are the Suricata RuleOptions settings.
	//
	// This member is required.
	RuleOptions []RuleOption

	noSmithyDocumentSerde
}

// The setting that allows the policy owner to change the behavior of the rule
// group within a policy.
type StatefulRuleGroupOverride struct {

	// The action that changes the rule group from DROP to ALERT. This only applies to
	// managed rule groups.
	Action OverrideAction

	noSmithyDocumentSerde
}

// Identifier for a single stateful rule group, used in a firewall policy to refer
// to a rule group.
type StatefulRuleGroupReference struct {

	// The Amazon Resource Name (ARN) of the stateful rule group.
	//
	// This member is required.
	ResourceArn *string

	// The action that allows the policy owner to override the behavior of the rule
	// group within a policy.
	Override *StatefulRuleGroupOverride

	// An integer setting that indicates the order in which to run the stateful rule
	// groups in a single FirewallPolicy. This setting only applies to firewall
	// policies that specify the STRICT_ORDER rule order in the stateful engine options
	// settings. Network Firewall evalutes each stateful rule group against a packet
	// starting with the group that has the lowest priority setting. You must ensure
	// that the priority settings are unique within each policy. You can change the
	// priority settings of your rule groups at any time. To make it easier to insert
	// rule groups later, number them so there's a wide range in between, for example
	// use 100, 200, and so on.
	Priority int32

	noSmithyDocumentSerde
}

// Additional options governing how Network Firewall handles the rule group. You
// can only use these for stateful rule groups.
type StatefulRuleOptions struct {

	// Indicates how to manage the order of the rule evaluation for the rule group.
	// DEFAULT_ACTION_ORDER is the default behavior. Stateful rules are provided to the
	// rule engine as Suricata compatible strings, and Suricata evaluates them based on
	// certain settings. For more information, see Evaluation order for stateful rules
	// (https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html)
	// in the AWS Network Firewall Developer Guide.
	RuleOrder RuleOrder

	noSmithyDocumentSerde
}

// A single stateless rule. This is used in StatelessRulesAndCustomActions.
type StatelessRule struct {

	// Indicates the order in which to run this rule relative to all of the rules that
	// are defined for a stateless rule group. Network Firewall evaluates the rules in
	// a rule group starting with the lowest priority setting. You must ensure that the
	// priority settings are unique for the rule group. Each stateless rule group uses
	// exactly one StatelessRulesAndCustomActions object, and each
	// StatelessRulesAndCustomActions contains exactly one StatelessRules object. To
	// ensure unique priority settings for your rule groups, set unique priorities for
	// the stateless rules that you define inside any single StatelessRules object. You
	// can change the priority settings of your rules at any time. To make it easier to
	// insert rules later, number them so there's a wide range in between, for example
	// use 100, 200, and so on.
	//
	// This member is required.
	Priority int32

	// Defines the stateless 5-tuple packet inspection criteria and the action to take
	// on a packet that matches the criteria.
	//
	// This member is required.
	RuleDefinition *RuleDefinition

	noSmithyDocumentSerde
}

// Identifier for a single stateless rule group, used in a firewall policy to refer
// to the rule group.
type StatelessRuleGroupReference struct {

	// An integer setting that indicates the order in which to run the stateless rule
	// groups in a single FirewallPolicy. Network Firewall applies each stateless rule
	// group to a packet starting with the group that has the lowest priority setting.
	// You must ensure that the priority settings are unique within each policy.
	//
	// This member is required.
	Priority int32

	// The Amazon Resource Name (ARN) of the stateless rule group.
	//
	// This member is required.
	ResourceArn *string

	noSmithyDocumentSerde
}

// Stateless inspection criteria. Each stateless rule group uses exactly one of
// these data types to define its stateless rules.
type StatelessRulesAndCustomActions struct {

	// Defines the set of stateless rules for use in a stateless rule group.
	//
	// This member is required.
	StatelessRules []StatelessRule

	// Defines an array of individual custom action definitions that are available for
	// use by the stateless rules in this StatelessRulesAndCustomActions specification.
	// You name each custom action that you define, and then you can use it by name in
	// your StatelessRuleRuleDefinitionActions specification.
	CustomActions []CustomAction

	noSmithyDocumentSerde
}

// The ID for a subnet that you want to associate with the firewall. This is used
// with CreateFirewall and AssociateSubnets. AWS Network Firewall creates an
// instance of the associated firewall in each subnet that you specify, to filter
// traffic in the subnet's Availability Zone.
type SubnetMapping struct {

	// The unique identifier for the subnet.
	//
	// This member is required.
	SubnetId *string

	noSmithyDocumentSerde
}

// The status of the firewall endpoint and firewall policy configuration for a
// single VPC subnet. For each VPC subnet that you associate with a firewall, AWS
// Network Firewall does the following:
//
// * Instantiates a firewall endpoint in the
// subnet, ready to take traffic.
//
// * Configures the endpoint with the current
// firewall policy settings, to provide the filtering behavior for the
// endpoint.
//
// When you update a firewall, for example to add a subnet association
// or change a rule group in the firewall policy, the affected sync states reflect
// out-of-sync or not ready status until the changes are complete.
type SyncState struct {

	// The attachment status of the firewall's association with a single VPC subnet.
	// For each configured subnet, Network Firewall creates the attachment by
	// instantiating the firewall endpoint in the subnet so that it's ready to take
	// traffic. This is part of the FirewallStatus.
	Attachment *Attachment

	// The configuration status of the firewall endpoint in a single VPC subnet.
	// Network Firewall provides each endpoint with the rules that are configured in
	// the firewall policy. Each time you add a subnet or modify the associated
	// firewall policy, Network Firewall synchronizes the rules in the endpoint, so it
	// can properly filter network traffic. This is part of the FirewallStatus.
	Config map[string]PerObjectStatus

	noSmithyDocumentSerde
}

// A key:value pair associated with an AWS resource. The key:value pair can be
// anything you define. Typically, the tag key represents a category (such as
// "environment") and the tag value represents a specific value within that
// category (such as "test," "development," or "production"). You can add up to 50
// tags to each AWS resource.
type Tag struct {

	// The part of the key:value pair that defines a tag. You can use a tag key to
	// describe a category of information, such as "customer." Tag keys are
	// case-sensitive.
	//
	// This member is required.
	Key *string

	// The part of the key:value pair that defines a tag. You can use a tag value to
	// describe a specific value within a category, such as "companyA" or "companyB."
	// Tag values are case-sensitive.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// TCP flags and masks to inspect packets for, used in stateless rules
// MatchAttributes settings.
type TCPFlagField struct {

	// Used in conjunction with the Masks setting to define the flags that must be set
	// and flags that must not be set in order for the packet to match. This setting
	// can only specify values that are also specified in the Masks setting. For the
	// flags that are specified in the masks setting, the following must be true for
	// the packet to match:
	//
	// * The ones that are set in this flags setting must be set
	// in the packet.
	//
	// * The ones that are not set in this flags setting must also not
	// be set in the packet.
	//
	// This member is required.
	Flags []TCPFlag

	// The set of flags to consider in the inspection. To inspect all flags in the
	// valid values list, leave this with no setting.
	Masks []TCPFlag

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
