// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
)

// The request to change the source server migration lifecycle state.
type ChangeServerLifeCycleStateSourceServerLifecycle struct {

	// The request to change the source server migration lifecycle state.
	//
	// This member is required.
	State ChangeServerLifeCycleStateSourceServerLifecycleState

	noSmithyDocumentSerde
}

// Source server CPU information.
type CPU struct {

	// The number of CPU cores on the source server.
	Cores int64

	// The source server's CPU model name.
	ModelName *string

	noSmithyDocumentSerde
}

// Error in data replication.
type DataReplicationError struct {

	// Error in data replication.
	Error DataReplicationErrorString

	// Error in data replication.
	RawError *string

	noSmithyDocumentSerde
}

// Request data replication info.
type DataReplicationInfo struct {

	// Error in obtaining data replication info.
	DataReplicationError *DataReplicationError

	// Request to query whether data replication has been initiated.
	DataReplicationInitiation *DataReplicationInitiation

	// Request to query the data replication state.
	DataReplicationState DataReplicationState

	// Request to query the time when data replication will be complete.
	EtaDateTime *string

	// Request to query data replication lag durating.
	LagDuration *string

	// Request to query data replication last snapshot time.
	LastSnapshotDateTime *string

	// Request to query disks replicated.
	ReplicatedDisks []DataReplicationInfoReplicatedDisk

	noSmithyDocumentSerde
}

// Request to query disks replicated.
type DataReplicationInfoReplicatedDisk struct {

	// Request to query data replication backlog size in bytes.
	BackloggedStorageBytes int64

	// Request to query device name.
	DeviceName *string

	// Request to query amount of data replicated in bytes.
	ReplicatedStorageBytes int64

	// Request to query amount of data rescanned in bytes.
	RescannedStorageBytes int64

	// Request to query total amount of data replicated in bytes.
	TotalStorageBytes int64

	noSmithyDocumentSerde
}

// Data replication initiation.
type DataReplicationInitiation struct {

	// Request to query next data initiation date and time.
	NextAttemptDateTime *string

	// Request to query data initiation start date and time.
	StartDateTime *string

	// Request to query data initiation steps.
	Steps []DataReplicationInitiationStep

	noSmithyDocumentSerde
}

// Data replication intiation step.
type DataReplicationInitiationStep struct {

	// Request to query data initiation step name.
	Name DataReplicationInitiationStepName

	// Request to query data initiation status.
	Status DataReplicationInitiationStepStatus

	noSmithyDocumentSerde
}

// Request to describe Job log filters.
type DescribeJobsRequestFilters struct {

	// Request to describe Job log filters by date.
	FromDate *string

	// Request to describe Job log filters by job ID.
	JobIDs []string

	// Request to describe Job log by last date.
	ToDate *string

	noSmithyDocumentSerde
}

// Request to filter Source Servers list.
type DescribeSourceServersRequestFilters struct {

	// Request to filter Source Servers list by archived.
	IsArchived *bool

	// Request to filter Source Servers list by life cycle states.
	LifeCycleStates []LifeCycleState

	// Request to filter Source Servers list by replication type.
	ReplicationTypes []ReplicationType

	// Request to filter Source Servers list by Source Server ID.
	SourceServerIDs []string

	noSmithyDocumentSerde
}

// The disk identifier.
type Disk struct {

	// The amount of storage on the disk in bytes.
	Bytes int64

	// The disk or device name.
	DeviceName *string

	noSmithyDocumentSerde
}

// Identification hints.
type IdentificationHints struct {

	// AWS Instance ID identification hint.
	AwsInstanceID *string

	// FQDN address identification hint.
	Fqdn *string

	// Hostname identification hint.
	Hostname *string

	// vCenter VM path identification hint.
	VmPath *string

	// vmWare UUID identification hint.
	VmWareUuid *string

	noSmithyDocumentSerde
}

// Job.
type Job struct {

	// Job ID.
	//
	// This member is required.
	JobID *string

	// the ARN of the specific Job.
	Arn *string

	// Job creation time.
	CreationDateTime *string

	// Job end time.
	EndDateTime *string

	// Job initiated by field.
	InitiatedBy InitiatedBy

	// Servers participating in a specific Job.
	ParticipatingServers []ParticipatingServer

	// Job status.
	Status JobStatus

	// Tags associated with spcific Job.
	Tags map[string]string

	// Job type.
	Type JobType

	noSmithyDocumentSerde
}

// Job log.
type JobLog struct {

	// Job log event.
	Event JobLogEvent

	// Job event data
	EventData *JobLogEventData

	// Job log event date and time.
	LogDateTime *string

	noSmithyDocumentSerde
}

// Job log data
type JobLogEventData struct {

	// Job Event conversion Server ID.
	ConversionServerID *string

	// Job error.
	RawError *string

	// Job Event Source Server ID.
	SourceServerID *string

	// Job Event Target instance ID.
	TargetInstanceID *string

	noSmithyDocumentSerde
}

// Configure launced instance.
type LaunchedInstance struct {

	// Configure launced instance EC2 ID.
	Ec2InstanceID *string

	// Configure launced instance first boot.
	FirstBoot FirstBoot

	// Configure launced instance Job ID.
	JobID *string

	noSmithyDocumentSerde
}

// Configure Licensing.
type Licensing struct {

	// Configure BYOL OS licensing.
	OsByol *bool

	noSmithyDocumentSerde
}

// Lifecycle.
type LifeCycle struct {

	// Lifecycle added to service data and time.
	AddedToServiceDateTime *string

	// Lifecycle elapsed time and duration.
	ElapsedReplicationDuration *string

	// Lifecycle replication initiation date and time.
	FirstByteDateTime *string

	// Lifecycle last Cutover.
	LastCutover *LifeCycleLastCutover

	// Lifecycle last seen date and time.
	LastSeenByServiceDateTime *string

	// Lifecycle last Test.
	LastTest *LifeCycleLastTest

	// Lifecycle state.
	State LifeCycleState

	noSmithyDocumentSerde
}

// Lifecycle last Cutover .
type LifeCycleLastCutover struct {

	// Lifecycle Cutover finalized date and time.
	Finalized *LifeCycleLastCutoverFinalized

	// Lifecycle last Cutover initiated.
	Initiated *LifeCycleLastCutoverInitiated

	// Lifecycle last Cutover reverted.
	Reverted *LifeCycleLastCutoverReverted

	noSmithyDocumentSerde
}

// Lifecycle Cutover finalized
type LifeCycleLastCutoverFinalized struct {

	// Lifecycle Cutover finalized date and time.
	ApiCallDateTime *string

	noSmithyDocumentSerde
}

// Lifecycle last Cutover initiated.
type LifeCycleLastCutoverInitiated struct {

	//
	ApiCallDateTime *string

	// Lifecycle last Cutover initiated by Job ID.
	JobID *string

	noSmithyDocumentSerde
}

// Lifecycle last Cutover reverted.
type LifeCycleLastCutoverReverted struct {

	// Lifecycle last Cutover reverted API call date time.
	ApiCallDateTime *string

	noSmithyDocumentSerde
}

// Lifecycle last Test.
type LifeCycleLastTest struct {

	// Lifecycle last Test finlized.
	Finalized *LifeCycleLastTestFinalized

	// Lifecycle last Test initiated.
	Initiated *LifeCycleLastTestInitiated

	// Lifecycle last Test reverted.
	Reverted *LifeCycleLastTestReverted

	noSmithyDocumentSerde
}

// Lifecycle last Test finlized.
type LifeCycleLastTestFinalized struct {

	// Lifecycle Test failed API call date and time.
	ApiCallDateTime *string

	noSmithyDocumentSerde
}

// Lifecycle last Test initiated.
type LifeCycleLastTestInitiated struct {

	// Lifecycle last Test initiated API call date and time.
	ApiCallDateTime *string

	// Lifecycle last Test initiated Job ID.
	JobID *string

	noSmithyDocumentSerde
}

// Lifecycle last Test reverted.
type LifeCycleLastTestReverted struct {

	// Lifecycle last Test reverted API call date and time.
	ApiCallDateTime *string

	noSmithyDocumentSerde
}

// Network interface.
type NetworkInterface struct {

	// Network interface IPs.
	Ips []string

	// Network interface primary IP.
	IsPrimary *bool

	// Network interface Mac address.
	MacAddress *string

	noSmithyDocumentSerde
}

// Operating System.
type OS struct {

	// OS full string.
	FullString *string

	noSmithyDocumentSerde
}

// Server participating in Job.
type ParticipatingServer struct {

	// Participating server launch status.
	LaunchStatus LaunchStatus

	// Participating server Source Server ID.
	SourceServerID *string

	noSmithyDocumentSerde
}

// Replication Configuration replicated disk.
type ReplicationConfigurationReplicatedDisk struct {

	// Replication Configuration replicated disk device name.
	DeviceName *string

	// Replication Configuration replicated disk IOPs.
	Iops int64

	// Replication Configuration replicated disk boot disk.
	IsBootDisk *bool

	// Replication Configuration replicated disk staging disk type.
	StagingDiskType ReplicationConfigurationReplicatedDiskStagingDiskType

	noSmithyDocumentSerde
}

type ReplicationConfigurationTemplate struct {

	// Replication Configuration template template ID.
	//
	// This member is required.
	ReplicationConfigurationTemplateID *string

	// Replication Configuration template ARN.
	Arn *string

	// Replication Configuration template associate default Application Migration
	// Service Security group.
	AssociateDefaultSecurityGroup *bool

	// Replication Configuration template bandwidth throtting.
	BandwidthThrottling int64

	// Replication Configuration template create Public IP.
	CreatePublicIP *bool

	// Replication Configuration template data plane routing.
	DataPlaneRouting ReplicationConfigurationDataPlaneRouting

	// Replication Configuration template use dedault large Staging Disk type.
	DefaultLargeStagingDiskType ReplicationConfigurationDefaultLargeStagingDiskType

	// Replication Configuration template EBS encryption.
	EbsEncryption ReplicationConfigurationEbsEncryption

	// Replication Configuration template EBS encryption key ARN.
	EbsEncryptionKeyArn *string

	// Replication Configuration template server instance type.
	ReplicationServerInstanceType *string

	// Replication Configuration template server Security Groups IDs.
	ReplicationServersSecurityGroupsIDs []string

	// Replication Configuration template Staging Area subnet ID.
	StagingAreaSubnetId *string

	// Replication Configuration template Staging Area Tags.
	StagingAreaTags map[string]string

	// Replication Configuration template Tags.
	Tags map[string]string

	// Replication Configuration template use Dedicated Replication Server.
	UseDedicatedReplicationServer *bool

	noSmithyDocumentSerde
}

// Source server properties.
type SourceProperties struct {

	// Source Server CPUs.
	Cpus []CPU

	// Source Server disks.
	Disks []Disk

	// Source server identification hints.
	IdentificationHints *IdentificationHints

	// Source server last update date and time.
	LastUpdatedDateTime *string

	// Source server network interfaces.
	NetworkInterfaces []NetworkInterface

	// Source server OS.
	Os *OS

	// Source server RAM in bytes.
	RamBytes int64

	// Source server recommended instance type.
	RecommendedInstanceType *string

	noSmithyDocumentSerde
}

type SourceServer struct {

	// Source server ARN.
	Arn *string

	// Source server data replication info.
	DataReplicationInfo *DataReplicationInfo

	// Source server archived status.
	IsArchived *bool

	// Source server launched instance.
	LaunchedInstance *LaunchedInstance

	// Source server lifecycle state.
	LifeCycle *LifeCycle

	// Source server replication type.
	ReplicationType ReplicationType

	// Source server properties.
	SourceProperties *SourceProperties

	// Source server ID.
	SourceServerID *string

	// Source server Tags.
	Tags map[string]string

	// Source server vCenter client id.
	VcenterClientID *string

	noSmithyDocumentSerde
}

// Validate exception field.
type ValidationExceptionField struct {

	// Validate exception field message.
	Message *string

	// Validate exception field name.
	Name *string

	noSmithyDocumentSerde
}

// vCenter client.
type VcenterClient struct {

	// Arn of vCenter client.
	Arn *string

	// Datacenter name of vCenter client.
	DatacenterName *string

	// Hostname of vCenter client .
	Hostname *string

	// Last seen time of vCenter client.
	LastSeenDatetime *string

	// Tags for Source Server of vCenter client.
	SourceServerTags map[string]string

	// Tags for vCenter client.
	Tags map[string]string

	// ID of vCenter client.
	VcenterClientID *string

	// Vcenter UUID of vCenter client.
	VcenterUUID *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
