// Code generated by smithy-go-codegen DO NOT EDIT.

package machinelearning

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	mlcust "github.com/aws/aws-sdk-go-v2/service/machinelearning/internal/customizations"
	"github.com/aws/aws-sdk-go-v2/service/machinelearning/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Generates a prediction for the observation using the specified ML Model. Note:
// Not all response parameters will be populated. Whether a response parameter is
// populated depends on the type of model requested.
func (c *Client) Predict(ctx context.Context, params *PredictInput, optFns ...func(*Options)) (*PredictOutput, error) {
	if params == nil {
		params = &PredictInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "Predict", params, optFns, c.addOperationPredictMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*PredictOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type PredictInput struct {

	// A unique identifier of the MLModel.
	//
	// This member is required.
	MLModelId *string

	// This member is required.
	PredictEndpoint *string

	// A map of variable name-value pairs that represent an observation.
	//
	// This member is required.
	Record map[string]string

	noSmithyDocumentSerde
}

type PredictOutput struct {

	// The output from a Predict operation:
	//
	// * Details - Contains the following
	// attributes: DetailsAttributes.PREDICTIVE_MODEL_TYPE - REGRESSION | BINARY |
	// MULTICLASSDetailsAttributes.ALGORITHM - SGD
	//
	// * PredictedLabel - Present for
	// either a BINARY or MULTICLASSMLModel request.
	//
	// * PredictedScores - Contains the
	// raw classification score corresponding to each label.
	//
	// * PredictedValue -
	// Present for a REGRESSIONMLModel request.
	Prediction *types.Prediction

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationPredictMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpPredict{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpPredict{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpPredictValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opPredict(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = mlcust.AddPredictEndpointMiddleware(stack, getPredictEndpoint); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opPredict(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "machinelearning",
		OperationName: "Predict",
	}
}

func getPredictEndpoint(input interface{}) (*string, error) {
	in, ok := input.(*PredictInput)
	if !ok {
		return nil, &smithy.SerializationError{Err: fmt.Errorf("expected *PredictInput, but was %T", input)}
	}
	return in.PredictEndpoint, nil
}
