// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// An Amazon Web Services account within your environment that Amazon Inspector has
// been enabled for.
type Account struct {

	// The ID of the Amazon Web Services account.
	//
	// This member is required.
	AccountId *string

	// Details of the status of Amazon Inspector scans by resource type.
	//
	// This member is required.
	ResourceStatus *ResourceStatus

	// The status of Amazon Inspector for the account.
	//
	// This member is required.
	Status Status

	noSmithyDocumentSerde
}

// An object that contains details about an aggregation response based on Amazon
// Web Services accounts.
type AccountAggregation struct {

	// The type of finding.
	FindingType AggregationFindingType

	// The type of resource.
	ResourceType AggregationResourceType

	// The value to sort by.
	SortBy AccountSortBy

	// The sort order (ascending or descending).
	SortOrder SortOrder

	noSmithyDocumentSerde
}

// An aggregation of findings by Amazon Web Services account ID.
type AccountAggregationResponse struct {

	// The Amazon Web Services account ID.
	AccountId *string

	// The number of findings by severity.
	SeverityCounts *SeverityCounts

	noSmithyDocumentSerde
}

// An object with details the status of an Amazon Web Services account within your
// Amazon Inspector environment
type AccountState struct {

	// The Amazon Web Services account ID.
	//
	// This member is required.
	AccountId *string

	// An object detailing which resources Amazon Inspector is enabled to scan for the
	// account.
	//
	// This member is required.
	ResourceState *ResourceState

	// An object detailing the status of Amazon Inspector for the account.
	//
	// This member is required.
	State *State

	noSmithyDocumentSerde
}

// Contains details about an aggregation request.
//
// The following types satisfy this interface:
//  AggregationRequestMemberAccountAggregation
//  AggregationRequestMemberAmiAggregation
//  AggregationRequestMemberAwsEcrContainerAggregation
//  AggregationRequestMemberEc2InstanceAggregation
//  AggregationRequestMemberFindingTypeAggregation
//  AggregationRequestMemberImageLayerAggregation
//  AggregationRequestMemberPackageAggregation
//  AggregationRequestMemberRepositoryAggregation
//  AggregationRequestMemberTitleAggregation
type AggregationRequest interface {
	isAggregationRequest()
}

// An object that contains details about an aggregation request based on Amazon Web
// Services account IDs.
type AggregationRequestMemberAccountAggregation struct {
	Value AccountAggregation

	noSmithyDocumentSerde
}

func (*AggregationRequestMemberAccountAggregation) isAggregationRequest() {}

// An object that contains details about an aggregation request based on Amazon
// Machine Images (AMIs).
type AggregationRequestMemberAmiAggregation struct {
	Value AmiAggregation

	noSmithyDocumentSerde
}

func (*AggregationRequestMemberAmiAggregation) isAggregationRequest() {}

// An object that contains details about an aggregation request based on Amazon ECR
// container images.
type AggregationRequestMemberAwsEcrContainerAggregation struct {
	Value AwsEcrContainerAggregation

	noSmithyDocumentSerde
}

func (*AggregationRequestMemberAwsEcrContainerAggregation) isAggregationRequest() {}

// An object that contains details about an aggregation request based on Amazon EC2
// instances.
type AggregationRequestMemberEc2InstanceAggregation struct {
	Value Ec2InstanceAggregation

	noSmithyDocumentSerde
}

func (*AggregationRequestMemberEc2InstanceAggregation) isAggregationRequest() {}

// An object that contains details about an aggregation request based on finding
// types.
type AggregationRequestMemberFindingTypeAggregation struct {
	Value FindingTypeAggregation

	noSmithyDocumentSerde
}

func (*AggregationRequestMemberFindingTypeAggregation) isAggregationRequest() {}

// An object that contains details about an aggregation request based on container
// image layers.
type AggregationRequestMemberImageLayerAggregation struct {
	Value ImageLayerAggregation

	noSmithyDocumentSerde
}

func (*AggregationRequestMemberImageLayerAggregation) isAggregationRequest() {}

// An object that contains details about an aggregation request based on operating
// system package type.
type AggregationRequestMemberPackageAggregation struct {
	Value PackageAggregation

	noSmithyDocumentSerde
}

func (*AggregationRequestMemberPackageAggregation) isAggregationRequest() {}

// An object that contains details about an aggregation request based on Amazon ECR
// repositories.
type AggregationRequestMemberRepositoryAggregation struct {
	Value RepositoryAggregation

	noSmithyDocumentSerde
}

func (*AggregationRequestMemberRepositoryAggregation) isAggregationRequest() {}

// An object that contains details about an aggregation request based on finding
// title.
type AggregationRequestMemberTitleAggregation struct {
	Value TitleAggregation

	noSmithyDocumentSerde
}

func (*AggregationRequestMemberTitleAggregation) isAggregationRequest() {}

// A structure that contains details about the results of an aggregation type.
//
// The following types satisfy this interface:
//  AggregationResponseMemberAccountAggregation
//  AggregationResponseMemberAmiAggregation
//  AggregationResponseMemberAwsEcrContainerAggregation
//  AggregationResponseMemberEc2InstanceAggregation
//  AggregationResponseMemberFindingTypeAggregation
//  AggregationResponseMemberImageLayerAggregation
//  AggregationResponseMemberPackageAggregation
//  AggregationResponseMemberRepositoryAggregation
//  AggregationResponseMemberTitleAggregation
type AggregationResponse interface {
	isAggregationResponse()
}

// An object that contains details about an aggregation response based on Amazon
// Web Services account IDs.
type AggregationResponseMemberAccountAggregation struct {
	Value AccountAggregationResponse

	noSmithyDocumentSerde
}

func (*AggregationResponseMemberAccountAggregation) isAggregationResponse() {}

// An object that contains details about an aggregation response based on Amazon
// Machine Images (AMIs).
type AggregationResponseMemberAmiAggregation struct {
	Value AmiAggregationResponse

	noSmithyDocumentSerde
}

func (*AggregationResponseMemberAmiAggregation) isAggregationResponse() {}

// An object that contains details about an aggregation response based on Amazon
// ECR container images.
type AggregationResponseMemberAwsEcrContainerAggregation struct {
	Value AwsEcrContainerAggregationResponse

	noSmithyDocumentSerde
}

func (*AggregationResponseMemberAwsEcrContainerAggregation) isAggregationResponse() {}

// An object that contains details about an aggregation response based on Amazon
// EC2 instances.
type AggregationResponseMemberEc2InstanceAggregation struct {
	Value Ec2InstanceAggregationResponse

	noSmithyDocumentSerde
}

func (*AggregationResponseMemberEc2InstanceAggregation) isAggregationResponse() {}

// An object that contains details about an aggregation response based on finding
// types.
type AggregationResponseMemberFindingTypeAggregation struct {
	Value FindingTypeAggregationResponse

	noSmithyDocumentSerde
}

func (*AggregationResponseMemberFindingTypeAggregation) isAggregationResponse() {}

// An object that contains details about an aggregation response based on container
// image layers.
type AggregationResponseMemberImageLayerAggregation struct {
	Value ImageLayerAggregationResponse

	noSmithyDocumentSerde
}

func (*AggregationResponseMemberImageLayerAggregation) isAggregationResponse() {}

// An object that contains details about an aggregation response based on operating
// system package type.
type AggregationResponseMemberPackageAggregation struct {
	Value PackageAggregationResponse

	noSmithyDocumentSerde
}

func (*AggregationResponseMemberPackageAggregation) isAggregationResponse() {}

// An object that contains details about an aggregation response based on Amazon
// ECR repositories.
type AggregationResponseMemberRepositoryAggregation struct {
	Value RepositoryAggregationResponse

	noSmithyDocumentSerde
}

func (*AggregationResponseMemberRepositoryAggregation) isAggregationResponse() {}

// An object that contains details about an aggregation response based on finding
// title.
type AggregationResponseMemberTitleAggregation struct {
	Value TitleAggregationResponse

	noSmithyDocumentSerde
}

func (*AggregationResponseMemberTitleAggregation) isAggregationResponse() {}

// The details that define an aggregation based on Amazon machine images (AMIs).
type AmiAggregation struct {

	// The IDs of AMIs to aggregate findings for.
	Amis []StringFilter

	// The value to sort results by.
	SortBy AmiSortBy

	// The order to sort results by.
	SortOrder SortOrder

	noSmithyDocumentSerde
}

// A response that contains the results of a finding aggregation by AMI.
type AmiAggregationResponse struct {

	// The ID of the AMI that findings were aggregated for.
	//
	// This member is required.
	Ami *string

	// The Amazon Web Services account ID that the AMI belongs.
	AccountId *string

	// The IDs of Amazon EC2 instances using this AMI.
	AffectedInstances *int64

	// An object that contains the count of matched findings per severity.
	SeverityCounts *SeverityCounts

	noSmithyDocumentSerde
}

// Represents which scan types are automatically enabled for new members of your
// Amazon Inspector organization.
type AutoEnable struct {

	// Represents whether Amazon EC2 scans are automatically enabled for new members of
	// your Amazon Inspector organization.
	//
	// This member is required.
	Ec2 *bool

	// Represents whether Amazon ECR scans are automatically enabled for new members of
	// your Amazon Inspector organization.
	//
	// This member is required.
	Ecr *bool

	noSmithyDocumentSerde
}

// Details of the Amazon EC2 instance involved in a finding.
type AwsEc2InstanceDetails struct {

	// The IAM instance profile ARN of the Amazon EC2 instance.
	IamInstanceProfileArn *string

	// The image ID of the Amazon EC2 instance.
	ImageId *string

	// The IPv4 addresses of the Amazon EC2 instance.
	IpV4Addresses []string

	// The IPv6 addresses of the Amazon EC2 instance.
	IpV6Addresses []string

	// The name of the key pair used to launch the Amazon EC2 instance.
	KeyName *string

	// The date and time the Amazon EC2 instance was launched at.
	LaunchedAt *time.Time

	// The platform of the Amazon EC2 instance.
	Platform *string

	// The subnet ID of the Amazon EC2 instance.
	SubnetId *string

	// The type of the Amazon EC2 instance.
	Type *string

	// The VPC ID of the Amazon EC2 instance.
	VpcId *string

	noSmithyDocumentSerde
}

// An aggregation of information about Amazon ECR containers.
type AwsEcrContainerAggregation struct {

	// The architecture of the containers.
	Architectures []StringFilter

	// The image SHA values.
	ImageShas []StringFilter

	// The image tags.
	ImageTags []StringFilter

	// The container repositories.
	Repositories []StringFilter

	// The container resource IDs.
	ResourceIds []StringFilter

	// The value to sort by.
	SortBy AwsEcrContainerSortBy

	// The sort order (ascending or descending).
	SortOrder SortOrder

	noSmithyDocumentSerde
}

// An aggregation of information about Amazon ECR containers.
type AwsEcrContainerAggregationResponse struct {

	// The resource ID of the container.
	//
	// This member is required.
	ResourceId *string

	// The Amazon Web Services account ID of the account that owns the container.
	AccountId *string

	// The architecture of the container.
	Architecture *string

	// The SHA value of the container image.
	ImageSha *string

	// The container image stags.
	ImageTags []string

	// The container repository.
	Repository *string

	// The number of finding by severity.
	SeverityCounts *SeverityCounts

	noSmithyDocumentSerde
}

// The image details of the Amazon ECR container image.
type AwsEcrContainerImageDetails struct {

	// The image hash of the Amazon ECR container image.
	//
	// This member is required.
	ImageHash *string

	// The registry the Amazon ECR container image belongs to.
	//
	// This member is required.
	Registry *string

	// The name of the repository the Amazon ECR container image resides in.
	//
	// This member is required.
	RepositoryName *string

	// The architecture of the Amazon ECR container image.
	Architecture *string

	// The image author of the Amazon ECR container image.
	Author *string

	// The image tags attached to the Amazon ECR container image.
	ImageTags []string

	// The platform of the Amazon ECR container image.
	Platform *string

	// The date and time the Amazon ECR container image was pushed.
	PushedAt *time.Time

	noSmithyDocumentSerde
}

// a structure that contains information on the count of resources within a group.
type Counts struct {

	// The number of resources.
	Count int64

	// The key associated with this group
	GroupKey GroupKey

	noSmithyDocumentSerde
}

// A structure that identifies filter criteria for GetCoverageStatistics.
type CoverageFilterCriteria struct {

	// An array of Amazon Web Services account IDs to return coverage statistics for.
	AccountId []CoverageStringFilter

	// The Amazon EC2 instance tags to filter on.
	Ec2InstanceTags []CoverageMapFilter

	// The Amazon ECR image tags to filter on.
	EcrImageTags []CoverageStringFilter

	// The Amazon ECR repository name to filter on.
	EcrRepositoryName []CoverageStringFilter

	// An array of Amazon Web Services resource IDs to return coverage statistics for.
	ResourceId []CoverageStringFilter

	// An array of Amazon Web Services resource types to return coverage statistics
	// for.
	ResourceType []CoverageStringFilter

	// The scan status code to filter on.
	ScanStatusCode []CoverageStringFilter

	// The scan status reason to filter on.
	ScanStatusReason []CoverageStringFilter

	// An array of Amazon Inspector scan types to return coverage statistics for.
	ScanType []CoverageStringFilter

	noSmithyDocumentSerde
}

// Contains details of a coverage map filter.
type CoverageMapFilter struct {

	// The operator to compare coverage on.
	//
	// This member is required.
	Comparison CoverageMapComparison

	// The tag key associated with the coverage map filter.
	//
	// This member is required.
	Key *string

	// The tag value associated with the coverage map filter.
	Value *string

	noSmithyDocumentSerde
}

// Contains details of a coverage string filter.
type CoverageStringFilter struct {

	// The operator to compare strings on.
	//
	// This member is required.
	Comparison CoverageStringComparison

	// The value to compare strings on.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// An object that contains details about a resource covered by Amazon Inspector.
type CoveredResource struct {

	// The Amazon Web Services account ID of the covered resource.
	//
	// This member is required.
	AccountId *string

	// The ID of the covered resource.
	//
	// This member is required.
	ResourceId *string

	// The type of the covered resource.
	//
	// This member is required.
	ResourceType CoverageResourceType

	// The Amazon Inspector scan type covering the resource.
	//
	// This member is required.
	ScanType ScanType

	// An object that contains details about the metadata.
	ResourceMetadata *ResourceScanMetadata

	// The status of the scan covering the resource.
	ScanStatus *ScanStatus

	noSmithyDocumentSerde
}

// The CVSS score for a finding.
type CvssScore struct {

	// The base CVSS score used for the finding.
	//
	// This member is required.
	BaseScore *float64

	// The vector string of the CVSS score.
	//
	// This member is required.
	ScoringVector *string

	// The source of the CVSS score.
	//
	// This member is required.
	Source *string

	// The version of CVSS used for the score.
	//
	// This member is required.
	Version *string

	noSmithyDocumentSerde
}

// Details on adjustments Amazon Inspector made to the CVSS score for a finding.
type CvssScoreAdjustment struct {

	// The metric used to adjust the CVSS score.
	//
	// This member is required.
	Metric *string

	// The reason the CVSS score has been adjustment.
	//
	// This member is required.
	Reason *string

	noSmithyDocumentSerde
}

// Information about the CVSS score.
type CvssScoreDetails struct {

	// The CVSS score.
	//
	// This member is required.
	Score *float64

	// The source for the CVSS score.
	//
	// This member is required.
	ScoreSource *string

	// The vector for the CVSS score.
	//
	// This member is required.
	ScoringVector *string

	// The CVSS version used in scoring.
	//
	// This member is required.
	Version *string

	// An object that contains details about adjustment Amazon Inspector made to the
	// CVSS score.
	Adjustments []CvssScoreAdjustment

	// The source of the CVSS data.
	CvssSource *string

	noSmithyDocumentSerde
}

// Contains details on the time range used to filter findings.
type DateFilter struct {

	// A timestamp representing the end of the time period filtered on.
	EndInclusive *time.Time

	// A timestamp representing the start of the time period filtered on.
	StartInclusive *time.Time

	noSmithyDocumentSerde
}

// Details of the Amazon Inspector delegated administrator for your organization.
type DelegatedAdmin struct {

	// The Amazon Web Services account ID of the Amazon Inspector delegated
	// administrator for your organization.
	AccountId *string

	// The status of the Amazon Inspector delegated administrator.
	RelationshipStatus RelationshipStatus

	noSmithyDocumentSerde
}

// Details of the Amazon Inspector delegated administrator for your organization.
type DelegatedAdminAccount struct {

	// The Amazon Web Services account ID of the Amazon Inspector delegated
	// administrator for your organization.
	AccountId *string

	// The status of the Amazon Inspector delegated administrator.
	Status DelegatedAdminStatus

	noSmithyDocumentSerde
}

// Contains details of the Amazon S3 bucket and KMS key used to export findings.
type Destination struct {

	// The name of the Amazon S3 bucket to export findings to.
	//
	// This member is required.
	BucketName *string

	// The ARN of the KMS key used to encrypt data when exporting findings.
	//
	// This member is required.
	KmsKeyArn *string

	// The prefix of the KMS key used to export findings.
	KeyPrefix *string

	noSmithyDocumentSerde
}

// The details that define an aggregation based on Amazon EC2 instances.
type Ec2InstanceAggregation struct {

	// The AMI IDs associated with the Amazon EC2 instances to aggregate findings for.
	Amis []StringFilter

	// The Amazon EC2 instance IDs to aggregate findings for.
	InstanceIds []StringFilter

	// The Amazon EC2 instance tags to aggregate findings for.
	InstanceTags []MapFilter

	// The operating system types to aggregate findings for. Valid values must be
	// uppercase and underscore separated, examples are ORACLE_LINUX_7 and
	// ALPINE_LINUX_3_8.
	OperatingSystems []StringFilter

	// The value to sort results by.
	SortBy Ec2InstanceSortBy

	// The order to sort results by.
	SortOrder SortOrder

	noSmithyDocumentSerde
}

// A response that contains the results of a finding aggregation by Amazon EC2
// instance.
type Ec2InstanceAggregationResponse struct {

	// The Amazon EC2 instance ID.
	//
	// This member is required.
	InstanceId *string

	// The Amazon Web Services account the Amazon EC2 instance belongs to.
	AccountId *string

	// The Amazon Machine Image (AMI) of the Amazon EC2 instance.
	Ami *string

	// The tags attached to the instance.
	InstanceTags map[string]string

	// The number of network findings for the Amazon EC2 instance.
	NetworkFindings *int64

	// The operating system of the Amazon EC2 instance.
	OperatingSystem *string

	// An object that contains the count of matched findings per severity.
	SeverityCounts *SeverityCounts

	noSmithyDocumentSerde
}

// Meta data details of an Amazon EC2 instance.
type Ec2Metadata struct {

	// The ID of the Amazon Machine Image (AMI) used to launch the instance.
	AmiId *string

	// The platform of the instance.
	Platform Ec2Platform

	// The tags attached to the instance.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Information on the Amazon ECR image metadata associated with a finding.
type EcrContainerImageMetadata struct {

	// Tags associated with the Amazon ECR image metadata.
	Tags []string

	noSmithyDocumentSerde
}

// Information on the Amazon ECR repository metadata associated with a finding.
type EcrRepositoryMetadata struct {

	// The name of the Amazon ECR repository.
	Name *string

	// The frequency of scans.
	ScanFrequency EcrScanFrequency

	noSmithyDocumentSerde
}

// An object with details on why an account failed to enable Amazon Inspector.
type FailedAccount struct {

	// The Amazon Web Services account ID.
	//
	// This member is required.
	AccountId *string

	// The error code explaining why the account failed to enable Amazon Inspector.
	//
	// This member is required.
	ErrorCode ErrorCode

	// The error message received when the account failed to enable Amazon Inspector.
	//
	// This member is required.
	ErrorMessage *string

	// An object detailing which resources Amazon Inspector is enabled to scan for the
	// account.
	ResourceStatus *ResourceStatus

	// The status of Amazon Inspector for the account.
	Status Status

	noSmithyDocumentSerde
}

// Details about a filter.
type Filter struct {

	// The action that is to be applied to the findings that match the filter.
	//
	// This member is required.
	Action FilterAction

	// The Amazon Resource Number (ARN) associated with this filter.
	//
	// This member is required.
	Arn *string

	// The date and time this filter was created at.
	//
	// This member is required.
	CreatedAt *time.Time

	// Details on the filter criteria associated with this filter.
	//
	// This member is required.
	Criteria *FilterCriteria

	// The name of the filter.
	//
	// This member is required.
	Name *string

	// The Amazon Web Services account ID of the account that created the filter.
	//
	// This member is required.
	OwnerId *string

	// The date and time the filter was last updated at.
	//
	// This member is required.
	UpdatedAt *time.Time

	// A description of the filter.
	Description *string

	// The reason for the filter.
	Reason *string

	// The tags attached to the filter.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Details on the criteria used to define the filter.
type FilterCriteria struct {

	// Details of the Amazon Web Services account IDs used to filter findings.
	AwsAccountId []StringFilter

	// Details of the component IDs used to filter findings.
	ComponentId []StringFilter

	// Details of the component types used to filter findings.
	ComponentType []StringFilter

	// Details of the Amazon EC2 instance image IDs used to filter findings.
	Ec2InstanceImageId []StringFilter

	// Details of the Amazon EC2 instance subnet IDs used to filter findings.
	Ec2InstanceSubnetId []StringFilter

	// Details of the Amazon EC2 instance VPC IDs used to filter findings.
	Ec2InstanceVpcId []StringFilter

	// Details of the Amazon ECR image architecture types used to filter findings.
	EcrImageArchitecture []StringFilter

	// Details of the Amazon ECR image hashes used to filter findings.
	EcrImageHash []StringFilter

	// Details on the Amazon ECR image push date and time used to filter findings.
	EcrImagePushedAt []DateFilter

	// Details on the Amazon ECR registry used to filter findings.
	EcrImageRegistry []StringFilter

	// Details on the name of the Amazon ECR repository used to filter findings.
	EcrImageRepositoryName []StringFilter

	// The tags attached to the Amazon ECR container image.
	EcrImageTags []StringFilter

	// Details on the finding ARNs used to filter findings.
	FindingArn []StringFilter

	// Details on the finding status types used to filter findings.
	FindingStatus []StringFilter

	// Details on the finding types used to filter findings.
	FindingType []StringFilter

	// Details on the date and time a finding was first seen used to filter findings.
	FirstObservedAt []DateFilter

	// The Amazon Inspector score to filter on.
	InspectorScore []NumberFilter

	// Details on the date and time a finding was last seen used to filter findings.
	LastObservedAt []DateFilter

	// Details on the ingress source addresses used to filter findings.
	NetworkProtocol []StringFilter

	// Details on the port ranges used to filter findings.
	PortRange []PortRangeFilter

	// Details on the related vulnerabilities used to filter findings.
	RelatedVulnerabilities []StringFilter

	// Details on the resource IDs used to filter findings.
	ResourceId []StringFilter

	// Details on the resource tags used to filter findings.
	ResourceTags []MapFilter

	// Details on the resource types used to filter findings.
	ResourceType []StringFilter

	// Details on the severity used to filter findings.
	Severity []StringFilter

	// Details on the finding title used to filter findings.
	Title []StringFilter

	// Details on the date and time a finding was last updated at used to filter
	// findings.
	UpdatedAt []DateFilter

	// Details on the vendor severity used to filter findings.
	VendorSeverity []StringFilter

	// Details on the vulnerability ID used to filter findings.
	VulnerabilityId []StringFilter

	// Details on the vulnerability type used to filter findings.
	VulnerabilitySource []StringFilter

	// Details on the vulnerable packages used to filter findings.
	VulnerablePackages []PackageFilter

	noSmithyDocumentSerde
}

// Details about an Amazon Inspector finding.
type Finding struct {

	// The Amazon Web Services account ID associated with the finding.
	//
	// This member is required.
	AwsAccountId *string

	// The description of the finding.
	//
	// This member is required.
	Description *string

	// The Amazon Resource Number (ARN) of the finding.
	//
	// This member is required.
	FindingArn *string

	// The date and time that the finding was first observed.
	//
	// This member is required.
	FirstObservedAt *time.Time

	// The date and time that the finding was last observed.
	//
	// This member is required.
	LastObservedAt *time.Time

	// An object that contains the details about how to remediate a finding.
	//
	// This member is required.
	Remediation *Remediation

	// Contains information on the resources involved in a finding.
	//
	// This member is required.
	Resources []Resource

	// The severity of the finding.
	//
	// This member is required.
	Severity Severity

	// The status of the finding.
	//
	// This member is required.
	Status FindingStatus

	// The type of the finding.
	//
	// This member is required.
	Type FindingType

	// The Amazon Inspector score given to the finding.
	InspectorScore *float64

	// An object that contains details of the Amazon Inspector score.
	InspectorScoreDetails *InspectorScoreDetails

	// An object that contains the details of a network reachability finding.
	NetworkReachabilityDetails *NetworkReachabilityDetails

	// An object that contains the details of a package vulnerability finding.
	PackageVulnerabilityDetails *PackageVulnerabilityDetails

	// The title of the finding.
	Title *string

	// The date and time the finding was last updated at.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// The details that define an aggregation based on finding type.
type FindingTypeAggregation struct {

	// The finding type to aggregate.
	FindingType AggregationFindingType

	// The resource type to aggregate.
	ResourceType AggregationResourceType

	// The value to sort results by.
	SortBy FindingTypeSortBy

	// The order to sort results by.
	SortOrder SortOrder

	noSmithyDocumentSerde
}

// A response that contains the results of a finding type aggregation.
type FindingTypeAggregationResponse struct {

	// The ID of the Amazon Web Services account associated with the findings.
	AccountId *string

	// The value to sort results by.
	SeverityCounts *SeverityCounts

	noSmithyDocumentSerde
}

// Information about the Amazon Inspector free trial for an account.
type FreeTrialAccountInfo struct {

	// The account associated with the Amazon Inspector free trial information.
	//
	// This member is required.
	AccountId *string

	// Contains information about the Amazon Inspector free trial for an account.
	//
	// This member is required.
	FreeTrialInfo []FreeTrialInfo

	noSmithyDocumentSerde
}

// An object that contains information about the Amazon Inspector free trial for an
// account.
type FreeTrialInfo struct {

	// The date and time that the Amazon Inspector free trail ends for a given account.
	//
	// This member is required.
	End *time.Time

	// The date and time that the Amazon Inspector free trail started for a given
	// account.
	//
	// This member is required.
	Start *time.Time

	// The order to sort results by.
	//
	// This member is required.
	Status FreeTrialStatus

	// The type of scan covered by the Amazon Inspector free trail.
	//
	// This member is required.
	Type FreeTrialType

	noSmithyDocumentSerde
}

// Information about an error received while accessing free trail data for an
// account.
type FreeTrialInfoError struct {

	// The account associated with the Amazon Inspector free trial information.
	//
	// This member is required.
	AccountId *string

	// The error code.
	//
	// This member is required.
	Code FreeTrialInfoErrorCode

	// The error message returned.
	//
	// This member is required.
	Message *string

	noSmithyDocumentSerde
}

// The details that define an aggregation based on container image layers.
type ImageLayerAggregation struct {

	// The hashes associated with the layers.
	LayerHashes []StringFilter

	// The repository associated with the container image hosting the layers.
	Repositories []StringFilter

	// The ID of the container image layer.
	ResourceIds []StringFilter

	// The value to sort results by.
	SortBy ImageLayerSortBy

	// The order to sort results by.
	SortOrder SortOrder

	noSmithyDocumentSerde
}

// A response that contains the results of a finding aggregation by image layer.
type ImageLayerAggregationResponse struct {

	// The ID of the Amazon Web Services account that owns the container image hosting
	// the layer image.
	//
	// This member is required.
	AccountId *string

	// The layer hash.
	//
	// This member is required.
	LayerHash *string

	// The repository the layer resides in.
	//
	// This member is required.
	Repository *string

	// The resource ID of the container image layer.
	//
	// This member is required.
	ResourceId *string

	// An object that represents the count of matched findings per severity.
	SeverityCounts *SeverityCounts

	noSmithyDocumentSerde
}

// Information about the Amazon Inspector score given to a finding.
type InspectorScoreDetails struct {

	// An object that contains details about the CVSS score given to a finding.
	AdjustedCvss *CvssScoreDetails

	noSmithyDocumentSerde
}

// An object that describes details of a map filter.
type MapFilter struct {

	// The operator to use when comparing values in the filter.
	//
	// This member is required.
	Comparison MapComparison

	// The tag key used in the filter.
	//
	// This member is required.
	Key *string

	// The tag value used in the filter.
	Value *string

	noSmithyDocumentSerde
}

// Details on a member account in your organization.
type Member struct {

	// The Amazon Web Services account ID of the member account.
	AccountId *string

	// The Amazon Web Services account ID of the Amazon Inspector delegated
	// administrator for this member account.
	DelegatedAdminAccountId *string

	// The status of the member account.
	RelationshipStatus RelationshipStatus

	// A timestamp showing when the status of this member was last updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Information on the network path associated with a finding.
type NetworkPath struct {

	// The details on the steps in the network path.
	Steps []Step

	noSmithyDocumentSerde
}

// Contains the details of a network reachability finding.
type NetworkReachabilityDetails struct {

	// An object that contains details about a network path associated with a finding.
	//
	// This member is required.
	NetworkPath *NetworkPath

	// An object that contains details about the open port range associated with a
	// finding.
	//
	// This member is required.
	OpenPortRange *PortRange

	// The protocol associated with a finding.
	//
	// This member is required.
	Protocol NetworkProtocol

	noSmithyDocumentSerde
}

// An object that describes the details of a number filter.
type NumberFilter struct {

	// The lowest number to be included in the filter.
	LowerInclusive *float64

	// The highest number to be included in the filter.
	UpperInclusive *float64

	noSmithyDocumentSerde
}

// The details that define an aggregation based on operating system package type.
type PackageAggregation struct {

	// The names of packages to aggregate findings on.
	PackageNames []StringFilter

	// The value to sort results by.
	SortBy PackageSortBy

	// The order to sort results by.
	SortOrder SortOrder

	noSmithyDocumentSerde
}

// A response that contains the results of a finding aggregation by image layer.
type PackageAggregationResponse struct {

	// The name of the operating system package.
	//
	// This member is required.
	PackageName *string

	// The ID of the Amazon Web Services account associated with the findings.
	AccountId *string

	// An object that contains the count of matched findings per severity.
	SeverityCounts *SeverityCounts

	noSmithyDocumentSerde
}

// Contains information on the details of a package filter.
type PackageFilter struct {

	// An object that contains details on the package architecture type to filter on.
	Architecture *StringFilter

	// An object that contains details on the package epoch to filter on.
	Epoch *NumberFilter

	// An object that contains details on the name of the package to filter on.
	Name *StringFilter

	// An object that contains details on the package release to filter on.
	Release *StringFilter

	// An object that contains details on the source layer hash to filter on.
	SourceLayerHash *StringFilter

	// The package version to filter on.
	Version *StringFilter

	noSmithyDocumentSerde
}

// Information about a package vulnerability finding.
type PackageVulnerabilityDetails struct {

	// The source of the vulnerability information.
	//
	// This member is required.
	Source *string

	// The ID given to this vulnerability.
	//
	// This member is required.
	VulnerabilityId *string

	// The packages impacted by this vulnerability.
	//
	// This member is required.
	VulnerablePackages []VulnerablePackage

	// An object that contains details about the CVSS score of a finding.
	Cvss []CvssScore

	// One or more URLs that contain details about this vulnerability type.
	ReferenceUrls []string

	// One or more vulnerabilities related to the one identified in this finding.
	RelatedVulnerabilities []string

	// A URL to the source of the vulnerability information.
	SourceUrl *string

	// The date and time that this vulnerability was first added to the vendor's
	// database.
	VendorCreatedAt *time.Time

	// The severity the vendor has given to this vulnerability type.
	VendorSeverity *string

	// The date and time the vendor last updated this vulnerability in their database.
	VendorUpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Contains information on the permissions an account has within Amazon Inspector.
type Permission struct {

	// The operations that can be performed with the given permissions.
	//
	// This member is required.
	Operation Operation

	// The services that the permissions allow an account to perform the given
	// operations for.
	//
	// This member is required.
	Service Service

	noSmithyDocumentSerde
}

// Details about the port range associated with a finding.
type PortRange struct {

	// The beginning port in a port range.
	//
	// This member is required.
	Begin *int32

	// The ending port in a port range.
	//
	// This member is required.
	End *int32

	noSmithyDocumentSerde
}

// An object that describes the details of a port range filter.
type PortRangeFilter struct {

	// The port number the port range begins at.
	BeginInclusive *int32

	// The port number the port range ends at.
	EndInclusive *int32

	noSmithyDocumentSerde
}

// Details about the recommended course of action to remediate the finding.
type Recommendation struct {

	// The recommended course of action to remediate the finding.
	Text *string

	// The URL address to the CVE remediation recommendations.
	Url *string

	noSmithyDocumentSerde
}

// Information on how to remediate a finding.
type Remediation struct {

	// An object that contains information about the recommended course of action to
	// remediate the finding.
	Recommendation *Recommendation

	noSmithyDocumentSerde
}

// The details that define an aggregation based on repository.
type RepositoryAggregation struct {

	// The names of repositories to aggregate findings on.
	Repositories []StringFilter

	// The value to sort results by.
	SortBy RepositorySortBy

	// The order to sort results by.
	SortOrder SortOrder

	noSmithyDocumentSerde
}

// A response that contains details on the results of a finding aggregation by
// repository.
type RepositoryAggregationResponse struct {

	// The name of the repository associated with the findings.
	//
	// This member is required.
	Repository *string

	// The ID of the Amazon Web Services account associated with the findings.
	AccountId *string

	// The number of container images impacted by the findings.
	AffectedImages *int64

	// An object that represent the count of matched findings per severity.
	SeverityCounts *SeverityCounts

	noSmithyDocumentSerde
}

// Details about the resource involved in a finding.
type Resource struct {

	// The ID of the resource.
	//
	// This member is required.
	Id *string

	// The type of resource.
	//
	// This member is required.
	Type ResourceType

	// An object that contains details about the resource involved in a finding.
	Details *ResourceDetails

	// The partition of the resource.
	Partition *string

	// The Amazon Web Services Region the impacted resource is located in.
	Region *string

	// The tags attached to the resource.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Contains details about the resource involved in the finding.
type ResourceDetails struct {

	// An object that contains details about the Amazon EC2 instance involved in the
	// finding.
	AwsEc2Instance *AwsEc2InstanceDetails

	// An object that contains details about the Amazon ECR container image involved in
	// the finding.
	AwsEcrContainerImage *AwsEcrContainerImageDetails

	noSmithyDocumentSerde
}

// An object that contains details about the metadata for an Amazon ECR resource.
type ResourceScanMetadata struct {

	// An object that contains metadata details for an Amazon EC2 instance.
	Ec2 *Ec2Metadata

	// An object that contains details about the container metadata for an Amazon ECR
	// image.
	EcrImage *EcrContainerImageMetadata

	// An object that contains details about the repository an Amazon ECR image resides
	// in.
	EcrRepository *EcrRepositoryMetadata

	noSmithyDocumentSerde
}

// Details the state of Amazon Inspector for each resource type Amazon Inspector
// scans.
type ResourceState struct {

	// An object detailing the state of Amazon Inspector scanning for Amazon EC2
	// resources.
	//
	// This member is required.
	Ec2 *State

	// An object detailing the state of Amazon Inspector scanning for Amazon ECR
	// resources.
	//
	// This member is required.
	Ecr *State

	noSmithyDocumentSerde
}

// Details the status of Amazon Inspector for each resource type Amazon Inspector
// scans.
type ResourceStatus struct {

	// The status of Amazon Inspector scanning for Amazon EC2 resources.
	//
	// This member is required.
	Ec2 Status

	// The status of Amazon Inspector scanning for Amazon ECR resources.
	//
	// This member is required.
	Ecr Status

	noSmithyDocumentSerde
}

// The status of the scan.
type ScanStatus struct {

	// The reason for the scan.
	//
	// This member is required.
	Reason ScanStatusReason

	// The status code of the scan.
	//
	// This member is required.
	StatusCode ScanStatusCode

	noSmithyDocumentSerde
}

// An object that contains the counts of aggregated finding per severity.
type SeverityCounts struct {

	// The total count of findings from all severities.
	All *int64

	// The total count of critical severity findings.
	Critical *int64

	// The total count of high severity findings.
	High *int64

	// The total count of medium severity findings.
	Medium *int64

	noSmithyDocumentSerde
}

// Details about the criteria used to sort finding results.
type SortCriteria struct {

	// The finding detail field by which results are sorted.
	//
	// This member is required.
	Field SortField

	// The order by which findings are sorted.
	//
	// This member is required.
	SortOrder SortOrder

	noSmithyDocumentSerde
}

// An object that described the state of Amazon Inspector scans for an account.
type State struct {

	// The error code explaining why the account failed to enable Amazon Inspector.
	//
	// This member is required.
	ErrorCode ErrorCode

	// The error message received when the account failed to enable Amazon Inspector.
	//
	// This member is required.
	ErrorMessage *string

	// The status of Amazon Inspector for the account.
	//
	// This member is required.
	Status Status

	noSmithyDocumentSerde
}

// Details about the step associated with a finding.
type Step struct {

	// The component ID.
	//
	// This member is required.
	ComponentId *string

	// The component type.
	//
	// This member is required.
	ComponentType *string

	noSmithyDocumentSerde
}

// An object that describes the details of a string filter.
type StringFilter struct {

	// The operator to use when comparing values in the filter
	//
	// This member is required.
	Comparison StringComparison

	// The value to filter on.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// The details that define an aggregation based on finding title.
type TitleAggregation struct {

	// The resource type to aggregate on.
	ResourceType AggregationResourceType

	// The value to sort results by.
	SortBy TitleSortBy

	// The order to sort results by.
	SortOrder SortOrder

	// The finding titles to aggregate on.
	Titles []StringFilter

	// The vulnerability IDs of the findings.
	VulnerabilityIds []StringFilter

	noSmithyDocumentSerde
}

// A response that contains details on the results of a finding aggregation by
// title.
type TitleAggregationResponse struct {

	// The title that the findings were aggregated on.
	//
	// This member is required.
	Title *string

	// The ID of the Amazon Web Services account associated with the findings.
	AccountId *string

	// An object that represent the count of matched findings per severity.
	SeverityCounts *SeverityCounts

	// The vulnerability ID of the finding.
	VulnerabilityId *string

	noSmithyDocumentSerde
}

// Contains usage information about the cost of Amazon Inspector operation.
type Usage struct {

	// The currency type used when calculating usage data.
	Currency Currency

	// The estimated monthly cost of Amazon Inspector.
	EstimatedMonthlyCost float64

	// The total of usage.
	Total float64

	// The type scan.
	Type UsageType

	noSmithyDocumentSerde
}

// The total of usage for an account ID.
type UsageTotal struct {

	// The account ID of the account that usage data was retrieved for.
	AccountId *string

	// An object representing the total usage for an account.
	Usage []Usage

	noSmithyDocumentSerde
}

// An object that describes a validation exception.
type ValidationExceptionField struct {

	// The validation exception message.
	//
	// This member is required.
	Message *string

	// The name of the validation exception.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Information on the vulnerable package identified by a finding.
type VulnerablePackage struct {

	// The name of the vulnerable package.
	//
	// This member is required.
	Name *string

	// The version of the vulnerable package.
	//
	// This member is required.
	Version *string

	// The architecture of the vulnerable package.
	Arch *string

	// The epoch of the vulnerable package.
	Epoch int32

	// The file path of the vulnerable package.
	FilePath *string

	// The version of the package that contains the vulnerability fix.
	FixedInVersion *string

	// The package manager of the vulnerable package.
	PackageManager PackageManager

	// The release of the vulnerable package.
	Release *string

	// The source layer hash of the vulnerable package.
	SourceLayerHash *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isAggregationRequest()  {}
func (*UnknownUnionMember) isAggregationResponse() {}
