// Code generated by smithy-go-codegen DO NOT EDIT.

package guardduty

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/guardduty/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a filter using the specified finding criteria.
func (c *Client) CreateFilter(ctx context.Context, params *CreateFilterInput, optFns ...func(*Options)) (*CreateFilterOutput, error) {
	if params == nil {
		params = &CreateFilterInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateFilter", params, optFns, c.addOperationCreateFilterMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateFilterOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateFilterInput struct {

	// The ID of the detector belonging to the GuardDuty account that you want to
	// create a filter for.
	//
	// This member is required.
	DetectorId *string

	// Represents the criteria to be used in the filter for querying findings. You can
	// only use the following attributes to query findings:
	//
	// * accountId
	//
	// * region
	//
	// *
	// confidence
	//
	// * id
	//
	// * resource.accessKeyDetails.accessKeyId
	//
	// *
	// resource.accessKeyDetails.principalId
	//
	// * resource.accessKeyDetails.userName
	//
	// *
	// resource.accessKeyDetails.userType
	//
	// *
	// resource.instanceDetails.iamInstanceProfile.id
	//
	// *
	// resource.instanceDetails.imageId
	//
	// * resource.instanceDetails.instanceId
	//
	// *
	// resource.instanceDetails.outpostArn
	//
	// *
	// resource.instanceDetails.networkInterfaces.ipv6Addresses
	//
	// *
	// resource.instanceDetails.networkInterfaces.privateIpAddresses.privateIpAddress
	//
	// *
	// resource.instanceDetails.networkInterfaces.publicDnsName
	//
	// *
	// resource.instanceDetails.networkInterfaces.publicIp
	//
	// *
	// resource.instanceDetails.networkInterfaces.securityGroups.groupId
	//
	// *
	// resource.instanceDetails.networkInterfaces.securityGroups.groupName
	//
	// *
	// resource.instanceDetails.networkInterfaces.subnetId
	//
	// *
	// resource.instanceDetails.networkInterfaces.vpcId
	//
	// *
	// resource.instanceDetails.tags.key
	//
	// * resource.instanceDetails.tags.value
	//
	// *
	// resource.resourceType
	//
	// * service.action.actionType
	//
	// *
	// service.action.awsApiCallAction.api
	//
	// *
	// service.action.awsApiCallAction.callerType
	//
	// *
	// service.action.awsApiCallAction.errorCode
	//
	// *
	// service.action.awsApiCallAction.remoteIpDetails.city.cityName
	//
	// *
	// service.action.awsApiCallAction.remoteIpDetails.country.countryName
	//
	// *
	// service.action.awsApiCallAction.remoteIpDetails.ipAddressV4
	//
	// *
	// service.action.awsApiCallAction.remoteIpDetails.organization.asn
	//
	// *
	// service.action.awsApiCallAction.remoteIpDetails.organization.asnOrg
	//
	// *
	// service.action.awsApiCallAction.serviceName
	//
	// *
	// service.action.dnsRequestAction.domain
	//
	// *
	// service.action.networkConnectionAction.blocked
	//
	// *
	// service.action.networkConnectionAction.connectionDirection
	//
	// *
	// service.action.networkConnectionAction.localPortDetails.port
	//
	// *
	// service.action.networkConnectionAction.protocol
	//
	// *
	// service.action.networkConnectionAction.localIpDetails.ipAddressV4
	//
	// *
	// service.action.networkConnectionAction.remoteIpDetails.city.cityName
	//
	// *
	// service.action.networkConnectionAction.remoteIpDetails.country.countryName
	//
	// *
	// service.action.networkConnectionAction.remoteIpDetails.ipAddressV4
	//
	// *
	// service.action.networkConnectionAction.remoteIpDetails.organization.asn
	//
	// *
	// service.action.networkConnectionAction.remoteIpDetails.organization.asnOrg
	//
	// *
	// service.action.networkConnectionAction.remotePortDetails.port
	//
	// *
	// service.additionalInfo.threatListName
	//
	// * service.archived When this attribute is
	// set to TRUE, only archived findings are listed. When it's set to FALSE, only
	// unarchived findings are listed. When this attribute is not set, all existing
	// findings are listed.
	//
	// * service.resourceRole
	//
	// * severity
	//
	// * type
	//
	// * updatedAt
	// Type: ISO 8601 string format: YYYY-MM-DDTHH:MM:SS.SSSZ or YYYY-MM-DDTHH:MM:SSZ
	// depending on whether the value contains milliseconds.
	//
	// This member is required.
	FindingCriteria *types.FindingCriteria

	// The name of the filter. Minimum length of 3. Maximum length of 64. Valid
	// characters include alphanumeric characters, dot (.), underscore (_), and dash
	// (-). Spaces are not allowed.
	//
	// This member is required.
	Name *string

	// Specifies the action that is to be applied to the findings that match the
	// filter.
	Action types.FilterAction

	// The idempotency token for the create request.
	ClientToken *string

	// The description of the filter.
	Description *string

	// Specifies the position of the filter in the list of current filters. Also
	// specifies the order in which this filter is applied to the findings.
	Rank int32

	// The tags to be added to a new filter resource.
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateFilterOutput struct {

	// The name of the successfully created filter.
	//
	// This member is required.
	Name *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateFilterMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateFilter{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateFilter{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateFilterMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateFilterValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateFilter(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateFilter struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateFilter) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateFilter) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateFilterInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateFilterInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateFilterMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateFilter{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateFilter(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "guardduty",
		OperationName: "CreateFilter",
	}
}
