// Code generated by smithy-go-codegen DO NOT EDIT.

package evidently

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/evidently/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// This operation assigns a feature variation to one given user session. You pass
// in an entityID that represents the user. Evidently then checks the evaluation
// rules and assigns the variation. The first rules that are evaluated are the
// override rules. If the user's entityID matches an override rule, the user is
// served the variation specified by that rule. Next, if there is a launch of the
// feature, the user might be assigned to a variation in the launch. The chance of
// this depends on the percentage of users that are allocated to that launch. If
// the user is enrolled in the launch, the variation they are served depends on the
// allocation of the various feature variations used for the launch. If the user is
// not assigned to a launch, and there is an ongoing experiment for this feature,
// the user might be assigned to a variation in the experiment. The chance of this
// depends on the percentage of users that are allocated to that experiment. If the
// user is enrolled in the experiment, the variation they are served depends on the
// allocation of the various feature variations used for the experiment. If the
// user is not assigned to a launch or experiment, they are served the default
// variation.
func (c *Client) EvaluateFeature(ctx context.Context, params *EvaluateFeatureInput, optFns ...func(*Options)) (*EvaluateFeatureOutput, error) {
	if params == nil {
		params = &EvaluateFeatureInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "EvaluateFeature", params, optFns, c.addOperationEvaluateFeatureMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*EvaluateFeatureOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type EvaluateFeatureInput struct {

	// An internal ID that represents a unique user of the application. This entityID
	// is checked against any override rules assigned for this feature.
	//
	// This member is required.
	EntityId *string

	// The name of the feature being evaluated.
	//
	// This member is required.
	Feature *string

	// The name or ARN of the project that contains this feature.
	//
	// This member is required.
	Project *string

	// A JSON block of attributes that you can optionally pass in. This JSON block is
	// included in the evaluation events sent to Evidently from the user session.
	//
	// This value conforms to the media type: application/json
	EvaluationContext *string

	noSmithyDocumentSerde
}

type EvaluateFeatureOutput struct {

	// If this user was assigned to a launch or experiment, this field lists the launch
	// or experiment name.
	//
	// This value conforms to the media type: application/json
	Details *string

	// Specifies the reason that the user session was assigned this variation. Possible
	// values include DEFAULT, meaning the user was served the default variation;
	// LAUNCH_RULE_MATCH, if the user session was enrolled in a launch;
	// EXPERIMENT_RULE_MATCH, if the user session was enrolled in an experiment; or
	// ENTITY_OVERRIDES_MATCH, if the user's entityId matches an override rule.
	Reason *string

	// The value assigned to this variation to differentiate it from the other
	// variations of this feature.
	Value types.VariableValue

	// The name of the variation that was served to the user session.
	Variation *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationEvaluateFeatureMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpEvaluateFeature{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpEvaluateFeature{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addEndpointPrefix_opEvaluateFeatureMiddleware(stack); err != nil {
		return err
	}
	if err = addOpEvaluateFeatureValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opEvaluateFeature(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

type endpointPrefix_opEvaluateFeatureMiddleware struct {
}

func (*endpointPrefix_opEvaluateFeatureMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opEvaluateFeatureMiddleware) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleSerialize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	req.URL.Host = "dataplane." + req.URL.Host

	return next.HandleSerialize(ctx, in)
}
func addEndpointPrefix_opEvaluateFeatureMiddleware(stack *middleware.Stack) error {
	return stack.Serialize.Insert(&endpointPrefix_opEvaluateFeatureMiddleware{}, `OperationSerializer`, middleware.After)
}

func newServiceMetadataMiddleware_opEvaluateFeature(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "evidently",
		OperationName: "EvaluateFeature",
	}
}
