// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Returns the number of open reactive insights, the number of open proactive
// insights, and the number of metrics analyzed in your Amazon Web Services
// account. Use these numbers to gauge the health of operations in your Amazon Web
// Services account.
type AccountHealth struct {

	// The ID of the Amazon Web Services account.
	AccountId *string

	// Information about the health of the Amazon Web Services resources in your
	// account, including the number of open proactive, open reactive insights, and the
	// Mean Time to Recover (MTTR) of closed insights.
	Insight *AccountInsightHealth

	noSmithyDocumentSerde
}

// Information about the number of open reactive and proactive insights that can be
// used to gauge the health of your system.
type AccountInsightHealth struct {

	// An integer that specifies the number of open proactive insights in your Amazon
	// Web Services account.
	OpenProactiveInsights int32

	// An integer that specifies the number of open reactive insights in your Amazon
	// Web Services account.
	OpenReactiveInsights int32

	noSmithyDocumentSerde
}

// A time range that specifies when DevOps Guru opens and then closes an anomaly.
// This is different from AnomalyTimeRange, which specifies the time range when
// DevOps Guru actually observes the anomalous behavior.
type AnomalyReportedTimeRange struct {

	// The time when an anomaly is opened.
	//
	// This member is required.
	OpenTime *time.Time

	// The time when an anomaly is closed.
	CloseTime *time.Time

	noSmithyDocumentSerde
}

// The Amazon Web Services resources in which DevOps Guru detected unusual behavior
// that resulted in the generation of an anomaly. When DevOps Guru detects multiple
// related anomalies, it creates and insight with details about the anomalous
// behavior and suggestions about how to correct the problem.
type AnomalyResource struct {

	// The name of the Amazon Web Services resource.
	Name *string

	// The type of the Amazon Web Services resource.
	Type *string

	noSmithyDocumentSerde
}

// Details about the source of the anomalous operational data that triggered the
// anomaly.
type AnomalySourceDetails struct {

	// An array of CloudWatchMetricsDetail objects that contain information about
	// analyzed CloudWatch metrics that show anomalous behavior.
	CloudWatchMetrics []CloudWatchMetricsDetail

	// An array of PerformanceInsightsMetricsDetail objects that contain information
	// about analyzed Performance Insights metrics that show anomalous behavior.
	PerformanceInsightsMetrics []PerformanceInsightsMetricsDetail

	noSmithyDocumentSerde
}

// A time range that specifies when the observed unusual behavior in an anomaly
// started and ended. This is different from AnomalyReportedTimeRange, which
// specifies the time range when DevOps Guru opens and then closes an anomaly.
type AnomalyTimeRange struct {

	// The time when the anomalous behavior started.
	//
	// This member is required.
	StartTime *time.Time

	// The time when the anomalous behavior ended.
	EndTime *time.Time

	noSmithyDocumentSerde
}

// Information about Amazon Web Services CloudFormation stacks. You can use up to
// 500 stacks to specify which Amazon Web Services resources in your account to
// analyze. For more information, see Stacks
// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html) in
// the Amazon Web Services CloudFormation User Guide.
type CloudFormationCollection struct {

	// An array of CloudFormation stack names.
	StackNames []string

	noSmithyDocumentSerde
}

// Information about Amazon Web Services CloudFormation stacks. You can use up to
// 500 stacks to specify which Amazon Web Services resources in your account to
// analyze. For more information, see Stacks
// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html) in
// the Amazon Web Services CloudFormation User Guide.
type CloudFormationCollectionFilter struct {

	// An array of CloudFormation stack names.
	StackNames []string

	noSmithyDocumentSerde
}

// Information about an Amazon Web Services CloudFormation stack used to create a
// monthly cost estimate for DevOps Guru to analyze Amazon Web Services resources.
// The maximum number of stacks you can specify for a cost estimate is one. The
// estimate created is for the cost to analyze the Amazon Web Services resources
// defined by the stack. For more information, see Stacks
// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html) in
// the Amazon Web Services CloudFormation User Guide.
type CloudFormationCostEstimationResourceCollectionFilter struct {

	// An array of CloudFormation stack names. Its size is fixed at 1 item.
	StackNames []string

	noSmithyDocumentSerde
}

// Information about the health of Amazon Web Services resources in your account
// that are specified by an Amazon Web Services CloudFormation stack.
type CloudFormationHealth struct {

	// Information about the health of the Amazon Web Services resources in your
	// account that are specified by an Amazon Web Services CloudFormation stack,
	// including the number of open proactive, open reactive insights, and the Mean
	// Time to Recover (MTTR) of closed insights.
	Insight *InsightHealth

	// The name of the CloudFormation stack.
	StackName *string

	noSmithyDocumentSerde
}

// Contains information about the analyzed metrics that displayed anomalous
// behavior.
type CloudWatchMetricsDataSummary struct {

	// This is an enum of the status showing whether the metric value pair list has
	// partial or complete data, or if there was an error.
	StatusCode CloudWatchMetricDataStatusCode

	// This is a list of Amazon CloudWatch metric values at given timestamp.
	TimestampMetricValuePairList []TimestampMetricValuePair

	noSmithyDocumentSerde
}

// Information about an Amazon CloudWatch metric.
type CloudWatchMetricsDetail struct {

	// An array of CloudWatch dimensions associated with
	Dimensions []CloudWatchMetricsDimension

	// This object returns anomaly metric data.
	MetricDataSummary *CloudWatchMetricsDataSummary

	// The name of the CloudWatch metric.
	MetricName *string

	// The namespace of the CloudWatch metric. A namespace is a container for
	// CloudWatch metrics.
	Namespace *string

	// The length of time associated with the CloudWatch metric in number of seconds.
	Period int32

	// The type of statistic associated with the CloudWatch metric. For more
	// information, see Statistics
	// (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic)
	// in the Amazon CloudWatch User Guide.
	Stat CloudWatchMetricsStat

	// The unit of measure used for the CloudWatch metric. For example, Bytes, Seconds,
	// Count, and Percent.
	Unit *string

	noSmithyDocumentSerde
}

// The dimension of am Amazon CloudWatch metric that is used when DevOps Guru
// analyzes the resources in your account for operational problems and anomalous
// behavior. A dimension is a name/value pair that is part of the identity of a
// metric. A metric can have up to 10 dimensions. For more information, see
// Dimensions
// (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Dimension)
// in the Amazon CloudWatch User Guide.
type CloudWatchMetricsDimension struct {

	// The name of the CloudWatch dimension.
	Name *string

	// The value of the CloudWatch dimension.
	Value *string

	noSmithyDocumentSerde
}

// Information about a filter used to specify which Amazon Web Services resources
// are analyzed to create a monthly DevOps Guru cost estimate. For more
// information, see Estimate your Amazon DevOps Guru costs
// (https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html)
// and Amazon DevOps Guru pricing (http://aws.amazon.com/devops-guru/pricing/).
type CostEstimationResourceCollectionFilter struct {

	// An object that specifies the CloudFormation stack that defines the Amazon Web
	// Services resources used to create a monthly estimate for DevOps Guru.
	CloudFormation *CloudFormationCostEstimationResourceCollectionFilter

	// The Amazon Web Services tags used to filter the resource collection that is used
	// for a cost estimate. Tags help you identify and organize your Amazon Web
	// Services resources. Many Amazon Web Services services support tagging, so you
	// can assign the same tag to resources from different services to indicate that
	// the resources are related. For example, you can assign the same tag to an Amazon
	// DynamoDB table resource that you assign to an Lambda function. For more
	// information about using tags, see the Tagging best practices
	// (https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf)
	// whitepaper. Each Amazon Web Services tag has two parts.
	//
	// * A tag key (for
	// example, CostCenter, Environment, Project, or Secret). Tag keys are
	// case-sensitive.
	//
	// * An optional field known as a tag value (for example,
	// 111122223333, Production, or a team name). Omitting the tag value is the same as
	// using an empty string. Like tag keys, tag values are case-sensitive.
	//
	// Together
	// these are known as key-value pairs. The string used for a key in a tag that you
	// use to define your resource coverage must begin with the prefix Devops-guru-.
	// The tag key might be Devops-guru-deployment-application or
	// Devops-guru-rds-application. While keys are case-sensitive, the case of key
	// characters don't matter to DevOps Guru. For example, DevOps Guru works with a
	// key named devops-guru-rds and a key named DevOps-Guru-RDS. Possible key/value
	// pairs in your application might be Devops-Guru-production-application/RDS or
	// Devops-Guru-production-application/containers.
	Tags []TagCostEstimationResourceCollectionFilter

	noSmithyDocumentSerde
}

// The time range of a cost estimation.
type CostEstimationTimeRange struct {

	// The end time of the cost estimation.
	EndTime *time.Time

	// The start time of the cost estimation.
	StartTime *time.Time

	noSmithyDocumentSerde
}

// A range of time that specifies when anomalous behavior in an anomaly or insight
// ended.
type EndTimeRange struct {

	// The earliest end time in the time range.
	FromTime *time.Time

	// The latest end time in the time range.
	ToTime *time.Time

	noSmithyDocumentSerde
}

// An Amazon Web Services resource event. Amazon Web Services resource events and
// metrics are analyzed by DevOps Guru to find anomalous behavior and provide
// recommendations to improve your operational solutions.
type Event struct {

	// The source, AWS_CLOUD_TRAIL or AWS_CODE_DEPLOY, where DevOps Guru analysis found
	// the event.
	DataSource EventDataSource

	// The class of the event. The class specifies what the event is related to, such
	// as an infrastructure change, a deployment, or a schema change.
	EventClass EventClass

	// The Amazon Web Services source that emitted the event.
	EventSource *string

	// The ID of the event.
	Id *string

	// The name of the event.
	Name *string

	// A collection of Amazon Web Services resources supported by DevOps Guru. The two
	// types of Amazon Web Services resource collections supported are Amazon Web
	// Services CloudFormation stacks and Amazon Web Services resources that contain
	// the same Amazon Web Services tag. DevOps Guru can be configured to analyze the
	// Amazon Web Services resources that are defined in the stacks or that are tagged
	// using the same tag key. You can specify up to 500 Amazon Web Services
	// CloudFormation stacks.
	ResourceCollection *ResourceCollection

	// An EventResource object that contains information about the resource that
	// emitted the event.
	Resources []EventResource

	// A Timestamp that specifies the time the event occurred.
	Time *time.Time

	noSmithyDocumentSerde
}

// The Amazon Web Services resource that emitted an event. Amazon Web Services
// resource events and metrics are analyzed by DevOps Guru to find anomalous
// behavior and provide recommendations to improve your operational solutions.
type EventResource struct {

	// The Amazon Resource Name (ARN) of the resource that emitted an event.
	Arn *string

	// The name of the resource that emitted an event.
	Name *string

	// The type of resource that emitted an event.
	Type *string

	noSmithyDocumentSerde
}

// The time range during which an Amazon Web Services event occurred. Amazon Web
// Services resource events and metrics are analyzed by DevOps Guru to find
// anomalous behavior and provide recommendations to improve your operational
// solutions.
type EventTimeRange struct {

	// The time when the event started.
	//
	// This member is required.
	FromTime *time.Time

	// The time when the event ended.
	//
	// This member is required.
	ToTime *time.Time

	noSmithyDocumentSerde
}

// Information about insight feedback received from a customer.
type InsightFeedback struct {

	// The feedback provided by the customer.
	Feedback InsightFeedbackOption

	// The insight feedback ID.
	Id *string

	noSmithyDocumentSerde
}

// Information about the number of open reactive and proactive insights that can be
// used to gauge the health of your system.
type InsightHealth struct {

	// The Meant Time to Recover (MTTR) for the insight.
	MeanTimeToRecoverInMilliseconds *int64

	// The number of open proactive insights.
	OpenProactiveInsights int32

	// The number of open reactive insights.
	OpenReactiveInsights int32

	noSmithyDocumentSerde
}

// A time ranged that specifies when the observed behavior in an insight started
// and ended.
type InsightTimeRange struct {

	// The time when the behavior described in an insight started.
	//
	// This member is required.
	StartTime *time.Time

	// The time when the behavior described in an insight ended.
	EndTime *time.Time

	noSmithyDocumentSerde
}

// Filters you can use to specify which events are returned when ListEvents is
// called.
type ListEventsFilters struct {

	// The source, AWS_CLOUD_TRAIL or AWS_CODE_DEPLOY, of the events you want returned.
	DataSource EventDataSource

	// The class of the events you want to filter for, such as an infrastructure
	// change, a deployment, or a schema change.
	EventClass EventClass

	// The Amazon Web Services source that emitted the events you want to filter for.
	EventSource *string

	// A time range during which you want the filtered events to have occurred.
	EventTimeRange *EventTimeRange

	// An ID of an insight that is related to the events you want to filter for.
	InsightId *string

	// A collection of Amazon Web Services resources supported by DevOps Guru. The two
	// types of Amazon Web Services resource collections supported are Amazon Web
	// Services CloudFormation stacks and Amazon Web Services resources that contain
	// the same Amazon Web Services tag. DevOps Guru can be configured to analyze the
	// Amazon Web Services resources that are defined in the stacks or that are tagged
	// using the same tag key. You can specify up to 500 Amazon Web Services
	// CloudFormation stacks.
	ResourceCollection *ResourceCollection

	noSmithyDocumentSerde
}

// Used to filter for insights that have any status.
type ListInsightsAnyStatusFilter struct {

	// A time range used to specify when the behavior of the filtered insights started.
	//
	// This member is required.
	StartTimeRange *StartTimeRange

	// Use to filter for either REACTIVE or PROACTIVE insights.
	//
	// This member is required.
	Type InsightType

	noSmithyDocumentSerde
}

// Used to filter for insights that have the status CLOSED.
type ListInsightsClosedStatusFilter struct {

	// A time range used to specify when the behavior of the filtered insights ended.
	//
	// This member is required.
	EndTimeRange *EndTimeRange

	// Use to filter for either REACTIVE or PROACTIVE insights.
	//
	// This member is required.
	Type InsightType

	noSmithyDocumentSerde
}

// Used to filter for insights that have the status ONGOING.
type ListInsightsOngoingStatusFilter struct {

	// Use to filter for either REACTIVE or PROACTIVE insights.
	//
	// This member is required.
	Type InsightType

	noSmithyDocumentSerde
}

// A filter used by ListInsights to specify which insights to return.
type ListInsightsStatusFilter struct {

	// A ListInsightsAnyStatusFilter that specifies insights of any status that are
	// either REACTIVE or PROACTIVE.
	Any *ListInsightsAnyStatusFilter

	// A ListInsightsClosedStatusFilter that specifies closed insights that are either
	// REACTIVE or PROACTIVE.
	Closed *ListInsightsClosedStatusFilter

	// A ListInsightsAnyStatusFilter that specifies ongoing insights that are either
	// REACTIVE or PROACTIVE.
	Ongoing *ListInsightsOngoingStatusFilter

	noSmithyDocumentSerde
}

// Information about a notification channel. A notification channel is used to
// notify you when DevOps Guru creates an insight. The one supported notification
// channel is Amazon Simple Notification Service (Amazon SNS). If you use an Amazon
// SNS topic in another account, you must attach a policy to it that grants DevOps
// Guru permission to it notifications. DevOps Guru adds the required policy on
// your behalf to send notifications using Amazon SNS in your account. For more
// information, see Permissions for cross account Amazon SNS topics
// (https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html).
// If you use an Amazon SNS topic that is encrypted by an Amazon Web Services Key
// Management Service customer-managed key (CMK), then you must add permissions to
// the CMK. For more information, see Permissions for Amazon Web Services
// KMS–encrypted Amazon SNS topics
// (https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html).
type NotificationChannel struct {

	// A NotificationChannelConfig object that contains information about configured
	// notification channels.
	Config *NotificationChannelConfig

	// The ID of a notification channel.
	Id *string

	noSmithyDocumentSerde
}

// Information about notification channels you have configured with DevOps Guru.
// The one supported notification channel is Amazon Simple Notification Service
// (Amazon SNS).
type NotificationChannelConfig struct {

	// Information about a notification channel configured in DevOps Guru to send
	// notifications when insights are created. If you use an Amazon SNS topic in
	// another account, you must attach a policy to it that grants DevOps Guru
	// permission to it notifications. DevOps Guru adds the required policy on your
	// behalf to send notifications using Amazon SNS in your account. For more
	// information, see Permissions for cross account Amazon SNS topics
	// (https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html).
	// If you use an Amazon SNS topic that is encrypted by an Amazon Web Services Key
	// Management Service customer-managed key (CMK), then you must add permissions to
	// the CMK. For more information, see Permissions for Amazon Web Services
	// KMS–encrypted Amazon SNS topics
	// (https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html).
	//
	// This member is required.
	Sns *SnsChannelConfig

	noSmithyDocumentSerde
}

// Information about whether DevOps Guru is configured to create an OpsItem in
// Amazon Web Services Systems Manager OpsCenter for each created insight.
type OpsCenterIntegration struct {

	// Specifies if DevOps Guru is enabled to create an Amazon Web Services Systems
	// Manager OpsItem for each created insight.
	OptInStatus OptInStatus

	noSmithyDocumentSerde
}

// Information about whether DevOps Guru is configured to create an OpsItem in
// Amazon Web Services Systems Manager OpsCenter for each created insight.
type OpsCenterIntegrationConfig struct {

	// Specifies if DevOps Guru is enabled to create an Amazon Web Services Systems
	// Manager OpsItem for each created insight.
	OptInStatus OptInStatus

	noSmithyDocumentSerde
}

// A logical grouping of Performance Insights metrics for a related subject area.
// For example, the db.sql dimension group consists of the following dimensions:
// db.sql.id, db.sql.db_id, db.sql.statement, and db.sql.tokenized_id. Each
// response element returns a maximum of 500 bytes. For larger elements, such as
// SQL statements, only the first 500 bytes are returned. Amazon RDS Performance
// Insights enables you to monitor and explore different dimensions of database
// load based on data captured from a running DB instance. DB load is measured as
// average active sessions. Performance Insights provides the data to API consumers
// as a two-dimensional time-series dataset. The time dimension provides DB load
// data for each time point in the queried time range. Each time point decomposes
// overall load in relation to the requested dimensions, measured at that time
// point. Examples include SQL, Wait event, User, and Host.
//
// * To learn more about
// Performance Insights and Amazon Aurora DB instances, go to the  Amazon Aurora
// User Guide
// (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_PerfInsights.html).
//
// *
// To learn more about Performance Insights and Amazon RDS DB instances, go to the
// Amazon RDS User Guide
// (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html).
type PerformanceInsightsMetricDimensionGroup struct {

	// A list of specific dimensions from a dimension group. If this parameter is not
	// present, then it signifies that all of the dimensions in the group were
	// requested or are present in the response. Valid values for elements in the
	// Dimensions array are:
	//
	// * db.application.name - The name of the application that
	// is connected to the database (only Aurora PostgreSQL and RDS PostgreSQL)
	//
	// *
	// db.host.id - The host ID of the connected client (all engines)
	//
	// * db.host.name -
	// The host name of the connected client (all engines)
	//
	// * db.name - The name of the
	// database to which the client is connected (only Aurora PostgreSQL, Amazon RDS
	// PostgreSQL, Aurora MySQL, Amazon RDS MySQL, and MariaDB)
	//
	// * db.session_type.name
	// - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL)
	//
	// *
	// db.sql.id - The SQL ID generated by Performance Insights (all engines)
	//
	// *
	// db.sql.db_id - The SQL ID generated by the database (all engines)
	//
	// *
	// db.sql.statement - The SQL text that is being executed (all engines)
	//
	// *
	// db.sql.tokenized_id
	//
	// * db.sql_tokenized.id - The SQL digest ID generated by
	// Performance Insights (all engines)
	//
	// * db.sql_tokenized.db_id - SQL digest ID
	// generated by the database (all engines)
	//
	// * db.sql_tokenized.statement - The SQL
	// digest text (all engines)
	//
	// * db.user.id - The ID of the user logged in to the
	// database (all engines)
	//
	// * db.user.name - The name of the user logged in to the
	// database (all engines)
	//
	// * db.wait_event.name - The event for which the backend
	// is waiting (all engines)
	//
	// * db.wait_event.type - The type of event for which the
	// backend is waiting (all engines)
	//
	// * db.wait_event_type.name - The name of the
	// event type for which the backend is waiting (all engines)
	Dimensions []string

	// The name of the dimension group. Its valid values are:
	//
	// * db - The name of the
	// database to which the client is connected (only Aurora PostgreSQL, Amazon RDS
	// PostgreSQL, Aurora MySQL, Amazon RDS MySQL, and MariaDB)
	//
	// * db.application - The
	// name of the application that is connected to the database (only Aurora
	// PostgreSQL and RDS PostgreSQL)
	//
	// * db.host - The host name of the connected
	// client (all engines)
	//
	// * db.session_type - The type of the current session (only
	// Aurora PostgreSQL and RDS PostgreSQL)
	//
	// * db.sql - The SQL that is currently
	// executing (all engines)
	//
	// * db.sql_tokenized - The SQL digest (all engines)
	//
	// *
	// db.wait_event - The event for which the database backend is waiting (all
	// engines)
	//
	// * db.wait_event_type - The type of event for which the database
	// backend is waiting (all engines)
	//
	// * db.user - The user logged in to the database
	// (all engines)
	Group *string

	// The maximum number of items to fetch for this dimension group.
	Limit *int32

	noSmithyDocumentSerde
}

// A single query to be processed. Use these parameters to query the Performance
// Insights GetResourceMetrics API to retrieve the metrics for an anomaly. For more
// information, see GetResourceMetrics
// (https://docs.aws.amazon.com/performance-insights/latest/APIReference/API_GetResourceMetrics.html)
// in the Amazon RDS Performance Insights API Reference. Amazon RDS Performance
// Insights enables you to monitor and explore different dimensions of database
// load based on data captured from a running DB instance. DB load is measured as
// average active sessions. Performance Insights provides the data to API consumers
// as a two-dimensional time-series dataset. The time dimension provides DB load
// data for each time point in the queried time range. Each time point decomposes
// overall load in relation to the requested dimensions, measured at that time
// point. Examples include SQL, Wait event, User, and Host.
//
// * To learn more about
// Performance Insights and Amazon Aurora DB instances, go to the  Amazon Aurora
// User Guide
// (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_PerfInsights.html).
//
// *
// To learn more about Performance Insights and Amazon RDS DB instances, go to the
// Amazon RDS User Guide
// (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html).
type PerformanceInsightsMetricQuery struct {

	// One or more filters to apply to a Performance Insights GetResourceMetrics API
	// query. Restrictions:
	//
	// * Any number of filters by the same dimension, as
	// specified in the GroupBy parameter.
	//
	// * A single filter for any other dimension
	// in this dimension group.
	Filter map[string]string

	// The specification for how to aggregate the data points from a Performance
	// Insights GetResourceMetrics API query. The Performance Insights query returns
	// all of the dimensions within that group, unless you provide the names of
	// specific dimensions within that group. You can also request that Performance
	// Insights return a limited number of values for a dimension.
	GroupBy *PerformanceInsightsMetricDimensionGroup

	// The name of the meteric used used when querying an Performance Insights
	// GetResourceMetrics API for anomaly metrics. Valid values for Metric are:
	//
	// *
	// db.load.avg - a scaled representation of the number of active sessions for the
	// database engine.
	//
	// * db.sampledload.avg - the raw number of active sessions for
	// the database engine.
	//
	// If the number of active sessions is less than an internal
	// Performance Insights threshold, db.load.avg and db.sampledload.avg are the same
	// value. If the number of active sessions is greater than the internal threshold,
	// Performance Insights samples the active sessions, with db.load.avg showing the
	// scaled values, db.sampledload.avg showing the raw values, and db.sampledload.avg
	// less than db.load.avg. For most use cases, you can query db.load.avg only.
	Metric *string

	noSmithyDocumentSerde
}

// Details about Performance Insights metrics. Amazon RDS Performance Insights
// enables you to monitor and explore different dimensions of database load based
// on data captured from a running DB instance. DB load is measured as average
// active sessions. Performance Insights provides the data to API consumers as a
// two-dimensional time-series dataset. The time dimension provides DB load data
// for each time point in the queried time range. Each time point decomposes
// overall load in relation to the requested dimensions, measured at that time
// point. Examples include SQL, Wait event, User, and Host.
//
// * To learn more about
// Performance Insights and Amazon Aurora DB instances, go to the  Amazon Aurora
// User Guide
// (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_PerfInsights.html).
//
// *
// To learn more about Performance Insights and Amazon RDS DB instances, go to the
// Amazon RDS User Guide
// (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html).
type PerformanceInsightsMetricsDetail struct {

	// The name used for a specific Performance Insights metric.
	MetricDisplayName *string

	// A single query to be processed for the metric. For more information, see
	// PerformanceInsightsMetricQuery
	// (https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_PerformanceInsightsMetricQuery.html).
	MetricQuery *PerformanceInsightsMetricQuery

	// For more information, see PerformanceInsightsReferenceData
	// (https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_PerformanceInsightsReferenceData.html).
	ReferenceData []PerformanceInsightsReferenceData

	// The metric statistics during the anomalous period detected by DevOps Guru;
	StatsAtAnomaly []PerformanceInsightsStat

	// Typical metric statistics that are not considered anomalous. When DevOps Guru
	// analyzes metrics, it compares them to StatsAtBaseline to help determine if they
	// are anomalous.
	StatsAtBaseline []PerformanceInsightsStat

	// The unit of measure for a metric. For example, a session or a process.
	Unit *string

	noSmithyDocumentSerde
}

// Reference scalar values and other metrics that DevOps Guru displays on a graph
// in its console along with the actual metrics it analyzed. Compare these
// reference values to your actual metrics to help you understand anomalous
// behavior that DevOps Guru detected.
type PerformanceInsightsReferenceComparisonValues struct {

	// A metric that DevOps Guru compares to actual metric values. This reference
	// metric is used to determine if an actual metric should be considered anomalous.
	ReferenceMetric *PerformanceInsightsReferenceMetric

	// A scalar value DevOps Guru for a metric that DevOps Guru compares to actual
	// metric values. This reference value is used to determine if an actual metric
	// value should be considered anomalous.
	ReferenceScalar *PerformanceInsightsReferenceScalar

	noSmithyDocumentSerde
}

// Reference data used to evaluate Performance Insights to determine if its
// performance is anomalous or not.
type PerformanceInsightsReferenceData struct {

	// The specific reference values used to evaluate the Performance Insights. For
	// more information, see PerformanceInsightsReferenceComparisonValues
	// (https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_PerformanceInsightsReferenceComparisonValues.html).
	ComparisonValues *PerformanceInsightsReferenceComparisonValues

	// The name of the reference data.
	Name *string

	noSmithyDocumentSerde
}

// Information about a reference metric used to evaluate Performance Insights.
type PerformanceInsightsReferenceMetric struct {

	// A query to be processed on the metric.
	MetricQuery *PerformanceInsightsMetricQuery

	noSmithyDocumentSerde
}

// A reference value to compare Performance Insights metrics against to determine
// if the metrics demonstrate anomalous behavior.
type PerformanceInsightsReferenceScalar struct {

	// The reference value.
	Value *float64

	noSmithyDocumentSerde
}

// A statistic in a Performance Insights collection.
type PerformanceInsightsStat struct {

	// The statistic type.
	Type *string

	// The value of the statistic.
	Value *float64

	noSmithyDocumentSerde
}

// The time range during which anomalous behavior in a proactive anomaly or an
// insight is expected to occur.
type PredictionTimeRange struct {

	// The time range during which a metric limit is expected to be exceeded. This
	// applies to proactive insights only.
	//
	// This member is required.
	StartTime *time.Time

	// The time when the behavior in a proactive insight is expected to end.
	EndTime *time.Time

	noSmithyDocumentSerde
}

// Information about an anomaly. This object is returned by ListAnomalies.
type ProactiveAnomaly struct {

	// An AnomalyReportedTimeRange object that specifies the time range between when
	// the anomaly is opened and the time when it is closed.
	AnomalyReportedTimeRange *AnomalyReportedTimeRange

	// A time range that specifies when the observed unusual behavior in an anomaly
	// started and ended. This is different from AnomalyReportedTimeRange, which
	// specifies the time range when DevOps Guru opens and then closes an anomaly.
	AnomalyTimeRange *AnomalyTimeRange

	// The ID of the insight that contains this anomaly. An insight is composed of
	// related anomalies.
	AssociatedInsightId *string

	// The ID of a proactive anomaly.
	Id *string

	// A threshold that was exceeded by behavior in analyzed resources. Exceeding this
	// threshold is related to the anomalous behavior that generated this anomaly.
	Limit *float64

	// The time range during which anomalous behavior in a proactive anomaly or an
	// insight is expected to occur.
	PredictionTimeRange *PredictionTimeRange

	// A collection of Amazon Web Services resources supported by DevOps Guru. The two
	// types of Amazon Web Services resource collections supported are Amazon Web
	// Services CloudFormation stacks and Amazon Web Services resources that contain
	// the same Amazon Web Services tag. DevOps Guru can be configured to analyze the
	// Amazon Web Services resources that are defined in the stacks or that are tagged
	// using the same tag key. You can specify up to 500 Amazon Web Services
	// CloudFormation stacks.
	ResourceCollection *ResourceCollection

	// The severity of the anomaly. The severity of anomalies that generate an insight
	// determine that insight's severity. For more information, see Understanding
	// insight severities
	// (https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities)
	// in the Amazon DevOps Guru User Guide.
	Severity AnomalySeverity

	// Details about the source of the analyzed operational data that triggered the
	// anomaly. The one supported source is Amazon CloudWatch metrics.
	SourceDetails *AnomalySourceDetails

	// The status of a proactive anomaly.
	Status AnomalyStatus

	// The time of the anomaly's most recent update.
	UpdateTime *time.Time

	noSmithyDocumentSerde
}

// Details about a proactive anomaly. This object is returned by DescribeAnomaly.
type ProactiveAnomalySummary struct {

	// An AnomalyReportedTimeRange object that specifies the time range between when
	// the anomaly is opened and the time when it is closed.
	AnomalyReportedTimeRange *AnomalyReportedTimeRange

	// A time range that specifies when the observed unusual behavior in an anomaly
	// started and ended. This is different from AnomalyReportedTimeRange, which
	// specifies the time range when DevOps Guru opens and then closes an anomaly.
	AnomalyTimeRange *AnomalyTimeRange

	// The ID of the insight that contains this anomaly. An insight is composed of
	// related anomalies.
	AssociatedInsightId *string

	// The ID of the anomaly.
	Id *string

	// A threshold that was exceeded by behavior in analyzed resources. Exceeding this
	// threshold is related to the anomalous behavior that generated this anomaly.
	Limit *float64

	// The time range during which anomalous behavior in a proactive anomaly or an
	// insight is expected to occur.
	PredictionTimeRange *PredictionTimeRange

	// A collection of Amazon Web Services resources supported by DevOps Guru. The two
	// types of Amazon Web Services resource collections supported are Amazon Web
	// Services CloudFormation stacks and Amazon Web Services resources that contain
	// the same Amazon Web Services tag. DevOps Guru can be configured to analyze the
	// Amazon Web Services resources that are defined in the stacks or that are tagged
	// using the same tag key. You can specify up to 500 Amazon Web Services
	// CloudFormation stacks.
	ResourceCollection *ResourceCollection

	// The severity of the anomaly. The severity of anomalies that generate an insight
	// determine that insight's severity. For more information, see Understanding
	// insight severities
	// (https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities)
	// in the Amazon DevOps Guru User Guide.
	Severity AnomalySeverity

	// Details about the source of the analyzed operational data that triggered the
	// anomaly. The one supported source is Amazon CloudWatch metrics.
	SourceDetails *AnomalySourceDetails

	// The status of the anomaly.
	Status AnomalyStatus

	// The time of the anomaly's most recent update.
	UpdateTime *time.Time

	noSmithyDocumentSerde
}

// Details about a proactive insight. This object is returned by ListInsights.
type ProactiveInsight struct {

	// The ID of the proactive insight.
	Id *string

	// A time ranged that specifies when the observed behavior in an insight started
	// and ended.
	InsightTimeRange *InsightTimeRange

	// The name of the proactive insight.
	Name *string

	// The time range during which anomalous behavior in a proactive anomaly or an
	// insight is expected to occur.
	PredictionTimeRange *PredictionTimeRange

	// A collection of Amazon Web Services resources supported by DevOps Guru. The two
	// types of Amazon Web Services resource collections supported are Amazon Web
	// Services CloudFormation stacks and Amazon Web Services resources that contain
	// the same Amazon Web Services tag. DevOps Guru can be configured to analyze the
	// Amazon Web Services resources that are defined in the stacks or that are tagged
	// using the same tag key. You can specify up to 500 Amazon Web Services
	// CloudFormation stacks.
	ResourceCollection *ResourceCollection

	// The severity of the insight. For more information, see Understanding insight
	// severities
	// (https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities)
	// in the Amazon DevOps Guru User Guide.
	Severity InsightSeverity

	// The ID of the Amazon Web Services System Manager OpsItem created for this
	// insight. You must enable the creation of OpstItems insights before they are
	// created for each insight.
	SsmOpsItemId *string

	// The status of the proactive insight.
	Status InsightStatus

	noSmithyDocumentSerde
}

// Details about a proactive insight. This object is returned by DescribeInsight.
type ProactiveInsightSummary struct {

	// The Amazon Resource Names (ARNs) of the Amazon Web Services resources that
	// generated this insight.
	AssociatedResourceArns []string

	// The ID of the proactive insight.
	Id *string

	// A time ranged that specifies when the observed behavior in an insight started
	// and ended.
	InsightTimeRange *InsightTimeRange

	// The name of the proactive insight.
	Name *string

	// The time range during which anomalous behavior in a proactive anomaly or an
	// insight is expected to occur.
	PredictionTimeRange *PredictionTimeRange

	// A collection of Amazon Web Services resources supported by DevOps Guru. The two
	// types of Amazon Web Services resource collections supported are Amazon Web
	// Services CloudFormation stacks and Amazon Web Services resources that contain
	// the same Amazon Web Services tag. DevOps Guru can be configured to analyze the
	// Amazon Web Services resources that are defined in the stacks or that are tagged
	// using the same tag key. You can specify up to 500 Amazon Web Services
	// CloudFormation stacks.
	ResourceCollection *ResourceCollection

	// A collection of the names of Amazon Web Services services.
	ServiceCollection *ServiceCollection

	// The severity of the insight. For more information, see Understanding insight
	// severities
	// (https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities)
	// in the Amazon DevOps Guru User Guide.
	Severity InsightSeverity

	// The status of the proactive insight.
	Status InsightStatus

	noSmithyDocumentSerde
}

// Details about a proactive insight. This object is returned by DescribeInsight.
type ProactiveOrganizationInsightSummary struct {

	// The ID of the Amazon Web Services account.
	AccountId *string

	// The ID of the insight summary.
	Id *string

	// A time ranged that specifies when the observed behavior in an insight started
	// and ended.
	InsightTimeRange *InsightTimeRange

	// The name of the insight summary.
	Name *string

	// The ID of the organizational unit.
	OrganizationalUnitId *string

	// The time range during which anomalous behavior in a proactive anomaly or an
	// insight is expected to occur.
	PredictionTimeRange *PredictionTimeRange

	// A collection of Amazon Web Services resources supported by DevOps Guru. The two
	// types of Amazon Web Services resource collections supported are Amazon Web
	// Services CloudFormation stacks and Amazon Web Services resources that contain
	// the same Amazon Web Services tag. DevOps Guru can be configured to analyze the
	// Amazon Web Services resources that are defined in the stacks or that are tagged
	// using the same tag key. You can specify up to 500 Amazon Web Services
	// CloudFormation stacks.
	ResourceCollection *ResourceCollection

	// A collection of the names of Amazon Web Services services.
	ServiceCollection *ServiceCollection

	// An array of severity values used to search for insights. For more information,
	// see Understanding insight severities
	// (https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities)
	// in the Amazon DevOps Guru User Guide.
	Severity InsightSeverity

	// An array of status values used to search for insights.
	Status InsightStatus

	noSmithyDocumentSerde
}

// Details about a reactive anomaly. This object is returned by ListAnomalies.
type ReactiveAnomaly struct {

	// An AnomalyReportedTimeRange object that specifies the time range between when
	// the anomaly is opened and the time when it is closed.
	AnomalyReportedTimeRange *AnomalyReportedTimeRange

	// The Amazon Web Services resources in which anomalous behavior was detected by
	// DevOps Guru.
	AnomalyResources []AnomalyResource

	// A time range that specifies when the observed unusual behavior in an anomaly
	// started and ended. This is different from AnomalyReportedTimeRange, which
	// specifies the time range when DevOps Guru opens and then closes an anomaly.
	AnomalyTimeRange *AnomalyTimeRange

	// The ID of the insight that contains this anomaly. An insight is composed of
	// related anomalies.
	AssociatedInsightId *string

	// The ID of the causal anomaly that is associated with this reactive anomaly. The
	// ID of a `CAUSAL` anomaly is always `NULL`.
	CausalAnomalyId *string

	// A description of the reactive anomaly.
	Description *string

	// The ID of the reactive anomaly.
	Id *string

	// The name of the reactive anomaly.
	Name *string

	// A collection of Amazon Web Services resources supported by DevOps Guru. The two
	// types of Amazon Web Services resource collections supported are Amazon Web
	// Services CloudFormation stacks and Amazon Web Services resources that contain
	// the same Amazon Web Services tag. DevOps Guru can be configured to analyze the
	// Amazon Web Services resources that are defined in the stacks or that are tagged
	// using the same tag key. You can specify up to 500 Amazon Web Services
	// CloudFormation stacks.
	ResourceCollection *ResourceCollection

	// The severity of the anomaly. The severity of anomalies that generate an insight
	// determine that insight's severity. For more information, see Understanding
	// insight severities
	// (https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities)
	// in the Amazon DevOps Guru User Guide.
	Severity AnomalySeverity

	// Details about the source of the analyzed operational data that triggered the
	// anomaly. The one supported source is Amazon CloudWatch metrics.
	SourceDetails *AnomalySourceDetails

	// The status of the anomaly.
	Status AnomalyStatus

	// The type of the reactive anomaly. It can be one of the following types.
	//
	// *
	// CAUSAL - the anomaly can cause a new insight.
	//
	// * CONTEXTUAL - the anomaly
	// contains additional information about an insight or its causal anomaly.
	Type AnomalyType

	noSmithyDocumentSerde
}

// Details about a reactive anomaly. This object is returned by DescribeAnomaly.
type ReactiveAnomalySummary struct {

	// An AnomalyReportedTimeRange object that specifies the time range between when
	// the anomaly is opened and the time when it is closed.
	AnomalyReportedTimeRange *AnomalyReportedTimeRange

	// The Amazon Web Services resources in which anomalous behavior was detected by
	// DevOps Guru.
	AnomalyResources []AnomalyResource

	// A time range that specifies when the observed unusual behavior in an anomaly
	// started and ended. This is different from AnomalyReportedTimeRange, which
	// specifies the time range when DevOps Guru opens and then closes an anomaly.
	AnomalyTimeRange *AnomalyTimeRange

	// The ID of the insight that contains this anomaly. An insight is composed of
	// related anomalies.
	AssociatedInsightId *string

	// The ID of the causal anomaly that is associated with this reactive anomaly. The
	// ID of a `CAUSAL` anomaly is always `NULL`.
	CausalAnomalyId *string

	// A description of the reactive anomaly.
	Description *string

	// The ID of the reactive anomaly.
	Id *string

	// The name of the reactive anomaly.
	Name *string

	// A collection of Amazon Web Services resources supported by DevOps Guru. The two
	// types of Amazon Web Services resource collections supported are Amazon Web
	// Services CloudFormation stacks and Amazon Web Services resources that contain
	// the same Amazon Web Services tag. DevOps Guru can be configured to analyze the
	// Amazon Web Services resources that are defined in the stacks or that are tagged
	// using the same tag key. You can specify up to 500 Amazon Web Services
	// CloudFormation stacks.
	ResourceCollection *ResourceCollection

	// The severity of the anomaly. The severity of anomalies that generate an insight
	// determine that insight's severity. For more information, see Understanding
	// insight severities
	// (https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities)
	// in the Amazon DevOps Guru User Guide.
	Severity AnomalySeverity

	// Details about the source of the analyzed operational data that triggered the
	// anomaly. The one supported source is Amazon CloudWatch metrics.
	SourceDetails *AnomalySourceDetails

	// The status of the reactive anomaly.
	Status AnomalyStatus

	// The type of the reactive anomaly. It can be one of the following types.
	//
	// *
	// CAUSAL - the anomaly can cause a new insight.
	//
	// * CONTEXTUAL - the anomaly
	// contains additional information about an insight or its causal anomaly.
	Type AnomalyType

	noSmithyDocumentSerde
}

// Information about a reactive insight. This object is returned by ListInsights.
type ReactiveInsight struct {

	// The ID of a reactive insight.
	Id *string

	// A time ranged that specifies when the observed behavior in an insight started
	// and ended.
	InsightTimeRange *InsightTimeRange

	// The name of a reactive insight.
	Name *string

	// A collection of Amazon Web Services resources supported by DevOps Guru. The two
	// types of Amazon Web Services resource collections supported are Amazon Web
	// Services CloudFormation stacks and Amazon Web Services resources that contain
	// the same Amazon Web Services tag. DevOps Guru can be configured to analyze the
	// Amazon Web Services resources that are defined in the stacks or that are tagged
	// using the same tag key. You can specify up to 500 Amazon Web Services
	// CloudFormation stacks.
	ResourceCollection *ResourceCollection

	// The severity of the insight. For more information, see Understanding insight
	// severities
	// (https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities)
	// in the Amazon DevOps Guru User Guide.
	Severity InsightSeverity

	// The ID of the Amazon Web Services System Manager OpsItem created for this
	// insight. You must enable the creation of OpstItems insights before they are
	// created for each insight.
	SsmOpsItemId *string

	// The status of a reactive insight.
	Status InsightStatus

	noSmithyDocumentSerde
}

// Information about a reactive insight. This object is returned by
// DescribeInsight.
type ReactiveInsightSummary struct {

	// The Amazon Resource Names (ARNs) of the Amazon Web Services resources that
	// generated this insight.
	AssociatedResourceArns []string

	// The ID of a reactive summary.
	Id *string

	// A time ranged that specifies when the observed behavior in an insight started
	// and ended.
	InsightTimeRange *InsightTimeRange

	// The name of a reactive insight.
	Name *string

	// A collection of Amazon Web Services resources supported by DevOps Guru. The two
	// types of Amazon Web Services resource collections supported are Amazon Web
	// Services CloudFormation stacks and Amazon Web Services resources that contain
	// the same Amazon Web Services tag. DevOps Guru can be configured to analyze the
	// Amazon Web Services resources that are defined in the stacks or that are tagged
	// using the same tag key. You can specify up to 500 Amazon Web Services
	// CloudFormation stacks.
	ResourceCollection *ResourceCollection

	// A collection of the names of Amazon Web Services services.
	ServiceCollection *ServiceCollection

	// The severity of the insight. For more information, see Understanding insight
	// severities
	// (https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities)
	// in the Amazon DevOps Guru User Guide.
	Severity InsightSeverity

	// The status of a reactive insight.
	Status InsightStatus

	noSmithyDocumentSerde
}

// Information about a reactive insight. This object is returned by
// DescribeInsight.
type ReactiveOrganizationInsightSummary struct {

	// The ID of the Amazon Web Services account.
	AccountId *string

	// The ID of the insight summary.
	Id *string

	// A time ranged that specifies when the observed behavior in an insight started
	// and ended.
	InsightTimeRange *InsightTimeRange

	// The name of the insight summary.
	Name *string

	// The ID of the organizational unit.
	OrganizationalUnitId *string

	// A collection of Amazon Web Services resources supported by DevOps Guru. The two
	// types of Amazon Web Services resource collections supported are Amazon Web
	// Services CloudFormation stacks and Amazon Web Services resources that contain
	// the same Amazon Web Services tag. DevOps Guru can be configured to analyze the
	// Amazon Web Services resources that are defined in the stacks or that are tagged
	// using the same tag key. You can specify up to 500 Amazon Web Services
	// CloudFormation stacks.
	ResourceCollection *ResourceCollection

	// A collection of the names of Amazon Web Services services.
	ServiceCollection *ServiceCollection

	// An array of severity values used to search for insights. For more information,
	// see Understanding insight severities
	// (https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities)
	// in the Amazon DevOps Guru User Guide.
	Severity InsightSeverity

	// An array of status values used to search for insights.
	Status InsightStatus

	noSmithyDocumentSerde
}

// Recommendation information to help you remediate detected anomalous behavior
// that generated an insight.
type Recommendation struct {

	// A description of the problem.
	Description *string

	// A hyperlink to information to help you address the problem.
	Link *string

	// The name of the recommendation.
	Name *string

	// The reason DevOps Guru flagged the anomalous behavior as a problem.
	Reason *string

	// Anomalies that are related to the problem. Use these Anomalies to learn more
	// about what's happening and to help address the issue.
	RelatedAnomalies []RecommendationRelatedAnomaly

	// Events that are related to the problem. Use these events to learn more about
	// what's happening and to help address the issue.
	RelatedEvents []RecommendationRelatedEvent

	noSmithyDocumentSerde
}

// Information about an anomaly that is related to a recommendation.
type RecommendationRelatedAnomaly struct {

	// The ID of an anomaly that generated the insight with this recommendation.
	AnomalyId *string

	// An array of objects that represent resources in which DevOps Guru detected
	// anomalous behavior. Each object contains the name and type of the resource.
	Resources []RecommendationRelatedAnomalyResource

	// Information about where the anomalous behavior related the recommendation was
	// found. For example, details in Amazon CloudWatch metrics.
	SourceDetails []RecommendationRelatedAnomalySourceDetail

	noSmithyDocumentSerde
}

// Information about a resource in which DevOps Guru detected anomalous behavior.
type RecommendationRelatedAnomalyResource struct {

	// The name of the resource.
	Name *string

	// The type of the resource. Resource types take the same form that is used by
	// Amazon Web Services CloudFormation resource type identifiers,
	// service-provider::service-name::data-type-name. For example,
	// AWS::RDS::DBCluster. For more information, see Amazon Web Services resource and
	// property types reference
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the Amazon Web Services CloudFormation User Guide.
	Type *string

	noSmithyDocumentSerde
}

// Contains an array of RecommendationRelatedCloudWatchMetricsSourceDetail objects
// that contain the name and namespace of an Amazon CloudWatch metric.
type RecommendationRelatedAnomalySourceDetail struct {

	// An array of CloudWatchMetricsDetail objects that contains information about the
	// analyzed metrics that displayed anomalous behavior.
	CloudWatchMetrics []RecommendationRelatedCloudWatchMetricsSourceDetail

	noSmithyDocumentSerde
}

// Information about an Amazon CloudWatch metric that is analyzed by DevOps Guru.
// It is one of many analyzed metrics that are used to generate insights.
type RecommendationRelatedCloudWatchMetricsSourceDetail struct {

	// The name of the CloudWatch metric.
	MetricName *string

	// The namespace of the CloudWatch metric. A namespace is a container for
	// CloudWatch metrics.
	Namespace *string

	noSmithyDocumentSerde
}

// Information about an event that is related to a recommendation.
type RecommendationRelatedEvent struct {

	// The name of the event. This corresponds to the Name field in an Event object.
	Name *string

	// A ResourceCollection object that contains arrays of the names of Amazon Web
	// Services CloudFormation stacks. You can specify up to 500 Amazon Web Services
	// CloudFormation stacks.
	Resources []RecommendationRelatedEventResource

	noSmithyDocumentSerde
}

// Information about an Amazon Web Services resource that emitted and event that is
// related to a recommendation in an insight.
type RecommendationRelatedEventResource struct {

	// The name of the resource that emitted the event. This corresponds to the Name
	// field in an EventResource object.
	Name *string

	// The type of the resource that emitted the event. This corresponds to the Type
	// field in an EventResource object.
	Type *string

	noSmithyDocumentSerde
}

// A collection of Amazon Web Services resources supported by DevOps Guru. The two
// types of Amazon Web Services resource collections supported are Amazon Web
// Services CloudFormation stacks and Amazon Web Services resources that contain
// the same Amazon Web Services tag. DevOps Guru can be configured to analyze the
// Amazon Web Services resources that are defined in the stacks or that are tagged
// using the same tag key. You can specify up to 500 Amazon Web Services
// CloudFormation stacks.
type ResourceCollection struct {

	// An array of the names of Amazon Web Services CloudFormation stacks. The stacks
	// define Amazon Web Services resources that DevOps Guru analyzes. You can specify
	// up to 500 Amazon Web Services CloudFormation stacks.
	CloudFormation *CloudFormationCollection

	// The Amazon Web Services tags that are used by resources in the resource
	// collection. Tags help you identify and organize your Amazon Web Services
	// resources. Many Amazon Web Services services support tagging, so you can assign
	// the same tag to resources from different services to indicate that the resources
	// are related. For example, you can assign the same tag to an Amazon DynamoDB
	// table resource that you assign to an Lambda function. For more information about
	// using tags, see the Tagging best practices
	// (https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf)
	// whitepaper. Each Amazon Web Services tag has two parts.
	//
	// * A tag key (for
	// example, CostCenter, Environment, Project, or Secret). Tag keys are
	// case-sensitive.
	//
	// * An optional field known as a tag value (for example,
	// 111122223333, Production, or a team name). Omitting the tag value is the same as
	// using an empty string. Like tag keys, tag values are case-sensitive.
	//
	// Together
	// these are known as key-value pairs. The string used for a key in a tag that you
	// use to define your resource coverage must begin with the prefix Devops-guru-.
	// The tag key might be Devops-guru-deployment-application or
	// Devops-guru-rds-application. While keys are case-sensitive, the case of key
	// characters don't matter to DevOps Guru. For example, DevOps Guru works with a
	// key named devops-guru-rds and a key named DevOps-Guru-RDS. Possible key/value
	// pairs in your application might be Devops-Guru-production-application/RDS or
	// Devops-Guru-production-application/containers.
	Tags []TagCollection

	noSmithyDocumentSerde
}

// Information about a filter used to specify which Amazon Web Services resources
// are analyzed for anomalous behavior by DevOps Guru.
type ResourceCollectionFilter struct {

	// Information about Amazon Web Services CloudFormation stacks. You can use up to
	// 500 stacks to specify which Amazon Web Services resources in your account to
	// analyze. For more information, see Stacks
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html) in
	// the Amazon Web Services CloudFormation User Guide.
	CloudFormation *CloudFormationCollectionFilter

	// The Amazon Web Services tags used to filter the resources in the resource
	// collection. Tags help you identify and organize your Amazon Web Services
	// resources. Many Amazon Web Services services support tagging, so you can assign
	// the same tag to resources from different services to indicate that the resources
	// are related. For example, you can assign the same tag to an Amazon DynamoDB
	// table resource that you assign to an Lambda function. For more information about
	// using tags, see the Tagging best practices
	// (https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf)
	// whitepaper. Each Amazon Web Services tag has two parts.
	//
	// * A tag key (for
	// example, CostCenter, Environment, Project, or Secret). Tag keys are
	// case-sensitive.
	//
	// * An optional field known as a tag value (for example,
	// 111122223333, Production, or a team name). Omitting the tag value is the same as
	// using an empty string. Like tag keys, tag values are case-sensitive.
	//
	// Together
	// these are known as key-value pairs. The string used for a key in a tag that you
	// use to define your resource coverage must begin with the prefix Devops-guru-.
	// The tag key might be Devops-guru-deployment-application or
	// Devops-guru-rds-application. While keys are case-sensitive, the case of key
	// characters don't matter to DevOps Guru. For example, DevOps Guru works with a
	// key named devops-guru-rds and a key named DevOps-Guru-RDS. Possible key/value
	// pairs in your application might be Devops-Guru-production-application/RDS or
	// Devops-Guru-production-application/containers.
	Tags []TagCollectionFilter

	noSmithyDocumentSerde
}

// Specifies one or more severity values and one or more status values that are
// used to search for insights.
type SearchInsightsFilters struct {

	// A collection of Amazon Web Services resources supported by DevOps Guru. The two
	// types of Amazon Web Services resource collections supported are Amazon Web
	// Services CloudFormation stacks and Amazon Web Services resources that contain
	// the same Amazon Web Services tag. DevOps Guru can be configured to analyze the
	// Amazon Web Services resources that are defined in the stacks or that are tagged
	// using the same tag key. You can specify up to 500 Amazon Web Services
	// CloudFormation stacks.
	ResourceCollection *ResourceCollection

	// A collection of the names of Amazon Web Services services.
	ServiceCollection *ServiceCollection

	// An array of severity values used to search for insights.
	Severities []InsightSeverity

	// An array of status values used to search for insights.
	Statuses []InsightStatus

	noSmithyDocumentSerde
}

// Filters you can use to specify which events are returned when ListEvents is
// called.
type SearchOrganizationInsightsFilters struct {

	// A collection of Amazon Web Services resources supported by DevOps Guru. The two
	// types of Amazon Web Services resource collections supported are Amazon Web
	// Services CloudFormation stacks and Amazon Web Services resources that contain
	// the same Amazon Web Services tag. DevOps Guru can be configured to analyze the
	// Amazon Web Services resources that are defined in the stacks or that are tagged
	// using the same tag key. You can specify up to 500 Amazon Web Services
	// CloudFormation stacks.
	ResourceCollection *ResourceCollection

	// A collection of the names of Amazon Web Services services.
	ServiceCollection *ServiceCollection

	// An array of severity values used to search for insights.
	Severities []InsightSeverity

	// An array of status values used to search for insights.
	Statuses []InsightStatus

	noSmithyDocumentSerde
}

// A collection of the names of Amazon Web Services services.
type ServiceCollection struct {

	// An array of strings that each specifies the name of an Amazon Web Services
	// service.
	ServiceNames []ServiceName

	noSmithyDocumentSerde
}

// Represents the health of an Amazon Web Services service.
type ServiceHealth struct {

	// Represents the health of an Amazon Web Services service. This is a
	// ServiceInsightHealth that contains the number of open proactive and reactive
	// insights for this service.
	Insight *ServiceInsightHealth

	// The name of the Amazon Web Services service.
	ServiceName ServiceName

	noSmithyDocumentSerde
}

// Contains the number of open proactive and reactive insights in an analyzed
// Amazon Web Services service.
type ServiceInsightHealth struct {

	// The number of open proactive insights in the Amazon Web Services service
	OpenProactiveInsights int32

	// The number of open reactive insights in the Amazon Web Services service
	OpenReactiveInsights int32

	noSmithyDocumentSerde
}

// Information about the integration of DevOps Guru with another Amazon Web
// Services service, such as Amazon Web Services Systems Manager.
type ServiceIntegrationConfig struct {

	// Information about whether DevOps Guru is configured to create an OpsItem in
	// Amazon Web Services Systems Manager OpsCenter for each created insight.
	OpsCenter *OpsCenterIntegration

	noSmithyDocumentSerde
}

// An object that contains information about the estimated monthly cost to analyze
// an Amazon Web Services resource. For more information, see Estimate your Amazon
// DevOps Guru costs
// (https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html)
// and Amazon DevOps Guru pricing (http://aws.amazon.com/devops-guru/pricing/).
type ServiceResourceCost struct {

	// The total estimated monthly cost to analyze the active resources for this
	// resource.
	Cost float64

	// The number of active resources analyzed for this service to create a monthly
	// cost estimate.
	Count int32

	// The state of the resource. The resource is ACTIVE if it produces metrics,
	// events, or logs within an hour, otherwise it is INACTIVE. You pay for the number
	// of active Amazon Web Services resource hours analyzed for each resource.
	// Inactive resources are not charged.
	State CostEstimationServiceResourceState

	// The type of the Amazon Web Services resource.
	Type *string

	// The price per hour to analyze the resources in the service. For more
	// information, see Estimate your Amazon DevOps Guru costs
	// (https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html)
	// and Amazon DevOps Guru pricing (http://aws.amazon.com/devops-guru/pricing/).
	UnitCost float64

	noSmithyDocumentSerde
}

// Contains the Amazon Resource Name (ARN) of an Amazon Simple Notification Service
// topic. If you use an Amazon SNS topic in another account, you must attach a
// policy to it that grants DevOps Guru permission to it notifications. DevOps Guru
// adds the required policy on your behalf to send notifications using Amazon SNS
// in your account. For more information, see Permissions for cross account Amazon
// SNS topics
// (https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html).
// If you use an Amazon SNS topic that is encrypted by an Amazon Web Services Key
// Management Service customer-managed key (CMK), then you must add permissions to
// the CMK. For more information, see Permissions for Amazon Web Services
// KMS–encrypted Amazon SNS topics
// (https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html).
type SnsChannelConfig struct {

	// The Amazon Resource Name (ARN) of an Amazon Simple Notification Service topic.
	TopicArn *string

	noSmithyDocumentSerde
}

// A time range used to specify when the behavior of an insight or anomaly started.
type StartTimeRange struct {

	// The start time of the time range.
	FromTime *time.Time

	// The end time of the time range.
	ToTime *time.Time

	noSmithyDocumentSerde
}

// A collection of Amazon Web Services stags. Tags help you identify and organize
// your Amazon Web Services resources. Many Amazon Web Services services support
// tagging, so you can assign the same tag to resources from different services to
// indicate that the resources are related. For example, you can assign the same
// tag to an Amazon DynamoDB table resource that you assign to an Lambda function.
// For more information about using tags, see the Tagging best practices
// (https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf)
// whitepaper. Each Amazon Web Services tag has two parts.
//
// * A tag key (for
// example, CostCenter, Environment, Project, or Secret). Tag keys are
// case-sensitive.
//
// * An optional field known as a tag value (for example,
// 111122223333, Production, or a team name). Omitting the tag value is the same as
// using an empty string. Like tag keys, tag values are case-sensitive.
//
// Together
// these are known as key-value pairs. The string used for a key in a tag that you
// use to define your resource coverage must begin with the prefix Devops-guru-.
// The tag key might be Devops-guru-deployment-application or
// Devops-guru-rds-application. While keys are case-sensitive, the case of key
// characters don't matter to DevOps Guru. For example, DevOps Guru works with a
// key named devops-guru-rds and a key named DevOps-Guru-RDS. Possible key/value
// pairs in your application might be Devops-Guru-production-application/RDS or
// Devops-Guru-production-application/containers.
type TagCollection struct {

	// An Amazon Web Services tag key that is used to identify the Amazon Web Services
	// resources that DevOps Guru analyzes. All Amazon Web Services resources in your
	// account and Region tagged with this key make up your DevOps Guru application and
	// analysis boundary. The string used for a key in a tag that you use to define
	// your resource coverage must begin with the prefix Devops-guru-. The tag key
	// might be Devops-guru-deployment-application or Devops-guru-rds-application.
	// While keys are case-sensitive, the case of key characters don't matter to DevOps
	// Guru. For example, DevOps Guru works with a key named devops-guru-rds and a key
	// named DevOps-Guru-RDS. Possible key/value pairs in your application might be
	// Devops-Guru-production-application/RDS or
	// Devops-Guru-production-application/containers.
	//
	// This member is required.
	AppBoundaryKey *string

	// The values in an Amazon Web Services tag collection. The tag's value is an
	// optional field used to associate a string with the tag key (for example,
	// 111122223333, Production, or a team name). The key and value are the tag's key
	// pair. Omitting the tag value is the same as using an empty string. Like tag
	// keys, tag values are case-sensitive. You can specify a maximum of 256 characters
	// for a tag value.
	//
	// This member is required.
	TagValues []string

	noSmithyDocumentSerde
}

// A collection of Amazon Web Services tags used to filter insights. This is used
// to return insights generated from only resources that contain the tags in the
// tag collection.
type TagCollectionFilter struct {

	// An Amazon Web Services tag key that is used to identify the Amazon Web Services
	// resources that DevOps Guru analyzes. All Amazon Web Services resources in your
	// account and Region tagged with this key make up your DevOps Guru application and
	// analysis boundary. The string used for a key in a tag that you use to define
	// your resource coverage must begin with the prefix Devops-guru-. The tag key
	// might be Devops-guru-deployment-application or Devops-guru-rds-application.
	// While keys are case-sensitive, the case of key characters don't matter to DevOps
	// Guru. For example, DevOps Guru works with a key named devops-guru-rds and a key
	// named DevOps-Guru-RDS. Possible key/value pairs in your application might be
	// Devops-Guru-production-application/RDS or
	// Devops-Guru-production-application/containers.
	//
	// This member is required.
	AppBoundaryKey *string

	// The values in an Amazon Web Services tag collection. The tag's value is an
	// optional field used to associate a string with the tag key (for example,
	// 111122223333, Production, or a team name). The key and value are the tag's key
	// pair. Omitting the tag value is the same as using an empty string. Like tag
	// keys, tag values are case-sensitive. You can specify a maximum of 256 characters
	// for a tag value.
	//
	// This member is required.
	TagValues []string

	noSmithyDocumentSerde
}

// Information about a collection of Amazon Web Services resources that are
// identified by an Amazon Web Services tag. This collection of resources is used
// to create a monthly cost estimate for DevOps Guru to analyze Amazon Web Services
// resources. The maximum number of tags you can specify for a cost estimate is
// one. The estimate created is for the cost to analyze the Amazon Web Services
// resources defined by the tag. For more information, see Stacks
// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html) in
// the Amazon Web Services CloudFormation User Guide.
type TagCostEstimationResourceCollectionFilter struct {

	// An Amazon Web Services tag key that is used to identify the Amazon Web Services
	// resources that DevOps Guru analyzes. All Amazon Web Services resources in your
	// account and Region tagged with this key make up your DevOps Guru application and
	// analysis boundary. The string used for a key in a tag that you use to define
	// your resource coverage must begin with the prefix Devops-guru-. The tag key
	// might be Devops-guru-deployment-application or Devops-guru-rds-application.
	// While keys are case-sensitive, the case of key characters don't matter to DevOps
	// Guru. For example, DevOps Guru works with a key named devops-guru-rds and a key
	// named DevOps-Guru-RDS. Possible key/value pairs in your application might be
	// Devops-Guru-production-application/RDS or
	// Devops-Guru-production-application/containers.
	//
	// This member is required.
	AppBoundaryKey *string

	// The values in an Amazon Web Services tag collection. The tag's value is an
	// optional field used to associate a string with the tag key (for example,
	// 111122223333, Production, or a team name). The key and value are the tag's key
	// pair. Omitting the tag value is the same as using an empty string. Like tag
	// keys, tag values are case-sensitive. You can specify a maximum of 256 characters
	// for a tag value.
	//
	// This member is required.
	TagValues []string

	noSmithyDocumentSerde
}

// Information about the health of Amazon Web Services resources in your account
// that are specified by an Amazon Web Services tag key.
type TagHealth struct {

	// An Amazon Web Services tag key that is used to identify the Amazon Web Services
	// resources that DevOps Guru analyzes. All Amazon Web Services resources in your
	// account and Region tagged with this key make up your DevOps Guru application and
	// analysis boundary. The string used for a key in a tag that you use to define
	// your resource coverage must begin with the prefix Devops-guru-. The tag key
	// might be Devops-guru-deployment-application or Devops-guru-rds-application.
	// While keys are case-sensitive, the case of key characters don't matter to DevOps
	// Guru. For example, DevOps Guru works with a key named devops-guru-rds and a key
	// named DevOps-Guru-RDS. Possible key/value pairs in your application might be
	// Devops-Guru-production-application/RDS or
	// Devops-Guru-production-application/containers.
	AppBoundaryKey *string

	// Information about the health of the Amazon Web Services resources in your
	// account that are specified by an Amazon Web Services tag, including the number
	// of open proactive, open reactive insights, and the Mean Time to Recover (MTTR)
	// of closed insights.
	Insight *InsightHealth

	// The value in an Amazon Web Services tag. The tag's value is an optional field
	// used to associate a string with the tag key (for example, 111122223333,
	// Production, or a team name). The key and value are the tag's key pair. Omitting
	// the tag value is the same as using an empty string. Like tag keys, tag values
	// are case-sensitive. You can specify a maximum of 256 characters for a tag value.
	TagValue *string

	noSmithyDocumentSerde
}

// A pair that contains metric values at the respective timestamp.
type TimestampMetricValuePair struct {

	// Value of the anomalous metric data point at respective Timestamp.
	MetricValue *float64

	// A Timestamp that specifies the time the event occurred.
	Timestamp *time.Time

	noSmithyDocumentSerde
}

// Contains the names of Amazon Web Services CloudFormation stacks used to update a
// collection of stacks. You can specify up to 500 Amazon Web Services
// CloudFormation stacks.
type UpdateCloudFormationCollectionFilter struct {

	// An array of the names of the Amazon Web Services CloudFormation stacks to
	// update. You can specify up to 500 Amazon Web Services CloudFormation stacks.
	StackNames []string

	noSmithyDocumentSerde
}

// Contains information used to update a collection of Amazon Web Services
// resources.
type UpdateResourceCollectionFilter struct {

	// A collection of Amazon Web Services CloudFormation stacks. You can specify up to
	// 500 Amazon Web Services CloudFormation stacks.
	CloudFormation *UpdateCloudFormationCollectionFilter

	// The updated Amazon Web Services tags used to filter the resources in the
	// resource collection. Tags help you identify and organize your Amazon Web
	// Services resources. Many Amazon Web Services services support tagging, so you
	// can assign the same tag to resources from different services to indicate that
	// the resources are related. For example, you can assign the same tag to an Amazon
	// DynamoDB table resource that you assign to an Lambda function. For more
	// information about using tags, see the Tagging best practices
	// (https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf)
	// whitepaper. Each Amazon Web Services tag has two parts.
	//
	// * A tag key (for
	// example, CostCenter, Environment, Project, or Secret). Tag keys are
	// case-sensitive.
	//
	// * An optional field known as a tag value (for example,
	// 111122223333, Production, or a team name). Omitting the tag value is the same as
	// using an empty string. Like tag keys, tag values are case-sensitive.
	//
	// Together
	// these are known as key-value pairs. The string used for a key in a tag that you
	// use to define your resource coverage must begin with the prefix Devops-guru-.
	// The tag key might be Devops-guru-deployment-application or
	// Devops-guru-rds-application. While keys are case-sensitive, the case of key
	// characters don't matter to DevOps Guru. For example, DevOps Guru works with a
	// key named devops-guru-rds and a key named DevOps-Guru-RDS. Possible key/value
	// pairs in your application might be Devops-Guru-production-application/RDS or
	// Devops-Guru-production-application/containers.
	Tags []UpdateTagCollectionFilter

	noSmithyDocumentSerde
}

// Information about updating the integration status of an Amazon Web Services
// service, such as Amazon Web Services Systems Manager, with DevOps Guru.
type UpdateServiceIntegrationConfig struct {

	// Information about whether DevOps Guru is configured to create an OpsItem in
	// Amazon Web Services Systems Manager OpsCenter for each created insight.
	OpsCenter *OpsCenterIntegrationConfig

	noSmithyDocumentSerde
}

// A new collection of Amazon Web Services resources that are defined by an Amazon
// Web Services tag or tag key/value pair.
type UpdateTagCollectionFilter struct {

	// An Amazon Web Services tag key that is used to identify the Amazon Web Services
	// resources that DevOps Guru analyzes. All Amazon Web Services resources in your
	// account and Region tagged with this key make up your DevOps Guru application and
	// analysis boundary. The string used for a key in a tag that you use to define
	// your resource coverage must begin with the prefix Devops-guru-. The tag key
	// might be Devops-guru-deployment-application or Devops-guru-rds-application.
	// While keys are case-sensitive, the case of key characters don't matter to DevOps
	// Guru. For example, DevOps Guru works with a key named devops-guru-rds and a key
	// named DevOps-Guru-RDS. Possible key/value pairs in your application might be
	// Devops-Guru-production-application/RDS or
	// Devops-Guru-production-application/containers.
	//
	// This member is required.
	AppBoundaryKey *string

	// The values in an Amazon Web Services tag collection. The tag's value is an
	// optional field used to associate a string with the tag key (for example,
	// 111122223333, Production, or a team name). The key and value are the tag's key
	// pair. Omitting the tag value is the same as using an empty string. Like tag
	// keys, tag values are case-sensitive. You can specify a maximum of 256 characters
	// for a tag value.
	//
	// This member is required.
	TagValues []string

	noSmithyDocumentSerde
}

// The field associated with the validation exception.
type ValidationExceptionField struct {

	// The message associated with the validation exception with information to help
	// determine its cause.
	//
	// This member is required.
	Message *string

	// The name of the field.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
