// Code generated by smithy-go-codegen DO NOT EDIT.

package connect

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/connect/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"math"
)

type awsRestjson1_serializeOpAssociateApprovedOrigin struct {
}

func (*awsRestjson1_serializeOpAssociateApprovedOrigin) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAssociateApprovedOrigin) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateApprovedOriginInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/instance/{InstanceId}/approved-origin")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAssociateApprovedOriginInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAssociateApprovedOriginInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAssociateApprovedOriginInput(v *AssociateApprovedOriginInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAssociateApprovedOriginInput(v *AssociateApprovedOriginInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Origin != nil {
		ok := object.Key("Origin")
		ok.String(*v.Origin)
	}

	return nil
}

type awsRestjson1_serializeOpAssociateBot struct {
}

func (*awsRestjson1_serializeOpAssociateBot) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAssociateBot) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateBotInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/instance/{InstanceId}/bot")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAssociateBotInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAssociateBotInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAssociateBotInput(v *AssociateBotInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAssociateBotInput(v *AssociateBotInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LexBot != nil {
		ok := object.Key("LexBot")
		if err := awsRestjson1_serializeDocumentLexBot(v.LexBot, ok); err != nil {
			return err
		}
	}

	if v.LexV2Bot != nil {
		ok := object.Key("LexV2Bot")
		if err := awsRestjson1_serializeDocumentLexV2Bot(v.LexV2Bot, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpAssociateInstanceStorageConfig struct {
}

func (*awsRestjson1_serializeOpAssociateInstanceStorageConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAssociateInstanceStorageConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateInstanceStorageConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/instance/{InstanceId}/storage-config")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAssociateInstanceStorageConfigInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAssociateInstanceStorageConfigInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAssociateInstanceStorageConfigInput(v *AssociateInstanceStorageConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAssociateInstanceStorageConfigInput(v *AssociateInstanceStorageConfigInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ResourceType) > 0 {
		ok := object.Key("ResourceType")
		ok.String(string(v.ResourceType))
	}

	if v.StorageConfig != nil {
		ok := object.Key("StorageConfig")
		if err := awsRestjson1_serializeDocumentInstanceStorageConfig(v.StorageConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpAssociateLambdaFunction struct {
}

func (*awsRestjson1_serializeOpAssociateLambdaFunction) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAssociateLambdaFunction) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateLambdaFunctionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/instance/{InstanceId}/lambda-function")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAssociateLambdaFunctionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAssociateLambdaFunctionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAssociateLambdaFunctionInput(v *AssociateLambdaFunctionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAssociateLambdaFunctionInput(v *AssociateLambdaFunctionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FunctionArn != nil {
		ok := object.Key("FunctionArn")
		ok.String(*v.FunctionArn)
	}

	return nil
}

type awsRestjson1_serializeOpAssociateLexBot struct {
}

func (*awsRestjson1_serializeOpAssociateLexBot) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAssociateLexBot) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateLexBotInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/instance/{InstanceId}/lex-bot")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAssociateLexBotInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAssociateLexBotInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAssociateLexBotInput(v *AssociateLexBotInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAssociateLexBotInput(v *AssociateLexBotInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LexBot != nil {
		ok := object.Key("LexBot")
		if err := awsRestjson1_serializeDocumentLexBot(v.LexBot, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpAssociateQueueQuickConnects struct {
}

func (*awsRestjson1_serializeOpAssociateQueueQuickConnects) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAssociateQueueQuickConnects) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateQueueQuickConnectsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/queues/{InstanceId}/{QueueId}/associate-quick-connects")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAssociateQueueQuickConnectsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAssociateQueueQuickConnectsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAssociateQueueQuickConnectsInput(v *AssociateQueueQuickConnectsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member QueueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("QueueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAssociateQueueQuickConnectsInput(v *AssociateQueueQuickConnectsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.QuickConnectIds != nil {
		ok := object.Key("QuickConnectIds")
		if err := awsRestjson1_serializeDocumentQuickConnectsList(v.QuickConnectIds, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpAssociateRoutingProfileQueues struct {
}

func (*awsRestjson1_serializeOpAssociateRoutingProfileQueues) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAssociateRoutingProfileQueues) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateRoutingProfileQueuesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/routing-profiles/{InstanceId}/{RoutingProfileId}/associate-queues")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAssociateRoutingProfileQueuesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAssociateRoutingProfileQueuesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAssociateRoutingProfileQueuesInput(v *AssociateRoutingProfileQueuesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.RoutingProfileId == nil || len(*v.RoutingProfileId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member RoutingProfileId must not be empty")}
	}
	if v.RoutingProfileId != nil {
		if err := encoder.SetURI("RoutingProfileId").String(*v.RoutingProfileId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAssociateRoutingProfileQueuesInput(v *AssociateRoutingProfileQueuesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.QueueConfigs != nil {
		ok := object.Key("QueueConfigs")
		if err := awsRestjson1_serializeDocumentRoutingProfileQueueConfigList(v.QueueConfigs, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpAssociateSecurityKey struct {
}

func (*awsRestjson1_serializeOpAssociateSecurityKey) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAssociateSecurityKey) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateSecurityKeyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/instance/{InstanceId}/security-key")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAssociateSecurityKeyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAssociateSecurityKeyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAssociateSecurityKeyInput(v *AssociateSecurityKeyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAssociateSecurityKeyInput(v *AssociateSecurityKeyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("Key")
		ok.String(*v.Key)
	}

	return nil
}

type awsRestjson1_serializeOpCreateAgentStatus struct {
}

func (*awsRestjson1_serializeOpCreateAgentStatus) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateAgentStatus) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateAgentStatusInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/agent-status/{InstanceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateAgentStatusInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateAgentStatusInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateAgentStatusInput(v *CreateAgentStatusInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateAgentStatusInput(v *CreateAgentStatusInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.DisplayOrder != nil {
		ok := object.Key("DisplayOrder")
		ok.Integer(*v.DisplayOrder)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if len(v.State) > 0 {
		ok := object.Key("State")
		ok.String(string(v.State))
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateContactFlow struct {
}

func (*awsRestjson1_serializeOpCreateContactFlow) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateContactFlow) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateContactFlowInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/contact-flows/{InstanceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateContactFlowInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateContactFlowInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateContactFlowInput(v *CreateContactFlowInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateContactFlowInput(v *CreateContactFlowInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Content != nil {
		ok := object.Key("Content")
		ok.String(*v.Content)
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

type awsRestjson1_serializeOpCreateContactFlowModule struct {
}

func (*awsRestjson1_serializeOpCreateContactFlowModule) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateContactFlowModule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateContactFlowModuleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/contact-flow-modules/{InstanceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateContactFlowModuleInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateContactFlowModuleInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateContactFlowModuleInput(v *CreateContactFlowModuleInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateContactFlowModuleInput(v *CreateContactFlowModuleInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("ClientToken")
		ok.String(*v.ClientToken)
	}

	if v.Content != nil {
		ok := object.Key("Content")
		ok.String(*v.Content)
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateHoursOfOperation struct {
}

func (*awsRestjson1_serializeOpCreateHoursOfOperation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateHoursOfOperation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateHoursOfOperationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/hours-of-operations/{InstanceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateHoursOfOperationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateHoursOfOperationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateHoursOfOperationInput(v *CreateHoursOfOperationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateHoursOfOperationInput(v *CreateHoursOfOperationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Config != nil {
		ok := object.Key("Config")
		if err := awsRestjson1_serializeDocumentHoursOfOperationConfigList(v.Config, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.TimeZone != nil {
		ok := object.Key("TimeZone")
		ok.String(*v.TimeZone)
	}

	return nil
}

type awsRestjson1_serializeOpCreateInstance struct {
}

func (*awsRestjson1_serializeOpCreateInstance) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateInstance) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateInstanceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/instance")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateInstanceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateInstanceInput(v *CreateInstanceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateInstanceInput(v *CreateInstanceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("ClientToken")
		ok.String(*v.ClientToken)
	}

	if v.DirectoryId != nil {
		ok := object.Key("DirectoryId")
		ok.String(*v.DirectoryId)
	}

	if len(v.IdentityManagementType) > 0 {
		ok := object.Key("IdentityManagementType")
		ok.String(string(v.IdentityManagementType))
	}

	if v.InboundCallsEnabled != nil {
		ok := object.Key("InboundCallsEnabled")
		ok.Boolean(*v.InboundCallsEnabled)
	}

	if v.InstanceAlias != nil {
		ok := object.Key("InstanceAlias")
		ok.String(*v.InstanceAlias)
	}

	if v.OutboundCallsEnabled != nil {
		ok := object.Key("OutboundCallsEnabled")
		ok.Boolean(*v.OutboundCallsEnabled)
	}

	return nil
}

type awsRestjson1_serializeOpCreateIntegrationAssociation struct {
}

func (*awsRestjson1_serializeOpCreateIntegrationAssociation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateIntegrationAssociation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateIntegrationAssociationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/instance/{InstanceId}/integration-associations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateIntegrationAssociationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateIntegrationAssociationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateIntegrationAssociationInput(v *CreateIntegrationAssociationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateIntegrationAssociationInput(v *CreateIntegrationAssociationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IntegrationArn != nil {
		ok := object.Key("IntegrationArn")
		ok.String(*v.IntegrationArn)
	}

	if len(v.IntegrationType) > 0 {
		ok := object.Key("IntegrationType")
		ok.String(string(v.IntegrationType))
	}

	if v.SourceApplicationName != nil {
		ok := object.Key("SourceApplicationName")
		ok.String(*v.SourceApplicationName)
	}

	if v.SourceApplicationUrl != nil {
		ok := object.Key("SourceApplicationUrl")
		ok.String(*v.SourceApplicationUrl)
	}

	if len(v.SourceType) > 0 {
		ok := object.Key("SourceType")
		ok.String(string(v.SourceType))
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateQueue struct {
}

func (*awsRestjson1_serializeOpCreateQueue) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateQueue) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateQueueInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/queues/{InstanceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateQueueInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateQueueInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateQueueInput(v *CreateQueueInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateQueueInput(v *CreateQueueInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.HoursOfOperationId != nil {
		ok := object.Key("HoursOfOperationId")
		ok.String(*v.HoursOfOperationId)
	}

	if v.MaxContacts != 0 {
		ok := object.Key("MaxContacts")
		ok.Integer(v.MaxContacts)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.OutboundCallerConfig != nil {
		ok := object.Key("OutboundCallerConfig")
		if err := awsRestjson1_serializeDocumentOutboundCallerConfig(v.OutboundCallerConfig, ok); err != nil {
			return err
		}
	}

	if v.QuickConnectIds != nil {
		ok := object.Key("QuickConnectIds")
		if err := awsRestjson1_serializeDocumentQuickConnectsList(v.QuickConnectIds, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateQuickConnect struct {
}

func (*awsRestjson1_serializeOpCreateQuickConnect) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateQuickConnect) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateQuickConnectInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/quick-connects/{InstanceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateQuickConnectInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateQuickConnectInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateQuickConnectInput(v *CreateQuickConnectInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateQuickConnectInput(v *CreateQuickConnectInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.QuickConnectConfig != nil {
		ok := object.Key("QuickConnectConfig")
		if err := awsRestjson1_serializeDocumentQuickConnectConfig(v.QuickConnectConfig, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateRoutingProfile struct {
}

func (*awsRestjson1_serializeOpCreateRoutingProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateRoutingProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateRoutingProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/routing-profiles/{InstanceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateRoutingProfileInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateRoutingProfileInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateRoutingProfileInput(v *CreateRoutingProfileInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateRoutingProfileInput(v *CreateRoutingProfileInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DefaultOutboundQueueId != nil {
		ok := object.Key("DefaultOutboundQueueId")
		ok.String(*v.DefaultOutboundQueueId)
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.MediaConcurrencies != nil {
		ok := object.Key("MediaConcurrencies")
		if err := awsRestjson1_serializeDocumentMediaConcurrencies(v.MediaConcurrencies, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.QueueConfigs != nil {
		ok := object.Key("QueueConfigs")
		if err := awsRestjson1_serializeDocumentRoutingProfileQueueConfigList(v.QueueConfigs, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateSecurityProfile struct {
}

func (*awsRestjson1_serializeOpCreateSecurityProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateSecurityProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateSecurityProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/security-profiles/{InstanceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateSecurityProfileInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateSecurityProfileInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateSecurityProfileInput(v *CreateSecurityProfileInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateSecurityProfileInput(v *CreateSecurityProfileInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.Permissions != nil {
		ok := object.Key("Permissions")
		if err := awsRestjson1_serializeDocumentPermissionsList(v.Permissions, ok); err != nil {
			return err
		}
	}

	if v.SecurityProfileName != nil {
		ok := object.Key("SecurityProfileName")
		ok.String(*v.SecurityProfileName)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateUseCase struct {
}

func (*awsRestjson1_serializeOpCreateUseCase) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateUseCase) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateUseCaseInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/instance/{InstanceId}/integration-associations/{IntegrationAssociationId}/use-cases")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateUseCaseInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateUseCaseInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateUseCaseInput(v *CreateUseCaseInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.IntegrationAssociationId == nil || len(*v.IntegrationAssociationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IntegrationAssociationId must not be empty")}
	}
	if v.IntegrationAssociationId != nil {
		if err := encoder.SetURI("IntegrationAssociationId").String(*v.IntegrationAssociationId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateUseCaseInput(v *CreateUseCaseInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	if len(v.UseCaseType) > 0 {
		ok := object.Key("UseCaseType")
		ok.String(string(v.UseCaseType))
	}

	return nil
}

type awsRestjson1_serializeOpCreateUser struct {
}

func (*awsRestjson1_serializeOpCreateUser) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateUser) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateUserInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/users/{InstanceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateUserInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateUserInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateUserInput(v *CreateUserInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateUserInput(v *CreateUserInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DirectoryUserId != nil {
		ok := object.Key("DirectoryUserId")
		ok.String(*v.DirectoryUserId)
	}

	if v.HierarchyGroupId != nil {
		ok := object.Key("HierarchyGroupId")
		ok.String(*v.HierarchyGroupId)
	}

	if v.IdentityInfo != nil {
		ok := object.Key("IdentityInfo")
		if err := awsRestjson1_serializeDocumentUserIdentityInfo(v.IdentityInfo, ok); err != nil {
			return err
		}
	}

	if v.Password != nil {
		ok := object.Key("Password")
		ok.String(*v.Password)
	}

	if v.PhoneConfig != nil {
		ok := object.Key("PhoneConfig")
		if err := awsRestjson1_serializeDocumentUserPhoneConfig(v.PhoneConfig, ok); err != nil {
			return err
		}
	}

	if v.RoutingProfileId != nil {
		ok := object.Key("RoutingProfileId")
		ok.String(*v.RoutingProfileId)
	}

	if v.SecurityProfileIds != nil {
		ok := object.Key("SecurityProfileIds")
		if err := awsRestjson1_serializeDocumentSecurityProfileIds(v.SecurityProfileIds, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.Username != nil {
		ok := object.Key("Username")
		ok.String(*v.Username)
	}

	return nil
}

type awsRestjson1_serializeOpCreateUserHierarchyGroup struct {
}

func (*awsRestjson1_serializeOpCreateUserHierarchyGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateUserHierarchyGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateUserHierarchyGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/user-hierarchy-groups/{InstanceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateUserHierarchyGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateUserHierarchyGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateUserHierarchyGroupInput(v *CreateUserHierarchyGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateUserHierarchyGroupInput(v *CreateUserHierarchyGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.ParentGroupId != nil {
		ok := object.Key("ParentGroupId")
		ok.String(*v.ParentGroupId)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteContactFlow struct {
}

func (*awsRestjson1_serializeOpDeleteContactFlow) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteContactFlow) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteContactFlowInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/contact-flows/{InstanceId}/{ContactFlowId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteContactFlowInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteContactFlowInput(v *DeleteContactFlowInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ContactFlowId == nil || len(*v.ContactFlowId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ContactFlowId must not be empty")}
	}
	if v.ContactFlowId != nil {
		if err := encoder.SetURI("ContactFlowId").String(*v.ContactFlowId); err != nil {
			return err
		}
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteContactFlowModule struct {
}

func (*awsRestjson1_serializeOpDeleteContactFlowModule) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteContactFlowModule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteContactFlowModuleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/contact-flow-modules/{InstanceId}/{ContactFlowModuleId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteContactFlowModuleInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteContactFlowModuleInput(v *DeleteContactFlowModuleInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ContactFlowModuleId == nil || len(*v.ContactFlowModuleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ContactFlowModuleId must not be empty")}
	}
	if v.ContactFlowModuleId != nil {
		if err := encoder.SetURI("ContactFlowModuleId").String(*v.ContactFlowModuleId); err != nil {
			return err
		}
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteHoursOfOperation struct {
}

func (*awsRestjson1_serializeOpDeleteHoursOfOperation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteHoursOfOperation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteHoursOfOperationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/hours-of-operations/{InstanceId}/{HoursOfOperationId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteHoursOfOperationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteHoursOfOperationInput(v *DeleteHoursOfOperationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.HoursOfOperationId == nil || len(*v.HoursOfOperationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member HoursOfOperationId must not be empty")}
	}
	if v.HoursOfOperationId != nil {
		if err := encoder.SetURI("HoursOfOperationId").String(*v.HoursOfOperationId); err != nil {
			return err
		}
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteInstance struct {
}

func (*awsRestjson1_serializeOpDeleteInstance) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteInstance) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteInstanceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/instance/{InstanceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteInstanceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteInstanceInput(v *DeleteInstanceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteIntegrationAssociation struct {
}

func (*awsRestjson1_serializeOpDeleteIntegrationAssociation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteIntegrationAssociation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteIntegrationAssociationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/instance/{InstanceId}/integration-associations/{IntegrationAssociationId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteIntegrationAssociationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteIntegrationAssociationInput(v *DeleteIntegrationAssociationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.IntegrationAssociationId == nil || len(*v.IntegrationAssociationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IntegrationAssociationId must not be empty")}
	}
	if v.IntegrationAssociationId != nil {
		if err := encoder.SetURI("IntegrationAssociationId").String(*v.IntegrationAssociationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteQuickConnect struct {
}

func (*awsRestjson1_serializeOpDeleteQuickConnect) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteQuickConnect) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteQuickConnectInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/quick-connects/{InstanceId}/{QuickConnectId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteQuickConnectInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteQuickConnectInput(v *DeleteQuickConnectInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.QuickConnectId == nil || len(*v.QuickConnectId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member QuickConnectId must not be empty")}
	}
	if v.QuickConnectId != nil {
		if err := encoder.SetURI("QuickConnectId").String(*v.QuickConnectId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteSecurityProfile struct {
}

func (*awsRestjson1_serializeOpDeleteSecurityProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteSecurityProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteSecurityProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/security-profiles/{InstanceId}/{SecurityProfileId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteSecurityProfileInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteSecurityProfileInput(v *DeleteSecurityProfileInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.SecurityProfileId == nil || len(*v.SecurityProfileId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member SecurityProfileId must not be empty")}
	}
	if v.SecurityProfileId != nil {
		if err := encoder.SetURI("SecurityProfileId").String(*v.SecurityProfileId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteUseCase struct {
}

func (*awsRestjson1_serializeOpDeleteUseCase) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteUseCase) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteUseCaseInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/instance/{InstanceId}/integration-associations/{IntegrationAssociationId}/use-cases/{UseCaseId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteUseCaseInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteUseCaseInput(v *DeleteUseCaseInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.IntegrationAssociationId == nil || len(*v.IntegrationAssociationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IntegrationAssociationId must not be empty")}
	}
	if v.IntegrationAssociationId != nil {
		if err := encoder.SetURI("IntegrationAssociationId").String(*v.IntegrationAssociationId); err != nil {
			return err
		}
	}

	if v.UseCaseId == nil || len(*v.UseCaseId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member UseCaseId must not be empty")}
	}
	if v.UseCaseId != nil {
		if err := encoder.SetURI("UseCaseId").String(*v.UseCaseId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteUser struct {
}

func (*awsRestjson1_serializeOpDeleteUser) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteUser) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteUserInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/users/{InstanceId}/{UserId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteUserInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteUserInput(v *DeleteUserInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.UserId == nil || len(*v.UserId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member UserId must not be empty")}
	}
	if v.UserId != nil {
		if err := encoder.SetURI("UserId").String(*v.UserId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteUserHierarchyGroup struct {
}

func (*awsRestjson1_serializeOpDeleteUserHierarchyGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteUserHierarchyGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteUserHierarchyGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/user-hierarchy-groups/{InstanceId}/{HierarchyGroupId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteUserHierarchyGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteUserHierarchyGroupInput(v *DeleteUserHierarchyGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.HierarchyGroupId == nil || len(*v.HierarchyGroupId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member HierarchyGroupId must not be empty")}
	}
	if v.HierarchyGroupId != nil {
		if err := encoder.SetURI("HierarchyGroupId").String(*v.HierarchyGroupId); err != nil {
			return err
		}
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeAgentStatus struct {
}

func (*awsRestjson1_serializeOpDescribeAgentStatus) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeAgentStatus) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAgentStatusInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/agent-status/{InstanceId}/{AgentStatusId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeAgentStatusInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeAgentStatusInput(v *DescribeAgentStatusInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AgentStatusId == nil || len(*v.AgentStatusId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AgentStatusId must not be empty")}
	}
	if v.AgentStatusId != nil {
		if err := encoder.SetURI("AgentStatusId").String(*v.AgentStatusId); err != nil {
			return err
		}
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeContact struct {
}

func (*awsRestjson1_serializeOpDescribeContact) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeContact) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeContactInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/contacts/{InstanceId}/{ContactId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeContactInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeContactInput(v *DescribeContactInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ContactId == nil || len(*v.ContactId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ContactId must not be empty")}
	}
	if v.ContactId != nil {
		if err := encoder.SetURI("ContactId").String(*v.ContactId); err != nil {
			return err
		}
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeContactFlow struct {
}

func (*awsRestjson1_serializeOpDescribeContactFlow) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeContactFlow) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeContactFlowInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/contact-flows/{InstanceId}/{ContactFlowId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeContactFlowInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeContactFlowInput(v *DescribeContactFlowInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ContactFlowId == nil || len(*v.ContactFlowId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ContactFlowId must not be empty")}
	}
	if v.ContactFlowId != nil {
		if err := encoder.SetURI("ContactFlowId").String(*v.ContactFlowId); err != nil {
			return err
		}
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeContactFlowModule struct {
}

func (*awsRestjson1_serializeOpDescribeContactFlowModule) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeContactFlowModule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeContactFlowModuleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/contact-flow-modules/{InstanceId}/{ContactFlowModuleId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeContactFlowModuleInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeContactFlowModuleInput(v *DescribeContactFlowModuleInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ContactFlowModuleId == nil || len(*v.ContactFlowModuleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ContactFlowModuleId must not be empty")}
	}
	if v.ContactFlowModuleId != nil {
		if err := encoder.SetURI("ContactFlowModuleId").String(*v.ContactFlowModuleId); err != nil {
			return err
		}
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeHoursOfOperation struct {
}

func (*awsRestjson1_serializeOpDescribeHoursOfOperation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeHoursOfOperation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeHoursOfOperationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/hours-of-operations/{InstanceId}/{HoursOfOperationId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeHoursOfOperationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeHoursOfOperationInput(v *DescribeHoursOfOperationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.HoursOfOperationId == nil || len(*v.HoursOfOperationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member HoursOfOperationId must not be empty")}
	}
	if v.HoursOfOperationId != nil {
		if err := encoder.SetURI("HoursOfOperationId").String(*v.HoursOfOperationId); err != nil {
			return err
		}
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeInstance struct {
}

func (*awsRestjson1_serializeOpDescribeInstance) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeInstance) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeInstanceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/instance/{InstanceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeInstanceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeInstanceInput(v *DescribeInstanceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeInstanceAttribute struct {
}

func (*awsRestjson1_serializeOpDescribeInstanceAttribute) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeInstanceAttribute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeInstanceAttributeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/instance/{InstanceId}/attribute/{AttributeType}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeInstanceAttributeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeInstanceAttributeInput(v *DescribeInstanceAttributeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.AttributeType) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AttributeType must not be empty")}
	}
	if len(v.AttributeType) > 0 {
		if err := encoder.SetURI("AttributeType").String(string(v.AttributeType)); err != nil {
			return err
		}
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeInstanceStorageConfig struct {
}

func (*awsRestjson1_serializeOpDescribeInstanceStorageConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeInstanceStorageConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeInstanceStorageConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/instance/{InstanceId}/storage-config/{AssociationId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeInstanceStorageConfigInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeInstanceStorageConfigInput(v *DescribeInstanceStorageConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AssociationId == nil || len(*v.AssociationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AssociationId must not be empty")}
	}
	if v.AssociationId != nil {
		if err := encoder.SetURI("AssociationId").String(*v.AssociationId); err != nil {
			return err
		}
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if len(v.ResourceType) > 0 {
		encoder.SetQuery("resourceType").String(string(v.ResourceType))
	}

	return nil
}

type awsRestjson1_serializeOpDescribeQueue struct {
}

func (*awsRestjson1_serializeOpDescribeQueue) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeQueue) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeQueueInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/queues/{InstanceId}/{QueueId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeQueueInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeQueueInput(v *DescribeQueueInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member QueueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("QueueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeQuickConnect struct {
}

func (*awsRestjson1_serializeOpDescribeQuickConnect) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeQuickConnect) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeQuickConnectInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/quick-connects/{InstanceId}/{QuickConnectId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeQuickConnectInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeQuickConnectInput(v *DescribeQuickConnectInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.QuickConnectId == nil || len(*v.QuickConnectId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member QuickConnectId must not be empty")}
	}
	if v.QuickConnectId != nil {
		if err := encoder.SetURI("QuickConnectId").String(*v.QuickConnectId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeRoutingProfile struct {
}

func (*awsRestjson1_serializeOpDescribeRoutingProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeRoutingProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeRoutingProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/routing-profiles/{InstanceId}/{RoutingProfileId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeRoutingProfileInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeRoutingProfileInput(v *DescribeRoutingProfileInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.RoutingProfileId == nil || len(*v.RoutingProfileId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member RoutingProfileId must not be empty")}
	}
	if v.RoutingProfileId != nil {
		if err := encoder.SetURI("RoutingProfileId").String(*v.RoutingProfileId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeSecurityProfile struct {
}

func (*awsRestjson1_serializeOpDescribeSecurityProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeSecurityProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeSecurityProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/security-profiles/{InstanceId}/{SecurityProfileId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeSecurityProfileInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeSecurityProfileInput(v *DescribeSecurityProfileInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.SecurityProfileId == nil || len(*v.SecurityProfileId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member SecurityProfileId must not be empty")}
	}
	if v.SecurityProfileId != nil {
		if err := encoder.SetURI("SecurityProfileId").String(*v.SecurityProfileId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeUser struct {
}

func (*awsRestjson1_serializeOpDescribeUser) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeUser) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeUserInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/users/{InstanceId}/{UserId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeUserInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeUserInput(v *DescribeUserInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.UserId == nil || len(*v.UserId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member UserId must not be empty")}
	}
	if v.UserId != nil {
		if err := encoder.SetURI("UserId").String(*v.UserId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeUserHierarchyGroup struct {
}

func (*awsRestjson1_serializeOpDescribeUserHierarchyGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeUserHierarchyGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeUserHierarchyGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/user-hierarchy-groups/{InstanceId}/{HierarchyGroupId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeUserHierarchyGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeUserHierarchyGroupInput(v *DescribeUserHierarchyGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.HierarchyGroupId == nil || len(*v.HierarchyGroupId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member HierarchyGroupId must not be empty")}
	}
	if v.HierarchyGroupId != nil {
		if err := encoder.SetURI("HierarchyGroupId").String(*v.HierarchyGroupId); err != nil {
			return err
		}
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeUserHierarchyStructure struct {
}

func (*awsRestjson1_serializeOpDescribeUserHierarchyStructure) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeUserHierarchyStructure) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeUserHierarchyStructureInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/user-hierarchy-structure/{InstanceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeUserHierarchyStructureInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeUserHierarchyStructureInput(v *DescribeUserHierarchyStructureInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDisassociateApprovedOrigin struct {
}

func (*awsRestjson1_serializeOpDisassociateApprovedOrigin) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDisassociateApprovedOrigin) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisassociateApprovedOriginInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/instance/{InstanceId}/approved-origin")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDisassociateApprovedOriginInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDisassociateApprovedOriginInput(v *DisassociateApprovedOriginInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.Origin != nil {
		encoder.SetQuery("origin").String(*v.Origin)
	}

	return nil
}

type awsRestjson1_serializeOpDisassociateBot struct {
}

func (*awsRestjson1_serializeOpDisassociateBot) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDisassociateBot) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisassociateBotInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/instance/{InstanceId}/bot")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDisassociateBotInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDisassociateBotInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDisassociateBotInput(v *DisassociateBotInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDisassociateBotInput(v *DisassociateBotInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LexBot != nil {
		ok := object.Key("LexBot")
		if err := awsRestjson1_serializeDocumentLexBot(v.LexBot, ok); err != nil {
			return err
		}
	}

	if v.LexV2Bot != nil {
		ok := object.Key("LexV2Bot")
		if err := awsRestjson1_serializeDocumentLexV2Bot(v.LexV2Bot, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDisassociateInstanceStorageConfig struct {
}

func (*awsRestjson1_serializeOpDisassociateInstanceStorageConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDisassociateInstanceStorageConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisassociateInstanceStorageConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/instance/{InstanceId}/storage-config/{AssociationId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDisassociateInstanceStorageConfigInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDisassociateInstanceStorageConfigInput(v *DisassociateInstanceStorageConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AssociationId == nil || len(*v.AssociationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AssociationId must not be empty")}
	}
	if v.AssociationId != nil {
		if err := encoder.SetURI("AssociationId").String(*v.AssociationId); err != nil {
			return err
		}
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if len(v.ResourceType) > 0 {
		encoder.SetQuery("resourceType").String(string(v.ResourceType))
	}

	return nil
}

type awsRestjson1_serializeOpDisassociateLambdaFunction struct {
}

func (*awsRestjson1_serializeOpDisassociateLambdaFunction) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDisassociateLambdaFunction) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisassociateLambdaFunctionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/instance/{InstanceId}/lambda-function")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDisassociateLambdaFunctionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDisassociateLambdaFunctionInput(v *DisassociateLambdaFunctionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FunctionArn != nil {
		encoder.SetQuery("functionArn").String(*v.FunctionArn)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDisassociateLexBot struct {
}

func (*awsRestjson1_serializeOpDisassociateLexBot) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDisassociateLexBot) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisassociateLexBotInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/instance/{InstanceId}/lex-bot")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDisassociateLexBotInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDisassociateLexBotInput(v *DisassociateLexBotInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotName != nil {
		encoder.SetQuery("botName").String(*v.BotName)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.LexRegion != nil {
		encoder.SetQuery("lexRegion").String(*v.LexRegion)
	}

	return nil
}

type awsRestjson1_serializeOpDisassociateQueueQuickConnects struct {
}

func (*awsRestjson1_serializeOpDisassociateQueueQuickConnects) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDisassociateQueueQuickConnects) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisassociateQueueQuickConnectsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/queues/{InstanceId}/{QueueId}/disassociate-quick-connects")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDisassociateQueueQuickConnectsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDisassociateQueueQuickConnectsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDisassociateQueueQuickConnectsInput(v *DisassociateQueueQuickConnectsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member QueueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("QueueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDisassociateQueueQuickConnectsInput(v *DisassociateQueueQuickConnectsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.QuickConnectIds != nil {
		ok := object.Key("QuickConnectIds")
		if err := awsRestjson1_serializeDocumentQuickConnectsList(v.QuickConnectIds, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDisassociateRoutingProfileQueues struct {
}

func (*awsRestjson1_serializeOpDisassociateRoutingProfileQueues) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDisassociateRoutingProfileQueues) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisassociateRoutingProfileQueuesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/routing-profiles/{InstanceId}/{RoutingProfileId}/disassociate-queues")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDisassociateRoutingProfileQueuesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDisassociateRoutingProfileQueuesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDisassociateRoutingProfileQueuesInput(v *DisassociateRoutingProfileQueuesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.RoutingProfileId == nil || len(*v.RoutingProfileId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member RoutingProfileId must not be empty")}
	}
	if v.RoutingProfileId != nil {
		if err := encoder.SetURI("RoutingProfileId").String(*v.RoutingProfileId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDisassociateRoutingProfileQueuesInput(v *DisassociateRoutingProfileQueuesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.QueueReferences != nil {
		ok := object.Key("QueueReferences")
		if err := awsRestjson1_serializeDocumentRoutingProfileQueueReferenceList(v.QueueReferences, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDisassociateSecurityKey struct {
}

func (*awsRestjson1_serializeOpDisassociateSecurityKey) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDisassociateSecurityKey) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisassociateSecurityKeyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/instance/{InstanceId}/security-key/{AssociationId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDisassociateSecurityKeyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDisassociateSecurityKeyInput(v *DisassociateSecurityKeyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AssociationId == nil || len(*v.AssociationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AssociationId must not be empty")}
	}
	if v.AssociationId != nil {
		if err := encoder.SetURI("AssociationId").String(*v.AssociationId); err != nil {
			return err
		}
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetContactAttributes struct {
}

func (*awsRestjson1_serializeOpGetContactAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetContactAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetContactAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/contact/attributes/{InstanceId}/{InitialContactId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetContactAttributesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetContactAttributesInput(v *GetContactAttributesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InitialContactId == nil || len(*v.InitialContactId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InitialContactId must not be empty")}
	}
	if v.InitialContactId != nil {
		if err := encoder.SetURI("InitialContactId").String(*v.InitialContactId); err != nil {
			return err
		}
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetCurrentMetricData struct {
}

func (*awsRestjson1_serializeOpGetCurrentMetricData) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetCurrentMetricData) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetCurrentMetricDataInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/metrics/current/{InstanceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetCurrentMetricDataInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGetCurrentMetricDataInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetCurrentMetricDataInput(v *GetCurrentMetricDataInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGetCurrentMetricDataInput(v *GetCurrentMetricDataInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CurrentMetrics != nil {
		ok := object.Key("CurrentMetrics")
		if err := awsRestjson1_serializeDocumentCurrentMetrics(v.CurrentMetrics, ok); err != nil {
			return err
		}
	}

	if v.Filters != nil {
		ok := object.Key("Filters")
		if err := awsRestjson1_serializeDocumentFilters(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.Groupings != nil {
		ok := object.Key("Groupings")
		if err := awsRestjson1_serializeDocumentGroupings(v.Groupings, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		ok := object.Key("MaxResults")
		ok.Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpGetFederationToken struct {
}

func (*awsRestjson1_serializeOpGetFederationToken) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetFederationToken) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetFederationTokenInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/user/federate/{InstanceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetFederationTokenInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetFederationTokenInput(v *GetFederationTokenInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetMetricData struct {
}

func (*awsRestjson1_serializeOpGetMetricData) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetMetricData) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetMetricDataInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/metrics/historical/{InstanceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetMetricDataInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGetMetricDataInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetMetricDataInput(v *GetMetricDataInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGetMetricDataInput(v *GetMetricDataInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EndTime != nil {
		ok := object.Key("EndTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.EndTime))
	}

	if v.Filters != nil {
		ok := object.Key("Filters")
		if err := awsRestjson1_serializeDocumentFilters(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.Groupings != nil {
		ok := object.Key("Groupings")
		if err := awsRestjson1_serializeDocumentGroupings(v.Groupings, ok); err != nil {
			return err
		}
	}

	if v.HistoricalMetrics != nil {
		ok := object.Key("HistoricalMetrics")
		if err := awsRestjson1_serializeDocumentHistoricalMetrics(v.HistoricalMetrics, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		ok := object.Key("MaxResults")
		ok.Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.StartTime != nil {
		ok := object.Key("StartTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.StartTime))
	}

	return nil
}

type awsRestjson1_serializeOpListAgentStatuses struct {
}

func (*awsRestjson1_serializeOpListAgentStatuses) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListAgentStatuses) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListAgentStatusesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/agent-status/{InstanceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListAgentStatusesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListAgentStatusesInput(v *ListAgentStatusesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AgentStatusTypes != nil {
		for i := range v.AgentStatusTypes {
			encoder.AddQuery("AgentStatusTypes").String(string(v.AgentStatusTypes[i]))
		}
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListApprovedOrigins struct {
}

func (*awsRestjson1_serializeOpListApprovedOrigins) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListApprovedOrigins) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListApprovedOriginsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/instance/{InstanceId}/approved-origins")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListApprovedOriginsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListApprovedOriginsInput(v *ListApprovedOriginsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListBots struct {
}

func (*awsRestjson1_serializeOpListBots) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListBots) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListBotsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/instance/{InstanceId}/bots")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListBotsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListBotsInput(v *ListBotsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if len(v.LexVersion) > 0 {
		encoder.SetQuery("lexVersion").String(string(v.LexVersion))
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListContactFlowModules struct {
}

func (*awsRestjson1_serializeOpListContactFlowModules) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListContactFlowModules) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListContactFlowModulesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/contact-flow-modules-summary/{InstanceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListContactFlowModulesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListContactFlowModulesInput(v *ListContactFlowModulesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.ContactFlowModuleState) > 0 {
		encoder.SetQuery("state").String(string(v.ContactFlowModuleState))
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListContactFlows struct {
}

func (*awsRestjson1_serializeOpListContactFlows) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListContactFlows) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListContactFlowsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/contact-flows-summary/{InstanceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListContactFlowsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListContactFlowsInput(v *ListContactFlowsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ContactFlowTypes != nil {
		for i := range v.ContactFlowTypes {
			encoder.AddQuery("contactFlowTypes").String(string(v.ContactFlowTypes[i]))
		}
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListContactReferences struct {
}

func (*awsRestjson1_serializeOpListContactReferences) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListContactReferences) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListContactReferencesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/contact/references/{InstanceId}/{ContactId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListContactReferencesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListContactReferencesInput(v *ListContactReferencesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ContactId == nil || len(*v.ContactId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ContactId must not be empty")}
	}
	if v.ContactId != nil {
		if err := encoder.SetURI("ContactId").String(*v.ContactId); err != nil {
			return err
		}
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.ReferenceTypes != nil {
		for i := range v.ReferenceTypes {
			encoder.AddQuery("referenceTypes").String(string(v.ReferenceTypes[i]))
		}
	}

	return nil
}

type awsRestjson1_serializeOpListHoursOfOperations struct {
}

func (*awsRestjson1_serializeOpListHoursOfOperations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListHoursOfOperations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListHoursOfOperationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/hours-of-operations-summary/{InstanceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListHoursOfOperationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListHoursOfOperationsInput(v *ListHoursOfOperationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListInstanceAttributes struct {
}

func (*awsRestjson1_serializeOpListInstanceAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListInstanceAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListInstanceAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/instance/{InstanceId}/attributes")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListInstanceAttributesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListInstanceAttributesInput(v *ListInstanceAttributesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListInstances struct {
}

func (*awsRestjson1_serializeOpListInstances) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListInstances) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListInstancesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/instance")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListInstancesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListInstancesInput(v *ListInstancesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListInstanceStorageConfigs struct {
}

func (*awsRestjson1_serializeOpListInstanceStorageConfigs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListInstanceStorageConfigs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListInstanceStorageConfigsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/instance/{InstanceId}/storage-configs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListInstanceStorageConfigsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListInstanceStorageConfigsInput(v *ListInstanceStorageConfigsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if len(v.ResourceType) > 0 {
		encoder.SetQuery("resourceType").String(string(v.ResourceType))
	}

	return nil
}

type awsRestjson1_serializeOpListIntegrationAssociations struct {
}

func (*awsRestjson1_serializeOpListIntegrationAssociations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListIntegrationAssociations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListIntegrationAssociationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/instance/{InstanceId}/integration-associations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListIntegrationAssociationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListIntegrationAssociationsInput(v *ListIntegrationAssociationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if len(v.IntegrationType) > 0 {
		encoder.SetQuery("integrationType").String(string(v.IntegrationType))
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListLambdaFunctions struct {
}

func (*awsRestjson1_serializeOpListLambdaFunctions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListLambdaFunctions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListLambdaFunctionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/instance/{InstanceId}/lambda-functions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListLambdaFunctionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListLambdaFunctionsInput(v *ListLambdaFunctionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListLexBots struct {
}

func (*awsRestjson1_serializeOpListLexBots) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListLexBots) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListLexBotsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/instance/{InstanceId}/lex-bots")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListLexBotsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListLexBotsInput(v *ListLexBotsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListPhoneNumbers struct {
}

func (*awsRestjson1_serializeOpListPhoneNumbers) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListPhoneNumbers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListPhoneNumbersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/phone-numbers-summary/{InstanceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListPhoneNumbersInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListPhoneNumbersInput(v *ListPhoneNumbersInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.PhoneNumberCountryCodes != nil {
		for i := range v.PhoneNumberCountryCodes {
			encoder.AddQuery("phoneNumberCountryCodes").String(string(v.PhoneNumberCountryCodes[i]))
		}
	}

	if v.PhoneNumberTypes != nil {
		for i := range v.PhoneNumberTypes {
			encoder.AddQuery("phoneNumberTypes").String(string(v.PhoneNumberTypes[i]))
		}
	}

	return nil
}

type awsRestjson1_serializeOpListPrompts struct {
}

func (*awsRestjson1_serializeOpListPrompts) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListPrompts) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListPromptsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prompts-summary/{InstanceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListPromptsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListPromptsInput(v *ListPromptsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListQueueQuickConnects struct {
}

func (*awsRestjson1_serializeOpListQueueQuickConnects) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListQueueQuickConnects) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListQueueQuickConnectsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/queues/{InstanceId}/{QueueId}/quick-connects")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListQueueQuickConnectsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListQueueQuickConnectsInput(v *ListQueueQuickConnectsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member QueueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("QueueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListQueues struct {
}

func (*awsRestjson1_serializeOpListQueues) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListQueues) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListQueuesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/queues-summary/{InstanceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListQueuesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListQueuesInput(v *ListQueuesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.QueueTypes != nil {
		for i := range v.QueueTypes {
			encoder.AddQuery("queueTypes").String(string(v.QueueTypes[i]))
		}
	}

	return nil
}

type awsRestjson1_serializeOpListQuickConnects struct {
}

func (*awsRestjson1_serializeOpListQuickConnects) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListQuickConnects) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListQuickConnectsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/quick-connects/{InstanceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListQuickConnectsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListQuickConnectsInput(v *ListQuickConnectsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.QuickConnectTypes != nil {
		for i := range v.QuickConnectTypes {
			encoder.AddQuery("QuickConnectTypes").String(string(v.QuickConnectTypes[i]))
		}
	}

	return nil
}

type awsRestjson1_serializeOpListRoutingProfileQueues struct {
}

func (*awsRestjson1_serializeOpListRoutingProfileQueues) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListRoutingProfileQueues) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListRoutingProfileQueuesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/routing-profiles/{InstanceId}/{RoutingProfileId}/queues")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListRoutingProfileQueuesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListRoutingProfileQueuesInput(v *ListRoutingProfileQueuesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.RoutingProfileId == nil || len(*v.RoutingProfileId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member RoutingProfileId must not be empty")}
	}
	if v.RoutingProfileId != nil {
		if err := encoder.SetURI("RoutingProfileId").String(*v.RoutingProfileId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListRoutingProfiles struct {
}

func (*awsRestjson1_serializeOpListRoutingProfiles) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListRoutingProfiles) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListRoutingProfilesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/routing-profiles-summary/{InstanceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListRoutingProfilesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListRoutingProfilesInput(v *ListRoutingProfilesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListSecurityKeys struct {
}

func (*awsRestjson1_serializeOpListSecurityKeys) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListSecurityKeys) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListSecurityKeysInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/instance/{InstanceId}/security-keys")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListSecurityKeysInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListSecurityKeysInput(v *ListSecurityKeysInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListSecurityProfilePermissions struct {
}

func (*awsRestjson1_serializeOpListSecurityProfilePermissions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListSecurityProfilePermissions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListSecurityProfilePermissionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/security-profiles-permissions/{InstanceId}/{SecurityProfileId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListSecurityProfilePermissionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListSecurityProfilePermissionsInput(v *ListSecurityProfilePermissionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.SecurityProfileId == nil || len(*v.SecurityProfileId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member SecurityProfileId must not be empty")}
	}
	if v.SecurityProfileId != nil {
		if err := encoder.SetURI("SecurityProfileId").String(*v.SecurityProfileId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListSecurityProfiles struct {
}

func (*awsRestjson1_serializeOpListSecurityProfiles) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListSecurityProfiles) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListSecurityProfilesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/security-profiles-summary/{InstanceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListSecurityProfilesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListSecurityProfilesInput(v *ListSecurityProfilesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListUseCases struct {
}

func (*awsRestjson1_serializeOpListUseCases) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListUseCases) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListUseCasesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/instance/{InstanceId}/integration-associations/{IntegrationAssociationId}/use-cases")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListUseCasesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListUseCasesInput(v *ListUseCasesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.IntegrationAssociationId == nil || len(*v.IntegrationAssociationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IntegrationAssociationId must not be empty")}
	}
	if v.IntegrationAssociationId != nil {
		if err := encoder.SetURI("IntegrationAssociationId").String(*v.IntegrationAssociationId); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListUserHierarchyGroups struct {
}

func (*awsRestjson1_serializeOpListUserHierarchyGroups) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListUserHierarchyGroups) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListUserHierarchyGroupsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/user-hierarchy-groups-summary/{InstanceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListUserHierarchyGroupsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListUserHierarchyGroupsInput(v *ListUserHierarchyGroupsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListUsers struct {
}

func (*awsRestjson1_serializeOpListUsers) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListUsers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListUsersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/users-summary/{InstanceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListUsersInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListUsersInput(v *ListUsersInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpResumeContactRecording struct {
}

func (*awsRestjson1_serializeOpResumeContactRecording) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpResumeContactRecording) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ResumeContactRecordingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/contact/resume-recording")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentResumeContactRecordingInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsResumeContactRecordingInput(v *ResumeContactRecordingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentResumeContactRecordingInput(v *ResumeContactRecordingInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContactId != nil {
		ok := object.Key("ContactId")
		ok.String(*v.ContactId)
	}

	if v.InitialContactId != nil {
		ok := object.Key("InitialContactId")
		ok.String(*v.InitialContactId)
	}

	if v.InstanceId != nil {
		ok := object.Key("InstanceId")
		ok.String(*v.InstanceId)
	}

	return nil
}

type awsRestjson1_serializeOpStartChatContact struct {
}

func (*awsRestjson1_serializeOpStartChatContact) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartChatContact) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartChatContactInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/contact/chat")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStartChatContactInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartChatContactInput(v *StartChatContactInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStartChatContactInput(v *StartChatContactInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Attributes != nil {
		ok := object.Key("Attributes")
		if err := awsRestjson1_serializeDocumentAttributes(v.Attributes, ok); err != nil {
			return err
		}
	}

	if v.ClientToken != nil {
		ok := object.Key("ClientToken")
		ok.String(*v.ClientToken)
	}

	if v.ContactFlowId != nil {
		ok := object.Key("ContactFlowId")
		ok.String(*v.ContactFlowId)
	}

	if v.InitialMessage != nil {
		ok := object.Key("InitialMessage")
		if err := awsRestjson1_serializeDocumentChatMessage(v.InitialMessage, ok); err != nil {
			return err
		}
	}

	if v.InstanceId != nil {
		ok := object.Key("InstanceId")
		ok.String(*v.InstanceId)
	}

	if v.ParticipantDetails != nil {
		ok := object.Key("ParticipantDetails")
		if err := awsRestjson1_serializeDocumentParticipantDetails(v.ParticipantDetails, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStartContactRecording struct {
}

func (*awsRestjson1_serializeOpStartContactRecording) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartContactRecording) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartContactRecordingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/contact/start-recording")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStartContactRecordingInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartContactRecordingInput(v *StartContactRecordingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStartContactRecordingInput(v *StartContactRecordingInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContactId != nil {
		ok := object.Key("ContactId")
		ok.String(*v.ContactId)
	}

	if v.InitialContactId != nil {
		ok := object.Key("InitialContactId")
		ok.String(*v.InitialContactId)
	}

	if v.InstanceId != nil {
		ok := object.Key("InstanceId")
		ok.String(*v.InstanceId)
	}

	if v.VoiceRecordingConfiguration != nil {
		ok := object.Key("VoiceRecordingConfiguration")
		if err := awsRestjson1_serializeDocumentVoiceRecordingConfiguration(v.VoiceRecordingConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStartContactStreaming struct {
}

func (*awsRestjson1_serializeOpStartContactStreaming) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartContactStreaming) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartContactStreamingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/contact/start-streaming")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStartContactStreamingInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartContactStreamingInput(v *StartContactStreamingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStartContactStreamingInput(v *StartContactStreamingInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ChatStreamingConfiguration != nil {
		ok := object.Key("ChatStreamingConfiguration")
		if err := awsRestjson1_serializeDocumentChatStreamingConfiguration(v.ChatStreamingConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ClientToken != nil {
		ok := object.Key("ClientToken")
		ok.String(*v.ClientToken)
	}

	if v.ContactId != nil {
		ok := object.Key("ContactId")
		ok.String(*v.ContactId)
	}

	if v.InstanceId != nil {
		ok := object.Key("InstanceId")
		ok.String(*v.InstanceId)
	}

	return nil
}

type awsRestjson1_serializeOpStartOutboundVoiceContact struct {
}

func (*awsRestjson1_serializeOpStartOutboundVoiceContact) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartOutboundVoiceContact) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartOutboundVoiceContactInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/contact/outbound-voice")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStartOutboundVoiceContactInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartOutboundVoiceContactInput(v *StartOutboundVoiceContactInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStartOutboundVoiceContactInput(v *StartOutboundVoiceContactInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AnswerMachineDetectionConfig != nil {
		ok := object.Key("AnswerMachineDetectionConfig")
		if err := awsRestjson1_serializeDocumentAnswerMachineDetectionConfig(v.AnswerMachineDetectionConfig, ok); err != nil {
			return err
		}
	}

	if v.Attributes != nil {
		ok := object.Key("Attributes")
		if err := awsRestjson1_serializeDocumentAttributes(v.Attributes, ok); err != nil {
			return err
		}
	}

	if v.CampaignId != nil {
		ok := object.Key("CampaignId")
		ok.String(*v.CampaignId)
	}

	if v.ClientToken != nil {
		ok := object.Key("ClientToken")
		ok.String(*v.ClientToken)
	}

	if v.ContactFlowId != nil {
		ok := object.Key("ContactFlowId")
		ok.String(*v.ContactFlowId)
	}

	if v.DestinationPhoneNumber != nil {
		ok := object.Key("DestinationPhoneNumber")
		ok.String(*v.DestinationPhoneNumber)
	}

	if v.InstanceId != nil {
		ok := object.Key("InstanceId")
		ok.String(*v.InstanceId)
	}

	if v.QueueId != nil {
		ok := object.Key("QueueId")
		ok.String(*v.QueueId)
	}

	if v.SourcePhoneNumber != nil {
		ok := object.Key("SourcePhoneNumber")
		ok.String(*v.SourcePhoneNumber)
	}

	if len(v.TrafficType) > 0 {
		ok := object.Key("TrafficType")
		ok.String(string(v.TrafficType))
	}

	return nil
}

type awsRestjson1_serializeOpStartTaskContact struct {
}

func (*awsRestjson1_serializeOpStartTaskContact) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartTaskContact) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartTaskContactInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/contact/task")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStartTaskContactInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartTaskContactInput(v *StartTaskContactInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStartTaskContactInput(v *StartTaskContactInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Attributes != nil {
		ok := object.Key("Attributes")
		if err := awsRestjson1_serializeDocumentAttributes(v.Attributes, ok); err != nil {
			return err
		}
	}

	if v.ClientToken != nil {
		ok := object.Key("ClientToken")
		ok.String(*v.ClientToken)
	}

	if v.ContactFlowId != nil {
		ok := object.Key("ContactFlowId")
		ok.String(*v.ContactFlowId)
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.InstanceId != nil {
		ok := object.Key("InstanceId")
		ok.String(*v.InstanceId)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.PreviousContactId != nil {
		ok := object.Key("PreviousContactId")
		ok.String(*v.PreviousContactId)
	}

	if v.References != nil {
		ok := object.Key("References")
		if err := awsRestjson1_serializeDocumentContactReferences(v.References, ok); err != nil {
			return err
		}
	}

	if v.ScheduledTime != nil {
		ok := object.Key("ScheduledTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.ScheduledTime))
	}

	return nil
}

type awsRestjson1_serializeOpStopContact struct {
}

func (*awsRestjson1_serializeOpStopContact) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStopContact) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopContactInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/contact/stop")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStopContactInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStopContactInput(v *StopContactInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStopContactInput(v *StopContactInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContactId != nil {
		ok := object.Key("ContactId")
		ok.String(*v.ContactId)
	}

	if v.InstanceId != nil {
		ok := object.Key("InstanceId")
		ok.String(*v.InstanceId)
	}

	return nil
}

type awsRestjson1_serializeOpStopContactRecording struct {
}

func (*awsRestjson1_serializeOpStopContactRecording) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStopContactRecording) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopContactRecordingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/contact/stop-recording")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStopContactRecordingInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStopContactRecordingInput(v *StopContactRecordingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStopContactRecordingInput(v *StopContactRecordingInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContactId != nil {
		ok := object.Key("ContactId")
		ok.String(*v.ContactId)
	}

	if v.InitialContactId != nil {
		ok := object.Key("InitialContactId")
		ok.String(*v.InitialContactId)
	}

	if v.InstanceId != nil {
		ok := object.Key("InstanceId")
		ok.String(*v.InstanceId)
	}

	return nil
}

type awsRestjson1_serializeOpStopContactStreaming struct {
}

func (*awsRestjson1_serializeOpStopContactStreaming) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStopContactStreaming) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopContactStreamingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/contact/stop-streaming")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStopContactStreamingInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStopContactStreamingInput(v *StopContactStreamingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStopContactStreamingInput(v *StopContactStreamingInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContactId != nil {
		ok := object.Key("ContactId")
		ok.String(*v.ContactId)
	}

	if v.InstanceId != nil {
		ok := object.Key("InstanceId")
		ok.String(*v.InstanceId)
	}

	if v.StreamingId != nil {
		ok := object.Key("StreamingId")
		ok.String(*v.StreamingId)
	}

	return nil
}

type awsRestjson1_serializeOpSuspendContactRecording struct {
}

func (*awsRestjson1_serializeOpSuspendContactRecording) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSuspendContactRecording) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SuspendContactRecordingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/contact/suspend-recording")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentSuspendContactRecordingInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSuspendContactRecordingInput(v *SuspendContactRecordingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentSuspendContactRecordingInput(v *SuspendContactRecordingInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContactId != nil {
		ok := object.Key("ContactId")
		ok.String(*v.ContactId)
	}

	if v.InitialContactId != nil {
		ok := object.Key("InitialContactId")
		ok.String(*v.InitialContactId)
	}

	if v.InstanceId != nil {
		ok := object.Key("InstanceId")
		ok.String(*v.InstanceId)
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUntagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	if v.TagKeys != nil {
		for i := range v.TagKeys {
			encoder.AddQuery("tagKeys").String(v.TagKeys[i])
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateAgentStatus struct {
}

func (*awsRestjson1_serializeOpUpdateAgentStatus) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateAgentStatus) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateAgentStatusInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/agent-status/{InstanceId}/{AgentStatusId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateAgentStatusInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateAgentStatusInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateAgentStatusInput(v *UpdateAgentStatusInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AgentStatusId == nil || len(*v.AgentStatusId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AgentStatusId must not be empty")}
	}
	if v.AgentStatusId != nil {
		if err := encoder.SetURI("AgentStatusId").String(*v.AgentStatusId); err != nil {
			return err
		}
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateAgentStatusInput(v *UpdateAgentStatusInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.DisplayOrder != nil {
		ok := object.Key("DisplayOrder")
		ok.Integer(*v.DisplayOrder)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.ResetOrderNumber {
		ok := object.Key("ResetOrderNumber")
		ok.Boolean(v.ResetOrderNumber)
	}

	if len(v.State) > 0 {
		ok := object.Key("State")
		ok.String(string(v.State))
	}

	return nil
}

type awsRestjson1_serializeOpUpdateContact struct {
}

func (*awsRestjson1_serializeOpUpdateContact) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateContact) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateContactInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/contacts/{InstanceId}/{ContactId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateContactInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateContactInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateContactInput(v *UpdateContactInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ContactId == nil || len(*v.ContactId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ContactId must not be empty")}
	}
	if v.ContactId != nil {
		if err := encoder.SetURI("ContactId").String(*v.ContactId); err != nil {
			return err
		}
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateContactInput(v *UpdateContactInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.References != nil {
		ok := object.Key("References")
		if err := awsRestjson1_serializeDocumentContactReferences(v.References, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateContactAttributes struct {
}

func (*awsRestjson1_serializeOpUpdateContactAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateContactAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateContactAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/contact/attributes")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateContactAttributesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateContactAttributesInput(v *UpdateContactAttributesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateContactAttributesInput(v *UpdateContactAttributesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Attributes != nil {
		ok := object.Key("Attributes")
		if err := awsRestjson1_serializeDocumentAttributes(v.Attributes, ok); err != nil {
			return err
		}
	}

	if v.InitialContactId != nil {
		ok := object.Key("InitialContactId")
		ok.String(*v.InitialContactId)
	}

	if v.InstanceId != nil {
		ok := object.Key("InstanceId")
		ok.String(*v.InstanceId)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateContactFlowContent struct {
}

func (*awsRestjson1_serializeOpUpdateContactFlowContent) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateContactFlowContent) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateContactFlowContentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/contact-flows/{InstanceId}/{ContactFlowId}/content")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateContactFlowContentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateContactFlowContentInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateContactFlowContentInput(v *UpdateContactFlowContentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ContactFlowId == nil || len(*v.ContactFlowId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ContactFlowId must not be empty")}
	}
	if v.ContactFlowId != nil {
		if err := encoder.SetURI("ContactFlowId").String(*v.ContactFlowId); err != nil {
			return err
		}
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateContactFlowContentInput(v *UpdateContactFlowContentInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Content != nil {
		ok := object.Key("Content")
		ok.String(*v.Content)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateContactFlowMetadata struct {
}

func (*awsRestjson1_serializeOpUpdateContactFlowMetadata) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateContactFlowMetadata) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateContactFlowMetadataInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/contact-flows/{InstanceId}/{ContactFlowId}/metadata")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateContactFlowMetadataInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateContactFlowMetadataInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateContactFlowMetadataInput(v *UpdateContactFlowMetadataInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ContactFlowId == nil || len(*v.ContactFlowId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ContactFlowId must not be empty")}
	}
	if v.ContactFlowId != nil {
		if err := encoder.SetURI("ContactFlowId").String(*v.ContactFlowId); err != nil {
			return err
		}
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateContactFlowMetadataInput(v *UpdateContactFlowMetadataInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ContactFlowState) > 0 {
		ok := object.Key("ContactFlowState")
		ok.String(string(v.ContactFlowState))
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateContactFlowModuleContent struct {
}

func (*awsRestjson1_serializeOpUpdateContactFlowModuleContent) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateContactFlowModuleContent) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateContactFlowModuleContentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/contact-flow-modules/{InstanceId}/{ContactFlowModuleId}/content")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateContactFlowModuleContentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateContactFlowModuleContentInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateContactFlowModuleContentInput(v *UpdateContactFlowModuleContentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ContactFlowModuleId == nil || len(*v.ContactFlowModuleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ContactFlowModuleId must not be empty")}
	}
	if v.ContactFlowModuleId != nil {
		if err := encoder.SetURI("ContactFlowModuleId").String(*v.ContactFlowModuleId); err != nil {
			return err
		}
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateContactFlowModuleContentInput(v *UpdateContactFlowModuleContentInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Content != nil {
		ok := object.Key("Content")
		ok.String(*v.Content)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateContactFlowModuleMetadata struct {
}

func (*awsRestjson1_serializeOpUpdateContactFlowModuleMetadata) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateContactFlowModuleMetadata) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateContactFlowModuleMetadataInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/contact-flow-modules/{InstanceId}/{ContactFlowModuleId}/metadata")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateContactFlowModuleMetadataInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateContactFlowModuleMetadataInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateContactFlowModuleMetadataInput(v *UpdateContactFlowModuleMetadataInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ContactFlowModuleId == nil || len(*v.ContactFlowModuleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ContactFlowModuleId must not be empty")}
	}
	if v.ContactFlowModuleId != nil {
		if err := encoder.SetURI("ContactFlowModuleId").String(*v.ContactFlowModuleId); err != nil {
			return err
		}
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateContactFlowModuleMetadataInput(v *UpdateContactFlowModuleMetadataInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if len(v.State) > 0 {
		ok := object.Key("State")
		ok.String(string(v.State))
	}

	return nil
}

type awsRestjson1_serializeOpUpdateContactFlowName struct {
}

func (*awsRestjson1_serializeOpUpdateContactFlowName) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateContactFlowName) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateContactFlowNameInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/contact-flows/{InstanceId}/{ContactFlowId}/name")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateContactFlowNameInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateContactFlowNameInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateContactFlowNameInput(v *UpdateContactFlowNameInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ContactFlowId == nil || len(*v.ContactFlowId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ContactFlowId must not be empty")}
	}
	if v.ContactFlowId != nil {
		if err := encoder.SetURI("ContactFlowId").String(*v.ContactFlowId); err != nil {
			return err
		}
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateContactFlowNameInput(v *UpdateContactFlowNameInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateContactSchedule struct {
}

func (*awsRestjson1_serializeOpUpdateContactSchedule) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateContactSchedule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateContactScheduleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/contact/schedule")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateContactScheduleInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateContactScheduleInput(v *UpdateContactScheduleInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateContactScheduleInput(v *UpdateContactScheduleInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContactId != nil {
		ok := object.Key("ContactId")
		ok.String(*v.ContactId)
	}

	if v.InstanceId != nil {
		ok := object.Key("InstanceId")
		ok.String(*v.InstanceId)
	}

	if v.ScheduledTime != nil {
		ok := object.Key("ScheduledTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.ScheduledTime))
	}

	return nil
}

type awsRestjson1_serializeOpUpdateHoursOfOperation struct {
}

func (*awsRestjson1_serializeOpUpdateHoursOfOperation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateHoursOfOperation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateHoursOfOperationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/hours-of-operations/{InstanceId}/{HoursOfOperationId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateHoursOfOperationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateHoursOfOperationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateHoursOfOperationInput(v *UpdateHoursOfOperationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.HoursOfOperationId == nil || len(*v.HoursOfOperationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member HoursOfOperationId must not be empty")}
	}
	if v.HoursOfOperationId != nil {
		if err := encoder.SetURI("HoursOfOperationId").String(*v.HoursOfOperationId); err != nil {
			return err
		}
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateHoursOfOperationInput(v *UpdateHoursOfOperationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Config != nil {
		ok := object.Key("Config")
		if err := awsRestjson1_serializeDocumentHoursOfOperationConfigList(v.Config, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.TimeZone != nil {
		ok := object.Key("TimeZone")
		ok.String(*v.TimeZone)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateInstanceAttribute struct {
}

func (*awsRestjson1_serializeOpUpdateInstanceAttribute) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateInstanceAttribute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateInstanceAttributeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/instance/{InstanceId}/attribute/{AttributeType}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateInstanceAttributeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateInstanceAttributeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateInstanceAttributeInput(v *UpdateInstanceAttributeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.AttributeType) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AttributeType must not be empty")}
	}
	if len(v.AttributeType) > 0 {
		if err := encoder.SetURI("AttributeType").String(string(v.AttributeType)); err != nil {
			return err
		}
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateInstanceAttributeInput(v *UpdateInstanceAttributeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateInstanceStorageConfig struct {
}

func (*awsRestjson1_serializeOpUpdateInstanceStorageConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateInstanceStorageConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateInstanceStorageConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/instance/{InstanceId}/storage-config/{AssociationId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateInstanceStorageConfigInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateInstanceStorageConfigInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateInstanceStorageConfigInput(v *UpdateInstanceStorageConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AssociationId == nil || len(*v.AssociationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AssociationId must not be empty")}
	}
	if v.AssociationId != nil {
		if err := encoder.SetURI("AssociationId").String(*v.AssociationId); err != nil {
			return err
		}
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if len(v.ResourceType) > 0 {
		encoder.SetQuery("resourceType").String(string(v.ResourceType))
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateInstanceStorageConfigInput(v *UpdateInstanceStorageConfigInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.StorageConfig != nil {
		ok := object.Key("StorageConfig")
		if err := awsRestjson1_serializeDocumentInstanceStorageConfig(v.StorageConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateQueueHoursOfOperation struct {
}

func (*awsRestjson1_serializeOpUpdateQueueHoursOfOperation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateQueueHoursOfOperation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateQueueHoursOfOperationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/queues/{InstanceId}/{QueueId}/hours-of-operation")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateQueueHoursOfOperationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateQueueHoursOfOperationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateQueueHoursOfOperationInput(v *UpdateQueueHoursOfOperationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member QueueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("QueueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateQueueHoursOfOperationInput(v *UpdateQueueHoursOfOperationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.HoursOfOperationId != nil {
		ok := object.Key("HoursOfOperationId")
		ok.String(*v.HoursOfOperationId)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateQueueMaxContacts struct {
}

func (*awsRestjson1_serializeOpUpdateQueueMaxContacts) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateQueueMaxContacts) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateQueueMaxContactsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/queues/{InstanceId}/{QueueId}/max-contacts")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateQueueMaxContactsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateQueueMaxContactsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateQueueMaxContactsInput(v *UpdateQueueMaxContactsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member QueueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("QueueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateQueueMaxContactsInput(v *UpdateQueueMaxContactsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxContacts != 0 {
		ok := object.Key("MaxContacts")
		ok.Integer(v.MaxContacts)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateQueueName struct {
}

func (*awsRestjson1_serializeOpUpdateQueueName) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateQueueName) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateQueueNameInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/queues/{InstanceId}/{QueueId}/name")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateQueueNameInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateQueueNameInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateQueueNameInput(v *UpdateQueueNameInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member QueueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("QueueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateQueueNameInput(v *UpdateQueueNameInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateQueueOutboundCallerConfig struct {
}

func (*awsRestjson1_serializeOpUpdateQueueOutboundCallerConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateQueueOutboundCallerConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateQueueOutboundCallerConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/queues/{InstanceId}/{QueueId}/outbound-caller-config")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateQueueOutboundCallerConfigInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateQueueOutboundCallerConfigInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateQueueOutboundCallerConfigInput(v *UpdateQueueOutboundCallerConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member QueueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("QueueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateQueueOutboundCallerConfigInput(v *UpdateQueueOutboundCallerConfigInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.OutboundCallerConfig != nil {
		ok := object.Key("OutboundCallerConfig")
		if err := awsRestjson1_serializeDocumentOutboundCallerConfig(v.OutboundCallerConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateQueueStatus struct {
}

func (*awsRestjson1_serializeOpUpdateQueueStatus) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateQueueStatus) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateQueueStatusInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/queues/{InstanceId}/{QueueId}/status")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateQueueStatusInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateQueueStatusInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateQueueStatusInput(v *UpdateQueueStatusInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member QueueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("QueueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateQueueStatusInput(v *UpdateQueueStatusInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Status) > 0 {
		ok := object.Key("Status")
		ok.String(string(v.Status))
	}

	return nil
}

type awsRestjson1_serializeOpUpdateQuickConnectConfig struct {
}

func (*awsRestjson1_serializeOpUpdateQuickConnectConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateQuickConnectConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateQuickConnectConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/quick-connects/{InstanceId}/{QuickConnectId}/config")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateQuickConnectConfigInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateQuickConnectConfigInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateQuickConnectConfigInput(v *UpdateQuickConnectConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.QuickConnectId == nil || len(*v.QuickConnectId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member QuickConnectId must not be empty")}
	}
	if v.QuickConnectId != nil {
		if err := encoder.SetURI("QuickConnectId").String(*v.QuickConnectId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateQuickConnectConfigInput(v *UpdateQuickConnectConfigInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.QuickConnectConfig != nil {
		ok := object.Key("QuickConnectConfig")
		if err := awsRestjson1_serializeDocumentQuickConnectConfig(v.QuickConnectConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateQuickConnectName struct {
}

func (*awsRestjson1_serializeOpUpdateQuickConnectName) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateQuickConnectName) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateQuickConnectNameInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/quick-connects/{InstanceId}/{QuickConnectId}/name")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateQuickConnectNameInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateQuickConnectNameInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateQuickConnectNameInput(v *UpdateQuickConnectNameInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.QuickConnectId == nil || len(*v.QuickConnectId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member QuickConnectId must not be empty")}
	}
	if v.QuickConnectId != nil {
		if err := encoder.SetURI("QuickConnectId").String(*v.QuickConnectId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateQuickConnectNameInput(v *UpdateQuickConnectNameInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateRoutingProfileConcurrency struct {
}

func (*awsRestjson1_serializeOpUpdateRoutingProfileConcurrency) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateRoutingProfileConcurrency) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateRoutingProfileConcurrencyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/routing-profiles/{InstanceId}/{RoutingProfileId}/concurrency")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateRoutingProfileConcurrencyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateRoutingProfileConcurrencyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateRoutingProfileConcurrencyInput(v *UpdateRoutingProfileConcurrencyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.RoutingProfileId == nil || len(*v.RoutingProfileId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member RoutingProfileId must not be empty")}
	}
	if v.RoutingProfileId != nil {
		if err := encoder.SetURI("RoutingProfileId").String(*v.RoutingProfileId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateRoutingProfileConcurrencyInput(v *UpdateRoutingProfileConcurrencyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MediaConcurrencies != nil {
		ok := object.Key("MediaConcurrencies")
		if err := awsRestjson1_serializeDocumentMediaConcurrencies(v.MediaConcurrencies, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateRoutingProfileDefaultOutboundQueue struct {
}

func (*awsRestjson1_serializeOpUpdateRoutingProfileDefaultOutboundQueue) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateRoutingProfileDefaultOutboundQueue) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateRoutingProfileDefaultOutboundQueueInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/routing-profiles/{InstanceId}/{RoutingProfileId}/default-outbound-queue")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateRoutingProfileDefaultOutboundQueueInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateRoutingProfileDefaultOutboundQueueInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateRoutingProfileDefaultOutboundQueueInput(v *UpdateRoutingProfileDefaultOutboundQueueInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.RoutingProfileId == nil || len(*v.RoutingProfileId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member RoutingProfileId must not be empty")}
	}
	if v.RoutingProfileId != nil {
		if err := encoder.SetURI("RoutingProfileId").String(*v.RoutingProfileId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateRoutingProfileDefaultOutboundQueueInput(v *UpdateRoutingProfileDefaultOutboundQueueInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DefaultOutboundQueueId != nil {
		ok := object.Key("DefaultOutboundQueueId")
		ok.String(*v.DefaultOutboundQueueId)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateRoutingProfileName struct {
}

func (*awsRestjson1_serializeOpUpdateRoutingProfileName) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateRoutingProfileName) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateRoutingProfileNameInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/routing-profiles/{InstanceId}/{RoutingProfileId}/name")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateRoutingProfileNameInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateRoutingProfileNameInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateRoutingProfileNameInput(v *UpdateRoutingProfileNameInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.RoutingProfileId == nil || len(*v.RoutingProfileId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member RoutingProfileId must not be empty")}
	}
	if v.RoutingProfileId != nil {
		if err := encoder.SetURI("RoutingProfileId").String(*v.RoutingProfileId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateRoutingProfileNameInput(v *UpdateRoutingProfileNameInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateRoutingProfileQueues struct {
}

func (*awsRestjson1_serializeOpUpdateRoutingProfileQueues) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateRoutingProfileQueues) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateRoutingProfileQueuesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/routing-profiles/{InstanceId}/{RoutingProfileId}/queues")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateRoutingProfileQueuesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateRoutingProfileQueuesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateRoutingProfileQueuesInput(v *UpdateRoutingProfileQueuesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.RoutingProfileId == nil || len(*v.RoutingProfileId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member RoutingProfileId must not be empty")}
	}
	if v.RoutingProfileId != nil {
		if err := encoder.SetURI("RoutingProfileId").String(*v.RoutingProfileId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateRoutingProfileQueuesInput(v *UpdateRoutingProfileQueuesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.QueueConfigs != nil {
		ok := object.Key("QueueConfigs")
		if err := awsRestjson1_serializeDocumentRoutingProfileQueueConfigList(v.QueueConfigs, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateSecurityProfile struct {
}

func (*awsRestjson1_serializeOpUpdateSecurityProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateSecurityProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateSecurityProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/security-profiles/{InstanceId}/{SecurityProfileId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateSecurityProfileInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateSecurityProfileInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateSecurityProfileInput(v *UpdateSecurityProfileInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.SecurityProfileId == nil || len(*v.SecurityProfileId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member SecurityProfileId must not be empty")}
	}
	if v.SecurityProfileId != nil {
		if err := encoder.SetURI("SecurityProfileId").String(*v.SecurityProfileId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateSecurityProfileInput(v *UpdateSecurityProfileInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.Permissions != nil {
		ok := object.Key("Permissions")
		if err := awsRestjson1_serializeDocumentPermissionsList(v.Permissions, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateUserHierarchy struct {
}

func (*awsRestjson1_serializeOpUpdateUserHierarchy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateUserHierarchy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateUserHierarchyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/users/{InstanceId}/{UserId}/hierarchy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateUserHierarchyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateUserHierarchyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateUserHierarchyInput(v *UpdateUserHierarchyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.UserId == nil || len(*v.UserId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member UserId must not be empty")}
	}
	if v.UserId != nil {
		if err := encoder.SetURI("UserId").String(*v.UserId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateUserHierarchyInput(v *UpdateUserHierarchyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.HierarchyGroupId != nil {
		ok := object.Key("HierarchyGroupId")
		ok.String(*v.HierarchyGroupId)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateUserHierarchyGroupName struct {
}

func (*awsRestjson1_serializeOpUpdateUserHierarchyGroupName) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateUserHierarchyGroupName) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateUserHierarchyGroupNameInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/user-hierarchy-groups/{InstanceId}/{HierarchyGroupId}/name")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateUserHierarchyGroupNameInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateUserHierarchyGroupNameInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateUserHierarchyGroupNameInput(v *UpdateUserHierarchyGroupNameInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.HierarchyGroupId == nil || len(*v.HierarchyGroupId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member HierarchyGroupId must not be empty")}
	}
	if v.HierarchyGroupId != nil {
		if err := encoder.SetURI("HierarchyGroupId").String(*v.HierarchyGroupId); err != nil {
			return err
		}
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateUserHierarchyGroupNameInput(v *UpdateUserHierarchyGroupNameInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateUserHierarchyStructure struct {
}

func (*awsRestjson1_serializeOpUpdateUserHierarchyStructure) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateUserHierarchyStructure) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateUserHierarchyStructureInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/user-hierarchy-structure/{InstanceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateUserHierarchyStructureInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateUserHierarchyStructureInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateUserHierarchyStructureInput(v *UpdateUserHierarchyStructureInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateUserHierarchyStructureInput(v *UpdateUserHierarchyStructureInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.HierarchyStructure != nil {
		ok := object.Key("HierarchyStructure")
		if err := awsRestjson1_serializeDocumentHierarchyStructureUpdate(v.HierarchyStructure, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateUserIdentityInfo struct {
}

func (*awsRestjson1_serializeOpUpdateUserIdentityInfo) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateUserIdentityInfo) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateUserIdentityInfoInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/users/{InstanceId}/{UserId}/identity-info")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateUserIdentityInfoInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateUserIdentityInfoInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateUserIdentityInfoInput(v *UpdateUserIdentityInfoInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.UserId == nil || len(*v.UserId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member UserId must not be empty")}
	}
	if v.UserId != nil {
		if err := encoder.SetURI("UserId").String(*v.UserId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateUserIdentityInfoInput(v *UpdateUserIdentityInfoInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IdentityInfo != nil {
		ok := object.Key("IdentityInfo")
		if err := awsRestjson1_serializeDocumentUserIdentityInfo(v.IdentityInfo, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateUserPhoneConfig struct {
}

func (*awsRestjson1_serializeOpUpdateUserPhoneConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateUserPhoneConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateUserPhoneConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/users/{InstanceId}/{UserId}/phone-config")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateUserPhoneConfigInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateUserPhoneConfigInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateUserPhoneConfigInput(v *UpdateUserPhoneConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.UserId == nil || len(*v.UserId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member UserId must not be empty")}
	}
	if v.UserId != nil {
		if err := encoder.SetURI("UserId").String(*v.UserId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateUserPhoneConfigInput(v *UpdateUserPhoneConfigInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PhoneConfig != nil {
		ok := object.Key("PhoneConfig")
		if err := awsRestjson1_serializeDocumentUserPhoneConfig(v.PhoneConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateUserRoutingProfile struct {
}

func (*awsRestjson1_serializeOpUpdateUserRoutingProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateUserRoutingProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateUserRoutingProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/users/{InstanceId}/{UserId}/routing-profile")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateUserRoutingProfileInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateUserRoutingProfileInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateUserRoutingProfileInput(v *UpdateUserRoutingProfileInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.UserId == nil || len(*v.UserId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member UserId must not be empty")}
	}
	if v.UserId != nil {
		if err := encoder.SetURI("UserId").String(*v.UserId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateUserRoutingProfileInput(v *UpdateUserRoutingProfileInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RoutingProfileId != nil {
		ok := object.Key("RoutingProfileId")
		ok.String(*v.RoutingProfileId)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateUserSecurityProfiles struct {
}

func (*awsRestjson1_serializeOpUpdateUserSecurityProfiles) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateUserSecurityProfiles) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateUserSecurityProfilesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/users/{InstanceId}/{UserId}/security-profiles")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateUserSecurityProfilesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateUserSecurityProfilesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateUserSecurityProfilesInput(v *UpdateUserSecurityProfilesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.UserId == nil || len(*v.UserId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member UserId must not be empty")}
	}
	if v.UserId != nil {
		if err := encoder.SetURI("UserId").String(*v.UserId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateUserSecurityProfilesInput(v *UpdateUserSecurityProfilesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SecurityProfileIds != nil {
		ok := object.Key("SecurityProfileIds")
		if err := awsRestjson1_serializeDocumentSecurityProfileIds(v.SecurityProfileIds, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAnswerMachineDetectionConfig(v *types.AnswerMachineDetectionConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AwaitAnswerMachinePrompt {
		ok := object.Key("AwaitAnswerMachinePrompt")
		ok.Boolean(v.AwaitAnswerMachinePrompt)
	}

	if v.EnableAnswerMachineDetection {
		ok := object.Key("EnableAnswerMachineDetection")
		ok.Boolean(v.EnableAnswerMachineDetection)
	}

	return nil
}

func awsRestjson1_serializeDocumentAttributes(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentChannels(v []types.Channel, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentChatMessage(v *types.ChatMessage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Content != nil {
		ok := object.Key("Content")
		ok.String(*v.Content)
	}

	if v.ContentType != nil {
		ok := object.Key("ContentType")
		ok.String(*v.ContentType)
	}

	return nil
}

func awsRestjson1_serializeDocumentChatStreamingConfiguration(v *types.ChatStreamingConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.StreamingEndpointArn != nil {
		ok := object.Key("StreamingEndpointArn")
		ok.String(*v.StreamingEndpointArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentContactReferences(v map[string]types.Reference, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentReference(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCurrentMetric(v *types.CurrentMetric, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("Name")
		ok.String(string(v.Name))
	}

	if len(v.Unit) > 0 {
		ok := object.Key("Unit")
		ok.String(string(v.Unit))
	}

	return nil
}

func awsRestjson1_serializeDocumentCurrentMetrics(v []types.CurrentMetric, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCurrentMetric(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentEncryptionConfig(v *types.EncryptionConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.EncryptionType) > 0 {
		ok := object.Key("EncryptionType")
		ok.String(string(v.EncryptionType))
	}

	if v.KeyId != nil {
		ok := object.Key("KeyId")
		ok.String(*v.KeyId)
	}

	return nil
}

func awsRestjson1_serializeDocumentFilters(v *types.Filters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Channels != nil {
		ok := object.Key("Channels")
		if err := awsRestjson1_serializeDocumentChannels(v.Channels, ok); err != nil {
			return err
		}
	}

	if v.Queues != nil {
		ok := object.Key("Queues")
		if err := awsRestjson1_serializeDocumentQueues(v.Queues, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGroupings(v []types.Grouping, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentHierarchyLevelUpdate(v *types.HierarchyLevelUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentHierarchyStructureUpdate(v *types.HierarchyStructureUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LevelFive != nil {
		ok := object.Key("LevelFive")
		if err := awsRestjson1_serializeDocumentHierarchyLevelUpdate(v.LevelFive, ok); err != nil {
			return err
		}
	}

	if v.LevelFour != nil {
		ok := object.Key("LevelFour")
		if err := awsRestjson1_serializeDocumentHierarchyLevelUpdate(v.LevelFour, ok); err != nil {
			return err
		}
	}

	if v.LevelOne != nil {
		ok := object.Key("LevelOne")
		if err := awsRestjson1_serializeDocumentHierarchyLevelUpdate(v.LevelOne, ok); err != nil {
			return err
		}
	}

	if v.LevelThree != nil {
		ok := object.Key("LevelThree")
		if err := awsRestjson1_serializeDocumentHierarchyLevelUpdate(v.LevelThree, ok); err != nil {
			return err
		}
	}

	if v.LevelTwo != nil {
		ok := object.Key("LevelTwo")
		if err := awsRestjson1_serializeDocumentHierarchyLevelUpdate(v.LevelTwo, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentHistoricalMetric(v *types.HistoricalMetric, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("Name")
		ok.String(string(v.Name))
	}

	if len(v.Statistic) > 0 {
		ok := object.Key("Statistic")
		ok.String(string(v.Statistic))
	}

	if v.Threshold != nil {
		ok := object.Key("Threshold")
		if err := awsRestjson1_serializeDocumentThreshold(v.Threshold, ok); err != nil {
			return err
		}
	}

	if len(v.Unit) > 0 {
		ok := object.Key("Unit")
		ok.String(string(v.Unit))
	}

	return nil
}

func awsRestjson1_serializeDocumentHistoricalMetrics(v []types.HistoricalMetric, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentHistoricalMetric(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentHoursOfOperationConfig(v *types.HoursOfOperationConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Day) > 0 {
		ok := object.Key("Day")
		ok.String(string(v.Day))
	}

	if v.EndTime != nil {
		ok := object.Key("EndTime")
		if err := awsRestjson1_serializeDocumentHoursOfOperationTimeSlice(v.EndTime, ok); err != nil {
			return err
		}
	}

	if v.StartTime != nil {
		ok := object.Key("StartTime")
		if err := awsRestjson1_serializeDocumentHoursOfOperationTimeSlice(v.StartTime, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentHoursOfOperationConfigList(v []types.HoursOfOperationConfig, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentHoursOfOperationConfig(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentHoursOfOperationTimeSlice(v *types.HoursOfOperationTimeSlice, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("Hours")
		ok.Integer(v.Hours)
	}

	{
		ok := object.Key("Minutes")
		ok.Integer(v.Minutes)
	}

	return nil
}

func awsRestjson1_serializeDocumentInstanceStorageConfig(v *types.InstanceStorageConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AssociationId != nil {
		ok := object.Key("AssociationId")
		ok.String(*v.AssociationId)
	}

	if v.KinesisFirehoseConfig != nil {
		ok := object.Key("KinesisFirehoseConfig")
		if err := awsRestjson1_serializeDocumentKinesisFirehoseConfig(v.KinesisFirehoseConfig, ok); err != nil {
			return err
		}
	}

	if v.KinesisStreamConfig != nil {
		ok := object.Key("KinesisStreamConfig")
		if err := awsRestjson1_serializeDocumentKinesisStreamConfig(v.KinesisStreamConfig, ok); err != nil {
			return err
		}
	}

	if v.KinesisVideoStreamConfig != nil {
		ok := object.Key("KinesisVideoStreamConfig")
		if err := awsRestjson1_serializeDocumentKinesisVideoStreamConfig(v.KinesisVideoStreamConfig, ok); err != nil {
			return err
		}
	}

	if v.S3Config != nil {
		ok := object.Key("S3Config")
		if err := awsRestjson1_serializeDocumentS3Config(v.S3Config, ok); err != nil {
			return err
		}
	}

	if len(v.StorageType) > 0 {
		ok := object.Key("StorageType")
		ok.String(string(v.StorageType))
	}

	return nil
}

func awsRestjson1_serializeDocumentKinesisFirehoseConfig(v *types.KinesisFirehoseConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FirehoseArn != nil {
		ok := object.Key("FirehoseArn")
		ok.String(*v.FirehoseArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentKinesisStreamConfig(v *types.KinesisStreamConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.StreamArn != nil {
		ok := object.Key("StreamArn")
		ok.String(*v.StreamArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentKinesisVideoStreamConfig(v *types.KinesisVideoStreamConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EncryptionConfig != nil {
		ok := object.Key("EncryptionConfig")
		if err := awsRestjson1_serializeDocumentEncryptionConfig(v.EncryptionConfig, ok); err != nil {
			return err
		}
	}

	if v.Prefix != nil {
		ok := object.Key("Prefix")
		ok.String(*v.Prefix)
	}

	{
		ok := object.Key("RetentionPeriodHours")
		ok.Integer(v.RetentionPeriodHours)
	}

	return nil
}

func awsRestjson1_serializeDocumentLexBot(v *types.LexBot, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LexRegion != nil {
		ok := object.Key("LexRegion")
		ok.String(*v.LexRegion)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentLexV2Bot(v *types.LexV2Bot, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AliasArn != nil {
		ok := object.Key("AliasArn")
		ok.String(*v.AliasArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentMediaConcurrencies(v []types.MediaConcurrency, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentMediaConcurrency(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentMediaConcurrency(v *types.MediaConcurrency, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Channel) > 0 {
		ok := object.Key("Channel")
		ok.String(string(v.Channel))
	}

	{
		ok := object.Key("Concurrency")
		ok.Integer(v.Concurrency)
	}

	return nil
}

func awsRestjson1_serializeDocumentOutboundCallerConfig(v *types.OutboundCallerConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.OutboundCallerIdName != nil {
		ok := object.Key("OutboundCallerIdName")
		ok.String(*v.OutboundCallerIdName)
	}

	if v.OutboundCallerIdNumberId != nil {
		ok := object.Key("OutboundCallerIdNumberId")
		ok.String(*v.OutboundCallerIdNumberId)
	}

	if v.OutboundFlowId != nil {
		ok := object.Key("OutboundFlowId")
		ok.String(*v.OutboundFlowId)
	}

	return nil
}

func awsRestjson1_serializeDocumentParticipantDetails(v *types.ParticipantDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DisplayName != nil {
		ok := object.Key("DisplayName")
		ok.String(*v.DisplayName)
	}

	return nil
}

func awsRestjson1_serializeDocumentPermissionsList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentPhoneNumberQuickConnectConfig(v *types.PhoneNumberQuickConnectConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PhoneNumber != nil {
		ok := object.Key("PhoneNumber")
		ok.String(*v.PhoneNumber)
	}

	return nil
}

func awsRestjson1_serializeDocumentQueueQuickConnectConfig(v *types.QueueQuickConnectConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContactFlowId != nil {
		ok := object.Key("ContactFlowId")
		ok.String(*v.ContactFlowId)
	}

	if v.QueueId != nil {
		ok := object.Key("QueueId")
		ok.String(*v.QueueId)
	}

	return nil
}

func awsRestjson1_serializeDocumentQueues(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentQuickConnectConfig(v *types.QuickConnectConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PhoneConfig != nil {
		ok := object.Key("PhoneConfig")
		if err := awsRestjson1_serializeDocumentPhoneNumberQuickConnectConfig(v.PhoneConfig, ok); err != nil {
			return err
		}
	}

	if v.QueueConfig != nil {
		ok := object.Key("QueueConfig")
		if err := awsRestjson1_serializeDocumentQueueQuickConnectConfig(v.QueueConfig, ok); err != nil {
			return err
		}
	}

	if len(v.QuickConnectType) > 0 {
		ok := object.Key("QuickConnectType")
		ok.String(string(v.QuickConnectType))
	}

	if v.UserConfig != nil {
		ok := object.Key("UserConfig")
		if err := awsRestjson1_serializeDocumentUserQuickConnectConfig(v.UserConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentQuickConnectsList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentReference(v *types.Reference, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentRoutingProfileQueueConfig(v *types.RoutingProfileQueueConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("Delay")
		ok.Integer(v.Delay)
	}

	{
		ok := object.Key("Priority")
		ok.Integer(v.Priority)
	}

	if v.QueueReference != nil {
		ok := object.Key("QueueReference")
		if err := awsRestjson1_serializeDocumentRoutingProfileQueueReference(v.QueueReference, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRoutingProfileQueueConfigList(v []types.RoutingProfileQueueConfig, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentRoutingProfileQueueConfig(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentRoutingProfileQueueReference(v *types.RoutingProfileQueueReference, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Channel) > 0 {
		ok := object.Key("Channel")
		ok.String(string(v.Channel))
	}

	if v.QueueId != nil {
		ok := object.Key("QueueId")
		ok.String(*v.QueueId)
	}

	return nil
}

func awsRestjson1_serializeDocumentRoutingProfileQueueReferenceList(v []types.RoutingProfileQueueReference, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentRoutingProfileQueueReference(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentS3Config(v *types.S3Config, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BucketName != nil {
		ok := object.Key("BucketName")
		ok.String(*v.BucketName)
	}

	if v.BucketPrefix != nil {
		ok := object.Key("BucketPrefix")
		ok.String(*v.BucketPrefix)
	}

	if v.EncryptionConfig != nil {
		ok := object.Key("EncryptionConfig")
		if err := awsRestjson1_serializeDocumentEncryptionConfig(v.EncryptionConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSecurityProfileIds(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentTagMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentThreshold(v *types.Threshold, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Comparison) > 0 {
		ok := object.Key("Comparison")
		ok.String(string(v.Comparison))
	}

	if v.ThresholdValue != nil {
		ok := object.Key("ThresholdValue")
		switch {
		case math.IsNaN(*v.ThresholdValue):
			ok.String("NaN")

		case math.IsInf(*v.ThresholdValue, 1):
			ok.String("Infinity")

		case math.IsInf(*v.ThresholdValue, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.ThresholdValue)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentUserIdentityInfo(v *types.UserIdentityInfo, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Email != nil {
		ok := object.Key("Email")
		ok.String(*v.Email)
	}

	if v.FirstName != nil {
		ok := object.Key("FirstName")
		ok.String(*v.FirstName)
	}

	if v.LastName != nil {
		ok := object.Key("LastName")
		ok.String(*v.LastName)
	}

	return nil
}

func awsRestjson1_serializeDocumentUserPhoneConfig(v *types.UserPhoneConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AfterContactWorkTimeLimit != 0 {
		ok := object.Key("AfterContactWorkTimeLimit")
		ok.Integer(v.AfterContactWorkTimeLimit)
	}

	if v.AutoAccept {
		ok := object.Key("AutoAccept")
		ok.Boolean(v.AutoAccept)
	}

	if v.DeskPhoneNumber != nil {
		ok := object.Key("DeskPhoneNumber")
		ok.String(*v.DeskPhoneNumber)
	}

	if len(v.PhoneType) > 0 {
		ok := object.Key("PhoneType")
		ok.String(string(v.PhoneType))
	}

	return nil
}

func awsRestjson1_serializeDocumentUserQuickConnectConfig(v *types.UserQuickConnectConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContactFlowId != nil {
		ok := object.Key("ContactFlowId")
		ok.String(*v.ContactFlowId)
	}

	if v.UserId != nil {
		ok := object.Key("UserId")
		ok.String(*v.UserId)
	}

	return nil
}

func awsRestjson1_serializeDocumentVoiceRecordingConfiguration(v *types.VoiceRecordingConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.VoiceRecordingTrack) > 0 {
		ok := object.Key("VoiceRecordingTrack")
		ok.String(string(v.VoiceRecordingTrack))
	}

	return nil
}
