// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"fmt"
	smithy "github.com/aws/smithy-go"
)

// You have specified a template that is not valid or supported.
type ConformancePackTemplateValidationException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *ConformancePackTemplateValidationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ConformancePackTemplateValidationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ConformancePackTemplateValidationException) ErrorCode() string {
	return "ConformancePackTemplateValidationException"
}
func (e *ConformancePackTemplateValidationException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// Your Amazon S3 bucket policy does not permit Config to write to it.
type InsufficientDeliveryPolicyException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InsufficientDeliveryPolicyException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InsufficientDeliveryPolicyException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InsufficientDeliveryPolicyException) ErrorCode() string {
	return "InsufficientDeliveryPolicyException"
}
func (e *InsufficientDeliveryPolicyException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// Indicates one of the following errors:
//
// * For PutConfigRule, the rule cannot be
// created because the IAM role assigned to Config lacks permissions to perform the
// config:Put* action.
//
// * For PutConfigRule, the Lambda function cannot be invoked.
// Check the function ARN, and check the function's permissions.
//
// * For
// PutOrganizationConfigRule, organization config rule cannot be created because
// you do not have permissions to call IAM GetRole action or create a service
// linked role.
//
// * For PutConformancePack and PutOrganizationConformancePack, a
// conformance pack cannot be created because you do not have permissions:
//
// * To
// call IAM GetRole action or create a service linked role.
//
// * To read Amazon S3
// bucket.
type InsufficientPermissionsException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InsufficientPermissionsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InsufficientPermissionsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InsufficientPermissionsException) ErrorCode() string {
	return "InsufficientPermissionsException"
}
func (e *InsufficientPermissionsException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You have provided a configuration recorder name that is not valid.
type InvalidConfigurationRecorderNameException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidConfigurationRecorderNameException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidConfigurationRecorderNameException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidConfigurationRecorderNameException) ErrorCode() string {
	return "InvalidConfigurationRecorderNameException"
}
func (e *InvalidConfigurationRecorderNameException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified delivery channel name is not valid.
type InvalidDeliveryChannelNameException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidDeliveryChannelNameException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidDeliveryChannelNameException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidDeliveryChannelNameException) ErrorCode() string {
	return "InvalidDeliveryChannelNameException"
}
func (e *InvalidDeliveryChannelNameException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The syntax of the query is incorrect.
type InvalidExpressionException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidExpressionException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidExpressionException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidExpressionException) ErrorCode() string             { return "InvalidExpressionException" }
func (e *InvalidExpressionException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified limit is outside the allowable range.
type InvalidLimitException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidLimitException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidLimitException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidLimitException) ErrorCode() string             { return "InvalidLimitException" }
func (e *InvalidLimitException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified next token is invalid. Specify the nextToken string that was
// returned in the previous response to get the next page of results.
type InvalidNextTokenException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidNextTokenException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidNextTokenException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidNextTokenException) ErrorCode() string             { return "InvalidNextTokenException" }
func (e *InvalidNextTokenException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// One or more of the specified parameters are invalid. Verify that your parameters
// are valid and try again.
type InvalidParameterValueException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidParameterValueException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidParameterValueException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidParameterValueException) ErrorCode() string             { return "InvalidParameterValueException" }
func (e *InvalidParameterValueException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Config throws an exception if the recording group does not contain a valid list
// of resource types. Invalid values might also be incorrectly formatted.
type InvalidRecordingGroupException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidRecordingGroupException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidRecordingGroupException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidRecordingGroupException) ErrorCode() string             { return "InvalidRecordingGroupException" }
func (e *InvalidRecordingGroupException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified ResultToken is invalid.
type InvalidResultTokenException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidResultTokenException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidResultTokenException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidResultTokenException) ErrorCode() string             { return "InvalidResultTokenException" }
func (e *InvalidResultTokenException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You have provided a null or empty role ARN.
type InvalidRoleException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidRoleException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidRoleException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidRoleException) ErrorCode() string             { return "InvalidRoleException" }
func (e *InvalidRoleException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified Amazon S3 key prefix is not valid.
type InvalidS3KeyPrefixException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidS3KeyPrefixException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidS3KeyPrefixException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidS3KeyPrefixException) ErrorCode() string             { return "InvalidS3KeyPrefixException" }
func (e *InvalidS3KeyPrefixException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified Amazon KMS Key ARN is not valid.
type InvalidS3KmsKeyArnException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidS3KmsKeyArnException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidS3KmsKeyArnException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidS3KmsKeyArnException) ErrorCode() string             { return "InvalidS3KmsKeyArnException" }
func (e *InvalidS3KmsKeyArnException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified Amazon SNS topic does not exist.
type InvalidSNSTopicARNException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidSNSTopicARNException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidSNSTopicARNException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidSNSTopicARNException) ErrorCode() string             { return "InvalidSNSTopicARNException" }
func (e *InvalidSNSTopicARNException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified time range is not valid. The earlier time is not chronologically
// before the later time.
type InvalidTimeRangeException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidTimeRangeException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidTimeRangeException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidTimeRangeException) ErrorCode() string             { return "InvalidTimeRangeException" }
func (e *InvalidTimeRangeException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You cannot delete the delivery channel you specified because the configuration
// recorder is running.
type LastDeliveryChannelDeleteFailedException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *LastDeliveryChannelDeleteFailedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *LastDeliveryChannelDeleteFailedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *LastDeliveryChannelDeleteFailedException) ErrorCode() string {
	return "LastDeliveryChannelDeleteFailedException"
}
func (e *LastDeliveryChannelDeleteFailedException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// For StartConfigRulesEvaluation API, this exception is thrown if an evaluation is
// in progress or if you call the StartConfigRulesEvaluation API more than once per
// minute. For PutConfigurationAggregator API, this exception is thrown if the
// number of accounts and aggregators exceeds the limit.
type LimitExceededException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *LimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *LimitExceededException) ErrorCode() string             { return "LimitExceededException" }
func (e *LimitExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You have reached the limit (100,000) of active custom resource types in your
// account. Delete unused resources using DeleteResourceConfig.
type MaxActiveResourcesExceededException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *MaxActiveResourcesExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MaxActiveResourcesExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MaxActiveResourcesExceededException) ErrorCode() string {
	return "MaxActiveResourcesExceededException"
}
func (e *MaxActiveResourcesExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// Failed to add the Config rule because the account already contains the maximum
// number of 150 rules. Consider deleting any deactivated rules before you add new
// rules.
type MaxNumberOfConfigRulesExceededException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *MaxNumberOfConfigRulesExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MaxNumberOfConfigRulesExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MaxNumberOfConfigRulesExceededException) ErrorCode() string {
	return "MaxNumberOfConfigRulesExceededException"
}
func (e *MaxNumberOfConfigRulesExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You have reached the limit of the number of recorders you can create.
type MaxNumberOfConfigurationRecordersExceededException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *MaxNumberOfConfigurationRecordersExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MaxNumberOfConfigurationRecordersExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MaxNumberOfConfigurationRecordersExceededException) ErrorCode() string {
	return "MaxNumberOfConfigurationRecordersExceededException"
}
func (e *MaxNumberOfConfigurationRecordersExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You have reached the limit (6) of the number of conformance packs in an account
// (6 conformance pack with 25 Config rules per pack).
type MaxNumberOfConformancePacksExceededException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *MaxNumberOfConformancePacksExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MaxNumberOfConformancePacksExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MaxNumberOfConformancePacksExceededException) ErrorCode() string {
	return "MaxNumberOfConformancePacksExceededException"
}
func (e *MaxNumberOfConformancePacksExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You have reached the limit of the number of delivery channels you can create.
type MaxNumberOfDeliveryChannelsExceededException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *MaxNumberOfDeliveryChannelsExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MaxNumberOfDeliveryChannelsExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MaxNumberOfDeliveryChannelsExceededException) ErrorCode() string {
	return "MaxNumberOfDeliveryChannelsExceededException"
}
func (e *MaxNumberOfDeliveryChannelsExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You have reached the limit of the number of organization config rules you can
// create.
type MaxNumberOfOrganizationConfigRulesExceededException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *MaxNumberOfOrganizationConfigRulesExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MaxNumberOfOrganizationConfigRulesExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MaxNumberOfOrganizationConfigRulesExceededException) ErrorCode() string {
	return "MaxNumberOfOrganizationConfigRulesExceededException"
}
func (e *MaxNumberOfOrganizationConfigRulesExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You have reached the limit (6) of the number of organization conformance packs
// in an account (6 conformance pack with 25 Config rules per pack per account).
type MaxNumberOfOrganizationConformancePacksExceededException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *MaxNumberOfOrganizationConformancePacksExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MaxNumberOfOrganizationConformancePacksExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MaxNumberOfOrganizationConformancePacksExceededException) ErrorCode() string {
	return "MaxNumberOfOrganizationConformancePacksExceededException"
}
func (e *MaxNumberOfOrganizationConformancePacksExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// Failed to add the retention configuration because a retention configuration with
// that name already exists.
type MaxNumberOfRetentionConfigurationsExceededException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *MaxNumberOfRetentionConfigurationsExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MaxNumberOfRetentionConfigurationsExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MaxNumberOfRetentionConfigurationsExceededException) ErrorCode() string {
	return "MaxNumberOfRetentionConfigurationsExceededException"
}
func (e *MaxNumberOfRetentionConfigurationsExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// There are no configuration recorders available to provide the role needed to
// describe your resources. Create a configuration recorder.
type NoAvailableConfigurationRecorderException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *NoAvailableConfigurationRecorderException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoAvailableConfigurationRecorderException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoAvailableConfigurationRecorderException) ErrorCode() string {
	return "NoAvailableConfigurationRecorderException"
}
func (e *NoAvailableConfigurationRecorderException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// There is no delivery channel available to record configurations.
type NoAvailableDeliveryChannelException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *NoAvailableDeliveryChannelException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoAvailableDeliveryChannelException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoAvailableDeliveryChannelException) ErrorCode() string {
	return "NoAvailableDeliveryChannelException"
}
func (e *NoAvailableDeliveryChannelException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// Organization is no longer available.
type NoAvailableOrganizationException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *NoAvailableOrganizationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoAvailableOrganizationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoAvailableOrganizationException) ErrorCode() string {
	return "NoAvailableOrganizationException"
}
func (e *NoAvailableOrganizationException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// There is no configuration recorder running.
type NoRunningConfigurationRecorderException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *NoRunningConfigurationRecorderException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoRunningConfigurationRecorderException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoRunningConfigurationRecorderException) ErrorCode() string {
	return "NoRunningConfigurationRecorderException"
}
func (e *NoRunningConfigurationRecorderException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified Amazon S3 bucket does not exist.
type NoSuchBucketException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *NoSuchBucketException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchBucketException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchBucketException) ErrorCode() string             { return "NoSuchBucketException" }
func (e *NoSuchBucketException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// One or more Config rules in the request are invalid. Verify that the rule names
// are correct and try again.
type NoSuchConfigRuleException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *NoSuchConfigRuleException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchConfigRuleException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchConfigRuleException) ErrorCode() string             { return "NoSuchConfigRuleException" }
func (e *NoSuchConfigRuleException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Config rule that you passed in the filter does not exist.
type NoSuchConfigRuleInConformancePackException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *NoSuchConfigRuleInConformancePackException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchConfigRuleInConformancePackException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchConfigRuleInConformancePackException) ErrorCode() string {
	return "NoSuchConfigRuleInConformancePackException"
}
func (e *NoSuchConfigRuleInConformancePackException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You have specified a configuration aggregator that does not exist.
type NoSuchConfigurationAggregatorException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *NoSuchConfigurationAggregatorException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchConfigurationAggregatorException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchConfigurationAggregatorException) ErrorCode() string {
	return "NoSuchConfigurationAggregatorException"
}
func (e *NoSuchConfigurationAggregatorException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You have specified a configuration recorder that does not exist.
type NoSuchConfigurationRecorderException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *NoSuchConfigurationRecorderException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchConfigurationRecorderException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchConfigurationRecorderException) ErrorCode() string {
	return "NoSuchConfigurationRecorderException"
}
func (e *NoSuchConfigurationRecorderException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You specified one or more conformance packs that do not exist.
type NoSuchConformancePackException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *NoSuchConformancePackException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchConformancePackException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchConformancePackException) ErrorCode() string             { return "NoSuchConformancePackException" }
func (e *NoSuchConformancePackException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You have specified a delivery channel that does not exist.
type NoSuchDeliveryChannelException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *NoSuchDeliveryChannelException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchDeliveryChannelException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchDeliveryChannelException) ErrorCode() string             { return "NoSuchDeliveryChannelException" }
func (e *NoSuchDeliveryChannelException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You specified one or more organization config rules that do not exist.
type NoSuchOrganizationConfigRuleException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *NoSuchOrganizationConfigRuleException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchOrganizationConfigRuleException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchOrganizationConfigRuleException) ErrorCode() string {
	return "NoSuchOrganizationConfigRuleException"
}
func (e *NoSuchOrganizationConfigRuleException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// Config organization conformance pack that you passed in the filter does not
// exist. For DeleteOrganizationConformancePack, you tried to delete an
// organization conformance pack that does not exist.
type NoSuchOrganizationConformancePackException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *NoSuchOrganizationConformancePackException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchOrganizationConformancePackException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchOrganizationConformancePackException) ErrorCode() string {
	return "NoSuchOrganizationConformancePackException"
}
func (e *NoSuchOrganizationConformancePackException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You specified an Config rule without a remediation configuration.
type NoSuchRemediationConfigurationException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *NoSuchRemediationConfigurationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchRemediationConfigurationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchRemediationConfigurationException) ErrorCode() string {
	return "NoSuchRemediationConfigurationException"
}
func (e *NoSuchRemediationConfigurationException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You tried to delete a remediation exception that does not exist.
type NoSuchRemediationExceptionException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *NoSuchRemediationExceptionException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchRemediationExceptionException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchRemediationExceptionException) ErrorCode() string {
	return "NoSuchRemediationExceptionException"
}
func (e *NoSuchRemediationExceptionException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You have specified a retention configuration that does not exist.
type NoSuchRetentionConfigurationException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *NoSuchRetentionConfigurationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchRetentionConfigurationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchRetentionConfigurationException) ErrorCode() string {
	return "NoSuchRetentionConfigurationException"
}
func (e *NoSuchRetentionConfigurationException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// For PutConfigurationAggregator API, you can see this exception for the following
// reasons:
//
// * No permission to call EnableAWSServiceAccess API
//
// * The
// configuration aggregator cannot be updated because your Amazon Web Services
// Organization management account or the delegated administrator role changed.
// Delete this aggregator and create a new one with the current Amazon Web Services
// Organization.
//
// * The configuration aggregator is associated with a previous
// Amazon Web Services Organization and Config cannot aggregate data with current
// Amazon Web Services Organization. Delete this aggregator and create a new one
// with the current Amazon Web Services Organization.
//
// * You are not a registered
// delegated administrator for Config with permissions to call
// ListDelegatedAdministrators API. Ensure that the management account registers
// delagated administrator for Config service principle name before the delegated
// administrator creates an aggregator.
//
// For all OrganizationConfigRule and
// OrganizationConformancePack APIs, Config throws an exception if APIs are called
// from member accounts. All APIs must be called from organization master account.
type OrganizationAccessDeniedException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *OrganizationAccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OrganizationAccessDeniedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OrganizationAccessDeniedException) ErrorCode() string {
	return "OrganizationAccessDeniedException"
}
func (e *OrganizationAccessDeniedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Config resource cannot be created because your organization does not have all
// features enabled.
type OrganizationAllFeaturesNotEnabledException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *OrganizationAllFeaturesNotEnabledException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OrganizationAllFeaturesNotEnabledException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OrganizationAllFeaturesNotEnabledException) ErrorCode() string {
	return "OrganizationAllFeaturesNotEnabledException"
}
func (e *OrganizationAllFeaturesNotEnabledException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You have specified a template that is not valid or supported.
type OrganizationConformancePackTemplateValidationException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *OrganizationConformancePackTemplateValidationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OrganizationConformancePackTemplateValidationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OrganizationConformancePackTemplateValidationException) ErrorCode() string {
	return "OrganizationConformancePackTemplateValidationException"
}
func (e *OrganizationConformancePackTemplateValidationException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The configuration item size is outside the allowable range.
type OversizedConfigurationItemException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *OversizedConfigurationItemException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OversizedConfigurationItemException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OversizedConfigurationItemException) ErrorCode() string {
	return "OversizedConfigurationItemException"
}
func (e *OversizedConfigurationItemException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// Remediation action is in progress. You can either cancel execution in Amazon Web
// Services Systems Manager or wait and try again later.
type RemediationInProgressException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *RemediationInProgressException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *RemediationInProgressException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *RemediationInProgressException) ErrorCode() string             { return "RemediationInProgressException" }
func (e *RemediationInProgressException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Two users are trying to modify the same query at the same time. Wait for a
// moment and try again.
type ResourceConcurrentModificationException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *ResourceConcurrentModificationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceConcurrentModificationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceConcurrentModificationException) ErrorCode() string {
	return "ResourceConcurrentModificationException"
}
func (e *ResourceConcurrentModificationException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You see this exception in the following cases:
//
// * For DeleteConfigRule, Config
// is deleting this rule. Try your request again later.
//
// * For DeleteConfigRule,
// the rule is deleting your evaluation results. Try your request again later.
//
// *
// For DeleteConfigRule, a remediation action is associated with the rule and
// Config cannot delete this rule. Delete the remediation action associated with
// the rule before deleting the rule and try your request again later.
//
// * For
// PutConfigOrganizationRule, organization config rule deletion is in progress. Try
// your request again later.
//
// * For DeleteOrganizationConfigRule, organization
// config rule creation is in progress. Try your request again later.
//
// * For
// PutConformancePack and PutOrganizationConformancePack, a conformance pack
// creation, update, and deletion is in progress. Try your request again later.
//
// *
// For DeleteConformancePack, a conformance pack creation, update, and deletion is
// in progress. Try your request again later.
type ResourceInUseException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *ResourceInUseException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceInUseException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceInUseException) ErrorCode() string             { return "ResourceInUseException" }
func (e *ResourceInUseException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You have specified a resource that is either unknown or has not been discovered.
type ResourceNotDiscoveredException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *ResourceNotDiscoveredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceNotDiscoveredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceNotDiscoveredException) ErrorCode() string             { return "ResourceNotDiscoveredException" }
func (e *ResourceNotDiscoveredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You have specified a resource that does not exist.
type ResourceNotFoundException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceNotFoundException) ErrorCode() string             { return "ResourceNotFoundException" }
func (e *ResourceNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You have reached the limit of the number of tags you can use. You have more than
// 50 tags.
type TooManyTagsException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TooManyTagsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyTagsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyTagsException) ErrorCode() string             { return "TooManyTagsException" }
func (e *TooManyTagsException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The requested action is not valid. For PutStoredQuery, you will see this
// exception if there are missing required fields or if the input value fails the
// validation, or if you are trying to create more than 300 queries. For
// GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
// exception if there are missing required fields or if the input value fails the
// validation.
type ValidationException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ValidationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ValidationException) ErrorCode() string             { return "ValidationException" }
func (e *ValidationException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }
