// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudfront

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/cloudfront/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyxml "github.com/aws/smithy-go/encoding/xml"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestxml_serializeOpAssociateAlias struct {
}

func (*awsRestxml_serializeOpAssociateAlias) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpAssociateAlias) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateAliasInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/distribution/{TargetDistributionId}/associate-alias")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsAssociateAliasInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsAssociateAliasInput(v *AssociateAliasInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Alias != nil {
		encoder.SetQuery("Alias").String(*v.Alias)
	}

	if v.TargetDistributionId == nil || len(*v.TargetDistributionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TargetDistributionId must not be empty")}
	}
	if v.TargetDistributionId != nil {
		if err := encoder.SetURI("TargetDistributionId").String(*v.TargetDistributionId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpCreateCachePolicy struct {
}

func (*awsRestxml_serializeOpCreateCachePolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpCreateCachePolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateCachePolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/cache-policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.CachePolicyConfig != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "CachePolicyConfig",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://cloudfront.amazonaws.com/doc/2020-05-31/"))
		if err := awsRestxml_serializeDocumentCachePolicyConfig(input.CachePolicyConfig, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsCreateCachePolicyInput(v *CreateCachePolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestxml_serializeOpCreateCloudFrontOriginAccessIdentity struct {
}

func (*awsRestxml_serializeOpCreateCloudFrontOriginAccessIdentity) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpCreateCloudFrontOriginAccessIdentity) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateCloudFrontOriginAccessIdentityInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/origin-access-identity/cloudfront")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.CloudFrontOriginAccessIdentityConfig != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "CloudFrontOriginAccessIdentityConfig",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://cloudfront.amazonaws.com/doc/2020-05-31/"))
		if err := awsRestxml_serializeDocumentCloudFrontOriginAccessIdentityConfig(input.CloudFrontOriginAccessIdentityConfig, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsCreateCloudFrontOriginAccessIdentityInput(v *CreateCloudFrontOriginAccessIdentityInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestxml_serializeOpCreateDistribution struct {
}

func (*awsRestxml_serializeOpCreateDistribution) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpCreateDistribution) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDistributionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/distribution")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.DistributionConfig != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "DistributionConfig",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://cloudfront.amazonaws.com/doc/2020-05-31/"))
		if err := awsRestxml_serializeDocumentDistributionConfig(input.DistributionConfig, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsCreateDistributionInput(v *CreateDistributionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestxml_serializeOpCreateDistributionWithTags struct {
}

func (*awsRestxml_serializeOpCreateDistributionWithTags) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpCreateDistributionWithTags) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDistributionWithTagsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/distribution?WithTags")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.DistributionConfigWithTags != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "DistributionConfigWithTags",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://cloudfront.amazonaws.com/doc/2020-05-31/"))
		if err := awsRestxml_serializeDocumentDistributionConfigWithTags(input.DistributionConfigWithTags, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsCreateDistributionWithTagsInput(v *CreateDistributionWithTagsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestxml_serializeOpCreateFieldLevelEncryptionConfig struct {
}

func (*awsRestxml_serializeOpCreateFieldLevelEncryptionConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpCreateFieldLevelEncryptionConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateFieldLevelEncryptionConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/field-level-encryption")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.FieldLevelEncryptionConfig != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "FieldLevelEncryptionConfig",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://cloudfront.amazonaws.com/doc/2020-05-31/"))
		if err := awsRestxml_serializeDocumentFieldLevelEncryptionConfig(input.FieldLevelEncryptionConfig, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsCreateFieldLevelEncryptionConfigInput(v *CreateFieldLevelEncryptionConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestxml_serializeOpCreateFieldLevelEncryptionProfile struct {
}

func (*awsRestxml_serializeOpCreateFieldLevelEncryptionProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpCreateFieldLevelEncryptionProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateFieldLevelEncryptionProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/field-level-encryption-profile")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.FieldLevelEncryptionProfileConfig != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "FieldLevelEncryptionProfileConfig",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://cloudfront.amazonaws.com/doc/2020-05-31/"))
		if err := awsRestxml_serializeDocumentFieldLevelEncryptionProfileConfig(input.FieldLevelEncryptionProfileConfig, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsCreateFieldLevelEncryptionProfileInput(v *CreateFieldLevelEncryptionProfileInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestxml_serializeOpCreateFunction struct {
}

func (*awsRestxml_serializeOpCreateFunction) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpCreateFunction) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateFunctionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/function")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "CreateFunctionRequest",
		},
		Attr: rootAttr,
	}
	root.Attr = append(root.Attr, smithyxml.NewNamespaceAttribute("", "http://cloudfront.amazonaws.com/doc/2020-05-31/"))
	if err := awsRestxml_serializeOpDocumentCreateFunctionInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsCreateFunctionInput(v *CreateFunctionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestxml_serializeOpDocumentCreateFunctionInput(v *CreateFunctionInput, value smithyxml.Value) error {
	defer value.Close()
	if v.FunctionCode != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "FunctionCode",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Base64EncodeBytes(v.FunctionCode)
	}
	if v.FunctionConfig != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "FunctionConfig",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentFunctionConfig(v.FunctionConfig, el); err != nil {
			return err
		}
	}
	if v.Name != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Name",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Name)
	}
	return nil
}

type awsRestxml_serializeOpCreateInvalidation struct {
}

func (*awsRestxml_serializeOpCreateInvalidation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpCreateInvalidation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateInvalidationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/distribution/{DistributionId}/invalidation")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsCreateInvalidationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.InvalidationBatch != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "InvalidationBatch",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://cloudfront.amazonaws.com/doc/2020-05-31/"))
		if err := awsRestxml_serializeDocumentInvalidationBatch(input.InvalidationBatch, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsCreateInvalidationInput(v *CreateInvalidationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DistributionId == nil || len(*v.DistributionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DistributionId must not be empty")}
	}
	if v.DistributionId != nil {
		if err := encoder.SetURI("DistributionId").String(*v.DistributionId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpCreateKeyGroup struct {
}

func (*awsRestxml_serializeOpCreateKeyGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpCreateKeyGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateKeyGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/key-group")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.KeyGroupConfig != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "KeyGroupConfig",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://cloudfront.amazonaws.com/doc/2020-05-31/"))
		if err := awsRestxml_serializeDocumentKeyGroupConfig(input.KeyGroupConfig, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsCreateKeyGroupInput(v *CreateKeyGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestxml_serializeOpCreateMonitoringSubscription struct {
}

func (*awsRestxml_serializeOpCreateMonitoringSubscription) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpCreateMonitoringSubscription) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateMonitoringSubscriptionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/distributions/{DistributionId}/monitoring-subscription")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsCreateMonitoringSubscriptionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.MonitoringSubscription != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "MonitoringSubscription",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://cloudfront.amazonaws.com/doc/2020-05-31/"))
		if err := awsRestxml_serializeDocumentMonitoringSubscription(input.MonitoringSubscription, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsCreateMonitoringSubscriptionInput(v *CreateMonitoringSubscriptionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DistributionId == nil || len(*v.DistributionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DistributionId must not be empty")}
	}
	if v.DistributionId != nil {
		if err := encoder.SetURI("DistributionId").String(*v.DistributionId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpCreateOriginRequestPolicy struct {
}

func (*awsRestxml_serializeOpCreateOriginRequestPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpCreateOriginRequestPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateOriginRequestPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/origin-request-policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.OriginRequestPolicyConfig != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "OriginRequestPolicyConfig",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://cloudfront.amazonaws.com/doc/2020-05-31/"))
		if err := awsRestxml_serializeDocumentOriginRequestPolicyConfig(input.OriginRequestPolicyConfig, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsCreateOriginRequestPolicyInput(v *CreateOriginRequestPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestxml_serializeOpCreatePublicKey struct {
}

func (*awsRestxml_serializeOpCreatePublicKey) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpCreatePublicKey) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreatePublicKeyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/public-key")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.PublicKeyConfig != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "PublicKeyConfig",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://cloudfront.amazonaws.com/doc/2020-05-31/"))
		if err := awsRestxml_serializeDocumentPublicKeyConfig(input.PublicKeyConfig, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsCreatePublicKeyInput(v *CreatePublicKeyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestxml_serializeOpCreateRealtimeLogConfig struct {
}

func (*awsRestxml_serializeOpCreateRealtimeLogConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpCreateRealtimeLogConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateRealtimeLogConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/realtime-log-config")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "CreateRealtimeLogConfigRequest",
		},
		Attr: rootAttr,
	}
	root.Attr = append(root.Attr, smithyxml.NewNamespaceAttribute("", "http://cloudfront.amazonaws.com/doc/2020-05-31/"))
	if err := awsRestxml_serializeOpDocumentCreateRealtimeLogConfigInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsCreateRealtimeLogConfigInput(v *CreateRealtimeLogConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestxml_serializeOpDocumentCreateRealtimeLogConfigInput(v *CreateRealtimeLogConfigInput, value smithyxml.Value) error {
	defer value.Close()
	if v.EndPoints != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "EndPoints",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentEndPointList(v.EndPoints, el); err != nil {
			return err
		}
	}
	if v.Fields != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Fields",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentFieldList(v.Fields, el); err != nil {
			return err
		}
	}
	if v.Name != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Name",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Name)
	}
	if v.SamplingRate != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "SamplingRate",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Long(*v.SamplingRate)
	}
	return nil
}

type awsRestxml_serializeOpCreateResponseHeadersPolicy struct {
}

func (*awsRestxml_serializeOpCreateResponseHeadersPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpCreateResponseHeadersPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateResponseHeadersPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/response-headers-policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.ResponseHeadersPolicyConfig != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ResponseHeadersPolicyConfig",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://cloudfront.amazonaws.com/doc/2020-05-31/"))
		if err := awsRestxml_serializeDocumentResponseHeadersPolicyConfig(input.ResponseHeadersPolicyConfig, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsCreateResponseHeadersPolicyInput(v *CreateResponseHeadersPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestxml_serializeOpCreateStreamingDistribution struct {
}

func (*awsRestxml_serializeOpCreateStreamingDistribution) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpCreateStreamingDistribution) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateStreamingDistributionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/streaming-distribution")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.StreamingDistributionConfig != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "StreamingDistributionConfig",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://cloudfront.amazonaws.com/doc/2020-05-31/"))
		if err := awsRestxml_serializeDocumentStreamingDistributionConfig(input.StreamingDistributionConfig, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsCreateStreamingDistributionInput(v *CreateStreamingDistributionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestxml_serializeOpCreateStreamingDistributionWithTags struct {
}

func (*awsRestxml_serializeOpCreateStreamingDistributionWithTags) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpCreateStreamingDistributionWithTags) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateStreamingDistributionWithTagsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/streaming-distribution?WithTags")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.StreamingDistributionConfigWithTags != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "StreamingDistributionConfigWithTags",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://cloudfront.amazonaws.com/doc/2020-05-31/"))
		if err := awsRestxml_serializeDocumentStreamingDistributionConfigWithTags(input.StreamingDistributionConfigWithTags, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsCreateStreamingDistributionWithTagsInput(v *CreateStreamingDistributionWithTagsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestxml_serializeOpDeleteCachePolicy struct {
}

func (*awsRestxml_serializeOpDeleteCachePolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteCachePolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteCachePolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/cache-policy/{Id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeleteCachePolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteCachePolicyInput(v *DeleteCachePolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	if v.IfMatch != nil && len(*v.IfMatch) > 0 {
		locationName := "If-Match"
		encoder.SetHeader(locationName).String(*v.IfMatch)
	}

	return nil
}

type awsRestxml_serializeOpDeleteCloudFrontOriginAccessIdentity struct {
}

func (*awsRestxml_serializeOpDeleteCloudFrontOriginAccessIdentity) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteCloudFrontOriginAccessIdentity) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteCloudFrontOriginAccessIdentityInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/origin-access-identity/cloudfront/{Id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeleteCloudFrontOriginAccessIdentityInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteCloudFrontOriginAccessIdentityInput(v *DeleteCloudFrontOriginAccessIdentityInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	if v.IfMatch != nil && len(*v.IfMatch) > 0 {
		locationName := "If-Match"
		encoder.SetHeader(locationName).String(*v.IfMatch)
	}

	return nil
}

type awsRestxml_serializeOpDeleteDistribution struct {
}

func (*awsRestxml_serializeOpDeleteDistribution) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteDistribution) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteDistributionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/distribution/{Id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeleteDistributionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteDistributionInput(v *DeleteDistributionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	if v.IfMatch != nil && len(*v.IfMatch) > 0 {
		locationName := "If-Match"
		encoder.SetHeader(locationName).String(*v.IfMatch)
	}

	return nil
}

type awsRestxml_serializeOpDeleteFieldLevelEncryptionConfig struct {
}

func (*awsRestxml_serializeOpDeleteFieldLevelEncryptionConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteFieldLevelEncryptionConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteFieldLevelEncryptionConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/field-level-encryption/{Id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeleteFieldLevelEncryptionConfigInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteFieldLevelEncryptionConfigInput(v *DeleteFieldLevelEncryptionConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	if v.IfMatch != nil && len(*v.IfMatch) > 0 {
		locationName := "If-Match"
		encoder.SetHeader(locationName).String(*v.IfMatch)
	}

	return nil
}

type awsRestxml_serializeOpDeleteFieldLevelEncryptionProfile struct {
}

func (*awsRestxml_serializeOpDeleteFieldLevelEncryptionProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteFieldLevelEncryptionProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteFieldLevelEncryptionProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/field-level-encryption-profile/{Id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeleteFieldLevelEncryptionProfileInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteFieldLevelEncryptionProfileInput(v *DeleteFieldLevelEncryptionProfileInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	if v.IfMatch != nil && len(*v.IfMatch) > 0 {
		locationName := "If-Match"
		encoder.SetHeader(locationName).String(*v.IfMatch)
	}

	return nil
}

type awsRestxml_serializeOpDeleteFunction struct {
}

func (*awsRestxml_serializeOpDeleteFunction) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteFunction) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteFunctionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/function/{Name}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeleteFunctionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteFunctionInput(v *DeleteFunctionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.IfMatch != nil && len(*v.IfMatch) > 0 {
		locationName := "If-Match"
		encoder.SetHeader(locationName).String(*v.IfMatch)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpDeleteKeyGroup struct {
}

func (*awsRestxml_serializeOpDeleteKeyGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteKeyGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteKeyGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/key-group/{Id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeleteKeyGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteKeyGroupInput(v *DeleteKeyGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	if v.IfMatch != nil && len(*v.IfMatch) > 0 {
		locationName := "If-Match"
		encoder.SetHeader(locationName).String(*v.IfMatch)
	}

	return nil
}

type awsRestxml_serializeOpDeleteMonitoringSubscription struct {
}

func (*awsRestxml_serializeOpDeleteMonitoringSubscription) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteMonitoringSubscription) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteMonitoringSubscriptionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/distributions/{DistributionId}/monitoring-subscription")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeleteMonitoringSubscriptionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteMonitoringSubscriptionInput(v *DeleteMonitoringSubscriptionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DistributionId == nil || len(*v.DistributionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DistributionId must not be empty")}
	}
	if v.DistributionId != nil {
		if err := encoder.SetURI("DistributionId").String(*v.DistributionId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpDeleteOriginRequestPolicy struct {
}

func (*awsRestxml_serializeOpDeleteOriginRequestPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteOriginRequestPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteOriginRequestPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/origin-request-policy/{Id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeleteOriginRequestPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteOriginRequestPolicyInput(v *DeleteOriginRequestPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	if v.IfMatch != nil && len(*v.IfMatch) > 0 {
		locationName := "If-Match"
		encoder.SetHeader(locationName).String(*v.IfMatch)
	}

	return nil
}

type awsRestxml_serializeOpDeletePublicKey struct {
}

func (*awsRestxml_serializeOpDeletePublicKey) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeletePublicKey) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeletePublicKeyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/public-key/{Id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeletePublicKeyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeletePublicKeyInput(v *DeletePublicKeyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	if v.IfMatch != nil && len(*v.IfMatch) > 0 {
		locationName := "If-Match"
		encoder.SetHeader(locationName).String(*v.IfMatch)
	}

	return nil
}

type awsRestxml_serializeOpDeleteRealtimeLogConfig struct {
}

func (*awsRestxml_serializeOpDeleteRealtimeLogConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteRealtimeLogConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteRealtimeLogConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/delete-realtime-log-config")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "DeleteRealtimeLogConfigRequest",
		},
		Attr: rootAttr,
	}
	root.Attr = append(root.Attr, smithyxml.NewNamespaceAttribute("", "http://cloudfront.amazonaws.com/doc/2020-05-31/"))
	if err := awsRestxml_serializeOpDocumentDeleteRealtimeLogConfigInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteRealtimeLogConfigInput(v *DeleteRealtimeLogConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestxml_serializeOpDocumentDeleteRealtimeLogConfigInput(v *DeleteRealtimeLogConfigInput, value smithyxml.Value) error {
	defer value.Close()
	if v.ARN != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ARN",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ARN)
	}
	if v.Name != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Name",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Name)
	}
	return nil
}

type awsRestxml_serializeOpDeleteResponseHeadersPolicy struct {
}

func (*awsRestxml_serializeOpDeleteResponseHeadersPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteResponseHeadersPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteResponseHeadersPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/response-headers-policy/{Id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeleteResponseHeadersPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteResponseHeadersPolicyInput(v *DeleteResponseHeadersPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	if v.IfMatch != nil && len(*v.IfMatch) > 0 {
		locationName := "If-Match"
		encoder.SetHeader(locationName).String(*v.IfMatch)
	}

	return nil
}

type awsRestxml_serializeOpDeleteStreamingDistribution struct {
}

func (*awsRestxml_serializeOpDeleteStreamingDistribution) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteStreamingDistribution) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteStreamingDistributionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/streaming-distribution/{Id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeleteStreamingDistributionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteStreamingDistributionInput(v *DeleteStreamingDistributionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	if v.IfMatch != nil && len(*v.IfMatch) > 0 {
		locationName := "If-Match"
		encoder.SetHeader(locationName).String(*v.IfMatch)
	}

	return nil
}

type awsRestxml_serializeOpDescribeFunction struct {
}

func (*awsRestxml_serializeOpDescribeFunction) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDescribeFunction) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeFunctionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/function/{Name}/describe")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDescribeFunctionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDescribeFunctionInput(v *DescribeFunctionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	if len(v.Stage) > 0 {
		encoder.SetQuery("Stage").String(string(v.Stage))
	}

	return nil
}

type awsRestxml_serializeOpGetCachePolicy struct {
}

func (*awsRestxml_serializeOpGetCachePolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetCachePolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetCachePolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/cache-policy/{Id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetCachePolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetCachePolicyInput(v *GetCachePolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpGetCachePolicyConfig struct {
}

func (*awsRestxml_serializeOpGetCachePolicyConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetCachePolicyConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetCachePolicyConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/cache-policy/{Id}/config")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetCachePolicyConfigInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetCachePolicyConfigInput(v *GetCachePolicyConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpGetCloudFrontOriginAccessIdentity struct {
}

func (*awsRestxml_serializeOpGetCloudFrontOriginAccessIdentity) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetCloudFrontOriginAccessIdentity) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetCloudFrontOriginAccessIdentityInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/origin-access-identity/cloudfront/{Id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetCloudFrontOriginAccessIdentityInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetCloudFrontOriginAccessIdentityInput(v *GetCloudFrontOriginAccessIdentityInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpGetCloudFrontOriginAccessIdentityConfig struct {
}

func (*awsRestxml_serializeOpGetCloudFrontOriginAccessIdentityConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetCloudFrontOriginAccessIdentityConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetCloudFrontOriginAccessIdentityConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/origin-access-identity/cloudfront/{Id}/config")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetCloudFrontOriginAccessIdentityConfigInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetCloudFrontOriginAccessIdentityConfigInput(v *GetCloudFrontOriginAccessIdentityConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpGetDistribution struct {
}

func (*awsRestxml_serializeOpGetDistribution) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetDistribution) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDistributionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/distribution/{Id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetDistributionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetDistributionInput(v *GetDistributionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpGetDistributionConfig struct {
}

func (*awsRestxml_serializeOpGetDistributionConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetDistributionConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDistributionConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/distribution/{Id}/config")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetDistributionConfigInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetDistributionConfigInput(v *GetDistributionConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpGetFieldLevelEncryption struct {
}

func (*awsRestxml_serializeOpGetFieldLevelEncryption) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetFieldLevelEncryption) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetFieldLevelEncryptionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/field-level-encryption/{Id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetFieldLevelEncryptionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetFieldLevelEncryptionInput(v *GetFieldLevelEncryptionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpGetFieldLevelEncryptionConfig struct {
}

func (*awsRestxml_serializeOpGetFieldLevelEncryptionConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetFieldLevelEncryptionConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetFieldLevelEncryptionConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/field-level-encryption/{Id}/config")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetFieldLevelEncryptionConfigInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetFieldLevelEncryptionConfigInput(v *GetFieldLevelEncryptionConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpGetFieldLevelEncryptionProfile struct {
}

func (*awsRestxml_serializeOpGetFieldLevelEncryptionProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetFieldLevelEncryptionProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetFieldLevelEncryptionProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/field-level-encryption-profile/{Id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetFieldLevelEncryptionProfileInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetFieldLevelEncryptionProfileInput(v *GetFieldLevelEncryptionProfileInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpGetFieldLevelEncryptionProfileConfig struct {
}

func (*awsRestxml_serializeOpGetFieldLevelEncryptionProfileConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetFieldLevelEncryptionProfileConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetFieldLevelEncryptionProfileConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/field-level-encryption-profile/{Id}/config")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetFieldLevelEncryptionProfileConfigInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetFieldLevelEncryptionProfileConfigInput(v *GetFieldLevelEncryptionProfileConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpGetFunction struct {
}

func (*awsRestxml_serializeOpGetFunction) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetFunction) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetFunctionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/function/{Name}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetFunctionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetFunctionInput(v *GetFunctionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	if len(v.Stage) > 0 {
		encoder.SetQuery("Stage").String(string(v.Stage))
	}

	return nil
}

type awsRestxml_serializeOpGetInvalidation struct {
}

func (*awsRestxml_serializeOpGetInvalidation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetInvalidation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetInvalidationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/distribution/{DistributionId}/invalidation/{Id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetInvalidationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetInvalidationInput(v *GetInvalidationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DistributionId == nil || len(*v.DistributionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DistributionId must not be empty")}
	}
	if v.DistributionId != nil {
		if err := encoder.SetURI("DistributionId").String(*v.DistributionId); err != nil {
			return err
		}
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpGetKeyGroup struct {
}

func (*awsRestxml_serializeOpGetKeyGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetKeyGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetKeyGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/key-group/{Id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetKeyGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetKeyGroupInput(v *GetKeyGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpGetKeyGroupConfig struct {
}

func (*awsRestxml_serializeOpGetKeyGroupConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetKeyGroupConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetKeyGroupConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/key-group/{Id}/config")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetKeyGroupConfigInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetKeyGroupConfigInput(v *GetKeyGroupConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpGetMonitoringSubscription struct {
}

func (*awsRestxml_serializeOpGetMonitoringSubscription) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetMonitoringSubscription) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetMonitoringSubscriptionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/distributions/{DistributionId}/monitoring-subscription")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetMonitoringSubscriptionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetMonitoringSubscriptionInput(v *GetMonitoringSubscriptionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DistributionId == nil || len(*v.DistributionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DistributionId must not be empty")}
	}
	if v.DistributionId != nil {
		if err := encoder.SetURI("DistributionId").String(*v.DistributionId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpGetOriginRequestPolicy struct {
}

func (*awsRestxml_serializeOpGetOriginRequestPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetOriginRequestPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetOriginRequestPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/origin-request-policy/{Id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetOriginRequestPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetOriginRequestPolicyInput(v *GetOriginRequestPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpGetOriginRequestPolicyConfig struct {
}

func (*awsRestxml_serializeOpGetOriginRequestPolicyConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetOriginRequestPolicyConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetOriginRequestPolicyConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/origin-request-policy/{Id}/config")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetOriginRequestPolicyConfigInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetOriginRequestPolicyConfigInput(v *GetOriginRequestPolicyConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpGetPublicKey struct {
}

func (*awsRestxml_serializeOpGetPublicKey) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetPublicKey) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetPublicKeyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/public-key/{Id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetPublicKeyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetPublicKeyInput(v *GetPublicKeyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpGetPublicKeyConfig struct {
}

func (*awsRestxml_serializeOpGetPublicKeyConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetPublicKeyConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetPublicKeyConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/public-key/{Id}/config")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetPublicKeyConfigInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetPublicKeyConfigInput(v *GetPublicKeyConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpGetRealtimeLogConfig struct {
}

func (*awsRestxml_serializeOpGetRealtimeLogConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetRealtimeLogConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetRealtimeLogConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/get-realtime-log-config")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "GetRealtimeLogConfigRequest",
		},
		Attr: rootAttr,
	}
	root.Attr = append(root.Attr, smithyxml.NewNamespaceAttribute("", "http://cloudfront.amazonaws.com/doc/2020-05-31/"))
	if err := awsRestxml_serializeOpDocumentGetRealtimeLogConfigInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetRealtimeLogConfigInput(v *GetRealtimeLogConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestxml_serializeOpDocumentGetRealtimeLogConfigInput(v *GetRealtimeLogConfigInput, value smithyxml.Value) error {
	defer value.Close()
	if v.ARN != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ARN",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ARN)
	}
	if v.Name != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Name",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Name)
	}
	return nil
}

type awsRestxml_serializeOpGetResponseHeadersPolicy struct {
}

func (*awsRestxml_serializeOpGetResponseHeadersPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetResponseHeadersPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetResponseHeadersPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/response-headers-policy/{Id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetResponseHeadersPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetResponseHeadersPolicyInput(v *GetResponseHeadersPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpGetResponseHeadersPolicyConfig struct {
}

func (*awsRestxml_serializeOpGetResponseHeadersPolicyConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetResponseHeadersPolicyConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetResponseHeadersPolicyConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/response-headers-policy/{Id}/config")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetResponseHeadersPolicyConfigInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetResponseHeadersPolicyConfigInput(v *GetResponseHeadersPolicyConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpGetStreamingDistribution struct {
}

func (*awsRestxml_serializeOpGetStreamingDistribution) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetStreamingDistribution) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetStreamingDistributionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/streaming-distribution/{Id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetStreamingDistributionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetStreamingDistributionInput(v *GetStreamingDistributionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpGetStreamingDistributionConfig struct {
}

func (*awsRestxml_serializeOpGetStreamingDistributionConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetStreamingDistributionConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetStreamingDistributionConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/streaming-distribution/{Id}/config")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetStreamingDistributionConfigInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetStreamingDistributionConfigInput(v *GetStreamingDistributionConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpListCachePolicies struct {
}

func (*awsRestxml_serializeOpListCachePolicies) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpListCachePolicies) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListCachePoliciesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/cache-policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsListCachePoliciesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsListCachePoliciesInput(v *ListCachePoliciesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Marker != nil {
		encoder.SetQuery("Marker").String(*v.Marker)
	}

	if v.MaxItems != nil {
		encoder.SetQuery("MaxItems").Integer(*v.MaxItems)
	}

	if len(v.Type) > 0 {
		encoder.SetQuery("Type").String(string(v.Type))
	}

	return nil
}

type awsRestxml_serializeOpListCloudFrontOriginAccessIdentities struct {
}

func (*awsRestxml_serializeOpListCloudFrontOriginAccessIdentities) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpListCloudFrontOriginAccessIdentities) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListCloudFrontOriginAccessIdentitiesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/origin-access-identity/cloudfront")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsListCloudFrontOriginAccessIdentitiesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsListCloudFrontOriginAccessIdentitiesInput(v *ListCloudFrontOriginAccessIdentitiesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Marker != nil {
		encoder.SetQuery("Marker").String(*v.Marker)
	}

	if v.MaxItems != nil {
		encoder.SetQuery("MaxItems").Integer(*v.MaxItems)
	}

	return nil
}

type awsRestxml_serializeOpListConflictingAliases struct {
}

func (*awsRestxml_serializeOpListConflictingAliases) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpListConflictingAliases) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListConflictingAliasesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/conflicting-alias")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsListConflictingAliasesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsListConflictingAliasesInput(v *ListConflictingAliasesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Alias != nil {
		encoder.SetQuery("Alias").String(*v.Alias)
	}

	if v.DistributionId != nil {
		encoder.SetQuery("DistributionId").String(*v.DistributionId)
	}

	if v.Marker != nil {
		encoder.SetQuery("Marker").String(*v.Marker)
	}

	if v.MaxItems != nil {
		encoder.SetQuery("MaxItems").Integer(*v.MaxItems)
	}

	return nil
}

type awsRestxml_serializeOpListDistributions struct {
}

func (*awsRestxml_serializeOpListDistributions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpListDistributions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDistributionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/distribution")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsListDistributionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsListDistributionsInput(v *ListDistributionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Marker != nil {
		encoder.SetQuery("Marker").String(*v.Marker)
	}

	if v.MaxItems != nil {
		encoder.SetQuery("MaxItems").Integer(*v.MaxItems)
	}

	return nil
}

type awsRestxml_serializeOpListDistributionsByCachePolicyId struct {
}

func (*awsRestxml_serializeOpListDistributionsByCachePolicyId) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpListDistributionsByCachePolicyId) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDistributionsByCachePolicyIdInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/distributionsByCachePolicyId/{CachePolicyId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsListDistributionsByCachePolicyIdInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsListDistributionsByCachePolicyIdInput(v *ListDistributionsByCachePolicyIdInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CachePolicyId == nil || len(*v.CachePolicyId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member CachePolicyId must not be empty")}
	}
	if v.CachePolicyId != nil {
		if err := encoder.SetURI("CachePolicyId").String(*v.CachePolicyId); err != nil {
			return err
		}
	}

	if v.Marker != nil {
		encoder.SetQuery("Marker").String(*v.Marker)
	}

	if v.MaxItems != nil {
		encoder.SetQuery("MaxItems").Integer(*v.MaxItems)
	}

	return nil
}

type awsRestxml_serializeOpListDistributionsByKeyGroup struct {
}

func (*awsRestxml_serializeOpListDistributionsByKeyGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpListDistributionsByKeyGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDistributionsByKeyGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/distributionsByKeyGroupId/{KeyGroupId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsListDistributionsByKeyGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsListDistributionsByKeyGroupInput(v *ListDistributionsByKeyGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.KeyGroupId == nil || len(*v.KeyGroupId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member KeyGroupId must not be empty")}
	}
	if v.KeyGroupId != nil {
		if err := encoder.SetURI("KeyGroupId").String(*v.KeyGroupId); err != nil {
			return err
		}
	}

	if v.Marker != nil {
		encoder.SetQuery("Marker").String(*v.Marker)
	}

	if v.MaxItems != nil {
		encoder.SetQuery("MaxItems").Integer(*v.MaxItems)
	}

	return nil
}

type awsRestxml_serializeOpListDistributionsByOriginRequestPolicyId struct {
}

func (*awsRestxml_serializeOpListDistributionsByOriginRequestPolicyId) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpListDistributionsByOriginRequestPolicyId) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDistributionsByOriginRequestPolicyIdInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/distributionsByOriginRequestPolicyId/{OriginRequestPolicyId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsListDistributionsByOriginRequestPolicyIdInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsListDistributionsByOriginRequestPolicyIdInput(v *ListDistributionsByOriginRequestPolicyIdInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Marker != nil {
		encoder.SetQuery("Marker").String(*v.Marker)
	}

	if v.MaxItems != nil {
		encoder.SetQuery("MaxItems").Integer(*v.MaxItems)
	}

	if v.OriginRequestPolicyId == nil || len(*v.OriginRequestPolicyId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member OriginRequestPolicyId must not be empty")}
	}
	if v.OriginRequestPolicyId != nil {
		if err := encoder.SetURI("OriginRequestPolicyId").String(*v.OriginRequestPolicyId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpListDistributionsByRealtimeLogConfig struct {
}

func (*awsRestxml_serializeOpListDistributionsByRealtimeLogConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpListDistributionsByRealtimeLogConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDistributionsByRealtimeLogConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/distributionsByRealtimeLogConfig")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "ListDistributionsByRealtimeLogConfigRequest",
		},
		Attr: rootAttr,
	}
	root.Attr = append(root.Attr, smithyxml.NewNamespaceAttribute("", "http://cloudfront.amazonaws.com/doc/2020-05-31/"))
	if err := awsRestxml_serializeOpDocumentListDistributionsByRealtimeLogConfigInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsListDistributionsByRealtimeLogConfigInput(v *ListDistributionsByRealtimeLogConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestxml_serializeOpDocumentListDistributionsByRealtimeLogConfigInput(v *ListDistributionsByRealtimeLogConfigInput, value smithyxml.Value) error {
	defer value.Close()
	if v.Marker != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Marker",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Marker)
	}
	if v.MaxItems != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "MaxItems",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.MaxItems)
	}
	if v.RealtimeLogConfigArn != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "RealtimeLogConfigArn",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.RealtimeLogConfigArn)
	}
	if v.RealtimeLogConfigName != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "RealtimeLogConfigName",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.RealtimeLogConfigName)
	}
	return nil
}

type awsRestxml_serializeOpListDistributionsByResponseHeadersPolicyId struct {
}

func (*awsRestxml_serializeOpListDistributionsByResponseHeadersPolicyId) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpListDistributionsByResponseHeadersPolicyId) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDistributionsByResponseHeadersPolicyIdInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/distributionsByResponseHeadersPolicyId/{ResponseHeadersPolicyId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsListDistributionsByResponseHeadersPolicyIdInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsListDistributionsByResponseHeadersPolicyIdInput(v *ListDistributionsByResponseHeadersPolicyIdInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Marker != nil {
		encoder.SetQuery("Marker").String(*v.Marker)
	}

	if v.MaxItems != nil {
		encoder.SetQuery("MaxItems").Integer(*v.MaxItems)
	}

	if v.ResponseHeadersPolicyId == nil || len(*v.ResponseHeadersPolicyId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResponseHeadersPolicyId must not be empty")}
	}
	if v.ResponseHeadersPolicyId != nil {
		if err := encoder.SetURI("ResponseHeadersPolicyId").String(*v.ResponseHeadersPolicyId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpListDistributionsByWebACLId struct {
}

func (*awsRestxml_serializeOpListDistributionsByWebACLId) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpListDistributionsByWebACLId) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDistributionsByWebACLIdInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/distributionsByWebACLId/{WebACLId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsListDistributionsByWebACLIdInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsListDistributionsByWebACLIdInput(v *ListDistributionsByWebACLIdInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Marker != nil {
		encoder.SetQuery("Marker").String(*v.Marker)
	}

	if v.MaxItems != nil {
		encoder.SetQuery("MaxItems").Integer(*v.MaxItems)
	}

	if v.WebACLId == nil || len(*v.WebACLId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member WebACLId must not be empty")}
	}
	if v.WebACLId != nil {
		if err := encoder.SetURI("WebACLId").String(*v.WebACLId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpListFieldLevelEncryptionConfigs struct {
}

func (*awsRestxml_serializeOpListFieldLevelEncryptionConfigs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpListFieldLevelEncryptionConfigs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListFieldLevelEncryptionConfigsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/field-level-encryption")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsListFieldLevelEncryptionConfigsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsListFieldLevelEncryptionConfigsInput(v *ListFieldLevelEncryptionConfigsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Marker != nil {
		encoder.SetQuery("Marker").String(*v.Marker)
	}

	if v.MaxItems != nil {
		encoder.SetQuery("MaxItems").Integer(*v.MaxItems)
	}

	return nil
}

type awsRestxml_serializeOpListFieldLevelEncryptionProfiles struct {
}

func (*awsRestxml_serializeOpListFieldLevelEncryptionProfiles) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpListFieldLevelEncryptionProfiles) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListFieldLevelEncryptionProfilesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/field-level-encryption-profile")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsListFieldLevelEncryptionProfilesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsListFieldLevelEncryptionProfilesInput(v *ListFieldLevelEncryptionProfilesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Marker != nil {
		encoder.SetQuery("Marker").String(*v.Marker)
	}

	if v.MaxItems != nil {
		encoder.SetQuery("MaxItems").Integer(*v.MaxItems)
	}

	return nil
}

type awsRestxml_serializeOpListFunctions struct {
}

func (*awsRestxml_serializeOpListFunctions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpListFunctions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListFunctionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/function")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsListFunctionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsListFunctionsInput(v *ListFunctionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Marker != nil {
		encoder.SetQuery("Marker").String(*v.Marker)
	}

	if v.MaxItems != nil {
		encoder.SetQuery("MaxItems").Integer(*v.MaxItems)
	}

	if len(v.Stage) > 0 {
		encoder.SetQuery("Stage").String(string(v.Stage))
	}

	return nil
}

type awsRestxml_serializeOpListInvalidations struct {
}

func (*awsRestxml_serializeOpListInvalidations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpListInvalidations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListInvalidationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/distribution/{DistributionId}/invalidation")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsListInvalidationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsListInvalidationsInput(v *ListInvalidationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DistributionId == nil || len(*v.DistributionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DistributionId must not be empty")}
	}
	if v.DistributionId != nil {
		if err := encoder.SetURI("DistributionId").String(*v.DistributionId); err != nil {
			return err
		}
	}

	if v.Marker != nil {
		encoder.SetQuery("Marker").String(*v.Marker)
	}

	if v.MaxItems != nil {
		encoder.SetQuery("MaxItems").Integer(*v.MaxItems)
	}

	return nil
}

type awsRestxml_serializeOpListKeyGroups struct {
}

func (*awsRestxml_serializeOpListKeyGroups) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpListKeyGroups) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListKeyGroupsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/key-group")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsListKeyGroupsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsListKeyGroupsInput(v *ListKeyGroupsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Marker != nil {
		encoder.SetQuery("Marker").String(*v.Marker)
	}

	if v.MaxItems != nil {
		encoder.SetQuery("MaxItems").Integer(*v.MaxItems)
	}

	return nil
}

type awsRestxml_serializeOpListOriginRequestPolicies struct {
}

func (*awsRestxml_serializeOpListOriginRequestPolicies) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpListOriginRequestPolicies) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListOriginRequestPoliciesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/origin-request-policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsListOriginRequestPoliciesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsListOriginRequestPoliciesInput(v *ListOriginRequestPoliciesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Marker != nil {
		encoder.SetQuery("Marker").String(*v.Marker)
	}

	if v.MaxItems != nil {
		encoder.SetQuery("MaxItems").Integer(*v.MaxItems)
	}

	if len(v.Type) > 0 {
		encoder.SetQuery("Type").String(string(v.Type))
	}

	return nil
}

type awsRestxml_serializeOpListPublicKeys struct {
}

func (*awsRestxml_serializeOpListPublicKeys) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpListPublicKeys) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListPublicKeysInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/public-key")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsListPublicKeysInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsListPublicKeysInput(v *ListPublicKeysInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Marker != nil {
		encoder.SetQuery("Marker").String(*v.Marker)
	}

	if v.MaxItems != nil {
		encoder.SetQuery("MaxItems").Integer(*v.MaxItems)
	}

	return nil
}

type awsRestxml_serializeOpListRealtimeLogConfigs struct {
}

func (*awsRestxml_serializeOpListRealtimeLogConfigs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpListRealtimeLogConfigs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListRealtimeLogConfigsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/realtime-log-config")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsListRealtimeLogConfigsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsListRealtimeLogConfigsInput(v *ListRealtimeLogConfigsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Marker != nil {
		encoder.SetQuery("Marker").String(*v.Marker)
	}

	if v.MaxItems != nil {
		encoder.SetQuery("MaxItems").Integer(*v.MaxItems)
	}

	return nil
}

type awsRestxml_serializeOpListResponseHeadersPolicies struct {
}

func (*awsRestxml_serializeOpListResponseHeadersPolicies) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpListResponseHeadersPolicies) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListResponseHeadersPoliciesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/response-headers-policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsListResponseHeadersPoliciesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsListResponseHeadersPoliciesInput(v *ListResponseHeadersPoliciesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Marker != nil {
		encoder.SetQuery("Marker").String(*v.Marker)
	}

	if v.MaxItems != nil {
		encoder.SetQuery("MaxItems").Integer(*v.MaxItems)
	}

	if len(v.Type) > 0 {
		encoder.SetQuery("Type").String(string(v.Type))
	}

	return nil
}

type awsRestxml_serializeOpListStreamingDistributions struct {
}

func (*awsRestxml_serializeOpListStreamingDistributions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpListStreamingDistributions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListStreamingDistributionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/streaming-distribution")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsListStreamingDistributionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsListStreamingDistributionsInput(v *ListStreamingDistributionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Marker != nil {
		encoder.SetQuery("Marker").String(*v.Marker)
	}

	if v.MaxItems != nil {
		encoder.SetQuery("MaxItems").Integer(*v.MaxItems)
	}

	return nil
}

type awsRestxml_serializeOpListTagsForResource struct {
}

func (*awsRestxml_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/tagging")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsListTagsForResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Resource != nil {
		encoder.SetQuery("Resource").String(*v.Resource)
	}

	return nil
}

type awsRestxml_serializeOpPublishFunction struct {
}

func (*awsRestxml_serializeOpPublishFunction) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPublishFunction) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PublishFunctionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/function/{Name}/publish")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPublishFunctionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPublishFunctionInput(v *PublishFunctionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.IfMatch != nil && len(*v.IfMatch) > 0 {
		locationName := "If-Match"
		encoder.SetHeader(locationName).String(*v.IfMatch)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpTagResource struct {
}

func (*awsRestxml_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/tagging?Operation=Tag")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsTagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.Tags != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Tags",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://cloudfront.amazonaws.com/doc/2020-05-31/"))
		if err := awsRestxml_serializeDocumentTags(input.Tags, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Resource != nil {
		encoder.SetQuery("Resource").String(*v.Resource)
	}

	return nil
}

type awsRestxml_serializeOpTestFunction struct {
}

func (*awsRestxml_serializeOpTestFunction) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpTestFunction) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TestFunctionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/function/{Name}/test")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsTestFunctionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "TestFunctionRequest",
		},
		Attr: rootAttr,
	}
	root.Attr = append(root.Attr, smithyxml.NewNamespaceAttribute("", "http://cloudfront.amazonaws.com/doc/2020-05-31/"))
	if err := awsRestxml_serializeOpDocumentTestFunctionInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsTestFunctionInput(v *TestFunctionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.IfMatch != nil && len(*v.IfMatch) > 0 {
		locationName := "If-Match"
		encoder.SetHeader(locationName).String(*v.IfMatch)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

func awsRestxml_serializeOpDocumentTestFunctionInput(v *TestFunctionInput, value smithyxml.Value) error {
	defer value.Close()
	if v.EventObject != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "EventObject",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Base64EncodeBytes(v.EventObject)
	}
	if len(v.Stage) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Stage",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.Stage))
	}
	return nil
}

type awsRestxml_serializeOpUntagResource struct {
}

func (*awsRestxml_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/tagging?Operation=Untag")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsUntagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.TagKeys != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "TagKeys",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://cloudfront.amazonaws.com/doc/2020-05-31/"))
		if err := awsRestxml_serializeDocumentTagKeys(input.TagKeys, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Resource != nil {
		encoder.SetQuery("Resource").String(*v.Resource)
	}

	return nil
}

type awsRestxml_serializeOpUpdateCachePolicy struct {
}

func (*awsRestxml_serializeOpUpdateCachePolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpUpdateCachePolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateCachePolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/cache-policy/{Id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsUpdateCachePolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.CachePolicyConfig != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "CachePolicyConfig",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://cloudfront.amazonaws.com/doc/2020-05-31/"))
		if err := awsRestxml_serializeDocumentCachePolicyConfig(input.CachePolicyConfig, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsUpdateCachePolicyInput(v *UpdateCachePolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	if v.IfMatch != nil && len(*v.IfMatch) > 0 {
		locationName := "If-Match"
		encoder.SetHeader(locationName).String(*v.IfMatch)
	}

	return nil
}

type awsRestxml_serializeOpUpdateCloudFrontOriginAccessIdentity struct {
}

func (*awsRestxml_serializeOpUpdateCloudFrontOriginAccessIdentity) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpUpdateCloudFrontOriginAccessIdentity) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateCloudFrontOriginAccessIdentityInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/origin-access-identity/cloudfront/{Id}/config")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsUpdateCloudFrontOriginAccessIdentityInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.CloudFrontOriginAccessIdentityConfig != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "CloudFrontOriginAccessIdentityConfig",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://cloudfront.amazonaws.com/doc/2020-05-31/"))
		if err := awsRestxml_serializeDocumentCloudFrontOriginAccessIdentityConfig(input.CloudFrontOriginAccessIdentityConfig, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsUpdateCloudFrontOriginAccessIdentityInput(v *UpdateCloudFrontOriginAccessIdentityInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	if v.IfMatch != nil && len(*v.IfMatch) > 0 {
		locationName := "If-Match"
		encoder.SetHeader(locationName).String(*v.IfMatch)
	}

	return nil
}

type awsRestxml_serializeOpUpdateDistribution struct {
}

func (*awsRestxml_serializeOpUpdateDistribution) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpUpdateDistribution) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateDistributionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/distribution/{Id}/config")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsUpdateDistributionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.DistributionConfig != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "DistributionConfig",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://cloudfront.amazonaws.com/doc/2020-05-31/"))
		if err := awsRestxml_serializeDocumentDistributionConfig(input.DistributionConfig, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsUpdateDistributionInput(v *UpdateDistributionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	if v.IfMatch != nil && len(*v.IfMatch) > 0 {
		locationName := "If-Match"
		encoder.SetHeader(locationName).String(*v.IfMatch)
	}

	return nil
}

type awsRestxml_serializeOpUpdateFieldLevelEncryptionConfig struct {
}

func (*awsRestxml_serializeOpUpdateFieldLevelEncryptionConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpUpdateFieldLevelEncryptionConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateFieldLevelEncryptionConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/field-level-encryption/{Id}/config")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsUpdateFieldLevelEncryptionConfigInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.FieldLevelEncryptionConfig != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "FieldLevelEncryptionConfig",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://cloudfront.amazonaws.com/doc/2020-05-31/"))
		if err := awsRestxml_serializeDocumentFieldLevelEncryptionConfig(input.FieldLevelEncryptionConfig, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsUpdateFieldLevelEncryptionConfigInput(v *UpdateFieldLevelEncryptionConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	if v.IfMatch != nil && len(*v.IfMatch) > 0 {
		locationName := "If-Match"
		encoder.SetHeader(locationName).String(*v.IfMatch)
	}

	return nil
}

type awsRestxml_serializeOpUpdateFieldLevelEncryptionProfile struct {
}

func (*awsRestxml_serializeOpUpdateFieldLevelEncryptionProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpUpdateFieldLevelEncryptionProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateFieldLevelEncryptionProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/field-level-encryption-profile/{Id}/config")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsUpdateFieldLevelEncryptionProfileInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.FieldLevelEncryptionProfileConfig != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "FieldLevelEncryptionProfileConfig",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://cloudfront.amazonaws.com/doc/2020-05-31/"))
		if err := awsRestxml_serializeDocumentFieldLevelEncryptionProfileConfig(input.FieldLevelEncryptionProfileConfig, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsUpdateFieldLevelEncryptionProfileInput(v *UpdateFieldLevelEncryptionProfileInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	if v.IfMatch != nil && len(*v.IfMatch) > 0 {
		locationName := "If-Match"
		encoder.SetHeader(locationName).String(*v.IfMatch)
	}

	return nil
}

type awsRestxml_serializeOpUpdateFunction struct {
}

func (*awsRestxml_serializeOpUpdateFunction) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpUpdateFunction) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateFunctionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/function/{Name}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsUpdateFunctionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "UpdateFunctionRequest",
		},
		Attr: rootAttr,
	}
	root.Attr = append(root.Attr, smithyxml.NewNamespaceAttribute("", "http://cloudfront.amazonaws.com/doc/2020-05-31/"))
	if err := awsRestxml_serializeOpDocumentUpdateFunctionInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsUpdateFunctionInput(v *UpdateFunctionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.IfMatch != nil && len(*v.IfMatch) > 0 {
		locationName := "If-Match"
		encoder.SetHeader(locationName).String(*v.IfMatch)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

func awsRestxml_serializeOpDocumentUpdateFunctionInput(v *UpdateFunctionInput, value smithyxml.Value) error {
	defer value.Close()
	if v.FunctionCode != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "FunctionCode",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Base64EncodeBytes(v.FunctionCode)
	}
	if v.FunctionConfig != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "FunctionConfig",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentFunctionConfig(v.FunctionConfig, el); err != nil {
			return err
		}
	}
	return nil
}

type awsRestxml_serializeOpUpdateKeyGroup struct {
}

func (*awsRestxml_serializeOpUpdateKeyGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpUpdateKeyGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateKeyGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/key-group/{Id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsUpdateKeyGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.KeyGroupConfig != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "KeyGroupConfig",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://cloudfront.amazonaws.com/doc/2020-05-31/"))
		if err := awsRestxml_serializeDocumentKeyGroupConfig(input.KeyGroupConfig, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsUpdateKeyGroupInput(v *UpdateKeyGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	if v.IfMatch != nil && len(*v.IfMatch) > 0 {
		locationName := "If-Match"
		encoder.SetHeader(locationName).String(*v.IfMatch)
	}

	return nil
}

type awsRestxml_serializeOpUpdateOriginRequestPolicy struct {
}

func (*awsRestxml_serializeOpUpdateOriginRequestPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpUpdateOriginRequestPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateOriginRequestPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/origin-request-policy/{Id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsUpdateOriginRequestPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.OriginRequestPolicyConfig != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "OriginRequestPolicyConfig",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://cloudfront.amazonaws.com/doc/2020-05-31/"))
		if err := awsRestxml_serializeDocumentOriginRequestPolicyConfig(input.OriginRequestPolicyConfig, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsUpdateOriginRequestPolicyInput(v *UpdateOriginRequestPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	if v.IfMatch != nil && len(*v.IfMatch) > 0 {
		locationName := "If-Match"
		encoder.SetHeader(locationName).String(*v.IfMatch)
	}

	return nil
}

type awsRestxml_serializeOpUpdatePublicKey struct {
}

func (*awsRestxml_serializeOpUpdatePublicKey) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpUpdatePublicKey) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdatePublicKeyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/public-key/{Id}/config")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsUpdatePublicKeyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.PublicKeyConfig != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "PublicKeyConfig",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://cloudfront.amazonaws.com/doc/2020-05-31/"))
		if err := awsRestxml_serializeDocumentPublicKeyConfig(input.PublicKeyConfig, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsUpdatePublicKeyInput(v *UpdatePublicKeyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	if v.IfMatch != nil && len(*v.IfMatch) > 0 {
		locationName := "If-Match"
		encoder.SetHeader(locationName).String(*v.IfMatch)
	}

	return nil
}

type awsRestxml_serializeOpUpdateRealtimeLogConfig struct {
}

func (*awsRestxml_serializeOpUpdateRealtimeLogConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpUpdateRealtimeLogConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateRealtimeLogConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/realtime-log-config")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "UpdateRealtimeLogConfigRequest",
		},
		Attr: rootAttr,
	}
	root.Attr = append(root.Attr, smithyxml.NewNamespaceAttribute("", "http://cloudfront.amazonaws.com/doc/2020-05-31/"))
	if err := awsRestxml_serializeOpDocumentUpdateRealtimeLogConfigInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsUpdateRealtimeLogConfigInput(v *UpdateRealtimeLogConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestxml_serializeOpDocumentUpdateRealtimeLogConfigInput(v *UpdateRealtimeLogConfigInput, value smithyxml.Value) error {
	defer value.Close()
	if v.ARN != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ARN",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ARN)
	}
	if v.EndPoints != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "EndPoints",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentEndPointList(v.EndPoints, el); err != nil {
			return err
		}
	}
	if v.Fields != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Fields",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentFieldList(v.Fields, el); err != nil {
			return err
		}
	}
	if v.Name != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Name",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Name)
	}
	if v.SamplingRate != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "SamplingRate",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Long(*v.SamplingRate)
	}
	return nil
}

type awsRestxml_serializeOpUpdateResponseHeadersPolicy struct {
}

func (*awsRestxml_serializeOpUpdateResponseHeadersPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpUpdateResponseHeadersPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateResponseHeadersPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/response-headers-policy/{Id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsUpdateResponseHeadersPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.ResponseHeadersPolicyConfig != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ResponseHeadersPolicyConfig",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://cloudfront.amazonaws.com/doc/2020-05-31/"))
		if err := awsRestxml_serializeDocumentResponseHeadersPolicyConfig(input.ResponseHeadersPolicyConfig, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsUpdateResponseHeadersPolicyInput(v *UpdateResponseHeadersPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	if v.IfMatch != nil && len(*v.IfMatch) > 0 {
		locationName := "If-Match"
		encoder.SetHeader(locationName).String(*v.IfMatch)
	}

	return nil
}

type awsRestxml_serializeOpUpdateStreamingDistribution struct {
}

func (*awsRestxml_serializeOpUpdateStreamingDistribution) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpUpdateStreamingDistribution) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateStreamingDistributionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-05-31/streaming-distribution/{Id}/config")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsUpdateStreamingDistributionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.StreamingDistributionConfig != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "StreamingDistributionConfig",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://cloudfront.amazonaws.com/doc/2020-05-31/"))
		if err := awsRestxml_serializeDocumentStreamingDistributionConfig(input.StreamingDistributionConfig, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsUpdateStreamingDistributionInput(v *UpdateStreamingDistributionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	if v.IfMatch != nil && len(*v.IfMatch) > 0 {
		locationName := "If-Match"
		encoder.SetHeader(locationName).String(*v.IfMatch)
	}

	return nil
}

func awsRestxml_serializeDocumentAccessControlAllowHeadersList(v []string, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "Header",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		am.String(v[i])
	}
	return nil
}

func awsRestxml_serializeDocumentAccessControlAllowMethodsList(v []types.ResponseHeadersPolicyAccessControlAllowMethodsValues, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "Method",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		am.String(string(v[i]))
	}
	return nil
}

func awsRestxml_serializeDocumentAccessControlAllowOriginsList(v []string, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "Origin",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		am.String(v[i])
	}
	return nil
}

func awsRestxml_serializeDocumentAccessControlExposeHeadersList(v []string, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "Header",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		am.String(v[i])
	}
	return nil
}

func awsRestxml_serializeDocumentAliases(v *types.Aliases, value smithyxml.Value) error {
	defer value.Close()
	if v.Items != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Items",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentAliasList(v.Items, el); err != nil {
			return err
		}
	}
	if v.Quantity != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Quantity",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.Quantity)
	}
	return nil
}

func awsRestxml_serializeDocumentAliasList(v []string, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "CNAME",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		am.String(v[i])
	}
	return nil
}

func awsRestxml_serializeDocumentAllowedMethods(v *types.AllowedMethods, value smithyxml.Value) error {
	defer value.Close()
	if v.CachedMethods != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "CachedMethods",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentCachedMethods(v.CachedMethods, el); err != nil {
			return err
		}
	}
	if v.Items != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Items",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentMethodsList(v.Items, el); err != nil {
			return err
		}
	}
	if v.Quantity != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Quantity",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.Quantity)
	}
	return nil
}

func awsRestxml_serializeDocumentAwsAccountNumberList(v []string, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "AwsAccountNumber",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		am.String(v[i])
	}
	return nil
}

func awsRestxml_serializeDocumentCacheBehavior(v *types.CacheBehavior, value smithyxml.Value) error {
	defer value.Close()
	if v.AllowedMethods != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "AllowedMethods",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentAllowedMethods(v.AllowedMethods, el); err != nil {
			return err
		}
	}
	if v.CachePolicyId != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "CachePolicyId",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.CachePolicyId)
	}
	if v.Compress != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Compress",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(*v.Compress)
	}
	if v.DefaultTTL != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "DefaultTTL",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Long(*v.DefaultTTL)
	}
	if v.FieldLevelEncryptionId != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "FieldLevelEncryptionId",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.FieldLevelEncryptionId)
	}
	if v.ForwardedValues != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ForwardedValues",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentForwardedValues(v.ForwardedValues, el); err != nil {
			return err
		}
	}
	if v.FunctionAssociations != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "FunctionAssociations",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentFunctionAssociations(v.FunctionAssociations, el); err != nil {
			return err
		}
	}
	if v.LambdaFunctionAssociations != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "LambdaFunctionAssociations",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentLambdaFunctionAssociations(v.LambdaFunctionAssociations, el); err != nil {
			return err
		}
	}
	if v.MaxTTL != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "MaxTTL",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Long(*v.MaxTTL)
	}
	if v.MinTTL != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "MinTTL",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Long(*v.MinTTL)
	}
	if v.OriginRequestPolicyId != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "OriginRequestPolicyId",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.OriginRequestPolicyId)
	}
	if v.PathPattern != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "PathPattern",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.PathPattern)
	}
	if v.RealtimeLogConfigArn != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "RealtimeLogConfigArn",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.RealtimeLogConfigArn)
	}
	if v.ResponseHeadersPolicyId != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ResponseHeadersPolicyId",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ResponseHeadersPolicyId)
	}
	if v.SmoothStreaming != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "SmoothStreaming",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(*v.SmoothStreaming)
	}
	if v.TargetOriginId != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "TargetOriginId",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.TargetOriginId)
	}
	if v.TrustedKeyGroups != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "TrustedKeyGroups",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentTrustedKeyGroups(v.TrustedKeyGroups, el); err != nil {
			return err
		}
	}
	if v.TrustedSigners != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "TrustedSigners",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentTrustedSigners(v.TrustedSigners, el); err != nil {
			return err
		}
	}
	if len(v.ViewerProtocolPolicy) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ViewerProtocolPolicy",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.ViewerProtocolPolicy))
	}
	return nil
}

func awsRestxml_serializeDocumentCacheBehaviorList(v []types.CacheBehavior, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "CacheBehavior",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentCacheBehavior(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentCacheBehaviors(v *types.CacheBehaviors, value smithyxml.Value) error {
	defer value.Close()
	if v.Items != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Items",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentCacheBehaviorList(v.Items, el); err != nil {
			return err
		}
	}
	if v.Quantity != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Quantity",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.Quantity)
	}
	return nil
}

func awsRestxml_serializeDocumentCachedMethods(v *types.CachedMethods, value smithyxml.Value) error {
	defer value.Close()
	if v.Items != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Items",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentMethodsList(v.Items, el); err != nil {
			return err
		}
	}
	if v.Quantity != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Quantity",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.Quantity)
	}
	return nil
}

func awsRestxml_serializeDocumentCachePolicyConfig(v *types.CachePolicyConfig, value smithyxml.Value) error {
	defer value.Close()
	if v.Comment != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Comment",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Comment)
	}
	if v.DefaultTTL != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "DefaultTTL",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Long(*v.DefaultTTL)
	}
	if v.MaxTTL != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "MaxTTL",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Long(*v.MaxTTL)
	}
	if v.MinTTL != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "MinTTL",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Long(*v.MinTTL)
	}
	if v.Name != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Name",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Name)
	}
	if v.ParametersInCacheKeyAndForwardedToOrigin != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ParametersInCacheKeyAndForwardedToOrigin",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentParametersInCacheKeyAndForwardedToOrigin(v.ParametersInCacheKeyAndForwardedToOrigin, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentCachePolicyCookiesConfig(v *types.CachePolicyCookiesConfig, value smithyxml.Value) error {
	defer value.Close()
	if len(v.CookieBehavior) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "CookieBehavior",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.CookieBehavior))
	}
	if v.Cookies != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Cookies",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentCookieNames(v.Cookies, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentCachePolicyHeadersConfig(v *types.CachePolicyHeadersConfig, value smithyxml.Value) error {
	defer value.Close()
	if len(v.HeaderBehavior) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "HeaderBehavior",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.HeaderBehavior))
	}
	if v.Headers != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Headers",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentHeaders(v.Headers, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentCachePolicyQueryStringsConfig(v *types.CachePolicyQueryStringsConfig, value smithyxml.Value) error {
	defer value.Close()
	if len(v.QueryStringBehavior) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "QueryStringBehavior",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.QueryStringBehavior))
	}
	if v.QueryStrings != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "QueryStrings",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentQueryStringNames(v.QueryStrings, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentCloudFrontOriginAccessIdentityConfig(v *types.CloudFrontOriginAccessIdentityConfig, value smithyxml.Value) error {
	defer value.Close()
	if v.CallerReference != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "CallerReference",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.CallerReference)
	}
	if v.Comment != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Comment",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Comment)
	}
	return nil
}

func awsRestxml_serializeDocumentContentTypeProfile(v *types.ContentTypeProfile, value smithyxml.Value) error {
	defer value.Close()
	if v.ContentType != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ContentType",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ContentType)
	}
	if len(v.Format) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Format",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.Format))
	}
	if v.ProfileId != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ProfileId",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ProfileId)
	}
	return nil
}

func awsRestxml_serializeDocumentContentTypeProfileConfig(v *types.ContentTypeProfileConfig, value smithyxml.Value) error {
	defer value.Close()
	if v.ContentTypeProfiles != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ContentTypeProfiles",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentContentTypeProfiles(v.ContentTypeProfiles, el); err != nil {
			return err
		}
	}
	if v.ForwardWhenContentTypeIsUnknown != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ForwardWhenContentTypeIsUnknown",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(*v.ForwardWhenContentTypeIsUnknown)
	}
	return nil
}

func awsRestxml_serializeDocumentContentTypeProfileList(v []types.ContentTypeProfile, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "ContentTypeProfile",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentContentTypeProfile(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentContentTypeProfiles(v *types.ContentTypeProfiles, value smithyxml.Value) error {
	defer value.Close()
	if v.Items != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Items",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentContentTypeProfileList(v.Items, el); err != nil {
			return err
		}
	}
	if v.Quantity != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Quantity",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.Quantity)
	}
	return nil
}

func awsRestxml_serializeDocumentCookieNameList(v []string, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "Name",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		am.String(v[i])
	}
	return nil
}

func awsRestxml_serializeDocumentCookieNames(v *types.CookieNames, value smithyxml.Value) error {
	defer value.Close()
	if v.Items != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Items",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentCookieNameList(v.Items, el); err != nil {
			return err
		}
	}
	if v.Quantity != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Quantity",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.Quantity)
	}
	return nil
}

func awsRestxml_serializeDocumentCookiePreference(v *types.CookiePreference, value smithyxml.Value) error {
	defer value.Close()
	if len(v.Forward) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Forward",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.Forward))
	}
	if v.WhitelistedNames != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "WhitelistedNames",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentCookieNames(v.WhitelistedNames, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentCustomErrorResponse(v *types.CustomErrorResponse, value smithyxml.Value) error {
	defer value.Close()
	if v.ErrorCachingMinTTL != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ErrorCachingMinTTL",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Long(*v.ErrorCachingMinTTL)
	}
	if v.ErrorCode != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ErrorCode",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.ErrorCode)
	}
	if v.ResponseCode != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ResponseCode",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ResponseCode)
	}
	if v.ResponsePagePath != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ResponsePagePath",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ResponsePagePath)
	}
	return nil
}

func awsRestxml_serializeDocumentCustomErrorResponseList(v []types.CustomErrorResponse, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "CustomErrorResponse",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentCustomErrorResponse(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentCustomErrorResponses(v *types.CustomErrorResponses, value smithyxml.Value) error {
	defer value.Close()
	if v.Items != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Items",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentCustomErrorResponseList(v.Items, el); err != nil {
			return err
		}
	}
	if v.Quantity != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Quantity",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.Quantity)
	}
	return nil
}

func awsRestxml_serializeDocumentCustomHeaders(v *types.CustomHeaders, value smithyxml.Value) error {
	defer value.Close()
	if v.Items != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Items",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentOriginCustomHeadersList(v.Items, el); err != nil {
			return err
		}
	}
	if v.Quantity != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Quantity",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.Quantity)
	}
	return nil
}

func awsRestxml_serializeDocumentCustomOriginConfig(v *types.CustomOriginConfig, value smithyxml.Value) error {
	defer value.Close()
	if v.HTTPPort != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "HTTPPort",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.HTTPPort)
	}
	if v.HTTPSPort != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "HTTPSPort",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.HTTPSPort)
	}
	if v.OriginKeepaliveTimeout != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "OriginKeepaliveTimeout",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.OriginKeepaliveTimeout)
	}
	if len(v.OriginProtocolPolicy) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "OriginProtocolPolicy",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.OriginProtocolPolicy))
	}
	if v.OriginReadTimeout != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "OriginReadTimeout",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.OriginReadTimeout)
	}
	if v.OriginSslProtocols != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "OriginSslProtocols",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentOriginSslProtocols(v.OriginSslProtocols, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentDefaultCacheBehavior(v *types.DefaultCacheBehavior, value smithyxml.Value) error {
	defer value.Close()
	if v.AllowedMethods != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "AllowedMethods",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentAllowedMethods(v.AllowedMethods, el); err != nil {
			return err
		}
	}
	if v.CachePolicyId != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "CachePolicyId",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.CachePolicyId)
	}
	if v.Compress != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Compress",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(*v.Compress)
	}
	if v.DefaultTTL != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "DefaultTTL",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Long(*v.DefaultTTL)
	}
	if v.FieldLevelEncryptionId != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "FieldLevelEncryptionId",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.FieldLevelEncryptionId)
	}
	if v.ForwardedValues != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ForwardedValues",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentForwardedValues(v.ForwardedValues, el); err != nil {
			return err
		}
	}
	if v.FunctionAssociations != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "FunctionAssociations",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentFunctionAssociations(v.FunctionAssociations, el); err != nil {
			return err
		}
	}
	if v.LambdaFunctionAssociations != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "LambdaFunctionAssociations",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentLambdaFunctionAssociations(v.LambdaFunctionAssociations, el); err != nil {
			return err
		}
	}
	if v.MaxTTL != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "MaxTTL",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Long(*v.MaxTTL)
	}
	if v.MinTTL != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "MinTTL",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Long(*v.MinTTL)
	}
	if v.OriginRequestPolicyId != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "OriginRequestPolicyId",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.OriginRequestPolicyId)
	}
	if v.RealtimeLogConfigArn != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "RealtimeLogConfigArn",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.RealtimeLogConfigArn)
	}
	if v.ResponseHeadersPolicyId != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ResponseHeadersPolicyId",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ResponseHeadersPolicyId)
	}
	if v.SmoothStreaming != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "SmoothStreaming",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(*v.SmoothStreaming)
	}
	if v.TargetOriginId != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "TargetOriginId",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.TargetOriginId)
	}
	if v.TrustedKeyGroups != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "TrustedKeyGroups",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentTrustedKeyGroups(v.TrustedKeyGroups, el); err != nil {
			return err
		}
	}
	if v.TrustedSigners != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "TrustedSigners",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentTrustedSigners(v.TrustedSigners, el); err != nil {
			return err
		}
	}
	if len(v.ViewerProtocolPolicy) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ViewerProtocolPolicy",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.ViewerProtocolPolicy))
	}
	return nil
}

func awsRestxml_serializeDocumentDistributionConfig(v *types.DistributionConfig, value smithyxml.Value) error {
	defer value.Close()
	if v.Aliases != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Aliases",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentAliases(v.Aliases, el); err != nil {
			return err
		}
	}
	if v.CacheBehaviors != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "CacheBehaviors",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentCacheBehaviors(v.CacheBehaviors, el); err != nil {
			return err
		}
	}
	if v.CallerReference != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "CallerReference",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.CallerReference)
	}
	if v.Comment != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Comment",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Comment)
	}
	if v.CustomErrorResponses != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "CustomErrorResponses",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentCustomErrorResponses(v.CustomErrorResponses, el); err != nil {
			return err
		}
	}
	if v.DefaultCacheBehavior != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "DefaultCacheBehavior",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentDefaultCacheBehavior(v.DefaultCacheBehavior, el); err != nil {
			return err
		}
	}
	if v.DefaultRootObject != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "DefaultRootObject",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.DefaultRootObject)
	}
	if v.Enabled != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Enabled",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(*v.Enabled)
	}
	if len(v.HttpVersion) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "HttpVersion",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.HttpVersion))
	}
	if v.IsIPV6Enabled != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "IsIPV6Enabled",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(*v.IsIPV6Enabled)
	}
	if v.Logging != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Logging",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentLoggingConfig(v.Logging, el); err != nil {
			return err
		}
	}
	if v.OriginGroups != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "OriginGroups",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentOriginGroups(v.OriginGroups, el); err != nil {
			return err
		}
	}
	if v.Origins != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Origins",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentOrigins(v.Origins, el); err != nil {
			return err
		}
	}
	if len(v.PriceClass) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "PriceClass",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.PriceClass))
	}
	if v.Restrictions != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Restrictions",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentRestrictions(v.Restrictions, el); err != nil {
			return err
		}
	}
	if v.ViewerCertificate != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ViewerCertificate",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentViewerCertificate(v.ViewerCertificate, el); err != nil {
			return err
		}
	}
	if v.WebACLId != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "WebACLId",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.WebACLId)
	}
	return nil
}

func awsRestxml_serializeDocumentDistributionConfigWithTags(v *types.DistributionConfigWithTags, value smithyxml.Value) error {
	defer value.Close()
	if v.DistributionConfig != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "DistributionConfig",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentDistributionConfig(v.DistributionConfig, el); err != nil {
			return err
		}
	}
	if v.Tags != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Tags",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentTags(v.Tags, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentEncryptionEntities(v *types.EncryptionEntities, value smithyxml.Value) error {
	defer value.Close()
	if v.Items != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Items",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentEncryptionEntityList(v.Items, el); err != nil {
			return err
		}
	}
	if v.Quantity != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Quantity",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.Quantity)
	}
	return nil
}

func awsRestxml_serializeDocumentEncryptionEntity(v *types.EncryptionEntity, value smithyxml.Value) error {
	defer value.Close()
	if v.FieldPatterns != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "FieldPatterns",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentFieldPatterns(v.FieldPatterns, el); err != nil {
			return err
		}
	}
	if v.ProviderId != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ProviderId",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ProviderId)
	}
	if v.PublicKeyId != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "PublicKeyId",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.PublicKeyId)
	}
	return nil
}

func awsRestxml_serializeDocumentEncryptionEntityList(v []types.EncryptionEntity, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "EncryptionEntity",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentEncryptionEntity(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentEndPoint(v *types.EndPoint, value smithyxml.Value) error {
	defer value.Close()
	if v.KinesisStreamConfig != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "KinesisStreamConfig",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentKinesisStreamConfig(v.KinesisStreamConfig, el); err != nil {
			return err
		}
	}
	if v.StreamType != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "StreamType",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.StreamType)
	}
	return nil
}

func awsRestxml_serializeDocumentEndPointList(v []types.EndPoint, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	array = value.Array()
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentEndPoint(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentFieldLevelEncryptionConfig(v *types.FieldLevelEncryptionConfig, value smithyxml.Value) error {
	defer value.Close()
	if v.CallerReference != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "CallerReference",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.CallerReference)
	}
	if v.Comment != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Comment",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Comment)
	}
	if v.ContentTypeProfileConfig != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ContentTypeProfileConfig",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentContentTypeProfileConfig(v.ContentTypeProfileConfig, el); err != nil {
			return err
		}
	}
	if v.QueryArgProfileConfig != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "QueryArgProfileConfig",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentQueryArgProfileConfig(v.QueryArgProfileConfig, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentFieldLevelEncryptionProfileConfig(v *types.FieldLevelEncryptionProfileConfig, value smithyxml.Value) error {
	defer value.Close()
	if v.CallerReference != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "CallerReference",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.CallerReference)
	}
	if v.Comment != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Comment",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Comment)
	}
	if v.EncryptionEntities != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "EncryptionEntities",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentEncryptionEntities(v.EncryptionEntities, el); err != nil {
			return err
		}
	}
	if v.Name != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Name",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Name)
	}
	return nil
}

func awsRestxml_serializeDocumentFieldList(v []string, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "Field",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		am.String(v[i])
	}
	return nil
}

func awsRestxml_serializeDocumentFieldPatternList(v []string, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "FieldPattern",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		am.String(v[i])
	}
	return nil
}

func awsRestxml_serializeDocumentFieldPatterns(v *types.FieldPatterns, value smithyxml.Value) error {
	defer value.Close()
	if v.Items != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Items",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentFieldPatternList(v.Items, el); err != nil {
			return err
		}
	}
	if v.Quantity != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Quantity",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.Quantity)
	}
	return nil
}

func awsRestxml_serializeDocumentForwardedValues(v *types.ForwardedValues, value smithyxml.Value) error {
	defer value.Close()
	if v.Cookies != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Cookies",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentCookiePreference(v.Cookies, el); err != nil {
			return err
		}
	}
	if v.Headers != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Headers",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentHeaders(v.Headers, el); err != nil {
			return err
		}
	}
	if v.QueryString != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "QueryString",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(*v.QueryString)
	}
	if v.QueryStringCacheKeys != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "QueryStringCacheKeys",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentQueryStringCacheKeys(v.QueryStringCacheKeys, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentFunctionAssociation(v *types.FunctionAssociation, value smithyxml.Value) error {
	defer value.Close()
	if len(v.EventType) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "EventType",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.EventType))
	}
	if v.FunctionARN != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "FunctionARN",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.FunctionARN)
	}
	return nil
}

func awsRestxml_serializeDocumentFunctionAssociationList(v []types.FunctionAssociation, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "FunctionAssociation",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentFunctionAssociation(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentFunctionAssociations(v *types.FunctionAssociations, value smithyxml.Value) error {
	defer value.Close()
	if v.Items != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Items",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentFunctionAssociationList(v.Items, el); err != nil {
			return err
		}
	}
	if v.Quantity != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Quantity",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.Quantity)
	}
	return nil
}

func awsRestxml_serializeDocumentFunctionConfig(v *types.FunctionConfig, value smithyxml.Value) error {
	defer value.Close()
	if v.Comment != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Comment",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Comment)
	}
	if len(v.Runtime) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Runtime",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.Runtime))
	}
	return nil
}

func awsRestxml_serializeDocumentGeoRestriction(v *types.GeoRestriction, value smithyxml.Value) error {
	defer value.Close()
	if v.Items != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Items",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentLocationList(v.Items, el); err != nil {
			return err
		}
	}
	if v.Quantity != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Quantity",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.Quantity)
	}
	if len(v.RestrictionType) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "RestrictionType",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.RestrictionType))
	}
	return nil
}

func awsRestxml_serializeDocumentHeaderList(v []string, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "Name",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		am.String(v[i])
	}
	return nil
}

func awsRestxml_serializeDocumentHeaders(v *types.Headers, value smithyxml.Value) error {
	defer value.Close()
	if v.Items != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Items",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentHeaderList(v.Items, el); err != nil {
			return err
		}
	}
	if v.Quantity != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Quantity",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.Quantity)
	}
	return nil
}

func awsRestxml_serializeDocumentInvalidationBatch(v *types.InvalidationBatch, value smithyxml.Value) error {
	defer value.Close()
	if v.CallerReference != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "CallerReference",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.CallerReference)
	}
	if v.Paths != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Paths",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentPaths(v.Paths, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentKeyGroupConfig(v *types.KeyGroupConfig, value smithyxml.Value) error {
	defer value.Close()
	if v.Comment != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Comment",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Comment)
	}
	if v.Items != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Items",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentPublicKeyIdList(v.Items, el); err != nil {
			return err
		}
	}
	if v.Name != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Name",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Name)
	}
	return nil
}

func awsRestxml_serializeDocumentKinesisStreamConfig(v *types.KinesisStreamConfig, value smithyxml.Value) error {
	defer value.Close()
	if v.RoleARN != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "RoleARN",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.RoleARN)
	}
	if v.StreamARN != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "StreamARN",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.StreamARN)
	}
	return nil
}

func awsRestxml_serializeDocumentLambdaFunctionAssociation(v *types.LambdaFunctionAssociation, value smithyxml.Value) error {
	defer value.Close()
	if len(v.EventType) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "EventType",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.EventType))
	}
	if v.IncludeBody != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "IncludeBody",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(*v.IncludeBody)
	}
	if v.LambdaFunctionARN != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "LambdaFunctionARN",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.LambdaFunctionARN)
	}
	return nil
}

func awsRestxml_serializeDocumentLambdaFunctionAssociationList(v []types.LambdaFunctionAssociation, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "LambdaFunctionAssociation",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentLambdaFunctionAssociation(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentLambdaFunctionAssociations(v *types.LambdaFunctionAssociations, value smithyxml.Value) error {
	defer value.Close()
	if v.Items != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Items",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentLambdaFunctionAssociationList(v.Items, el); err != nil {
			return err
		}
	}
	if v.Quantity != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Quantity",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.Quantity)
	}
	return nil
}

func awsRestxml_serializeDocumentLocationList(v []string, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "Location",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		am.String(v[i])
	}
	return nil
}

func awsRestxml_serializeDocumentLoggingConfig(v *types.LoggingConfig, value smithyxml.Value) error {
	defer value.Close()
	if v.Bucket != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Bucket",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Bucket)
	}
	if v.Enabled != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Enabled",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(*v.Enabled)
	}
	if v.IncludeCookies != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "IncludeCookies",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(*v.IncludeCookies)
	}
	if v.Prefix != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Prefix",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Prefix)
	}
	return nil
}

func awsRestxml_serializeDocumentMethodsList(v []types.Method, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "Method",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		am.String(string(v[i]))
	}
	return nil
}

func awsRestxml_serializeDocumentMonitoringSubscription(v *types.MonitoringSubscription, value smithyxml.Value) error {
	defer value.Close()
	if v.RealtimeMetricsSubscriptionConfig != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "RealtimeMetricsSubscriptionConfig",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentRealtimeMetricsSubscriptionConfig(v.RealtimeMetricsSubscriptionConfig, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentOrigin(v *types.Origin, value smithyxml.Value) error {
	defer value.Close()
	if v.ConnectionAttempts != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ConnectionAttempts",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.ConnectionAttempts)
	}
	if v.ConnectionTimeout != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ConnectionTimeout",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.ConnectionTimeout)
	}
	if v.CustomHeaders != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "CustomHeaders",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentCustomHeaders(v.CustomHeaders, el); err != nil {
			return err
		}
	}
	if v.CustomOriginConfig != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "CustomOriginConfig",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentCustomOriginConfig(v.CustomOriginConfig, el); err != nil {
			return err
		}
	}
	if v.DomainName != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "DomainName",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.DomainName)
	}
	if v.Id != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Id",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Id)
	}
	if v.OriginPath != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "OriginPath",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.OriginPath)
	}
	if v.OriginShield != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "OriginShield",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentOriginShield(v.OriginShield, el); err != nil {
			return err
		}
	}
	if v.S3OriginConfig != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "S3OriginConfig",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentS3OriginConfig(v.S3OriginConfig, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentOriginCustomHeader(v *types.OriginCustomHeader, value smithyxml.Value) error {
	defer value.Close()
	if v.HeaderName != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "HeaderName",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.HeaderName)
	}
	if v.HeaderValue != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "HeaderValue",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.HeaderValue)
	}
	return nil
}

func awsRestxml_serializeDocumentOriginCustomHeadersList(v []types.OriginCustomHeader, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "OriginCustomHeader",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentOriginCustomHeader(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentOriginGroup(v *types.OriginGroup, value smithyxml.Value) error {
	defer value.Close()
	if v.FailoverCriteria != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "FailoverCriteria",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentOriginGroupFailoverCriteria(v.FailoverCriteria, el); err != nil {
			return err
		}
	}
	if v.Id != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Id",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Id)
	}
	if v.Members != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Members",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentOriginGroupMembers(v.Members, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentOriginGroupFailoverCriteria(v *types.OriginGroupFailoverCriteria, value smithyxml.Value) error {
	defer value.Close()
	if v.StatusCodes != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "StatusCodes",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentStatusCodes(v.StatusCodes, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentOriginGroupList(v []types.OriginGroup, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "OriginGroup",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentOriginGroup(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentOriginGroupMember(v *types.OriginGroupMember, value smithyxml.Value) error {
	defer value.Close()
	if v.OriginId != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "OriginId",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.OriginId)
	}
	return nil
}

func awsRestxml_serializeDocumentOriginGroupMemberList(v []types.OriginGroupMember, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "OriginGroupMember",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentOriginGroupMember(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentOriginGroupMembers(v *types.OriginGroupMembers, value smithyxml.Value) error {
	defer value.Close()
	if v.Items != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Items",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentOriginGroupMemberList(v.Items, el); err != nil {
			return err
		}
	}
	if v.Quantity != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Quantity",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.Quantity)
	}
	return nil
}

func awsRestxml_serializeDocumentOriginGroups(v *types.OriginGroups, value smithyxml.Value) error {
	defer value.Close()
	if v.Items != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Items",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentOriginGroupList(v.Items, el); err != nil {
			return err
		}
	}
	if v.Quantity != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Quantity",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.Quantity)
	}
	return nil
}

func awsRestxml_serializeDocumentOriginList(v []types.Origin, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "Origin",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentOrigin(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentOriginRequestPolicyConfig(v *types.OriginRequestPolicyConfig, value smithyxml.Value) error {
	defer value.Close()
	if v.Comment != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Comment",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Comment)
	}
	if v.CookiesConfig != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "CookiesConfig",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentOriginRequestPolicyCookiesConfig(v.CookiesConfig, el); err != nil {
			return err
		}
	}
	if v.HeadersConfig != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "HeadersConfig",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentOriginRequestPolicyHeadersConfig(v.HeadersConfig, el); err != nil {
			return err
		}
	}
	if v.Name != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Name",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Name)
	}
	if v.QueryStringsConfig != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "QueryStringsConfig",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentOriginRequestPolicyQueryStringsConfig(v.QueryStringsConfig, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentOriginRequestPolicyCookiesConfig(v *types.OriginRequestPolicyCookiesConfig, value smithyxml.Value) error {
	defer value.Close()
	if len(v.CookieBehavior) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "CookieBehavior",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.CookieBehavior))
	}
	if v.Cookies != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Cookies",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentCookieNames(v.Cookies, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentOriginRequestPolicyHeadersConfig(v *types.OriginRequestPolicyHeadersConfig, value smithyxml.Value) error {
	defer value.Close()
	if len(v.HeaderBehavior) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "HeaderBehavior",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.HeaderBehavior))
	}
	if v.Headers != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Headers",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentHeaders(v.Headers, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentOriginRequestPolicyQueryStringsConfig(v *types.OriginRequestPolicyQueryStringsConfig, value smithyxml.Value) error {
	defer value.Close()
	if len(v.QueryStringBehavior) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "QueryStringBehavior",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.QueryStringBehavior))
	}
	if v.QueryStrings != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "QueryStrings",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentQueryStringNames(v.QueryStrings, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentOrigins(v *types.Origins, value smithyxml.Value) error {
	defer value.Close()
	if v.Items != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Items",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentOriginList(v.Items, el); err != nil {
			return err
		}
	}
	if v.Quantity != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Quantity",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.Quantity)
	}
	return nil
}

func awsRestxml_serializeDocumentOriginShield(v *types.OriginShield, value smithyxml.Value) error {
	defer value.Close()
	if v.Enabled != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Enabled",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(*v.Enabled)
	}
	if v.OriginShieldRegion != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "OriginShieldRegion",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.OriginShieldRegion)
	}
	return nil
}

func awsRestxml_serializeDocumentOriginSslProtocols(v *types.OriginSslProtocols, value smithyxml.Value) error {
	defer value.Close()
	if v.Items != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Items",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentSslProtocolsList(v.Items, el); err != nil {
			return err
		}
	}
	if v.Quantity != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Quantity",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.Quantity)
	}
	return nil
}

func awsRestxml_serializeDocumentParametersInCacheKeyAndForwardedToOrigin(v *types.ParametersInCacheKeyAndForwardedToOrigin, value smithyxml.Value) error {
	defer value.Close()
	if v.CookiesConfig != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "CookiesConfig",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentCachePolicyCookiesConfig(v.CookiesConfig, el); err != nil {
			return err
		}
	}
	if v.EnableAcceptEncodingBrotli != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "EnableAcceptEncodingBrotli",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(*v.EnableAcceptEncodingBrotli)
	}
	if v.EnableAcceptEncodingGzip != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "EnableAcceptEncodingGzip",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(*v.EnableAcceptEncodingGzip)
	}
	if v.HeadersConfig != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "HeadersConfig",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentCachePolicyHeadersConfig(v.HeadersConfig, el); err != nil {
			return err
		}
	}
	if v.QueryStringsConfig != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "QueryStringsConfig",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentCachePolicyQueryStringsConfig(v.QueryStringsConfig, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentPathList(v []string, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "Path",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		am.String(v[i])
	}
	return nil
}

func awsRestxml_serializeDocumentPaths(v *types.Paths, value smithyxml.Value) error {
	defer value.Close()
	if v.Items != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Items",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentPathList(v.Items, el); err != nil {
			return err
		}
	}
	if v.Quantity != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Quantity",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.Quantity)
	}
	return nil
}

func awsRestxml_serializeDocumentPublicKeyConfig(v *types.PublicKeyConfig, value smithyxml.Value) error {
	defer value.Close()
	if v.CallerReference != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "CallerReference",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.CallerReference)
	}
	if v.Comment != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Comment",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Comment)
	}
	if v.EncodedKey != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "EncodedKey",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.EncodedKey)
	}
	if v.Name != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Name",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Name)
	}
	return nil
}

func awsRestxml_serializeDocumentPublicKeyIdList(v []string, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "PublicKey",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		am.String(v[i])
	}
	return nil
}

func awsRestxml_serializeDocumentQueryArgProfile(v *types.QueryArgProfile, value smithyxml.Value) error {
	defer value.Close()
	if v.ProfileId != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ProfileId",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ProfileId)
	}
	if v.QueryArg != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "QueryArg",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.QueryArg)
	}
	return nil
}

func awsRestxml_serializeDocumentQueryArgProfileConfig(v *types.QueryArgProfileConfig, value smithyxml.Value) error {
	defer value.Close()
	if v.ForwardWhenQueryArgProfileIsUnknown != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ForwardWhenQueryArgProfileIsUnknown",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(*v.ForwardWhenQueryArgProfileIsUnknown)
	}
	if v.QueryArgProfiles != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "QueryArgProfiles",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentQueryArgProfiles(v.QueryArgProfiles, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentQueryArgProfileList(v []types.QueryArgProfile, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "QueryArgProfile",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentQueryArgProfile(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentQueryArgProfiles(v *types.QueryArgProfiles, value smithyxml.Value) error {
	defer value.Close()
	if v.Items != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Items",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentQueryArgProfileList(v.Items, el); err != nil {
			return err
		}
	}
	if v.Quantity != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Quantity",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.Quantity)
	}
	return nil
}

func awsRestxml_serializeDocumentQueryStringCacheKeys(v *types.QueryStringCacheKeys, value smithyxml.Value) error {
	defer value.Close()
	if v.Items != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Items",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentQueryStringCacheKeysList(v.Items, el); err != nil {
			return err
		}
	}
	if v.Quantity != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Quantity",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.Quantity)
	}
	return nil
}

func awsRestxml_serializeDocumentQueryStringCacheKeysList(v []string, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "Name",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		am.String(v[i])
	}
	return nil
}

func awsRestxml_serializeDocumentQueryStringNames(v *types.QueryStringNames, value smithyxml.Value) error {
	defer value.Close()
	if v.Items != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Items",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentQueryStringNamesList(v.Items, el); err != nil {
			return err
		}
	}
	if v.Quantity != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Quantity",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.Quantity)
	}
	return nil
}

func awsRestxml_serializeDocumentQueryStringNamesList(v []string, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "Name",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		am.String(v[i])
	}
	return nil
}

func awsRestxml_serializeDocumentRealtimeMetricsSubscriptionConfig(v *types.RealtimeMetricsSubscriptionConfig, value smithyxml.Value) error {
	defer value.Close()
	if len(v.RealtimeMetricsSubscriptionStatus) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "RealtimeMetricsSubscriptionStatus",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.RealtimeMetricsSubscriptionStatus))
	}
	return nil
}

func awsRestxml_serializeDocumentResponseHeadersPolicyAccessControlAllowHeaders(v *types.ResponseHeadersPolicyAccessControlAllowHeaders, value smithyxml.Value) error {
	defer value.Close()
	if v.Items != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Items",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentAccessControlAllowHeadersList(v.Items, el); err != nil {
			return err
		}
	}
	if v.Quantity != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Quantity",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.Quantity)
	}
	return nil
}

func awsRestxml_serializeDocumentResponseHeadersPolicyAccessControlAllowMethods(v *types.ResponseHeadersPolicyAccessControlAllowMethods, value smithyxml.Value) error {
	defer value.Close()
	if v.Items != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Items",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentAccessControlAllowMethodsList(v.Items, el); err != nil {
			return err
		}
	}
	if v.Quantity != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Quantity",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.Quantity)
	}
	return nil
}

func awsRestxml_serializeDocumentResponseHeadersPolicyAccessControlAllowOrigins(v *types.ResponseHeadersPolicyAccessControlAllowOrigins, value smithyxml.Value) error {
	defer value.Close()
	if v.Items != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Items",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentAccessControlAllowOriginsList(v.Items, el); err != nil {
			return err
		}
	}
	if v.Quantity != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Quantity",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.Quantity)
	}
	return nil
}

func awsRestxml_serializeDocumentResponseHeadersPolicyAccessControlExposeHeaders(v *types.ResponseHeadersPolicyAccessControlExposeHeaders, value smithyxml.Value) error {
	defer value.Close()
	if v.Items != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Items",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentAccessControlExposeHeadersList(v.Items, el); err != nil {
			return err
		}
	}
	if v.Quantity != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Quantity",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.Quantity)
	}
	return nil
}

func awsRestxml_serializeDocumentResponseHeadersPolicyConfig(v *types.ResponseHeadersPolicyConfig, value smithyxml.Value) error {
	defer value.Close()
	if v.Comment != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Comment",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Comment)
	}
	if v.CorsConfig != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "CorsConfig",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentResponseHeadersPolicyCorsConfig(v.CorsConfig, el); err != nil {
			return err
		}
	}
	if v.CustomHeadersConfig != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "CustomHeadersConfig",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentResponseHeadersPolicyCustomHeadersConfig(v.CustomHeadersConfig, el); err != nil {
			return err
		}
	}
	if v.Name != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Name",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Name)
	}
	if v.SecurityHeadersConfig != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "SecurityHeadersConfig",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentResponseHeadersPolicySecurityHeadersConfig(v.SecurityHeadersConfig, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentResponseHeadersPolicyContentSecurityPolicy(v *types.ResponseHeadersPolicyContentSecurityPolicy, value smithyxml.Value) error {
	defer value.Close()
	if v.ContentSecurityPolicy != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ContentSecurityPolicy",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ContentSecurityPolicy)
	}
	if v.Override != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Override",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(*v.Override)
	}
	return nil
}

func awsRestxml_serializeDocumentResponseHeadersPolicyContentTypeOptions(v *types.ResponseHeadersPolicyContentTypeOptions, value smithyxml.Value) error {
	defer value.Close()
	if v.Override != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Override",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(*v.Override)
	}
	return nil
}

func awsRestxml_serializeDocumentResponseHeadersPolicyCorsConfig(v *types.ResponseHeadersPolicyCorsConfig, value smithyxml.Value) error {
	defer value.Close()
	if v.AccessControlAllowCredentials != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "AccessControlAllowCredentials",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(*v.AccessControlAllowCredentials)
	}
	if v.AccessControlAllowHeaders != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "AccessControlAllowHeaders",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentResponseHeadersPolicyAccessControlAllowHeaders(v.AccessControlAllowHeaders, el); err != nil {
			return err
		}
	}
	if v.AccessControlAllowMethods != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "AccessControlAllowMethods",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentResponseHeadersPolicyAccessControlAllowMethods(v.AccessControlAllowMethods, el); err != nil {
			return err
		}
	}
	if v.AccessControlAllowOrigins != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "AccessControlAllowOrigins",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentResponseHeadersPolicyAccessControlAllowOrigins(v.AccessControlAllowOrigins, el); err != nil {
			return err
		}
	}
	if v.AccessControlExposeHeaders != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "AccessControlExposeHeaders",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentResponseHeadersPolicyAccessControlExposeHeaders(v.AccessControlExposeHeaders, el); err != nil {
			return err
		}
	}
	if v.AccessControlMaxAgeSec != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "AccessControlMaxAgeSec",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.AccessControlMaxAgeSec)
	}
	if v.OriginOverride != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "OriginOverride",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(*v.OriginOverride)
	}
	return nil
}

func awsRestxml_serializeDocumentResponseHeadersPolicyCustomHeader(v *types.ResponseHeadersPolicyCustomHeader, value smithyxml.Value) error {
	defer value.Close()
	if v.Header != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Header",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Header)
	}
	if v.Override != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Override",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(*v.Override)
	}
	if v.Value != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Value",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Value)
	}
	return nil
}

func awsRestxml_serializeDocumentResponseHeadersPolicyCustomHeaderList(v []types.ResponseHeadersPolicyCustomHeader, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "ResponseHeadersPolicyCustomHeader",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentResponseHeadersPolicyCustomHeader(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentResponseHeadersPolicyCustomHeadersConfig(v *types.ResponseHeadersPolicyCustomHeadersConfig, value smithyxml.Value) error {
	defer value.Close()
	if v.Items != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Items",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentResponseHeadersPolicyCustomHeaderList(v.Items, el); err != nil {
			return err
		}
	}
	if v.Quantity != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Quantity",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.Quantity)
	}
	return nil
}

func awsRestxml_serializeDocumentResponseHeadersPolicyFrameOptions(v *types.ResponseHeadersPolicyFrameOptions, value smithyxml.Value) error {
	defer value.Close()
	if len(v.FrameOption) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "FrameOption",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.FrameOption))
	}
	if v.Override != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Override",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(*v.Override)
	}
	return nil
}

func awsRestxml_serializeDocumentResponseHeadersPolicyReferrerPolicy(v *types.ResponseHeadersPolicyReferrerPolicy, value smithyxml.Value) error {
	defer value.Close()
	if v.Override != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Override",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(*v.Override)
	}
	if len(v.ReferrerPolicy) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ReferrerPolicy",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.ReferrerPolicy))
	}
	return nil
}

func awsRestxml_serializeDocumentResponseHeadersPolicySecurityHeadersConfig(v *types.ResponseHeadersPolicySecurityHeadersConfig, value smithyxml.Value) error {
	defer value.Close()
	if v.ContentSecurityPolicy != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ContentSecurityPolicy",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentResponseHeadersPolicyContentSecurityPolicy(v.ContentSecurityPolicy, el); err != nil {
			return err
		}
	}
	if v.ContentTypeOptions != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ContentTypeOptions",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentResponseHeadersPolicyContentTypeOptions(v.ContentTypeOptions, el); err != nil {
			return err
		}
	}
	if v.FrameOptions != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "FrameOptions",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentResponseHeadersPolicyFrameOptions(v.FrameOptions, el); err != nil {
			return err
		}
	}
	if v.ReferrerPolicy != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ReferrerPolicy",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentResponseHeadersPolicyReferrerPolicy(v.ReferrerPolicy, el); err != nil {
			return err
		}
	}
	if v.StrictTransportSecurity != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "StrictTransportSecurity",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentResponseHeadersPolicyStrictTransportSecurity(v.StrictTransportSecurity, el); err != nil {
			return err
		}
	}
	if v.XSSProtection != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "XSSProtection",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentResponseHeadersPolicyXSSProtection(v.XSSProtection, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentResponseHeadersPolicyStrictTransportSecurity(v *types.ResponseHeadersPolicyStrictTransportSecurity, value smithyxml.Value) error {
	defer value.Close()
	if v.AccessControlMaxAgeSec != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "AccessControlMaxAgeSec",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.AccessControlMaxAgeSec)
	}
	if v.IncludeSubdomains != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "IncludeSubdomains",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(*v.IncludeSubdomains)
	}
	if v.Override != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Override",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(*v.Override)
	}
	if v.Preload != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Preload",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(*v.Preload)
	}
	return nil
}

func awsRestxml_serializeDocumentResponseHeadersPolicyXSSProtection(v *types.ResponseHeadersPolicyXSSProtection, value smithyxml.Value) error {
	defer value.Close()
	if v.ModeBlock != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ModeBlock",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(*v.ModeBlock)
	}
	if v.Override != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Override",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(*v.Override)
	}
	if v.Protection != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Protection",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(*v.Protection)
	}
	if v.ReportUri != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ReportUri",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ReportUri)
	}
	return nil
}

func awsRestxml_serializeDocumentRestrictions(v *types.Restrictions, value smithyxml.Value) error {
	defer value.Close()
	if v.GeoRestriction != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "GeoRestriction",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentGeoRestriction(v.GeoRestriction, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentS3Origin(v *types.S3Origin, value smithyxml.Value) error {
	defer value.Close()
	if v.DomainName != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "DomainName",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.DomainName)
	}
	if v.OriginAccessIdentity != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "OriginAccessIdentity",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.OriginAccessIdentity)
	}
	return nil
}

func awsRestxml_serializeDocumentS3OriginConfig(v *types.S3OriginConfig, value smithyxml.Value) error {
	defer value.Close()
	if v.OriginAccessIdentity != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "OriginAccessIdentity",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.OriginAccessIdentity)
	}
	return nil
}

func awsRestxml_serializeDocumentSslProtocolsList(v []types.SslProtocol, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "SslProtocol",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		am.String(string(v[i]))
	}
	return nil
}

func awsRestxml_serializeDocumentStatusCodeList(v []int32, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "StatusCode",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		am.Integer(v[i])
	}
	return nil
}

func awsRestxml_serializeDocumentStatusCodes(v *types.StatusCodes, value smithyxml.Value) error {
	defer value.Close()
	if v.Items != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Items",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentStatusCodeList(v.Items, el); err != nil {
			return err
		}
	}
	if v.Quantity != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Quantity",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.Quantity)
	}
	return nil
}

func awsRestxml_serializeDocumentStreamingDistributionConfig(v *types.StreamingDistributionConfig, value smithyxml.Value) error {
	defer value.Close()
	if v.Aliases != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Aliases",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentAliases(v.Aliases, el); err != nil {
			return err
		}
	}
	if v.CallerReference != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "CallerReference",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.CallerReference)
	}
	if v.Comment != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Comment",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Comment)
	}
	if v.Enabled != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Enabled",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(*v.Enabled)
	}
	if v.Logging != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Logging",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentStreamingLoggingConfig(v.Logging, el); err != nil {
			return err
		}
	}
	if len(v.PriceClass) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "PriceClass",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.PriceClass))
	}
	if v.S3Origin != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "S3Origin",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentS3Origin(v.S3Origin, el); err != nil {
			return err
		}
	}
	if v.TrustedSigners != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "TrustedSigners",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentTrustedSigners(v.TrustedSigners, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentStreamingDistributionConfigWithTags(v *types.StreamingDistributionConfigWithTags, value smithyxml.Value) error {
	defer value.Close()
	if v.StreamingDistributionConfig != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "StreamingDistributionConfig",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentStreamingDistributionConfig(v.StreamingDistributionConfig, el); err != nil {
			return err
		}
	}
	if v.Tags != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Tags",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentTags(v.Tags, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentStreamingLoggingConfig(v *types.StreamingLoggingConfig, value smithyxml.Value) error {
	defer value.Close()
	if v.Bucket != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Bucket",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Bucket)
	}
	if v.Enabled != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Enabled",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(*v.Enabled)
	}
	if v.Prefix != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Prefix",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Prefix)
	}
	return nil
}

func awsRestxml_serializeDocumentTag(v *types.Tag, value smithyxml.Value) error {
	defer value.Close()
	if v.Key != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Key",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Key)
	}
	if v.Value != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Value",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Value)
	}
	return nil
}

func awsRestxml_serializeDocumentTagKeyList(v []string, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "Key",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		am.String(v[i])
	}
	return nil
}

func awsRestxml_serializeDocumentTagKeys(v *types.TagKeys, value smithyxml.Value) error {
	defer value.Close()
	if v.Items != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Items",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentTagKeyList(v.Items, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentTagList(v []types.Tag, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "Tag",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentTag(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentTags(v *types.Tags, value smithyxml.Value) error {
	defer value.Close()
	if v.Items != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Items",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentTagList(v.Items, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentTrustedKeyGroupIdList(v []string, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "KeyGroup",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		am.String(v[i])
	}
	return nil
}

func awsRestxml_serializeDocumentTrustedKeyGroups(v *types.TrustedKeyGroups, value smithyxml.Value) error {
	defer value.Close()
	if v.Enabled != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Enabled",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(*v.Enabled)
	}
	if v.Items != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Items",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentTrustedKeyGroupIdList(v.Items, el); err != nil {
			return err
		}
	}
	if v.Quantity != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Quantity",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.Quantity)
	}
	return nil
}

func awsRestxml_serializeDocumentTrustedSigners(v *types.TrustedSigners, value smithyxml.Value) error {
	defer value.Close()
	if v.Enabled != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Enabled",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(*v.Enabled)
	}
	if v.Items != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Items",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentAwsAccountNumberList(v.Items, el); err != nil {
			return err
		}
	}
	if v.Quantity != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Quantity",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.Quantity)
	}
	return nil
}

func awsRestxml_serializeDocumentViewerCertificate(v *types.ViewerCertificate, value smithyxml.Value) error {
	defer value.Close()
	if v.ACMCertificateArn != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ACMCertificateArn",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ACMCertificateArn)
	}
	if v.Certificate != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Certificate",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Certificate)
	}
	if len(v.CertificateSource) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "CertificateSource",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.CertificateSource))
	}
	if v.CloudFrontDefaultCertificate != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "CloudFrontDefaultCertificate",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(*v.CloudFrontDefaultCertificate)
	}
	if v.IAMCertificateId != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "IAMCertificateId",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.IAMCertificateId)
	}
	if len(v.MinimumProtocolVersion) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "MinimumProtocolVersion",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.MinimumProtocolVersion))
	}
	if len(v.SSLSupportMethod) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "SSLSupportMethod",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.SSLSupportMethod))
	}
	return nil
}
