// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The Amazon Chime account details. An AWS account can have multiple Amazon Chime
// accounts.
type Account struct {

	// The Amazon Chime account ID.
	//
	// This member is required.
	AccountId *string

	// The AWS account ID.
	//
	// This member is required.
	AwsAccountId *string

	// The Amazon Chime account name.
	//
	// This member is required.
	Name *string

	// The status of the account.
	AccountStatus AccountStatus

	// The Amazon Chime account type. For more information about different account
	// types, see Managing Your Amazon Chime Accounts
	// (https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html) in the
	// Amazon Chime Administration Guide.
	AccountType AccountType

	// The Amazon Chime account creation timestamp, in ISO 8601 format.
	CreatedTimestamp *time.Time

	// The default license for the Amazon Chime account.
	DefaultLicense License

	// The sign-in delegate groups associated with the account.
	SigninDelegateGroups []SigninDelegateGroup

	// Supported licenses for the Amazon Chime account.
	SupportedLicenses []License

	noSmithyDocumentSerde
}

// Settings related to the Amazon Chime account. This includes settings that start
// or stop remote control of shared screens, or start or stop the dial-out option
// in the Amazon Chime web application. For more information about these settings,
// see Use the Policies Page
// (https://docs.aws.amazon.com/chime/latest/ag/policies.html) in the Amazon Chime
// Administration Guide.
type AccountSettings struct {

	// Setting that stops or starts remote control of shared screens during meetings.
	DisableRemoteControl *bool

	// Setting that allows meeting participants to choose the Call me at a phone number
	// option. For more information, see Join a Meeting without the Amazon Chime App
	// (https://docs.aws.amazon.com/chime/latest/ug/chime-join-meeting.html).
	EnableDialOut *bool

	noSmithyDocumentSerde
}

// The Alexa for Business metadata associated with an Amazon Chime user, used to
// integrate Alexa for Business with a device.
type AlexaForBusinessMetadata struct {

	// The ARN of the room resource.
	AlexaForBusinessRoomArn *string

	// Starts or stops Alexa for Business.
	IsAlexaForBusinessEnabled *bool

	noSmithyDocumentSerde
}

// The details of an AppInstance, an instance of an Amazon Chime SDK messaging
// application.
type AppInstance struct {

	// The ARN of the messaging instance.
	AppInstanceArn *string

	// The time at which an AppInstance was created. In epoch milliseconds.
	CreatedTimestamp *time.Time

	// The time an AppInstance was last updated. In epoch milliseconds.
	LastUpdatedTimestamp *time.Time

	// The metadata of an AppInstance.
	Metadata *string

	// The name of an AppInstance.
	Name *string

	noSmithyDocumentSerde
}

// The details of an AppInstanceAdmin.
type AppInstanceAdmin struct {

	// The AppInstanceAdmin data.
	Admin *Identity

	// The ARN of the AppInstance for which the user is an administrator.
	AppInstanceArn *string

	// The time at which an administrator was created.
	CreatedTimestamp *time.Time

	noSmithyDocumentSerde
}

// Summary of the details of an AppInstanceAdmin.
type AppInstanceAdminSummary struct {

	// The details of the AppInstanceAdmin.
	Admin *Identity

	noSmithyDocumentSerde
}

// The details of the data-retention settings for an AppInstance.
type AppInstanceRetentionSettings struct {

	// The length of time in days to retain the messages in a channel.
	ChannelRetentionSettings *ChannelRetentionSettings

	noSmithyDocumentSerde
}

// The details of the streaming configuration of an AppInstance.
type AppInstanceStreamingConfiguration struct {

	// The type of data to be streamed.
	//
	// This member is required.
	AppInstanceDataType AppInstanceDataType

	// The resource ARN.
	//
	// This member is required.
	ResourceArn *string

	noSmithyDocumentSerde
}

// Summary of the data for an AppInstance.
type AppInstanceSummary struct {

	// The AppInstance ARN.
	AppInstanceArn *string

	// The metadata of the AppInstance.
	Metadata *string

	// The name of the AppInstance.
	Name *string

	noSmithyDocumentSerde
}

// The details of an AppInstanceUser.
type AppInstanceUser struct {

	// The ARN of the AppInstanceUser.
	AppInstanceUserArn *string

	// The time at which the AppInstanceUser was created.
	CreatedTimestamp *time.Time

	// The time at which the AppInstanceUser was last updated.
	LastUpdatedTimestamp *time.Time

	// The metadata of the AppInstanceUser.
	Metadata *string

	// The name of the AppInstanceUser.
	Name *string

	noSmithyDocumentSerde
}

// Summary of the membership details of an AppInstanceUser.
type AppInstanceUserMembershipSummary struct {

	// The time at which a message was last read.
	ReadMarkerTimestamp *time.Time

	// The type of ChannelMembership.
	Type ChannelMembershipType

	noSmithyDocumentSerde
}

// Summary of the details of an AppInstanceUser.
type AppInstanceUserSummary struct {

	// The ARN of the AppInstanceUser.
	AppInstanceUserArn *string

	// The metadata of the AppInstanceUser.
	Metadata *string

	// The name of an AppInstanceUser.
	Name *string

	noSmithyDocumentSerde
}

// The configuration for the artifacts.
type ArtifactsConfiguration struct {

	// The configuration for the audio artifacts.
	//
	// This member is required.
	Audio *AudioArtifactsConfiguration

	// The configuration for the content artifacts.
	//
	// This member is required.
	Content *ContentArtifactsConfiguration

	// The configuration for the video artifacts.
	//
	// This member is required.
	Video *VideoArtifactsConfiguration

	noSmithyDocumentSerde
}

// An Amazon Chime SDK meeting attendee. Includes a unique AttendeeId and JoinToken
// . The JoinToken allows a client to authenticate and join as the specified
// attendee. The JoinToken expires when the meeting ends or when DeleteAttendee is
// called. After that, the attendee is unable to join the meeting. We recommend
// securely transferring each JoinToken from your server application to the client
// so that no other client has access to the token except for the one authorized to
// represent the attendee.
type Attendee struct {

	// The Amazon Chime SDK attendee ID.
	AttendeeId *string

	// The Amazon Chime SDK external user ID. An idempotency token. Links the attendee
	// to an identity managed by a builder application.
	ExternalUserId *string

	// The join token used by the Amazon Chime SDK attendee.
	JoinToken *string

	noSmithyDocumentSerde
}

// The audio artifact configuration object.
type AudioArtifactsConfiguration struct {

	// The MUX type of the audio artifact configuration object.
	//
	// This member is required.
	MuxType AudioMuxType

	noSmithyDocumentSerde
}

// The membership information, including member ARNs, the channel ARN, and
// membership types.
type BatchChannelMemberships struct {

	// The ARN of the channel to which you're adding users.
	ChannelArn *string

	// The identifier of the member who invited another member.
	InvitedBy *Identity

	// The users successfully added to the request.
	Members []Identity

	// The membership types set for the channel users.
	Type ChannelMembershipType

	noSmithyDocumentSerde
}

// A list of failed member ARNs, error codes, and error messages.
type BatchCreateChannelMembershipError struct {

	// The error code.
	ErrorCode ErrorCode

	// The error message.
	ErrorMessage *string

	// The ARN of the member that the service couldn't add.
	MemberArn *string

	noSmithyDocumentSerde
}

// A resource that allows Enterprise account administrators to configure an
// interface to receive events from Amazon Chime.
type Bot struct {

	// The bot email address.
	BotEmail *string

	// The bot ID.
	BotId *string

	// The bot type.
	BotType BotType

	// The bot creation timestamp, in ISO 8601 format.
	CreatedTimestamp *time.Time

	// When true, the bot is stopped from running in your account.
	Disabled *bool

	// The bot display name.
	DisplayName *string

	// The security token used to authenticate Amazon Chime with the outgoing event
	// endpoint.
	SecurityToken *string

	// The updated bot timestamp, in ISO 8601 format.
	UpdatedTimestamp *time.Time

	// The unique ID for the bot user.
	UserId *string

	noSmithyDocumentSerde
}

// The Amazon Chime Business Calling settings for the administrator's AWS account.
// Includes any Amazon S3 buckets designated for storing call detail records.
type BusinessCallingSettings struct {

	// The Amazon S3 bucket designated for call detail record storage.
	CdrBucket *string

	noSmithyDocumentSerde
}

// The details of a channel.
type Channel struct {

	// The ARN of the channel.
	ChannelArn *string

	// The AppInstanceUser who created the channel.
	CreatedBy *Identity

	// The time at which the AppInstanceUser created the channel.
	CreatedTimestamp *time.Time

	// The time at which a member sent the last message in the channel.
	LastMessageTimestamp *time.Time

	// The time at which a channel was last updated.
	LastUpdatedTimestamp *time.Time

	// The channel's metadata.
	Metadata *string

	// The mode of the channel.
	Mode ChannelMode

	// The name of the channel.
	Name *string

	// The channel's privacy setting.
	Privacy ChannelPrivacy

	noSmithyDocumentSerde
}

// The details of a channel ban.
type ChannelBan struct {

	// The ARN of the channel from which a member is being banned.
	ChannelArn *string

	// The AppInstanceUser who created the ban.
	CreatedBy *Identity

	// The time at which the ban was created.
	CreatedTimestamp *time.Time

	// The member being banned from the channel.
	Member *Identity

	noSmithyDocumentSerde
}

// Summary of the details of a ChannelBan.
type ChannelBanSummary struct {

	// The member being banned from a channel.
	Member *Identity

	noSmithyDocumentSerde
}

// The details of a channel member.
type ChannelMembership struct {

	// The ARN of the member's channel.
	ChannelArn *string

	// The time at which the channel membership was created.
	CreatedTimestamp *time.Time

	// The identifier of the member who invited another member.
	InvitedBy *Identity

	// The time at which a channel membership was last updated.
	LastUpdatedTimestamp *time.Time

	// The data of the channel member.
	Member *Identity

	// The membership type set for the channel member.
	Type ChannelMembershipType

	noSmithyDocumentSerde
}

// Summary of the channel membership details of an AppInstanceUser.
type ChannelMembershipForAppInstanceUserSummary struct {

	// Summary of the membership details of an AppInstanceUser.
	AppInstanceUserMembershipSummary *AppInstanceUserMembershipSummary

	// Summary of the details of a Channel.
	ChannelSummary *ChannelSummary

	noSmithyDocumentSerde
}

// Summary of the details of a ChannelMembership.
type ChannelMembershipSummary struct {

	// A member's summary data.
	Member *Identity

	noSmithyDocumentSerde
}

// The details of a message in a channel.
type ChannelMessage struct {

	// The ARN of the channel.
	ChannelArn *string

	// The message content.
	Content *string

	// The time at which the message was created.
	CreatedTimestamp *time.Time

	// The time at which a message was edited.
	LastEditedTimestamp *time.Time

	// The time at which a message was updated.
	LastUpdatedTimestamp *time.Time

	// The ID of a message.
	MessageId *string

	// The message metadata.
	Metadata *string

	// The persistence setting for a channel message.
	Persistence ChannelMessagePersistenceType

	// Hides the content of a message.
	Redacted bool

	// The message sender.
	Sender *Identity

	// The message type.
	Type ChannelMessageType

	noSmithyDocumentSerde
}

// Summary of the messages in a Channel.
type ChannelMessageSummary struct {

	// The content of the message.
	Content *string

	// The time at which the message summary was created.
	CreatedTimestamp *time.Time

	// The time at which a message was last edited.
	LastEditedTimestamp *time.Time

	// The time at which a message was last updated.
	LastUpdatedTimestamp *time.Time

	// The ID of the message.
	MessageId *string

	// The metadata of the message.
	Metadata *string

	// Indicates whether a message was redacted.
	Redacted bool

	// The message sender.
	Sender *Identity

	// The type of message.
	Type ChannelMessageType

	noSmithyDocumentSerde
}

// Summary of the details of a moderated channel.
type ChannelModeratedByAppInstanceUserSummary struct {

	// Summary of the details of a Channel.
	ChannelSummary *ChannelSummary

	noSmithyDocumentSerde
}

// The details of a channel moderator.
type ChannelModerator struct {

	// The ARN of the moderator's channel.
	ChannelArn *string

	// The AppInstanceUser who created the moderator.
	CreatedBy *Identity

	// The time at which the moderator was created.
	CreatedTimestamp *time.Time

	// The moderator's data.
	Moderator *Identity

	noSmithyDocumentSerde
}

// Summary of the details of a ChannelModerator.
type ChannelModeratorSummary struct {

	// The data for a moderator.
	Moderator *Identity

	noSmithyDocumentSerde
}

// The details of the retention settings for a channel.
type ChannelRetentionSettings struct {

	// The time in days to retain the messages in a channel.
	RetentionDays *int32

	noSmithyDocumentSerde
}

// Summary of the details of a Channel.
type ChannelSummary struct {

	// The ARN of the channel.
	ChannelArn *string

	// The time at which the last message in a channel was sent.
	LastMessageTimestamp *time.Time

	// The metadata of the channel.
	Metadata *string

	// The mode of the channel.
	Mode ChannelMode

	// The name of the channel.
	Name *string

	// The privacy setting of the channel.
	Privacy ChannelPrivacy

	noSmithyDocumentSerde
}

// The configuration object of the Amazon Chime SDK meeting for a specified media
// capture pipeline. SourceType must be ChimeSdkMeeting.
type ChimeSdkMeetingConfiguration struct {

	// The configuration for the artifacts in an Amazon Chime SDK meeting.
	ArtifactsConfiguration *ArtifactsConfiguration

	// The source configuration for a specified media capture pipline.
	SourceConfiguration *SourceConfiguration

	noSmithyDocumentSerde
}

// The content artifact object.
type ContentArtifactsConfiguration struct {

	// Indicates whether the content artifact is enabled or disabled.
	//
	// This member is required.
	State ArtifactsState

	// The MUX type of the artifact configuration.
	MuxType ContentMuxType

	noSmithyDocumentSerde
}

// The retention settings that determine how long to retain conversation messages
// for an Amazon Chime Enterprise account.
type ConversationRetentionSettings struct {

	// The number of days for which to retain conversation messages.
	RetentionDays *int32

	noSmithyDocumentSerde
}

// The list of errors returned when errors are encountered during the
// BatchCreateAttendee and CreateAttendee actions. This includes external user IDs,
// error codes, and error messages.
type CreateAttendeeError struct {

	// The error code.
	ErrorCode *string

	// The error message.
	ErrorMessage *string

	// The Amazon Chime SDK external user ID. An idempotency token. Links the attendee
	// to an identity managed by a builder application.
	ExternalUserId *string

	noSmithyDocumentSerde
}

// The Amazon Chime SDK attendee fields to create, used with the
// BatchCreateAttendee action.
type CreateAttendeeRequestItem struct {

	// The Amazon Chime SDK external user ID. An idempotency token. Links the attendee
	// to an identity managed by a builder application.
	//
	// This member is required.
	ExternalUserId *string

	// The tag key-value pairs.
	Tags []Tag

	noSmithyDocumentSerde
}

// The SIP credentials used to authenticate requests to your Amazon Chime Voice
// Connector.
type Credential struct {

	// The RFC2617 compliant password associated with the SIP credentials, in US-ASCII
	// format.
	Password *string

	// The RFC2617 compliant user name associated with the SIP credentials, in US-ASCII
	// format.
	Username *string

	noSmithyDocumentSerde
}

// The Dialed Number Identification Service (DNIS) emergency calling configuration
// details associated with an Amazon Chime Voice Connector's emergency calling
// configuration.
type DNISEmergencyCallingConfiguration struct {

	// The country from which emergency calls are allowed, in ISO 3166-1 alpha-2
	// format.
	//
	// This member is required.
	CallingCountry *string

	// The DNIS phone number to route emergency calls to, in E.164 format.
	//
	// This member is required.
	EmergencyPhoneNumber *string

	// The DNIS phone number to route test emergency calls to, in E.164 format.
	TestPhoneNumber *string

	noSmithyDocumentSerde
}

// The emergency calling configuration details associated with an Amazon Chime
// Voice Connector.
type EmergencyCallingConfiguration struct {

	// The Dialed Number Identification Service (DNIS) emergency calling configuration
	// details.
	DNIS []DNISEmergencyCallingConfiguration

	noSmithyDocumentSerde
}

// Settings specific to the Amazon Transcribe Medical engine.
type EngineTranscribeMedicalSettings struct {

	// The language code specified for the Amazon Transcribe Medical engine.
	//
	// This member is required.
	LanguageCode TranscribeMedicalLanguageCode

	// The specialty specified for the Amazon Transcribe Medical engine.
	//
	// This member is required.
	Specialty TranscribeMedicalSpecialty

	// The type of transcription.
	//
	// This member is required.
	Type TranscribeMedicalType

	// Set this field to PHI to identify personal health information in the
	// transcription output.
	ContentIdentificationType TranscribeMedicalContentIdentificationType

	// The AWS Region passed to Amazon Transcribe Medical. If you don't specify a
	// Region, Amazon Chime uses the meeting's Region.
	Region TranscribeMedicalRegion

	// The name of the vocabulary passed to Amazon Transcribe Medical.
	VocabularyName *string

	noSmithyDocumentSerde
}

// Settings specific to the Amazon Transcribe engine.
type EngineTranscribeSettings struct {

	// The language code specified for the Amazon Transcribe engine.
	//
	// This member is required.
	LanguageCode TranscribeLanguageCode

	// Set this field to PII to identify personal health information in the
	// transcription output.
	ContentIdentificationType TranscribeContentIdentificationType

	// Set this field to PII to redact personally identifiable information in the
	// transcription output. Content redaction is performed only upon complete
	// transcription of the audio segments.
	ContentRedactionType TranscribeContentRedactionType

	// Generates partial transcription results that are less likely to change as
	// meeting attendees speak. It does so by only allowing the last few words from the
	// partial results to change.
	EnablePartialResultsStabilization *bool

	// The name of the language model used during transcription.
	LanguageModelName *string

	// The stabity level of a partial results transcription. Determines how stable you
	// want the transcription results to be. A higher level means the transcription
	// results are less likely to change.
	PartialResultsStability TranscribePartialResultsStability

	// Lists the PII entity types you want to identify or redact. To specify entity
	// types, you must enable ContentIdentificationType or ContentRedactionType.
	// PIIEntityTypes must be comma-separated. The available values are:
	// BANK_ACCOUNT_NUMBER, BANK_ROUTING, CREDIT_DEBIT_NUMBER, CREDIT_DEBIT_CVV,
	// CREDIT_DEBIT_EXPIRY, PIN, EMAIL, ADDRESS, NAME, PHONE, SSN, and ALL.
	// PiiEntityTypes is an optional parameter with a default value of ALL.
	PiiEntityTypes *string

	// The AWS Region passed to Amazon Transcribe. If you don't specify a Region,
	// Amazon Chime uses the meeting's Region.
	Region TranscribeRegion

	// The filtering method passed to Amazon Transcribe.
	VocabularyFilterMethod TranscribeVocabularyFilterMethod

	// The name of the vocabulary filter passed to Amazon Transcribe.
	VocabularyFilterName *string

	// The name of the vocabulary passed to Amazon Transcribe.
	VocabularyName *string

	noSmithyDocumentSerde
}

// The configuration that allows a bot to receive outgoing events. Can be either an
// HTTPS endpoint or a Lambda function ARN.
type EventsConfiguration struct {

	// The bot ID.
	BotId *string

	// Lambda function ARN that allows a bot to receive outgoing events.
	LambdaFunctionArn *string

	// HTTPS endpoint that allows a bot to receive outgoing events.
	OutboundEventsHTTPSEndpoint *string

	noSmithyDocumentSerde
}

// The country and area code for a proxy phone number in a proxy phone session.
type GeoMatchParams struct {

	// The area code.
	//
	// This member is required.
	AreaCode *string

	// The country.
	//
	// This member is required.
	Country *string

	noSmithyDocumentSerde
}

// The details of a user.
type Identity struct {

	// The ARN in an Identity.
	Arn *string

	// The name in an Identity.
	Name *string

	noSmithyDocumentSerde
}

// Invitation object returned after emailing users to invite them to join the
// Amazon Chime Team account.
type Invite struct {

	// The email address to which the invite is sent.
	EmailAddress *string

	// The status of the invite email.
	EmailStatus EmailStatus

	// The invite ID.
	InviteId *string

	// The status of the invite.
	Status InviteStatus

	noSmithyDocumentSerde
}

// The logging configuration associated with an Amazon Chime Voice Connector.
// Specifies whether SIP message logs are enabled for sending to Amazon CloudWatch
// Logs.
type LoggingConfiguration struct {

	// When true, enables SIP message logs for sending to Amazon CloudWatch Logs.
	EnableSIPLogs *bool

	noSmithyDocumentSerde
}

// A media capture pipeline object consisting of an ID, source type, source ARN, a
// sink type, a sink ARN, and a configuration object.
type MediaCapturePipeline struct {

	// The configuration for a specified media capture pipeline. SourceType must be
	// ChimeSdkMeeting.
	ChimeSdkMeetingConfiguration *ChimeSdkMeetingConfiguration

	// The time at which the capture pipeline was created, in ISO 8601 format.
	CreatedTimestamp *time.Time

	// The ID of a media capture pipeline.
	MediaPipelineId *string

	// ARN of the destination to which the media artifacts are saved.
	SinkArn *string

	// Destination type to which the media artifacts are saved. You must use an S3
	// Bucket.
	SinkType MediaPipelineSinkType

	// ARN of the source from which the media artifacts will be saved.
	SourceArn *string

	// Source type from which media artifacts are saved. You must use ChimeMeeting.
	SourceType MediaPipelineSourceType

	// The status of the media capture pipeline.
	Status MediaPipelineStatus

	// The time at which the capture pipeline was updated, in ISO 8601 format.
	UpdatedTimestamp *time.Time

	noSmithyDocumentSerde
}

// A set of endpoints used by clients to connect to the media service group for an
// Amazon Chime SDK meeting.
type MediaPlacement struct {

	// The audio fallback URL.
	AudioFallbackUrl *string

	// The audio host URL.
	AudioHostUrl *string

	// The event ingestion URL.
	EventIngestionUrl *string

	// The screen data URL.
	ScreenDataUrl *string

	// The screen sharing URL.
	ScreenSharingUrl *string

	// The screen viewing URL.
	ScreenViewingUrl *string

	// The signaling URL.
	SignalingUrl *string

	// The turn control URL.
	TurnControlUrl *string

	noSmithyDocumentSerde
}

// A meeting created using the Amazon Chime SDK.
type Meeting struct {

	// The external meeting ID.
	ExternalMeetingId *string

	// The media placement for the meeting.
	MediaPlacement *MediaPlacement

	// The Region in which you create the meeting. Available values: af-south-1,
	// ap-northeast-1, ap-northeast-2, ap-south-1, ap-southeast-1, ap-southeast-2,
	// ca-central-1, eu-central-1, eu-north-1, eu-south-1, eu-west-1, eu-west-2,
	// eu-west-3, sa-east-1, us-east-1, us-east-2, us-west-1, us-west-2.
	MediaRegion *string

	// The Amazon Chime SDK meeting ID.
	MeetingId *string

	noSmithyDocumentSerde
}

// The resource target configurations for receiving Amazon Chime SDK meeting and
// attendee event notifications. The Amazon Chime SDK supports resource targets
// located in the US East (N. Virginia) AWS Region (us-east-1).
type MeetingNotificationConfiguration struct {

	// The SNS topic ARN.
	SnsTopicArn *string

	// The SQS queue ARN.
	SqsQueueArn *string

	noSmithyDocumentSerde
}

// The member details, such as email address, name, member ID, and member type.
type Member struct {

	// The Amazon Chime account ID.
	AccountId *string

	// The member email address.
	Email *string

	// The member name.
	FullName *string

	// The member ID (user ID or bot ID).
	MemberId *string

	// The member type.
	MemberType MemberType

	noSmithyDocumentSerde
}

// The list of errors returned when a member action results in an error.
type MemberError struct {

	// The error code.
	ErrorCode ErrorCode

	// The error message.
	ErrorMessage *string

	// The member ID.
	MemberId *string

	noSmithyDocumentSerde
}

// Membership details, such as member ID and member role.
type MembershipItem struct {

	// The member ID.
	MemberId *string

	// The member role.
	Role RoomMembershipRole

	noSmithyDocumentSerde
}

// The websocket endpoint used to connect to Amazon Chime SDK messaging.
type MessagingSessionEndpoint struct {

	// The endpoint to which you establish a websocket connection.
	Url *string

	noSmithyDocumentSerde
}

// A phone number for which an order has been placed.
type OrderedPhoneNumber struct {

	// The phone number, in E.164 format.
	E164PhoneNumber *string

	// The phone number status.
	Status OrderedPhoneNumberStatus

	noSmithyDocumentSerde
}

// Origination settings enable your SIP hosts to receive inbound calls using your
// Amazon Chime Voice Connector. The parameters listed below are not required, but
// you must use at least one.
type Origination struct {

	// When origination settings are disabled, inbound calls are not enabled for your
	// Amazon Chime Voice Connector. This parameter is not required, but you must
	// specify this parameter or Routes.
	Disabled *bool

	// The call distribution properties defined for your SIP hosts. Valid range:
	// Minimum value of 1. Maximum value of 20. This parameter is not required, but you
	// must specify this parameter or Disabled.
	Routes []OriginationRoute

	noSmithyDocumentSerde
}

// Origination routes define call distribution properties for your SIP hosts to
// receive inbound calls using your Amazon Chime Voice Connector. Limit: Ten
// origination routes for each Amazon Chime Voice Connector. The parameters listed
// below are not required, but you must use at least one.
type OriginationRoute struct {

	// The FQDN or IP address to contact for origination traffic.
	Host *string

	// The designated origination route port. Defaults to 5060.
	Port *int32

	// The priority associated with the host, with 1 being the highest priority. Higher
	// priority hosts are attempted first.
	Priority *int32

	// The protocol to use for the origination route. Encryption-enabled Amazon Chime
	// Voice Connectors use TCP protocol by default.
	Protocol OriginationRouteProtocol

	// The weight associated with the host. If hosts are equal in priority, calls are
	// redistributed among them based on their relative weight.
	Weight *int32

	noSmithyDocumentSerde
}

// The phone number and proxy phone number for a participant in an Amazon Chime
// Voice Connector proxy session.
type Participant struct {

	// The participant's phone number.
	PhoneNumber *string

	// The participant's proxy phone number.
	ProxyPhoneNumber *string

	noSmithyDocumentSerde
}

// A phone number used for Amazon Chime Business Calling or an Amazon Chime Voice
// Connector.
type PhoneNumber struct {

	// The phone number associations.
	Associations []PhoneNumberAssociation

	// The outbound calling name associated with the phone number.
	CallingName *string

	// The outbound calling name status.
	CallingNameStatus CallingNameStatus

	// The phone number capabilities.
	Capabilities *PhoneNumberCapabilities

	// The phone number country. Format: ISO 3166-1 alpha-2.
	Country *string

	// The phone number creation timestamp, in ISO 8601 format.
	CreatedTimestamp *time.Time

	// The deleted phone number timestamp, in ISO 8601 format.
	DeletionTimestamp *time.Time

	// The phone number, in E.164 format.
	E164PhoneNumber *string

	// The phone number ID.
	PhoneNumberId *string

	// The phone number product type.
	ProductType PhoneNumberProductType

	// The phone number status.
	Status PhoneNumberStatus

	// The phone number type.
	Type PhoneNumberType

	// The updated phone number timestamp, in ISO 8601 format.
	UpdatedTimestamp *time.Time

	noSmithyDocumentSerde
}

// The phone number associations, such as Amazon Chime account ID, Amazon Chime
// user ID, Amazon Chime Voice Connector ID, or Amazon Chime Voice Connector group
// ID.
type PhoneNumberAssociation struct {

	// The timestamp of the phone number association, in ISO 8601 format.
	AssociatedTimestamp *time.Time

	// Defines the association with an Amazon Chime account ID, user ID, Amazon Chime
	// Voice Connector ID, or Amazon Chime Voice Connector group ID.
	Name PhoneNumberAssociationName

	// Contains the ID for the entity specified in Name.
	Value *string

	noSmithyDocumentSerde
}

// The phone number capabilities for Amazon Chime Business Calling phone numbers,
// such as enabled inbound and outbound calling and text messaging.
type PhoneNumberCapabilities struct {

	// Allows or denies inbound calling for the specified phone number.
	InboundCall *bool

	// Allows or denies inbound MMS messaging for the specified phone number.
	InboundMMS *bool

	// Allows or denies inbound SMS messaging for the specified phone number.
	InboundSMS *bool

	// Allows or denies outbound calling for the specified phone number.
	OutboundCall *bool

	// Allows or denies outbound MMS messaging for the specified phone number.
	OutboundMMS *bool

	// Allows or denies outbound SMS messaging for the specified phone number.
	OutboundSMS *bool

	noSmithyDocumentSerde
}

// The phone number country.
type PhoneNumberCountry struct {

	// The phone number country code. Format: ISO 3166-1 alpha-2.
	CountryCode *string

	// The supported phone number types.
	SupportedPhoneNumberTypes []PhoneNumberType

	noSmithyDocumentSerde
}

// If the phone number action fails for one or more of the phone numbers in the
// request, a list of the phone numbers is returned, along with error codes and
// error messages.
type PhoneNumberError struct {

	// The error code.
	ErrorCode ErrorCode

	// The error message.
	ErrorMessage *string

	// The phone number ID for which the action failed.
	PhoneNumberId *string

	noSmithyDocumentSerde
}

// The details of a phone number order created for Amazon Chime.
type PhoneNumberOrder struct {

	// The phone number order creation time stamp, in ISO 8601 format.
	CreatedTimestamp *time.Time

	// The ordered phone number details, such as the phone number in E.164 format and
	// the phone number status.
	OrderedPhoneNumbers []OrderedPhoneNumber

	// The phone number order ID.
	PhoneNumberOrderId *string

	// The phone number order product type.
	ProductType PhoneNumberProductType

	// The status of the phone number order.
	Status PhoneNumberOrderStatus

	// The updated phone number order time stamp, in ISO 8601 format.
	UpdatedTimestamp *time.Time

	noSmithyDocumentSerde
}

// The proxy configuration for an Amazon Chime Voice Connector.
type Proxy struct {

	// The default number of minutes allowed for proxy sessions.
	DefaultSessionExpiryMinutes *int32

	// When true, stops proxy sessions from being created on the specified Amazon Chime
	// Voice Connector.
	Disabled *bool

	// The phone number to route calls to after a proxy session expires.
	FallBackPhoneNumber *string

	// The countries for proxy phone numbers to be selected from.
	PhoneNumberCountries []string

	noSmithyDocumentSerde
}

// The proxy session for an Amazon Chime Voice Connector.
type ProxySession struct {

	// The proxy session capabilities.
	Capabilities []Capability

	// The created time stamp, in ISO 8601 format.
	CreatedTimestamp *time.Time

	// The ended time stamp, in ISO 8601 format.
	EndedTimestamp *time.Time

	// The number of minutes allowed for the proxy session.
	ExpiryMinutes *int32

	// The preference for matching the country or area code of the proxy phone number
	// with that of the first participant.
	GeoMatchLevel GeoMatchLevel

	// The country and area code for the proxy phone number.
	GeoMatchParams *GeoMatchParams

	// The name of the proxy session.
	Name *string

	// The preference for proxy phone number reuse, or stickiness, between the same
	// participants across sessions.
	NumberSelectionBehavior NumberSelectionBehavior

	// The proxy session participants.
	Participants []Participant

	// The proxy session ID.
	ProxySessionId *string

	// The status of the proxy session.
	Status ProxySessionStatus

	// The updated time stamp, in ISO 8601 format.
	UpdatedTimestamp *time.Time

	// The Amazon Chime voice connector ID.
	VoiceConnectorId *string

	noSmithyDocumentSerde
}

// The retention settings for an Amazon Chime Enterprise account that determine how
// long to retain items such as chat-room messages and chat-conversation messages.
type RetentionSettings struct {

	// The chat conversation retention settings.
	ConversationRetentionSettings *ConversationRetentionSettings

	// The chat room retention settings.
	RoomRetentionSettings *RoomRetentionSettings

	noSmithyDocumentSerde
}

// The Amazon Chime chat room details.
type Room struct {

	// The Amazon Chime account ID.
	AccountId *string

	// The identifier of the room creator.
	CreatedBy *string

	// The room creation timestamp, in ISO 8601 format.
	CreatedTimestamp *time.Time

	// The room name.
	Name *string

	// The room ID.
	RoomId *string

	// The room update timestamp, in ISO 8601 format.
	UpdatedTimestamp *time.Time

	noSmithyDocumentSerde
}

// The room membership details.
type RoomMembership struct {

	// The identifier of the user that invited the room member.
	InvitedBy *string

	// The member details, such as email address, name, member ID, and member type.
	Member *Member

	// The membership role.
	Role RoomMembershipRole

	// The room ID.
	RoomId *string

	// The room membership update timestamp, in ISO 8601 format.
	UpdatedTimestamp *time.Time

	noSmithyDocumentSerde
}

// The retention settings that determine how long to retain chat-room messages for
// an Amazon Chime Enterprise account.
type RoomRetentionSettings struct {

	// The number of days for which to retain chat-room messages.
	RetentionDays *int32

	noSmithyDocumentSerde
}

// The video streams to capture for a specified media capture pipeline. The total
// number of video streams can't exceed 25.
type SelectedVideoStreams struct {

	// The attendee IDs of the streams selected for a media capture pipeline.
	AttendeeIds []string

	// The external user IDs of the streams selected for a media capture pipeline.
	ExternalUserIds []string

	noSmithyDocumentSerde
}

// An Active Directory (AD) group whose members are granted permission to act as
// delegates.
type SigninDelegateGroup struct {

	// The group name.
	GroupName *string

	noSmithyDocumentSerde
}

// The details of the SIP media application, including name and endpoints. An AWS
// account can have multiple SIP media applications.
type SipMediaApplication struct {

	// The AWS Region in which the SIP media application is created.
	AwsRegion *string

	// The SIP media application creation timestamp, in ISO 8601 format.
	CreatedTimestamp *time.Time

	// List of endpoints for SIP media application. Currently, only one endpoint per
	// SIP media application is permitted.
	Endpoints []SipMediaApplicationEndpoint

	// The name of the SIP media application.
	Name *string

	// The SIP media application ID.
	SipMediaApplicationId *string

	// The SIP media application updated timestamp, in ISO 8601 format.
	UpdatedTimestamp *time.Time

	noSmithyDocumentSerde
}

// A Call instance for a SIP media application.
type SipMediaApplicationCall struct {

	// The transaction ID of a call.
	TransactionId *string

	noSmithyDocumentSerde
}

// The endpoint assigned to the SIP media application.
type SipMediaApplicationEndpoint struct {

	// Valid Amazon Resource Name (ARN) of the Lambda function. The function must be
	// created in the same AWS Region as the SIP media application.
	LambdaArn *string

	noSmithyDocumentSerde
}

// Logging configuration of the SIP media application.
type SipMediaApplicationLoggingConfiguration struct {

	// Enables application message logs for the SIP media application.
	EnableSipMediaApplicationMessageLogs *bool

	noSmithyDocumentSerde
}

// The SIP rule details, including name, triggers, and target applications. An AWS
// account can have multiple SIP rules.
type SipRule struct {

	// The time at which the SIP rule was created, in ISO 8601 format.
	CreatedTimestamp *time.Time

	// Indicates whether the SIP rule is enabled or disabled. You must disable a rule
	// before you can delete it.
	Disabled *bool

	// The name of the SIP rule.
	Name *string

	// The SIP rule ID.
	SipRuleId *string

	// Target SIP media application and other details, such as priority and AWS Region,
	// to be specified in the SIP rule. Only one SIP rule per AWS Region can be
	// provided.
	TargetApplications []SipRuleTargetApplication

	// The type of trigger assigned to the SIP rule in TriggerValue, currently
	// RequestUriHostname or ToPhoneNumber.
	TriggerType SipRuleTriggerType

	// If TriggerType is RequestUriHostname, then the value can be the outbound host
	// name of the Amazon Chime Voice Connector. If TriggerType is ToPhoneNumber, then
	// the value can be a customer-owned phone number in E164 format. SipRule is
	// triggered when a SIP rule requests host name or ToPhoneNumber matches in the
	// incoming SIP request.
	TriggerValue *string

	// The time at which the SIP rule was last updated, in ISO 8601 format.
	UpdatedTimestamp *time.Time

	noSmithyDocumentSerde
}

// Target SIP media application and other details, such as priority and AWS Region,
// to be specified in the SIP rule. Only one SIP rule per AWS Region can be
// provided.
type SipRuleTargetApplication struct {

	// The AWS Region of the target application.
	AwsRegion *string

	// Priority of the SIP media application in the target list.
	Priority *int32

	// The SIP media application ID.
	SipMediaApplicationId *string

	noSmithyDocumentSerde
}

// Source configuration for a specified media capture pipeline.
type SourceConfiguration struct {

	// The selected video streams to capture for a specified media capture pipeline.
	// The number of video streams can't exceed 25.
	SelectedVideoStreams *SelectedVideoStreams

	noSmithyDocumentSerde
}

// The streaming configuration associated with an Amazon Chime Voice Connector.
// Specifies whether media streaming is enabled for sending to Amazon Kinesis, and
// shows the retention period for the Amazon Kinesis data, in hours.
type StreamingConfiguration struct {

	// The retention period, in hours, for the Amazon Kinesis data.
	//
	// This member is required.
	DataRetentionInHours *int32

	// When true, media streaming to Amazon Kinesis is turned off.
	Disabled *bool

	// The streaming notification targets.
	StreamingNotificationTargets []StreamingNotificationTarget

	noSmithyDocumentSerde
}

// The targeted recipient for a streaming configuration notification.
type StreamingNotificationTarget struct {

	// The streaming notification target.
	//
	// This member is required.
	NotificationTarget NotificationTarget

	noSmithyDocumentSerde
}

// Describes a tag applied to a resource.
type Tag struct {

	// The key of the tag.
	//
	// This member is required.
	Key *string

	// The value of the tag.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Settings that allow management of telephony permissions for an Amazon Chime
// user, such as inbound and outbound calling and text messaging.
type TelephonySettings struct {

	// Allows or denies inbound calling.
	//
	// This member is required.
	InboundCalling *bool

	// Allows or denies outbound calling.
	//
	// This member is required.
	OutboundCalling *bool

	// Allows or denies SMS messaging.
	//
	// This member is required.
	SMS *bool

	noSmithyDocumentSerde
}

// Termination settings enable your SIP hosts to make outbound calls using your
// Amazon Chime Voice Connector.
type Termination struct {

	// The countries to which calls are allowed, in ISO 3166-1 alpha-2 format.
	// Required.
	CallingRegions []string

	// The IP addresses allowed to make calls, in CIDR format. Required.
	CidrAllowedList []string

	// The limit on calls per second. Max value based on account service quota. Default
	// value of 1.
	CpsLimit *int32

	// The default caller ID phone number.
	DefaultPhoneNumber *string

	// When termination settings are disabled, outbound calls can not be made.
	Disabled *bool

	noSmithyDocumentSerde
}

// The termination health details, including the source IP address and timestamp of
// the last successful SIP OPTIONS message from your SIP infrastructure.
type TerminationHealth struct {

	// The source IP address.
	Source *string

	// The timestamp, in ISO 8601 format.
	Timestamp *time.Time

	noSmithyDocumentSerde
}

// The configuration for the current transcription operation. Must contain
// EngineTranscribeSettings or EngineTranscribeMedicalSettings.
type TranscriptionConfiguration struct {

	// The transcription configuration settings passed to Amazon Transcribe Medical.
	EngineTranscribeMedicalSettings *EngineTranscribeMedicalSettings

	// The transcription configuration settings passed to Amazon Transcribe.
	EngineTranscribeSettings *EngineTranscribeSettings

	noSmithyDocumentSerde
}

// The phone number ID, product type, or calling name fields to update, used with
// the BatchUpdatePhoneNumber and UpdatePhoneNumber actions.
type UpdatePhoneNumberRequestItem struct {

	// The phone number ID to update.
	//
	// This member is required.
	PhoneNumberId *string

	// The outbound calling name to update.
	CallingName *string

	// The product type to update.
	ProductType PhoneNumberProductType

	noSmithyDocumentSerde
}

// The user ID and user fields to update, used with the BatchUpdateUser action.
type UpdateUserRequestItem struct {

	// The user ID.
	//
	// This member is required.
	UserId *string

	// The Alexa for Business metadata.
	AlexaForBusinessMetadata *AlexaForBusinessMetadata

	// The user license type.
	LicenseType License

	// The user type.
	UserType UserType

	noSmithyDocumentSerde
}

// The user on the Amazon Chime account.
type User struct {

	// The user ID.
	//
	// This member is required.
	UserId *string

	// The Amazon Chime account ID.
	AccountId *string

	// The Alexa for Business metadata.
	AlexaForBusinessMetadata *AlexaForBusinessMetadata

	// The display name of the user.
	DisplayName *string

	// Date and time when the user is invited to the Amazon Chime account, in ISO 8601
	// format.
	InvitedOn *time.Time

	// The license type for the user.
	LicenseType License

	// The user's personal meeting PIN.
	PersonalPIN *string

	// The primary email address of the user.
	PrimaryEmail *string

	// The primary phone number associated with the user.
	PrimaryProvisionedNumber *string

	// Date and time when the user is registered, in ISO 8601 format.
	RegisteredOn *time.Time

	// The user invite status.
	UserInvitationStatus InviteStatus

	// The user registration status.
	UserRegistrationStatus RegistrationStatus

	// The user type.
	UserType UserType

	noSmithyDocumentSerde
}

// The list of errors returned when errors are encountered during the
// BatchSuspendUser, BatchUnsuspendUser, or BatchUpdateUser actions. This includes
// user IDs, error codes, and error messages.
type UserError struct {

	// The error code.
	ErrorCode ErrorCode

	// The error message.
	ErrorMessage *string

	// The user ID for which the action failed.
	UserId *string

	noSmithyDocumentSerde
}

// Settings associated with an Amazon Chime user, including inbound and outbound
// calling and text messaging.
type UserSettings struct {

	// The telephony settings associated with the user.
	//
	// This member is required.
	Telephony *TelephonySettings

	noSmithyDocumentSerde
}

// The video artifact configuration object.
type VideoArtifactsConfiguration struct {

	// Indicates whether the video artifact is enabled or disabled.
	//
	// This member is required.
	State ArtifactsState

	// The MUX type of the video artifact configuration object.
	MuxType VideoMuxType

	noSmithyDocumentSerde
}

// The Amazon Chime Voice Connector configuration, including outbound host name and
// encryption settings.
type VoiceConnector struct {

	// The AWS Region in which the Amazon Chime Voice Connector is created. Default:
	// us-east-1.
	AwsRegion VoiceConnectorAwsRegion

	// The Amazon Chime Voice Connector creation timestamp, in ISO 8601 format.
	CreatedTimestamp *time.Time

	// The name of the Amazon Chime Voice Connector.
	Name *string

	// The outbound host name for the Amazon Chime Voice Connector.
	OutboundHostName *string

	// Designates whether encryption is required for the Amazon Chime Voice Connector.
	RequireEncryption *bool

	// The updated Amazon Chime Voice Connector timestamp, in ISO 8601 format.
	UpdatedTimestamp *time.Time

	// The ARN of the specified Amazon Chime Voice Connector.
	VoiceConnectorArn *string

	// The Amazon Chime Voice Connector ID.
	VoiceConnectorId *string

	noSmithyDocumentSerde
}

// The Amazon Chime Voice Connector group configuration, including associated
// Amazon Chime Voice Connectors. You can include Amazon Chime Voice Connectors
// from different AWS Regions in your group. This creates a fault tolerant
// mechanism for fallback in case of availability events.
type VoiceConnectorGroup struct {

	// The Amazon Chime Voice Connector group creation time stamp, in ISO 8601 format.
	CreatedTimestamp *time.Time

	// The name of the Amazon Chime Voice Connector group.
	Name *string

	// The updated Amazon Chime Voice Connector group time stamp, in ISO 8601 format.
	UpdatedTimestamp *time.Time

	// The ARN of the specified Amazon Chime Voice Connector group.
	VoiceConnectorGroupArn *string

	// The Amazon Chime Voice Connector group ID.
	VoiceConnectorGroupId *string

	// The Amazon Chime Voice Connectors to which to route inbound calls.
	VoiceConnectorItems []VoiceConnectorItem

	noSmithyDocumentSerde
}

// For Amazon Chime Voice Connector groups, the Amazon Chime Voice Connectors to
// which to route inbound calls. Includes priority configuration settings. Limit: 3
// VoiceConnectorItems per Amazon Chime Voice Connector group.
type VoiceConnectorItem struct {

	// The priority associated with the Amazon Chime Voice Connector, with 1 being the
	// highest priority. Higher priority Amazon Chime Voice Connectors are attempted
	// first.
	//
	// This member is required.
	Priority *int32

	// The Amazon Chime Voice Connector ID.
	//
	// This member is required.
	VoiceConnectorId *string

	noSmithyDocumentSerde
}

// The Amazon Chime Voice Connector settings. Includes any Amazon S3 buckets
// designated for storing call detail records.
type VoiceConnectorSettings struct {

	// The Amazon S3 bucket designated for call detail record storage.
	CdrBucket *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
