// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The aggregation settings that you can use to customize the output format of your
// flow data.
type AggregationConfig struct {

	// Specifies whether Amazon AppFlow aggregates the flow records into a single file,
	// or leave them unaggregated.
	AggregationType AggregationType

	noSmithyDocumentSerde
}

// The connector-specific credentials required when using Amplitude.
type AmplitudeConnectorProfileCredentials struct {

	// A unique alphanumeric identifier used to authenticate a user, developer, or
	// calling program to your API.
	//
	// This member is required.
	ApiKey *string

	// The Secret Access Key portion of the credentials.
	//
	// This member is required.
	SecretKey *string

	noSmithyDocumentSerde
}

// The connector-specific profile properties required when using Amplitude.
type AmplitudeConnectorProfileProperties struct {
	noSmithyDocumentSerde
}

// The connector metadata specific to Amplitude.
type AmplitudeMetadata struct {
	noSmithyDocumentSerde
}

// The properties that are applied when Amplitude is being used as a source.
type AmplitudeSourceProperties struct {

	// The object specified in the Amplitude flow source.
	//
	// This member is required.
	Object *string

	noSmithyDocumentSerde
}

// The basic auth credentials required for basic authentication.
type BasicAuthCredentials struct {

	// The password to use to connect to a resource.
	//
	// This member is required.
	Password *string

	// The username to use to connect to a resource.
	//
	// This member is required.
	Username *string

	noSmithyDocumentSerde
}

// The configuration settings related to a given connector.
type ConnectorConfiguration struct {

	// Specifies whether the connector can be used as a destination.
	CanUseAsDestination bool

	// Specifies whether the connector can be used as a source.
	CanUseAsSource bool

	// Specifies connector-specific metadata such as oAuthScopes, supportedRegions,
	// privateLinkServiceUrl, and so on.
	ConnectorMetadata *ConnectorMetadata

	// Specifies if PrivateLink is enabled for that connector.
	IsPrivateLinkEnabled bool

	// Specifies if a PrivateLink endpoint URL is required.
	IsPrivateLinkEndpointUrlRequired bool

	// Lists the connectors that are available for use as destinations.
	SupportedDestinationConnectors []ConnectorType

	// Specifies the supported flow frequency for that connector.
	SupportedSchedulingFrequencies []ScheduleFrequencyType

	// Specifies the supported trigger types for the flow.
	SupportedTriggerTypes []TriggerType

	noSmithyDocumentSerde
}

// The high-level entity that can be queried in Amazon AppFlow. For example, a
// Salesforce entity might be an Account or Opportunity, whereas a ServiceNow
// entity might be an Incident.
type ConnectorEntity struct {

	// The name of the connector entity.
	//
	// This member is required.
	Name *string

	// Specifies whether the connector entity is a parent or a category and has more
	// entities nested underneath it. If another call is made with entitiesPath =
	// "the_current_entity_name_with_hasNestedEntities_true", then it returns the
	// nested entities underneath it. This provides a way to retrieve all supported
	// entities in a recursive fashion.
	HasNestedEntities bool

	// The label applied to the connector entity.
	Label *string

	noSmithyDocumentSerde
}

// Describes the data model of a connector field. For example, for an account
// entity, the fields would be account name, account ID, and so on.
type ConnectorEntityField struct {

	// The unique identifier of the connector field.
	//
	// This member is required.
	Identifier *string

	// A description of the connector entity field.
	Description *string

	// The properties applied to a field when the connector is being used as a
	// destination.
	DestinationProperties *DestinationFieldProperties

	// The label applied to a connector entity field.
	Label *string

	// The properties that can be applied to a field when the connector is being used
	// as a source.
	SourceProperties *SourceFieldProperties

	// Contains details regarding the supported FieldType, including the corresponding
	// filterOperators and supportedValues.
	SupportedFieldTypeDetails *SupportedFieldTypeDetails

	noSmithyDocumentSerde
}

// A structure to specify connector-specific metadata such as oAuthScopes,
// supportedRegions, privateLinkServiceUrl, and so on.
type ConnectorMetadata struct {

	// The connector metadata specific to Amplitude.
	Amplitude *AmplitudeMetadata

	// The connector metadata specific to Amazon Connect Customer Profiles.
	CustomerProfiles *CustomerProfilesMetadata

	// The connector metadata specific to Datadog.
	Datadog *DatadogMetadata

	// The connector metadata specific to Dynatrace.
	Dynatrace *DynatraceMetadata

	// The connector metadata specific to Amazon EventBridge.
	EventBridge *EventBridgeMetadata

	// The connector metadata specific to Google Analytics.
	GoogleAnalytics *GoogleAnalyticsMetadata

	// The connector metadata specific to Amazon Honeycode.
	Honeycode *HoneycodeMetadata

	// The connector metadata specific to Infor Nexus.
	InforNexus *InforNexusMetadata

	// The connector metadata specific to Marketo.
	Marketo *MarketoMetadata

	// The connector metadata specific to Amazon Redshift.
	Redshift *RedshiftMetadata

	// The connector metadata specific to Amazon S3.
	S3 *S3Metadata

	// The connector metadata specific to SAPOData.
	SAPOData *SAPODataMetadata

	// The connector metadata specific to Salesforce.
	Salesforce *SalesforceMetadata

	// The connector metadata specific to ServiceNow.
	ServiceNow *ServiceNowMetadata

	// The connector metadata specific to Singular.
	Singular *SingularMetadata

	// The connector metadata specific to Slack.
	Slack *SlackMetadata

	// The connector metadata specific to Snowflake.
	Snowflake *SnowflakeMetadata

	// The connector metadata specific to Trend Micro.
	Trendmicro *TrendmicroMetadata

	// The connector metadata specific to Upsolver.
	Upsolver *UpsolverMetadata

	// The connector metadata specific to Veeva.
	Veeva *VeevaMetadata

	// The connector metadata specific to Zendesk.
	Zendesk *ZendeskMetadata

	noSmithyDocumentSerde
}

// Used by select connectors for which the OAuth workflow is supported, such as
// Salesforce, Google Analytics, Marketo, Zendesk, and Slack.
type ConnectorOAuthRequest struct {

	// The code provided by the connector when it has been authenticated via the
	// connected app.
	AuthCode *string

	// The URL to which the authentication server redirects the browser after
	// authorization has been granted.
	RedirectUri *string

	noSmithyDocumentSerde
}

// The operation to be performed on the provided source fields.
type ConnectorOperator struct {

	// The operation to be performed on the provided Amplitude source fields.
	Amplitude AmplitudeConnectorOperator

	// The operation to be performed on the provided Datadog source fields.
	Datadog DatadogConnectorOperator

	// The operation to be performed on the provided Dynatrace source fields.
	Dynatrace DynatraceConnectorOperator

	// The operation to be performed on the provided Google Analytics source fields.
	GoogleAnalytics GoogleAnalyticsConnectorOperator

	// The operation to be performed on the provided Infor Nexus source fields.
	InforNexus InforNexusConnectorOperator

	// The operation to be performed on the provided Marketo source fields.
	Marketo MarketoConnectorOperator

	// The operation to be performed on the provided Amazon S3 source fields.
	S3 S3ConnectorOperator

	// The operation to be performed on the provided SAPOData source fields.
	SAPOData SAPODataConnectorOperator

	// The operation to be performed on the provided Salesforce source fields.
	Salesforce SalesforceConnectorOperator

	// The operation to be performed on the provided ServiceNow source fields.
	ServiceNow ServiceNowConnectorOperator

	// The operation to be performed on the provided Singular source fields.
	Singular SingularConnectorOperator

	// The operation to be performed on the provided Slack source fields.
	Slack SlackConnectorOperator

	// The operation to be performed on the provided Trend Micro source fields.
	Trendmicro TrendmicroConnectorOperator

	// The operation to be performed on the provided Veeva source fields.
	Veeva VeevaConnectorOperator

	// The operation to be performed on the provided Zendesk source fields.
	Zendesk ZendeskConnectorOperator

	noSmithyDocumentSerde
}

// Describes an instance of a connector. This includes the provided name,
// credentials ARN, connection-mode, and so on. To keep the API intuitive and
// extensible, the fields that are common to all types of connector profiles are
// explicitly specified at the top level. The rest of the connector-specific
// properties are available via the connectorProfileProperties field.
type ConnectorProfile struct {

	// Indicates the connection mode and if it is public or private.
	ConnectionMode ConnectionMode

	// The Amazon Resource Name (ARN) of the connector profile.
	ConnectorProfileArn *string

	// The name of the connector profile. The name is unique for each ConnectorProfile
	// in the Amazon Web Services account.
	ConnectorProfileName *string

	// The connector-specific properties of the profile configuration.
	ConnectorProfileProperties *ConnectorProfileProperties

	// The type of connector, such as Salesforce, Amplitude, and so on.
	ConnectorType ConnectorType

	// Specifies when the connector profile was created.
	CreatedAt *time.Time

	// The Amazon Resource Name (ARN) of the connector profile credentials.
	CredentialsArn *string

	// Specifies when the connector profile was last updated.
	LastUpdatedAt *time.Time

	// Specifies the private connection provisioning state.
	PrivateConnectionProvisioningState *PrivateConnectionProvisioningState

	noSmithyDocumentSerde
}

// Defines the connector-specific configuration and credentials for the connector
// profile.
type ConnectorProfileConfig struct {

	// The connector-specific credentials required by each connector.
	//
	// This member is required.
	ConnectorProfileCredentials *ConnectorProfileCredentials

	// The connector-specific properties of the profile configuration.
	//
	// This member is required.
	ConnectorProfileProperties *ConnectorProfileProperties

	noSmithyDocumentSerde
}

// The connector-specific credentials required by a connector.
type ConnectorProfileCredentials struct {

	// The connector-specific credentials required when using Amplitude.
	Amplitude *AmplitudeConnectorProfileCredentials

	// The connector-specific credentials required when using Datadog.
	Datadog *DatadogConnectorProfileCredentials

	// The connector-specific credentials required when using Dynatrace.
	Dynatrace *DynatraceConnectorProfileCredentials

	// The connector-specific credentials required when using Google Analytics.
	GoogleAnalytics *GoogleAnalyticsConnectorProfileCredentials

	// The connector-specific credentials required when using Amazon Honeycode.
	Honeycode *HoneycodeConnectorProfileCredentials

	// The connector-specific credentials required when using Infor Nexus.
	InforNexus *InforNexusConnectorProfileCredentials

	// The connector-specific credentials required when using Marketo.
	Marketo *MarketoConnectorProfileCredentials

	// The connector-specific credentials required when using Amazon Redshift.
	Redshift *RedshiftConnectorProfileCredentials

	// The connector-specific profile credentials required when using SAPOData.
	SAPOData *SAPODataConnectorProfileCredentials

	// The connector-specific credentials required when using Salesforce.
	Salesforce *SalesforceConnectorProfileCredentials

	// The connector-specific credentials required when using ServiceNow.
	ServiceNow *ServiceNowConnectorProfileCredentials

	// The connector-specific credentials required when using Singular.
	Singular *SingularConnectorProfileCredentials

	// The connector-specific credentials required when using Slack.
	Slack *SlackConnectorProfileCredentials

	// The connector-specific credentials required when using Snowflake.
	Snowflake *SnowflakeConnectorProfileCredentials

	// The connector-specific credentials required when using Trend Micro.
	Trendmicro *TrendmicroConnectorProfileCredentials

	// The connector-specific credentials required when using Veeva.
	Veeva *VeevaConnectorProfileCredentials

	// The connector-specific credentials required when using Zendesk.
	Zendesk *ZendeskConnectorProfileCredentials

	noSmithyDocumentSerde
}

// The connector-specific profile properties required by each connector.
type ConnectorProfileProperties struct {

	// The connector-specific properties required by Amplitude.
	Amplitude *AmplitudeConnectorProfileProperties

	// The connector-specific properties required by Datadog.
	Datadog *DatadogConnectorProfileProperties

	// The connector-specific properties required by Dynatrace.
	Dynatrace *DynatraceConnectorProfileProperties

	// The connector-specific properties required Google Analytics.
	GoogleAnalytics *GoogleAnalyticsConnectorProfileProperties

	// The connector-specific properties required by Amazon Honeycode.
	Honeycode *HoneycodeConnectorProfileProperties

	// The connector-specific properties required by Infor Nexus.
	InforNexus *InforNexusConnectorProfileProperties

	// The connector-specific properties required by Marketo.
	Marketo *MarketoConnectorProfileProperties

	// The connector-specific properties required by Amazon Redshift.
	Redshift *RedshiftConnectorProfileProperties

	// The connector-specific profile properties required when using SAPOData.
	SAPOData *SAPODataConnectorProfileProperties

	// The connector-specific properties required by Salesforce.
	Salesforce *SalesforceConnectorProfileProperties

	// The connector-specific properties required by serviceNow.
	ServiceNow *ServiceNowConnectorProfileProperties

	// The connector-specific properties required by Singular.
	Singular *SingularConnectorProfileProperties

	// The connector-specific properties required by Slack.
	Slack *SlackConnectorProfileProperties

	// The connector-specific properties required by Snowflake.
	Snowflake *SnowflakeConnectorProfileProperties

	// The connector-specific properties required by Trend Micro.
	Trendmicro *TrendmicroConnectorProfileProperties

	// The connector-specific properties required by Veeva.
	Veeva *VeevaConnectorProfileProperties

	// The connector-specific properties required by Zendesk.
	Zendesk *ZendeskConnectorProfileProperties

	noSmithyDocumentSerde
}

// The properties that are applied when Amazon Connect Customer Profiles is used as
// a destination.
type CustomerProfilesDestinationProperties struct {

	// The unique name of the Amazon Connect Customer Profiles domain.
	//
	// This member is required.
	DomainName *string

	// The object specified in the Amazon Connect Customer Profiles flow destination.
	ObjectTypeName *string

	noSmithyDocumentSerde
}

// The connector metadata specific to Amazon Connect Customer Profiles.
type CustomerProfilesMetadata struct {
	noSmithyDocumentSerde
}

// The connector-specific credentials required by Datadog.
type DatadogConnectorProfileCredentials struct {

	// A unique alphanumeric identifier used to authenticate a user, developer, or
	// calling program to your API.
	//
	// This member is required.
	ApiKey *string

	// Application keys, in conjunction with your API key, give you full access to
	// Datadog’s programmatic API. Application keys are associated with the user
	// account that created them. The application key is used to log all requests made
	// to the API.
	//
	// This member is required.
	ApplicationKey *string

	noSmithyDocumentSerde
}

// The connector-specific profile properties required by Datadog.
type DatadogConnectorProfileProperties struct {

	// The location of the Datadog resource.
	//
	// This member is required.
	InstanceUrl *string

	noSmithyDocumentSerde
}

// The connector metadata specific to Datadog.
type DatadogMetadata struct {
	noSmithyDocumentSerde
}

// The properties that are applied when Datadog is being used as a source.
type DatadogSourceProperties struct {

	// The object specified in the Datadog flow source.
	//
	// This member is required.
	Object *string

	noSmithyDocumentSerde
}

// This stores the information that is required to query a particular connector.
type DestinationConnectorProperties struct {

	// The properties required to query Amazon Connect Customer Profiles.
	CustomerProfiles *CustomerProfilesDestinationProperties

	// The properties required to query Amazon EventBridge.
	EventBridge *EventBridgeDestinationProperties

	// The properties required to query Amazon Honeycode.
	Honeycode *HoneycodeDestinationProperties

	// The properties required to query Amazon Lookout for Metrics.
	LookoutMetrics *LookoutMetricsDestinationProperties

	// The properties required to query Amazon Redshift.
	Redshift *RedshiftDestinationProperties

	// The properties required to query Amazon S3.
	S3 *S3DestinationProperties

	// The properties required to query Salesforce.
	Salesforce *SalesforceDestinationProperties

	// The properties required to query Snowflake.
	Snowflake *SnowflakeDestinationProperties

	// The properties required to query Upsolver.
	Upsolver *UpsolverDestinationProperties

	// The properties required to query Zendesk.
	Zendesk *ZendeskDestinationProperties

	noSmithyDocumentSerde
}

// The properties that can be applied to a field when connector is being used as a
// destination.
type DestinationFieldProperties struct {

	// Specifies if the destination field can be created by the current user.
	IsCreatable bool

	// Specifies if the destination field can have a null value.
	IsNullable bool

	// Specifies whether the field can be updated during an UPDATE or UPSERT write
	// operation.
	IsUpdatable bool

	// Specifies if the flow run can either insert new rows in the destination field if
	// they do not already exist, or update them if they do.
	IsUpsertable bool

	// A list of supported write operations. For each write operation listed, this
	// field can be used in idFieldNames when that write operation is present as a
	// destination option.
	SupportedWriteOperations []WriteOperationType

	noSmithyDocumentSerde
}

// Contains information about the configuration of destination connectors present
// in the flow.
type DestinationFlowConfig struct {

	// The type of connector, such as Salesforce, Amplitude, and so on.
	//
	// This member is required.
	ConnectorType ConnectorType

	// This stores the information that is required to query a particular connector.
	//
	// This member is required.
	DestinationConnectorProperties *DestinationConnectorProperties

	// The name of the connector profile. This name must be unique for each connector
	// profile in the Amazon Web Services account.
	ConnectorProfileName *string

	noSmithyDocumentSerde
}

// The connector-specific profile credentials required by Dynatrace.
type DynatraceConnectorProfileCredentials struct {

	// The API tokens used by Dynatrace API to authenticate various API calls.
	//
	// This member is required.
	ApiToken *string

	noSmithyDocumentSerde
}

// The connector-specific profile properties required by Dynatrace.
type DynatraceConnectorProfileProperties struct {

	// The location of the Dynatrace resource.
	//
	// This member is required.
	InstanceUrl *string

	noSmithyDocumentSerde
}

// The connector metadata specific to Dynatrace.
type DynatraceMetadata struct {
	noSmithyDocumentSerde
}

// The properties that are applied when Dynatrace is being used as a source.
type DynatraceSourceProperties struct {

	// The object specified in the Dynatrace flow source.
	//
	// This member is required.
	Object *string

	noSmithyDocumentSerde
}

// The settings that determine how Amazon AppFlow handles an error when placing
// data in the destination. For example, this setting would determine if the flow
// should fail after one insertion error, or continue and attempt to insert every
// record regardless of the initial failure. ErrorHandlingConfig is a part of the
// destination connector details.
type ErrorHandlingConfig struct {

	// Specifies the name of the Amazon S3 bucket.
	BucketName *string

	// Specifies the Amazon S3 bucket prefix.
	BucketPrefix *string

	// Specifies if the flow should fail after the first instance of a failure when
	// attempting to place data in the destination.
	FailOnFirstDestinationError bool

	noSmithyDocumentSerde
}

// Provides details in the event of a failed flow, including the failure count and
// the related error messages.
type ErrorInfo struct {

	// Specifies the error message that appears if a flow fails.
	ExecutionMessage *string

	// Specifies the failure count for the attempted flow.
	PutFailuresCount *int64

	noSmithyDocumentSerde
}

// The properties that are applied when Amazon EventBridge is being used as a
// destination.
type EventBridgeDestinationProperties struct {

	// The object specified in the Amazon EventBridge flow destination.
	//
	// This member is required.
	Object *string

	// The settings that determine how Amazon AppFlow handles an error when placing
	// data in the destination. For example, this setting would determine if the flow
	// should fail after one insertion error, or continue and attempt to insert every
	// record regardless of the initial failure. ErrorHandlingConfig is a part of the
	// destination connector details.
	ErrorHandlingConfig *ErrorHandlingConfig

	noSmithyDocumentSerde
}

// The connector metadata specific to Amazon EventBridge.
type EventBridgeMetadata struct {
	noSmithyDocumentSerde
}

// Describes the details of the flow run, including the timestamp, status, and
// message.
type ExecutionDetails struct {

	// Describes the details of the most recent flow run.
	MostRecentExecutionMessage *string

	// Specifies the status of the most recent flow run.
	MostRecentExecutionStatus ExecutionStatus

	// Specifies the time of the most recent flow run.
	MostRecentExecutionTime *time.Time

	noSmithyDocumentSerde
}

// Specifies information about the past flow run instances for a given flow.
type ExecutionRecord struct {

	// The timestamp that indicates the last new or updated record to be transferred in
	// the flow run.
	DataPullEndTime *time.Time

	// The timestamp that determines the first new or updated record to be transferred
	// in the flow run.
	DataPullStartTime *time.Time

	// Specifies the identifier of the given flow run.
	ExecutionId *string

	// Describes the result of the given flow run.
	ExecutionResult *ExecutionResult

	// Specifies the flow run status and whether it is in progress, has completed
	// successfully, or has failed.
	ExecutionStatus ExecutionStatus

	// Specifies the time of the most recent update.
	LastUpdatedAt *time.Time

	// Specifies the start time of the flow run.
	StartedAt *time.Time

	noSmithyDocumentSerde
}

// Specifies the end result of the flow run.
type ExecutionResult struct {

	// The total number of bytes processed by the flow run.
	BytesProcessed *int64

	// The total number of bytes written as a result of the flow run.
	BytesWritten *int64

	// Provides any error message information related to the flow run.
	ErrorInfo *ErrorInfo

	// The number of records processed in the flow run.
	RecordsProcessed *int64

	noSmithyDocumentSerde
}

// Contains details regarding the supported field type and the operators that can
// be applied for filtering.
type FieldTypeDetails struct {

	// The type of field, such as string, integer, date, and so on.
	//
	// This member is required.
	FieldType *string

	// The list of operators supported by a field.
	//
	// This member is required.
	FilterOperators []Operator

	// The list of values that a field can contain. For example, a Boolean fieldType
	// can have two values: "true" and "false".
	SupportedValues []string

	noSmithyDocumentSerde
}

// The properties of the flow, such as its source, destination, trigger type, and
// so on.
type FlowDefinition struct {

	// Specifies when the flow was created.
	CreatedAt *time.Time

	// The ARN of the user who created the flow.
	CreatedBy *string

	// A user-entered description of the flow.
	Description *string

	// Specifies the destination connector type, such as Salesforce, Amazon S3,
	// Amplitude, and so on.
	DestinationConnectorType ConnectorType

	// The flow's Amazon Resource Name (ARN).
	FlowArn *string

	// The specified name of the flow. Spaces are not allowed. Use underscores (_) or
	// hyphens (-) only.
	FlowName *string

	// Indicates the current status of the flow.
	FlowStatus FlowStatus

	// Describes the details of the most recent flow run.
	LastRunExecutionDetails *ExecutionDetails

	// Specifies when the flow was last updated.
	LastUpdatedAt *time.Time

	// Specifies the account user name that most recently updated the flow.
	LastUpdatedBy *string

	// Specifies the source connector type, such as Salesforce, Amazon S3, Amplitude,
	// and so on.
	SourceConnectorType ConnectorType

	// The tags used to organize, track, or control access for your flow.
	Tags map[string]string

	// Specifies the type of flow trigger. This can be OnDemand, Scheduled, or Event.
	TriggerType TriggerType

	noSmithyDocumentSerde
}

// The connector-specific profile credentials required by Google Analytics.
type GoogleAnalyticsConnectorProfileCredentials struct {

	// The identifier for the desired client.
	//
	// This member is required.
	ClientId *string

	// The client secret used by the OAuth client to authenticate to the authorization
	// server.
	//
	// This member is required.
	ClientSecret *string

	// The credentials used to access protected Google Analytics resources.
	AccessToken *string

	// The OAuth requirement needed to request security tokens from the connector
	// endpoint.
	OAuthRequest *ConnectorOAuthRequest

	// The credentials used to acquire new access tokens. This is required only for
	// OAuth2 access tokens, and is not required for OAuth1 access tokens.
	RefreshToken *string

	noSmithyDocumentSerde
}

// The connector-specific profile properties required by Google Analytics.
type GoogleAnalyticsConnectorProfileProperties struct {
	noSmithyDocumentSerde
}

// The connector metadata specific to Google Analytics.
type GoogleAnalyticsMetadata struct {

	// The desired authorization scope for the Google Analytics account.
	OAuthScopes []string

	noSmithyDocumentSerde
}

// The properties that are applied when Google Analytics is being used as a source.
type GoogleAnalyticsSourceProperties struct {

	// The object specified in the Google Analytics flow source.
	//
	// This member is required.
	Object *string

	noSmithyDocumentSerde
}

// The connector-specific credentials required when using Amazon Honeycode.
type HoneycodeConnectorProfileCredentials struct {

	// The credentials used to access protected Amazon Honeycode resources.
	AccessToken *string

	// Used by select connectors for which the OAuth workflow is supported, such as
	// Salesforce, Google Analytics, Marketo, Zendesk, and Slack.
	OAuthRequest *ConnectorOAuthRequest

	// The credentials used to acquire new access tokens.
	RefreshToken *string

	noSmithyDocumentSerde
}

// The connector-specific properties required when using Amazon Honeycode.
type HoneycodeConnectorProfileProperties struct {
	noSmithyDocumentSerde
}

// The properties that are applied when Amazon Honeycode is used as a destination.
type HoneycodeDestinationProperties struct {

	// The object specified in the Amazon Honeycode flow destination.
	//
	// This member is required.
	Object *string

	// The settings that determine how Amazon AppFlow handles an error when placing
	// data in the destination. For example, this setting would determine if the flow
	// should fail after one insertion error, or continue and attempt to insert every
	// record regardless of the initial failure. ErrorHandlingConfig is a part of the
	// destination connector details.
	ErrorHandlingConfig *ErrorHandlingConfig

	noSmithyDocumentSerde
}

// The connector metadata specific to Amazon Honeycode.
type HoneycodeMetadata struct {

	// The desired authorization scope for the Amazon Honeycode account.
	OAuthScopes []string

	noSmithyDocumentSerde
}

// Specifies the configuration used when importing incremental records from the
// source.
type IncrementalPullConfig struct {

	// A field that specifies the date time or timestamp field as the criteria to use
	// when importing incremental records from the source.
	DatetimeTypeFieldName *string

	noSmithyDocumentSerde
}

// The connector-specific profile credentials required by Infor Nexus.
type InforNexusConnectorProfileCredentials struct {

	// The Access Key portion of the credentials.
	//
	// This member is required.
	AccessKeyId *string

	// The encryption keys used to encrypt data.
	//
	// This member is required.
	Datakey *string

	// The secret key used to sign requests.
	//
	// This member is required.
	SecretAccessKey *string

	// The identifier for the user.
	//
	// This member is required.
	UserId *string

	noSmithyDocumentSerde
}

// The connector-specific profile properties required by Infor Nexus.
type InforNexusConnectorProfileProperties struct {

	// The location of the Infor Nexus resource.
	//
	// This member is required.
	InstanceUrl *string

	noSmithyDocumentSerde
}

// The connector metadata specific to Infor Nexus.
type InforNexusMetadata struct {
	noSmithyDocumentSerde
}

// The properties that are applied when Infor Nexus is being used as a source.
type InforNexusSourceProperties struct {

	// The object specified in the Infor Nexus flow source.
	//
	// This member is required.
	Object *string

	noSmithyDocumentSerde
}

// The properties that are applied when Amazon Lookout for Metrics is used as a
// destination.
type LookoutMetricsDestinationProperties struct {
	noSmithyDocumentSerde
}

// The connector-specific profile credentials required by Marketo.
type MarketoConnectorProfileCredentials struct {

	// The identifier for the desired client.
	//
	// This member is required.
	ClientId *string

	// The client secret used by the OAuth client to authenticate to the authorization
	// server.
	//
	// This member is required.
	ClientSecret *string

	// The credentials used to access protected Marketo resources.
	AccessToken *string

	// The OAuth requirement needed to request security tokens from the connector
	// endpoint.
	OAuthRequest *ConnectorOAuthRequest

	noSmithyDocumentSerde
}

// The connector-specific profile properties required when using Marketo.
type MarketoConnectorProfileProperties struct {

	// The location of the Marketo resource.
	//
	// This member is required.
	InstanceUrl *string

	noSmithyDocumentSerde
}

// The connector metadata specific to Marketo.
type MarketoMetadata struct {
	noSmithyDocumentSerde
}

// The properties that are applied when Marketo is being used as a source.
type MarketoSourceProperties struct {

	// The object specified in the Marketo flow source.
	//
	// This member is required.
	Object *string

	noSmithyDocumentSerde
}

// The OAuth credentials required for OAuth type authentication.
type OAuthCredentials struct {

	// The identifier for the desired client.
	//
	// This member is required.
	ClientId *string

	// The client secret used by the OAuth client to authenticate to the authorization
	// server.
	//
	// This member is required.
	ClientSecret *string

	// The access token used to access protected SAPOData resources.
	AccessToken *string

	// The OAuth requirement needed to request security tokens from the connector
	// endpoint.
	OAuthRequest *ConnectorOAuthRequest

	// The refresh token used to refresh expired access token.
	RefreshToken *string

	noSmithyDocumentSerde
}

// The OAuth properties required for OAuth type authentication.
type OAuthProperties struct {

	// The authorization code url required to redirect to SAP Login Page to fetch
	// authorization code for OAuth type authentication.
	//
	// This member is required.
	AuthCodeUrl *string

	// The OAuth scopes required for OAuth type authentication.
	//
	// This member is required.
	OAuthScopes []string

	// The token url required to fetch access/refresh tokens using authorization code
	// and also to refresh expired access token using refresh token.
	//
	// This member is required.
	TokenUrl *string

	noSmithyDocumentSerde
}

// Determines the prefix that Amazon AppFlow applies to the destination folder
// name. You can name your destination folders according to the flow frequency and
// date.
type PrefixConfig struct {

	// Determines the level of granularity that's included in the prefix.
	PrefixFormat PrefixFormat

	// Determines the format of the prefix, and whether it applies to the file name,
	// file path, or both.
	PrefixType PrefixType

	noSmithyDocumentSerde
}

// Specifies the private connection provisioning state.
type PrivateConnectionProvisioningState struct {

	// Specifies the private connection provisioning failure cause.
	FailureCause PrivateConnectionProvisioningFailureCause

	// Specifies the private connection provisioning failure reason.
	FailureMessage *string

	// Specifies the private connection provisioning status.
	Status PrivateConnectionProvisioningStatus

	noSmithyDocumentSerde
}

// The connector-specific profile credentials required when using Amazon Redshift.
type RedshiftConnectorProfileCredentials struct {

	// The password that corresponds to the user name.
	//
	// This member is required.
	Password *string

	// The name of the user.
	//
	// This member is required.
	Username *string

	noSmithyDocumentSerde
}

// The connector-specific profile properties when using Amazon Redshift.
type RedshiftConnectorProfileProperties struct {

	// A name for the associated Amazon S3 bucket.
	//
	// This member is required.
	BucketName *string

	// The JDBC URL of the Amazon Redshift cluster.
	//
	// This member is required.
	DatabaseUrl *string

	// The Amazon Resource Name (ARN) of the IAM role.
	//
	// This member is required.
	RoleArn *string

	// The object key for the destination bucket in which Amazon AppFlow places the
	// files.
	BucketPrefix *string

	noSmithyDocumentSerde
}

// The properties that are applied when Amazon Redshift is being used as a
// destination.
type RedshiftDestinationProperties struct {

	// The intermediate bucket that Amazon AppFlow uses when moving data into Amazon
	// Redshift.
	//
	// This member is required.
	IntermediateBucketName *string

	// The object specified in the Amazon Redshift flow destination.
	//
	// This member is required.
	Object *string

	// The object key for the bucket in which Amazon AppFlow places the destination
	// files.
	BucketPrefix *string

	// The settings that determine how Amazon AppFlow handles an error when placing
	// data in the Amazon Redshift destination. For example, this setting would
	// determine if the flow should fail after one insertion error, or continue and
	// attempt to insert every record regardless of the initial failure.
	// ErrorHandlingConfig is a part of the destination connector details.
	ErrorHandlingConfig *ErrorHandlingConfig

	noSmithyDocumentSerde
}

// The connector metadata specific to Amazon Redshift.
type RedshiftMetadata struct {
	noSmithyDocumentSerde
}

// The properties that are applied when Amazon S3 is used as a destination.
type S3DestinationProperties struct {

	// The Amazon S3 bucket name in which Amazon AppFlow places the transferred data.
	//
	// This member is required.
	BucketName *string

	// The object key for the destination bucket in which Amazon AppFlow places the
	// files.
	BucketPrefix *string

	// The configuration that determines how Amazon AppFlow should format the flow
	// output data when Amazon S3 is used as the destination.
	S3OutputFormatConfig *S3OutputFormatConfig

	noSmithyDocumentSerde
}

// When you use Amazon S3 as the source, the configuration format that you provide
// the flow input data.
type S3InputFormatConfig struct {

	// The file type that Amazon AppFlow gets from your Amazon S3 bucket.
	S3InputFileType S3InputFileType

	noSmithyDocumentSerde
}

// The connector metadata specific to Amazon S3.
type S3Metadata struct {
	noSmithyDocumentSerde
}

// The configuration that determines how Amazon AppFlow should format the flow
// output data when Amazon S3 is used as the destination.
type S3OutputFormatConfig struct {

	// The aggregation settings that you can use to customize the output format of your
	// flow data.
	AggregationConfig *AggregationConfig

	// Indicates the file type that Amazon AppFlow places in the Amazon S3 bucket.
	FileType FileType

	// Determines the prefix that Amazon AppFlow applies to the folder name in the
	// Amazon S3 bucket. You can name folders according to the flow frequency and date.
	PrefixConfig *PrefixConfig

	noSmithyDocumentSerde
}

// The properties that are applied when Amazon S3 is being used as the flow source.
type S3SourceProperties struct {

	// The Amazon S3 bucket name where the source files are stored.
	//
	// This member is required.
	BucketName *string

	// The object key for the Amazon S3 bucket in which the source files are stored.
	BucketPrefix *string

	// When you use Amazon S3 as the source, the configuration format that you provide
	// the flow input data.
	S3InputFormatConfig *S3InputFormatConfig

	noSmithyDocumentSerde
}

// The connector-specific profile credentials required when using Salesforce.
type SalesforceConnectorProfileCredentials struct {

	// The credentials used to access protected Salesforce resources.
	AccessToken *string

	// The secret manager ARN, which contains the client ID and client secret of the
	// connected app.
	ClientCredentialsArn *string

	// The OAuth requirement needed to request security tokens from the connector
	// endpoint.
	OAuthRequest *ConnectorOAuthRequest

	// The credentials used to acquire new access tokens.
	RefreshToken *string

	noSmithyDocumentSerde
}

// The connector-specific profile properties required when using Salesforce.
type SalesforceConnectorProfileProperties struct {

	// The location of the Salesforce resource.
	InstanceUrl *string

	// Indicates whether the connector profile applies to a sandbox or production
	// environment.
	IsSandboxEnvironment bool

	noSmithyDocumentSerde
}

// The properties that are applied when Salesforce is being used as a destination.
type SalesforceDestinationProperties struct {

	// The object specified in the Salesforce flow destination.
	//
	// This member is required.
	Object *string

	// The settings that determine how Amazon AppFlow handles an error when placing
	// data in the Salesforce destination. For example, this setting would determine if
	// the flow should fail after one insertion error, or continue and attempt to
	// insert every record regardless of the initial failure. ErrorHandlingConfig is a
	// part of the destination connector details.
	ErrorHandlingConfig *ErrorHandlingConfig

	// The name of the field that Amazon AppFlow uses as an ID when performing a write
	// operation such as update or delete.
	IdFieldNames []string

	// This specifies the type of write operation to be performed in Salesforce. When
	// the value is UPSERT, then idFieldNames is required.
	WriteOperationType WriteOperationType

	noSmithyDocumentSerde
}

// The connector metadata specific to Salesforce.
type SalesforceMetadata struct {

	// The desired authorization scope for the Salesforce account.
	OAuthScopes []string

	noSmithyDocumentSerde
}

// The properties that are applied when Salesforce is being used as a source.
type SalesforceSourceProperties struct {

	// The object specified in the Salesforce flow source.
	//
	// This member is required.
	Object *string

	// The flag that enables dynamic fetching of new (recently added) fields in the
	// Salesforce objects while running a flow.
	EnableDynamicFieldUpdate bool

	// Indicates whether Amazon AppFlow includes deleted files in the flow run.
	IncludeDeletedRecords bool

	noSmithyDocumentSerde
}

// The connector-specific profile credentials required when using SAPOData.
type SAPODataConnectorProfileCredentials struct {

	// The SAPOData basic authentication credentials.
	BasicAuthCredentials *BasicAuthCredentials

	// The SAPOData OAuth type authentication credentials.
	OAuthCredentials *OAuthCredentials

	noSmithyDocumentSerde
}

// The connector-specific profile properties required when using SAPOData.
type SAPODataConnectorProfileProperties struct {

	// The location of the SAPOData resource.
	//
	// This member is required.
	ApplicationHostUrl *string

	// The application path to catalog service.
	//
	// This member is required.
	ApplicationServicePath *string

	// The client number for the client creating the connection.
	//
	// This member is required.
	ClientNumber *string

	// The port number of the SAPOData instance.
	//
	// This member is required.
	PortNumber int32

	// The logon language of SAPOData instance.
	LogonLanguage *string

	// The SAPOData OAuth properties required for OAuth type authentication.
	OAuthProperties *OAuthProperties

	// The SAPOData Private Link service name to be used for private data transfers.
	PrivateLinkServiceName *string

	noSmithyDocumentSerde
}

// The connector metadata specific to SAPOData.
type SAPODataMetadata struct {
	noSmithyDocumentSerde
}

// The properties that are applied when using SAPOData as a flow source.
type SAPODataSourceProperties struct {

	// The object path specified in the SAPOData flow source.
	ObjectPath *string

	noSmithyDocumentSerde
}

// Specifies the configuration details of a schedule-triggered flow as defined by
// the user. Currently, these settings only apply to the Scheduled trigger type.
type ScheduledTriggerProperties struct {

	// The scheduling expression that determines the rate at which the schedule will
	// run, for example rate(5minutes).
	//
	// This member is required.
	ScheduleExpression *string

	// Specifies whether a scheduled flow has an incremental data transfer or a
	// complete data transfer for each flow run.
	DataPullMode DataPullMode

	// Specifies the date range for the records to import from the connector in the
	// first flow run.
	FirstExecutionFrom *time.Time

	// Specifies the scheduled end time for a schedule-triggered flow.
	ScheduleEndTime *time.Time

	// Specifies the optional offset that is added to the time interval for a
	// schedule-triggered flow.
	ScheduleOffset int64

	// Specifies the scheduled start time for a schedule-triggered flow.
	ScheduleStartTime *time.Time

	// Specifies the time zone used when referring to the date and time of a
	// scheduled-triggered flow, such as America/New_York.
	Timezone *string

	noSmithyDocumentSerde
}

// The connector-specific profile credentials required when using ServiceNow.
type ServiceNowConnectorProfileCredentials struct {

	// The password that corresponds to the user name.
	//
	// This member is required.
	Password *string

	// The name of the user.
	//
	// This member is required.
	Username *string

	noSmithyDocumentSerde
}

// The connector-specific profile properties required when using ServiceNow.
type ServiceNowConnectorProfileProperties struct {

	// The location of the ServiceNow resource.
	//
	// This member is required.
	InstanceUrl *string

	noSmithyDocumentSerde
}

// The connector metadata specific to ServiceNow.
type ServiceNowMetadata struct {
	noSmithyDocumentSerde
}

// The properties that are applied when ServiceNow is being used as a source.
type ServiceNowSourceProperties struct {

	// The object specified in the ServiceNow flow source.
	//
	// This member is required.
	Object *string

	noSmithyDocumentSerde
}

// The connector-specific profile credentials required when using Singular.
type SingularConnectorProfileCredentials struct {

	// A unique alphanumeric identifier used to authenticate a user, developer, or
	// calling program to your API.
	//
	// This member is required.
	ApiKey *string

	noSmithyDocumentSerde
}

// The connector-specific profile properties required when using Singular.
type SingularConnectorProfileProperties struct {
	noSmithyDocumentSerde
}

// The connector metadata specific to Singular.
type SingularMetadata struct {
	noSmithyDocumentSerde
}

// The properties that are applied when Singular is being used as a source.
type SingularSourceProperties struct {

	// The object specified in the Singular flow source.
	//
	// This member is required.
	Object *string

	noSmithyDocumentSerde
}

// The connector-specific profile credentials required when using Slack.
type SlackConnectorProfileCredentials struct {

	// The identifier for the client.
	//
	// This member is required.
	ClientId *string

	// The client secret used by the OAuth client to authenticate to the authorization
	// server.
	//
	// This member is required.
	ClientSecret *string

	// The credentials used to access protected Slack resources.
	AccessToken *string

	// The OAuth requirement needed to request security tokens from the connector
	// endpoint.
	OAuthRequest *ConnectorOAuthRequest

	noSmithyDocumentSerde
}

// The connector-specific profile properties required when using Slack.
type SlackConnectorProfileProperties struct {

	// The location of the Slack resource.
	//
	// This member is required.
	InstanceUrl *string

	noSmithyDocumentSerde
}

// The connector metadata specific to Slack.
type SlackMetadata struct {

	// The desired authorization scope for the Slack account.
	OAuthScopes []string

	noSmithyDocumentSerde
}

// The properties that are applied when Slack is being used as a source.
type SlackSourceProperties struct {

	// The object specified in the Slack flow source.
	//
	// This member is required.
	Object *string

	noSmithyDocumentSerde
}

// The connector-specific profile credentials required when using Snowflake.
type SnowflakeConnectorProfileCredentials struct {

	// The password that corresponds to the user name.
	//
	// This member is required.
	Password *string

	// The name of the user.
	//
	// This member is required.
	Username *string

	noSmithyDocumentSerde
}

// The connector-specific profile properties required when using Snowflake.
type SnowflakeConnectorProfileProperties struct {

	// The name of the Amazon S3 bucket associated with Snowflake.
	//
	// This member is required.
	BucketName *string

	// The name of the Amazon S3 stage that was created while setting up an Amazon S3
	// stage in the Snowflake account. This is written in the following format: <
	// Database>< Schema>.
	//
	// This member is required.
	Stage *string

	// The name of the Snowflake warehouse.
	//
	// This member is required.
	Warehouse *string

	// The name of the account.
	AccountName *string

	// The bucket path that refers to the Amazon S3 bucket associated with Snowflake.
	BucketPrefix *string

	// The Snowflake Private Link service name to be used for private data transfers.
	PrivateLinkServiceName *string

	// The Amazon Web Services Region of the Snowflake account.
	Region *string

	noSmithyDocumentSerde
}

// The properties that are applied when Snowflake is being used as a destination.
type SnowflakeDestinationProperties struct {

	// The intermediate bucket that Amazon AppFlow uses when moving data into
	// Snowflake.
	//
	// This member is required.
	IntermediateBucketName *string

	// The object specified in the Snowflake flow destination.
	//
	// This member is required.
	Object *string

	// The object key for the destination bucket in which Amazon AppFlow places the
	// files.
	BucketPrefix *string

	// The settings that determine how Amazon AppFlow handles an error when placing
	// data in the Snowflake destination. For example, this setting would determine if
	// the flow should fail after one insertion error, or continue and attempt to
	// insert every record regardless of the initial failure. ErrorHandlingConfig is a
	// part of the destination connector details.
	ErrorHandlingConfig *ErrorHandlingConfig

	noSmithyDocumentSerde
}

// The connector metadata specific to Snowflake.
type SnowflakeMetadata struct {

	// Specifies the supported Amazon Web Services Regions when using Snowflake.
	SupportedRegions []string

	noSmithyDocumentSerde
}

// Specifies the information that is required to query a particular connector.
type SourceConnectorProperties struct {

	// Specifies the information that is required for querying Amplitude.
	Amplitude *AmplitudeSourceProperties

	// Specifies the information that is required for querying Datadog.
	Datadog *DatadogSourceProperties

	// Specifies the information that is required for querying Dynatrace.
	Dynatrace *DynatraceSourceProperties

	// Specifies the information that is required for querying Google Analytics.
	GoogleAnalytics *GoogleAnalyticsSourceProperties

	// Specifies the information that is required for querying Infor Nexus.
	InforNexus *InforNexusSourceProperties

	// Specifies the information that is required for querying Marketo.
	Marketo *MarketoSourceProperties

	// Specifies the information that is required for querying Amazon S3.
	S3 *S3SourceProperties

	// The properties that are applied when using SAPOData as a flow source.
	SAPOData *SAPODataSourceProperties

	// Specifies the information that is required for querying Salesforce.
	Salesforce *SalesforceSourceProperties

	// Specifies the information that is required for querying ServiceNow.
	ServiceNow *ServiceNowSourceProperties

	// Specifies the information that is required for querying Singular.
	Singular *SingularSourceProperties

	// Specifies the information that is required for querying Slack.
	Slack *SlackSourceProperties

	// Specifies the information that is required for querying Trend Micro.
	Trendmicro *TrendmicroSourceProperties

	// Specifies the information that is required for querying Veeva.
	Veeva *VeevaSourceProperties

	// Specifies the information that is required for querying Zendesk.
	Zendesk *ZendeskSourceProperties

	noSmithyDocumentSerde
}

// The properties that can be applied to a field when the connector is being used
// as a source.
type SourceFieldProperties struct {

	// Indicates if the field can be queried.
	IsQueryable bool

	// Indicates whether the field can be returned in a search result.
	IsRetrievable bool

	noSmithyDocumentSerde
}

// Contains information about the configuration of the source connector used in the
// flow.
type SourceFlowConfig struct {

	// The type of connector, such as Salesforce, Amplitude, and so on.
	//
	// This member is required.
	ConnectorType ConnectorType

	// Specifies the information that is required to query a particular source
	// connector.
	//
	// This member is required.
	SourceConnectorProperties *SourceConnectorProperties

	// The name of the connector profile. This name must be unique for each connector
	// profile in the Amazon Web Services account.
	ConnectorProfileName *string

	// Defines the configuration for a scheduled incremental data pull. If a valid
	// configuration is provided, the fields specified in the configuration are used
	// when querying for the incremental data pull.
	IncrementalPullConfig *IncrementalPullConfig

	noSmithyDocumentSerde
}

// Contains details regarding all the supported FieldTypes and their corresponding
// filterOperators and supportedValues.
type SupportedFieldTypeDetails struct {

	// The initial supported version for fieldType. If this is later changed to a
	// different version, v2 will be introduced.
	//
	// This member is required.
	V1 *FieldTypeDetails

	noSmithyDocumentSerde
}

// A class for modeling different type of tasks. Task implementation varies based
// on the TaskType.
type Task struct {

	// The source fields to which a particular task is applied.
	//
	// This member is required.
	SourceFields []string

	// Specifies the particular task implementation that Amazon AppFlow performs.
	//
	// This member is required.
	TaskType TaskType

	// The operation to be performed on the provided source fields.
	ConnectorOperator *ConnectorOperator

	// A field in a destination connector, or a field value against which Amazon
	// AppFlow validates a source field.
	DestinationField *string

	// A map used to store task-related information. The execution service looks for
	// particular information based on the TaskType.
	TaskProperties map[string]string

	noSmithyDocumentSerde
}

// The connector-specific profile credentials required when using Trend Micro.
type TrendmicroConnectorProfileCredentials struct {

	// The Secret Access Key portion of the credentials.
	//
	// This member is required.
	ApiSecretKey *string

	noSmithyDocumentSerde
}

// The connector-specific profile properties required when using Trend Micro.
type TrendmicroConnectorProfileProperties struct {
	noSmithyDocumentSerde
}

// The connector metadata specific to Trend Micro.
type TrendmicroMetadata struct {
	noSmithyDocumentSerde
}

// The properties that are applied when using Trend Micro as a flow source.
type TrendmicroSourceProperties struct {

	// The object specified in the Trend Micro flow source.
	//
	// This member is required.
	Object *string

	noSmithyDocumentSerde
}

// The trigger settings that determine how and when Amazon AppFlow runs the
// specified flow.
type TriggerConfig struct {

	// Specifies the type of flow trigger. This can be OnDemand, Scheduled, or Event.
	//
	// This member is required.
	TriggerType TriggerType

	// Specifies the configuration details of a schedule-triggered flow as defined by
	// the user. Currently, these settings only apply to the Scheduled trigger type.
	TriggerProperties *TriggerProperties

	noSmithyDocumentSerde
}

// Specifies the configuration details that control the trigger for a flow.
// Currently, these settings only apply to the Scheduled trigger type.
type TriggerProperties struct {

	// Specifies the configuration details of a schedule-triggered flow as defined by
	// the user.
	Scheduled *ScheduledTriggerProperties

	noSmithyDocumentSerde
}

// The properties that are applied when Upsolver is used as a destination.
type UpsolverDestinationProperties struct {

	// The Upsolver Amazon S3 bucket name in which Amazon AppFlow places the
	// transferred data.
	//
	// This member is required.
	BucketName *string

	// The configuration that determines how data is formatted when Upsolver is used as
	// the flow destination.
	//
	// This member is required.
	S3OutputFormatConfig *UpsolverS3OutputFormatConfig

	// The object key for the destination Upsolver Amazon S3 bucket in which Amazon
	// AppFlow places the files.
	BucketPrefix *string

	noSmithyDocumentSerde
}

// The connector metadata specific to Upsolver.
type UpsolverMetadata struct {
	noSmithyDocumentSerde
}

// The configuration that determines how Amazon AppFlow formats the flow output
// data when Upsolver is used as the destination.
type UpsolverS3OutputFormatConfig struct {

	// Determines the prefix that Amazon AppFlow applies to the destination folder
	// name. You can name your destination folders according to the flow frequency and
	// date.
	//
	// This member is required.
	PrefixConfig *PrefixConfig

	// The aggregation settings that you can use to customize the output format of your
	// flow data.
	AggregationConfig *AggregationConfig

	// Indicates the file type that Amazon AppFlow places in the Upsolver Amazon S3
	// bucket.
	FileType FileType

	noSmithyDocumentSerde
}

// The connector-specific profile credentials required when using Veeva.
type VeevaConnectorProfileCredentials struct {

	// The password that corresponds to the user name.
	//
	// This member is required.
	Password *string

	// The name of the user.
	//
	// This member is required.
	Username *string

	noSmithyDocumentSerde
}

// The connector-specific profile properties required when using Veeva.
type VeevaConnectorProfileProperties struct {

	// The location of the Veeva resource.
	//
	// This member is required.
	InstanceUrl *string

	noSmithyDocumentSerde
}

// The connector metadata specific to Veeva.
type VeevaMetadata struct {
	noSmithyDocumentSerde
}

// The properties that are applied when using Veeva as a flow source.
type VeevaSourceProperties struct {

	// The object specified in the Veeva flow source.
	//
	// This member is required.
	Object *string

	// The document type specified in the Veeva document extract flow.
	DocumentType *string

	// Boolean value to include All Versions of files in Veeva document extract flow.
	IncludeAllVersions bool

	// Boolean value to include file renditions in Veeva document extract flow.
	IncludeRenditions bool

	// Boolean value to include source files in Veeva document extract flow.
	IncludeSourceFiles bool

	noSmithyDocumentSerde
}

// The connector-specific profile credentials required when using Zendesk.
type ZendeskConnectorProfileCredentials struct {

	// The identifier for the desired client.
	//
	// This member is required.
	ClientId *string

	// The client secret used by the OAuth client to authenticate to the authorization
	// server.
	//
	// This member is required.
	ClientSecret *string

	// The credentials used to access protected Zendesk resources.
	AccessToken *string

	// The OAuth requirement needed to request security tokens from the connector
	// endpoint.
	OAuthRequest *ConnectorOAuthRequest

	noSmithyDocumentSerde
}

// The connector-specific profile properties required when using Zendesk.
type ZendeskConnectorProfileProperties struct {

	// The location of the Zendesk resource.
	//
	// This member is required.
	InstanceUrl *string

	noSmithyDocumentSerde
}

// The properties that are applied when Zendesk is used as a destination.
type ZendeskDestinationProperties struct {

	// The object specified in the Zendesk flow destination.
	//
	// This member is required.
	Object *string

	// The settings that determine how Amazon AppFlow handles an error when placing
	// data in the destination. For example, this setting would determine if the flow
	// should fail after one insertion error, or continue and attempt to insert every
	// record regardless of the initial failure. ErrorHandlingConfig is a part of the
	// destination connector details.
	ErrorHandlingConfig *ErrorHandlingConfig

	// A list of field names that can be used as an ID field when performing a write
	// operation.
	IdFieldNames []string

	// The possible write operations in the destination connector. When this value is
	// not provided, this defaults to the INSERT operation.
	WriteOperationType WriteOperationType

	noSmithyDocumentSerde
}

// The connector metadata specific to Zendesk.
type ZendeskMetadata struct {

	// The desired authorization scope for the Zendesk account.
	OAuthScopes []string

	noSmithyDocumentSerde
}

// The properties that are applied when using Zendesk as a flow source.
type ZendeskSourceProperties struct {

	// The object specified in the Zendesk flow source.
	//
	// This member is required.
	Object *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
