// Code generated by smithy-go-codegen DO NOT EDIT.

package appconfigdata

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Starts a configuration session used to retrieve a deployed configuration. See
// the GetLatestConfiguration API for more details.
func (c *Client) StartConfigurationSession(ctx context.Context, params *StartConfigurationSessionInput, optFns ...func(*Options)) (*StartConfigurationSessionOutput, error) {
	if params == nil {
		params = &StartConfigurationSessionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartConfigurationSession", params, optFns, c.addOperationStartConfigurationSessionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartConfigurationSessionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Request parameters for the StartConfigurationSession API.
type StartConfigurationSessionInput struct {

	// The application ID or the application name.
	//
	// This member is required.
	ApplicationIdentifier *string

	// The configuration profile ID or the configuration profile name.
	//
	// This member is required.
	ConfigurationProfileIdentifier *string

	// The environment ID or the environment name.
	//
	// This member is required.
	EnvironmentIdentifier *string

	// The interval at which your client will poll for configuration. If provided, the
	// service will throw a BadRequestException if the client polls before the
	// specified poll interval. By default, client poll intervals are not enforced.
	RequiredMinimumPollIntervalInSeconds *int32

	noSmithyDocumentSerde
}

// Response parameters for the StartConfigurationSession API.
type StartConfigurationSessionOutput struct {

	// Token encapsulating state about the configuration session. Provide this token to
	// the GetLatestConfiguration API to retrieve configuration data. This token should
	// only be used once in your first call to GetLatestConfiguration. You MUST use the
	// new token in the GetConfiguration response (NextPollConfigurationToken) in each
	// subsequent call to GetLatestConfiguration.
	InitialConfigurationToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartConfigurationSessionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpStartConfigurationSession{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpStartConfigurationSession{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpStartConfigurationSessionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartConfigurationSession(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opStartConfigurationSession(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "appconfig",
		OperationName: "StartConfigurationSession",
	}
}
