// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workspaces

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ModifyWorkspaceCreationPropertiesInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory.
	//
	// ResourceId is a required field
	ResourceId *string `min:"10" type:"string" required:"true"`

	// The default properties for creating WorkSpaces.
	//
	// WorkspaceCreationProperties is a required field
	WorkspaceCreationProperties *WorkspaceCreationProperties `type:"structure" required:"true"`
}

// String returns the string representation
func (s ModifyWorkspaceCreationPropertiesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyWorkspaceCreationPropertiesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModifyWorkspaceCreationPropertiesInput"}

	if s.ResourceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 10 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceId", 10))
	}

	if s.WorkspaceCreationProperties == nil {
		invalidParams.Add(aws.NewErrParamRequired("WorkspaceCreationProperties"))
	}
	if s.WorkspaceCreationProperties != nil {
		if err := s.WorkspaceCreationProperties.Validate(); err != nil {
			invalidParams.AddNested("WorkspaceCreationProperties", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ModifyWorkspaceCreationPropertiesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ModifyWorkspaceCreationPropertiesOutput) String() string {
	return awsutil.Prettify(s)
}

const opModifyWorkspaceCreationProperties = "ModifyWorkspaceCreationProperties"

// ModifyWorkspaceCreationPropertiesRequest returns a request value for making API operation for
// Amazon WorkSpaces.
//
// Modify the default properties used to create WorkSpaces.
//
//    // Example sending a request using ModifyWorkspaceCreationPropertiesRequest.
//    req := client.ModifyWorkspaceCreationPropertiesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceCreationProperties
func (c *Client) ModifyWorkspaceCreationPropertiesRequest(input *ModifyWorkspaceCreationPropertiesInput) ModifyWorkspaceCreationPropertiesRequest {
	op := &aws.Operation{
		Name:       opModifyWorkspaceCreationProperties,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyWorkspaceCreationPropertiesInput{}
	}

	req := c.newRequest(op, input, &ModifyWorkspaceCreationPropertiesOutput{})

	return ModifyWorkspaceCreationPropertiesRequest{Request: req, Input: input, Copy: c.ModifyWorkspaceCreationPropertiesRequest}
}

// ModifyWorkspaceCreationPropertiesRequest is the request type for the
// ModifyWorkspaceCreationProperties API operation.
type ModifyWorkspaceCreationPropertiesRequest struct {
	*aws.Request
	Input *ModifyWorkspaceCreationPropertiesInput
	Copy  func(*ModifyWorkspaceCreationPropertiesInput) ModifyWorkspaceCreationPropertiesRequest
}

// Send marshals and sends the ModifyWorkspaceCreationProperties API request.
func (r ModifyWorkspaceCreationPropertiesRequest) Send(ctx context.Context) (*ModifyWorkspaceCreationPropertiesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ModifyWorkspaceCreationPropertiesResponse{
		ModifyWorkspaceCreationPropertiesOutput: r.Request.Data.(*ModifyWorkspaceCreationPropertiesOutput),
		response:                                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ModifyWorkspaceCreationPropertiesResponse is the response type for the
// ModifyWorkspaceCreationProperties API operation.
type ModifyWorkspaceCreationPropertiesResponse struct {
	*ModifyWorkspaceCreationPropertiesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ModifyWorkspaceCreationProperties request.
func (r *ModifyWorkspaceCreationPropertiesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
