// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workspaces

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeWorkspaceImagesInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the image.
	ImageIds []string `min:"1" type:"list"`

	// The maximum number of items to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// If you received a NextToken from a previous call that was paginated, provide
	// this token to receive the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeWorkspaceImagesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkspaceImagesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeWorkspaceImagesInput"}
	if s.ImageIds != nil && len(s.ImageIds) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ImageIds", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeWorkspaceImagesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the images.
	Images []WorkspaceImage `type:"list"`

	// The token to use to retrieve the next set of results, or null if no more
	// results are available.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeWorkspaceImagesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeWorkspaceImages = "DescribeWorkspaceImages"

// DescribeWorkspaceImagesRequest returns a request value for making API operation for
// Amazon WorkSpaces.
//
// Retrieves a list that describes one or more specified images, if the image
// identifiers are provided. Otherwise, all images in the account are described.
//
//    // Example sending a request using DescribeWorkspaceImagesRequest.
//    req := client.DescribeWorkspaceImagesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceImages
func (c *Client) DescribeWorkspaceImagesRequest(input *DescribeWorkspaceImagesInput) DescribeWorkspaceImagesRequest {
	op := &aws.Operation{
		Name:       opDescribeWorkspaceImages,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeWorkspaceImagesInput{}
	}

	req := c.newRequest(op, input, &DescribeWorkspaceImagesOutput{})

	return DescribeWorkspaceImagesRequest{Request: req, Input: input, Copy: c.DescribeWorkspaceImagesRequest}
}

// DescribeWorkspaceImagesRequest is the request type for the
// DescribeWorkspaceImages API operation.
type DescribeWorkspaceImagesRequest struct {
	*aws.Request
	Input *DescribeWorkspaceImagesInput
	Copy  func(*DescribeWorkspaceImagesInput) DescribeWorkspaceImagesRequest
}

// Send marshals and sends the DescribeWorkspaceImages API request.
func (r DescribeWorkspaceImagesRequest) Send(ctx context.Context) (*DescribeWorkspaceImagesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeWorkspaceImagesResponse{
		DescribeWorkspaceImagesOutput: r.Request.Data.(*DescribeWorkspaceImagesOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeWorkspaceImagesResponse is the response type for the
// DescribeWorkspaceImages API operation.
type DescribeWorkspaceImagesResponse struct {
	*DescribeWorkspaceImagesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeWorkspaceImages request.
func (r *DescribeWorkspaceImagesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
