// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workmail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListAccessControlRulesInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the organization.
	//
	// OrganizationId is a required field
	OrganizationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListAccessControlRulesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAccessControlRulesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListAccessControlRulesInput"}

	if s.OrganizationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("OrganizationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListAccessControlRulesOutput struct {
	_ struct{} `type:"structure"`

	// The access control rules.
	Rules []AccessControlRule `type:"list"`
}

// String returns the string representation
func (s ListAccessControlRulesOutput) String() string {
	return awsutil.Prettify(s)
}

const opListAccessControlRules = "ListAccessControlRules"

// ListAccessControlRulesRequest returns a request value for making API operation for
// Amazon WorkMail.
//
// Lists the access control rules for the specified organization.
//
//    // Example sending a request using ListAccessControlRulesRequest.
//    req := client.ListAccessControlRulesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListAccessControlRules
func (c *Client) ListAccessControlRulesRequest(input *ListAccessControlRulesInput) ListAccessControlRulesRequest {
	op := &aws.Operation{
		Name:       opListAccessControlRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListAccessControlRulesInput{}
	}

	req := c.newRequest(op, input, &ListAccessControlRulesOutput{})

	return ListAccessControlRulesRequest{Request: req, Input: input, Copy: c.ListAccessControlRulesRequest}
}

// ListAccessControlRulesRequest is the request type for the
// ListAccessControlRules API operation.
type ListAccessControlRulesRequest struct {
	*aws.Request
	Input *ListAccessControlRulesInput
	Copy  func(*ListAccessControlRulesInput) ListAccessControlRulesRequest
}

// Send marshals and sends the ListAccessControlRules API request.
func (r ListAccessControlRulesRequest) Send(ctx context.Context) (*ListAccessControlRulesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListAccessControlRulesResponse{
		ListAccessControlRulesOutput: r.Request.Data.(*ListAccessControlRulesOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListAccessControlRulesResponse is the response type for the
// ListAccessControlRules API operation.
type ListAccessControlRulesResponse struct {
	*ListAccessControlRulesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListAccessControlRules request.
func (r *ListAccessControlRulesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
