// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package worklink

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListWebsiteAuthorizationProvidersInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the fleet.
	//
	// FleetArn is a required field
	FleetArn *string `min:"20" type:"string" required:"true"`

	// The maximum number of results to be included in the next page.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListWebsiteAuthorizationProvidersInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListWebsiteAuthorizationProvidersInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListWebsiteAuthorizationProvidersInput"}

	if s.FleetArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("FleetArn"))
	}
	if s.FleetArn != nil && len(*s.FleetArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("FleetArn", 20))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListWebsiteAuthorizationProvidersInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.FleetArn != nil {
		v := *s.FleetArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FleetArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListWebsiteAuthorizationProvidersOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"1" type:"string"`

	// The website authorization providers.
	WebsiteAuthorizationProviders []WebsiteAuthorizationProviderSummary `type:"list"`
}

// String returns the string representation
func (s ListWebsiteAuthorizationProvidersOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListWebsiteAuthorizationProvidersOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.WebsiteAuthorizationProviders != nil {
		v := s.WebsiteAuthorizationProviders

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "WebsiteAuthorizationProviders", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListWebsiteAuthorizationProviders = "ListWebsiteAuthorizationProviders"

// ListWebsiteAuthorizationProvidersRequest returns a request value for making API operation for
// Amazon WorkLink.
//
// Retrieves a list of website authorization providers associated with a specified
// fleet.
//
//    // Example sending a request using ListWebsiteAuthorizationProvidersRequest.
//    req := client.ListWebsiteAuthorizationProvidersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListWebsiteAuthorizationProviders
func (c *Client) ListWebsiteAuthorizationProvidersRequest(input *ListWebsiteAuthorizationProvidersInput) ListWebsiteAuthorizationProvidersRequest {
	op := &aws.Operation{
		Name:       opListWebsiteAuthorizationProviders,
		HTTPMethod: "POST",
		HTTPPath:   "/listWebsiteAuthorizationProviders",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListWebsiteAuthorizationProvidersInput{}
	}

	req := c.newRequest(op, input, &ListWebsiteAuthorizationProvidersOutput{})

	return ListWebsiteAuthorizationProvidersRequest{Request: req, Input: input, Copy: c.ListWebsiteAuthorizationProvidersRequest}
}

// ListWebsiteAuthorizationProvidersRequest is the request type for the
// ListWebsiteAuthorizationProviders API operation.
type ListWebsiteAuthorizationProvidersRequest struct {
	*aws.Request
	Input *ListWebsiteAuthorizationProvidersInput
	Copy  func(*ListWebsiteAuthorizationProvidersInput) ListWebsiteAuthorizationProvidersRequest
}

// Send marshals and sends the ListWebsiteAuthorizationProviders API request.
func (r ListWebsiteAuthorizationProvidersRequest) Send(ctx context.Context) (*ListWebsiteAuthorizationProvidersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListWebsiteAuthorizationProvidersResponse{
		ListWebsiteAuthorizationProvidersOutput: r.Request.Data.(*ListWebsiteAuthorizationProvidersOutput),
		response:                                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListWebsiteAuthorizationProvidersRequestPaginator returns a paginator for ListWebsiteAuthorizationProviders.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListWebsiteAuthorizationProvidersRequest(input)
//   p := worklink.NewListWebsiteAuthorizationProvidersRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListWebsiteAuthorizationProvidersPaginator(req ListWebsiteAuthorizationProvidersRequest) ListWebsiteAuthorizationProvidersPaginator {
	return ListWebsiteAuthorizationProvidersPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListWebsiteAuthorizationProvidersInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListWebsiteAuthorizationProvidersPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListWebsiteAuthorizationProvidersPaginator struct {
	aws.Pager
}

func (p *ListWebsiteAuthorizationProvidersPaginator) CurrentPage() *ListWebsiteAuthorizationProvidersOutput {
	return p.Pager.CurrentPage().(*ListWebsiteAuthorizationProvidersOutput)
}

// ListWebsiteAuthorizationProvidersResponse is the response type for the
// ListWebsiteAuthorizationProviders API operation.
type ListWebsiteAuthorizationProvidersResponse struct {
	*ListWebsiteAuthorizationProvidersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListWebsiteAuthorizationProviders request.
func (r *ListWebsiteAuthorizationProvidersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
