// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package wafv2

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateRuleGroupInput struct {
	_ struct{} `type:"structure"`

	// The web ACL capacity units (WCUs) required for this rule group.
	//
	// When you create your own rule group, you define this, and you cannot change
	// it after creation. When you add or modify the rules in a rule group, AWS
	// WAF enforces this limit. You can check the capacity for a set of rules using
	// CheckCapacity.
	//
	// AWS WAF uses WCUs to calculate and control the operating resources that are
	// used to run your rules, rule groups, and web ACLs. AWS WAF calculates capacity
	// differently for each rule type, to reflect the relative cost of each rule.
	// Simple rules that cost little to run use fewer WCUs than more complex rules
	// that use more processing power. Rule group capacity is fixed at creation,
	// which helps users plan their web ACL WCU usage when they use a rule group.
	// The WCU limit for web ACLs is 1,500.
	//
	// Capacity is a required field
	Capacity *int64 `min:"1" type:"long" required:"true"`

	// A description of the rule group that helps with identification. You cannot
	// change the description of a rule group after you create it.
	Description *string `min:"1" type:"string"`

	// The name of the rule group. You cannot change the name of a rule group after
	// you create it.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The Rule statements used to identify the web requests that you want to allow,
	// block, or count. Each rule includes one top-level statement that AWS WAF
	// uses to identify matching web requests, and parameters that govern how AWS
	// WAF handles them.
	Rules []Rule `type:"list"`

	// Specifies whether this is for an AWS CloudFront distribution or for a regional
	// application. A regional application can be an Application Load Balancer (ALB)
	// or an API Gateway stage.
	//
	// To work with CloudFront, you must also specify the Region US East (N. Virginia)
	// as follows:
	//
	//    * CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT
	//    --region=us-east-1.
	//
	//    * API and SDKs - For all calls, use the Region endpoint us-east-1.
	//
	// Scope is a required field
	Scope Scope `type:"string" required:"true" enum:"true"`

	// An array of key:value pairs to associate with the resource.
	Tags []Tag `min:"1" type:"list"`

	// Defines and enables Amazon CloudWatch metrics and web request sample collection.
	//
	// VisibilityConfig is a required field
	VisibilityConfig *VisibilityConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateRuleGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRuleGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateRuleGroupInput"}

	if s.Capacity == nil {
		invalidParams.Add(aws.NewErrParamRequired("Capacity"))
	}
	if s.Capacity != nil && *s.Capacity < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Capacity", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Description", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if len(s.Scope) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Scope"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Tags", 1))
	}

	if s.VisibilityConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("VisibilityConfig"))
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.VisibilityConfig != nil {
		if err := s.VisibilityConfig.Validate(); err != nil {
			invalidParams.AddNested("VisibilityConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateRuleGroupOutput struct {
	_ struct{} `type:"structure"`

	// High-level information about a RuleGroup, returned by operations like create
	// and list. This provides information like the ID, that you can use to retrieve
	// and manage a RuleGroup, and the ARN, that you provide to the RuleGroupReferenceStatement
	// to use the rule group in a Rule.
	Summary *RuleGroupSummary `type:"structure"`
}

// String returns the string representation
func (s CreateRuleGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateRuleGroup = "CreateRuleGroup"

// CreateRuleGroupRequest returns a request value for making API operation for
// AWS WAFV2.
//
//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// Creates a RuleGroup per the specifications provided.
//
// A rule group defines a collection of rules to inspect and control web requests
// that you can use in a WebACL. When you create a rule group, you define an
// immutable capacity limit. If you update a rule group, you must stay within
// the capacity. This allows others to reuse the rule group with confidence
// in its capacity requirements.
//
//    // Example sending a request using CreateRuleGroupRequest.
//    req := client.CreateRuleGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CreateRuleGroup
func (c *Client) CreateRuleGroupRequest(input *CreateRuleGroupInput) CreateRuleGroupRequest {
	op := &aws.Operation{
		Name:       opCreateRuleGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRuleGroupInput{}
	}

	req := c.newRequest(op, input, &CreateRuleGroupOutput{})

	return CreateRuleGroupRequest{Request: req, Input: input, Copy: c.CreateRuleGroupRequest}
}

// CreateRuleGroupRequest is the request type for the
// CreateRuleGroup API operation.
type CreateRuleGroupRequest struct {
	*aws.Request
	Input *CreateRuleGroupInput
	Copy  func(*CreateRuleGroupInput) CreateRuleGroupRequest
}

// Send marshals and sends the CreateRuleGroup API request.
func (r CreateRuleGroupRequest) Send(ctx context.Context) (*CreateRuleGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateRuleGroupResponse{
		CreateRuleGroupOutput: r.Request.Data.(*CreateRuleGroupOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateRuleGroupResponse is the response type for the
// CreateRuleGroup API operation.
type CreateRuleGroupResponse struct {
	*CreateRuleGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateRuleGroup request.
func (r *CreateRuleGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
