// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package waf

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// A request to delete an XssMatchSet from AWS WAF.
type DeleteXssMatchSetInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`

	// The XssMatchSetId of the XssMatchSet that you want to delete. XssMatchSetId
	// is returned by CreateXssMatchSet and by ListXssMatchSets.
	//
	// XssMatchSetId is a required field
	XssMatchSetId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteXssMatchSetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteXssMatchSetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteXssMatchSetInput"}

	if s.ChangeToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ChangeToken", 1))
	}

	if s.XssMatchSetId == nil {
		invalidParams.Add(aws.NewErrParamRequired("XssMatchSetId"))
	}
	if s.XssMatchSetId != nil && len(*s.XssMatchSetId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("XssMatchSetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The response to a request to delete an XssMatchSet from AWS WAF.
type DeleteXssMatchSetOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the DeleteXssMatchSet request. You
	// can also use this value to query the status of the request. For more information,
	// see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteXssMatchSetOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteXssMatchSet = "DeleteXssMatchSet"

// DeleteXssMatchSetRequest returns a request value for making API operation for
// AWS WAF.
//
//
// This is AWS WAF Classic documentation. For more information, see AWS WAF
// Classic (https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
// in the developer guide.
//
// For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
// WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
// With the latest version, AWS WAF has a single set of endpoints for regional
// and global use.
//
// Permanently deletes an XssMatchSet. You can't delete an XssMatchSet if it's
// still used in any Rules or if it still contains any XssMatchTuple objects.
//
// If you just want to remove an XssMatchSet from a Rule, use UpdateRule.
//
// To permanently delete an XssMatchSet from AWS WAF, perform the following
// steps:
//
// Update the XssMatchSet to remove filters, if any. For more information, see
// UpdateXssMatchSet.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a DeleteXssMatchSet request.
//
// Submit a DeleteXssMatchSet request.
//
//    // Example sending a request using DeleteXssMatchSetRequest.
//    req := client.DeleteXssMatchSetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/DeleteXssMatchSet
func (c *Client) DeleteXssMatchSetRequest(input *DeleteXssMatchSetInput) DeleteXssMatchSetRequest {
	op := &aws.Operation{
		Name:       opDeleteXssMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteXssMatchSetInput{}
	}

	req := c.newRequest(op, input, &DeleteXssMatchSetOutput{})

	return DeleteXssMatchSetRequest{Request: req, Input: input, Copy: c.DeleteXssMatchSetRequest}
}

// DeleteXssMatchSetRequest is the request type for the
// DeleteXssMatchSet API operation.
type DeleteXssMatchSetRequest struct {
	*aws.Request
	Input *DeleteXssMatchSetInput
	Copy  func(*DeleteXssMatchSetInput) DeleteXssMatchSetRequest
}

// Send marshals and sends the DeleteXssMatchSet API request.
func (r DeleteXssMatchSetRequest) Send(ctx context.Context) (*DeleteXssMatchSetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteXssMatchSetResponse{
		DeleteXssMatchSetOutput: r.Request.Data.(*DeleteXssMatchSetOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteXssMatchSetResponse is the response type for the
// DeleteXssMatchSet API operation.
type DeleteXssMatchSetResponse struct {
	*DeleteXssMatchSetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteXssMatchSet request.
func (r *DeleteXssMatchSetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
