// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package transcribe

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetVocabularyFilterInput struct {
	_ struct{} `type:"structure"`

	// The name of the vocabulary filter for which to return information.
	//
	// VocabularyFilterName is a required field
	VocabularyFilterName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetVocabularyFilterInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVocabularyFilterInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetVocabularyFilterInput"}

	if s.VocabularyFilterName == nil {
		invalidParams.Add(aws.NewErrParamRequired("VocabularyFilterName"))
	}
	if s.VocabularyFilterName != nil && len(*s.VocabularyFilterName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VocabularyFilterName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetVocabularyFilterOutput struct {
	_ struct{} `type:"structure"`

	// The URI of the list of words in the vocabulary filter. You can use this URI
	// to get the list of words.
	DownloadUri *string `min:"1" type:"string"`

	// The language code of the words in the vocabulary filter.
	LanguageCode LanguageCode `type:"string" enum:"true"`

	// The date and time that the contents of the vocabulary filter were updated.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the vocabulary filter.
	VocabularyFilterName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetVocabularyFilterOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetVocabularyFilter = "GetVocabularyFilter"

// GetVocabularyFilterRequest returns a request value for making API operation for
// Amazon Transcribe Service.
//
// Returns information about a vocabulary filter.
//
//    // Example sending a request using GetVocabularyFilterRequest.
//    req := client.GetVocabularyFilterRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetVocabularyFilter
func (c *Client) GetVocabularyFilterRequest(input *GetVocabularyFilterInput) GetVocabularyFilterRequest {
	op := &aws.Operation{
		Name:       opGetVocabularyFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetVocabularyFilterInput{}
	}

	req := c.newRequest(op, input, &GetVocabularyFilterOutput{})

	return GetVocabularyFilterRequest{Request: req, Input: input, Copy: c.GetVocabularyFilterRequest}
}

// GetVocabularyFilterRequest is the request type for the
// GetVocabularyFilter API operation.
type GetVocabularyFilterRequest struct {
	*aws.Request
	Input *GetVocabularyFilterInput
	Copy  func(*GetVocabularyFilterInput) GetVocabularyFilterRequest
}

// Send marshals and sends the GetVocabularyFilter API request.
func (r GetVocabularyFilterRequest) Send(ctx context.Context) (*GetVocabularyFilterResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetVocabularyFilterResponse{
		GetVocabularyFilterOutput: r.Request.Data.(*GetVocabularyFilterOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetVocabularyFilterResponse is the response type for the
// GetVocabularyFilter API operation.
type GetVocabularyFilterResponse struct {
	*GetVocabularyFilterOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetVocabularyFilter request.
func (r *GetVocabularyFilterResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
