// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package transcribe

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetMedicalVocabularyInput struct {
	_ struct{} `type:"structure"`

	// The name of the vocabulary you are trying to get information about. The value
	// you enter for this request is case-sensitive.
	//
	// VocabularyName is a required field
	VocabularyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetMedicalVocabularyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMedicalVocabularyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetMedicalVocabularyInput"}

	if s.VocabularyName == nil {
		invalidParams.Add(aws.NewErrParamRequired("VocabularyName"))
	}
	if s.VocabularyName != nil && len(*s.VocabularyName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VocabularyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetMedicalVocabularyOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 location where the vocabulary is stored. Use this URI to get
	// the contents of the vocabulary. You can download your vocabulary from the
	// URI for a limited time.
	DownloadUri *string `min:"1" type:"string"`

	// If the VocabularyState is FAILED, this field contains information about why
	// the job failed.
	FailureReason *string `type:"string"`

	// The valid language code returned for your vocabulary entries.
	LanguageCode LanguageCode `type:"string" enum:"true"`

	// The date and time the vocabulary was last modified with a text file different
	// from what was previously used.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The valid name that Amazon Transcribe Medical returns.
	VocabularyName *string `min:"1" type:"string"`

	// The processing state of the vocabulary.
	VocabularyState VocabularyState `type:"string" enum:"true"`
}

// String returns the string representation
func (s GetMedicalVocabularyOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetMedicalVocabulary = "GetMedicalVocabulary"

// GetMedicalVocabularyRequest returns a request value for making API operation for
// Amazon Transcribe Service.
//
// Retrieve information about a medical vocabulary.
//
//    // Example sending a request using GetMedicalVocabularyRequest.
//    req := client.GetMedicalVocabularyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetMedicalVocabulary
func (c *Client) GetMedicalVocabularyRequest(input *GetMedicalVocabularyInput) GetMedicalVocabularyRequest {
	op := &aws.Operation{
		Name:       opGetMedicalVocabulary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetMedicalVocabularyInput{}
	}

	req := c.newRequest(op, input, &GetMedicalVocabularyOutput{})

	return GetMedicalVocabularyRequest{Request: req, Input: input, Copy: c.GetMedicalVocabularyRequest}
}

// GetMedicalVocabularyRequest is the request type for the
// GetMedicalVocabulary API operation.
type GetMedicalVocabularyRequest struct {
	*aws.Request
	Input *GetMedicalVocabularyInput
	Copy  func(*GetMedicalVocabularyInput) GetMedicalVocabularyRequest
}

// Send marshals and sends the GetMedicalVocabulary API request.
func (r GetMedicalVocabularyRequest) Send(ctx context.Context) (*GetMedicalVocabularyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetMedicalVocabularyResponse{
		GetMedicalVocabularyOutput: r.Request.Data.(*GetMedicalVocabularyOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetMedicalVocabularyResponse is the response type for the
// GetMedicalVocabulary API operation.
type GetMedicalVocabularyResponse struct {
	*GetMedicalVocabularyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetMedicalVocabulary request.
func (r *GetMedicalVocabularyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
