// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package swf

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type RequestCancelWorkflowExecutionInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain containing the workflow execution to cancel.
	//
	// Domain is a required field
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// The runId of the workflow execution to cancel.
	RunId *string `locationName:"runId" type:"string"`

	// The workflowId of the workflow execution to cancel.
	//
	// WorkflowId is a required field
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RequestCancelWorkflowExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RequestCancelWorkflowExecutionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RequestCancelWorkflowExecutionInput"}

	if s.Domain == nil {
		invalidParams.Add(aws.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Domain", 1))
	}

	if s.WorkflowId == nil {
		invalidParams.Add(aws.NewErrParamRequired("WorkflowId"))
	}
	if s.WorkflowId != nil && len(*s.WorkflowId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("WorkflowId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RequestCancelWorkflowExecutionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RequestCancelWorkflowExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

const opRequestCancelWorkflowExecution = "RequestCancelWorkflowExecution"

// RequestCancelWorkflowExecutionRequest returns a request value for making API operation for
// Amazon Simple Workflow Service.
//
// Records a WorkflowExecutionCancelRequested event in the currently running
// workflow execution identified by the given domain, workflowId, and runId.
// This logically requests the cancellation of the workflow execution as a whole.
// It is up to the decider to take appropriate actions when it receives an execution
// history with this event.
//
// If the runId isn't specified, the WorkflowExecutionCancelRequested event
// is recorded in the history of the current open workflow execution with the
// specified workflowId in the domain.
//
// Because this action allows the workflow to properly clean up and gracefully
// close, it should be used instead of TerminateWorkflowExecution when possible.
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * You cannot use an IAM policy to constrain this action's parameters.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
//
//    // Example sending a request using RequestCancelWorkflowExecutionRequest.
//    req := client.RequestCancelWorkflowExecutionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) RequestCancelWorkflowExecutionRequest(input *RequestCancelWorkflowExecutionInput) RequestCancelWorkflowExecutionRequest {
	op := &aws.Operation{
		Name:       opRequestCancelWorkflowExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RequestCancelWorkflowExecutionInput{}
	}

	req := c.newRequest(op, input, &RequestCancelWorkflowExecutionOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return RequestCancelWorkflowExecutionRequest{Request: req, Input: input, Copy: c.RequestCancelWorkflowExecutionRequest}
}

// RequestCancelWorkflowExecutionRequest is the request type for the
// RequestCancelWorkflowExecution API operation.
type RequestCancelWorkflowExecutionRequest struct {
	*aws.Request
	Input *RequestCancelWorkflowExecutionInput
	Copy  func(*RequestCancelWorkflowExecutionInput) RequestCancelWorkflowExecutionRequest
}

// Send marshals and sends the RequestCancelWorkflowExecution API request.
func (r RequestCancelWorkflowExecutionRequest) Send(ctx context.Context) (*RequestCancelWorkflowExecutionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RequestCancelWorkflowExecutionResponse{
		RequestCancelWorkflowExecutionOutput: r.Request.Data.(*RequestCancelWorkflowExecutionOutput),
		response:                             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RequestCancelWorkflowExecutionResponse is the response type for the
// RequestCancelWorkflowExecution API operation.
type RequestCancelWorkflowExecutionResponse struct {
	*RequestCancelWorkflowExecutionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RequestCancelWorkflowExecution request.
func (r *RequestCancelWorkflowExecutionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
