// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package storagegateway

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// CreateTapesInput
type CreateTapesInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier that you use to retry a request. If you retry a request,
	// use the same ClientToken you specified in the initial request.
	//
	// Using the same ClientToken prevents creating the tape multiple times.
	//
	// ClientToken is a required field
	ClientToken *string `min:"5" type:"string" required:"true"`

	// The unique Amazon Resource Name (ARN) that represents the gateway to associate
	// the virtual tapes with. Use the ListGateways operation to return a list of
	// gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// Set to true to use Amazon S3 server-side encryption with your own AWS KMS
	// key, or false to use a key managed by Amazon S3. Optional.
	//
	// Valid Values: true | false
	KMSEncrypted *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used
	// for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric
	// CMKs. This value can only be set when KMSEncrypted is true. Optional.
	KMSKey *string `min:"7" type:"string"`

	// The number of virtual tapes that you want to create.
	//
	// NumTapesToCreate is a required field
	NumTapesToCreate *int64 `min:"1" type:"integer" required:"true"`

	// The ID of the pool that you want to add your tape to for archiving. The tape
	// in this pool is archived in the S3 storage class that is associated with
	// the pool. When you use your backup application to eject the tape, the tape
	// is archived directly into the storage class (S3 Glacier or S3 Glacier Deep
	// Archive) that corresponds to the pool.
	//
	// Valid Values: GLACIER | DEEP_ARCHIVE
	PoolId *string `min:"1" type:"string"`

	// A list of up to 50 tags that can be assigned to a virtual tape. Each tag
	// is a key-value pair.
	//
	// Valid characters for key and value are letters, spaces, and numbers representable
	// in UTF-8 format, and the following special characters: + - = . _ : / @. The
	// maximum length of a tag's key is 128 characters, and the maximum length for
	// a tag's value is 256.
	Tags []Tag `type:"list"`

	// A prefix that you append to the barcode of the virtual tape you are creating.
	// This prefix makes the barcode unique.
	//
	// The prefix must be 1 to 4 characters in length and must be one of the uppercase
	// letters from A to Z.
	//
	// TapeBarcodePrefix is a required field
	TapeBarcodePrefix *string `min:"1" type:"string" required:"true"`

	// The size, in bytes, of the virtual tapes that you want to create.
	//
	// The size must be aligned by gigabyte (1024*1024*1024 bytes).
	//
	// TapeSizeInBytes is a required field
	TapeSizeInBytes *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s CreateTapesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTapesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateTapesInput"}

	if s.ClientToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClientToken"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 5 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientToken", 5))
	}

	if s.GatewayARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(aws.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.KMSKey != nil && len(*s.KMSKey) < 7 {
		invalidParams.Add(aws.NewErrParamMinLen("KMSKey", 7))
	}

	if s.NumTapesToCreate == nil {
		invalidParams.Add(aws.NewErrParamRequired("NumTapesToCreate"))
	}
	if s.NumTapesToCreate != nil && *s.NumTapesToCreate < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("NumTapesToCreate", 1))
	}
	if s.PoolId != nil && len(*s.PoolId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PoolId", 1))
	}

	if s.TapeBarcodePrefix == nil {
		invalidParams.Add(aws.NewErrParamRequired("TapeBarcodePrefix"))
	}
	if s.TapeBarcodePrefix != nil && len(*s.TapeBarcodePrefix) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TapeBarcodePrefix", 1))
	}

	if s.TapeSizeInBytes == nil {
		invalidParams.Add(aws.NewErrParamRequired("TapeSizeInBytes"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// CreateTapeOutput
type CreateTapesOutput struct {
	_ struct{} `type:"structure"`

	// A list of unique Amazon Resource Names (ARNs) that represents the virtual
	// tapes that were created.
	TapeARNs []string `type:"list"`
}

// String returns the string representation
func (s CreateTapesOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateTapes = "CreateTapes"

// CreateTapesRequest returns a request value for making API operation for
// AWS Storage Gateway.
//
// Creates one or more virtual tapes. You write data to the virtual tapes and
// then archive the tapes. This operation is only supported in the tape gateway
// type.
//
// Cache storage must be allocated to the gateway before you can create virtual
// tapes. Use the AddCache operation to add cache storage to a gateway.
//
//    // Example sending a request using CreateTapesRequest.
//    req := client.CreateTapesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateTapes
func (c *Client) CreateTapesRequest(input *CreateTapesInput) CreateTapesRequest {
	op := &aws.Operation{
		Name:       opCreateTapes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTapesInput{}
	}

	req := c.newRequest(op, input, &CreateTapesOutput{})

	return CreateTapesRequest{Request: req, Input: input, Copy: c.CreateTapesRequest}
}

// CreateTapesRequest is the request type for the
// CreateTapes API operation.
type CreateTapesRequest struct {
	*aws.Request
	Input *CreateTapesInput
	Copy  func(*CreateTapesInput) CreateTapesRequest
}

// Send marshals and sends the CreateTapes API request.
func (r CreateTapesRequest) Send(ctx context.Context) (*CreateTapesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateTapesResponse{
		CreateTapesOutput: r.Request.Data.(*CreateTapesOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateTapesResponse is the response type for the
// CreateTapes API operation.
type CreateTapesResponse struct {
	*CreateTapesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateTapes request.
func (r *CreateTapesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
