// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssm

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// Information includes the AWS account ID where the current document is shared
// and the version shared with that account.
type AccountSharingInfo struct {
	_ struct{} `type:"structure"`

	// The AWS account ID where the current document is shared.
	AccountId *string `type:"string"`

	// The version of the current document shared with the account.
	SharedDocumentVersion *string `type:"string"`
}

// String returns the string representation
func (s AccountSharingInfo) String() string {
	return awsutil.Prettify(s)
}

// An activation registers one or more on-premises servers or virtual machines
// (VMs) with AWS so that you can configure those servers or VMs using Run Command.
// A server or VM that has been registered with AWS is called a managed instance.
type Activation struct {
	_ struct{} `type:"structure"`

	// The ID created by Systems Manager when you submitted the activation.
	ActivationId *string `type:"string"`

	// The date the activation was created.
	CreatedDate *time.Time `type:"timestamp"`

	// A name for the managed instance when it is created.
	DefaultInstanceName *string `type:"string"`

	// A user defined description of the activation.
	Description *string `type:"string"`

	// The date when this activation can no longer be used to register managed instances.
	ExpirationDate *time.Time `type:"timestamp"`

	// Whether or not the activation is expired.
	Expired *bool `type:"boolean"`

	// The Amazon Identity and Access Management (IAM) role to assign to the managed
	// instance.
	IamRole *string `type:"string"`

	// The maximum number of managed instances that can be registered using this
	// activation.
	RegistrationLimit *int64 `min:"1" type:"integer"`

	// The number of managed instances already registered with this activation.
	RegistrationsCount *int64 `min:"1" type:"integer"`

	// Tags assigned to the activation.
	Tags []Tag `type:"list"`
}

// String returns the string representation
func (s Activation) String() string {
	return awsutil.Prettify(s)
}

// Describes an association of a Systems Manager document and an instance.
type Association struct {
	_ struct{} `type:"structure"`

	// The ID created by the system when you create an association. An association
	// is a binding between a document and a set of targets with a schedule.
	AssociationId *string `type:"string"`

	// The association name.
	AssociationName *string `type:"string"`

	// The association version.
	AssociationVersion *string `type:"string"`

	// The version of the document used in the association.
	DocumentVersion *string `type:"string"`

	// The ID of the instance.
	InstanceId *string `type:"string"`

	// The date on which the association was last run.
	LastExecutionDate *time.Time `type:"timestamp"`

	// The name of the Systems Manager document.
	Name *string `type:"string"`

	// Information about the association.
	Overview *AssociationOverview `type:"structure"`

	// A cron expression that specifies a schedule when the association runs.
	ScheduleExpression *string `min:"1" type:"string"`

	// The instances targeted by the request to create an association.
	Targets []Target `type:"list"`
}

// String returns the string representation
func (s Association) String() string {
	return awsutil.Prettify(s)
}

// Describes the parameters for a document.
type AssociationDescription struct {
	_ struct{} `type:"structure"`

	// By default, when you create a new associations, the system runs it immediately
	// after it is created and then according to the schedule you specified. Specify
	// this option if you don't want an association to run immediately after you
	// create it.
	ApplyOnlyAtCronInterval *bool `type:"boolean"`

	// The association ID.
	AssociationId *string `type:"string"`

	// The association name.
	AssociationName *string `type:"string"`

	// The association version.
	AssociationVersion *string `type:"string"`

	// Specify the target for the association. This target is required for associations
	// that use an Automation document and target resources by using rate controls.
	AutomationTargetParameterName *string `min:"1" type:"string"`

	// The severity level that is assigned to the association.
	ComplianceSeverity AssociationComplianceSeverity `type:"string" enum:"true"`

	// The date when the association was made.
	Date *time.Time `type:"timestamp"`

	// The document version.
	DocumentVersion *string `type:"string"`

	// The ID of the instance.
	InstanceId *string `type:"string"`

	// The date on which the association was last run.
	LastExecutionDate *time.Time `type:"timestamp"`

	// The last date on which the association was successfully run.
	LastSuccessfulExecutionDate *time.Time `type:"timestamp"`

	// The date when the association was last updated.
	LastUpdateAssociationDate *time.Time `type:"timestamp"`

	// The maximum number of targets allowed to run the association at the same
	// time. You can specify a number, for example 10, or a percentage of the target
	// set, for example 10%. The default value is 100%, which means all targets
	// run the association at the same time.
	//
	// If a new instance starts and attempts to run an association while Systems
	// Manager is running MaxConcurrency associations, the association is allowed
	// to run. During the next association interval, the new instance will process
	// its association within the limit specified for MaxConcurrency.
	MaxConcurrency *string `min:"1" type:"string"`

	// The number of errors that are allowed before the system stops sending requests
	// to run the association on additional targets. You can specify either an absolute
	// number of errors, for example 10, or a percentage of the target set, for
	// example 10%. If you specify 3, for example, the system stops sending requests
	// when the fourth error is received. If you specify 0, then the system stops
	// sending requests after the first error is returned. If you run an association
	// on 50 instances and set MaxError to 10%, then the system stops sending the
	// request when the sixth error is received.
	//
	// Executions that are already running an association when MaxErrors is reached
	// are allowed to complete, but some of these executions may fail as well. If
	// you need to ensure that there won't be more than max-errors failed executions,
	// set MaxConcurrency to 1 so that executions proceed one at a time.
	MaxErrors *string `min:"1" type:"string"`

	// The name of the Systems Manager document.
	Name *string `type:"string"`

	// An S3 bucket where you want to store the output details of the request.
	OutputLocation *InstanceAssociationOutputLocation `type:"structure"`

	// Information about the association.
	Overview *AssociationOverview `type:"structure"`

	// A description of the parameters for a document.
	Parameters map[string][]string `type:"map"`

	// A cron expression that specifies a schedule when the association runs.
	ScheduleExpression *string `min:"1" type:"string"`

	// The association status.
	Status *AssociationStatus `type:"structure"`

	// The mode for generating association compliance. You can specify AUTO or MANUAL.
	// In AUTO mode, the system uses the status of the association execution to
	// determine the compliance status. If the association execution runs successfully,
	// then the association is COMPLIANT. If the association execution doesn't run
	// successfully, the association is NON-COMPLIANT.
	//
	// In MANUAL mode, you must specify the AssociationId as a parameter for the
	// PutComplianceItems API action. In this case, compliance data is not managed
	// by State Manager. It is managed by your direct call to the PutComplianceItems
	// API action.
	//
	// By default, all associations use AUTO mode.
	SyncCompliance AssociationSyncCompliance `type:"string" enum:"true"`

	// The instances targeted by the request.
	Targets []Target `type:"list"`
}

// String returns the string representation
func (s AssociationDescription) String() string {
	return awsutil.Prettify(s)
}

// Includes information about the specified association.
type AssociationExecution struct {
	_ struct{} `type:"structure"`

	// The association ID.
	AssociationId *string `type:"string"`

	// The association version.
	AssociationVersion *string `type:"string"`

	// The time the execution started.
	CreatedTime *time.Time `type:"timestamp"`

	// Detailed status information about the execution.
	DetailedStatus *string `type:"string"`

	// The execution ID for the association.
	ExecutionId *string `type:"string"`

	// The date of the last execution.
	LastExecutionDate *time.Time `type:"timestamp"`

	// An aggregate status of the resources in the execution based on the status
	// type.
	ResourceCountByStatus *string `type:"string"`

	// The status of the association execution.
	Status *string `type:"string"`
}

// String returns the string representation
func (s AssociationExecution) String() string {
	return awsutil.Prettify(s)
}

// Filters used in the request.
type AssociationExecutionFilter struct {
	_ struct{} `type:"structure"`

	// The key value used in the request.
	//
	// Key is a required field
	Key AssociationExecutionFilterKey `type:"string" required:"true" enum:"true"`

	// The filter type specified in the request.
	//
	// Type is a required field
	Type AssociationFilterOperatorType `type:"string" required:"true" enum:"true"`

	// The value specified for the key.
	//
	// Value is a required field
	Value *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociationExecutionFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociationExecutionFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AssociationExecutionFilter"}
	if len(s.Key) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Includes information about the specified association execution.
type AssociationExecutionTarget struct {
	_ struct{} `type:"structure"`

	// The association ID.
	AssociationId *string `type:"string"`

	// The association version.
	AssociationVersion *string `type:"string"`

	// Detailed information about the execution status.
	DetailedStatus *string `type:"string"`

	// The execution ID.
	ExecutionId *string `type:"string"`

	// The date of the last execution.
	LastExecutionDate *time.Time `type:"timestamp"`

	// The location where the association details are saved.
	OutputSource *OutputSource `type:"structure"`

	// The resource ID, for example, the instance ID where the association ran.
	ResourceId *string `min:"1" type:"string"`

	// The resource type, for example, instance.
	ResourceType *string `min:"1" type:"string"`

	// The association execution status.
	Status *string `type:"string"`
}

// String returns the string representation
func (s AssociationExecutionTarget) String() string {
	return awsutil.Prettify(s)
}

// Filters for the association execution.
type AssociationExecutionTargetsFilter struct {
	_ struct{} `type:"structure"`

	// The key value used in the request.
	//
	// Key is a required field
	Key AssociationExecutionTargetsFilterKey `type:"string" required:"true" enum:"true"`

	// The value specified for the key.
	//
	// Value is a required field
	Value *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociationExecutionTargetsFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociationExecutionTargetsFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AssociationExecutionTargetsFilter"}
	if len(s.Key) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes a filter.
type AssociationFilter struct {
	_ struct{} `type:"structure"`

	// The name of the filter.
	//
	// Key is a required field
	Key AssociationFilterKey `locationName:"key" type:"string" required:"true" enum:"true"`

	// The filter value.
	//
	// Value is a required field
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociationFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociationFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AssociationFilter"}
	if len(s.Key) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about the association.
type AssociationOverview struct {
	_ struct{} `type:"structure"`

	// Returns the number of targets for the association status. For example, if
	// you created an association with two instances, and one of them was successful,
	// this would return the count of instances by status.
	AssociationStatusAggregatedCount map[string]int64 `type:"map"`

	// A detailed status of the association.
	DetailedStatus *string `type:"string"`

	// The status of the association. Status can be: Pending, Success, or Failed.
	Status *string `type:"string"`
}

// String returns the string representation
func (s AssociationOverview) String() string {
	return awsutil.Prettify(s)
}

// Describes an association status.
type AssociationStatus struct {
	_ struct{} `type:"structure"`

	// A user-defined string.
	AdditionalInfo *string `type:"string"`

	// The date when the status changed.
	//
	// Date is a required field
	Date *time.Time `type:"timestamp" required:"true"`

	// The reason for the status.
	//
	// Message is a required field
	Message *string `min:"1" type:"string" required:"true"`

	// The status.
	//
	// Name is a required field
	Name AssociationStatusName `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s AssociationStatus) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociationStatus) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AssociationStatus"}

	if s.Date == nil {
		invalidParams.Add(aws.NewErrParamRequired("Date"))
	}

	if s.Message == nil {
		invalidParams.Add(aws.NewErrParamRequired("Message"))
	}
	if s.Message != nil && len(*s.Message) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Message", 1))
	}
	if len(s.Name) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about the association version.
type AssociationVersionInfo struct {
	_ struct{} `type:"structure"`

	// By default, when you create a new associations, the system runs it immediately
	// after it is created and then according to the schedule you specified. Specify
	// this option if you don't want an association to run immediately after you
	// create it.
	ApplyOnlyAtCronInterval *bool `type:"boolean"`

	// The ID created by the system when the association was created.
	AssociationId *string `type:"string"`

	// The name specified for the association version when the association version
	// was created.
	AssociationName *string `type:"string"`

	// The association version.
	AssociationVersion *string `type:"string"`

	// The severity level that is assigned to the association.
	ComplianceSeverity AssociationComplianceSeverity `type:"string" enum:"true"`

	// The date the association version was created.
	CreatedDate *time.Time `type:"timestamp"`

	// The version of a Systems Manager document used when the association version
	// was created.
	DocumentVersion *string `type:"string"`

	// The maximum number of targets allowed to run the association at the same
	// time. You can specify a number, for example 10, or a percentage of the target
	// set, for example 10%. The default value is 100%, which means all targets
	// run the association at the same time.
	//
	// If a new instance starts and attempts to run an association while Systems
	// Manager is running MaxConcurrency associations, the association is allowed
	// to run. During the next association interval, the new instance will process
	// its association within the limit specified for MaxConcurrency.
	MaxConcurrency *string `min:"1" type:"string"`

	// The number of errors that are allowed before the system stops sending requests
	// to run the association on additional targets. You can specify either an absolute
	// number of errors, for example 10, or a percentage of the target set, for
	// example 10%. If you specify 3, for example, the system stops sending requests
	// when the fourth error is received. If you specify 0, then the system stops
	// sending requests after the first error is returned. If you run an association
	// on 50 instances and set MaxError to 10%, then the system stops sending the
	// request when the sixth error is received.
	//
	// Executions that are already running an association when MaxErrors is reached
	// are allowed to complete, but some of these executions may fail as well. If
	// you need to ensure that there won't be more than max-errors failed executions,
	// set MaxConcurrency to 1 so that executions proceed one at a time.
	MaxErrors *string `min:"1" type:"string"`

	// The name specified when the association was created.
	Name *string `type:"string"`

	// The location in Amazon S3 specified for the association when the association
	// version was created.
	OutputLocation *InstanceAssociationOutputLocation `type:"structure"`

	// Parameters specified when the association version was created.
	Parameters map[string][]string `type:"map"`

	// The cron or rate schedule specified for the association when the association
	// version was created.
	ScheduleExpression *string `min:"1" type:"string"`

	// The mode for generating association compliance. You can specify AUTO or MANUAL.
	// In AUTO mode, the system uses the status of the association execution to
	// determine the compliance status. If the association execution runs successfully,
	// then the association is COMPLIANT. If the association execution doesn't run
	// successfully, the association is NON-COMPLIANT.
	//
	// In MANUAL mode, you must specify the AssociationId as a parameter for the
	// PutComplianceItems API action. In this case, compliance data is not managed
	// by State Manager. It is managed by your direct call to the PutComplianceItems
	// API action.
	//
	// By default, all associations use AUTO mode.
	SyncCompliance AssociationSyncCompliance `type:"string" enum:"true"`

	// The targets specified for the association when the association version was
	// created.
	Targets []Target `type:"list"`
}

// String returns the string representation
func (s AssociationVersionInfo) String() string {
	return awsutil.Prettify(s)
}

// A structure that includes attributes that describe a document attachment.
type AttachmentContent struct {
	_ struct{} `type:"structure"`

	// The cryptographic hash value of the document content.
	Hash *string `type:"string"`

	// The hash algorithm used to calculate the hash value.
	HashType AttachmentHashType `type:"string" enum:"true"`

	// The name of an attachment.
	Name *string `type:"string"`

	// The size of an attachment in bytes.
	Size *int64 `type:"long"`

	// The URL location of the attachment content.
	Url *string `type:"string"`
}

// String returns the string representation
func (s AttachmentContent) String() string {
	return awsutil.Prettify(s)
}

// An attribute of an attachment, such as the attachment name.
type AttachmentInformation struct {
	_ struct{} `type:"structure"`

	// The name of the attachment.
	Name *string `type:"string"`
}

// String returns the string representation
func (s AttachmentInformation) String() string {
	return awsutil.Prettify(s)
}

// Identifying information about a document attachment, including the file name
// and a key-value pair that identifies the location of an attachment to a document.
type AttachmentsSource struct {
	_ struct{} `type:"structure"`

	// The key of a key-value pair that identifies the location of an attachment
	// to a document.
	Key AttachmentsSourceKey `type:"string" enum:"true"`

	// The name of the document attachment file.
	Name *string `type:"string"`

	// The value of a key-value pair that identifies the location of an attachment
	// to a document. The format for Value depends on the type of key you specify.
	//
	//    * For the key SourceUrl, the value is an S3 bucket location. For example:
	//    "Values": [ "s3://my-bucket/my-folder" ]
	//
	//    * For the key S3FileUrl, the value is a file in an S3 bucket. For example:
	//    "Values": [ "s3://my-bucket/my-folder/my-file.py" ]
	//
	//    * For the key AttachmentReference, the value is constructed from the name
	//    of another SSM document in your account, a version number of that document,
	//    and a file attached to that document version that you want to reuse. For
	//    example: "Values": [ "MyOtherDocument/3/my-other-file.py" ] However, if
	//    the SSM document is shared with you from another account, the full SSM
	//    document ARN must be specified instead of the document name only. For
	//    example: "Values": [ "arn:aws:ssm:us-east-2:111122223333:document/OtherAccountDocument/3/their-file.py"
	//    ]
	Values []string `min:"1" type:"list"`
}

// String returns the string representation
func (s AttachmentsSource) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachmentsSource) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AttachmentsSource"}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Detailed information about the current state of an individual Automation
// execution.
type AutomationExecution struct {
	_ struct{} `type:"structure"`

	// The execution ID.
	AutomationExecutionId *string `min:"36" type:"string"`

	// The execution status of the Automation.
	AutomationExecutionStatus AutomationExecutionStatus `type:"string" enum:"true"`

	// The action of the step that is currently running.
	CurrentAction *string `type:"string"`

	// The name of the step that is currently running.
	CurrentStepName *string `type:"string"`

	// The name of the Automation document used during the execution.
	DocumentName *string `type:"string"`

	// The version of the document to use during execution.
	DocumentVersion *string `type:"string"`

	// The Amazon Resource Name (ARN) of the user who ran the automation.
	ExecutedBy *string `type:"string"`

	// The time the execution finished.
	ExecutionEndTime *time.Time `type:"timestamp"`

	// The time the execution started.
	ExecutionStartTime *time.Time `type:"timestamp"`

	// A message describing why an execution has failed, if the status is set to
	// Failed.
	FailureMessage *string `type:"string"`

	// The MaxConcurrency value specified by the user when the execution started.
	MaxConcurrency *string `min:"1" type:"string"`

	// The MaxErrors value specified by the user when the execution started.
	MaxErrors *string `min:"1" type:"string"`

	// The automation execution mode.
	Mode ExecutionMode `type:"string" enum:"true"`

	// The list of execution outputs as defined in the automation document.
	Outputs map[string][]string `min:"1" type:"map"`

	// The key-value map of execution parameters, which were supplied when calling
	// StartAutomationExecution.
	Parameters map[string][]string `min:"1" type:"map"`

	// The AutomationExecutionId of the parent automation.
	ParentAutomationExecutionId *string `min:"36" type:"string"`

	// An aggregate of step execution statuses displayed in the AWS Console for
	// a multi-Region and multi-account Automation execution.
	ProgressCounters *ProgressCounters `type:"structure"`

	// A list of resolved targets in the rate control execution.
	ResolvedTargets *ResolvedTargets `type:"structure"`

	// A list of details about the current state of all steps that comprise an execution.
	// An Automation document contains a list of steps that are run in order.
	StepExecutions []StepExecution `type:"list"`

	// A boolean value that indicates if the response contains the full list of
	// the Automation step executions. If true, use the DescribeAutomationStepExecutions
	// API action to get the full list of step executions.
	StepExecutionsTruncated *bool `type:"boolean"`

	// The target of the execution.
	Target *string `type:"string"`

	// The combination of AWS Regions and/or AWS accounts where you want to run
	// the Automation.
	TargetLocations []TargetLocation `min:"1" type:"list"`

	// The specified key-value mapping of document parameters to target resources.
	TargetMaps []map[string][]string `type:"list"`

	// The parameter name.
	TargetParameterName *string `min:"1" type:"string"`

	// The specified targets.
	Targets []Target `type:"list"`
}

// String returns the string representation
func (s AutomationExecution) String() string {
	return awsutil.Prettify(s)
}

// A filter used to match specific automation executions. This is used to limit
// the scope of Automation execution information returned.
type AutomationExecutionFilter struct {
	_ struct{} `type:"structure"`

	// One or more keys to limit the results. Valid filter keys include the following:
	// DocumentNamePrefix, ExecutionStatus, ExecutionId, ParentExecutionId, CurrentAction,
	// StartTimeBefore, StartTimeAfter.
	//
	// Key is a required field
	Key AutomationExecutionFilterKey `type:"string" required:"true" enum:"true"`

	// The values used to limit the execution information associated with the filter's
	// key.
	//
	// Values is a required field
	Values []string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s AutomationExecutionFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutomationExecutionFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AutomationExecutionFilter"}
	if len(s.Key) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}

	if s.Values == nil {
		invalidParams.Add(aws.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Details about a specific Automation execution.
type AutomationExecutionMetadata struct {
	_ struct{} `type:"structure"`

	// The execution ID.
	AutomationExecutionId *string `min:"36" type:"string"`

	// The status of the execution.
	AutomationExecutionStatus AutomationExecutionStatus `type:"string" enum:"true"`

	// Use this filter with DescribeAutomationExecutions. Specify either Local or
	// CrossAccount. CrossAccount is an Automation that runs in multiple AWS Regions
	// and accounts. For more information, see Running Automation workflows in multiple
	// AWS Regions and accounts (https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-automation-multiple-accounts-and-regions.html)
	// in the AWS Systems Manager User Guide.
	AutomationType AutomationType `type:"string" enum:"true"`

	// The action of the step that is currently running.
	CurrentAction *string `type:"string"`

	// The name of the step that is currently running.
	CurrentStepName *string `type:"string"`

	// The name of the Automation document used during execution.
	DocumentName *string `type:"string"`

	// The document version used during the execution.
	DocumentVersion *string `type:"string"`

	// The IAM role ARN of the user who ran the Automation.
	ExecutedBy *string `type:"string"`

	// The time the execution finished. This is not populated if the execution is
	// still in progress.
	ExecutionEndTime *time.Time `type:"timestamp"`

	// The time the execution started.
	ExecutionStartTime *time.Time `type:"timestamp"`

	// The list of execution outputs as defined in the Automation document.
	FailureMessage *string `type:"string"`

	// An S3 bucket where execution information is stored.
	LogFile *string `type:"string"`

	// The MaxConcurrency value specified by the user when starting the Automation.
	MaxConcurrency *string `min:"1" type:"string"`

	// The MaxErrors value specified by the user when starting the Automation.
	MaxErrors *string `min:"1" type:"string"`

	// The Automation execution mode.
	Mode ExecutionMode `type:"string" enum:"true"`

	// The list of execution outputs as defined in the Automation document.
	Outputs map[string][]string `min:"1" type:"map"`

	// The ExecutionId of the parent Automation.
	ParentAutomationExecutionId *string `min:"36" type:"string"`

	// A list of targets that resolved during the execution.
	ResolvedTargets *ResolvedTargets `type:"structure"`

	// The list of execution outputs as defined in the Automation document.
	Target *string `type:"string"`

	// The specified key-value mapping of document parameters to target resources.
	TargetMaps []map[string][]string `type:"list"`

	// The list of execution outputs as defined in the Automation document.
	TargetParameterName *string `min:"1" type:"string"`

	// The targets defined by the user when starting the Automation.
	Targets []Target `type:"list"`
}

// String returns the string representation
func (s AutomationExecutionMetadata) String() string {
	return awsutil.Prettify(s)
}

// Configuration options for sending command output to CloudWatch Logs.
type CloudWatchOutputConfig struct {
	_ struct{} `type:"structure"`

	// The name of the CloudWatch log group where you want to send command output.
	// If you don't specify a group name, Systems Manager automatically creates
	// a log group for you. The log group uses the following naming format: aws/ssm/SystemsManagerDocumentName.
	CloudWatchLogGroupName *string `min:"1" type:"string"`

	// Enables Systems Manager to send command output to CloudWatch Logs.
	CloudWatchOutputEnabled *bool `type:"boolean"`
}

// String returns the string representation
func (s CloudWatchOutputConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudWatchOutputConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CloudWatchOutputConfig"}
	if s.CloudWatchLogGroupName != nil && len(*s.CloudWatchLogGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CloudWatchLogGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes a command request.
type Command struct {
	_ struct{} `type:"structure"`

	// CloudWatch Logs information where you want Systems Manager to send the command
	// output.
	CloudWatchOutputConfig *CloudWatchOutputConfig `type:"structure"`

	// A unique identifier for this command.
	CommandId *string `min:"36" type:"string"`

	// User-specified information about the command, such as a brief description
	// of what the command should do.
	Comment *string `type:"string"`

	// The number of targets for which the command invocation reached a terminal
	// state. Terminal states include the following: Success, Failed, Execution
	// Timed Out, Delivery Timed Out, Canceled, Terminated, or Undeliverable.
	CompletedCount *int64 `type:"integer"`

	// The number of targets for which the status is Delivery Timed Out.
	DeliveryTimedOutCount *int64 `type:"integer"`

	// The name of the document requested for execution.
	DocumentName *string `type:"string"`

	// The SSM document version.
	DocumentVersion *string `type:"string"`

	// The number of targets for which the status is Failed or Execution Timed Out.
	ErrorCount *int64 `type:"integer"`

	// If this time is reached and the command has not already started running,
	// it will not run. Calculated based on the ExpiresAfter user input provided
	// as part of the SendCommand API.
	ExpiresAfter *time.Time `type:"timestamp"`

	// The instance IDs against which this command was requested.
	InstanceIds []string `type:"list"`

	// The maximum number of instances that are allowed to run the command at the
	// same time. You can specify a number of instances, such as 10, or a percentage
	// of instances, such as 10%. The default value is 50. For more information
	// about how to use MaxConcurrency, see Running commands using Systems Manager
	// Run Command (https://docs.aws.amazon.com/systems-manager/latest/userguide/run-command.html)
	// in the AWS Systems Manager User Guide.
	MaxConcurrency *string `min:"1" type:"string"`

	// The maximum number of errors allowed before the system stops sending the
	// command to additional targets. You can specify a number of errors, such as
	// 10, or a percentage or errors, such as 10%. The default value is 0. For more
	// information about how to use MaxErrors, see Running commands using Systems
	// Manager Run Command (https://docs.aws.amazon.com/systems-manager/latest/userguide/run-command.html)
	// in the AWS Systems Manager User Guide.
	MaxErrors *string `min:"1" type:"string"`

	// Configurations for sending notifications about command status changes.
	NotificationConfig *NotificationConfig `type:"structure"`

	// The S3 bucket where the responses to the command executions should be stored.
	// This was requested when issuing the command.
	OutputS3BucketName *string `min:"3" type:"string"`

	// The S3 directory path inside the bucket where the responses to the command
	// executions should be stored. This was requested when issuing the command.
	OutputS3KeyPrefix *string `type:"string"`

	// (Deprecated) You can no longer specify this parameter. The system ignores
	// it. Instead, Systems Manager automatically determines the Region of the S3
	// bucket.
	OutputS3Region *string `min:"3" type:"string"`

	// The parameter values to be inserted in the document when running the command.
	Parameters map[string][]string `type:"map"`

	// The date and time the command was requested.
	RequestedDateTime *time.Time `type:"timestamp"`

	// The IAM service role that Run Command uses to act on your behalf when sending
	// notifications about command status changes.
	ServiceRole *string `type:"string"`

	// The status of the command.
	Status CommandStatus `type:"string" enum:"true"`

	// A detailed status of the command execution. StatusDetails includes more information
	// than Status because it includes states resulting from error and concurrency
	// control parameters. StatusDetails can show different results than Status.
	// For more information about these statuses, see Understanding command statuses
	// (https://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html)
	// in the AWS Systems Manager User Guide. StatusDetails can be one of the following
	// values:
	//
	//    * Pending: The command has not been sent to any instances.
	//
	//    * In Progress: The command has been sent to at least one instance but
	//    has not reached a final state on all instances.
	//
	//    * Success: The command successfully ran on all invocations. This is a
	//    terminal state.
	//
	//    * Delivery Timed Out: The value of MaxErrors or more command invocations
	//    shows a status of Delivery Timed Out. This is a terminal state.
	//
	//    * Execution Timed Out: The value of MaxErrors or more command invocations
	//    shows a status of Execution Timed Out. This is a terminal state.
	//
	//    * Failed: The value of MaxErrors or more command invocations shows a status
	//    of Failed. This is a terminal state.
	//
	//    * Incomplete: The command was attempted on all instances and one or more
	//    invocations does not have a value of Success but not enough invocations
	//    failed for the status to be Failed. This is a terminal state.
	//
	//    * Canceled: The command was terminated before it was completed. This is
	//    a terminal state.
	//
	//    * Rate Exceeded: The number of instances targeted by the command exceeded
	//    the account limit for pending invocations. The system has canceled the
	//    command before running it on any instance. This is a terminal state.
	StatusDetails *string `type:"string"`

	// The number of targets for the command.
	TargetCount *int64 `type:"integer"`

	// An array of search criteria that targets instances using a Key,Value combination
	// that you specify. Targets is required if you don't provide one or more instance
	// IDs in the call.
	Targets []Target `type:"list"`

	// The TimeoutSeconds value specified for a command.
	TimeoutSeconds *int64 `min:"30" type:"integer"`
}

// String returns the string representation
func (s Command) String() string {
	return awsutil.Prettify(s)
}

// Describes a command filter.
type CommandFilter struct {
	_ struct{} `type:"structure"`

	// The name of the filter.
	//
	// Key is a required field
	Key CommandFilterKey `locationName:"key" type:"string" required:"true" enum:"true"`

	// The filter value. Valid values for each filter key are as follows:
	//
	//    * InvokedAfter: Specify a timestamp to limit your results. For example,
	//    specify 2018-07-07T00:00:00Z to see a list of command executions occurring
	//    July 7, 2018, and later.
	//
	//    * InvokedBefore: Specify a timestamp to limit your results. For example,
	//    specify 2018-07-07T00:00:00Z to see a list of command executions from
	//    before July 7, 2018.
	//
	//    * Status: Specify a valid command status to see a list of all command
	//    executions with that status. Status values you can specify include: Pending
	//    InProgress Success Cancelled Failed TimedOut Cancelling
	//
	//    * DocumentName: Specify name of the SSM document for which you want to
	//    see command execution results. For example, specify AWS-RunPatchBaseline
	//    to see command executions that used this SSM document to perform security
	//    patching operations on instances.
	//
	//    * ExecutionStage: Specify one of the following values: Executing: Returns
	//    a list of command executions that are currently still running. Complete:
	//    Returns a list of command executions that have already completed.
	//
	// Value is a required field
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CommandFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CommandFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CommandFilter"}
	if len(s.Key) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// An invocation is copy of a command sent to a specific instance. A command
// can apply to one or more instances. A command invocation applies to one instance.
// For example, if a user runs SendCommand against three instances, then a command
// invocation is created for each requested instance ID. A command invocation
// returns status and detail information about a command you ran.
type CommandInvocation struct {
	_ struct{} `type:"structure"`

	// CloudWatch Logs information where you want Systems Manager to send the command
	// output.
	CloudWatchOutputConfig *CloudWatchOutputConfig `type:"structure"`

	// The command against which this invocation was requested.
	CommandId *string `min:"36" type:"string"`

	CommandPlugins []CommandPlugin `type:"list"`

	// User-specified information about the command, such as a brief description
	// of what the command should do.
	Comment *string `type:"string"`

	// The document name that was requested for execution.
	DocumentName *string `type:"string"`

	// The SSM document version.
	DocumentVersion *string `type:"string"`

	// The instance ID in which this invocation was requested.
	InstanceId *string `type:"string"`

	// The name of the invocation target. For EC2 instances this is the value for
	// the aws:Name tag. For on-premises instances, this is the name of the instance.
	InstanceName *string `type:"string"`

	// Configurations for sending notifications about command status changes on
	// a per instance basis.
	NotificationConfig *NotificationConfig `type:"structure"`

	// The time and date the request was sent to this instance.
	RequestedDateTime *time.Time `type:"timestamp"`

	// The IAM service role that Run Command uses to act on your behalf when sending
	// notifications about command status changes on a per instance basis.
	ServiceRole *string `type:"string"`

	// The URL to the plugin's StdErr file in Amazon S3, if the S3 bucket was defined
	// for the parent command. For an invocation, StandardErrorUrl is populated
	// if there is just one plugin defined for the command, and the S3 bucket was
	// defined for the command.
	StandardErrorUrl *string `type:"string"`

	// The URL to the plugin's StdOut file in Amazon S3, if the S3 bucket was defined
	// for the parent command. For an invocation, StandardOutputUrl is populated
	// if there is just one plugin defined for the command, and the S3 bucket was
	// defined for the command.
	StandardOutputUrl *string `type:"string"`

	// Whether or not the invocation succeeded, failed, or is pending.
	Status CommandInvocationStatus `type:"string" enum:"true"`

	// A detailed status of the command execution for each invocation (each instance
	// targeted by the command). StatusDetails includes more information than Status
	// because it includes states resulting from error and concurrency control parameters.
	// StatusDetails can show different results than Status. For more information
	// about these statuses, see Understanding command statuses (https://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html)
	// in the AWS Systems Manager User Guide. StatusDetails can be one of the following
	// values:
	//
	//    * Pending: The command has not been sent to the instance.
	//
	//    * In Progress: The command has been sent to the instance but has not reached
	//    a terminal state.
	//
	//    * Success: The execution of the command or plugin was successfully completed.
	//    This is a terminal state.
	//
	//    * Delivery Timed Out: The command was not delivered to the instance before
	//    the delivery timeout expired. Delivery timeouts do not count against the
	//    parent command's MaxErrors limit, but they do contribute to whether the
	//    parent command status is Success or Incomplete. This is a terminal state.
	//
	//    * Execution Timed Out: Command execution started on the instance, but
	//    the execution was not complete before the execution timeout expired. Execution
	//    timeouts count against the MaxErrors limit of the parent command. This
	//    is a terminal state.
	//
	//    * Failed: The command was not successful on the instance. For a plugin,
	//    this indicates that the result code was not zero. For a command invocation,
	//    this indicates that the result code for one or more plugins was not zero.
	//    Invocation failures count against the MaxErrors limit of the parent command.
	//    This is a terminal state.
	//
	//    * Canceled: The command was terminated before it was completed. This is
	//    a terminal state.
	//
	//    * Undeliverable: The command can't be delivered to the instance. The instance
	//    might not exist or might not be responding. Undeliverable invocations
	//    don't count against the parent command's MaxErrors limit and don't contribute
	//    to whether the parent command status is Success or Incomplete. This is
	//    a terminal state.
	//
	//    * Terminated: The parent command exceeded its MaxErrors limit and subsequent
	//    command invocations were canceled by the system. This is a terminal state.
	StatusDetails *string `type:"string"`

	// Gets the trace output sent by the agent.
	TraceOutput *string `type:"string"`
}

// String returns the string representation
func (s CommandInvocation) String() string {
	return awsutil.Prettify(s)
}

// Describes plugin details.
type CommandPlugin struct {
	_ struct{} `type:"structure"`

	// The name of the plugin. Must be one of the following: aws:updateAgent, aws:domainjoin,
	// aws:applications, aws:runPowerShellScript, aws:psmodule, aws:cloudWatch,
	// aws:runShellScript, or aws:updateSSMAgent.
	Name *string `min:"4" type:"string"`

	// Output of the plugin execution.
	Output *string `type:"string"`

	// The S3 bucket where the responses to the command executions should be stored.
	// This was requested when issuing the command. For example, in the following
	// response:
	//
	// test_folder/ab19cb99-a030-46dd-9dfc-8eSAMPLEPre-Fix/i-1234567876543/awsrunShellScript
	//
	// test_folder is the name of the S3 bucket;
	//
	// ab19cb99-a030-46dd-9dfc-8eSAMPLEPre-Fix is the name of the S3 prefix;
	//
	// i-1234567876543 is the instance ID;
	//
	// awsrunShellScript is the name of the plugin.
	OutputS3BucketName *string `min:"3" type:"string"`

	// The S3 directory path inside the bucket where the responses to the command
	// executions should be stored. This was requested when issuing the command.
	// For example, in the following response:
	//
	// test_folder/ab19cb99-a030-46dd-9dfc-8eSAMPLEPre-Fix/i-1234567876543/awsrunShellScript
	//
	// test_folder is the name of the S3 bucket;
	//
	// ab19cb99-a030-46dd-9dfc-8eSAMPLEPre-Fix is the name of the S3 prefix;
	//
	// i-1234567876543 is the instance ID;
	//
	// awsrunShellScript is the name of the plugin.
	OutputS3KeyPrefix *string `type:"string"`

	// (Deprecated) You can no longer specify this parameter. The system ignores
	// it. Instead, Systems Manager automatically determines the S3 bucket region.
	OutputS3Region *string `min:"3" type:"string"`

	// A numeric response code generated after running the plugin.
	ResponseCode *int64 `type:"integer"`

	// The time the plugin stopped running. Could stop prematurely if, for example,
	// a cancel command was sent.
	ResponseFinishDateTime *time.Time `type:"timestamp"`

	// The time the plugin started running.
	ResponseStartDateTime *time.Time `type:"timestamp"`

	// The URL for the complete text written by the plugin to stderr. If execution
	// is not yet complete, then this string is empty.
	StandardErrorUrl *string `type:"string"`

	// The URL for the complete text written by the plugin to stdout in Amazon S3.
	// If the S3 bucket for the command was not specified, then this string is empty.
	StandardOutputUrl *string `type:"string"`

	// The status of this plugin. You can run a document with multiple plugins.
	Status CommandPluginStatus `type:"string" enum:"true"`

	// A detailed status of the plugin execution. StatusDetails includes more information
	// than Status because it includes states resulting from error and concurrency
	// control parameters. StatusDetails can show different results than Status.
	// For more information about these statuses, see Understanding command statuses
	// (https://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html)
	// in the AWS Systems Manager User Guide. StatusDetails can be one of the following
	// values:
	//
	//    * Pending: The command has not been sent to the instance.
	//
	//    * In Progress: The command has been sent to the instance but has not reached
	//    a terminal state.
	//
	//    * Success: The execution of the command or plugin was successfully completed.
	//    This is a terminal state.
	//
	//    * Delivery Timed Out: The command was not delivered to the instance before
	//    the delivery timeout expired. Delivery timeouts do not count against the
	//    parent command's MaxErrors limit, but they do contribute to whether the
	//    parent command status is Success or Incomplete. This is a terminal state.
	//
	//    * Execution Timed Out: Command execution started on the instance, but
	//    the execution was not complete before the execution timeout expired. Execution
	//    timeouts count against the MaxErrors limit of the parent command. This
	//    is a terminal state.
	//
	//    * Failed: The command was not successful on the instance. For a plugin,
	//    this indicates that the result code was not zero. For a command invocation,
	//    this indicates that the result code for one or more plugins was not zero.
	//    Invocation failures count against the MaxErrors limit of the parent command.
	//    This is a terminal state.
	//
	//    * Canceled: The command was terminated before it was completed. This is
	//    a terminal state.
	//
	//    * Undeliverable: The command can't be delivered to the instance. The instance
	//    might not exist, or it might not be responding. Undeliverable invocations
	//    don't count against the parent command's MaxErrors limit, and they don't
	//    contribute to whether the parent command status is Success or Incomplete.
	//    This is a terminal state.
	//
	//    * Terminated: The parent command exceeded its MaxErrors limit and subsequent
	//    command invocations were canceled by the system. This is a terminal state.
	StatusDetails *string `type:"string"`
}

// String returns the string representation
func (s CommandPlugin) String() string {
	return awsutil.Prettify(s)
}

// A summary of the call execution that includes an execution ID, the type of
// execution (for example, Command), and the date/time of the execution using
// a datetime object that is saved in the following format: yyyy-MM-dd'T'HH:mm:ss'Z'.
type ComplianceExecutionSummary struct {
	_ struct{} `type:"structure"`

	// An ID created by the system when PutComplianceItems was called. For example,
	// CommandID is a valid execution ID. You can use this ID in subsequent calls.
	ExecutionId *string `type:"string"`

	// The time the execution ran as a datetime object that is saved in the following
	// format: yyyy-MM-dd'T'HH:mm:ss'Z'.
	//
	// ExecutionTime is a required field
	ExecutionTime *time.Time `type:"timestamp" required:"true"`

	// The type of execution. For example, Command is a valid execution type.
	ExecutionType *string `type:"string"`
}

// String returns the string representation
func (s ComplianceExecutionSummary) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ComplianceExecutionSummary) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ComplianceExecutionSummary"}

	if s.ExecutionTime == nil {
		invalidParams.Add(aws.NewErrParamRequired("ExecutionTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about the compliance as defined by the resource type. For example,
// for a patch resource type, Items includes information about the PatchSeverity,
// Classification, and so on.
type ComplianceItem struct {
	_ struct{} `type:"structure"`

	// The compliance type. For example, Association (for a State Manager association),
	// Patch, or Custom:string are all valid compliance types.
	ComplianceType *string `min:"1" type:"string"`

	// A "Key": "Value" tag combination for the compliance item.
	Details map[string]string `type:"map"`

	// A summary for the compliance item. The summary includes an execution ID,
	// the execution type (for example, command), and the execution time.
	ExecutionSummary *ComplianceExecutionSummary `type:"structure"`

	// An ID for the compliance item. For example, if the compliance item is a Windows
	// patch, the ID could be the number of the KB article; for example: KB4010320.
	Id *string `type:"string"`

	// An ID for the resource. For a managed instance, this is the instance ID.
	ResourceId *string `min:"1" type:"string"`

	// The type of resource. ManagedInstance is currently the only supported resource
	// type.
	ResourceType *string `min:"1" type:"string"`

	// The severity of the compliance status. Severity can be one of the following:
	// Critical, High, Medium, Low, Informational, Unspecified.
	Severity ComplianceSeverity `type:"string" enum:"true"`

	// The status of the compliance item. An item is either COMPLIANT or NON_COMPLIANT.
	Status ComplianceStatus `type:"string" enum:"true"`

	// A title for the compliance item. For example, if the compliance item is a
	// Windows patch, the title could be the title of the KB article for the patch;
	// for example: Security Update for Active Directory Federation Services.
	Title *string `type:"string"`
}

// String returns the string representation
func (s ComplianceItem) String() string {
	return awsutil.Prettify(s)
}

// Information about a compliance item.
type ComplianceItemEntry struct {
	_ struct{} `type:"structure"`

	// A "Key": "Value" tag combination for the compliance item.
	Details map[string]string `type:"map"`

	// The compliance item ID. For example, if the compliance item is a Windows
	// patch, the ID could be the number of the KB article.
	Id *string `type:"string"`

	// The severity of the compliance status. Severity can be one of the following:
	// Critical, High, Medium, Low, Informational, Unspecified.
	//
	// Severity is a required field
	Severity ComplianceSeverity `type:"string" required:"true" enum:"true"`

	// The status of the compliance item. An item is either COMPLIANT or NON_COMPLIANT.
	//
	// Status is a required field
	Status ComplianceStatus `type:"string" required:"true" enum:"true"`

	// The title of the compliance item. For example, if the compliance item is
	// a Windows patch, the title could be the title of the KB article for the patch;
	// for example: Security Update for Active Directory Federation Services.
	Title *string `type:"string"`
}

// String returns the string representation
func (s ComplianceItemEntry) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ComplianceItemEntry) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ComplianceItemEntry"}
	if len(s.Severity) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Severity"))
	}
	if len(s.Status) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// One or more filters. Use a filter to return a more specific list of results.
type ComplianceStringFilter struct {
	_ struct{} `type:"structure"`

	// The name of the filter.
	Key *string `min:"1" type:"string"`

	// The type of comparison that should be performed for the value: Equal, NotEqual,
	// BeginWith, LessThan, or GreaterThan.
	Type ComplianceQueryOperatorType `type:"string" enum:"true"`

	// The value for which to search.
	Values []string `min:"1" type:"list"`
}

// String returns the string representation
func (s ComplianceStringFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ComplianceStringFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ComplianceStringFilter"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A summary of compliance information by compliance type.
type ComplianceSummaryItem struct {
	_ struct{} `type:"structure"`

	// The type of compliance item. For example, the compliance type can be Association,
	// Patch, or Custom:string.
	ComplianceType *string `min:"1" type:"string"`

	// A list of COMPLIANT items for the specified compliance type.
	CompliantSummary *CompliantSummary `type:"structure"`

	// A list of NON_COMPLIANT items for the specified compliance type.
	NonCompliantSummary *NonCompliantSummary `type:"structure"`
}

// String returns the string representation
func (s ComplianceSummaryItem) String() string {
	return awsutil.Prettify(s)
}

// A summary of resources that are compliant. The summary is organized according
// to the resource count for each compliance type.
type CompliantSummary struct {
	_ struct{} `type:"structure"`

	// The total number of resources that are compliant.
	CompliantCount *int64 `type:"integer"`

	// A summary of the compliance severity by compliance type.
	SeveritySummary *SeveritySummary `type:"structure"`
}

// String returns the string representation
func (s CompliantSummary) String() string {
	return awsutil.Prettify(s)
}

// Describes the association of a Systems Manager SSM document and an instance.
type CreateAssociationBatchRequestEntry struct {
	_ struct{} `type:"structure"`

	// By default, when you create a new associations, the system runs it immediately
	// after it is created and then according to the schedule you specified. Specify
	// this option if you don't want an association to run immediately after you
	// create it.
	ApplyOnlyAtCronInterval *bool `type:"boolean"`

	// Specify a descriptive name for the association.
	AssociationName *string `type:"string"`

	// Specify the target for the association. This target is required for associations
	// that use an Automation document and target resources by using rate controls.
	AutomationTargetParameterName *string `min:"1" type:"string"`

	// The severity level to assign to the association.
	ComplianceSeverity AssociationComplianceSeverity `type:"string" enum:"true"`

	// The document version.
	DocumentVersion *string `type:"string"`

	// The ID of the instance.
	InstanceId *string `type:"string"`

	// The maximum number of targets allowed to run the association at the same
	// time. You can specify a number, for example 10, or a percentage of the target
	// set, for example 10%. The default value is 100%, which means all targets
	// run the association at the same time.
	//
	// If a new instance starts and attempts to run an association while Systems
	// Manager is running MaxConcurrency associations, the association is allowed
	// to run. During the next association interval, the new instance will process
	// its association within the limit specified for MaxConcurrency.
	MaxConcurrency *string `min:"1" type:"string"`

	// The number of errors that are allowed before the system stops sending requests
	// to run the association on additional targets. You can specify either an absolute
	// number of errors, for example 10, or a percentage of the target set, for
	// example 10%. If you specify 3, for example, the system stops sending requests
	// when the fourth error is received. If you specify 0, then the system stops
	// sending requests after the first error is returned. If you run an association
	// on 50 instances and set MaxError to 10%, then the system stops sending the
	// request when the sixth error is received.
	//
	// Executions that are already running an association when MaxErrors is reached
	// are allowed to complete, but some of these executions may fail as well. If
	// you need to ensure that there won't be more than max-errors failed executions,
	// set MaxConcurrency to 1 so that executions proceed one at a time.
	MaxErrors *string `min:"1" type:"string"`

	// The name of the SSM document that contains the configuration information
	// for the instance. You can specify Command or Automation documents.
	//
	// You can specify AWS-predefined documents, documents you created, or a document
	// that is shared with you from another account.
	//
	// For SSM documents that are shared with you from other AWS accounts, you must
	// specify the complete SSM document ARN, in the following format:
	//
	// arn:aws:ssm:region:account-id:document/document-name
	//
	// For example:
	//
	// arn:aws:ssm:us-east-2:12345678912:document/My-Shared-Document
	//
	// For AWS-predefined documents and SSM documents you created in your account,
	// you only need to specify the document name. For example, AWS-ApplyPatchBaseline
	// or My-Document.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// An S3 bucket where you want to store the results of this request.
	OutputLocation *InstanceAssociationOutputLocation `type:"structure"`

	// A description of the parameters for a document.
	Parameters map[string][]string `type:"map"`

	// A cron expression that specifies a schedule when the association runs.
	ScheduleExpression *string `min:"1" type:"string"`

	// The mode for generating association compliance. You can specify AUTO or MANUAL.
	// In AUTO mode, the system uses the status of the association execution to
	// determine the compliance status. If the association execution runs successfully,
	// then the association is COMPLIANT. If the association execution doesn't run
	// successfully, the association is NON-COMPLIANT.
	//
	// In MANUAL mode, you must specify the AssociationId as a parameter for the
	// PutComplianceItems API action. In this case, compliance data is not managed
	// by State Manager. It is managed by your direct call to the PutComplianceItems
	// API action.
	//
	// By default, all associations use AUTO mode.
	SyncCompliance AssociationSyncCompliance `type:"string" enum:"true"`

	// The instances targeted by the request.
	Targets []Target `type:"list"`
}

// String returns the string representation
func (s CreateAssociationBatchRequestEntry) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAssociationBatchRequestEntry) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateAssociationBatchRequestEntry"}
	if s.AutomationTargetParameterName != nil && len(*s.AutomationTargetParameterName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AutomationTargetParameterName", 1))
	}
	if s.MaxConcurrency != nil && len(*s.MaxConcurrency) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MaxConcurrency", 1))
	}
	if s.MaxErrors != nil && len(*s.MaxErrors) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MaxErrors", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.ScheduleExpression != nil && len(*s.ScheduleExpression) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ScheduleExpression", 1))
	}
	if s.OutputLocation != nil {
		if err := s.OutputLocation.Validate(); err != nil {
			invalidParams.AddNested("OutputLocation", err.(aws.ErrInvalidParams))
		}
	}
	if s.Targets != nil {
		for i, v := range s.Targets {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Targets", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Filter for the DescribeActivation API.
type DescribeActivationsFilter struct {
	_ struct{} `type:"structure"`

	// The name of the filter.
	FilterKey DescribeActivationsFilterKeys `type:"string" enum:"true"`

	// The filter values.
	FilterValues []string `type:"list"`
}

// String returns the string representation
func (s DescribeActivationsFilter) String() string {
	return awsutil.Prettify(s)
}

// A default version of a document.
type DocumentDefaultVersionDescription struct {
	_ struct{} `type:"structure"`

	// The default version of the document.
	DefaultVersion *string `type:"string"`

	// The default version of the artifact associated with the document.
	DefaultVersionName *string `type:"string"`

	// The name of the document.
	Name *string `type:"string"`
}

// String returns the string representation
func (s DocumentDefaultVersionDescription) String() string {
	return awsutil.Prettify(s)
}

// Describes a Systems Manager document.
type DocumentDescription struct {
	_ struct{} `type:"structure"`

	// Details about the document attachments, including names, locations, sizes,
	// and so on.
	AttachmentsInformation []AttachmentInformation `type:"list"`

	// The date when the document was created.
	CreatedDate *time.Time `type:"timestamp"`

	// The default version.
	DefaultVersion *string `type:"string"`

	// A description of the document.
	Description *string `type:"string"`

	// The document format, either JSON or YAML.
	DocumentFormat DocumentFormat `type:"string" enum:"true"`

	// The type of document.
	DocumentType DocumentType `type:"string" enum:"true"`

	// The document version.
	DocumentVersion *string `type:"string"`

	// The Sha256 or Sha1 hash created by the system when the document was created.
	//
	// Sha1 hashes have been deprecated.
	Hash *string `type:"string"`

	// The hash type of the document. Valid values include Sha256 or Sha1.
	//
	// Sha1 hashes have been deprecated.
	HashType DocumentHashType `type:"string" enum:"true"`

	// The latest version of the document.
	LatestVersion *string `type:"string"`

	// The name of the Systems Manager document.
	Name *string `type:"string"`

	// The AWS user account that created the document.
	Owner *string `type:"string"`

	// A description of the parameters for a document.
	Parameters []DocumentParameter `type:"list"`

	// The list of OS platforms compatible with this Systems Manager document.
	PlatformTypes []PlatformType `type:"list"`

	// A list of SSM documents required by a document. For example, an ApplicationConfiguration
	// document requires an ApplicationConfigurationSchema document.
	Requires []DocumentRequires `min:"1" type:"list"`

	// The schema version.
	SchemaVersion *string `type:"string"`

	// The SHA1 hash of the document, which you can use for verification.
	Sha1 *string `type:"string"`

	// The status of the Systems Manager document.
	Status DocumentStatus `type:"string" enum:"true"`

	// A message returned by AWS Systems Manager that explains the Status value.
	// For example, a Failed status might be explained by the StatusInformation
	// message, "The specified S3 bucket does not exist. Verify that the URL of
	// the S3 bucket is correct."
	StatusInformation *string `type:"string"`

	// The tags, or metadata, that have been applied to the document.
	Tags []Tag `type:"list"`

	// The target type which defines the kinds of resources the document can run
	// on. For example, /AWS::EC2::Instance. For a list of valid resource types,
	// see AWS resource and property types reference (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the AWS CloudFormation User Guide.
	TargetType *string `type:"string"`

	// The version of the artifact associated with the document.
	VersionName *string `type:"string"`
}

// String returns the string representation
func (s DocumentDescription) String() string {
	return awsutil.Prettify(s)
}

// This data type is deprecated. Instead, use DocumentKeyValuesFilter.
type DocumentFilter struct {
	_ struct{} `type:"structure"`

	// The name of the filter.
	//
	// Key is a required field
	Key DocumentFilterKey `locationName:"key" type:"string" required:"true" enum:"true"`

	// The value of the filter.
	//
	// Value is a required field
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DocumentFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DocumentFilter"}
	if len(s.Key) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the name of a Systems Manager document.
type DocumentIdentifier struct {
	_ struct{} `type:"structure"`

	// The document format, either JSON or YAML.
	DocumentFormat DocumentFormat `type:"string" enum:"true"`

	// The document type.
	DocumentType DocumentType `type:"string" enum:"true"`

	// The document version.
	DocumentVersion *string `type:"string"`

	// The name of the Systems Manager document.
	Name *string `type:"string"`

	// The AWS user account that created the document.
	Owner *string `type:"string"`

	// The operating system platform.
	PlatformTypes []PlatformType `type:"list"`

	// A list of SSM documents required by a document. For example, an ApplicationConfiguration
	// document requires an ApplicationConfigurationSchema document.
	Requires []DocumentRequires `min:"1" type:"list"`

	// The schema version.
	SchemaVersion *string `type:"string"`

	// The tags, or metadata, that have been applied to the document.
	Tags []Tag `type:"list"`

	// The target type which defines the kinds of resources the document can run
	// on. For example, /AWS::EC2::Instance. For a list of valid resource types,
	// see AWS resource and property types reference (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the AWS CloudFormation User Guide.
	TargetType *string `type:"string"`

	// An optional field specifying the version of the artifact associated with
	// the document. For example, "Release 12, Update 6". This value is unique across
	// all versions of a document, and cannot be changed.
	VersionName *string `type:"string"`
}

// String returns the string representation
func (s DocumentIdentifier) String() string {
	return awsutil.Prettify(s)
}

// One or more filters. Use a filter to return a more specific list of documents.
//
// For keys, you can specify one or more tags that have been applied to a document.
//
// Other valid values include Owner, Name, PlatformTypes, DocumentType, and
// TargetType.
//
// Note that only one Owner can be specified in a request. For example: Key=Owner,Values=Self.
//
// If you use Name as a key, you can use a name prefix to return a list of documents.
// For example, in the AWS CLI, to return a list of all documents that begin
// with Te, run the following command:
//
// aws ssm list-documents --filters Key=Name,Values=Te
//
// If you specify more than two keys, only documents that are identified by
// all the tags are returned in the results. If you specify more than two values
// for a key, documents that are identified by any of the values are returned
// in the results.
//
// To specify a custom key and value pair, use the format Key=tag:tagName,Values=valueName.
//
// For example, if you created a Key called region and are using the AWS CLI
// to call the list-documents command:
//
// aws ssm list-documents --filters Key=tag:region,Values=east,west Key=Owner,Values=Self
type DocumentKeyValuesFilter struct {
	_ struct{} `type:"structure"`

	// The name of the filter key.
	Key *string `min:"1" type:"string"`

	// The value for the filter key.
	Values []string `type:"list"`
}

// String returns the string representation
func (s DocumentKeyValuesFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentKeyValuesFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DocumentKeyValuesFilter"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Parameters specified in a System Manager document that run on the server
// when the command is run.
type DocumentParameter struct {
	_ struct{} `type:"structure"`

	// If specified, the default values for the parameters. Parameters without a
	// default value are required. Parameters with a default value are optional.
	DefaultValue *string `type:"string"`

	// A description of what the parameter does, how to use it, the default value,
	// and whether or not the parameter is optional.
	Description *string `type:"string"`

	// The name of the parameter.
	Name *string `type:"string"`

	// The type of parameter. The type can be either String or StringList.
	Type DocumentParameterType `type:"string" enum:"true"`
}

// String returns the string representation
func (s DocumentParameter) String() string {
	return awsutil.Prettify(s)
}

// An SSM document required by the current document.
type DocumentRequires struct {
	_ struct{} `type:"structure"`

	// The name of the required SSM document. The name can be an Amazon Resource
	// Name (ARN).
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The document version required by the current document.
	Version *string `type:"string"`
}

// String returns the string representation
func (s DocumentRequires) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentRequires) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DocumentRequires"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Version information about the document.
type DocumentVersionInfo struct {
	_ struct{} `type:"structure"`

	// The date the document was created.
	CreatedDate *time.Time `type:"timestamp"`

	// The document format, either JSON or YAML.
	DocumentFormat DocumentFormat `type:"string" enum:"true"`

	// The document version.
	DocumentVersion *string `type:"string"`

	// An identifier for the default version of the document.
	IsDefaultVersion *bool `type:"boolean"`

	// The document name.
	Name *string `type:"string"`

	// The status of the Systems Manager document, such as Creating, Active, Failed,
	// and Deleting.
	Status DocumentStatus `type:"string" enum:"true"`

	// A message returned by AWS Systems Manager that explains the Status value.
	// For example, a Failed status might be explained by the StatusInformation
	// message, "The specified S3 bucket does not exist. Verify that the URL of
	// the S3 bucket is correct."
	StatusInformation *string `type:"string"`

	// The version of the artifact associated with the document. For example, "Release
	// 12, Update 6". This value is unique across all versions of a document, and
	// cannot be changed.
	VersionName *string `type:"string"`
}

// String returns the string representation
func (s DocumentVersionInfo) String() string {
	return awsutil.Prettify(s)
}

// The EffectivePatch structure defines metadata about a patch along with the
// approval state of the patch in a particular patch baseline. The approval
// state includes information about whether the patch is currently approved,
// due to be approved by a rule, explicitly approved, or explicitly rejected
// and the date the patch was or will be approved.
type EffectivePatch struct {
	_ struct{} `type:"structure"`

	// Provides metadata for a patch, including information such as the KB ID, severity,
	// classification and a URL for where more information can be obtained about
	// the patch.
	Patch *Patch `type:"structure"`

	// The status of the patch in a patch baseline. This includes information about
	// whether the patch is currently approved, due to be approved by a rule, explicitly
	// approved, or explicitly rejected and the date the patch was or will be approved.
	PatchStatus *PatchStatus `type:"structure"`
}

// String returns the string representation
func (s EffectivePatch) String() string {
	return awsutil.Prettify(s)
}

// Describes a failed association.
type FailedCreateAssociation struct {
	_ struct{} `type:"structure"`

	// The association.
	Entry *CreateAssociationBatchRequestEntry `type:"structure"`

	// The source of the failure.
	Fault Fault `type:"string" enum:"true"`

	// A description of the failure.
	Message *string `type:"string"`
}

// String returns the string representation
func (s FailedCreateAssociation) String() string {
	return awsutil.Prettify(s)
}

// Information about an Automation failure.
type FailureDetails struct {
	_ struct{} `type:"structure"`

	// Detailed information about the Automation step failure.
	Details map[string][]string `min:"1" type:"map"`

	// The stage of the Automation execution when the failure occurred. The stages
	// include the following: InputValidation, PreVerification, Invocation, PostVerification.
	FailureStage *string `type:"string"`

	// The type of Automation failure. Failure types include the following: Action,
	// Permission, Throttling, Verification, Internal.
	FailureType *string `type:"string"`
}

// String returns the string representation
func (s FailureDetails) String() string {
	return awsutil.Prettify(s)
}

// Status information about the aggregated associations.
type InstanceAggregatedAssociationOverview struct {
	_ struct{} `type:"structure"`

	// Detailed status information about the aggregated associations.
	DetailedStatus *string `type:"string"`

	// The number of associations for the instance(s).
	InstanceAssociationStatusAggregatedCount map[string]int64 `type:"map"`
}

// String returns the string representation
func (s InstanceAggregatedAssociationOverview) String() string {
	return awsutil.Prettify(s)
}

// One or more association documents on the instance.
type InstanceAssociation struct {
	_ struct{} `type:"structure"`

	// The association ID.
	AssociationId *string `type:"string"`

	// Version information for the association on the instance.
	AssociationVersion *string `type:"string"`

	// The content of the association document for the instance(s).
	Content *string `min:"1" type:"string"`

	// The instance ID.
	InstanceId *string `type:"string"`
}

// String returns the string representation
func (s InstanceAssociation) String() string {
	return awsutil.Prettify(s)
}

// An S3 bucket where you want to store the results of this request.
type InstanceAssociationOutputLocation struct {
	_ struct{} `type:"structure"`

	// An S3 bucket where you want to store the results of this request.
	S3Location *S3OutputLocation `type:"structure"`
}

// String returns the string representation
func (s InstanceAssociationOutputLocation) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InstanceAssociationOutputLocation) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InstanceAssociationOutputLocation"}
	if s.S3Location != nil {
		if err := s.S3Location.Validate(); err != nil {
			invalidParams.AddNested("S3Location", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The URL of S3 bucket where you want to store the results of this request.
type InstanceAssociationOutputUrl struct {
	_ struct{} `type:"structure"`

	// The URL of S3 bucket where you want to store the results of this request.
	S3OutputUrl *S3OutputUrl `type:"structure"`
}

// String returns the string representation
func (s InstanceAssociationOutputUrl) String() string {
	return awsutil.Prettify(s)
}

// Status information about the instance association.
type InstanceAssociationStatusInfo struct {
	_ struct{} `type:"structure"`

	// The association ID.
	AssociationId *string `type:"string"`

	// The name of the association applied to the instance.
	AssociationName *string `type:"string"`

	// The version of the association applied to the instance.
	AssociationVersion *string `type:"string"`

	// Detailed status information about the instance association.
	DetailedStatus *string `type:"string"`

	// The association document versions.
	DocumentVersion *string `type:"string"`

	// An error code returned by the request to create the association.
	ErrorCode *string `type:"string"`

	// The date the instance association ran.
	ExecutionDate *time.Time `type:"timestamp"`

	// Summary information about association execution.
	ExecutionSummary *string `min:"1" type:"string"`

	// The instance ID where the association was created.
	InstanceId *string `type:"string"`

	// The name of the association.
	Name *string `type:"string"`

	// A URL for an S3 bucket where you want to store the results of this request.
	OutputUrl *InstanceAssociationOutputUrl `type:"structure"`

	// Status information about the instance association.
	Status *string `type:"string"`
}

// String returns the string representation
func (s InstanceAssociationStatusInfo) String() string {
	return awsutil.Prettify(s)
}

// Describes a filter for a specific list of instances.
type InstanceInformation struct {
	_ struct{} `type:"structure"`

	// The activation ID created by Systems Manager when the server or VM was registered.
	ActivationId *string `type:"string"`

	// The version of SSM Agent running on your Linux instance.
	AgentVersion *string `type:"string"`

	// Information about the association.
	AssociationOverview *InstanceAggregatedAssociationOverview `type:"structure"`

	// The status of the association.
	AssociationStatus *string `type:"string"`

	// The fully qualified host name of the managed instance.
	ComputerName *string `min:"1" type:"string"`

	// The IP address of the managed instance.
	IPAddress *string `min:"1" type:"string"`

	// The Amazon Identity and Access Management (IAM) role assigned to the on-premises
	// Systems Manager managed instances. This call does not return the IAM role
	// for EC2 instances.
	IamRole *string `type:"string"`

	// The instance ID.
	InstanceId *string `type:"string"`

	// Indicates whether the latest version of SSM Agent is running on your Linux
	// Managed Instance. This field does not indicate whether or not the latest
	// version is installed on Windows managed instances, because some older versions
	// of Windows Server use the EC2Config service to process SSM requests.
	IsLatestVersion *bool `type:"boolean"`

	// The date the association was last run.
	LastAssociationExecutionDate *time.Time `type:"timestamp"`

	// The date and time when agent last pinged Systems Manager service.
	LastPingDateTime *time.Time `type:"timestamp"`

	// The last date the association was successfully run.
	LastSuccessfulAssociationExecutionDate *time.Time `type:"timestamp"`

	// The name of the managed instance.
	Name *string `type:"string"`

	// Connection status of SSM Agent.
	PingStatus PingStatus `type:"string" enum:"true"`

	// The name of the operating system platform running on your instance.
	PlatformName *string `type:"string"`

	// The operating system platform type.
	PlatformType PlatformType `type:"string" enum:"true"`

	// The version of the OS platform running on your instance.
	PlatformVersion *string `type:"string"`

	// The date the server or VM was registered with AWS as a managed instance.
	RegistrationDate *time.Time `type:"timestamp"`

	// The type of instance. Instances are either EC2 instances or managed instances.
	ResourceType ResourceType `type:"string" enum:"true"`
}

// String returns the string representation
func (s InstanceInformation) String() string {
	return awsutil.Prettify(s)
}

// Describes a filter for a specific list of instances. You can filter instances
// information by using tags. You specify tags by using a key-value mapping.
//
// Use this action instead of the DescribeInstanceInformationRequest$InstanceInformationFilterList
// method. The InstanceInformationFilterList method is a legacy method and does
// not support tags.
type InstanceInformationFilter struct {
	_ struct{} `type:"structure"`

	// The name of the filter.
	//
	// Key is a required field
	Key InstanceInformationFilterKey `locationName:"key" type:"string" required:"true" enum:"true"`

	// The filter values.
	//
	// ValueSet is a required field
	ValueSet []string `locationName:"valueSet" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s InstanceInformationFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InstanceInformationFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InstanceInformationFilter"}
	if len(s.Key) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}

	if s.ValueSet == nil {
		invalidParams.Add(aws.NewErrParamRequired("ValueSet"))
	}
	if s.ValueSet != nil && len(s.ValueSet) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ValueSet", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The filters to describe or get information about your managed instances.
type InstanceInformationStringFilter struct {
	_ struct{} `type:"structure"`

	// The filter key name to describe your instances. For example:
	//
	// "InstanceIds"|"AgentVersion"|"PingStatus"|"PlatformTypes"|"ActivationIds"|"IamRole"|"ResourceType"|"AssociationStatus"|"Tag
	// Key"
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The filter values.
	//
	// Values is a required field
	Values []string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s InstanceInformationStringFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InstanceInformationStringFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InstanceInformationStringFilter"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if s.Values == nil {
		invalidParams.Add(aws.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Defines the high-level patch compliance state for a managed instance, providing
// information about the number of installed, missing, not applicable, and failed
// patches along with metadata about the operation when this information was
// gathered for the instance.
type InstancePatchState struct {
	_ struct{} `type:"structure"`

	// The ID of the patch baseline used to patch the instance.
	//
	// BaselineId is a required field
	BaselineId *string `min:"20" type:"string" required:"true"`

	// The number of patches from the patch baseline that were attempted to be installed
	// during the last patching operation, but failed to install.
	FailedCount *int64 `type:"integer"`

	// An https URL or an Amazon S3 path-style URL to a list of patches to be installed.
	// This patch installation list, which you maintain in an S3 bucket in YAML
	// format and specify in the SSM document AWS-RunPatchBaseline, overrides the
	// patches specified by the default patch baseline.
	//
	// For more information about the InstallOverrideList parameter, see About the
	// SSM document AWS-RunPatchBaseline (https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-about-aws-runpatchbaseline.html)
	// in the AWS Systems Manager User Guide.
	InstallOverrideList *string `min:"1" type:"string"`

	// The number of patches from the patch baseline that are installed on the instance.
	InstalledCount *int64 `type:"integer"`

	// The number of patches not specified in the patch baseline that are installed
	// on the instance.
	InstalledOtherCount *int64 `type:"integer"`

	// The number of patches installed by Patch Manager since the last time the
	// instance was rebooted.
	InstalledPendingRebootCount *int64 `type:"integer"`

	// The number of instances with patches installed that are specified in a RejectedPatches
	// list. Patches with a status of InstalledRejected were typically installed
	// before they were added to a RejectedPatches list.
	//
	// If ALLOW_AS_DEPENDENCY is the specified option for RejectedPatchesAction,
	// the value of InstalledRejectedCount will always be 0 (zero).
	InstalledRejectedCount *int64 `type:"integer"`

	// The ID of the managed instance the high-level patch compliance information
	// was collected for.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`

	// The time of the last attempt to patch the instance with NoReboot specified
	// as the reboot option.
	LastNoRebootInstallOperationTime *time.Time `type:"timestamp"`

	// The number of patches from the patch baseline that are applicable for the
	// instance but aren't currently installed.
	MissingCount *int64 `type:"integer"`

	// The number of patches from the patch baseline that aren't applicable for
	// the instance and therefore aren't installed on the instance. This number
	// may be truncated if the list of patch names is very large. The number of
	// patches beyond this limit are reported in UnreportedNotApplicableCount.
	NotApplicableCount *int64 `type:"integer"`

	// The type of patching operation that was performed: SCAN (assess patch compliance
	// state) or INSTALL (install missing patches).
	//
	// Operation is a required field
	Operation PatchOperationType `type:"string" required:"true" enum:"true"`

	// The time the most recent patching operation completed on the instance.
	//
	// OperationEndTime is a required field
	OperationEndTime *time.Time `type:"timestamp" required:"true"`

	// The time the most recent patching operation was started on the instance.
	//
	// OperationStartTime is a required field
	OperationStartTime *time.Time `type:"timestamp" required:"true"`

	// Placeholder information. This field will always be empty in the current release
	// of the service.
	OwnerInformation *string `min:"1" type:"string" sensitive:"true"`

	// The name of the patch group the managed instance belongs to.
	//
	// PatchGroup is a required field
	PatchGroup *string `min:"1" type:"string" required:"true"`

	// Indicates the reboot option specified in the patch baseline.
	//
	// Reboot options apply to Install operations only. Reboots are not attempted
	// for Patch Manager Scan operations.
	//
	//    * RebootIfNeeded: Patch Manager tries to reboot the instance if it installed
	//    any patches, or if any patches are detected with a status of InstalledPendingReboot.
	//
	//    * NoReboot: Patch Manager attempts to install missing packages without
	//    trying to reboot the system. Patches installed with this option are assigned
	//    a status of InstalledPendingReboot. These patches might not be in effect
	//    until a reboot is performed.
	RebootOption RebootOption `type:"string" enum:"true"`

	// The ID of the patch baseline snapshot used during the patching operation
	// when this compliance data was collected.
	SnapshotId *string `min:"36" type:"string"`

	// The number of patches beyond the supported limit of NotApplicableCount that
	// are not reported by name to Systems Manager Inventory.
	UnreportedNotApplicableCount *int64 `type:"integer"`
}

// String returns the string representation
func (s InstancePatchState) String() string {
	return awsutil.Prettify(s)
}

// Defines a filter used in DescribeInstancePatchStatesForPatchGroup used to
// scope down the information returned by the API.
type InstancePatchStateFilter struct {
	_ struct{} `type:"structure"`

	// The key for the filter. Supported values are FailedCount, InstalledCount,
	// InstalledOtherCount, MissingCount and NotApplicableCount.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The type of comparison that should be performed for the value: Equal, NotEqual,
	// LessThan or GreaterThan.
	//
	// Type is a required field
	Type InstancePatchStateOperatorType `type:"string" required:"true" enum:"true"`

	// The value for the filter, must be an integer greater than or equal to 0.
	//
	// Values is a required field
	Values []string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s InstancePatchStateFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InstancePatchStateFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InstancePatchStateFilter"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if s.Values == nil {
		invalidParams.Add(aws.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies the inventory type and attribute for the aggregation execution.
type InventoryAggregator struct {
	_ struct{} `type:"structure"`

	// Nested aggregators to further refine aggregation for an inventory type.
	Aggregators []InventoryAggregator `min:"1" type:"list"`

	// The inventory type and attribute name for aggregation.
	Expression *string `min:"1" type:"string"`

	// A user-defined set of one or more filters on which to aggregate inventory
	// data. Groups return a count of resources that match and don't match the specified
	// criteria.
	Groups []InventoryGroup `min:"1" type:"list"`
}

// String returns the string representation
func (s InventoryAggregator) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InventoryAggregator) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InventoryAggregator"}
	if s.Aggregators != nil && len(s.Aggregators) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Aggregators", 1))
	}
	if s.Expression != nil && len(*s.Expression) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Expression", 1))
	}
	if s.Groups != nil && len(s.Groups) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Groups", 1))
	}
	if s.Aggregators != nil {
		for i, v := range s.Aggregators {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Aggregators", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Groups != nil {
		for i, v := range s.Groups {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Groups", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Status information returned by the DeleteInventory action.
type InventoryDeletionStatusItem struct {
	_ struct{} `type:"structure"`

	// The deletion ID returned by the DeleteInventory action.
	DeletionId *string `type:"string"`

	// The UTC timestamp when the delete operation started.
	DeletionStartTime *time.Time `type:"timestamp"`

	// Information about the delete operation. For more information about this summary,
	// see Understanding the delete inventory summary (https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-custom.html#sysman-inventory-delete)
	// in the AWS Systems Manager User Guide.
	DeletionSummary *InventoryDeletionSummary `type:"structure"`

	// The status of the operation. Possible values are InProgress and Complete.
	LastStatus InventoryDeletionStatus `type:"string" enum:"true"`

	// Information about the status.
	LastStatusMessage *string `type:"string"`

	// The UTC timestamp of when the last status report.
	LastStatusUpdateTime *time.Time `type:"timestamp"`

	// The name of the inventory data type.
	TypeName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s InventoryDeletionStatusItem) String() string {
	return awsutil.Prettify(s)
}

// Information about the delete operation.
type InventoryDeletionSummary struct {
	_ struct{} `type:"structure"`

	// Remaining number of items to delete.
	RemainingCount *int64 `type:"integer"`

	// A list of counts and versions for deleted items.
	SummaryItems []InventoryDeletionSummaryItem `type:"list"`

	// The total number of items to delete. This count does not change during the
	// delete operation.
	TotalCount *int64 `type:"integer"`
}

// String returns the string representation
func (s InventoryDeletionSummary) String() string {
	return awsutil.Prettify(s)
}

// Either a count, remaining count, or a version number in a delete inventory
// summary.
type InventoryDeletionSummaryItem struct {
	_ struct{} `type:"structure"`

	// A count of the number of deleted items.
	Count *int64 `type:"integer"`

	// The remaining number of items to delete.
	RemainingCount *int64 `type:"integer"`

	// The inventory type version.
	Version *string `type:"string"`
}

// String returns the string representation
func (s InventoryDeletionSummaryItem) String() string {
	return awsutil.Prettify(s)
}

// One or more filters. Use a filter to return a more specific list of results.
type InventoryFilter struct {
	_ struct{} `type:"structure"`

	// The name of the filter key.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The type of filter.
	//
	// The Exists filter must be used with aggregators. For more information, see
	// Aggregating inventory data (https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-aggregate.html)
	// in the AWS Systems Manager User Guide.
	Type InventoryQueryOperatorType `type:"string" enum:"true"`

	// Inventory filter values. Example: inventory filter where instance IDs are
	// specified as values Key=AWS:InstanceInformation.InstanceId,Values= i-a12b3c4d5e6g,
	// i-1a2b3c4d5e6,Type=Equal
	//
	// Values is a required field
	Values []string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s InventoryFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InventoryFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InventoryFilter"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if s.Values == nil {
		invalidParams.Add(aws.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A user-defined set of one or more filters on which to aggregate inventory
// data. Groups return a count of resources that match and don't match the specified
// criteria.
type InventoryGroup struct {
	_ struct{} `type:"structure"`

	// Filters define the criteria for the group. The matchingCount field displays
	// the number of resources that match the criteria. The notMatchingCount field
	// displays the number of resources that don't match the criteria.
	//
	// Filters is a required field
	Filters []InventoryFilter `min:"1" type:"list" required:"true"`

	// The name of the group.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s InventoryGroup) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InventoryGroup) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InventoryGroup"}

	if s.Filters == nil {
		invalidParams.Add(aws.NewErrParamRequired("Filters"))
	}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Filters", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information collected from managed instances based on your inventory policy
// document
type InventoryItem struct {
	_ struct{} `type:"structure"`

	// The time the inventory information was collected.
	//
	// CaptureTime is a required field
	CaptureTime *string `type:"string" required:"true"`

	// The inventory data of the inventory type.
	Content []map[string]string `type:"list"`

	// MD5 hash of the inventory item type contents. The content hash is used to
	// determine whether to update inventory information. The PutInventory API does
	// not update the inventory item type contents if the MD5 hash has not changed
	// since last update.
	ContentHash *string `type:"string"`

	// A map of associated properties for a specified inventory type. For example,
	// with this attribute, you can specify the ExecutionId, ExecutionType, ComplianceType
	// properties of the AWS:ComplianceItem type.
	Context map[string]string `type:"map"`

	// The schema version for the inventory item.
	//
	// SchemaVersion is a required field
	SchemaVersion *string `type:"string" required:"true"`

	// The name of the inventory type. Default inventory item type names start with
	// AWS. Custom inventory type names will start with Custom. Default inventory
	// item types include the following: AWS:AWSComponent, AWS:Application, AWS:InstanceInformation,
	// AWS:Network, and AWS:WindowsUpdate.
	//
	// TypeName is a required field
	TypeName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s InventoryItem) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InventoryItem) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InventoryItem"}

	if s.CaptureTime == nil {
		invalidParams.Add(aws.NewErrParamRequired("CaptureTime"))
	}

	if s.SchemaVersion == nil {
		invalidParams.Add(aws.NewErrParamRequired("SchemaVersion"))
	}

	if s.TypeName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TypeName"))
	}
	if s.TypeName != nil && len(*s.TypeName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TypeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Attributes are the entries within the inventory item content. It contains
// name and value.
type InventoryItemAttribute struct {
	_ struct{} `type:"structure"`

	// The data type of the inventory item attribute.
	//
	// DataType is a required field
	DataType InventoryAttributeDataType `type:"string" required:"true" enum:"true"`

	// Name of the inventory item attribute.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s InventoryItemAttribute) String() string {
	return awsutil.Prettify(s)
}

// The inventory item schema definition. Users can use this to compose inventory
// query filters.
type InventoryItemSchema struct {
	_ struct{} `type:"structure"`

	// The schema attributes for inventory. This contains data type and attribute
	// name.
	//
	// Attributes is a required field
	Attributes []InventoryItemAttribute `min:"1" type:"list" required:"true"`

	// The alias name of the inventory type. The alias name is used for display
	// purposes.
	DisplayName *string `type:"string"`

	// The name of the inventory type. Default inventory item type names start with
	// AWS. Custom inventory type names will start with Custom. Default inventory
	// item types include the following: AWS:AWSComponent, AWS:Application, AWS:InstanceInformation,
	// AWS:Network, and AWS:WindowsUpdate.
	//
	// TypeName is a required field
	TypeName *string `min:"1" type:"string" required:"true"`

	// The schema version for the inventory item.
	Version *string `type:"string"`
}

// String returns the string representation
func (s InventoryItemSchema) String() string {
	return awsutil.Prettify(s)
}

// Inventory query results.
type InventoryResultEntity struct {
	_ struct{} `type:"structure"`

	// The data section in the inventory result entity JSON.
	Data map[string]InventoryResultItem `type:"map"`

	// ID of the inventory result entity. For example, for managed instance inventory
	// the result will be the managed instance ID. For EC2 instance inventory, the
	// result will be the instance ID.
	Id *string `type:"string"`
}

// String returns the string representation
func (s InventoryResultEntity) String() string {
	return awsutil.Prettify(s)
}

// The inventory result item.
type InventoryResultItem struct {
	_ struct{} `type:"structure"`

	// The time inventory item data was captured.
	CaptureTime *string `type:"string"`

	// Contains all the inventory data of the item type. Results include attribute
	// names and values.
	//
	// Content is a required field
	Content []map[string]string `type:"list" required:"true"`

	// MD5 hash of the inventory item type contents. The content hash is used to
	// determine whether to update inventory information. The PutInventory API does
	// not update the inventory item type contents if the MD5 hash has not changed
	// since last update.
	ContentHash *string `type:"string"`

	// The schema version for the inventory result item/
	//
	// SchemaVersion is a required field
	SchemaVersion *string `type:"string" required:"true"`

	// The name of the inventory result item type.
	//
	// TypeName is a required field
	TypeName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s InventoryResultItem) String() string {
	return awsutil.Prettify(s)
}

// Information about an S3 bucket to write instance-level logs to.
//
// LoggingInfo has been deprecated. To specify an S3 bucket to contain logs,
// instead use the OutputS3BucketName and OutputS3KeyPrefix options in the TaskInvocationParameters
// structure. For information about how Systems Manager handles these options
// for the supported maintenance window task types, see MaintenanceWindowTaskInvocationParameters.
type LoggingInfo struct {
	_ struct{} `type:"structure"`

	// The name of an S3 bucket where execution logs are stored .
	//
	// S3BucketName is a required field
	S3BucketName *string `min:"3" type:"string" required:"true"`

	// (Optional) The S3 bucket subfolder.
	S3KeyPrefix *string `type:"string"`

	// The Region where the S3 bucket is located.
	//
	// S3Region is a required field
	S3Region *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s LoggingInfo) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LoggingInfo) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LoggingInfo"}

	if s.S3BucketName == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3BucketName"))
	}
	if s.S3BucketName != nil && len(*s.S3BucketName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("S3BucketName", 3))
	}

	if s.S3Region == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3Region"))
	}
	if s.S3Region != nil && len(*s.S3Region) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("S3Region", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The parameters for an AUTOMATION task type.
type MaintenanceWindowAutomationParameters struct {
	_ struct{} `type:"structure"`

	// The version of an Automation document to use during task execution.
	DocumentVersion *string `type:"string"`

	// The parameters for the AUTOMATION task.
	//
	// For information about specifying and updating task parameters, see RegisterTaskWithMaintenanceWindow
	// and UpdateMaintenanceWindowTask.
	//
	// LoggingInfo has been deprecated. To specify an S3 bucket to contain logs,
	// instead use the OutputS3BucketName and OutputS3KeyPrefix options in the TaskInvocationParameters
	// structure. For information about how Systems Manager handles these options
	// for the supported maintenance window task types, see MaintenanceWindowTaskInvocationParameters.
	//
	// TaskParameters has been deprecated. To specify parameters to pass to a task
	// when it runs, instead use the Parameters option in the TaskInvocationParameters
	// structure. For information about how Systems Manager handles these options
	// for the supported maintenance window task types, see MaintenanceWindowTaskInvocationParameters.
	//
	// For AUTOMATION task types, Systems Manager ignores any values specified for
	// these parameters.
	Parameters map[string][]string `min:"1" type:"map"`
}

// String returns the string representation
func (s MaintenanceWindowAutomationParameters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MaintenanceWindowAutomationParameters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MaintenanceWindowAutomationParameters"}
	if s.Parameters != nil && len(s.Parameters) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Parameters", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the information about an execution of a maintenance window.
type MaintenanceWindowExecution struct {
	_ struct{} `type:"structure"`

	// The time the execution finished.
	EndTime *time.Time `type:"timestamp"`

	// The time the execution started.
	StartTime *time.Time `type:"timestamp"`

	// The status of the execution.
	Status MaintenanceWindowExecutionStatus `type:"string" enum:"true"`

	// The details explaining the Status. Only available for certain status values.
	StatusDetails *string `type:"string"`

	// The ID of the maintenance window execution.
	WindowExecutionId *string `min:"36" type:"string"`

	// The ID of the maintenance window.
	WindowId *string `min:"20" type:"string"`
}

// String returns the string representation
func (s MaintenanceWindowExecution) String() string {
	return awsutil.Prettify(s)
}

// Information about a task execution performed as part of a maintenance window
// execution.
type MaintenanceWindowExecutionTaskIdentity struct {
	_ struct{} `type:"structure"`

	// The time the task execution finished.
	EndTime *time.Time `type:"timestamp"`

	// The time the task execution started.
	StartTime *time.Time `type:"timestamp"`

	// The status of the task execution.
	Status MaintenanceWindowExecutionStatus `type:"string" enum:"true"`

	// The details explaining the status of the task execution. Only available for
	// certain status values.
	StatusDetails *string `type:"string"`

	// The ARN of the task that ran.
	TaskArn *string `min:"1" type:"string"`

	// The ID of the specific task execution in the maintenance window execution.
	TaskExecutionId *string `min:"36" type:"string"`

	// The type of task that ran.
	TaskType MaintenanceWindowTaskType `type:"string" enum:"true"`

	// The ID of the maintenance window execution that ran the task.
	WindowExecutionId *string `min:"36" type:"string"`
}

// String returns the string representation
func (s MaintenanceWindowExecutionTaskIdentity) String() string {
	return awsutil.Prettify(s)
}

// Describes the information about a task invocation for a particular target
// as part of a task execution performed as part of a maintenance window execution.
type MaintenanceWindowExecutionTaskInvocationIdentity struct {
	_ struct{} `type:"structure"`

	// The time the invocation finished.
	EndTime *time.Time `type:"timestamp"`

	// The ID of the action performed in the service that actually handled the task
	// invocation. If the task type is RUN_COMMAND, this value is the command ID.
	ExecutionId *string `type:"string"`

	// The ID of the task invocation.
	InvocationId *string `min:"36" type:"string"`

	// User-provided value that was specified when the target was registered with
	// the maintenance window. This was also included in any CloudWatch events raised
	// during the task invocation.
	OwnerInformation *string `min:"1" type:"string" sensitive:"true"`

	// The parameters that were provided for the invocation when it was run.
	Parameters *string `type:"string" sensitive:"true"`

	// The time the invocation started.
	StartTime *time.Time `type:"timestamp"`

	// The status of the task invocation.
	Status MaintenanceWindowExecutionStatus `type:"string" enum:"true"`

	// The details explaining the status of the task invocation. Only available
	// for certain Status values.
	StatusDetails *string `type:"string"`

	// The ID of the specific task execution in the maintenance window execution.
	TaskExecutionId *string `min:"36" type:"string"`

	// The task type.
	TaskType MaintenanceWindowTaskType `type:"string" enum:"true"`

	// The ID of the maintenance window execution that ran the task.
	WindowExecutionId *string `min:"36" type:"string"`

	// The ID of the target definition in this maintenance window the invocation
	// was performed for.
	WindowTargetId *string `type:"string"`
}

// String returns the string representation
func (s MaintenanceWindowExecutionTaskInvocationIdentity) String() string {
	return awsutil.Prettify(s)
}

// Filter used in the request. Supported filter keys are Name and Enabled.
type MaintenanceWindowFilter struct {
	_ struct{} `type:"structure"`

	// The name of the filter.
	Key *string `min:"1" type:"string"`

	// The filter values.
	Values []string `type:"list"`
}

// String returns the string representation
func (s MaintenanceWindowFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MaintenanceWindowFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MaintenanceWindowFilter"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about the maintenance window.
type MaintenanceWindowIdentity struct {
	_ struct{} `type:"structure"`

	// The number of hours before the end of the maintenance window that Systems
	// Manager stops scheduling new tasks for execution.
	Cutoff *int64 `type:"integer"`

	// A description of the maintenance window.
	Description *string `min:"1" type:"string" sensitive:"true"`

	// The duration of the maintenance window in hours.
	Duration *int64 `min:"1" type:"integer"`

	// Indicates whether the maintenance window is enabled.
	Enabled *bool `type:"boolean"`

	// The date and time, in ISO-8601 Extended format, for when the maintenance
	// window is scheduled to become inactive.
	EndDate *string `type:"string"`

	// The name of the maintenance window.
	Name *string `min:"3" type:"string"`

	// The next time the maintenance window will actually run, taking into account
	// any specified times for the maintenance window to become active or inactive.
	NextExecutionTime *string `type:"string"`

	// The schedule of the maintenance window in the form of a cron or rate expression.
	Schedule *string `min:"1" type:"string"`

	// The number of days to wait to run a maintenance window after the scheduled
	// CRON expression date and time.
	ScheduleOffset *int64 `min:"1" type:"integer"`

	// The time zone that the scheduled maintenance window executions are based
	// on, in Internet Assigned Numbers Authority (IANA) format.
	ScheduleTimezone *string `type:"string"`

	// The date and time, in ISO-8601 Extended format, for when the maintenance
	// window is scheduled to become active.
	StartDate *string `type:"string"`

	// The ID of the maintenance window.
	WindowId *string `min:"20" type:"string"`
}

// String returns the string representation
func (s MaintenanceWindowIdentity) String() string {
	return awsutil.Prettify(s)
}

// The maintenance window to which the specified target belongs.
type MaintenanceWindowIdentityForTarget struct {
	_ struct{} `type:"structure"`

	// The name of the maintenance window.
	Name *string `min:"3" type:"string"`

	// The ID of the maintenance window.
	WindowId *string `min:"20" type:"string"`
}

// String returns the string representation
func (s MaintenanceWindowIdentityForTarget) String() string {
	return awsutil.Prettify(s)
}

// The parameters for a LAMBDA task type.
//
// For information about specifying and updating task parameters, see RegisterTaskWithMaintenanceWindow
// and UpdateMaintenanceWindowTask.
//
// LoggingInfo has been deprecated. To specify an S3 bucket to contain logs,
// instead use the OutputS3BucketName and OutputS3KeyPrefix options in the TaskInvocationParameters
// structure. For information about how Systems Manager handles these options
// for the supported maintenance window task types, see MaintenanceWindowTaskInvocationParameters.
//
// TaskParameters has been deprecated. To specify parameters to pass to a task
// when it runs, instead use the Parameters option in the TaskInvocationParameters
// structure. For information about how Systems Manager handles these options
// for the supported maintenance window task types, see MaintenanceWindowTaskInvocationParameters.
//
// For Lambda tasks, Systems Manager ignores any values specified for TaskParameters
// and LoggingInfo.
type MaintenanceWindowLambdaParameters struct {
	_ struct{} `type:"structure"`

	// Pass client-specific information to the Lambda function that you are invoking.
	// You can then process the client information in your Lambda function as you
	// choose through the context variable.
	ClientContext *string `min:"1" type:"string"`

	// JSON to provide to your Lambda function as input.
	//
	// Payload is automatically base64 encoded/decoded by the SDK.
	Payload []byte `type:"blob" sensitive:"true"`

	// (Optional) Specify a Lambda function version or alias name. If you specify
	// a function version, the action uses the qualified function ARN to invoke
	// a specific Lambda function. If you specify an alias name, the action uses
	// the alias ARN to invoke the Lambda function version to which the alias points.
	Qualifier *string `min:"1" type:"string"`
}

// String returns the string representation
func (s MaintenanceWindowLambdaParameters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MaintenanceWindowLambdaParameters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MaintenanceWindowLambdaParameters"}
	if s.ClientContext != nil && len(*s.ClientContext) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientContext", 1))
	}
	if s.Qualifier != nil && len(*s.Qualifier) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Qualifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The parameters for a RUN_COMMAND task type.
//
// For information about specifying and updating task parameters, see RegisterTaskWithMaintenanceWindow
// and UpdateMaintenanceWindowTask.
//
// LoggingInfo has been deprecated. To specify an S3 bucket to contain logs,
// instead use the OutputS3BucketName and OutputS3KeyPrefix options in the TaskInvocationParameters
// structure. For information about how Systems Manager handles these options
// for the supported maintenance window task types, see MaintenanceWindowTaskInvocationParameters.
//
// TaskParameters has been deprecated. To specify parameters to pass to a task
// when it runs, instead use the Parameters option in the TaskInvocationParameters
// structure. For information about how Systems Manager handles these options
// for the supported maintenance window task types, see MaintenanceWindowTaskInvocationParameters.
//
// For Run Command tasks, Systems Manager uses specified values for TaskParameters
// and LoggingInfo only if no values are specified for TaskInvocationParameters.
type MaintenanceWindowRunCommandParameters struct {
	_ struct{} `type:"structure"`

	// Configuration options for sending command output to CloudWatch Logs.
	CloudWatchOutputConfig *CloudWatchOutputConfig `type:"structure"`

	// Information about the commands to run.
	Comment *string `type:"string"`

	// The SHA-256 or SHA-1 hash created by the system when the document was created.
	// SHA-1 hashes have been deprecated.
	DocumentHash *string `type:"string"`

	// SHA-256 or SHA-1. SHA-1 hashes have been deprecated.
	DocumentHashType DocumentHashType `type:"string" enum:"true"`

	// The SSM document version to use in the request. You can specify $DEFAULT,
	// $LATEST, or a specific version number. If you run commands by using the AWS
	// CLI, then you must escape the first two options by using a backslash. If
	// you specify a version number, then you don't need to use the backslash. For
	// example:
	//
	// --document-version "\$DEFAULT"
	//
	// --document-version "\$LATEST"
	//
	// --document-version "3"
	DocumentVersion *string `type:"string"`

	// Configurations for sending notifications about command status changes on
	// a per-instance basis.
	NotificationConfig *NotificationConfig `type:"structure"`

	// The name of the S3 bucket.
	OutputS3BucketName *string `min:"3" type:"string"`

	// The S3 bucket subfolder.
	OutputS3KeyPrefix *string `type:"string"`

	// The parameters for the RUN_COMMAND task execution.
	Parameters map[string][]string `type:"map"`

	// The ARN of the IAM service role to use to publish Amazon Simple Notification
	// Service (Amazon SNS) notifications for maintenance window Run Command tasks.
	ServiceRoleArn *string `type:"string"`

	// If this time is reached and the command has not already started running,
	// it doesn't run.
	TimeoutSeconds *int64 `min:"30" type:"integer"`
}

// String returns the string representation
func (s MaintenanceWindowRunCommandParameters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MaintenanceWindowRunCommandParameters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MaintenanceWindowRunCommandParameters"}
	if s.OutputS3BucketName != nil && len(*s.OutputS3BucketName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("OutputS3BucketName", 3))
	}
	if s.TimeoutSeconds != nil && *s.TimeoutSeconds < 30 {
		invalidParams.Add(aws.NewErrParamMinValue("TimeoutSeconds", 30))
	}
	if s.CloudWatchOutputConfig != nil {
		if err := s.CloudWatchOutputConfig.Validate(); err != nil {
			invalidParams.AddNested("CloudWatchOutputConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The parameters for a STEP_FUNCTIONS task.
//
// For information about specifying and updating task parameters, see RegisterTaskWithMaintenanceWindow
// and UpdateMaintenanceWindowTask.
//
// LoggingInfo has been deprecated. To specify an S3 bucket to contain logs,
// instead use the OutputS3BucketName and OutputS3KeyPrefix options in the TaskInvocationParameters
// structure. For information about how Systems Manager handles these options
// for the supported maintenance window task types, see MaintenanceWindowTaskInvocationParameters.
//
// TaskParameters has been deprecated. To specify parameters to pass to a task
// when it runs, instead use the Parameters option in the TaskInvocationParameters
// structure. For information about how Systems Manager handles these options
// for the supported maintenance window task types, see MaintenanceWindowTaskInvocationParameters.
//
// For Step Functions tasks, Systems Manager ignores any values specified for
// TaskParameters and LoggingInfo.
type MaintenanceWindowStepFunctionsParameters struct {
	_ struct{} `type:"structure"`

	// The inputs for the STEP_FUNCTIONS task.
	Input *string `type:"string" sensitive:"true"`

	// The name of the STEP_FUNCTIONS task.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s MaintenanceWindowStepFunctionsParameters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MaintenanceWindowStepFunctionsParameters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MaintenanceWindowStepFunctionsParameters"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The target registered with the maintenance window.
type MaintenanceWindowTarget struct {
	_ struct{} `type:"structure"`

	// A description for the target.
	Description *string `min:"1" type:"string" sensitive:"true"`

	// The name for the maintenance window target.
	Name *string `min:"3" type:"string"`

	// A user-provided value that will be included in any CloudWatch events that
	// are raised while running tasks for these targets in this maintenance window.
	OwnerInformation *string `min:"1" type:"string" sensitive:"true"`

	// The type of target that is being registered with the maintenance window.
	ResourceType MaintenanceWindowResourceType `type:"string" enum:"true"`

	// The targets, either instances or tags.
	//
	// Specify instances using the following format:
	//
	// Key=instanceids,Values=<instanceid1>,<instanceid2>
	//
	// Tags are specified using the following format:
	//
	// Key=<tag name>,Values=<tag value>.
	Targets []Target `type:"list"`

	// The ID of the maintenance window to register the target with.
	WindowId *string `min:"20" type:"string"`

	// The ID of the target.
	WindowTargetId *string `min:"36" type:"string"`
}

// String returns the string representation
func (s MaintenanceWindowTarget) String() string {
	return awsutil.Prettify(s)
}

// Information about a task defined for a maintenance window.
type MaintenanceWindowTask struct {
	_ struct{} `type:"structure"`

	// A description of the task.
	Description *string `min:"1" type:"string" sensitive:"true"`

	// Information about an S3 bucket to write task-level logs to.
	//
	// LoggingInfo has been deprecated. To specify an S3 bucket to contain logs,
	// instead use the OutputS3BucketName and OutputS3KeyPrefix options in the TaskInvocationParameters
	// structure. For information about how Systems Manager handles these options
	// for the supported maintenance window task types, see MaintenanceWindowTaskInvocationParameters.
	LoggingInfo *LoggingInfo `type:"structure"`

	// The maximum number of targets this task can be run for, in parallel.
	MaxConcurrency *string `min:"1" type:"string"`

	// The maximum number of errors allowed before this task stops being scheduled.
	MaxErrors *string `min:"1" type:"string"`

	// The task name.
	Name *string `min:"3" type:"string"`

	// The priority of the task in the maintenance window. The lower the number,
	// the higher the priority. Tasks that have the same priority are scheduled
	// in parallel.
	Priority *int64 `type:"integer"`

	// The ARN of the IAM service role to use to publish Amazon Simple Notification
	// Service (Amazon SNS) notifications for maintenance window Run Command tasks.
	ServiceRoleArn *string `type:"string"`

	// The targets (either instances or tags). Instances are specified using Key=instanceids,Values=<instanceid1>,<instanceid2>.
	// Tags are specified using Key=<tag name>,Values=<tag value>.
	Targets []Target `type:"list"`

	// The resource that the task uses during execution. For RUN_COMMAND and AUTOMATION
	// task types, TaskArn is the Systems Manager document name or ARN. For LAMBDA
	// tasks, it's the function name or ARN. For STEP_FUNCTIONS tasks, it's the
	// state machine ARN.
	TaskArn *string `min:"1" type:"string"`

	// The parameters that should be passed to the task when it is run.
	//
	// TaskParameters has been deprecated. To specify parameters to pass to a task
	// when it runs, instead use the Parameters option in the TaskInvocationParameters
	// structure. For information about how Systems Manager handles these options
	// for the supported maintenance window task types, see MaintenanceWindowTaskInvocationParameters.
	TaskParameters map[string]MaintenanceWindowTaskParameterValueExpression `type:"map" sensitive:"true"`

	// The type of task. The type can be one of the following: RUN_COMMAND, AUTOMATION,
	// LAMBDA, or STEP_FUNCTIONS.
	Type MaintenanceWindowTaskType `type:"string" enum:"true"`

	// The ID of the maintenance window where the task is registered.
	WindowId *string `min:"20" type:"string"`

	// The task ID.
	WindowTaskId *string `min:"36" type:"string"`
}

// String returns the string representation
func (s MaintenanceWindowTask) String() string {
	return awsutil.Prettify(s)
}

// The parameters for task execution.
type MaintenanceWindowTaskInvocationParameters struct {
	_ struct{} `type:"structure"`

	// The parameters for an AUTOMATION task type.
	Automation *MaintenanceWindowAutomationParameters `type:"structure"`

	// The parameters for a LAMBDA task type.
	Lambda *MaintenanceWindowLambdaParameters `type:"structure"`

	// The parameters for a RUN_COMMAND task type.
	RunCommand *MaintenanceWindowRunCommandParameters `type:"structure"`

	// The parameters for a STEP_FUNCTIONS task type.
	StepFunctions *MaintenanceWindowStepFunctionsParameters `type:"structure"`
}

// String returns the string representation
func (s MaintenanceWindowTaskInvocationParameters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MaintenanceWindowTaskInvocationParameters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MaintenanceWindowTaskInvocationParameters"}
	if s.Automation != nil {
		if err := s.Automation.Validate(); err != nil {
			invalidParams.AddNested("Automation", err.(aws.ErrInvalidParams))
		}
	}
	if s.Lambda != nil {
		if err := s.Lambda.Validate(); err != nil {
			invalidParams.AddNested("Lambda", err.(aws.ErrInvalidParams))
		}
	}
	if s.RunCommand != nil {
		if err := s.RunCommand.Validate(); err != nil {
			invalidParams.AddNested("RunCommand", err.(aws.ErrInvalidParams))
		}
	}
	if s.StepFunctions != nil {
		if err := s.StepFunctions.Validate(); err != nil {
			invalidParams.AddNested("StepFunctions", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Defines the values for a task parameter.
type MaintenanceWindowTaskParameterValueExpression struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// This field contains an array of 0 or more strings, each 1 to 255 characters
	// in length.
	Values []string `type:"list" sensitive:"true"`
}

// String returns the string representation
func (s MaintenanceWindowTaskParameterValueExpression) String() string {
	return awsutil.Prettify(s)
}

// A summary of resources that are not compliant. The summary is organized according
// to resource type.
type NonCompliantSummary struct {
	_ struct{} `type:"structure"`

	// The total number of compliance items that are not compliant.
	NonCompliantCount *int64 `type:"integer"`

	// A summary of the non-compliance severity by compliance type
	SeveritySummary *SeveritySummary `type:"structure"`
}

// String returns the string representation
func (s NonCompliantSummary) String() string {
	return awsutil.Prettify(s)
}

// Configurations for sending notifications.
type NotificationConfig struct {
	_ struct{} `type:"structure"`

	// An Amazon Resource Name (ARN) for an Amazon Simple Notification Service (Amazon
	// SNS) topic. Run Command pushes notifications about command status changes
	// to this topic.
	NotificationArn *string `type:"string"`

	// The different events for which you can receive notifications. These events
	// include the following: All (events), InProgress, Success, TimedOut, Cancelled,
	// Failed. To learn more about these events, see Monitoring Systems Manager
	// status changes using Amazon SNS notifications (https://docs.aws.amazon.com/systems-manager/latest/userguide/monitoring-sns-notifications.html)
	// in the AWS Systems Manager User Guide.
	NotificationEvents []NotificationEvent `type:"list"`

	// Command: Receive notification when the status of a command changes. Invocation:
	// For commands sent to multiple instances, receive notification on a per-instance
	// basis when the status of a command changes.
	NotificationType NotificationType `type:"string" enum:"true"`
}

// String returns the string representation
func (s NotificationConfig) String() string {
	return awsutil.Prettify(s)
}

// One or more aggregators for viewing counts of OpsItems using different dimensions
// such as Source, CreatedTime, or Source and CreatedTime, to name a few.
type OpsAggregator struct {
	_ struct{} `type:"structure"`

	// Either a Range or Count aggregator for limiting an OpsItem summary.
	AggregatorType *string `min:"1" type:"string"`

	// A nested aggregator for viewing counts of OpsItems.
	Aggregators []OpsAggregator `min:"1" type:"list"`

	// The name of an OpsItem attribute on which to limit the count of OpsItems.
	AttributeName *string `type:"string"`

	// The aggregator filters.
	Filters []OpsFilter `min:"1" type:"list"`

	// The data type name to use for viewing counts of OpsItems.
	TypeName *string `min:"1" type:"string"`

	// The aggregator value.
	Values map[string]string `type:"map"`
}

// String returns the string representation
func (s OpsAggregator) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OpsAggregator) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "OpsAggregator"}
	if s.AggregatorType != nil && len(*s.AggregatorType) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AggregatorType", 1))
	}
	if s.Aggregators != nil && len(s.Aggregators) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Aggregators", 1))
	}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Filters", 1))
	}
	if s.TypeName != nil && len(*s.TypeName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TypeName", 1))
	}
	if s.Aggregators != nil {
		for i, v := range s.Aggregators {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Aggregators", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of the query.
type OpsEntity struct {
	_ struct{} `type:"structure"`

	// The data returned by the query.
	Data map[string]OpsEntityItem `type:"map"`

	// The query ID.
	Id *string `type:"string"`
}

// String returns the string representation
func (s OpsEntity) String() string {
	return awsutil.Prettify(s)
}

// The OpsItem summaries result item.
type OpsEntityItem struct {
	_ struct{} `type:"structure"`

	// The time OpsItem data was captured.
	CaptureTime *string `type:"string"`

	// The detailed data content for an OpsItem summaries result item.
	Content []map[string]string `type:"list"`
}

// String returns the string representation
func (s OpsEntityItem) String() string {
	return awsutil.Prettify(s)
}

// A filter for viewing OpsItem summaries.
type OpsFilter struct {
	_ struct{} `type:"structure"`

	// The name of the filter.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The type of filter.
	Type OpsFilterOperatorType `type:"string" enum:"true"`

	// The filter value.
	//
	// Values is a required field
	Values []string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s OpsFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OpsFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "OpsFilter"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if s.Values == nil {
		invalidParams.Add(aws.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Operations engineers and IT professionals use OpsCenter to view, investigate,
// and remediate operational issues impacting the performance and health of
// their AWS resources. For more information, see AWS Systems Manager OpsCenter
// (https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html)
// in the AWS Systems Manager User Guide.
type OpsItem struct {
	_ struct{} `type:"structure"`

	// An OpsItem category. Category options include: Availability, Cost, Performance,
	// Recovery, Security.
	Category *string `min:"1" type:"string"`

	// The ARN of the AWS account that created the OpsItem.
	CreatedBy *string `type:"string"`

	// The date and time the OpsItem was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The OpsItem description.
	Description *string `min:"1" type:"string"`

	// The ARN of the AWS account that last updated the OpsItem.
	LastModifiedBy *string `type:"string"`

	// The date and time the OpsItem was last updated.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of an SNS topic where notifications are sent
	// when this OpsItem is edited or changed.
	Notifications []OpsItemNotification `type:"list"`

	// Operational data is custom data that provides useful reference details about
	// the OpsItem. For example, you can specify log files, error strings, license
	// keys, troubleshooting tips, or other relevant data. You enter operational
	// data as key-value pairs. The key has a maximum length of 128 characters.
	// The value has a maximum size of 20 KB.
	//
	// Operational data keys can't begin with the following: amazon, aws, amzn,
	// ssm, /amazon, /aws, /amzn, /ssm.
	//
	// You can choose to make the data searchable by other users in the account
	// or you can restrict search access. Searchable data means that all users with
	// access to the OpsItem Overview page (as provided by the DescribeOpsItems
	// API action) can view and search on the specified data. Operational data that
	// is not searchable is only viewable by users who have access to the OpsItem
	// (as provided by the GetOpsItem API action).
	//
	// Use the /aws/resources key in OperationalData to specify a related resource
	// in the request. Use the /aws/automations key in OperationalData to associate
	// an Automation runbook with the OpsItem. To view AWS CLI example commands
	// that use these keys, see Creating OpsItems manually (https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-creating-OpsItems.html#OpsCenter-manually-create-OpsItems)
	// in the AWS Systems Manager User Guide.
	OperationalData map[string]OpsItemDataValue `type:"map"`

	// The ID of the OpsItem.
	OpsItemId *string `type:"string"`

	// The importance of this OpsItem in relation to other OpsItems in the system.
	Priority *int64 `min:"1" type:"integer"`

	// One or more OpsItems that share something in common with the current OpsItem.
	// For example, related OpsItems can include OpsItems with similar error messages,
	// impacted resources, or statuses for the impacted resource.
	RelatedOpsItems []RelatedOpsItem `type:"list"`

	// The severity of the OpsItem. Severity options range from 1 to 4.
	Severity *string `min:"1" type:"string"`

	// The origin of the OpsItem, such as Amazon EC2 or Systems Manager. The impacted
	// resource is a subset of source.
	Source *string `min:"1" type:"string"`

	// The OpsItem status. Status can be Open, In Progress, or Resolved. For more
	// information, see Editing OpsItem details (https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-working-with-OpsItems-editing-details.html)
	// in the AWS Systems Manager User Guide.
	Status OpsItemStatus `type:"string" enum:"true"`

	// A short heading that describes the nature of the OpsItem and the impacted
	// resource.
	Title *string `min:"1" type:"string"`

	// The version of this OpsItem. Each time the OpsItem is edited the version
	// number increments by one.
	Version *string `type:"string"`
}

// String returns the string representation
func (s OpsItem) String() string {
	return awsutil.Prettify(s)
}

// An object that defines the value of the key and its type in the OperationalData
// map.
type OpsItemDataValue struct {
	_ struct{} `type:"structure"`

	// The type of key-value pair. Valid types include SearchableString and String.
	Type OpsItemDataType `type:"string" enum:"true"`

	// The value of the OperationalData key.
	Value *string `type:"string"`
}

// String returns the string representation
func (s OpsItemDataValue) String() string {
	return awsutil.Prettify(s)
}

// Describes an OpsItem filter.
type OpsItemFilter struct {
	_ struct{} `type:"structure"`

	// The name of the filter.
	//
	// Key is a required field
	Key OpsItemFilterKey `type:"string" required:"true" enum:"true"`

	// The operator used by the filter call.
	//
	// Operator is a required field
	Operator OpsItemFilterOperator `type:"string" required:"true" enum:"true"`

	// The filter value.
	//
	// Values is a required field
	Values []string `type:"list" required:"true"`
}

// String returns the string representation
func (s OpsItemFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OpsItemFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "OpsItemFilter"}
	if len(s.Key) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if len(s.Operator) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Operator"))
	}

	if s.Values == nil {
		invalidParams.Add(aws.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A notification about the OpsItem.
type OpsItemNotification struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an SNS topic where notifications are sent
	// when this OpsItem is edited or changed.
	Arn *string `type:"string"`
}

// String returns the string representation
func (s OpsItemNotification) String() string {
	return awsutil.Prettify(s)
}

// A count of OpsItems.
type OpsItemSummary struct {
	_ struct{} `type:"structure"`

	// A list of OpsItems by category.
	Category *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the IAM entity that created the OpsItem.
	CreatedBy *string `type:"string"`

	// The date and time the OpsItem was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the IAM entity that created the OpsItem.
	LastModifiedBy *string `type:"string"`

	// The date and time the OpsItem was last updated.
	LastModifiedTime *time.Time `type:"timestamp"`

	// Operational data is custom data that provides useful reference details about
	// the OpsItem.
	OperationalData map[string]OpsItemDataValue `type:"map"`

	// The ID of the OpsItem.
	OpsItemId *string `type:"string"`

	// The importance of this OpsItem in relation to other OpsItems in the system.
	Priority *int64 `min:"1" type:"integer"`

	// A list of OpsItems by severity.
	Severity *string `min:"1" type:"string"`

	// The impacted AWS resource.
	Source *string `min:"1" type:"string"`

	// The OpsItem status. Status can be Open, In Progress, or Resolved.
	Status OpsItemStatus `type:"string" enum:"true"`

	// A short heading that describes the nature of the OpsItem and the impacted
	// resource.
	Title *string `min:"1" type:"string"`
}

// String returns the string representation
func (s OpsItemSummary) String() string {
	return awsutil.Prettify(s)
}

// The OpsItem data type to return.
type OpsResultAttribute struct {
	_ struct{} `type:"structure"`

	// Name of the data type. Valid value: AWS:OpsItem, AWS:EC2InstanceInformation,
	// AWS:OpsItemTrendline, or AWS:ComplianceSummary.
	//
	// TypeName is a required field
	TypeName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s OpsResultAttribute) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OpsResultAttribute) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "OpsResultAttribute"}

	if s.TypeName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TypeName"))
	}
	if s.TypeName != nil && len(*s.TypeName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TypeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about the source where the association execution details are
// stored.
type OutputSource struct {
	_ struct{} `type:"structure"`

	// The ID of the output source, for example the URL of an S3 bucket.
	OutputSourceId *string `min:"36" type:"string"`

	// The type of source where the association execution details are stored, for
	// example, Amazon S3.
	OutputSourceType *string `type:"string"`
}

// String returns the string representation
func (s OutputSource) String() string {
	return awsutil.Prettify(s)
}

// An Systems Manager parameter in Parameter Store.
type Parameter struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the parameter.
	ARN *string `type:"string"`

	// The data type of the parameter, such as text or aws:ec2:image. The default
	// is text.
	DataType *string `type:"string"`

	// Date the parameter was last changed or updated and the parameter version
	// was created.
	LastModifiedDate *time.Time `type:"timestamp"`

	// The name of the parameter.
	Name *string `min:"1" type:"string"`

	// Either the version number or the label used to retrieve the parameter value.
	// Specify selectors by using one of the following formats:
	//
	// parameter_name:version
	//
	// parameter_name:label
	Selector *string `type:"string"`

	// Applies to parameters that reference information in other AWS services. SourceResult
	// is the raw result or response from the source.
	SourceResult *string `type:"string"`

	// The type of parameter. Valid values include the following: String, StringList,
	// and SecureString.
	Type ParameterType `type:"string" enum:"true"`

	// The parameter value.
	Value *string `type:"string"`

	// The parameter version.
	Version *int64 `type:"long"`
}

// String returns the string representation
func (s Parameter) String() string {
	return awsutil.Prettify(s)
}

// Information about parameter usage.
type ParameterHistory struct {
	_ struct{} `type:"structure"`

	// Parameter names can include the following letters and symbols.
	//
	// a-zA-Z0-9_.-
	AllowedPattern *string `type:"string"`

	// The data type of the parameter, such as text or aws:ec2:image. The default
	// is text.
	DataType *string `type:"string"`

	// Information about the parameter.
	Description *string `type:"string"`

	// The ID of the query key used for this parameter.
	KeyId *string `min:"1" type:"string"`

	// Labels assigned to the parameter version.
	Labels []string `min:"1" type:"list"`

	// Date the parameter was last changed or updated.
	LastModifiedDate *time.Time `type:"timestamp"`

	// Amazon Resource Name (ARN) of the AWS user who last changed the parameter.
	LastModifiedUser *string `type:"string"`

	// The name of the parameter.
	Name *string `min:"1" type:"string"`

	// Information about the policies assigned to a parameter.
	//
	// Assigning parameter policies (https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-policies.html)
	// in the AWS Systems Manager User Guide.
	Policies []ParameterInlinePolicy `type:"list"`

	// The parameter tier.
	Tier ParameterTier `type:"string" enum:"true"`

	// The type of parameter used.
	Type ParameterType `type:"string" enum:"true"`

	// The parameter value.
	Value *string `type:"string"`

	// The parameter version.
	Version *int64 `type:"long"`
}

// String returns the string representation
func (s ParameterHistory) String() string {
	return awsutil.Prettify(s)
}

// One or more policies assigned to a parameter.
type ParameterInlinePolicy struct {
	_ struct{} `type:"structure"`

	// The status of the policy. Policies report the following statuses: Pending
	// (the policy has not been enforced or applied yet), Finished (the policy was
	// applied), Failed (the policy was not applied), or InProgress (the policy
	// is being applied now).
	PolicyStatus *string `type:"string"`

	// The JSON text of the policy.
	PolicyText *string `type:"string"`

	// The type of policy. Parameter Store supports the following policy types:
	// Expiration, ExpirationNotification, and NoChangeNotification.
	PolicyType *string `type:"string"`
}

// String returns the string representation
func (s ParameterInlinePolicy) String() string {
	return awsutil.Prettify(s)
}

// Metadata includes information like the ARN of the last user and the date/time
// the parameter was last used.
type ParameterMetadata struct {
	_ struct{} `type:"structure"`

	// A parameter name can include only the following letters and symbols.
	//
	// a-zA-Z0-9_.-
	AllowedPattern *string `type:"string"`

	// The data type of the parameter, such as text or aws:ec2:image. The default
	// is text.
	DataType *string `type:"string"`

	// Description of the parameter actions.
	Description *string `type:"string"`

	// The ID of the query key used for this parameter.
	KeyId *string `min:"1" type:"string"`

	// Date the parameter was last changed or updated.
	LastModifiedDate *time.Time `type:"timestamp"`

	// Amazon Resource Name (ARN) of the AWS user who last changed the parameter.
	LastModifiedUser *string `type:"string"`

	// The parameter name.
	Name *string `min:"1" type:"string"`

	// A list of policies associated with a parameter.
	Policies []ParameterInlinePolicy `type:"list"`

	// The parameter tier.
	Tier ParameterTier `type:"string" enum:"true"`

	// The type of parameter. Valid parameter types include the following: String,
	// StringList, and SecureString.
	Type ParameterType `type:"string" enum:"true"`

	// The parameter version.
	Version *int64 `type:"long"`
}

// String returns the string representation
func (s ParameterMetadata) String() string {
	return awsutil.Prettify(s)
}

// One or more filters. Use a filter to return a more specific list of results.
//
// The ParameterStringFilter object is used by the DescribeParameters and GetParametersByPath
// API actions. However, not all of the pattern values listed for Key can be
// used with both actions.
//
// For DescribeActions, all of the listed patterns are valid, with the exception
// of Label.
//
// For GetParametersByPath, the following patterns listed for Key are not valid:
// Name, Path, and Tier.
//
// For examples of CLI commands demonstrating valid parameter filter constructions,
// see Searching for Systems Manager parameters (https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-search.html)
// in the AWS Systems Manager User Guide.
type ParameterStringFilter struct {
	_ struct{} `type:"structure"`

	// The name of the filter.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// For all filters used with DescribeParameters, valid options include Equals
	// and BeginsWith. The Name filter additionally supports the Contains option.
	// (Exception: For filters using the key Path, valid options include Recursive
	// and OneLevel.)
	//
	// For filters used with GetParametersByPath, valid options include Equals and
	// BeginsWith. (Exception: For filters using the key Label, the only valid option
	// is Equals.)
	Option *string `min:"1" type:"string"`

	// The value you want to search for.
	Values []string `min:"1" type:"list"`
}

// String returns the string representation
func (s ParameterStringFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ParameterStringFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ParameterStringFilter"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}
	if s.Option != nil && len(*s.Option) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Option", 1))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// This data type is deprecated. Instead, use ParameterStringFilter.
type ParametersFilter struct {
	_ struct{} `type:"structure"`

	// The name of the filter.
	//
	// Key is a required field
	Key ParametersFilterKey `type:"string" required:"true" enum:"true"`

	// The filter values.
	//
	// Values is a required field
	Values []string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s ParametersFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ParametersFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ParametersFilter"}
	if len(s.Key) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}

	if s.Values == nil {
		invalidParams.Add(aws.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents metadata about a patch.
type Patch struct {
	_ struct{} `type:"structure"`

	// The classification of the patch (for example, SecurityUpdates, Updates, CriticalUpdates).
	Classification *string `type:"string"`

	// The URL where more information can be obtained about the patch.
	ContentUrl *string `type:"string"`

	// The description of the patch.
	Description *string `type:"string"`

	// The ID of the patch (this is different than the Microsoft Knowledge Base
	// ID).
	Id *string `min:"1" type:"string"`

	// The Microsoft Knowledge Base ID of the patch.
	KbNumber *string `type:"string"`

	// The language of the patch if it's language-specific.
	Language *string `type:"string"`

	// The ID of the MSRC bulletin the patch is related to.
	MsrcNumber *string `type:"string"`

	// The severity of the patch (for example Critical, Important, Moderate).
	MsrcSeverity *string `type:"string"`

	// The specific product the patch is applicable for (for example, WindowsServer2016).
	Product *string `type:"string"`

	// The product family the patch is applicable for (for example, Windows).
	ProductFamily *string `type:"string"`

	// The date the patch was released.
	ReleaseDate *time.Time `type:"timestamp"`

	// The title of the patch.
	Title *string `type:"string"`

	// The name of the vendor providing the patch.
	Vendor *string `type:"string"`
}

// String returns the string representation
func (s Patch) String() string {
	return awsutil.Prettify(s)
}

// Defines the basic information about a patch baseline.
type PatchBaselineIdentity struct {
	_ struct{} `type:"structure"`

	// The description of the patch baseline.
	BaselineDescription *string `min:"1" type:"string"`

	// The ID of the patch baseline.
	BaselineId *string `min:"20" type:"string"`

	// The name of the patch baseline.
	BaselineName *string `min:"3" type:"string"`

	// Whether this is the default baseline. Note that Systems Manager supports
	// creating multiple default patch baselines. For example, you can create a
	// default patch baseline for each operating system.
	DefaultBaseline *bool `type:"boolean"`

	// Defines the operating system the patch baseline applies to. The Default value
	// is WINDOWS.
	OperatingSystem OperatingSystem `type:"string" enum:"true"`
}

// String returns the string representation
func (s PatchBaselineIdentity) String() string {
	return awsutil.Prettify(s)
}

// Information about the state of a patch on a particular instance as it relates
// to the patch baseline used to patch the instance.
type PatchComplianceData struct {
	_ struct{} `type:"structure"`

	// The classification of the patch (for example, SecurityUpdates, Updates, CriticalUpdates).
	//
	// Classification is a required field
	Classification *string `type:"string" required:"true"`

	// The date/time the patch was installed on the instance. Note that not all
	// operating systems provide this level of information.
	//
	// InstalledTime is a required field
	InstalledTime *time.Time `type:"timestamp" required:"true"`

	// The operating system-specific ID of the patch.
	//
	// KBId is a required field
	KBId *string `type:"string" required:"true"`

	// The severity of the patch (for example, Critical, Important, Moderate).
	//
	// Severity is a required field
	Severity *string `type:"string" required:"true"`

	// The state of the patch on the instance, such as INSTALLED or FAILED.
	//
	// For descriptions of each patch state, see About patch compliance (https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-compliance-about.html#sysman-compliance-monitor-patch)
	// in the AWS Systems Manager User Guide.
	//
	// State is a required field
	State PatchComplianceDataState `type:"string" required:"true" enum:"true"`

	// The title of the patch.
	//
	// Title is a required field
	Title *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PatchComplianceData) String() string {
	return awsutil.Prettify(s)
}

// Defines which patches should be included in a patch baseline.
//
// A patch filter consists of a key and a set of values. The filter key is a
// patch property. For example, the available filter keys for WINDOWS are PATCH_SET,
// PRODUCT, PRODUCT_FAMILY, CLASSIFICATION, and MSRC_SEVERITY. The filter values
// define a matching criterion for the patch property indicated by the key.
// For example, if the filter key is PRODUCT and the filter values are ["Office
// 2013", "Office 2016"], then the filter accepts all patches where product
// name is either "Office 2013" or "Office 2016". The filter values can be exact
// values for the patch property given as a key, or a wildcard (*), which matches
// all values.
//
// You can view lists of valid values for the patch properties by running the
// DescribePatchProperties command. For information about which patch properties
// can be used with each major operating system, see DescribePatchProperties.
type PatchFilter struct {
	_ struct{} `type:"structure"`

	// The key for the filter.
	//
	// Run the DescribePatchProperties command to view lists of valid keys for each
	// operating system type.
	//
	// Key is a required field
	Key PatchFilterKey `type:"string" required:"true" enum:"true"`

	// The value for the filter key.
	//
	// Run the DescribePatchProperties command to view lists of valid values for
	// each key based on operating system type.
	//
	// Values is a required field
	Values []string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s PatchFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PatchFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PatchFilter"}
	if len(s.Key) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}

	if s.Values == nil {
		invalidParams.Add(aws.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A set of patch filters, typically used for approval rules.
type PatchFilterGroup struct {
	_ struct{} `type:"structure"`

	// The set of patch filters that make up the group.
	//
	// PatchFilters is a required field
	PatchFilters []PatchFilter `type:"list" required:"true"`
}

// String returns the string representation
func (s PatchFilterGroup) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PatchFilterGroup) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PatchFilterGroup"}

	if s.PatchFilters == nil {
		invalidParams.Add(aws.NewErrParamRequired("PatchFilters"))
	}
	if s.PatchFilters != nil {
		for i, v := range s.PatchFilters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PatchFilters", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The mapping between a patch group and the patch baseline the patch group
// is registered with.
type PatchGroupPatchBaselineMapping struct {
	_ struct{} `type:"structure"`

	// The patch baseline the patch group is registered with.
	BaselineIdentity *PatchBaselineIdentity `type:"structure"`

	// The name of the patch group registered with the patch baseline.
	PatchGroup *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PatchGroupPatchBaselineMapping) String() string {
	return awsutil.Prettify(s)
}

// Defines a filter used in Patch Manager APIs.
type PatchOrchestratorFilter struct {
	_ struct{} `type:"structure"`

	// The key for the filter.
	Key *string `min:"1" type:"string"`

	// The value for the filter.
	Values []string `type:"list"`
}

// String returns the string representation
func (s PatchOrchestratorFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PatchOrchestratorFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PatchOrchestratorFilter"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Defines an approval rule for a patch baseline.
type PatchRule struct {
	_ struct{} `type:"structure"`

	// The number of days after the release date of each patch matched by the rule
	// that the patch is marked as approved in the patch baseline. For example,
	// a value of 7 means that patches are approved seven days after they are released.
	// Not supported on Ubuntu Server.
	ApproveAfterDays *int64 `type:"integer"`

	// The cutoff date for auto approval of released patches. Any patches released
	// on or before this date are installed automatically. Not supported on Ubuntu
	// Server.
	//
	// Enter dates in the format YYYY-MM-DD. For example, 2020-12-31.
	ApproveUntilDate *string `min:"1" type:"string"`

	// A compliance severity level for all approved patches in a patch baseline.
	ComplianceLevel PatchComplianceLevel `type:"string" enum:"true"`

	// For instances identified by the approval rule filters, enables a patch baseline
	// to apply non-security updates available in the specified repository. The
	// default value is 'false'. Applies to Linux instances only.
	EnableNonSecurity *bool `type:"boolean"`

	// The patch filter group that defines the criteria for the rule.
	//
	// PatchFilterGroup is a required field
	PatchFilterGroup *PatchFilterGroup `type:"structure" required:"true"`
}

// String returns the string representation
func (s PatchRule) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PatchRule) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PatchRule"}
	if s.ApproveUntilDate != nil && len(*s.ApproveUntilDate) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ApproveUntilDate", 1))
	}

	if s.PatchFilterGroup == nil {
		invalidParams.Add(aws.NewErrParamRequired("PatchFilterGroup"))
	}
	if s.PatchFilterGroup != nil {
		if err := s.PatchFilterGroup.Validate(); err != nil {
			invalidParams.AddNested("PatchFilterGroup", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A set of rules defining the approval rules for a patch baseline.
type PatchRuleGroup struct {
	_ struct{} `type:"structure"`

	// The rules that make up the rule group.
	//
	// PatchRules is a required field
	PatchRules []PatchRule `type:"list" required:"true"`
}

// String returns the string representation
func (s PatchRuleGroup) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PatchRuleGroup) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PatchRuleGroup"}

	if s.PatchRules == nil {
		invalidParams.Add(aws.NewErrParamRequired("PatchRules"))
	}
	if s.PatchRules != nil {
		for i, v := range s.PatchRules {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PatchRules", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about the patches to use to update the instances, including target
// operating systems and source repository. Applies to Linux instances only.
type PatchSource struct {
	_ struct{} `type:"structure"`

	// The value of the yum repo configuration. For example:
	//
	// [main]
	//
	// cachedir=/var/cache/yum/$basesearch$releasever
	//
	// keepcache=0
	//
	// debuglevel=2
	//
	// Configuration is a required field
	Configuration *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The name specified to identify the patch source.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The specific operating system versions a patch repository applies to, such
	// as "Ubuntu16.04", "AmazonLinux2016.09", "RedhatEnterpriseLinux7.2" or "Suse12.7".
	// For lists of supported product values, see PatchFilter.
	//
	// Products is a required field
	Products []string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s PatchSource) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PatchSource) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PatchSource"}

	if s.Configuration == nil {
		invalidParams.Add(aws.NewErrParamRequired("Configuration"))
	}
	if s.Configuration != nil && len(*s.Configuration) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Configuration", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.Products == nil {
		invalidParams.Add(aws.NewErrParamRequired("Products"))
	}
	if s.Products != nil && len(s.Products) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Products", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about the approval status of a patch.
type PatchStatus struct {
	_ struct{} `type:"structure"`

	// The date the patch was approved (or will be approved if the status is PENDING_APPROVAL).
	ApprovalDate *time.Time `type:"timestamp"`

	// The compliance severity level for a patch.
	ComplianceLevel PatchComplianceLevel `type:"string" enum:"true"`

	// The approval status of a patch (APPROVED, PENDING_APPROVAL, EXPLICIT_APPROVED,
	// EXPLICIT_REJECTED).
	DeploymentStatus PatchDeploymentStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s PatchStatus) String() string {
	return awsutil.Prettify(s)
}

// An aggregate of step execution statuses displayed in the AWS Console for
// a multi-Region and multi-account Automation execution.
type ProgressCounters struct {
	_ struct{} `type:"structure"`

	// The total number of steps that the system cancelled in all specified AWS
	// Regions and accounts for the current Automation execution.
	CancelledSteps *int64 `type:"integer"`

	// The total number of steps that failed to run in all specified AWS Regions
	// and accounts for the current Automation execution.
	FailedSteps *int64 `type:"integer"`

	// The total number of steps that successfully completed in all specified AWS
	// Regions and accounts for the current Automation execution.
	SuccessSteps *int64 `type:"integer"`

	// The total number of steps that timed out in all specified AWS Regions and
	// accounts for the current Automation execution.
	TimedOutSteps *int64 `type:"integer"`

	// The total number of steps run in all specified AWS Regions and accounts for
	// the current Automation execution.
	TotalSteps *int64 `type:"integer"`
}

// String returns the string representation
func (s ProgressCounters) String() string {
	return awsutil.Prettify(s)
}

// An OpsItems that shares something in common with the current OpsItem. For
// example, related OpsItems can include OpsItems with similar error messages,
// impacted resources, or statuses for the impacted resource.
type RelatedOpsItem struct {
	_ struct{} `type:"structure"`

	// The ID of an OpsItem related to the current OpsItem.
	//
	// OpsItemId is a required field
	OpsItemId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RelatedOpsItem) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RelatedOpsItem) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RelatedOpsItem"}

	if s.OpsItemId == nil {
		invalidParams.Add(aws.NewErrParamRequired("OpsItemId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about targets that resolved during the Automation execution.
type ResolvedTargets struct {
	_ struct{} `type:"structure"`

	// A list of parameter values sent to targets that resolved during the Automation
	// execution.
	ParameterValues []string `type:"list"`

	// A boolean value indicating whether the resolved target list is truncated.
	Truncated *bool `type:"boolean"`
}

// String returns the string representation
func (s ResolvedTargets) String() string {
	return awsutil.Prettify(s)
}

// Compliance summary information for a specific resource.
type ResourceComplianceSummaryItem struct {
	_ struct{} `type:"structure"`

	// The compliance type.
	ComplianceType *string `min:"1" type:"string"`

	// A list of items that are compliant for the resource.
	CompliantSummary *CompliantSummary `type:"structure"`

	// Information about the execution.
	ExecutionSummary *ComplianceExecutionSummary `type:"structure"`

	// A list of items that aren't compliant for the resource.
	NonCompliantSummary *NonCompliantSummary `type:"structure"`

	// The highest severity item found for the resource. The resource is compliant
	// for this item.
	OverallSeverity ComplianceSeverity `type:"string" enum:"true"`

	// The resource ID.
	ResourceId *string `min:"1" type:"string"`

	// The resource type.
	ResourceType *string `min:"1" type:"string"`

	// The compliance status for the resource.
	Status ComplianceStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s ResourceComplianceSummaryItem) String() string {
	return awsutil.Prettify(s)
}

// Information about the AwsOrganizationsSource resource data sync source. A
// sync source of this type can synchronize data from AWS Organizations or,
// if an AWS Organization is not present, from multiple AWS Regions.
type ResourceDataSyncAwsOrganizationsSource struct {
	_ struct{} `type:"structure"`

	// If an AWS Organization is present, this is either OrganizationalUnits or
	// EntireOrganization. For OrganizationalUnits, the data is aggregated from
	// a set of organization units. For EntireOrganization, the data is aggregated
	// from the entire AWS Organization.
	//
	// OrganizationSourceType is a required field
	OrganizationSourceType *string `min:"1" type:"string" required:"true"`

	// The AWS Organizations organization units included in the sync.
	OrganizationalUnits []ResourceDataSyncOrganizationalUnit `min:"1" type:"list"`
}

// String returns the string representation
func (s ResourceDataSyncAwsOrganizationsSource) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceDataSyncAwsOrganizationsSource) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ResourceDataSyncAwsOrganizationsSource"}

	if s.OrganizationSourceType == nil {
		invalidParams.Add(aws.NewErrParamRequired("OrganizationSourceType"))
	}
	if s.OrganizationSourceType != nil && len(*s.OrganizationSourceType) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("OrganizationSourceType", 1))
	}
	if s.OrganizationalUnits != nil && len(s.OrganizationalUnits) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("OrganizationalUnits", 1))
	}
	if s.OrganizationalUnits != nil {
		for i, v := range s.OrganizationalUnits {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OrganizationalUnits", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Synchronize Systems Manager Inventory data from multiple AWS accounts defined
// in AWS Organizations to a centralized S3 bucket. Data is synchronized to
// individual key prefixes in the central bucket. Each key prefix represents
// a different AWS account ID.
type ResourceDataSyncDestinationDataSharing struct {
	_ struct{} `type:"structure"`

	// The sharing data type. Only Organization is supported.
	DestinationDataSharingType *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ResourceDataSyncDestinationDataSharing) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceDataSyncDestinationDataSharing) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ResourceDataSyncDestinationDataSharing"}
	if s.DestinationDataSharingType != nil && len(*s.DestinationDataSharingType) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DestinationDataSharingType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about a Resource Data Sync configuration, including its current
// status and last successful sync.
type ResourceDataSyncItem struct {
	_ struct{} `type:"structure"`

	// The status reported by the last sync.
	LastStatus LastResourceDataSyncStatus `type:"string" enum:"true"`

	// The last time the sync operations returned a status of SUCCESSFUL (UTC).
	LastSuccessfulSyncTime *time.Time `type:"timestamp"`

	// The status message details reported by the last sync.
	LastSyncStatusMessage *string `type:"string"`

	// The last time the configuration attempted to sync (UTC).
	LastSyncTime *time.Time `type:"timestamp"`

	// Configuration information for the target S3 bucket.
	S3Destination *ResourceDataSyncS3Destination `type:"structure"`

	// The date and time the configuration was created (UTC).
	SyncCreatedTime *time.Time `type:"timestamp"`

	// The date and time the resource data sync was changed.
	SyncLastModifiedTime *time.Time `type:"timestamp"`

	// The name of the Resource Data Sync.
	SyncName *string `min:"1" type:"string"`

	// Information about the source where the data was synchronized.
	SyncSource *ResourceDataSyncSourceWithState `type:"structure"`

	// The type of resource data sync. If SyncType is SyncToDestination, then the
	// resource data sync synchronizes data to an S3 bucket. If the SyncType is
	// SyncFromSource then the resource data sync synchronizes data from AWS Organizations
	// or from multiple AWS Regions.
	SyncType *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ResourceDataSyncItem) String() string {
	return awsutil.Prettify(s)
}

// The AWS Organizations organizational unit data source for the sync.
type ResourceDataSyncOrganizationalUnit struct {
	_ struct{} `type:"structure"`

	// The AWS Organization unit ID data source for the sync.
	OrganizationalUnitId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ResourceDataSyncOrganizationalUnit) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceDataSyncOrganizationalUnit) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ResourceDataSyncOrganizationalUnit"}
	if s.OrganizationalUnitId != nil && len(*s.OrganizationalUnitId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("OrganizationalUnitId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about the target S3 bucket for the Resource Data Sync.
type ResourceDataSyncS3Destination struct {
	_ struct{} `type:"structure"`

	// The ARN of an encryption key for a destination in Amazon S3. Must belong
	// to the same Region as the destination S3 bucket.
	AWSKMSKeyARN *string `min:"1" type:"string"`

	// The name of the S3 bucket where the aggregated data is stored.
	//
	// BucketName is a required field
	BucketName *string `min:"1" type:"string" required:"true"`

	// Enables destination data sharing. By default, this field is null.
	DestinationDataSharing *ResourceDataSyncDestinationDataSharing `type:"structure"`

	// An Amazon S3 prefix for the bucket.
	Prefix *string `min:"1" type:"string"`

	// The AWS Region with the S3 bucket targeted by the Resource Data Sync.
	//
	// Region is a required field
	Region *string `min:"1" type:"string" required:"true"`

	// A supported sync format. The following format is currently supported: JsonSerDe
	//
	// SyncFormat is a required field
	SyncFormat ResourceDataSyncS3Format `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s ResourceDataSyncS3Destination) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceDataSyncS3Destination) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ResourceDataSyncS3Destination"}
	if s.AWSKMSKeyARN != nil && len(*s.AWSKMSKeyARN) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AWSKMSKeyARN", 1))
	}

	if s.BucketName == nil {
		invalidParams.Add(aws.NewErrParamRequired("BucketName"))
	}
	if s.BucketName != nil && len(*s.BucketName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("BucketName", 1))
	}
	if s.Prefix != nil && len(*s.Prefix) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Prefix", 1))
	}

	if s.Region == nil {
		invalidParams.Add(aws.NewErrParamRequired("Region"))
	}
	if s.Region != nil && len(*s.Region) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Region", 1))
	}
	if len(s.SyncFormat) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("SyncFormat"))
	}
	if s.DestinationDataSharing != nil {
		if err := s.DestinationDataSharing.Validate(); err != nil {
			invalidParams.AddNested("DestinationDataSharing", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about the source of the data included in the resource data sync.
type ResourceDataSyncSource struct {
	_ struct{} `type:"structure"`

	// Information about the AwsOrganizationsSource resource data sync source. A
	// sync source of this type can synchronize data from AWS Organizations.
	AwsOrganizationsSource *ResourceDataSyncAwsOrganizationsSource `type:"structure"`

	// Whether to automatically synchronize and aggregate data from new AWS Regions
	// when those Regions come online.
	IncludeFutureRegions *bool `type:"boolean"`

	// The SyncSource AWS Regions included in the resource data sync.
	//
	// SourceRegions is a required field
	SourceRegions []string `type:"list" required:"true"`

	// The type of data source for the resource data sync. SourceType is either
	// AwsOrganizations (if an organization is present in AWS Organizations) or
	// singleAccountMultiRegions.
	//
	// SourceType is a required field
	SourceType *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ResourceDataSyncSource) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceDataSyncSource) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ResourceDataSyncSource"}

	if s.SourceRegions == nil {
		invalidParams.Add(aws.NewErrParamRequired("SourceRegions"))
	}

	if s.SourceType == nil {
		invalidParams.Add(aws.NewErrParamRequired("SourceType"))
	}
	if s.SourceType != nil && len(*s.SourceType) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SourceType", 1))
	}
	if s.AwsOrganizationsSource != nil {
		if err := s.AwsOrganizationsSource.Validate(); err != nil {
			invalidParams.AddNested("AwsOrganizationsSource", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The data type name for including resource data sync state. There are four
// sync states:
//
// OrganizationNotExists (Your organization doesn't exist)
//
// NoPermissions (The system can't locate the service-linked role. This role
// is automatically created when a user creates a resource data sync in Explorer.)
//
// InvalidOrganizationalUnit (You specified or selected an invalid unit in the
// resource data sync configuration.)
//
// TrustedAccessDisabled (You disabled Systems Manager access in the organization
// in AWS Organizations.)
type ResourceDataSyncSourceWithState struct {
	_ struct{} `type:"structure"`

	// The field name in SyncSource for the ResourceDataSyncAwsOrganizationsSource
	// type.
	AwsOrganizationsSource *ResourceDataSyncAwsOrganizationsSource `type:"structure"`

	// Whether to automatically synchronize and aggregate data from new AWS Regions
	// when those Regions come online.
	IncludeFutureRegions *bool `type:"boolean"`

	// The SyncSource AWS Regions included in the resource data sync.
	SourceRegions []string `type:"list"`

	// The type of data source for the resource data sync. SourceType is either
	// AwsOrganizations (if an organization is present in AWS Organizations) or
	// singleAccountMultiRegions.
	SourceType *string `min:"1" type:"string"`

	// The data type name for including resource data sync state. There are four
	// sync states:
	//
	// OrganizationNotExists: Your organization doesn't exist.
	//
	// NoPermissions: The system can't locate the service-linked role. This role
	// is automatically created when a user creates a resource data sync in Explorer.
	//
	// InvalidOrganizationalUnit: You specified or selected an invalid unit in the
	// resource data sync configuration.
	//
	// TrustedAccessDisabled: You disabled Systems Manager access in the organization
	// in AWS Organizations.
	State *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ResourceDataSyncSourceWithState) String() string {
	return awsutil.Prettify(s)
}

// The inventory item result attribute.
type ResultAttribute struct {
	_ struct{} `type:"structure"`

	// Name of the inventory item type. Valid value: AWS:InstanceInformation. Default
	// Value: AWS:InstanceInformation.
	//
	// TypeName is a required field
	TypeName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ResultAttribute) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResultAttribute) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ResultAttribute"}

	if s.TypeName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TypeName"))
	}
	if s.TypeName != nil && len(*s.TypeName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TypeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// An S3 bucket where you want to store the results of this request.
type S3OutputLocation struct {
	_ struct{} `type:"structure"`

	// The name of the S3 bucket.
	OutputS3BucketName *string `min:"3" type:"string"`

	// The S3 bucket subfolder.
	OutputS3KeyPrefix *string `type:"string"`

	// (Deprecated) You can no longer specify this parameter. The system ignores
	// it. Instead, Systems Manager automatically determines the Region of the S3
	// bucket.
	OutputS3Region *string `min:"3" type:"string"`
}

// String returns the string representation
func (s S3OutputLocation) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3OutputLocation) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3OutputLocation"}
	if s.OutputS3BucketName != nil && len(*s.OutputS3BucketName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("OutputS3BucketName", 3))
	}
	if s.OutputS3Region != nil && len(*s.OutputS3Region) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("OutputS3Region", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A URL for the S3 bucket where you want to store the results of this request.
type S3OutputUrl struct {
	_ struct{} `type:"structure"`

	// A URL for an S3 bucket where you want to store the results of this request.
	OutputUrl *string `type:"string"`
}

// String returns the string representation
func (s S3OutputUrl) String() string {
	return awsutil.Prettify(s)
}

// Information about a scheduled execution for a maintenance window.
type ScheduledWindowExecution struct {
	_ struct{} `type:"structure"`

	// The time, in ISO-8601 Extended format, that the maintenance window is scheduled
	// to be run.
	ExecutionTime *string `type:"string"`

	// The name of the maintenance window to be run.
	Name *string `min:"3" type:"string"`

	// The ID of the maintenance window to be run.
	WindowId *string `min:"20" type:"string"`
}

// String returns the string representation
func (s ScheduledWindowExecution) String() string {
	return awsutil.Prettify(s)
}

// The service setting data structure.
//
// ServiceSetting is an account-level setting for an AWS service. This setting
// defines how a user interacts with or uses a service or a feature of a service.
// For example, if an AWS service charges money to the account based on feature
// or service usage, then the AWS service team might create a default setting
// of "false". This means the user can't use this feature unless they change
// the setting to "true" and intentionally opt in for a paid feature.
//
// Services map a SettingId object to a setting value. AWS services teams define
// the default value for a SettingId. You can't create a new SettingId, but
// you can overwrite the default value if you have the ssm:UpdateServiceSetting
// permission for the setting. Use the UpdateServiceSetting API action to change
// the default setting. Or, use the ResetServiceSetting to change the value
// back to the original value defined by the AWS service team.
type ServiceSetting struct {
	_ struct{} `type:"structure"`

	// The ARN of the service setting.
	ARN *string `type:"string"`

	// The last time the service setting was modified.
	LastModifiedDate *time.Time `type:"timestamp"`

	// The ARN of the last modified user. This field is populated only if the setting
	// value was overwritten.
	LastModifiedUser *string `type:"string"`

	// The ID of the service setting.
	SettingId *string `min:"1" type:"string"`

	// The value of the service setting.
	SettingValue *string `min:"1" type:"string"`

	// The status of the service setting. The value can be Default, Customized or
	// PendingUpdate.
	//
	//    * Default: The current setting uses a default value provisioned by the
	//    AWS service team.
	//
	//    * Customized: The current setting use a custom value specified by the
	//    customer.
	//
	//    * PendingUpdate: The current setting uses a default or custom value, but
	//    a setting change request is pending approval.
	Status *string `type:"string"`
}

// String returns the string representation
func (s ServiceSetting) String() string {
	return awsutil.Prettify(s)
}

// Information about a Session Manager connection to an instance.
type Session struct {
	_ struct{} `type:"structure"`

	// Reserved for future use.
	Details *string `min:"1" type:"string"`

	// The name of the Session Manager SSM document used to define the parameters
	// and plugin settings for the session. For example, SSM-SessionManagerRunShell.
	DocumentName *string `type:"string"`

	// The date and time, in ISO-8601 Extended format, when the session was terminated.
	EndDate *time.Time `type:"timestamp"`

	// Reserved for future use.
	OutputUrl *SessionManagerOutputUrl `type:"structure"`

	// The ID of the AWS user account that started the session.
	Owner *string `min:"1" type:"string"`

	// The ID of the session.
	SessionId *string `min:"1" type:"string"`

	// The date and time, in ISO-8601 Extended format, when the session began.
	StartDate *time.Time `type:"timestamp"`

	// The status of the session. For example, "Connected" or "Terminated".
	Status SessionStatus `type:"string" enum:"true"`

	// The instance that the Session Manager session connected to.
	Target *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Session) String() string {
	return awsutil.Prettify(s)
}

// Describes a filter for Session Manager information.
type SessionFilter struct {
	_ struct{} `type:"structure"`

	// The name of the filter.
	//
	// Key is a required field
	Key SessionFilterKey `locationName:"key" type:"string" required:"true" enum:"true"`

	// The filter value. Valid values for each filter key are as follows:
	//
	//    * InvokedAfter: Specify a timestamp to limit your results. For example,
	//    specify 2018-08-29T00:00:00Z to see sessions that started August 29, 2018,
	//    and later.
	//
	//    * InvokedBefore: Specify a timestamp to limit your results. For example,
	//    specify 2018-08-29T00:00:00Z to see sessions that started before August
	//    29, 2018.
	//
	//    * Target: Specify an instance to which session connections have been made.
	//
	//    * Owner: Specify an AWS user account to see a list of sessions started
	//    by that user.
	//
	//    * Status: Specify a valid session status to see a list of all sessions
	//    with that status. Status values you can specify include: Connected Connecting
	//    Disconnected Terminated Terminating Failed
	//
	// Value is a required field
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SessionFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SessionFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SessionFilter"}
	if len(s.Key) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Reserved for future use.
type SessionManagerOutputUrl struct {
	_ struct{} `type:"structure"`

	// Reserved for future use.
	CloudWatchOutputUrl *string `min:"1" type:"string"`

	// Reserved for future use.
	S3OutputUrl *string `min:"1" type:"string"`
}

// String returns the string representation
func (s SessionManagerOutputUrl) String() string {
	return awsutil.Prettify(s)
}

// The number of managed instances found for each patch severity level defined
// in the request filter.
type SeveritySummary struct {
	_ struct{} `type:"structure"`

	// The total number of resources or compliance items that have a severity level
	// of critical. Critical severity is determined by the organization that published
	// the compliance items.
	CriticalCount *int64 `type:"integer"`

	// The total number of resources or compliance items that have a severity level
	// of high. High severity is determined by the organization that published the
	// compliance items.
	HighCount *int64 `type:"integer"`

	// The total number of resources or compliance items that have a severity level
	// of informational. Informational severity is determined by the organization
	// that published the compliance items.
	InformationalCount *int64 `type:"integer"`

	// The total number of resources or compliance items that have a severity level
	// of low. Low severity is determined by the organization that published the
	// compliance items.
	LowCount *int64 `type:"integer"`

	// The total number of resources or compliance items that have a severity level
	// of medium. Medium severity is determined by the organization that published
	// the compliance items.
	MediumCount *int64 `type:"integer"`

	// The total number of resources or compliance items that have a severity level
	// of unspecified. Unspecified severity is determined by the organization that
	// published the compliance items.
	UnspecifiedCount *int64 `type:"integer"`
}

// String returns the string representation
func (s SeveritySummary) String() string {
	return awsutil.Prettify(s)
}

// Detailed information about an the execution state of an Automation step.
type StepExecution struct {
	_ struct{} `type:"structure"`

	// The action this step performs. The action determines the behavior of the
	// step.
	Action *string `type:"string"`

	// If a step has finished execution, this contains the time the execution ended.
	// If the step has not yet concluded, this field is not populated.
	ExecutionEndTime *time.Time `type:"timestamp"`

	// If a step has begun execution, this contains the time the step started. If
	// the step is in Pending status, this field is not populated.
	ExecutionStartTime *time.Time `type:"timestamp"`

	// Information about the Automation failure.
	FailureDetails *FailureDetails `type:"structure"`

	// If a step failed, this message explains why the execution failed.
	FailureMessage *string `type:"string"`

	// Fully-resolved values passed into the step before execution.
	Inputs map[string]string `type:"map"`

	// The flag which can be used to help decide whether the failure of current
	// step leads to the Automation failure.
	IsCritical *bool `type:"boolean"`

	// The flag which can be used to end automation no matter whether the step succeeds
	// or fails.
	IsEnd *bool `type:"boolean"`

	// The maximum number of tries to run the action of the step. The default value
	// is 1.
	MaxAttempts *int64 `type:"integer"`

	// The next step after the step succeeds.
	NextStep *string `type:"string"`

	// The action to take if the step fails. The default value is Abort.
	OnFailure *string `type:"string"`

	// Returned values from the execution of the step.
	Outputs map[string][]string `min:"1" type:"map"`

	// A user-specified list of parameters to override when running a step.
	OverriddenParameters map[string][]string `min:"1" type:"map"`

	// A message associated with the response code for an execution.
	Response *string `type:"string"`

	// The response code returned by the execution of the step.
	ResponseCode *string `type:"string"`

	// The unique ID of a step execution.
	StepExecutionId *string `type:"string"`

	// The name of this execution step.
	StepName *string `type:"string"`

	// The execution status for this step.
	StepStatus AutomationExecutionStatus `type:"string" enum:"true"`

	// The combination of AWS Regions and accounts targeted by the current Automation
	// execution.
	TargetLocation *TargetLocation `type:"structure"`

	// The targets for the step execution.
	Targets []Target `type:"list"`

	// The timeout seconds of the step.
	TimeoutSeconds *int64 `type:"long"`

	// Strategies used when step fails, we support Continue and Abort. Abort will
	// fail the automation when the step fails. Continue will ignore the failure
	// of current step and allow automation to run the next step. With conditional
	// branching, we add step:stepName to support the automation to go to another
	// specific step.
	ValidNextSteps []string `type:"list"`
}

// String returns the string representation
func (s StepExecution) String() string {
	return awsutil.Prettify(s)
}

// A filter to limit the amount of step execution information returned by the
// call.
type StepExecutionFilter struct {
	_ struct{} `type:"structure"`

	// One or more keys to limit the results. Valid filter keys include the following:
	// StepName, Action, StepExecutionId, StepExecutionStatus, StartTimeBefore,
	// StartTimeAfter.
	//
	// Key is a required field
	Key StepExecutionFilterKey `type:"string" required:"true" enum:"true"`

	// The values of the filter key.
	//
	// Values is a required field
	Values []string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s StepExecutionFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StepExecutionFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StepExecutionFilter"}
	if len(s.Key) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}

	if s.Values == nil {
		invalidParams.Add(aws.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Metadata that you assign to your AWS resources. Tags enable you to categorize
// your resources in different ways, for example, by purpose, owner, or environment.
// In Systems Manager, you can apply tags to documents, managed instances, maintenance
// windows, Parameter Store parameters, and patch baselines.
type Tag struct {
	_ struct{} `type:"structure"`

	// The name of the tag.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value of the tag.
	//
	// Value is a required field
	Value *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// An array of search criteria that targets instances using a Key,Value combination
// that you specify.
//
// Supported formats include the following.
//
//    * Key=InstanceIds,Values=instance-id-1,instance-id-2,instance-id-3
//
//    * Key=tag:my-tag-key,Values=my-tag-value-1,my-tag-value-2
//
//    * Key=tag-key,Values=my-tag-key-1,my-tag-key-2
//
//    * (Maintenance window targets only) Key=resource-groups:Name,Values=resource-group-name
//
//    * (Maintenance window targets only) Key=resource-groups:ResourceTypeFilters,Values=resource-type-1,resource-type-2
//
// For example:
//
//    * Key=InstanceIds,Values=i-02573cafcfEXAMPLE,i-0471e04240EXAMPLE,i-07782c72faEXAMPLE
//
//    * Key=tag:CostCenter,Values=CostCenter1,CostCenter2,CostCenter3
//
//    * Key=tag-key,Values=Name,Instance-Type,CostCenter
//
//    * (Maintenance window targets only) Key=resource-groups:Name,Values=ProductionResourceGroup
//    This example demonstrates how to target all resources in the resource
//    group ProductionResourceGroup in your maintenance window.
//
//    * (Maintenance window targets only) Key=resource-groups:ResourceTypeFilters,Values=AWS::EC2::INSTANCE,AWS::EC2::VPC
//    This example demonstrates how to target only EC2 instances and VPCs in
//    your maintenance window.
//
//    * (State Manager association targets only) Key=InstanceIds,Values=* This
//    example demonstrates how to target all managed instances in the AWS Region
//    where the association was created.
//
// For information about how to send commands that target instances using Key,Value
// parameters, see Targeting multiple instances (https://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html#send-commands-targeting)
// in the AWS Systems Manager User Guide.
type Target struct {
	_ struct{} `type:"structure"`

	// User-defined criteria for sending commands that target instances that meet
	// the criteria.
	Key *string `min:"1" type:"string"`

	// User-defined criteria that maps to Key. For example, if you specified tag:ServerRole,
	// you could specify value:WebServer to run a command on instances that include
	// EC2 tags of ServerRole,WebServer.
	Values []string `type:"list"`
}

// String returns the string representation
func (s Target) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Target) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Target"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The combination of AWS Regions and accounts targeted by the current Automation
// execution.
type TargetLocation struct {
	_ struct{} `type:"structure"`

	// The AWS accounts targeted by the current Automation execution.
	Accounts []string `min:"1" type:"list"`

	// The Automation execution role used by the currently running Automation.
	ExecutionRoleName *string `min:"1" type:"string"`

	// The AWS Regions targeted by the current Automation execution.
	Regions []string `min:"1" type:"list"`

	// The maximum number of AWS accounts and AWS regions allowed to run the Automation
	// concurrently
	TargetLocationMaxConcurrency *string `min:"1" type:"string"`

	// The maximum number of errors allowed before the system stops queueing additional
	// Automation executions for the currently running Automation.
	TargetLocationMaxErrors *string `min:"1" type:"string"`
}

// String returns the string representation
func (s TargetLocation) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TargetLocation) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TargetLocation"}
	if s.Accounts != nil && len(s.Accounts) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Accounts", 1))
	}
	if s.ExecutionRoleName != nil && len(*s.ExecutionRoleName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ExecutionRoleName", 1))
	}
	if s.Regions != nil && len(s.Regions) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Regions", 1))
	}
	if s.TargetLocationMaxConcurrency != nil && len(*s.TargetLocationMaxConcurrency) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TargetLocationMaxConcurrency", 1))
	}
	if s.TargetLocationMaxErrors != nil && len(*s.TargetLocationMaxErrors) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TargetLocationMaxErrors", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}
