// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type StopAutomationExecutionInput struct {
	_ struct{} `type:"structure"`

	// The execution ID of the Automation to stop.
	//
	// AutomationExecutionId is a required field
	AutomationExecutionId *string `min:"36" type:"string" required:"true"`

	// The stop request type. Valid types include the following: Cancel and Complete.
	// The default type is Cancel.
	Type StopType `type:"string" enum:"true"`
}

// String returns the string representation
func (s StopAutomationExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopAutomationExecutionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StopAutomationExecutionInput"}

	if s.AutomationExecutionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AutomationExecutionId"))
	}
	if s.AutomationExecutionId != nil && len(*s.AutomationExecutionId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("AutomationExecutionId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StopAutomationExecutionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopAutomationExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

const opStopAutomationExecution = "StopAutomationExecution"

// StopAutomationExecutionRequest returns a request value for making API operation for
// Amazon Simple Systems Manager (SSM).
//
// Stop an Automation that is currently running.
//
//    // Example sending a request using StopAutomationExecutionRequest.
//    req := client.StopAutomationExecutionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/StopAutomationExecution
func (c *Client) StopAutomationExecutionRequest(input *StopAutomationExecutionInput) StopAutomationExecutionRequest {
	op := &aws.Operation{
		Name:       opStopAutomationExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopAutomationExecutionInput{}
	}

	req := c.newRequest(op, input, &StopAutomationExecutionOutput{})

	return StopAutomationExecutionRequest{Request: req, Input: input, Copy: c.StopAutomationExecutionRequest}
}

// StopAutomationExecutionRequest is the request type for the
// StopAutomationExecution API operation.
type StopAutomationExecutionRequest struct {
	*aws.Request
	Input *StopAutomationExecutionInput
	Copy  func(*StopAutomationExecutionInput) StopAutomationExecutionRequest
}

// Send marshals and sends the StopAutomationExecution API request.
func (r StopAutomationExecutionRequest) Send(ctx context.Context) (*StopAutomationExecutionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StopAutomationExecutionResponse{
		StopAutomationExecutionOutput: r.Request.Data.(*StopAutomationExecutionOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StopAutomationExecutionResponse is the response type for the
// StopAutomationExecution API operation.
type StopAutomationExecutionResponse struct {
	*StopAutomationExecutionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StopAutomationExecution request.
func (r *StopAutomationExecutionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
