// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sesv2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// A request to list all of the email identities associated with your AWS account.
// This list includes identities that you've already verified, identities that
// are unverified, and identities that were verified in the past, but are no
// longer verified.
type ListEmailIdentitiesInput struct {
	_ struct{} `type:"structure"`

	// A token returned from a previous call to ListEmailIdentities to indicate
	// the position in the list of identities.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// The number of results to show in a single call to ListEmailIdentities. If
	// the number of results is larger than the number you specified in this parameter,
	// then the response includes a NextToken element, which you can use to obtain
	// additional results.
	//
	// The value you specify has to be at least 0, and can be no more than 1000.
	PageSize *int64 `location:"querystring" locationName:"PageSize" type:"integer"`
}

// String returns the string representation
func (s ListEmailIdentitiesInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListEmailIdentitiesInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PageSize != nil {
		v := *s.PageSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "PageSize", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A list of all of the identities that you've attempted to verify, regardless
// of whether or not those identities were successfully verified.
type ListEmailIdentitiesOutput struct {
	_ struct{} `type:"structure"`

	// An array that includes all of the email identities associated with your AWS
	// account.
	EmailIdentities []IdentityInfo `type:"list"`

	// A token that indicates that there are additional configuration sets to list.
	// To view additional configuration sets, issue another request to ListEmailIdentities,
	// and pass this token in the NextToken parameter.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListEmailIdentitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListEmailIdentitiesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.EmailIdentities != nil {
		v := s.EmailIdentities

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "EmailIdentities", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListEmailIdentities = "ListEmailIdentities"

// ListEmailIdentitiesRequest returns a request value for making API operation for
// Amazon Simple Email Service.
//
// Returns a list of all of the email identities that are associated with your
// AWS account. An identity can be either an email address or a domain. This
// operation returns identities that are verified as well as those that aren't.
// This operation returns identities that are associated with Amazon SES and
// Amazon Pinpoint.
//
//    // Example sending a request using ListEmailIdentitiesRequest.
//    req := client.ListEmailIdentitiesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListEmailIdentities
func (c *Client) ListEmailIdentitiesRequest(input *ListEmailIdentitiesInput) ListEmailIdentitiesRequest {
	op := &aws.Operation{
		Name:       opListEmailIdentities,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/email/identities",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "PageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEmailIdentitiesInput{}
	}

	req := c.newRequest(op, input, &ListEmailIdentitiesOutput{})

	return ListEmailIdentitiesRequest{Request: req, Input: input, Copy: c.ListEmailIdentitiesRequest}
}

// ListEmailIdentitiesRequest is the request type for the
// ListEmailIdentities API operation.
type ListEmailIdentitiesRequest struct {
	*aws.Request
	Input *ListEmailIdentitiesInput
	Copy  func(*ListEmailIdentitiesInput) ListEmailIdentitiesRequest
}

// Send marshals and sends the ListEmailIdentities API request.
func (r ListEmailIdentitiesRequest) Send(ctx context.Context) (*ListEmailIdentitiesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListEmailIdentitiesResponse{
		ListEmailIdentitiesOutput: r.Request.Data.(*ListEmailIdentitiesOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListEmailIdentitiesRequestPaginator returns a paginator for ListEmailIdentities.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListEmailIdentitiesRequest(input)
//   p := sesv2.NewListEmailIdentitiesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListEmailIdentitiesPaginator(req ListEmailIdentitiesRequest) ListEmailIdentitiesPaginator {
	return ListEmailIdentitiesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListEmailIdentitiesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListEmailIdentitiesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListEmailIdentitiesPaginator struct {
	aws.Pager
}

func (p *ListEmailIdentitiesPaginator) CurrentPage() *ListEmailIdentitiesOutput {
	return p.Pager.CurrentPage().(*ListEmailIdentitiesOutput)
}

// ListEmailIdentitiesResponse is the response type for the
// ListEmailIdentities API operation.
type ListEmailIdentitiesResponse struct {
	*ListEmailIdentitiesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListEmailIdentities request.
func (r *ListEmailIdentitiesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
