// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ses

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents a request to list the IP address filters that exist under your
// AWS account. You use IP address filters when you receive email with Amazon
// SES. For more information, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html).
type ListReceiptFiltersInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ListReceiptFiltersInput) String() string {
	return awsutil.Prettify(s)
}

// A list of IP address filters that exist under your AWS account.
type ListReceiptFiltersOutput struct {
	_ struct{} `type:"structure"`

	// A list of IP address filter data structures, which each consist of a name,
	// an IP address range, and whether to allow or block mail from it.
	Filters []ReceiptFilter `type:"list"`
}

// String returns the string representation
func (s ListReceiptFiltersOutput) String() string {
	return awsutil.Prettify(s)
}

const opListReceiptFilters = "ListReceiptFilters"

// ListReceiptFiltersRequest returns a request value for making API operation for
// Amazon Simple Email Service.
//
// Lists the IP address filters associated with your AWS account in the current
// AWS Region.
//
// For information about managing IP address filters, see the Amazon SES Developer
// Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-ip-filters.html).
//
// You can execute this operation no more than once per second.
//
//    // Example sending a request using ListReceiptFiltersRequest.
//    req := client.ListReceiptFiltersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListReceiptFilters
func (c *Client) ListReceiptFiltersRequest(input *ListReceiptFiltersInput) ListReceiptFiltersRequest {
	op := &aws.Operation{
		Name:       opListReceiptFilters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListReceiptFiltersInput{}
	}

	req := c.newRequest(op, input, &ListReceiptFiltersOutput{})

	return ListReceiptFiltersRequest{Request: req, Input: input, Copy: c.ListReceiptFiltersRequest}
}

// ListReceiptFiltersRequest is the request type for the
// ListReceiptFilters API operation.
type ListReceiptFiltersRequest struct {
	*aws.Request
	Input *ListReceiptFiltersInput
	Copy  func(*ListReceiptFiltersInput) ListReceiptFiltersRequest
}

// Send marshals and sends the ListReceiptFilters API request.
func (r ListReceiptFiltersRequest) Send(ctx context.Context) (*ListReceiptFiltersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListReceiptFiltersResponse{
		ListReceiptFiltersOutput: r.Request.Data.(*ListReceiptFiltersOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListReceiptFiltersResponse is the response type for the
// ListReceiptFilters API operation.
type ListReceiptFiltersResponse struct {
	*ListReceiptFiltersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListReceiptFilters request.
func (r *ListReceiptFiltersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
