// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicequotas

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetAWSDefaultServiceQuotaInput struct {
	_ struct{} `type:"structure"`

	// Identifies the service quota you want to select.
	//
	// QuotaCode is a required field
	QuotaCode *string `min:"1" type:"string" required:"true"`

	// Specifies the service that you want to use.
	//
	// ServiceCode is a required field
	ServiceCode *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAWSDefaultServiceQuotaInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAWSDefaultServiceQuotaInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetAWSDefaultServiceQuotaInput"}

	if s.QuotaCode == nil {
		invalidParams.Add(aws.NewErrParamRequired("QuotaCode"))
	}
	if s.QuotaCode != nil && len(*s.QuotaCode) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("QuotaCode", 1))
	}

	if s.ServiceCode == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServiceCode"))
	}
	if s.ServiceCode != nil && len(*s.ServiceCode) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ServiceCode", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetAWSDefaultServiceQuotaOutput struct {
	_ struct{} `type:"structure"`

	// Returns the ServiceQuota object which contains all values for a quota.
	Quota *ServiceQuota `type:"structure"`
}

// String returns the string representation
func (s GetAWSDefaultServiceQuotaOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetAWSDefaultServiceQuota = "GetAWSDefaultServiceQuota"

// GetAWSDefaultServiceQuotaRequest returns a request value for making API operation for
// Service Quotas.
//
// Retrieves the default service quotas values. The Value returned for each
// quota is the AWS default value, even if the quotas have been increased..
//
//    // Example sending a request using GetAWSDefaultServiceQuotaRequest.
//    req := client.GetAWSDefaultServiceQuotaRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetAWSDefaultServiceQuota
func (c *Client) GetAWSDefaultServiceQuotaRequest(input *GetAWSDefaultServiceQuotaInput) GetAWSDefaultServiceQuotaRequest {
	op := &aws.Operation{
		Name:       opGetAWSDefaultServiceQuota,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAWSDefaultServiceQuotaInput{}
	}

	req := c.newRequest(op, input, &GetAWSDefaultServiceQuotaOutput{})

	return GetAWSDefaultServiceQuotaRequest{Request: req, Input: input, Copy: c.GetAWSDefaultServiceQuotaRequest}
}

// GetAWSDefaultServiceQuotaRequest is the request type for the
// GetAWSDefaultServiceQuota API operation.
type GetAWSDefaultServiceQuotaRequest struct {
	*aws.Request
	Input *GetAWSDefaultServiceQuotaInput
	Copy  func(*GetAWSDefaultServiceQuotaInput) GetAWSDefaultServiceQuotaRequest
}

// Send marshals and sends the GetAWSDefaultServiceQuota API request.
func (r GetAWSDefaultServiceQuotaRequest) Send(ctx context.Context) (*GetAWSDefaultServiceQuotaResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetAWSDefaultServiceQuotaResponse{
		GetAWSDefaultServiceQuotaOutput: r.Request.Data.(*GetAWSDefaultServiceQuotaOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetAWSDefaultServiceQuotaResponse is the response type for the
// GetAWSDefaultServiceQuota API operation.
type GetAWSDefaultServiceQuotaResponse struct {
	*GetAWSDefaultServiceQuotaOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetAWSDefaultServiceQuota request.
func (r *GetAWSDefaultServiceQuotaResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
