// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicecatalog

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateProvisioningArtifactInput struct {
	_ struct{} `type:"structure"`

	// The language code.
	//
	//    * en - English (default)
	//
	//    * jp - Japanese
	//
	//    * zh - Chinese
	AcceptLanguage *string `type:"string"`

	// A unique identifier that you provide to ensure idempotency. If multiple requests
	// differ only by the idempotency token, the same response is returned for each
	// repeated request.
	//
	// IdempotencyToken is a required field
	IdempotencyToken *string `min:"1" type:"string" required:"true" idempotencyToken:"true"`

	// The configuration for the provisioning artifact.
	//
	// Parameters is a required field
	Parameters *ProvisioningArtifactProperties `type:"structure" required:"true"`

	// The product identifier.
	//
	// ProductId is a required field
	ProductId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateProvisioningArtifactInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateProvisioningArtifactInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateProvisioningArtifactInput"}

	if s.IdempotencyToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("IdempotencyToken"))
	}
	if s.IdempotencyToken != nil && len(*s.IdempotencyToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("IdempotencyToken", 1))
	}

	if s.Parameters == nil {
		invalidParams.Add(aws.NewErrParamRequired("Parameters"))
	}

	if s.ProductId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProductId"))
	}
	if s.ProductId != nil && len(*s.ProductId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProductId", 1))
	}
	if s.Parameters != nil {
		if err := s.Parameters.Validate(); err != nil {
			invalidParams.AddNested("Parameters", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateProvisioningArtifactOutput struct {
	_ struct{} `type:"structure"`

	// The URL of the CloudFormation template in Amazon S3, in JSON format.
	Info map[string]string `min:"1" type:"map"`

	// Information about the provisioning artifact.
	ProvisioningArtifactDetail *ProvisioningArtifactDetail `type:"structure"`

	// The status of the current request.
	Status Status `type:"string" enum:"true"`
}

// String returns the string representation
func (s CreateProvisioningArtifactOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateProvisioningArtifact = "CreateProvisioningArtifact"

// CreateProvisioningArtifactRequest returns a request value for making API operation for
// AWS Service Catalog.
//
// Creates a provisioning artifact (also known as a version) for the specified
// product.
//
// You cannot create a provisioning artifact for a product that was shared with
// you.
//
//    // Example sending a request using CreateProvisioningArtifactRequest.
//    req := client.CreateProvisioningArtifactRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateProvisioningArtifact
func (c *Client) CreateProvisioningArtifactRequest(input *CreateProvisioningArtifactInput) CreateProvisioningArtifactRequest {
	op := &aws.Operation{
		Name:       opCreateProvisioningArtifact,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateProvisioningArtifactInput{}
	}

	req := c.newRequest(op, input, &CreateProvisioningArtifactOutput{})

	return CreateProvisioningArtifactRequest{Request: req, Input: input, Copy: c.CreateProvisioningArtifactRequest}
}

// CreateProvisioningArtifactRequest is the request type for the
// CreateProvisioningArtifact API operation.
type CreateProvisioningArtifactRequest struct {
	*aws.Request
	Input *CreateProvisioningArtifactInput
	Copy  func(*CreateProvisioningArtifactInput) CreateProvisioningArtifactRequest
}

// Send marshals and sends the CreateProvisioningArtifact API request.
func (r CreateProvisioningArtifactRequest) Send(ctx context.Context) (*CreateProvisioningArtifactResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateProvisioningArtifactResponse{
		CreateProvisioningArtifactOutput: r.Request.Data.(*CreateProvisioningArtifactOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateProvisioningArtifactResponse is the response type for the
// CreateProvisioningArtifact API operation.
type CreateProvisioningArtifactResponse struct {
	*CreateProvisioningArtifactOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateProvisioningArtifact request.
func (r *CreateProvisioningArtifactResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
