// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package serverlessapplicationrepository

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

type UnshareApplicationInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" type:"string" required:"true"`

	// OrganizationId is a required field
	OrganizationId *string `locationName:"organizationId" type:"string" required:"true"`
}

// String returns the string representation
func (s UnshareApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UnshareApplicationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UnshareApplicationInput"}

	if s.ApplicationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationId"))
	}

	if s.OrganizationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("OrganizationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UnshareApplicationInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.OrganizationId != nil {
		v := *s.OrganizationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "organizationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "applicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UnshareApplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UnshareApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UnshareApplicationOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opUnshareApplication = "UnshareApplication"

// UnshareApplicationRequest returns a request value for making API operation for
// AWSServerlessApplicationRepository.
//
// Unshares an application from an AWS Organization.
//
// This operation can be called only from the organization's master account.
//
//    // Example sending a request using UnshareApplicationRequest.
//    req := client.UnshareApplicationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/UnshareApplication
func (c *Client) UnshareApplicationRequest(input *UnshareApplicationInput) UnshareApplicationRequest {
	op := &aws.Operation{
		Name:       opUnshareApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/applications/{applicationId}/unshare",
	}

	if input == nil {
		input = &UnshareApplicationInput{}
	}

	req := c.newRequest(op, input, &UnshareApplicationOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return UnshareApplicationRequest{Request: req, Input: input, Copy: c.UnshareApplicationRequest}
}

// UnshareApplicationRequest is the request type for the
// UnshareApplication API operation.
type UnshareApplicationRequest struct {
	*aws.Request
	Input *UnshareApplicationInput
	Copy  func(*UnshareApplicationInput) UnshareApplicationRequest
}

// Send marshals and sends the UnshareApplication API request.
func (r UnshareApplicationRequest) Send(ctx context.Context) (*UnshareApplicationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UnshareApplicationResponse{
		UnshareApplicationOutput: r.Request.Data.(*UnshareApplicationOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UnshareApplicationResponse is the response type for the
// UnshareApplication API operation.
type UnshareApplicationResponse struct {
	*UnshareApplicationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UnshareApplication request.
func (r *UnshareApplicationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
