// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package securityhub

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type BatchUpdateFindingsInput struct {
	_ struct{} `type:"structure"`

	// The updated value for the finding confidence. Confidence is defined as the
	// likelihood that a finding accurately identifies the behavior or issue that
	// it was intended to identify.
	//
	// Confidence is scored on a 0-100 basis using a ratio scale, where 0 means
	// zero percent confidence and 100 means 100 percent confidence.
	Confidence *int64 `type:"integer"`

	// The updated value for the level of importance assigned to the resources associated
	// with the findings.
	//
	// A score of 0 means that the underlying resources have no criticality, and
	// a score of 100 is reserved for the most critical resources.
	Criticality *int64 `type:"integer"`

	// The list of findings to update. BatchUpdateFindings can be used to update
	// up to 100 findings at a time.
	//
	// For each finding, the list provides the finding identifier and the ARN of
	// the finding provider.
	//
	// FindingIdentifiers is a required field
	FindingIdentifiers []AwsSecurityFindingIdentifier `type:"list" required:"true"`

	// The updated note.
	Note *NoteUpdate `type:"structure"`

	// A list of findings that are related to the updated findings.
	RelatedFindings []RelatedFinding `type:"list"`

	// Used to update the finding severity.
	Severity *SeverityUpdate `type:"structure"`

	// One or more finding types in the format of namespace/category/classifier
	// that classify a finding.
	//
	// Valid namespace values are as follows.
	//
	//    * Software and Configuration Checks
	//
	//    * TTPs
	//
	//    * Effects
	//
	//    * Unusual Behaviors
	//
	//    * Sensitive Data Identifications
	Types []string `type:"list"`

	// A list of name/value string pairs associated with the finding. These are
	// custom, user-defined fields added to a finding.
	UserDefinedFields map[string]string `type:"map"`

	// Indicates the veracity of a finding.
	//
	// The available values for VerificationState are as follows.
	//
	//    * UNKNOWN – The default disposition of a security finding
	//
	//    * TRUE_POSITIVE – The security finding is confirmed
	//
	//    * FALSE_POSITIVE – The security finding was determined to be a false
	//    alarm
	//
	//    * BENIGN_POSITIVE – A special case of TRUE_POSITIVE where the finding
	//    doesn't pose any threat, is expected, or both
	VerificationState VerificationState `type:"string" enum:"true"`

	// Used to update the workflow status of a finding.
	//
	// The workflow status indicates the progress of the investigation into the
	// finding.
	Workflow *WorkflowUpdate `type:"structure"`
}

// String returns the string representation
func (s BatchUpdateFindingsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchUpdateFindingsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchUpdateFindingsInput"}

	if s.FindingIdentifiers == nil {
		invalidParams.Add(aws.NewErrParamRequired("FindingIdentifiers"))
	}
	if s.FindingIdentifiers != nil {
		for i, v := range s.FindingIdentifiers {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FindingIdentifiers", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Note != nil {
		if err := s.Note.Validate(); err != nil {
			invalidParams.AddNested("Note", err.(aws.ErrInvalidParams))
		}
	}
	if s.RelatedFindings != nil {
		for i, v := range s.RelatedFindings {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RelatedFindings", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchUpdateFindingsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Confidence != nil {
		v := *s.Confidence

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Confidence", protocol.Int64Value(v), metadata)
	}
	if s.Criticality != nil {
		v := *s.Criticality

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Criticality", protocol.Int64Value(v), metadata)
	}
	if s.FindingIdentifiers != nil {
		v := s.FindingIdentifiers

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "FindingIdentifiers", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Note != nil {
		v := s.Note

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Note", v, metadata)
	}
	if s.RelatedFindings != nil {
		v := s.RelatedFindings

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "RelatedFindings", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Severity != nil {
		v := s.Severity

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Severity", v, metadata)
	}
	if s.Types != nil {
		v := s.Types

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Types", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.UserDefinedFields != nil {
		v := s.UserDefinedFields

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "UserDefinedFields", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if len(s.VerificationState) > 0 {
		v := s.VerificationState

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VerificationState", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Workflow != nil {
		v := s.Workflow

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Workflow", v, metadata)
	}
	return nil
}

type BatchUpdateFindingsOutput struct {
	_ struct{} `type:"structure"`

	// The list of findings that were updated successfully.
	//
	// ProcessedFindings is a required field
	ProcessedFindings []AwsSecurityFindingIdentifier `type:"list" required:"true"`

	// The list of findings that were not updated.
	//
	// UnprocessedFindings is a required field
	UnprocessedFindings []BatchUpdateFindingsUnprocessedFinding `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchUpdateFindingsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchUpdateFindingsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ProcessedFindings != nil {
		v := s.ProcessedFindings

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ProcessedFindings", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.UnprocessedFindings != nil {
		v := s.UnprocessedFindings

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "UnprocessedFindings", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opBatchUpdateFindings = "BatchUpdateFindings"

// BatchUpdateFindingsRequest returns a request value for making API operation for
// AWS SecurityHub.
//
// Used by Security Hub customers to update information about their investigation
// into a finding. Requested by master accounts or member accounts. Master accounts
// can update findings for their account and their member accounts. Member accounts
// can update findings for their account.
//
// Updates from BatchUpdateFindings do not affect the value of UpdatedAt for
// a finding.
//
// Master accounts can use BatchUpdateFindings to update the following finding
// fields and objects.
//
//    * Confidence
//
//    * Criticality
//
//    * Note
//
//    * RelatedFindings
//
//    * Severity
//
//    * Types
//
//    * UserDefinedFields
//
//    * VerificationState
//
//    * Workflow
//
// Member accounts can only use BatchUpdateFindings to update the Note object.
//
//    // Example sending a request using BatchUpdateFindingsRequest.
//    req := client.BatchUpdateFindingsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchUpdateFindings
func (c *Client) BatchUpdateFindingsRequest(input *BatchUpdateFindingsInput) BatchUpdateFindingsRequest {
	op := &aws.Operation{
		Name:       opBatchUpdateFindings,
		HTTPMethod: "PATCH",
		HTTPPath:   "/findings/batchupdate",
	}

	if input == nil {
		input = &BatchUpdateFindingsInput{}
	}

	req := c.newRequest(op, input, &BatchUpdateFindingsOutput{})

	return BatchUpdateFindingsRequest{Request: req, Input: input, Copy: c.BatchUpdateFindingsRequest}
}

// BatchUpdateFindingsRequest is the request type for the
// BatchUpdateFindings API operation.
type BatchUpdateFindingsRequest struct {
	*aws.Request
	Input *BatchUpdateFindingsInput
	Copy  func(*BatchUpdateFindingsInput) BatchUpdateFindingsRequest
}

// Send marshals and sends the BatchUpdateFindings API request.
func (r BatchUpdateFindingsRequest) Send(ctx context.Context) (*BatchUpdateFindingsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &BatchUpdateFindingsResponse{
		BatchUpdateFindingsOutput: r.Request.Data.(*BatchUpdateFindingsOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// BatchUpdateFindingsResponse is the response type for the
// BatchUpdateFindings API operation.
type BatchUpdateFindingsResponse struct {
	*BatchUpdateFindingsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// BatchUpdateFindings request.
func (r *BatchUpdateFindingsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
