// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package secretsmanager

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ValidateResourcePolicyInput struct {
	_ struct{} `type:"structure"`

	// Identifies the Resource Policy attached to the secret.
	//
	// ResourcePolicy is a required field
	ResourcePolicy *string `min:"1" type:"string" required:"true"`

	// The identifier for the secret that you want to validate a resource policy.
	// You can specify either the Amazon Resource Name (ARN) or the friendly name
	// of the secret.
	//
	// If you specify an ARN, we generally recommend that you specify a complete
	// ARN. You can specify a partial ARN too—for example, if you don’t include
	// the final hyphen and six random characters that Secrets Manager adds at the
	// end of the ARN when you created the secret. A partial ARN match can work
	// as long as it uniquely matches only one secret. However, if your secret has
	// a name that ends in a hyphen followed by six characters (before Secrets Manager
	// adds the hyphen and six characters to the ARN) and you try to use that as
	// a partial ARN, then those characters cause Secrets Manager to assume that
	// you’re specifying a complete ARN. This confusion can cause unexpected results.
	// To avoid this situation, we recommend that you don’t create secret names
	// ending with a hyphen followed by six characters.
	//
	// If you specify an incomplete ARN without the random suffix, and instead provide
	// the 'friendly name', you must not include the random suffix. If you do include
	// the random suffix added by Secrets Manager, you receive either a ResourceNotFoundException
	// or an AccessDeniedException error, depending on your permissions.
	SecretId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ValidateResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ValidateResourcePolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ValidateResourcePolicyInput"}

	if s.ResourcePolicy == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourcePolicy"))
	}
	if s.ResourcePolicy != nil && len(*s.ResourcePolicy) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourcePolicy", 1))
	}
	if s.SecretId != nil && len(*s.SecretId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SecretId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ValidateResourcePolicyOutput struct {
	_ struct{} `type:"structure"`

	// Returns a message stating that your Reource Policy passed validation.
	PolicyValidationPassed *bool `type:"boolean"`

	// Returns an error message if your policy doesn't pass validatation.
	ValidationErrors []ValidationErrorsEntry `type:"list"`
}

// String returns the string representation
func (s ValidateResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

const opValidateResourcePolicy = "ValidateResourcePolicy"

// ValidateResourcePolicyRequest returns a request value for making API operation for
// AWS Secrets Manager.
//
// Validates the JSON text of the resource-based policy document attached to
// the specified secret. The JSON request string input and response output displays
// formatted code with white space and line breaks for better readability. Submit
// your input as a single line JSON string. A resource-based policy is optional.
//
//    // Example sending a request using ValidateResourcePolicyRequest.
//    req := client.ValidateResourcePolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/ValidateResourcePolicy
func (c *Client) ValidateResourcePolicyRequest(input *ValidateResourcePolicyInput) ValidateResourcePolicyRequest {
	op := &aws.Operation{
		Name:       opValidateResourcePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ValidateResourcePolicyInput{}
	}

	req := c.newRequest(op, input, &ValidateResourcePolicyOutput{})

	return ValidateResourcePolicyRequest{Request: req, Input: input, Copy: c.ValidateResourcePolicyRequest}
}

// ValidateResourcePolicyRequest is the request type for the
// ValidateResourcePolicy API operation.
type ValidateResourcePolicyRequest struct {
	*aws.Request
	Input *ValidateResourcePolicyInput
	Copy  func(*ValidateResourcePolicyInput) ValidateResourcePolicyRequest
}

// Send marshals and sends the ValidateResourcePolicy API request.
func (r ValidateResourcePolicyRequest) Send(ctx context.Context) (*ValidateResourcePolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ValidateResourcePolicyResponse{
		ValidateResourcePolicyOutput: r.Request.Data.(*ValidateResourcePolicyOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ValidateResourcePolicyResponse is the response type for the
// ValidateResourcePolicy API operation.
type ValidateResourcePolicyResponse struct {
	*ValidateResourcePolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ValidateResourcePolicy request.
func (r *ValidateResourcePolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
