// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListNotebookInstancesInput struct {
	_ struct{} `type:"structure"`

	// A filter that returns only notebook instances with associated with the specified
	// git repository.
	AdditionalCodeRepositoryEquals *string `min:"1" type:"string"`

	// A filter that returns only notebook instances that were created after the
	// specified time (timestamp).
	CreationTimeAfter *time.Time `type:"timestamp"`

	// A filter that returns only notebook instances that were created before the
	// specified time (timestamp).
	CreationTimeBefore *time.Time `type:"timestamp"`

	// A string in the name or URL of a Git repository associated with this notebook
	// instance. This filter returns only notebook instances associated with a git
	// repository with a name that contains the specified string.
	DefaultCodeRepositoryContains *string `type:"string"`

	// A filter that returns only notebook instances that were modified after the
	// specified time (timestamp).
	LastModifiedTimeAfter *time.Time `type:"timestamp"`

	// A filter that returns only notebook instances that were modified before the
	// specified time (timestamp).
	LastModifiedTimeBefore *time.Time `type:"timestamp"`

	// The maximum number of notebook instances to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// A string in the notebook instances' name. This filter returns only notebook
	// instances whose name contains the specified string.
	NameContains *string `type:"string"`

	// If the previous call to the ListNotebookInstances is truncated, the response
	// includes a NextToken. You can use this token in your subsequent ListNotebookInstances
	// request to fetch the next set of notebook instances.
	//
	// You might specify a filter or a sort order in your request. When response
	// is truncated, you must use the same values for the filer and sort order in
	// the next request.
	NextToken *string `type:"string"`

	// A string in the name of a notebook instances lifecycle configuration associated
	// with this notebook instance. This filter returns only notebook instances
	// associated with a lifecycle configuration with a name that contains the specified
	// string.
	NotebookInstanceLifecycleConfigNameContains *string `type:"string"`

	// The field to sort results by. The default is Name.
	SortBy NotebookInstanceSortKey `type:"string" enum:"true"`

	// The sort order for results.
	SortOrder NotebookInstanceSortOrder `type:"string" enum:"true"`

	// A filter that returns only notebook instances with the specified status.
	StatusEquals NotebookInstanceStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s ListNotebookInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListNotebookInstancesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListNotebookInstancesInput"}
	if s.AdditionalCodeRepositoryEquals != nil && len(*s.AdditionalCodeRepositoryEquals) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AdditionalCodeRepositoryEquals", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListNotebookInstancesOutput struct {
	_ struct{} `type:"structure"`

	// If the response to the previous ListNotebookInstances request was truncated,
	// Amazon SageMaker returns this token. To retrieve the next set of notebook
	// instances, use the token in the next request.
	NextToken *string `type:"string"`

	// An array of NotebookInstanceSummary objects, one for each notebook instance.
	NotebookInstances []NotebookInstanceSummary `type:"list"`
}

// String returns the string representation
func (s ListNotebookInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

const opListNotebookInstances = "ListNotebookInstances"

// ListNotebookInstancesRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Returns a list of the Amazon SageMaker notebook instances in the requester's
// account in an AWS Region.
//
//    // Example sending a request using ListNotebookInstancesRequest.
//    req := client.ListNotebookInstancesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListNotebookInstances
func (c *Client) ListNotebookInstancesRequest(input *ListNotebookInstancesInput) ListNotebookInstancesRequest {
	op := &aws.Operation{
		Name:       opListNotebookInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListNotebookInstancesInput{}
	}

	req := c.newRequest(op, input, &ListNotebookInstancesOutput{})

	return ListNotebookInstancesRequest{Request: req, Input: input, Copy: c.ListNotebookInstancesRequest}
}

// ListNotebookInstancesRequest is the request type for the
// ListNotebookInstances API operation.
type ListNotebookInstancesRequest struct {
	*aws.Request
	Input *ListNotebookInstancesInput
	Copy  func(*ListNotebookInstancesInput) ListNotebookInstancesRequest
}

// Send marshals and sends the ListNotebookInstances API request.
func (r ListNotebookInstancesRequest) Send(ctx context.Context) (*ListNotebookInstancesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListNotebookInstancesResponse{
		ListNotebookInstancesOutput: r.Request.Data.(*ListNotebookInstancesOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListNotebookInstancesRequestPaginator returns a paginator for ListNotebookInstances.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListNotebookInstancesRequest(input)
//   p := sagemaker.NewListNotebookInstancesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListNotebookInstancesPaginator(req ListNotebookInstancesRequest) ListNotebookInstancesPaginator {
	return ListNotebookInstancesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListNotebookInstancesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListNotebookInstancesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListNotebookInstancesPaginator struct {
	aws.Pager
}

func (p *ListNotebookInstancesPaginator) CurrentPage() *ListNotebookInstancesOutput {
	return p.Pager.CurrentPage().(*ListNotebookInstancesOutput)
}

// ListNotebookInstancesResponse is the response type for the
// ListNotebookInstances API operation.
type ListNotebookInstancesResponse struct {
	*ListNotebookInstancesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListNotebookInstances request.
func (r *ListNotebookInstancesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
