// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeTrialComponentInput struct {
	_ struct{} `type:"structure"`

	// The name of the trial component to describe.
	//
	// TrialComponentName is a required field
	TrialComponentName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeTrialComponentInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTrialComponentInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeTrialComponentInput"}

	if s.TrialComponentName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TrialComponentName"))
	}
	if s.TrialComponentName != nil && len(*s.TrialComponentName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TrialComponentName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeTrialComponentOutput struct {
	_ struct{} `type:"structure"`

	// Who created the component.
	CreatedBy *UserContext `type:"structure"`

	// When the component was created.
	CreationTime *time.Time `type:"timestamp"`

	// The name of the component as displayed. If DisplayName isn't specified, TrialComponentName
	// is displayed.
	DisplayName *string `min:"1" type:"string"`

	// When the component ended.
	EndTime *time.Time `type:"timestamp"`

	// The input artifacts of the component.
	InputArtifacts map[string]TrialComponentArtifact `type:"map"`

	// Who last modified the component.
	LastModifiedBy *UserContext `type:"structure"`

	// When the component was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The metrics for the component.
	Metrics []TrialComponentMetricSummary `type:"list"`

	// The output artifacts of the component.
	OutputArtifacts map[string]TrialComponentArtifact `type:"map"`

	// The hyperparameters of the component.
	Parameters map[string]TrialComponentParameterValue `type:"map"`

	// The Amazon Resource Name (ARN) of the source and, optionally, the job type.
	Source *TrialComponentSource `type:"structure"`

	// When the component started.
	StartTime *time.Time `type:"timestamp"`

	// The status of the component. States include:
	//
	//    * InProgress
	//
	//    * Completed
	//
	//    * Failed
	Status *TrialComponentStatus `type:"structure"`

	// The Amazon Resource Name (ARN) of the trial component.
	TrialComponentArn *string `type:"string"`

	// The name of the trial component.
	TrialComponentName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeTrialComponentOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeTrialComponent = "DescribeTrialComponent"

// DescribeTrialComponentRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Provides a list of a trials component's properties.
//
//    // Example sending a request using DescribeTrialComponentRequest.
//    req := client.DescribeTrialComponentRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTrialComponent
func (c *Client) DescribeTrialComponentRequest(input *DescribeTrialComponentInput) DescribeTrialComponentRequest {
	op := &aws.Operation{
		Name:       opDescribeTrialComponent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTrialComponentInput{}
	}

	req := c.newRequest(op, input, &DescribeTrialComponentOutput{})

	return DescribeTrialComponentRequest{Request: req, Input: input, Copy: c.DescribeTrialComponentRequest}
}

// DescribeTrialComponentRequest is the request type for the
// DescribeTrialComponent API operation.
type DescribeTrialComponentRequest struct {
	*aws.Request
	Input *DescribeTrialComponentInput
	Copy  func(*DescribeTrialComponentInput) DescribeTrialComponentRequest
}

// Send marshals and sends the DescribeTrialComponent API request.
func (r DescribeTrialComponentRequest) Send(ctx context.Context) (*DescribeTrialComponentResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeTrialComponentResponse{
		DescribeTrialComponentOutput: r.Request.Data.(*DescribeTrialComponentOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeTrialComponentResponse is the response type for the
// DescribeTrialComponent API operation.
type DescribeTrialComponentResponse struct {
	*DescribeTrialComponentOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeTrialComponent request.
func (r *DescribeTrialComponentResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
