// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package s3control

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restxml"
)

type PutAccessPointPolicyInput struct {
	_ struct{} `locationName:"PutAccessPointPolicyRequest" type:"structure" xmlURI:"http://awss3control.amazonaws.com/doc/2018-08-20/"`

	// The AWS account ID for owner of the bucket associated with the specified
	// access point.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The name of the access point that you want to associate with the specified
	// policy.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`

	// The policy that you want to apply to the specified access point. For more
	// information about access point policies, see Managing Data Access with Amazon
	// S3 Access Points (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-points.html)
	// in the Amazon Simple Storage Service Developer Guide.
	//
	// Policy is a required field
	Policy *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PutAccessPointPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutAccessPointPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutAccessPointPolicyInput"}

	if s.AccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountId"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 3))
	}

	if s.Policy == nil {
		invalidParams.Add(aws.NewErrParamRequired("Policy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutAccessPointPolicyInput) MarshalFields(e protocol.FieldEncoder) error {

	e.SetFields(protocol.BodyTarget, "PutAccessPointPolicyRequest", protocol.FieldMarshalerFunc(func(e protocol.FieldEncoder) error {
		if s.Policy != nil {
			v := *s.Policy

			metadata := protocol.Metadata{}
			e.SetValue(protocol.BodyTarget, "Policy", protocol.StringValue(v), metadata)
		}
		return nil
	}), protocol.Metadata{XMLNamespaceURI: "http://awss3control.amazonaws.com/doc/2018-08-20/"})
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-account-id", protocol.StringValue(v), metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "name", protocol.StringValue(v), metadata)
	}
	return nil
}

type PutAccessPointPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutAccessPointPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutAccessPointPolicyOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opPutAccessPointPolicy = "PutAccessPointPolicy"

// PutAccessPointPolicyRequest returns a request value for making API operation for
// AWS S3 Control.
//
// Associates an access policy with the specified access point. Each access
// point can have only one policy, so a request made to this API replaces any
// existing policy associated with the specified access point.
//
//    // Example sending a request using PutAccessPointPolicyRequest.
//    req := client.PutAccessPointPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutAccessPointPolicy
func (c *Client) PutAccessPointPolicyRequest(input *PutAccessPointPolicyInput) PutAccessPointPolicyRequest {
	op := &aws.Operation{
		Name:       opPutAccessPointPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20180820/accesspoint/{name}/policy",
	}

	if input == nil {
		input = &PutAccessPointPolicyInput{}
	}

	req := c.newRequest(op, input, &PutAccessPointPolicyOutput{})
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(buildPrefixHostHandler("AccountID", aws.StringValue(input.AccountId)))
	req.Handlers.Build.PushBackNamed(buildRemoveHeaderHandler("X-Amz-Account-Id"))

	return PutAccessPointPolicyRequest{Request: req, Input: input, Copy: c.PutAccessPointPolicyRequest}
}

// PutAccessPointPolicyRequest is the request type for the
// PutAccessPointPolicy API operation.
type PutAccessPointPolicyRequest struct {
	*aws.Request
	Input *PutAccessPointPolicyInput
	Copy  func(*PutAccessPointPolicyInput) PutAccessPointPolicyRequest
}

// Send marshals and sends the PutAccessPointPolicy API request.
func (r PutAccessPointPolicyRequest) Send(ctx context.Context) (*PutAccessPointPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutAccessPointPolicyResponse{
		PutAccessPointPolicyOutput: r.Request.Data.(*PutAccessPointPolicyOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutAccessPointPolicyResponse is the response type for the
// PutAccessPointPolicy API operation.
type PutAccessPointPolicyResponse struct {
	*PutAccessPointPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutAccessPointPolicy request.
func (r *PutAccessPointPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
