// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package s3control

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteJobTaggingInput struct {
	_ struct{} `type:"structure"`

	// The AWS account ID associated with the Amazon S3 Batch Operations job.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The ID for the Amazon S3 Batch Operations job whose tags you want to delete.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"id" min:"5" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteJobTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteJobTaggingInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteJobTaggingInput"}

	if s.AccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountId"))
	}

	if s.JobId == nil {
		invalidParams.Add(aws.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 5 {
		invalidParams.Add(aws.NewErrParamMinLen("JobId", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteJobTaggingInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-account-id", protocol.StringValue(v), metadata)
	}
	if s.JobId != nil {
		v := *s.JobId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "id", protocol.StringValue(v), metadata)
	}
	return nil
}

type DeleteJobTaggingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteJobTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteJobTaggingOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteJobTagging = "DeleteJobTagging"

// DeleteJobTaggingRequest returns a request value for making API operation for
// AWS S3 Control.
//
// Removes the entire tag set from the specified Amazon S3 Batch Operations
// job. To use this operation, you must have permission to perform the s3:DeleteJobTagging
// action. For more information, see Using Job Tags (https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-managing-jobs.html#batch-ops-job-tags)
// in the Amazon Simple Storage Service Developer Guide.
//
// Related actions include:
//
//    * CreateJob
//
//    * GetJobTagging
//
//    * PutJobTagging
//
//    // Example sending a request using DeleteJobTaggingRequest.
//    req := client.DeleteJobTaggingRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteJobTagging
func (c *Client) DeleteJobTaggingRequest(input *DeleteJobTaggingInput) DeleteJobTaggingRequest {
	op := &aws.Operation{
		Name:       opDeleteJobTagging,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20180820/jobs/{id}/tagging",
	}

	if input == nil {
		input = &DeleteJobTaggingInput{}
	}

	req := c.newRequest(op, input, &DeleteJobTaggingOutput{})
	req.Handlers.Build.PushBackNamed(buildPrefixHostHandler("AccountID", aws.StringValue(input.AccountId)))
	req.Handlers.Build.PushBackNamed(buildRemoveHeaderHandler("X-Amz-Account-Id"))

	return DeleteJobTaggingRequest{Request: req, Input: input, Copy: c.DeleteJobTaggingRequest}
}

// DeleteJobTaggingRequest is the request type for the
// DeleteJobTagging API operation.
type DeleteJobTaggingRequest struct {
	*aws.Request
	Input *DeleteJobTaggingInput
	Copy  func(*DeleteJobTaggingInput) DeleteJobTaggingRequest
}

// Send marshals and sends the DeleteJobTagging API request.
func (r DeleteJobTaggingRequest) Send(ctx context.Context) (*DeleteJobTaggingResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteJobTaggingResponse{
		DeleteJobTaggingOutput: r.Request.Data.(*DeleteJobTaggingOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteJobTaggingResponse is the response type for the
// DeleteJobTagging API operation.
type DeleteJobTaggingResponse struct {
	*DeleteJobTaggingOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteJobTagging request.
func (r *DeleteJobTaggingResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
