// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package s3

import (
	"context"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/service/s3/internal/arn"
)

type ListPartsInput struct {
	_ struct{} `type:"structure"`

	// Name of the bucket to which the parts are being uploaded.
	//
	// When using this API with an access point, you must direct requests to the
	// access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
	// When using this operation using an access point through the AWS SDKs, you
	// provide the access point ARN in place of the bucket name. For more information
	// about access point ARNs, see Using Access Points (https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html)
	// in the Amazon Simple Storage Service Developer Guide.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Object key for which the multipart upload was initiated.
	//
	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Sets the maximum number of parts to return.
	MaxParts *int64 `location:"querystring" locationName:"max-parts" type:"integer"`

	// Specifies the part after which listing should begin. Only parts with higher
	// part numbers will be listed.
	PartNumberMarker *int64 `location:"querystring" locationName:"part-number-marker" type:"integer"`

	// Confirms that the requester knows that they will be charged for the request.
	// Bucket owners need not specify this parameter in their requests. For information
	// about downloading objects from requester pays buckets, see Downloading Objects
	// in Requestor Pays Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html)
	// in the Amazon S3 Developer Guide.
	RequestPayer RequestPayer `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"true"`

	// Upload ID identifying the multipart upload whose parts are being listed.
	//
	// UploadId is a required field
	UploadId *string `location:"querystring" locationName:"uploadId" type:"string" required:"true"`
}

// String returns the string representation
func (s ListPartsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPartsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListPartsInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if s.UploadId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UploadId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *ListPartsInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListPartsInput) MarshalFields(e protocol.FieldEncoder) error {

	if len(s.RequestPayer) > 0 {
		v := s.RequestPayer

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-request-payer", v, metadata)
	}
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.MaxParts != nil {
		v := *s.MaxParts

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "max-parts", protocol.Int64Value(v), metadata)
	}
	if s.PartNumberMarker != nil {
		v := *s.PartNumberMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "part-number-marker", protocol.Int64Value(v), metadata)
	}
	if s.UploadId != nil {
		v := *s.UploadId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "uploadId", protocol.StringValue(v), metadata)
	}
	return nil
}

func (s *ListPartsInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *ListPartsInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

type ListPartsOutput struct {
	_ struct{} `type:"structure"`

	// If the bucket has a lifecycle rule configured with an action to abort incomplete
	// multipart uploads and the prefix in the lifecycle rule matches the object
	// name in the request, then the response includes this header indicating when
	// the initiated multipart upload will become eligible for abort operation.
	// For more information, see Aborting Incomplete Multipart Uploads Using a Bucket
	// Lifecycle Policy (https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config).
	//
	// The response will also include the x-amz-abort-rule-id header that will provide
	// the ID of the lifecycle configuration rule that defines this action.
	AbortDate *time.Time `location:"header" locationName:"x-amz-abort-date" type:"timestamp"`

	// This header is returned along with the x-amz-abort-date header. It identifies
	// applicable lifecycle configuration rule that defines the action to abort
	// incomplete multipart uploads.
	AbortRuleId *string `location:"header" locationName:"x-amz-abort-rule-id" type:"string"`

	// Name of the bucket to which the multipart upload was initiated.
	Bucket *string `type:"string"`

	// Container element that identifies who initiated the multipart upload. If
	// the initiator is an AWS account, this element provides the same information
	// as the Owner element. If the initiator is an IAM User, this element provides
	// the user ARN and display name.
	Initiator *Initiator `type:"structure"`

	// Indicates whether the returned list of parts is truncated. A true value indicates
	// that the list was truncated. A list can be truncated if the number of parts
	// exceeds the limit returned in the MaxParts element.
	IsTruncated *bool `type:"boolean"`

	// Object key for which the multipart upload was initiated.
	Key *string `min:"1" type:"string"`

	// Maximum number of parts that were allowed in the response.
	MaxParts *int64 `type:"integer"`

	// When a list is truncated, this element specifies the last part in the list,
	// as well as the value to use for the part-number-marker request parameter
	// in a subsequent request.
	NextPartNumberMarker *int64 `type:"integer"`

	// Container element that identifies the object owner, after the object is created.
	// If multipart upload is initiated by an IAM user, this element provides the
	// parent account ID and display name.
	Owner *Owner `type:"structure"`

	// When a list is truncated, this element specifies the last part in the list,
	// as well as the value to use for the part-number-marker request parameter
	// in a subsequent request.
	PartNumberMarker *int64 `type:"integer"`

	// Container for elements related to a particular part. A response can contain
	// zero or more Part elements.
	Parts []Part `locationName:"Part" type:"list" flattened:"true"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged RequestCharged `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"true"`

	// Class of storage (STANDARD or REDUCED_REDUNDANCY) used to store the uploaded
	// object.
	StorageClass StorageClass `type:"string" enum:"true"`

	// Upload ID identifying the multipart upload whose parts are being listed.
	UploadId *string `type:"string"`
}

// String returns the string representation
func (s ListPartsOutput) String() string {
	return awsutil.Prettify(s)
}

func (s *ListPartsOutput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListPartsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Initiator != nil {
		v := s.Initiator

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Initiator", v, metadata)
	}
	if s.IsTruncated != nil {
		v := *s.IsTruncated

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsTruncated", protocol.BoolValue(v), metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.MaxParts != nil {
		v := *s.MaxParts

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxParts", protocol.Int64Value(v), metadata)
	}
	if s.NextPartNumberMarker != nil {
		v := *s.NextPartNumberMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextPartNumberMarker", protocol.Int64Value(v), metadata)
	}
	if s.Owner != nil {
		v := s.Owner

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Owner", v, metadata)
	}
	if s.PartNumberMarker != nil {
		v := *s.PartNumberMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PartNumberMarker", protocol.Int64Value(v), metadata)
	}
	if s.Parts != nil {
		v := s.Parts

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Part", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.StorageClass) > 0 {
		v := s.StorageClass

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StorageClass", v, metadata)
	}
	if s.UploadId != nil {
		v := *s.UploadId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UploadId", protocol.StringValue(v), metadata)
	}
	if s.AbortDate != nil {
		v := *s.AbortDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-abort-date",
			protocol.TimeValue{V: v, Format: protocol.RFC822TimeFormatName, QuotedFormatTime: false}, metadata)
	}
	if s.AbortRuleId != nil {
		v := *s.AbortRuleId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-abort-rule-id", protocol.StringValue(v), metadata)
	}
	if len(s.RequestCharged) > 0 {
		v := s.RequestCharged

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-request-charged", v, metadata)
	}
	return nil
}

const opListParts = "ListParts"

// ListPartsRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Lists the parts that have been uploaded for a specific multipart upload.
// This operation must include the upload ID, which you obtain by sending the
// initiate multipart upload request (see CreateMultipartUpload). This request
// returns a maximum of 1,000 uploaded parts. The default number of parts returned
// is 1,000 parts. You can restrict the number of parts returned by specifying
// the max-parts request parameter. If your multipart upload consists of more
// than 1,000 parts, the response returns an IsTruncated field with the value
// of true, and a NextPartNumberMarker element. In subsequent ListParts requests
// you can include the part-number-marker query string parameter and set its
// value to the NextPartNumberMarker field value from the previous response.
//
// For more information on multipart uploads, see Uploading Objects Using Multipart
// Upload (https://docs.aws.amazon.com/AmazonS3/latest/dev/uploadobjusingmpu.html).
//
// For information on permissions required to use the multipart upload API,
// see Multipart Upload API and Permissions (https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuAndPermissions.html).
//
// The following operations are related to ListParts:
//
//    * CreateMultipartUpload
//
//    * UploadPart
//
//    * CompleteMultipartUpload
//
//    * AbortMultipartUpload
//
//    * ListMultipartUploads
//
//    // Example sending a request using ListPartsRequest.
//    req := client.ListPartsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListParts
func (c *Client) ListPartsRequest(input *ListPartsInput) ListPartsRequest {
	op := &aws.Operation{
		Name:       opListParts,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}/{Key+}",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"PartNumberMarker"},
			OutputTokens:    []string{"NextPartNumberMarker"},
			LimitToken:      "MaxParts",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListPartsInput{}
	}

	req := c.newRequest(op, input, &ListPartsOutput{})

	return ListPartsRequest{Request: req, Input: input, Copy: c.ListPartsRequest}
}

// ListPartsRequest is the request type for the
// ListParts API operation.
type ListPartsRequest struct {
	*aws.Request
	Input *ListPartsInput
	Copy  func(*ListPartsInput) ListPartsRequest
}

// Send marshals and sends the ListParts API request.
func (r ListPartsRequest) Send(ctx context.Context) (*ListPartsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListPartsResponse{
		ListPartsOutput: r.Request.Data.(*ListPartsOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListPartsRequestPaginator returns a paginator for ListParts.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListPartsRequest(input)
//   p := s3.NewListPartsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListPartsPaginator(req ListPartsRequest) ListPartsPaginator {
	return ListPartsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListPartsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListPartsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListPartsPaginator struct {
	aws.Pager
}

func (p *ListPartsPaginator) CurrentPage() *ListPartsOutput {
	return p.Pager.CurrentPage().(*ListPartsOutput)
}

// ListPartsResponse is the response type for the
// ListParts API operation.
type ListPartsResponse struct {
	*ListPartsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListParts request.
func (r *ListPartsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
