// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package route53domains

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// The UpdateDomainContact request includes the following elements.
type UpdateDomainContactInput struct {
	_ struct{} `type:"structure"`

	// Provides detailed contact information.
	AdminContact *ContactDetail `type:"structure" sensitive:"true"`

	// The name of the domain that you want to update contact information for.
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`

	// Provides detailed contact information.
	RegistrantContact *ContactDetail `type:"structure" sensitive:"true"`

	// Provides detailed contact information.
	TechContact *ContactDetail `type:"structure" sensitive:"true"`
}

// String returns the string representation
func (s UpdateDomainContactInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDomainContactInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateDomainContactInput"}

	if s.DomainName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainName"))
	}
	if s.AdminContact != nil {
		if err := s.AdminContact.Validate(); err != nil {
			invalidParams.AddNested("AdminContact", err.(aws.ErrInvalidParams))
		}
	}
	if s.RegistrantContact != nil {
		if err := s.RegistrantContact.Validate(); err != nil {
			invalidParams.AddNested("RegistrantContact", err.(aws.ErrInvalidParams))
		}
	}
	if s.TechContact != nil {
		if err := s.TechContact.Validate(); err != nil {
			invalidParams.AddNested("TechContact", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The UpdateDomainContact response includes the following element.
type UpdateDomainContactOutput struct {
	_ struct{} `type:"structure"`

	// Identifier for tracking the progress of the request. To query the operation
	// status, use GetOperationDetail (https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html).
	//
	// OperationId is a required field
	OperationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateDomainContactOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateDomainContact = "UpdateDomainContact"

// UpdateDomainContactRequest returns a request value for making API operation for
// Amazon Route 53 Domains.
//
// This operation updates the contact information for a particular domain. You
// must specify information for at least one contact: registrant, administrator,
// or technical.
//
// If the update is successful, this method returns an operation ID that you
// can use to track the progress and completion of the action. If the request
// is not completed successfully, the domain registrant will be notified by
// email.
//
//    // Example sending a request using UpdateDomainContactRequest.
//    req := client.UpdateDomainContactRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/UpdateDomainContact
func (c *Client) UpdateDomainContactRequest(input *UpdateDomainContactInput) UpdateDomainContactRequest {
	op := &aws.Operation{
		Name:       opUpdateDomainContact,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDomainContactInput{}
	}

	req := c.newRequest(op, input, &UpdateDomainContactOutput{})

	return UpdateDomainContactRequest{Request: req, Input: input, Copy: c.UpdateDomainContactRequest}
}

// UpdateDomainContactRequest is the request type for the
// UpdateDomainContact API operation.
type UpdateDomainContactRequest struct {
	*aws.Request
	Input *UpdateDomainContactInput
	Copy  func(*UpdateDomainContactInput) UpdateDomainContactRequest
}

// Send marshals and sends the UpdateDomainContact API request.
func (r UpdateDomainContactRequest) Send(ctx context.Context) (*UpdateDomainContactResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateDomainContactResponse{
		UpdateDomainContactOutput: r.Request.Data.(*UpdateDomainContactOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateDomainContactResponse is the response type for the
// UpdateDomainContact API operation.
type UpdateDomainContactResponse struct {
	*UpdateDomainContactOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateDomainContact request.
func (r *UpdateDomainContactResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
