// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package robomaker

import (
	"context"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateSimulationApplicationInput struct {
	_ struct{} `type:"structure"`

	// The name of the simulation application.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The rendering engine for the simulation application.
	RenderingEngine *RenderingEngine `locationName:"renderingEngine" type:"structure"`

	// The robot software suite (ROS distribution) used by the simulation application.
	//
	// RobotSoftwareSuite is a required field
	RobotSoftwareSuite *RobotSoftwareSuite `locationName:"robotSoftwareSuite" type:"structure" required:"true"`

	// The simulation software suite used by the simulation application.
	//
	// SimulationSoftwareSuite is a required field
	SimulationSoftwareSuite *SimulationSoftwareSuite `locationName:"simulationSoftwareSuite" type:"structure" required:"true"`

	// The sources of the simulation application.
	//
	// Sources is a required field
	Sources []SourceConfig `locationName:"sources" type:"list" required:"true"`

	// A map that contains tag keys and tag values that are attached to the simulation
	// application.
	Tags map[string]string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateSimulationApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSimulationApplicationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateSimulationApplicationInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.RobotSoftwareSuite == nil {
		invalidParams.Add(aws.NewErrParamRequired("RobotSoftwareSuite"))
	}

	if s.SimulationSoftwareSuite == nil {
		invalidParams.Add(aws.NewErrParamRequired("SimulationSoftwareSuite"))
	}

	if s.Sources == nil {
		invalidParams.Add(aws.NewErrParamRequired("Sources"))
	}
	if s.RenderingEngine != nil {
		if err := s.RenderingEngine.Validate(); err != nil {
			invalidParams.AddNested("RenderingEngine", err.(aws.ErrInvalidParams))
		}
	}
	if s.Sources != nil {
		for i, v := range s.Sources {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Sources", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateSimulationApplicationInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RenderingEngine != nil {
		v := s.RenderingEngine

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "renderingEngine", v, metadata)
	}
	if s.RobotSoftwareSuite != nil {
		v := s.RobotSoftwareSuite

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "robotSoftwareSuite", v, metadata)
	}
	if s.SimulationSoftwareSuite != nil {
		v := s.SimulationSoftwareSuite

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "simulationSoftwareSuite", v, metadata)
	}
	if s.Sources != nil {
		v := s.Sources

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "sources", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

type CreateSimulationApplicationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the simulation application.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the simulation application
	// was last updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// The name of the simulation application.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The rendering engine for the simulation application.
	RenderingEngine *RenderingEngine `locationName:"renderingEngine" type:"structure"`

	// The revision id of the simulation application.
	RevisionId *string `locationName:"revisionId" min:"1" type:"string"`

	// Information about the robot software suite (ROS distribution).
	RobotSoftwareSuite *RobotSoftwareSuite `locationName:"robotSoftwareSuite" type:"structure"`

	// The simulation software suite used by the simulation application.
	SimulationSoftwareSuite *SimulationSoftwareSuite `locationName:"simulationSoftwareSuite" type:"structure"`

	// The sources of the simulation application.
	Sources []Source `locationName:"sources" type:"list"`

	// The list of all tags added to the simulation application.
	Tags map[string]string `locationName:"tags" type:"map"`

	// The version of the simulation application.
	Version *string `locationName:"version" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateSimulationApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateSimulationApplicationOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastUpdatedAt != nil {
		v := *s.LastUpdatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdatedAt",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RenderingEngine != nil {
		v := s.RenderingEngine

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "renderingEngine", v, metadata)
	}
	if s.RevisionId != nil {
		v := *s.RevisionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "revisionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RobotSoftwareSuite != nil {
		v := s.RobotSoftwareSuite

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "robotSoftwareSuite", v, metadata)
	}
	if s.SimulationSoftwareSuite != nil {
		v := s.SimulationSoftwareSuite

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "simulationSoftwareSuite", v, metadata)
	}
	if s.Sources != nil {
		v := s.Sources

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "sources", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opCreateSimulationApplication = "CreateSimulationApplication"

// CreateSimulationApplicationRequest returns a request value for making API operation for
// AWS RoboMaker.
//
// Creates a simulation application.
//
//    // Example sending a request using CreateSimulationApplicationRequest.
//    req := client.CreateSimulationApplicationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateSimulationApplication
func (c *Client) CreateSimulationApplicationRequest(input *CreateSimulationApplicationInput) CreateSimulationApplicationRequest {
	op := &aws.Operation{
		Name:       opCreateSimulationApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/createSimulationApplication",
	}

	if input == nil {
		input = &CreateSimulationApplicationInput{}
	}

	req := c.newRequest(op, input, &CreateSimulationApplicationOutput{})

	return CreateSimulationApplicationRequest{Request: req, Input: input, Copy: c.CreateSimulationApplicationRequest}
}

// CreateSimulationApplicationRequest is the request type for the
// CreateSimulationApplication API operation.
type CreateSimulationApplicationRequest struct {
	*aws.Request
	Input *CreateSimulationApplicationInput
	Copy  func(*CreateSimulationApplicationInput) CreateSimulationApplicationRequest
}

// Send marshals and sends the CreateSimulationApplication API request.
func (r CreateSimulationApplicationRequest) Send(ctx context.Context) (*CreateSimulationApplicationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateSimulationApplicationResponse{
		CreateSimulationApplicationOutput: r.Request.Data.(*CreateSimulationApplicationOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateSimulationApplicationResponse is the response type for the
// CreateSimulationApplication API operation.
type CreateSimulationApplicationResponse struct {
	*CreateSimulationApplicationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateSimulationApplication request.
func (r *CreateSimulationApplicationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
