// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package redshift

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type BatchDeleteClusterSnapshotsInput struct {
	_ struct{} `type:"structure"`

	// A list of identifiers for the snapshots that you want to delete.
	//
	// Identifiers is a required field
	Identifiers []DeleteClusterSnapshotMessage `locationNameList:"DeleteClusterSnapshotMessage" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchDeleteClusterSnapshotsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDeleteClusterSnapshotsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchDeleteClusterSnapshotsInput"}

	if s.Identifiers == nil {
		invalidParams.Add(aws.NewErrParamRequired("Identifiers"))
	}
	if s.Identifiers != nil {
		for i, v := range s.Identifiers {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Identifiers", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type BatchDeleteClusterSnapshotsOutput struct {
	_ struct{} `type:"structure"`

	// A list of any errors returned.
	Errors []SnapshotErrorMessage `locationNameList:"SnapshotErrorMessage" type:"list"`

	// A list of the snapshot identifiers that were deleted.
	Resources []string `locationNameList:"String" type:"list"`
}

// String returns the string representation
func (s BatchDeleteClusterSnapshotsOutput) String() string {
	return awsutil.Prettify(s)
}

const opBatchDeleteClusterSnapshots = "BatchDeleteClusterSnapshots"

// BatchDeleteClusterSnapshotsRequest returns a request value for making API operation for
// Amazon Redshift.
//
// Deletes a set of cluster snapshots.
//
//    // Example sending a request using BatchDeleteClusterSnapshotsRequest.
//    req := client.BatchDeleteClusterSnapshotsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/BatchDeleteClusterSnapshots
func (c *Client) BatchDeleteClusterSnapshotsRequest(input *BatchDeleteClusterSnapshotsInput) BatchDeleteClusterSnapshotsRequest {
	op := &aws.Operation{
		Name:       opBatchDeleteClusterSnapshots,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchDeleteClusterSnapshotsInput{}
	}

	req := c.newRequest(op, input, &BatchDeleteClusterSnapshotsOutput{})

	return BatchDeleteClusterSnapshotsRequest{Request: req, Input: input, Copy: c.BatchDeleteClusterSnapshotsRequest}
}

// BatchDeleteClusterSnapshotsRequest is the request type for the
// BatchDeleteClusterSnapshots API operation.
type BatchDeleteClusterSnapshotsRequest struct {
	*aws.Request
	Input *BatchDeleteClusterSnapshotsInput
	Copy  func(*BatchDeleteClusterSnapshotsInput) BatchDeleteClusterSnapshotsRequest
}

// Send marshals and sends the BatchDeleteClusterSnapshots API request.
func (r BatchDeleteClusterSnapshotsRequest) Send(ctx context.Context) (*BatchDeleteClusterSnapshotsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &BatchDeleteClusterSnapshotsResponse{
		BatchDeleteClusterSnapshotsOutput: r.Request.Data.(*BatchDeleteClusterSnapshotsOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// BatchDeleteClusterSnapshotsResponse is the response type for the
// BatchDeleteClusterSnapshots API operation.
type BatchDeleteClusterSnapshotsResponse struct {
	*BatchDeleteClusterSnapshotsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// BatchDeleteClusterSnapshots request.
func (r *BatchDeleteClusterSnapshotsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
