// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rds

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ModifyDBClusterEndpointInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the endpoint to modify. This parameter is stored as a lowercase
	// string.
	//
	// DBClusterEndpointIdentifier is a required field
	DBClusterEndpointIdentifier *string `type:"string" required:"true"`

	// The type of the endpoint. One of: READER, WRITER, ANY.
	EndpointType *string `type:"string"`

	// List of DB instance identifiers that aren't part of the custom endpoint group.
	// All other eligible instances are reachable through the custom endpoint. Only
	// relevant if the list of static members is empty.
	ExcludedMembers []string `type:"list"`

	// List of DB instance identifiers that are part of the custom endpoint group.
	StaticMembers []string `type:"list"`
}

// String returns the string representation
func (s ModifyDBClusterEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyDBClusterEndpointInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModifyDBClusterEndpointInput"}

	if s.DBClusterEndpointIdentifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("DBClusterEndpointIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// This data type represents the information you need to connect to an Amazon
// Aurora DB cluster. This data type is used as a response element in the following
// actions:
//
//    * CreateDBClusterEndpoint
//
//    * DescribeDBClusterEndpoints
//
//    * ModifyDBClusterEndpoint
//
//    * DeleteDBClusterEndpoint
//
// For the data structure that represents Amazon RDS DB instance endpoints,
// see Endpoint.
type ModifyDBClusterEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The type associated with a custom endpoint. One of: READER, WRITER, ANY.
	CustomEndpointType *string `type:"string"`

	// The Amazon Resource Name (ARN) for the endpoint.
	DBClusterEndpointArn *string `type:"string"`

	// The identifier associated with the endpoint. This parameter is stored as
	// a lowercase string.
	DBClusterEndpointIdentifier *string `type:"string"`

	// A unique system-generated identifier for an endpoint. It remains the same
	// for the whole life of the endpoint.
	DBClusterEndpointResourceIdentifier *string `type:"string"`

	// The DB cluster identifier of the DB cluster associated with the endpoint.
	// This parameter is stored as a lowercase string.
	DBClusterIdentifier *string `type:"string"`

	// The DNS address of the endpoint.
	Endpoint *string `type:"string"`

	// The type of the endpoint. One of: READER, WRITER, CUSTOM.
	EndpointType *string `type:"string"`

	// List of DB instance identifiers that aren't part of the custom endpoint group.
	// All other eligible instances are reachable through the custom endpoint. Only
	// relevant if the list of static members is empty.
	ExcludedMembers []string `type:"list"`

	// List of DB instance identifiers that are part of the custom endpoint group.
	StaticMembers []string `type:"list"`

	// The current status of the endpoint. One of: creating, available, deleting,
	// modifying.
	Status *string `type:"string"`
}

// String returns the string representation
func (s ModifyDBClusterEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

const opModifyDBClusterEndpoint = "ModifyDBClusterEndpoint"

// ModifyDBClusterEndpointRequest returns a request value for making API operation for
// Amazon Relational Database Service.
//
// Modifies the properties of an endpoint in an Amazon Aurora DB cluster.
//
// This action only applies to Aurora DB clusters.
//
//    // Example sending a request using ModifyDBClusterEndpointRequest.
//    req := client.ModifyDBClusterEndpointRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBClusterEndpoint
func (c *Client) ModifyDBClusterEndpointRequest(input *ModifyDBClusterEndpointInput) ModifyDBClusterEndpointRequest {
	op := &aws.Operation{
		Name:       opModifyDBClusterEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyDBClusterEndpointInput{}
	}

	req := c.newRequest(op, input, &ModifyDBClusterEndpointOutput{})

	return ModifyDBClusterEndpointRequest{Request: req, Input: input, Copy: c.ModifyDBClusterEndpointRequest}
}

// ModifyDBClusterEndpointRequest is the request type for the
// ModifyDBClusterEndpoint API operation.
type ModifyDBClusterEndpointRequest struct {
	*aws.Request
	Input *ModifyDBClusterEndpointInput
	Copy  func(*ModifyDBClusterEndpointInput) ModifyDBClusterEndpointRequest
}

// Send marshals and sends the ModifyDBClusterEndpoint API request.
func (r ModifyDBClusterEndpointRequest) Send(ctx context.Context) (*ModifyDBClusterEndpointResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ModifyDBClusterEndpointResponse{
		ModifyDBClusterEndpointOutput: r.Request.Data.(*ModifyDBClusterEndpointOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ModifyDBClusterEndpointResponse is the response type for the
// ModifyDBClusterEndpoint API operation.
type ModifyDBClusterEndpointResponse struct {
	*ModifyDBClusterEndpointOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ModifyDBClusterEndpoint request.
func (r *ModifyDBClusterEndpointResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
