// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package quicksight

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// The active AWS Identity and Access Management (IAM) policy assignment.
type ActiveIAMPolicyAssignment struct {
	_ struct{} `type:"structure"`

	// A name for the IAM policy assignment.
	AssignmentName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the resource.
	PolicyArn *string `type:"string"`
}

// String returns the string representation
func (s ActiveIAMPolicyAssignment) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ActiveIAMPolicyAssignment) MarshalFields(e protocol.FieldEncoder) error {
	if s.AssignmentName != nil {
		v := *s.AssignmentName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AssignmentName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PolicyArn != nil {
		v := *s.PolicyArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PolicyArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Ad hoc (one-time) filtering option.
type AdHocFilteringOption struct {
	_ struct{} `type:"structure"`

	// Availability status.
	AvailabilityStatus DashboardBehavior `type:"string" enum:"true"`
}

// String returns the string representation
func (s AdHocFilteringOption) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AdHocFilteringOption) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.AvailabilityStatus) > 0 {
		v := s.AvailabilityStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AvailabilityStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Amazon Elasticsearch Service parameters.
type AmazonElasticsearchParameters struct {
	_ struct{} `type:"structure"`

	// The Amazon Elasticsearch Service domain.
	//
	// Domain is a required field
	Domain *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AmazonElasticsearchParameters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AmazonElasticsearchParameters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AmazonElasticsearchParameters"}

	if s.Domain == nil {
		invalidParams.Add(aws.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Domain", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AmazonElasticsearchParameters) MarshalFields(e protocol.FieldEncoder) error {
	if s.Domain != nil {
		v := *s.Domain

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Domain", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Amazon Athena parameters.
type AthenaParameters struct {
	_ struct{} `type:"structure"`

	// The workgroup that Amazon Athena uses.
	WorkGroup *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AthenaParameters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AthenaParameters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AthenaParameters"}
	if s.WorkGroup != nil && len(*s.WorkGroup) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("WorkGroup", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AthenaParameters) MarshalFields(e protocol.FieldEncoder) error {
	if s.WorkGroup != nil {
		v := *s.WorkGroup

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "WorkGroup", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Amazon Aurora parameters.
type AuroraParameters struct {
	_ struct{} `type:"structure"`

	// Database.
	//
	// Database is a required field
	Database *string `min:"1" type:"string" required:"true"`

	// Host.
	//
	// Host is a required field
	Host *string `min:"1" type:"string" required:"true"`

	// Port.
	//
	// Port is a required field
	Port *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s AuroraParameters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AuroraParameters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AuroraParameters"}

	if s.Database == nil {
		invalidParams.Add(aws.NewErrParamRequired("Database"))
	}
	if s.Database != nil && len(*s.Database) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Database", 1))
	}

	if s.Host == nil {
		invalidParams.Add(aws.NewErrParamRequired("Host"))
	}
	if s.Host != nil && len(*s.Host) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Host", 1))
	}

	if s.Port == nil {
		invalidParams.Add(aws.NewErrParamRequired("Port"))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Port", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AuroraParameters) MarshalFields(e protocol.FieldEncoder) error {
	if s.Database != nil {
		v := *s.Database

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Database", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Host != nil {
		v := *s.Host

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Host", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Port != nil {
		v := *s.Port

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Port", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Amazon Aurora with PostgreSQL compatibility parameters.
type AuroraPostgreSqlParameters struct {
	_ struct{} `type:"structure"`

	// Database.
	//
	// Database is a required field
	Database *string `min:"1" type:"string" required:"true"`

	// Host.
	//
	// Host is a required field
	Host *string `min:"1" type:"string" required:"true"`

	// Port.
	//
	// Port is a required field
	Port *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s AuroraPostgreSqlParameters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AuroraPostgreSqlParameters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AuroraPostgreSqlParameters"}

	if s.Database == nil {
		invalidParams.Add(aws.NewErrParamRequired("Database"))
	}
	if s.Database != nil && len(*s.Database) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Database", 1))
	}

	if s.Host == nil {
		invalidParams.Add(aws.NewErrParamRequired("Host"))
	}
	if s.Host != nil && len(*s.Host) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Host", 1))
	}

	if s.Port == nil {
		invalidParams.Add(aws.NewErrParamRequired("Port"))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Port", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AuroraPostgreSqlParameters) MarshalFields(e protocol.FieldEncoder) error {
	if s.Database != nil {
		v := *s.Database

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Database", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Host != nil {
		v := *s.Host

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Host", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Port != nil {
		v := *s.Port

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Port", protocol.Int64Value(v), metadata)
	}
	return nil
}

// AWS IoT Analytics parameters.
type AwsIotAnalyticsParameters struct {
	_ struct{} `type:"structure"`

	// Dataset name.
	//
	// DataSetName is a required field
	DataSetName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AwsIotAnalyticsParameters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AwsIotAnalyticsParameters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AwsIotAnalyticsParameters"}

	if s.DataSetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DataSetName"))
	}
	if s.DataSetName != nil && len(*s.DataSetName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DataSetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsIotAnalyticsParameters) MarshalFields(e protocol.FieldEncoder) error {
	if s.DataSetName != nil {
		v := *s.DataSetName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DataSetName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The display options for tile borders for visuals.
type BorderStyle struct {
	_ struct{} `type:"structure"`

	// The option to enable display of borders for visuals.
	Show *bool `type:"boolean"`
}

// String returns the string representation
func (s BorderStyle) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BorderStyle) MarshalFields(e protocol.FieldEncoder) error {
	if s.Show != nil {
		v := *s.Show

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Show", protocol.BoolValue(v), metadata)
	}
	return nil
}

// A calculated column for a dataset.
type CalculatedColumn struct {
	_ struct{} `type:"structure"`

	// A unique ID to identify a calculated column. During a dataset update, if
	// the column ID of a calculated column matches that of an existing calculated
	// column, Amazon QuickSight preserves the existing calculated column.
	//
	// ColumnId is a required field
	ColumnId *string `min:"1" type:"string" required:"true"`

	// Column name.
	//
	// ColumnName is a required field
	ColumnName *string `min:"1" type:"string" required:"true"`

	// An expression that defines the calculated column.
	//
	// Expression is a required field
	Expression *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CalculatedColumn) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CalculatedColumn) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CalculatedColumn"}

	if s.ColumnId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ColumnId"))
	}
	if s.ColumnId != nil && len(*s.ColumnId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ColumnId", 1))
	}

	if s.ColumnName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ColumnName"))
	}
	if s.ColumnName != nil && len(*s.ColumnName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ColumnName", 1))
	}

	if s.Expression == nil {
		invalidParams.Add(aws.NewErrParamRequired("Expression"))
	}
	if s.Expression != nil && len(*s.Expression) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Expression", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CalculatedColumn) MarshalFields(e protocol.FieldEncoder) error {
	if s.ColumnId != nil {
		v := *s.ColumnId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ColumnId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ColumnName != nil {
		v := *s.ColumnName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ColumnName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Expression != nil {
		v := *s.Expression

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Expression", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A transform operation that casts a column to a different type.
type CastColumnTypeOperation struct {
	_ struct{} `type:"structure"`

	// Column name.
	//
	// ColumnName is a required field
	ColumnName *string `min:"1" type:"string" required:"true"`

	// When casting a column from string to datetime type, you can supply a string
	// in a format supported by Amazon QuickSight to denote the source data format.
	Format *string `type:"string"`

	// New column data type.
	//
	// NewColumnType is a required field
	NewColumnType ColumnDataType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s CastColumnTypeOperation) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CastColumnTypeOperation) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CastColumnTypeOperation"}

	if s.ColumnName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ColumnName"))
	}
	if s.ColumnName != nil && len(*s.ColumnName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ColumnName", 1))
	}
	if len(s.NewColumnType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("NewColumnType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CastColumnTypeOperation) MarshalFields(e protocol.FieldEncoder) error {
	if s.ColumnName != nil {
		v := *s.ColumnName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ColumnName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Format != nil {
		v := *s.Format

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Format", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.NewColumnType) > 0 {
		v := s.NewColumnType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NewColumnType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Groupings of columns that work together in certain Amazon QuickSight features.
// This is a variant type structure. For this structure to be valid, only one
// of the attributes can be non-null.
type ColumnGroup struct {
	_ struct{} `type:"structure"`

	// Geospatial column group that denotes a hierarchy.
	GeoSpatialColumnGroup *GeoSpatialColumnGroup `type:"structure"`
}

// String returns the string representation
func (s ColumnGroup) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ColumnGroup) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ColumnGroup"}
	if s.GeoSpatialColumnGroup != nil {
		if err := s.GeoSpatialColumnGroup.Validate(); err != nil {
			invalidParams.AddNested("GeoSpatialColumnGroup", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ColumnGroup) MarshalFields(e protocol.FieldEncoder) error {
	if s.GeoSpatialColumnGroup != nil {
		v := s.GeoSpatialColumnGroup

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "GeoSpatialColumnGroup", v, metadata)
	}
	return nil
}

// A structure describing the name, data type, and geographic role of the columns.
type ColumnGroupColumnSchema struct {
	_ struct{} `type:"structure"`

	// The name of the column group's column schema.
	Name *string `type:"string"`
}

// String returns the string representation
func (s ColumnGroupColumnSchema) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ColumnGroupColumnSchema) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The column group schema.
type ColumnGroupSchema struct {
	_ struct{} `type:"structure"`

	// A structure containing the list of schemas for column group columns.
	ColumnGroupColumnSchemaList []ColumnGroupColumnSchema `type:"list"`

	// The name of the column group schema.
	Name *string `type:"string"`
}

// String returns the string representation
func (s ColumnGroupSchema) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ColumnGroupSchema) MarshalFields(e protocol.FieldEncoder) error {
	if s.ColumnGroupColumnSchemaList != nil {
		v := s.ColumnGroupColumnSchemaList

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ColumnGroupColumnSchemaList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The column schema.
type ColumnSchema struct {
	_ struct{} `type:"structure"`

	// The data type of the column schema.
	DataType *string `type:"string"`

	// The geographic role of the column schema.
	GeographicRole *string `type:"string"`

	// The name of the column schema.
	Name *string `type:"string"`
}

// String returns the string representation
func (s ColumnSchema) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ColumnSchema) MarshalFields(e protocol.FieldEncoder) error {
	if s.DataType != nil {
		v := *s.DataType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DataType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GeographicRole != nil {
		v := *s.GeographicRole

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GeographicRole", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A tag for a column in a TagColumnOperation structure. This is a variant type
// structure. For this structure to be valid, only one of the attributes can
// be non-null.
type ColumnTag struct {
	_ struct{} `type:"structure"`

	// A geospatial role for a column.
	ColumnGeographicRole GeoSpatialDataRole `type:"string" enum:"true"`
}

// String returns the string representation
func (s ColumnTag) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ColumnTag) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.ColumnGeographicRole) > 0 {
		v := s.ColumnGeographicRole

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ColumnGeographicRole", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// A transform operation that creates calculated columns. Columns created in
// one such operation form a lexical closure.
type CreateColumnsOperation struct {
	_ struct{} `type:"structure"`

	// Calculated columns to create.
	//
	// Columns is a required field
	Columns []CalculatedColumn `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s CreateColumnsOperation) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateColumnsOperation) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateColumnsOperation"}

	if s.Columns == nil {
		invalidParams.Add(aws.NewErrParamRequired("Columns"))
	}
	if s.Columns != nil && len(s.Columns) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Columns", 1))
	}
	if s.Columns != nil {
		for i, v := range s.Columns {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Columns", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateColumnsOperation) MarshalFields(e protocol.FieldEncoder) error {
	if s.Columns != nil {
		v := s.Columns

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Columns", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// The combination of user name and password that are used as credentials.
type CredentialPair struct {
	_ struct{} `type:"structure"`

	// A set of alternate data source parameters that you want to share for these
	// credentials. The credentials are applied in tandem with the data source parameters
	// when you copy a data source by using a create or update request. The API
	// compares the DataSourceParameters structure that's in the request with the
	// structures in the AlternateDataSourceParameters allowlist. If the structures
	// are an exact match, the request is allowed to use the new data source with
	// the existing credentials. If the AlternateDataSourceParameters list is null,
	// the DataSourceParameters originally used with these Credentials is automatically
	// allowed.
	AlternateDataSourceParameters []DataSourceParameters `min:"1" type:"list"`

	// Password.
	//
	// Password is a required field
	Password *string `min:"1" type:"string" required:"true"`

	// User name.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CredentialPair) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CredentialPair) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CredentialPair"}
	if s.AlternateDataSourceParameters != nil && len(s.AlternateDataSourceParameters) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AlternateDataSourceParameters", 1))
	}

	if s.Password == nil {
		invalidParams.Add(aws.NewErrParamRequired("Password"))
	}
	if s.Password != nil && len(*s.Password) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Password", 1))
	}

	if s.Username == nil {
		invalidParams.Add(aws.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Username", 1))
	}
	if s.AlternateDataSourceParameters != nil {
		for i, v := range s.AlternateDataSourceParameters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AlternateDataSourceParameters", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CredentialPair) MarshalFields(e protocol.FieldEncoder) error {
	if s.AlternateDataSourceParameters != nil {
		v := s.AlternateDataSourceParameters

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "AlternateDataSourceParameters", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Password != nil {
		v := *s.Password

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Password", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Username != nil {
		v := *s.Username

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Username", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A physical table type built from the results of the custom SQL query.
type CustomSql struct {
	_ struct{} `type:"structure"`

	// The column schema from the SQL query result set.
	Columns []InputColumn `min:"1" type:"list"`

	// The Amazon Resource Name (ARN) of the data source.
	//
	// DataSourceArn is a required field
	DataSourceArn *string `type:"string" required:"true"`

	// A display name for the SQL query result.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The SQL query.
	//
	// SqlQuery is a required field
	SqlQuery *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CustomSql) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomSql) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CustomSql"}
	if s.Columns != nil && len(s.Columns) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Columns", 1))
	}

	if s.DataSourceArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("DataSourceArn"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.SqlQuery == nil {
		invalidParams.Add(aws.NewErrParamRequired("SqlQuery"))
	}
	if s.SqlQuery != nil && len(*s.SqlQuery) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SqlQuery", 1))
	}
	if s.Columns != nil {
		for i, v := range s.Columns {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Columns", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CustomSql) MarshalFields(e protocol.FieldEncoder) error {
	if s.Columns != nil {
		v := s.Columns

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Columns", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.DataSourceArn != nil {
		v := *s.DataSourceArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DataSourceArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SqlQuery != nil {
		v := *s.SqlQuery

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SqlQuery", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Dashboard.
type Dashboard struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	Arn *string `type:"string"`

	// The time that this dataset was created.
	CreatedTime *time.Time `type:"timestamp"`

	// Dashboard ID.
	DashboardId *string `min:"1" type:"string"`

	// The last time that this dataset was published.
	LastPublishedTime *time.Time `type:"timestamp"`

	// The last time that this dataset was updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// A display name for the dashboard.
	Name *string `min:"1" type:"string"`

	// Version.
	Version *DashboardVersion `type:"structure"`
}

// String returns the string representation
func (s Dashboard) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Dashboard) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedTime != nil {
		v := *s.CreatedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.DashboardId != nil {
		v := *s.DashboardId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DashboardId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastPublishedTime != nil {
		v := *s.LastPublishedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastPublishedTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.LastUpdatedTime != nil {
		v := *s.LastUpdatedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastUpdatedTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := s.Version

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Version", v, metadata)
	}
	return nil
}

// Dashboard error.
type DashboardError struct {
	_ struct{} `type:"structure"`

	// Message.
	Message *string `type:"string"`

	// Type.
	Type DashboardErrorType `type:"string" enum:"true"`
}

// String returns the string representation
func (s DashboardError) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DashboardError) MarshalFields(e protocol.FieldEncoder) error {
	if s.Message != nil {
		v := *s.Message

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Message", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Dashboard publish options.
type DashboardPublishOptions struct {
	_ struct{} `type:"structure"`

	// Ad hoc (one-time) filtering option.
	AdHocFilteringOption *AdHocFilteringOption `type:"structure"`

	// Export to .csv option.
	ExportToCSVOption *ExportToCSVOption `type:"structure"`

	// Sheet controls option.
	SheetControlsOption *SheetControlsOption `type:"structure"`
}

// String returns the string representation
func (s DashboardPublishOptions) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DashboardPublishOptions) MarshalFields(e protocol.FieldEncoder) error {
	if s.AdHocFilteringOption != nil {
		v := s.AdHocFilteringOption

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AdHocFilteringOption", v, metadata)
	}
	if s.ExportToCSVOption != nil {
		v := s.ExportToCSVOption

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ExportToCSVOption", v, metadata)
	}
	if s.SheetControlsOption != nil {
		v := s.SheetControlsOption

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SheetControlsOption", v, metadata)
	}
	return nil
}

// A filter that you apply when searching for dashboards.
type DashboardSearchFilter struct {
	_ struct{} `type:"structure"`

	// The name of the value that you want to use as a filter, for example, "Name":
	// "QUICKSIGHT_USER".
	Name DashboardFilterAttribute `type:"string" enum:"true"`

	// The comparison operator that you want to use as a filter, for example, "Operator":
	// "StringEquals".
	//
	// Operator is a required field
	Operator FilterOperator `type:"string" required:"true" enum:"true"`

	// The value of the named item, in this case QUICKSIGHT_USER, that you want
	// to use as a filter, for example, "Value": "arn:aws:quicksight:us-east-1:1:user/default/UserName1".
	Value *string `type:"string"`
}

// String returns the string representation
func (s DashboardSearchFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DashboardSearchFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DashboardSearchFilter"}
	if len(s.Operator) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Operator"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DashboardSearchFilter) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Name) > 0 {
		v := s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Operator) > 0 {
		v := s.Operator

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Operator", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Dashboard source entity.
type DashboardSourceEntity struct {
	_ struct{} `type:"structure"`

	// Source template.
	SourceTemplate *DashboardSourceTemplate `type:"structure"`
}

// String returns the string representation
func (s DashboardSourceEntity) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DashboardSourceEntity) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DashboardSourceEntity"}
	if s.SourceTemplate != nil {
		if err := s.SourceTemplate.Validate(); err != nil {
			invalidParams.AddNested("SourceTemplate", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DashboardSourceEntity) MarshalFields(e protocol.FieldEncoder) error {
	if s.SourceTemplate != nil {
		v := s.SourceTemplate

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SourceTemplate", v, metadata)
	}
	return nil
}

// Dashboard source template.
type DashboardSourceTemplate struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// Dataset references.
	//
	// DataSetReferences is a required field
	DataSetReferences []DataSetReference `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s DashboardSourceTemplate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DashboardSourceTemplate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DashboardSourceTemplate"}

	if s.Arn == nil {
		invalidParams.Add(aws.NewErrParamRequired("Arn"))
	}

	if s.DataSetReferences == nil {
		invalidParams.Add(aws.NewErrParamRequired("DataSetReferences"))
	}
	if s.DataSetReferences != nil && len(s.DataSetReferences) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DataSetReferences", 1))
	}
	if s.DataSetReferences != nil {
		for i, v := range s.DataSetReferences {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DataSetReferences", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DashboardSourceTemplate) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DataSetReferences != nil {
		v := s.DataSetReferences

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "DataSetReferences", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Dashboard summary.
type DashboardSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	Arn *string `type:"string"`

	// The time that this dashboard was created.
	CreatedTime *time.Time `type:"timestamp"`

	// Dashboard ID.
	DashboardId *string `min:"1" type:"string"`

	// The last time that this dashboard was published.
	LastPublishedTime *time.Time `type:"timestamp"`

	// The last time that this dashboard was updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// A display name for the dashboard.
	Name *string `min:"1" type:"string"`

	// Published version number.
	PublishedVersionNumber *int64 `min:"1" type:"long"`
}

// String returns the string representation
func (s DashboardSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DashboardSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedTime != nil {
		v := *s.CreatedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.DashboardId != nil {
		v := *s.DashboardId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DashboardId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastPublishedTime != nil {
		v := *s.LastPublishedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastPublishedTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.LastUpdatedTime != nil {
		v := *s.LastUpdatedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastUpdatedTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PublishedVersionNumber != nil {
		v := *s.PublishedVersionNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PublishedVersionNumber", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Dashboard version.
type DashboardVersion struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	Arn *string `type:"string"`

	// The time that this dashboard version was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The Amazon Resource Numbers (ARNs) for the datasets that are associated with
	// a version of the dashboard.
	DataSetArns []string `type:"list"`

	// Description.
	Description *string `min:"1" type:"string"`

	// Errors.
	Errors []DashboardError `min:"1" type:"list"`

	// Source entity ARN.
	SourceEntityArn *string `type:"string"`

	// The HTTP status of the request.
	Status ResourceStatus `type:"string" enum:"true"`

	// Version number.
	VersionNumber *int64 `min:"1" type:"long"`
}

// String returns the string representation
func (s DashboardVersion) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DashboardVersion) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedTime != nil {
		v := *s.CreatedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.DataSetArns != nil {
		v := s.DataSetArns

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "DataSetArns", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Errors != nil {
		v := s.Errors

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Errors", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.SourceEntityArn != nil {
		v := *s.SourceEntityArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SourceEntityArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.VersionNumber != nil {
		v := *s.VersionNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VersionNumber", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Dashboard version summary.
type DashboardVersionSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	Arn *string `type:"string"`

	// The time that this dashboard version was created.
	CreatedTime *time.Time `type:"timestamp"`

	// Description.
	Description *string `min:"1" type:"string"`

	// Source entity ARN.
	SourceEntityArn *string `type:"string"`

	// The HTTP status of the request.
	Status ResourceStatus `type:"string" enum:"true"`

	// Version number.
	VersionNumber *int64 `min:"1" type:"long"`
}

// String returns the string representation
func (s DashboardVersionSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DashboardVersionSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedTime != nil {
		v := *s.CreatedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SourceEntityArn != nil {
		v := *s.SourceEntityArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SourceEntityArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.VersionNumber != nil {
		v := *s.VersionNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VersionNumber", protocol.Int64Value(v), metadata)
	}
	return nil
}

// The theme colors that are used for data colors in charts. The colors description
// is a hexidecimal color code that consists of six alphanumerical characters,
// prefixed with #, for example #37BFF5.
type DataColorPalette struct {
	_ struct{} `type:"structure"`

	// The hexadecimal codes for the colors.
	Colors []string `type:"list"`

	// The hexadecimal code of a color that applies to charts where a lack of data
	// is highlighted.
	EmptyFillColor *string `type:"string"`

	// The minimum and maximum hexadecimal codes that describe a color gradient.
	MinMaxGradient []string `type:"list"`
}

// String returns the string representation
func (s DataColorPalette) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DataColorPalette) MarshalFields(e protocol.FieldEncoder) error {
	if s.Colors != nil {
		v := s.Colors

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Colors", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.EmptyFillColor != nil {
		v := *s.EmptyFillColor

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EmptyFillColor", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MinMaxGradient != nil {
		v := s.MinMaxGradient

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "MinMaxGradient", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// Dataset.
type DataSet struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	Arn *string `type:"string"`

	// Groupings of columns that work together in certain Amazon QuickSight features.
	// Currently, only geospatial hierarchy is supported.
	ColumnGroups []ColumnGroup `min:"1" type:"list"`

	// The amount of SPICE capacity used by this dataset. This is 0 if the dataset
	// isn't imported into SPICE.
	ConsumedSpiceCapacityInBytes *int64 `type:"long"`

	// The time that this dataset was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The ID of the dataset.
	DataSetId *string `type:"string"`

	// Indicates whether you want to import the data into SPICE.
	ImportMode DataSetImportMode `type:"string" enum:"true"`

	// The last time that this dataset was updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// Configures the combination and transformation of the data from the physical
	// tables.
	LogicalTableMap map[string]LogicalTable `min:"1" type:"map"`

	// A display name for the dataset.
	Name *string `min:"1" type:"string"`

	// The list of columns after all transforms. These columns are available in
	// templates, analyses, and dashboards.
	OutputColumns []OutputColumn `type:"list"`

	// Declares the physical tables that are available in the underlying data sources.
	PhysicalTableMap map[string]PhysicalTable `min:"1" type:"map"`

	// The row-level security configuration for the dataset.
	RowLevelPermissionDataSet *RowLevelPermissionDataSet `type:"structure"`
}

// String returns the string representation
func (s DataSet) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DataSet) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ColumnGroups != nil {
		v := s.ColumnGroups

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ColumnGroups", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ConsumedSpiceCapacityInBytes != nil {
		v := *s.ConsumedSpiceCapacityInBytes

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ConsumedSpiceCapacityInBytes", protocol.Int64Value(v), metadata)
	}
	if s.CreatedTime != nil {
		v := *s.CreatedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.DataSetId != nil {
		v := *s.DataSetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DataSetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ImportMode) > 0 {
		v := s.ImportMode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ImportMode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.LastUpdatedTime != nil {
		v := *s.LastUpdatedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastUpdatedTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.LogicalTableMap != nil {
		v := s.LogicalTableMap

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "LogicalTableMap", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OutputColumns != nil {
		v := s.OutputColumns

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "OutputColumns", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.PhysicalTableMap != nil {
		v := s.PhysicalTableMap

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "PhysicalTableMap", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	if s.RowLevelPermissionDataSet != nil {
		v := s.RowLevelPermissionDataSet

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "RowLevelPermissionDataSet", v, metadata)
	}
	return nil
}

// Dataset configuration.
type DataSetConfiguration struct {
	_ struct{} `type:"structure"`

	// A structure containing the list of column group schemas.
	ColumnGroupSchemaList []ColumnGroupSchema `type:"list"`

	// Dataset schema.
	DataSetSchema *DataSetSchema `type:"structure"`

	// Placeholder.
	Placeholder *string `type:"string"`
}

// String returns the string representation
func (s DataSetConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DataSetConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.ColumnGroupSchemaList != nil {
		v := s.ColumnGroupSchemaList

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ColumnGroupSchemaList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.DataSetSchema != nil {
		v := s.DataSetSchema

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DataSetSchema", v, metadata)
	}
	if s.Placeholder != nil {
		v := *s.Placeholder

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Placeholder", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Dataset reference.
type DataSetReference struct {
	_ struct{} `type:"structure"`

	// Dataset Amazon Resource Name (ARN).
	//
	// DataSetArn is a required field
	DataSetArn *string `type:"string" required:"true"`

	// Dataset placeholder.
	//
	// DataSetPlaceholder is a required field
	DataSetPlaceholder *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DataSetReference) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataSetReference) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DataSetReference"}

	if s.DataSetArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("DataSetArn"))
	}

	if s.DataSetPlaceholder == nil {
		invalidParams.Add(aws.NewErrParamRequired("DataSetPlaceholder"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DataSetReference) MarshalFields(e protocol.FieldEncoder) error {
	if s.DataSetArn != nil {
		v := *s.DataSetArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DataSetArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DataSetPlaceholder != nil {
		v := *s.DataSetPlaceholder

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DataSetPlaceholder", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Dataset schema.
type DataSetSchema struct {
	_ struct{} `type:"structure"`

	// A structure containing the list of column schemas.
	ColumnSchemaList []ColumnSchema `type:"list"`
}

// String returns the string representation
func (s DataSetSchema) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DataSetSchema) MarshalFields(e protocol.FieldEncoder) error {
	if s.ColumnSchemaList != nil {
		v := s.ColumnSchemaList

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ColumnSchemaList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Dataset summary.
type DataSetSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset.
	Arn *string `type:"string"`

	// The time that this dataset was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The ID of the dataset.
	DataSetId *string `type:"string"`

	// Indicates whether you want to import the data into SPICE.
	ImportMode DataSetImportMode `type:"string" enum:"true"`

	// The last time that this dataset was updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// A display name for the dataset.
	Name *string `min:"1" type:"string"`

	// The row-level security configuration for the dataset.
	RowLevelPermissionDataSet *RowLevelPermissionDataSet `type:"structure"`
}

// String returns the string representation
func (s DataSetSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DataSetSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedTime != nil {
		v := *s.CreatedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.DataSetId != nil {
		v := *s.DataSetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DataSetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ImportMode) > 0 {
		v := s.ImportMode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ImportMode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.LastUpdatedTime != nil {
		v := *s.LastUpdatedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastUpdatedTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RowLevelPermissionDataSet != nil {
		v := s.RowLevelPermissionDataSet

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "RowLevelPermissionDataSet", v, metadata)
	}
	return nil
}

// The structure of a data source.
type DataSource struct {
	_ struct{} `type:"structure"`

	// A set of alternate data source parameters that you want to share for the
	// credentials stored with this data source. The credentials are applied in
	// tandem with the data source parameters when you copy a data source by using
	// a create or update request. The API compares the DataSourceParameters structure
	// that's in the request with the structures in the AlternateDataSourceParameters
	// allowlist. If the structures are an exact match, the request is allowed to
	// use the credentials from this existing data source. If the AlternateDataSourceParameters
	// list is null, the Credentials originally used with this DataSourceParameters
	// are automatically allowed.
	AlternateDataSourceParameters []DataSourceParameters `min:"1" type:"list"`

	// The Amazon Resource Name (ARN) of the data source.
	Arn *string `type:"string"`

	// The time that this data source was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The ID of the data source. This ID is unique per AWS Region for each AWS
	// account.
	DataSourceId *string `type:"string"`

	// The parameters that Amazon QuickSight uses to connect to your underlying
	// source. This is a variant type structure. For this structure to be valid,
	// only one of the attributes can be non-null.
	DataSourceParameters *DataSourceParameters `type:"structure"`

	// Error information from the last update or the creation of the data source.
	ErrorInfo *DataSourceErrorInfo `type:"structure"`

	// The last time that this data source was updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// A display name for the data source.
	Name *string `min:"1" type:"string"`

	// Secure Socket Layer (SSL) properties that apply when QuickSight connects
	// to your underlying source.
	SslProperties *SslProperties `type:"structure"`

	// The HTTP status of the request.
	Status ResourceStatus `type:"string" enum:"true"`

	// The type of the data source. This type indicates which database engine the
	// data source connects to.
	Type DataSourceType `type:"string" enum:"true"`

	// The VPC connection information. You need to use this parameter only when
	// you want QuickSight to use a VPC connection when connecting to your underlying
	// source.
	VpcConnectionProperties *VpcConnectionProperties `type:"structure"`
}

// String returns the string representation
func (s DataSource) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DataSource) MarshalFields(e protocol.FieldEncoder) error {
	if s.AlternateDataSourceParameters != nil {
		v := s.AlternateDataSourceParameters

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "AlternateDataSourceParameters", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedTime != nil {
		v := *s.CreatedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.DataSourceId != nil {
		v := *s.DataSourceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DataSourceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DataSourceParameters != nil {
		v := s.DataSourceParameters

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DataSourceParameters", v, metadata)
	}
	if s.ErrorInfo != nil {
		v := s.ErrorInfo

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ErrorInfo", v, metadata)
	}
	if s.LastUpdatedTime != nil {
		v := *s.LastUpdatedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastUpdatedTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SslProperties != nil {
		v := s.SslProperties

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SslProperties", v, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.VpcConnectionProperties != nil {
		v := s.VpcConnectionProperties

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "VpcConnectionProperties", v, metadata)
	}
	return nil
}

// Data source credentials. This is a variant type structure. For this structure
// to be valid, only one of the attributes can be non-null.
type DataSourceCredentials struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The Amazon Resource Name (ARN) of a data source that has the credential pair
	// that you want to use. When CopySourceArn is not null, the credential pair
	// from the data source in the ARN is used as the credentials for the DataSourceCredentials
	// structure.
	CopySourceArn *string `type:"string"`

	// Credential pair. For more information, see CredentialPair.
	CredentialPair *CredentialPair `type:"structure"`
}

// String returns the string representation
func (s DataSourceCredentials) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataSourceCredentials) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DataSourceCredentials"}
	if s.CredentialPair != nil {
		if err := s.CredentialPair.Validate(); err != nil {
			invalidParams.AddNested("CredentialPair", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DataSourceCredentials) MarshalFields(e protocol.FieldEncoder) error {
	if s.CopySourceArn != nil {
		v := *s.CopySourceArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CopySourceArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CredentialPair != nil {
		v := s.CredentialPair

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CredentialPair", v, metadata)
	}
	return nil
}

// Error information for the data source creation or update.
type DataSourceErrorInfo struct {
	_ struct{} `type:"structure"`

	// Error message.
	Message *string `type:"string"`

	// Error type.
	Type DataSourceErrorInfoType `type:"string" enum:"true"`
}

// String returns the string representation
func (s DataSourceErrorInfo) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DataSourceErrorInfo) MarshalFields(e protocol.FieldEncoder) error {
	if s.Message != nil {
		v := *s.Message

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Message", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// The parameters that Amazon QuickSight uses to connect to your underlying
// data source. This is a variant type structure. For this structure to be valid,
// only one of the attributes can be non-null.
type DataSourceParameters struct {
	_ struct{} `type:"structure"`

	// Amazon Elasticsearch Service parameters.
	AmazonElasticsearchParameters *AmazonElasticsearchParameters `type:"structure"`

	// Amazon Athena parameters.
	AthenaParameters *AthenaParameters `type:"structure"`

	// Amazon Aurora MySQL parameters.
	AuroraParameters *AuroraParameters `type:"structure"`

	// Aurora PostgreSQL parameters.
	AuroraPostgreSqlParameters *AuroraPostgreSqlParameters `type:"structure"`

	// AWS IoT Analytics parameters.
	AwsIotAnalyticsParameters *AwsIotAnalyticsParameters `type:"structure"`

	// Jira parameters.
	JiraParameters *JiraParameters `type:"structure"`

	// MariaDB parameters.
	MariaDbParameters *MariaDbParameters `type:"structure"`

	// MySQL parameters.
	MySqlParameters *MySqlParameters `type:"structure"`

	// PostgreSQL parameters.
	PostgreSqlParameters *PostgreSqlParameters `type:"structure"`

	// Presto parameters.
	PrestoParameters *PrestoParameters `type:"structure"`

	// Amazon RDS parameters.
	RdsParameters *RdsParameters `type:"structure"`

	// Amazon Redshift parameters.
	RedshiftParameters *RedshiftParameters `type:"structure"`

	// S3 parameters.
	S3Parameters *S3Parameters `type:"structure"`

	// ServiceNow parameters.
	ServiceNowParameters *ServiceNowParameters `type:"structure"`

	// Snowflake parameters.
	SnowflakeParameters *SnowflakeParameters `type:"structure"`

	// Spark parameters.
	SparkParameters *SparkParameters `type:"structure"`

	// SQL Server parameters.
	SqlServerParameters *SqlServerParameters `type:"structure"`

	// Teradata parameters.
	TeradataParameters *TeradataParameters `type:"structure"`

	// Twitter parameters.
	TwitterParameters *TwitterParameters `type:"structure"`
}

// String returns the string representation
func (s DataSourceParameters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataSourceParameters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DataSourceParameters"}
	if s.AmazonElasticsearchParameters != nil {
		if err := s.AmazonElasticsearchParameters.Validate(); err != nil {
			invalidParams.AddNested("AmazonElasticsearchParameters", err.(aws.ErrInvalidParams))
		}
	}
	if s.AthenaParameters != nil {
		if err := s.AthenaParameters.Validate(); err != nil {
			invalidParams.AddNested("AthenaParameters", err.(aws.ErrInvalidParams))
		}
	}
	if s.AuroraParameters != nil {
		if err := s.AuroraParameters.Validate(); err != nil {
			invalidParams.AddNested("AuroraParameters", err.(aws.ErrInvalidParams))
		}
	}
	if s.AuroraPostgreSqlParameters != nil {
		if err := s.AuroraPostgreSqlParameters.Validate(); err != nil {
			invalidParams.AddNested("AuroraPostgreSqlParameters", err.(aws.ErrInvalidParams))
		}
	}
	if s.AwsIotAnalyticsParameters != nil {
		if err := s.AwsIotAnalyticsParameters.Validate(); err != nil {
			invalidParams.AddNested("AwsIotAnalyticsParameters", err.(aws.ErrInvalidParams))
		}
	}
	if s.JiraParameters != nil {
		if err := s.JiraParameters.Validate(); err != nil {
			invalidParams.AddNested("JiraParameters", err.(aws.ErrInvalidParams))
		}
	}
	if s.MariaDbParameters != nil {
		if err := s.MariaDbParameters.Validate(); err != nil {
			invalidParams.AddNested("MariaDbParameters", err.(aws.ErrInvalidParams))
		}
	}
	if s.MySqlParameters != nil {
		if err := s.MySqlParameters.Validate(); err != nil {
			invalidParams.AddNested("MySqlParameters", err.(aws.ErrInvalidParams))
		}
	}
	if s.PostgreSqlParameters != nil {
		if err := s.PostgreSqlParameters.Validate(); err != nil {
			invalidParams.AddNested("PostgreSqlParameters", err.(aws.ErrInvalidParams))
		}
	}
	if s.PrestoParameters != nil {
		if err := s.PrestoParameters.Validate(); err != nil {
			invalidParams.AddNested("PrestoParameters", err.(aws.ErrInvalidParams))
		}
	}
	if s.RdsParameters != nil {
		if err := s.RdsParameters.Validate(); err != nil {
			invalidParams.AddNested("RdsParameters", err.(aws.ErrInvalidParams))
		}
	}
	if s.RedshiftParameters != nil {
		if err := s.RedshiftParameters.Validate(); err != nil {
			invalidParams.AddNested("RedshiftParameters", err.(aws.ErrInvalidParams))
		}
	}
	if s.S3Parameters != nil {
		if err := s.S3Parameters.Validate(); err != nil {
			invalidParams.AddNested("S3Parameters", err.(aws.ErrInvalidParams))
		}
	}
	if s.ServiceNowParameters != nil {
		if err := s.ServiceNowParameters.Validate(); err != nil {
			invalidParams.AddNested("ServiceNowParameters", err.(aws.ErrInvalidParams))
		}
	}
	if s.SnowflakeParameters != nil {
		if err := s.SnowflakeParameters.Validate(); err != nil {
			invalidParams.AddNested("SnowflakeParameters", err.(aws.ErrInvalidParams))
		}
	}
	if s.SparkParameters != nil {
		if err := s.SparkParameters.Validate(); err != nil {
			invalidParams.AddNested("SparkParameters", err.(aws.ErrInvalidParams))
		}
	}
	if s.SqlServerParameters != nil {
		if err := s.SqlServerParameters.Validate(); err != nil {
			invalidParams.AddNested("SqlServerParameters", err.(aws.ErrInvalidParams))
		}
	}
	if s.TeradataParameters != nil {
		if err := s.TeradataParameters.Validate(); err != nil {
			invalidParams.AddNested("TeradataParameters", err.(aws.ErrInvalidParams))
		}
	}
	if s.TwitterParameters != nil {
		if err := s.TwitterParameters.Validate(); err != nil {
			invalidParams.AddNested("TwitterParameters", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DataSourceParameters) MarshalFields(e protocol.FieldEncoder) error {
	if s.AmazonElasticsearchParameters != nil {
		v := s.AmazonElasticsearchParameters

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AmazonElasticsearchParameters", v, metadata)
	}
	if s.AthenaParameters != nil {
		v := s.AthenaParameters

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AthenaParameters", v, metadata)
	}
	if s.AuroraParameters != nil {
		v := s.AuroraParameters

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AuroraParameters", v, metadata)
	}
	if s.AuroraPostgreSqlParameters != nil {
		v := s.AuroraPostgreSqlParameters

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AuroraPostgreSqlParameters", v, metadata)
	}
	if s.AwsIotAnalyticsParameters != nil {
		v := s.AwsIotAnalyticsParameters

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AwsIotAnalyticsParameters", v, metadata)
	}
	if s.JiraParameters != nil {
		v := s.JiraParameters

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "JiraParameters", v, metadata)
	}
	if s.MariaDbParameters != nil {
		v := s.MariaDbParameters

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "MariaDbParameters", v, metadata)
	}
	if s.MySqlParameters != nil {
		v := s.MySqlParameters

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "MySqlParameters", v, metadata)
	}
	if s.PostgreSqlParameters != nil {
		v := s.PostgreSqlParameters

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "PostgreSqlParameters", v, metadata)
	}
	if s.PrestoParameters != nil {
		v := s.PrestoParameters

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "PrestoParameters", v, metadata)
	}
	if s.RdsParameters != nil {
		v := s.RdsParameters

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "RdsParameters", v, metadata)
	}
	if s.RedshiftParameters != nil {
		v := s.RedshiftParameters

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "RedshiftParameters", v, metadata)
	}
	if s.S3Parameters != nil {
		v := s.S3Parameters

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "S3Parameters", v, metadata)
	}
	if s.ServiceNowParameters != nil {
		v := s.ServiceNowParameters

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ServiceNowParameters", v, metadata)
	}
	if s.SnowflakeParameters != nil {
		v := s.SnowflakeParameters

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SnowflakeParameters", v, metadata)
	}
	if s.SparkParameters != nil {
		v := s.SparkParameters

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SparkParameters", v, metadata)
	}
	if s.SqlServerParameters != nil {
		v := s.SqlServerParameters

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SqlServerParameters", v, metadata)
	}
	if s.TeradataParameters != nil {
		v := s.TeradataParameters

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "TeradataParameters", v, metadata)
	}
	if s.TwitterParameters != nil {
		v := s.TwitterParameters

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "TwitterParameters", v, metadata)
	}
	return nil
}

// Date time parameter.
type DateTimeParameter struct {
	_ struct{} `type:"structure"`

	// A display name for the dataset.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// Values.
	//
	// Values is a required field
	Values []time.Time `type:"list" required:"true"`
}

// String returns the string representation
func (s DateTimeParameter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DateTimeParameter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DateTimeParameter"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.Values == nil {
		invalidParams.Add(aws.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DateTimeParameter) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Values != nil {
		v := s.Values

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Values", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.TimeValue{V: v1})
		}
		ls0.End()

	}
	return nil
}

// Decimal parameter.
type DecimalParameter struct {
	_ struct{} `type:"structure"`

	// A display name for the dataset.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// Values.
	//
	// Values is a required field
	Values []float64 `type:"list" required:"true"`
}

// String returns the string representation
func (s DecimalParameter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DecimalParameter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DecimalParameter"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.Values == nil {
		invalidParams.Add(aws.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DecimalParameter) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Values != nil {
		v := s.Values

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Values", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.Float64Value(v1))
		}
		ls0.End()

	}
	return nil
}

// Error information for the SPICE ingestion of a dataset.
type ErrorInfo struct {
	_ struct{} `type:"structure"`

	// Error message.
	Message *string `type:"string"`

	// Error type.
	Type IngestionErrorType `type:"string" enum:"true"`
}

// String returns the string representation
func (s ErrorInfo) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ErrorInfo) MarshalFields(e protocol.FieldEncoder) error {
	if s.Message != nil {
		v := *s.Message

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Message", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Export to .csv option.
type ExportToCSVOption struct {
	_ struct{} `type:"structure"`

	// Availability status.
	AvailabilityStatus DashboardBehavior `type:"string" enum:"true"`
}

// String returns the string representation
func (s ExportToCSVOption) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ExportToCSVOption) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.AvailabilityStatus) > 0 {
		v := s.AvailabilityStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AvailabilityStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// A transform operation that filters rows based on a condition.
type FilterOperation struct {
	_ struct{} `type:"structure"`

	// An expression that must evaluate to a Boolean value. Rows for which the expression
	// evaluates to true are kept in the dataset.
	//
	// ConditionExpression is a required field
	ConditionExpression *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s FilterOperation) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FilterOperation) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "FilterOperation"}

	if s.ConditionExpression == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConditionExpression"))
	}
	if s.ConditionExpression != nil && len(*s.ConditionExpression) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ConditionExpression", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FilterOperation) MarshalFields(e protocol.FieldEncoder) error {
	if s.ConditionExpression != nil {
		v := *s.ConditionExpression

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ConditionExpression", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Geospatial column group that denotes a hierarchy.
type GeoSpatialColumnGroup struct {
	_ struct{} `type:"structure"`

	// Columns in this hierarchy.
	//
	// Columns is a required field
	Columns []string `min:"1" type:"list" required:"true"`

	// Country code.
	//
	// CountryCode is a required field
	CountryCode GeoSpatialCountryCode `type:"string" required:"true" enum:"true"`

	// A display name for the hierarchy.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GeoSpatialColumnGroup) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GeoSpatialColumnGroup) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GeoSpatialColumnGroup"}

	if s.Columns == nil {
		invalidParams.Add(aws.NewErrParamRequired("Columns"))
	}
	if s.Columns != nil && len(s.Columns) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Columns", 1))
	}
	if len(s.CountryCode) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("CountryCode"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GeoSpatialColumnGroup) MarshalFields(e protocol.FieldEncoder) error {
	if s.Columns != nil {
		v := s.Columns

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Columns", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if len(s.CountryCode) > 0 {
		v := s.CountryCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CountryCode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A group in Amazon QuickSight consists of a set of users. You can use groups
// to make it easier to manage access and security. Currently, an Amazon QuickSight
// subscription can't contain more than 500 Amazon QuickSight groups.
type Group struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the group.
	Arn *string `type:"string"`

	// The group description.
	Description *string `min:"1" type:"string"`

	// The name of the group.
	GroupName *string `min:"1" type:"string"`

	// The principal ID of the group.
	PrincipalId *string `type:"string"`
}

// String returns the string representation
func (s Group) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Group) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GroupName != nil {
		v := *s.GroupName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GroupName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PrincipalId != nil {
		v := *s.PrincipalId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PrincipalId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A member of an Amazon QuickSight group. Currently, group members must be
// users. Groups can't be members of another group. .
type GroupMember struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the group member (user).
	Arn *string `type:"string"`

	// The name of the group member (user).
	MemberName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GroupMember) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GroupMember) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MemberName != nil {
		v := *s.MemberName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MemberName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The display options for gutter spacing between tiles on a sheet.
type GutterStyle struct {
	_ struct{} `type:"structure"`

	// This Boolean value controls whether to display a gutter space between sheet
	// tiles.
	Show *bool `type:"boolean"`
}

// String returns the string representation
func (s GutterStyle) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GutterStyle) MarshalFields(e protocol.FieldEncoder) error {
	if s.Show != nil {
		v := *s.Show

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Show", protocol.BoolValue(v), metadata)
	}
	return nil
}

// An AWS Identity and Access Management (IAM) policy assignment.
type IAMPolicyAssignment struct {
	_ struct{} `type:"structure"`

	// Assignment ID.
	AssignmentId *string `type:"string"`

	// Assignment name.
	AssignmentName *string `min:"1" type:"string"`

	// Assignment status.
	AssignmentStatus AssignmentStatus `type:"string" enum:"true"`

	// The AWS account ID.
	AwsAccountId *string `min:"12" type:"string"`

	// Identities.
	Identities map[string][]string `type:"map"`

	// The Amazon Resource Name (ARN) for the IAM policy.
	PolicyArn *string `type:"string"`
}

// String returns the string representation
func (s IAMPolicyAssignment) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s IAMPolicyAssignment) MarshalFields(e protocol.FieldEncoder) error {
	if s.AssignmentId != nil {
		v := *s.AssignmentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AssignmentId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AssignmentName != nil {
		v := *s.AssignmentName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AssignmentName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.AssignmentStatus) > 0 {
		v := s.AssignmentStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AssignmentStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.AwsAccountId != nil {
		v := *s.AwsAccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AwsAccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Identities != nil {
		v := s.Identities

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Identities", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ls1 := ms0.List(k1)
			ls1.Start()
			for _, v2 := range v1 {
				ls1.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v2)})
			}
			ls1.End()
		}
		ms0.End()

	}
	if s.PolicyArn != nil {
		v := *s.PolicyArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PolicyArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// IAM policy assignment summary.
type IAMPolicyAssignmentSummary struct {
	_ struct{} `type:"structure"`

	// Assignment name.
	AssignmentName *string `min:"1" type:"string"`

	// Assignment status.
	AssignmentStatus AssignmentStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s IAMPolicyAssignmentSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s IAMPolicyAssignmentSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.AssignmentName != nil {
		v := *s.AssignmentName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AssignmentName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.AssignmentStatus) > 0 {
		v := s.AssignmentStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AssignmentStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Information about the SPICE ingestion for a dataset.
type Ingestion struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The time that this ingestion started.
	//
	// CreatedTime is a required field
	CreatedTime *time.Time `type:"timestamp" required:"true"`

	// Error information for this ingestion.
	ErrorInfo *ErrorInfo `type:"structure"`

	// Ingestion ID.
	IngestionId *string `min:"1" type:"string"`

	// The size of the data ingested, in bytes.
	IngestionSizeInBytes *int64 `type:"long"`

	// Ingestion status.
	//
	// IngestionStatus is a required field
	IngestionStatus IngestionStatus `type:"string" required:"true" enum:"true"`

	// The time that this ingestion took, measured in seconds.
	IngestionTimeInSeconds *int64 `type:"long"`

	// Information about a queued dataset SPICE ingestion.
	QueueInfo *QueueInfo `type:"structure"`

	// Event source for this ingestion.
	RequestSource IngestionRequestSource `type:"string" enum:"true"`

	// Type of this ingestion.
	RequestType IngestionRequestType `type:"string" enum:"true"`

	// Information about rows for a data set SPICE ingestion.
	RowInfo *RowInfo `type:"structure"`
}

// String returns the string representation
func (s Ingestion) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Ingestion) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedTime != nil {
		v := *s.CreatedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.ErrorInfo != nil {
		v := s.ErrorInfo

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ErrorInfo", v, metadata)
	}
	if s.IngestionId != nil {
		v := *s.IngestionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IngestionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IngestionSizeInBytes != nil {
		v := *s.IngestionSizeInBytes

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IngestionSizeInBytes", protocol.Int64Value(v), metadata)
	}
	if len(s.IngestionStatus) > 0 {
		v := s.IngestionStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IngestionStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.IngestionTimeInSeconds != nil {
		v := *s.IngestionTimeInSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IngestionTimeInSeconds", protocol.Int64Value(v), metadata)
	}
	if s.QueueInfo != nil {
		v := s.QueueInfo

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "QueueInfo", v, metadata)
	}
	if len(s.RequestSource) > 0 {
		v := s.RequestSource

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequestSource", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.RequestType) > 0 {
		v := s.RequestType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequestType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.RowInfo != nil {
		v := s.RowInfo

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "RowInfo", v, metadata)
	}
	return nil
}

// Metadata for a column that is used as the input of a transform operation.
type InputColumn struct {
	_ struct{} `type:"structure"`

	// The name of this column in the underlying data source.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The data type of the column.
	//
	// Type is a required field
	Type InputColumnDataType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s InputColumn) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputColumn) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InputColumn"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InputColumn) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Integer parameter.
type IntegerParameter struct {
	_ struct{} `type:"structure"`

	// A display name for the dataset.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// Values.
	//
	// Values is a required field
	Values []int64 `type:"list" required:"true"`
}

// String returns the string representation
func (s IntegerParameter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IntegerParameter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "IntegerParameter"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.Values == nil {
		invalidParams.Add(aws.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s IntegerParameter) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Values != nil {
		v := s.Values

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Values", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.Int64Value(v1))
		}
		ls0.End()

	}
	return nil
}

// Jira parameters.
type JiraParameters struct {
	_ struct{} `type:"structure"`

	// The base URL of the Jira site.
	//
	// SiteBaseUrl is a required field
	SiteBaseUrl *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s JiraParameters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JiraParameters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "JiraParameters"}

	if s.SiteBaseUrl == nil {
		invalidParams.Add(aws.NewErrParamRequired("SiteBaseUrl"))
	}
	if s.SiteBaseUrl != nil && len(*s.SiteBaseUrl) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SiteBaseUrl", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JiraParameters) MarshalFields(e protocol.FieldEncoder) error {
	if s.SiteBaseUrl != nil {
		v := *s.SiteBaseUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SiteBaseUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Join instruction.
type JoinInstruction struct {
	_ struct{} `type:"structure"`

	// Left operand.
	//
	// LeftOperand is a required field
	LeftOperand *string `min:"1" type:"string" required:"true"`

	// On Clause.
	//
	// OnClause is a required field
	OnClause *string `min:"1" type:"string" required:"true"`

	// Right operand.
	//
	// RightOperand is a required field
	RightOperand *string `min:"1" type:"string" required:"true"`

	// Type.
	//
	// Type is a required field
	Type JoinType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s JoinInstruction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JoinInstruction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "JoinInstruction"}

	if s.LeftOperand == nil {
		invalidParams.Add(aws.NewErrParamRequired("LeftOperand"))
	}
	if s.LeftOperand != nil && len(*s.LeftOperand) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LeftOperand", 1))
	}

	if s.OnClause == nil {
		invalidParams.Add(aws.NewErrParamRequired("OnClause"))
	}
	if s.OnClause != nil && len(*s.OnClause) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("OnClause", 1))
	}

	if s.RightOperand == nil {
		invalidParams.Add(aws.NewErrParamRequired("RightOperand"))
	}
	if s.RightOperand != nil && len(*s.RightOperand) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RightOperand", 1))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JoinInstruction) MarshalFields(e protocol.FieldEncoder) error {
	if s.LeftOperand != nil {
		v := *s.LeftOperand

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LeftOperand", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OnClause != nil {
		v := *s.OnClause

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OnClause", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RightOperand != nil {
		v := *s.RightOperand

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RightOperand", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// A logical table is a unit that joins and that data transformations operate
// on. A logical table has a source, which can be either a physical table or
// result of a join. When a logical table points to a physical table, the logical
// table acts as a mutable copy of that physical table through transform operations.
type LogicalTable struct {
	_ struct{} `type:"structure"`

	// A display name for the logical table.
	//
	// Alias is a required field
	Alias *string `min:"1" type:"string" required:"true"`

	// Transform operations that act on this logical table.
	DataTransforms []TransformOperation `min:"1" type:"list"`

	// Source of this logical table.
	//
	// Source is a required field
	Source *LogicalTableSource `type:"structure" required:"true"`
}

// String returns the string representation
func (s LogicalTable) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LogicalTable) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LogicalTable"}

	if s.Alias == nil {
		invalidParams.Add(aws.NewErrParamRequired("Alias"))
	}
	if s.Alias != nil && len(*s.Alias) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Alias", 1))
	}
	if s.DataTransforms != nil && len(s.DataTransforms) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DataTransforms", 1))
	}

	if s.Source == nil {
		invalidParams.Add(aws.NewErrParamRequired("Source"))
	}
	if s.DataTransforms != nil {
		for i, v := range s.DataTransforms {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DataTransforms", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Source != nil {
		if err := s.Source.Validate(); err != nil {
			invalidParams.AddNested("Source", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LogicalTable) MarshalFields(e protocol.FieldEncoder) error {
	if s.Alias != nil {
		v := *s.Alias

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Alias", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DataTransforms != nil {
		v := s.DataTransforms

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "DataTransforms", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Source != nil {
		v := s.Source

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Source", v, metadata)
	}
	return nil
}

// Information about the source of a logical table. This is a variant type structure.
// For this structure to be valid, only one of the attributes can be non-null.
type LogicalTableSource struct {
	_ struct{} `type:"structure"`

	// Specifies the result of a join of two logical tables.
	JoinInstruction *JoinInstruction `type:"structure"`

	// Physical table ID.
	PhysicalTableId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s LogicalTableSource) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LogicalTableSource) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LogicalTableSource"}
	if s.PhysicalTableId != nil && len(*s.PhysicalTableId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PhysicalTableId", 1))
	}
	if s.JoinInstruction != nil {
		if err := s.JoinInstruction.Validate(); err != nil {
			invalidParams.AddNested("JoinInstruction", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LogicalTableSource) MarshalFields(e protocol.FieldEncoder) error {
	if s.JoinInstruction != nil {
		v := s.JoinInstruction

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "JoinInstruction", v, metadata)
	}
	if s.PhysicalTableId != nil {
		v := *s.PhysicalTableId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PhysicalTableId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Amazon S3 manifest file location.
type ManifestFileLocation struct {
	_ struct{} `type:"structure"`

	// Amazon S3 bucket.
	//
	// Bucket is a required field
	Bucket *string `min:"1" type:"string" required:"true"`

	// Amazon S3 key that identifies an object.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ManifestFileLocation) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ManifestFileLocation) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ManifestFileLocation"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Bucket", 1))
	}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ManifestFileLocation) MarshalFields(e protocol.FieldEncoder) error {
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Bucket", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The display options for margins around the outside edge of sheets.
type MarginStyle struct {
	_ struct{} `type:"structure"`

	// This Boolean value controls whether to display sheet margins.
	Show *bool `type:"boolean"`
}

// String returns the string representation
func (s MarginStyle) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MarginStyle) MarshalFields(e protocol.FieldEncoder) error {
	if s.Show != nil {
		v := *s.Show

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Show", protocol.BoolValue(v), metadata)
	}
	return nil
}

// MariaDB parameters.
type MariaDbParameters struct {
	_ struct{} `type:"structure"`

	// Database.
	//
	// Database is a required field
	Database *string `min:"1" type:"string" required:"true"`

	// Host.
	//
	// Host is a required field
	Host *string `min:"1" type:"string" required:"true"`

	// Port.
	//
	// Port is a required field
	Port *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s MariaDbParameters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MariaDbParameters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MariaDbParameters"}

	if s.Database == nil {
		invalidParams.Add(aws.NewErrParamRequired("Database"))
	}
	if s.Database != nil && len(*s.Database) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Database", 1))
	}

	if s.Host == nil {
		invalidParams.Add(aws.NewErrParamRequired("Host"))
	}
	if s.Host != nil && len(*s.Host) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Host", 1))
	}

	if s.Port == nil {
		invalidParams.Add(aws.NewErrParamRequired("Port"))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Port", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MariaDbParameters) MarshalFields(e protocol.FieldEncoder) error {
	if s.Database != nil {
		v := *s.Database

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Database", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Host != nil {
		v := *s.Host

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Host", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Port != nil {
		v := *s.Port

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Port", protocol.Int64Value(v), metadata)
	}
	return nil
}

// MySQL parameters.
type MySqlParameters struct {
	_ struct{} `type:"structure"`

	// Database.
	//
	// Database is a required field
	Database *string `min:"1" type:"string" required:"true"`

	// Host.
	//
	// Host is a required field
	Host *string `min:"1" type:"string" required:"true"`

	// Port.
	//
	// Port is a required field
	Port *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s MySqlParameters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MySqlParameters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MySqlParameters"}

	if s.Database == nil {
		invalidParams.Add(aws.NewErrParamRequired("Database"))
	}
	if s.Database != nil && len(*s.Database) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Database", 1))
	}

	if s.Host == nil {
		invalidParams.Add(aws.NewErrParamRequired("Host"))
	}
	if s.Host != nil && len(*s.Host) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Host", 1))
	}

	if s.Port == nil {
		invalidParams.Add(aws.NewErrParamRequired("Port"))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Port", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MySqlParameters) MarshalFields(e protocol.FieldEncoder) error {
	if s.Database != nil {
		v := *s.Database

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Database", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Host != nil {
		v := *s.Host

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Host", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Port != nil {
		v := *s.Port

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Port", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Output column.
type OutputColumn struct {
	_ struct{} `type:"structure"`

	// A display name for the dataset.
	Name *string `min:"1" type:"string"`

	// Type.
	Type ColumnDataType `type:"string" enum:"true"`
}

// String returns the string representation
func (s OutputColumn) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s OutputColumn) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Parameters.
type Parameters struct {
	_ struct{} `type:"structure"`

	// DateTime parameters.
	DateTimeParameters []DateTimeParameter `type:"list"`

	// Decimal parameters.
	DecimalParameters []DecimalParameter `type:"list"`

	// Integer parameters.
	IntegerParameters []IntegerParameter `type:"list"`

	// String parameters.
	StringParameters []StringParameter `type:"list"`
}

// String returns the string representation
func (s Parameters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Parameters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Parameters"}
	if s.DateTimeParameters != nil {
		for i, v := range s.DateTimeParameters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DateTimeParameters", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.DecimalParameters != nil {
		for i, v := range s.DecimalParameters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DecimalParameters", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.IntegerParameters != nil {
		for i, v := range s.IntegerParameters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "IntegerParameters", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.StringParameters != nil {
		for i, v := range s.StringParameters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "StringParameters", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Parameters) MarshalFields(e protocol.FieldEncoder) error {
	if s.DateTimeParameters != nil {
		v := s.DateTimeParameters

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "DateTimeParameters", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.DecimalParameters != nil {
		v := s.DecimalParameters

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "DecimalParameters", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.IntegerParameters != nil {
		v := s.IntegerParameters

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "IntegerParameters", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.StringParameters != nil {
		v := s.StringParameters

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "StringParameters", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// A view of a data source that contains information about the shape of the
// data in the underlying source. This is a variant type structure. For this
// structure to be valid, only one of the attributes can be non-null.
type PhysicalTable struct {
	_ struct{} `type:"structure"`

	// A physical table type built from the results of the custom SQL query.
	CustomSql *CustomSql `type:"structure"`

	// A physical table type for relational data sources.
	RelationalTable *RelationalTable `type:"structure"`

	// A physical table type for as S3 data source.
	S3Source *S3Source `type:"structure"`
}

// String returns the string representation
func (s PhysicalTable) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PhysicalTable) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PhysicalTable"}
	if s.CustomSql != nil {
		if err := s.CustomSql.Validate(); err != nil {
			invalidParams.AddNested("CustomSql", err.(aws.ErrInvalidParams))
		}
	}
	if s.RelationalTable != nil {
		if err := s.RelationalTable.Validate(); err != nil {
			invalidParams.AddNested("RelationalTable", err.(aws.ErrInvalidParams))
		}
	}
	if s.S3Source != nil {
		if err := s.S3Source.Validate(); err != nil {
			invalidParams.AddNested("S3Source", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PhysicalTable) MarshalFields(e protocol.FieldEncoder) error {
	if s.CustomSql != nil {
		v := s.CustomSql

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CustomSql", v, metadata)
	}
	if s.RelationalTable != nil {
		v := s.RelationalTable

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "RelationalTable", v, metadata)
	}
	if s.S3Source != nil {
		v := s.S3Source

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "S3Source", v, metadata)
	}
	return nil
}

// PostgreSQL parameters.
type PostgreSqlParameters struct {
	_ struct{} `type:"structure"`

	// Database.
	//
	// Database is a required field
	Database *string `min:"1" type:"string" required:"true"`

	// Host.
	//
	// Host is a required field
	Host *string `min:"1" type:"string" required:"true"`

	// Port.
	//
	// Port is a required field
	Port *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s PostgreSqlParameters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PostgreSqlParameters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PostgreSqlParameters"}

	if s.Database == nil {
		invalidParams.Add(aws.NewErrParamRequired("Database"))
	}
	if s.Database != nil && len(*s.Database) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Database", 1))
	}

	if s.Host == nil {
		invalidParams.Add(aws.NewErrParamRequired("Host"))
	}
	if s.Host != nil && len(*s.Host) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Host", 1))
	}

	if s.Port == nil {
		invalidParams.Add(aws.NewErrParamRequired("Port"))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Port", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PostgreSqlParameters) MarshalFields(e protocol.FieldEncoder) error {
	if s.Database != nil {
		v := *s.Database

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Database", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Host != nil {
		v := *s.Host

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Host", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Port != nil {
		v := *s.Port

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Port", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Presto parameters.
type PrestoParameters struct {
	_ struct{} `type:"structure"`

	// Catalog.
	//
	// Catalog is a required field
	Catalog *string `type:"string" required:"true"`

	// Host.
	//
	// Host is a required field
	Host *string `min:"1" type:"string" required:"true"`

	// Port.
	//
	// Port is a required field
	Port *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s PrestoParameters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PrestoParameters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PrestoParameters"}

	if s.Catalog == nil {
		invalidParams.Add(aws.NewErrParamRequired("Catalog"))
	}

	if s.Host == nil {
		invalidParams.Add(aws.NewErrParamRequired("Host"))
	}
	if s.Host != nil && len(*s.Host) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Host", 1))
	}

	if s.Port == nil {
		invalidParams.Add(aws.NewErrParamRequired("Port"))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Port", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PrestoParameters) MarshalFields(e protocol.FieldEncoder) error {
	if s.Catalog != nil {
		v := *s.Catalog

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Catalog", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Host != nil {
		v := *s.Host

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Host", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Port != nil {
		v := *s.Port

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Port", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A transform operation that projects columns. Operations that come after a
// projection can only refer to projected columns.
type ProjectOperation struct {
	_ struct{} `type:"structure"`

	// Projected columns.
	//
	// ProjectedColumns is a required field
	ProjectedColumns []string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s ProjectOperation) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProjectOperation) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ProjectOperation"}

	if s.ProjectedColumns == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProjectedColumns"))
	}
	if s.ProjectedColumns != nil && len(s.ProjectedColumns) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProjectedColumns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ProjectOperation) MarshalFields(e protocol.FieldEncoder) error {
	if s.ProjectedColumns != nil {
		v := s.ProjectedColumns

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ProjectedColumns", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// Information about a queued dataset SPICE ingestion.
type QueueInfo struct {
	_ struct{} `type:"structure"`

	// The ID of the ongoing ingestion. The queued ingestion is waiting for the
	// ongoing ingestion to complete.
	//
	// QueuedIngestion is a required field
	QueuedIngestion *string `type:"string" required:"true"`

	// The ID of the queued ingestion.
	//
	// WaitingOnIngestion is a required field
	WaitingOnIngestion *string `type:"string" required:"true"`
}

// String returns the string representation
func (s QueueInfo) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s QueueInfo) MarshalFields(e protocol.FieldEncoder) error {
	if s.QueuedIngestion != nil {
		v := *s.QueuedIngestion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "QueuedIngestion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.WaitingOnIngestion != nil {
		v := *s.WaitingOnIngestion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "WaitingOnIngestion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Amazon RDS parameters.
type RdsParameters struct {
	_ struct{} `type:"structure"`

	// Database.
	//
	// Database is a required field
	Database *string `min:"1" type:"string" required:"true"`

	// Instance ID.
	//
	// InstanceId is a required field
	InstanceId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RdsParameters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RdsParameters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RdsParameters"}

	if s.Database == nil {
		invalidParams.Add(aws.NewErrParamRequired("Database"))
	}
	if s.Database != nil && len(*s.Database) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Database", 1))
	}

	if s.InstanceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InstanceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RdsParameters) MarshalFields(e protocol.FieldEncoder) error {
	if s.Database != nil {
		v := *s.Database

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Database", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InstanceId != nil {
		v := *s.InstanceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InstanceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Amazon Redshift parameters. The ClusterId field can be blank if Host and
// Port are both set. The Host and Port fields can be blank if the ClusterId
// field is set.
type RedshiftParameters struct {
	_ struct{} `type:"structure"`

	// Cluster ID. This field can be blank if the Host and Port are provided.
	ClusterId *string `min:"1" type:"string"`

	// Database.
	//
	// Database is a required field
	Database *string `min:"1" type:"string" required:"true"`

	// Host. This field can be blank if ClusterId is provided.
	Host *string `min:"1" type:"string"`

	// Port. This field can be blank if the ClusterId is provided.
	Port *int64 `type:"integer"`
}

// String returns the string representation
func (s RedshiftParameters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RedshiftParameters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RedshiftParameters"}
	if s.ClusterId != nil && len(*s.ClusterId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClusterId", 1))
	}

	if s.Database == nil {
		invalidParams.Add(aws.NewErrParamRequired("Database"))
	}
	if s.Database != nil && len(*s.Database) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Database", 1))
	}
	if s.Host != nil && len(*s.Host) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Host", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RedshiftParameters) MarshalFields(e protocol.FieldEncoder) error {
	if s.ClusterId != nil {
		v := *s.ClusterId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ClusterId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Database != nil {
		v := *s.Database

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Database", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Host != nil {
		v := *s.Host

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Host", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Port != nil {
		v := *s.Port

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Port", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A physical table type for relational data sources.
type RelationalTable struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the data source.
	//
	// DataSourceArn is a required field
	DataSourceArn *string `type:"string" required:"true"`

	// The column schema of the table.
	//
	// InputColumns is a required field
	InputColumns []InputColumn `min:"1" type:"list" required:"true"`

	// The name of the relational table.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The schema name. This name applies to certain relational database engines.
	Schema *string `type:"string"`
}

// String returns the string representation
func (s RelationalTable) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RelationalTable) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RelationalTable"}

	if s.DataSourceArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("DataSourceArn"))
	}

	if s.InputColumns == nil {
		invalidParams.Add(aws.NewErrParamRequired("InputColumns"))
	}
	if s.InputColumns != nil && len(s.InputColumns) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InputColumns", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.InputColumns != nil {
		for i, v := range s.InputColumns {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InputColumns", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RelationalTable) MarshalFields(e protocol.FieldEncoder) error {
	if s.DataSourceArn != nil {
		v := *s.DataSourceArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DataSourceArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InputColumns != nil {
		v := s.InputColumns

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "InputColumns", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Schema != nil {
		v := *s.Schema

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Schema", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A transform operation that renames a column.
type RenameColumnOperation struct {
	_ struct{} `type:"structure"`

	// The name of the column to be renamed.
	//
	// ColumnName is a required field
	ColumnName *string `min:"1" type:"string" required:"true"`

	// The new name for the column.
	//
	// NewColumnName is a required field
	NewColumnName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RenameColumnOperation) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RenameColumnOperation) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RenameColumnOperation"}

	if s.ColumnName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ColumnName"))
	}
	if s.ColumnName != nil && len(*s.ColumnName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ColumnName", 1))
	}

	if s.NewColumnName == nil {
		invalidParams.Add(aws.NewErrParamRequired("NewColumnName"))
	}
	if s.NewColumnName != nil && len(*s.NewColumnName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NewColumnName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RenameColumnOperation) MarshalFields(e protocol.FieldEncoder) error {
	if s.ColumnName != nil {
		v := *s.ColumnName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ColumnName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NewColumnName != nil {
		v := *s.NewColumnName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NewColumnName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Permission for the resource.
type ResourcePermission struct {
	_ struct{} `type:"structure"`

	// The action to grant or revoke permissions on, for example "quicksight:DescribeDashboard".
	//
	// Actions is a required field
	Actions []string `min:"1" type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the principal. This can be one of the following:
	//
	//    * The ARN of an Amazon QuickSight user, group, or namespace. (This is
	//    most common.)
	//
	//    * The ARN of an AWS account root: This is an IAM ARN rather than a QuickSight
	//    ARN. Use this option only to share resources (templates) across AWS accounts.
	//    (This is less common.)
	//
	// Principal is a required field
	Principal *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ResourcePermission) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourcePermission) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ResourcePermission"}

	if s.Actions == nil {
		invalidParams.Add(aws.NewErrParamRequired("Actions"))
	}
	if s.Actions != nil && len(s.Actions) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Actions", 1))
	}

	if s.Principal == nil {
		invalidParams.Add(aws.NewErrParamRequired("Principal"))
	}
	if s.Principal != nil && len(*s.Principal) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Principal", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ResourcePermission) MarshalFields(e protocol.FieldEncoder) error {
	if s.Actions != nil {
		v := s.Actions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Actions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Principal != nil {
		v := *s.Principal

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Principal", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about rows for a data set SPICE ingestion.
type RowInfo struct {
	_ struct{} `type:"structure"`

	// The number of rows that were not ingested.
	RowsDropped *int64 `type:"long"`

	// The number of rows that were ingested.
	RowsIngested *int64 `type:"long"`
}

// String returns the string representation
func (s RowInfo) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RowInfo) MarshalFields(e protocol.FieldEncoder) error {
	if s.RowsDropped != nil {
		v := *s.RowsDropped

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RowsDropped", protocol.Int64Value(v), metadata)
	}
	if s.RowsIngested != nil {
		v := *s.RowsIngested

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RowsIngested", protocol.Int64Value(v), metadata)
	}
	return nil
}

// The row-level security configuration for the dataset.
type RowLevelPermissionDataSet struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the permission dataset.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// Permission policy.
	//
	// PermissionPolicy is a required field
	PermissionPolicy RowLevelPermissionPolicy `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s RowLevelPermissionDataSet) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RowLevelPermissionDataSet) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RowLevelPermissionDataSet"}

	if s.Arn == nil {
		invalidParams.Add(aws.NewErrParamRequired("Arn"))
	}
	if len(s.PermissionPolicy) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("PermissionPolicy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RowLevelPermissionDataSet) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.PermissionPolicy) > 0 {
		v := s.PermissionPolicy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PermissionPolicy", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// S3 parameters.
type S3Parameters struct {
	_ struct{} `type:"structure"`

	// Location of the Amazon S3 manifest file. This is NULL if the manifest file
	// was uploaded in the console.
	//
	// ManifestFileLocation is a required field
	ManifestFileLocation *ManifestFileLocation `type:"structure" required:"true"`
}

// String returns the string representation
func (s S3Parameters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Parameters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3Parameters"}

	if s.ManifestFileLocation == nil {
		invalidParams.Add(aws.NewErrParamRequired("ManifestFileLocation"))
	}
	if s.ManifestFileLocation != nil {
		if err := s.ManifestFileLocation.Validate(); err != nil {
			invalidParams.AddNested("ManifestFileLocation", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s S3Parameters) MarshalFields(e protocol.FieldEncoder) error {
	if s.ManifestFileLocation != nil {
		v := s.ManifestFileLocation

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ManifestFileLocation", v, metadata)
	}
	return nil
}

// A physical table type for as S3 data source.
type S3Source struct {
	_ struct{} `type:"structure"`

	// The amazon Resource Name (ARN) for the data source.
	//
	// DataSourceArn is a required field
	DataSourceArn *string `type:"string" required:"true"`

	// A physical table type for as S3 data source.
	//
	// InputColumns is a required field
	InputColumns []InputColumn `min:"1" type:"list" required:"true"`

	// Information about the format for the S3 source file or files.
	UploadSettings *UploadSettings `type:"structure"`
}

// String returns the string representation
func (s S3Source) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Source) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3Source"}

	if s.DataSourceArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("DataSourceArn"))
	}

	if s.InputColumns == nil {
		invalidParams.Add(aws.NewErrParamRequired("InputColumns"))
	}
	if s.InputColumns != nil && len(s.InputColumns) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InputColumns", 1))
	}
	if s.InputColumns != nil {
		for i, v := range s.InputColumns {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InputColumns", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.UploadSettings != nil {
		if err := s.UploadSettings.Validate(); err != nil {
			invalidParams.AddNested("UploadSettings", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s S3Source) MarshalFields(e protocol.FieldEncoder) error {
	if s.DataSourceArn != nil {
		v := *s.DataSourceArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DataSourceArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InputColumns != nil {
		v := s.InputColumns

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "InputColumns", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.UploadSettings != nil {
		v := s.UploadSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "UploadSettings", v, metadata)
	}
	return nil
}

// ServiceNow parameters.
type ServiceNowParameters struct {
	_ struct{} `type:"structure"`

	// URL of the base site.
	//
	// SiteBaseUrl is a required field
	SiteBaseUrl *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ServiceNowParameters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServiceNowParameters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ServiceNowParameters"}

	if s.SiteBaseUrl == nil {
		invalidParams.Add(aws.NewErrParamRequired("SiteBaseUrl"))
	}
	if s.SiteBaseUrl != nil && len(*s.SiteBaseUrl) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SiteBaseUrl", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ServiceNowParameters) MarshalFields(e protocol.FieldEncoder) error {
	if s.SiteBaseUrl != nil {
		v := *s.SiteBaseUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SiteBaseUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Sheet controls option.
type SheetControlsOption struct {
	_ struct{} `type:"structure"`

	// Visibility state.
	VisibilityState DashboardUIState `type:"string" enum:"true"`
}

// String returns the string representation
func (s SheetControlsOption) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SheetControlsOption) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.VisibilityState) > 0 {
		v := s.VisibilityState

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VisibilityState", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// The theme display options for sheets.
type SheetStyle struct {
	_ struct{} `type:"structure"`

	// The display options for tiles.
	Tile *TileStyle `type:"structure"`

	// The layout options for tiles.
	TileLayout *TileLayoutStyle `type:"structure"`
}

// String returns the string representation
func (s SheetStyle) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SheetStyle) MarshalFields(e protocol.FieldEncoder) error {
	if s.Tile != nil {
		v := s.Tile

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Tile", v, metadata)
	}
	if s.TileLayout != nil {
		v := s.TileLayout

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "TileLayout", v, metadata)
	}
	return nil
}

// Snowflake parameters.
type SnowflakeParameters struct {
	_ struct{} `type:"structure"`

	// Database.
	//
	// Database is a required field
	Database *string `min:"1" type:"string" required:"true"`

	// Host.
	//
	// Host is a required field
	Host *string `min:"1" type:"string" required:"true"`

	// Warehouse.
	//
	// Warehouse is a required field
	Warehouse *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SnowflakeParameters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SnowflakeParameters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SnowflakeParameters"}

	if s.Database == nil {
		invalidParams.Add(aws.NewErrParamRequired("Database"))
	}
	if s.Database != nil && len(*s.Database) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Database", 1))
	}

	if s.Host == nil {
		invalidParams.Add(aws.NewErrParamRequired("Host"))
	}
	if s.Host != nil && len(*s.Host) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Host", 1))
	}

	if s.Warehouse == nil {
		invalidParams.Add(aws.NewErrParamRequired("Warehouse"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SnowflakeParameters) MarshalFields(e protocol.FieldEncoder) error {
	if s.Database != nil {
		v := *s.Database

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Database", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Host != nil {
		v := *s.Host

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Host", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Warehouse != nil {
		v := *s.Warehouse

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Warehouse", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Spark parameters.
type SparkParameters struct {
	_ struct{} `type:"structure"`

	// Host.
	//
	// Host is a required field
	Host *string `min:"1" type:"string" required:"true"`

	// Port.
	//
	// Port is a required field
	Port *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s SparkParameters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SparkParameters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SparkParameters"}

	if s.Host == nil {
		invalidParams.Add(aws.NewErrParamRequired("Host"))
	}
	if s.Host != nil && len(*s.Host) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Host", 1))
	}

	if s.Port == nil {
		invalidParams.Add(aws.NewErrParamRequired("Port"))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Port", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SparkParameters) MarshalFields(e protocol.FieldEncoder) error {
	if s.Host != nil {
		v := *s.Host

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Host", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Port != nil {
		v := *s.Port

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Port", protocol.Int64Value(v), metadata)
	}
	return nil
}

// SQL Server parameters.
type SqlServerParameters struct {
	_ struct{} `type:"structure"`

	// Database.
	//
	// Database is a required field
	Database *string `min:"1" type:"string" required:"true"`

	// Host.
	//
	// Host is a required field
	Host *string `min:"1" type:"string" required:"true"`

	// Port.
	//
	// Port is a required field
	Port *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s SqlServerParameters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SqlServerParameters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SqlServerParameters"}

	if s.Database == nil {
		invalidParams.Add(aws.NewErrParamRequired("Database"))
	}
	if s.Database != nil && len(*s.Database) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Database", 1))
	}

	if s.Host == nil {
		invalidParams.Add(aws.NewErrParamRequired("Host"))
	}
	if s.Host != nil && len(*s.Host) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Host", 1))
	}

	if s.Port == nil {
		invalidParams.Add(aws.NewErrParamRequired("Port"))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Port", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SqlServerParameters) MarshalFields(e protocol.FieldEncoder) error {
	if s.Database != nil {
		v := *s.Database

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Database", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Host != nil {
		v := *s.Host

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Host", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Port != nil {
		v := *s.Port

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Port", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Secure Socket Layer (SSL) properties that apply when QuickSight connects
// to your underlying data source.
type SslProperties struct {
	_ struct{} `type:"structure"`

	// A Boolean option to control whether SSL should be disabled.
	DisableSsl *bool `type:"boolean"`
}

// String returns the string representation
func (s SslProperties) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SslProperties) MarshalFields(e protocol.FieldEncoder) error {
	if s.DisableSsl != nil {
		v := *s.DisableSsl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DisableSsl", protocol.BoolValue(v), metadata)
	}
	return nil
}

// String parameter.
type StringParameter struct {
	_ struct{} `type:"structure"`

	// A display name for the dataset.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// Values.
	//
	// Values is a required field
	Values []string `type:"list" required:"true"`
}

// String returns the string representation
func (s StringParameter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StringParameter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StringParameter"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.Values == nil {
		invalidParams.Add(aws.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StringParameter) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Values != nil {
		v := s.Values

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Values", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// The key or keys of the key-value pairs for the resource tag or tags assigned
// to the resource.
type Tag struct {
	_ struct{} `type:"structure"`

	// Tag key.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// Tag value.
	//
	// Value is a required field
	Value *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Tag) MarshalFields(e protocol.FieldEncoder) error {
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A transform operation that tags a column with additional information.
type TagColumnOperation struct {
	_ struct{} `type:"structure"`

	// The column that this operation acts on.
	//
	// ColumnName is a required field
	ColumnName *string `min:"1" type:"string" required:"true"`

	// The dataset column tag, currently only used for geospatial type tagging. .
	//
	// This is not tags for the AWS tagging feature. .
	//
	// Tags is a required field
	Tags []ColumnTag `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s TagColumnOperation) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagColumnOperation) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TagColumnOperation"}

	if s.ColumnName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ColumnName"))
	}
	if s.ColumnName != nil && len(*s.ColumnName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ColumnName", 1))
	}

	if s.Tags == nil {
		invalidParams.Add(aws.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TagColumnOperation) MarshalFields(e protocol.FieldEncoder) error {
	if s.ColumnName != nil {
		v := *s.ColumnName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ColumnName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Tags", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// A template object. A template is an entity in QuickSight that encapsulates
// the metadata required to create an analysis and that you can use to create
// a dashboard. A template adds a layer of abstraction by using placeholders
// to replace the dataset associated with the analysis. You can use templates
// to create dashboards by replacing dataset placeholders with datasets that
// follow the same schema that was used to create the source analysis and template.
//
// You can share templates across AWS accounts by allowing users in other AWS
// accounts to create a template or a dashboard from an existing template.
type Template struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the template.
	Arn *string `type:"string"`

	// Time when this was created.
	CreatedTime *time.Time `type:"timestamp"`

	// Time when this was last updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// The display name of the template.
	Name *string `min:"1" type:"string"`

	// The ID for the template. This is unique per AWS Region for each AWS account.
	TemplateId *string `min:"1" type:"string"`

	// A structure describing the versions of the template.
	Version *TemplateVersion `type:"structure"`
}

// String returns the string representation
func (s Template) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Template) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedTime != nil {
		v := *s.CreatedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.LastUpdatedTime != nil {
		v := *s.LastUpdatedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastUpdatedTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TemplateId != nil {
		v := *s.TemplateId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TemplateId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := s.Version

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Version", v, metadata)
	}
	return nil
}

// The template alias.
type TemplateAlias struct {
	_ struct{} `type:"structure"`

	// The display name of the template alias.
	AliasName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the template alias.
	Arn *string `type:"string"`

	// The version number of the template alias.
	TemplateVersionNumber *int64 `min:"1" type:"long"`
}

// String returns the string representation
func (s TemplateAlias) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TemplateAlias) MarshalFields(e protocol.FieldEncoder) error {
	if s.AliasName != nil {
		v := *s.AliasName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AliasName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TemplateVersionNumber != nil {
		v := *s.TemplateVersionNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TemplateVersionNumber", protocol.Int64Value(v), metadata)
	}
	return nil
}

// List of errors that occurred when the template version creation failed.
type TemplateError struct {
	_ struct{} `type:"structure"`

	// Description of the error type.
	Message *string `type:"string"`

	// Type of error.
	Type TemplateErrorType `type:"string" enum:"true"`
}

// String returns the string representation
func (s TemplateError) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TemplateError) MarshalFields(e protocol.FieldEncoder) error {
	if s.Message != nil {
		v := *s.Message

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Message", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// The source analysis of the template.
type TemplateSourceAnalysis struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// A structure containing information about the dataset references used as placeholders
	// in the template.
	//
	// DataSetReferences is a required field
	DataSetReferences []DataSetReference `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s TemplateSourceAnalysis) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TemplateSourceAnalysis) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TemplateSourceAnalysis"}

	if s.Arn == nil {
		invalidParams.Add(aws.NewErrParamRequired("Arn"))
	}

	if s.DataSetReferences == nil {
		invalidParams.Add(aws.NewErrParamRequired("DataSetReferences"))
	}
	if s.DataSetReferences != nil && len(s.DataSetReferences) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DataSetReferences", 1))
	}
	if s.DataSetReferences != nil {
		for i, v := range s.DataSetReferences {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DataSetReferences", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TemplateSourceAnalysis) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DataSetReferences != nil {
		v := s.DataSetReferences

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "DataSetReferences", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// The source entity of the template.
type TemplateSourceEntity struct {
	_ struct{} `type:"structure"`

	// The source analysis, if it is based on an analysis.
	SourceAnalysis *TemplateSourceAnalysis `type:"structure"`

	// The source template, if it is based on an template.
	SourceTemplate *TemplateSourceTemplate `type:"structure"`
}

// String returns the string representation
func (s TemplateSourceEntity) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TemplateSourceEntity) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TemplateSourceEntity"}
	if s.SourceAnalysis != nil {
		if err := s.SourceAnalysis.Validate(); err != nil {
			invalidParams.AddNested("SourceAnalysis", err.(aws.ErrInvalidParams))
		}
	}
	if s.SourceTemplate != nil {
		if err := s.SourceTemplate.Validate(); err != nil {
			invalidParams.AddNested("SourceTemplate", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TemplateSourceEntity) MarshalFields(e protocol.FieldEncoder) error {
	if s.SourceAnalysis != nil {
		v := s.SourceAnalysis

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SourceAnalysis", v, metadata)
	}
	if s.SourceTemplate != nil {
		v := s.SourceTemplate

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SourceTemplate", v, metadata)
	}
	return nil
}

// The source template of the template.
type TemplateSourceTemplate struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s TemplateSourceTemplate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TemplateSourceTemplate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TemplateSourceTemplate"}

	if s.Arn == nil {
		invalidParams.Add(aws.NewErrParamRequired("Arn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TemplateSourceTemplate) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The template summary.
type TemplateSummary struct {
	_ struct{} `type:"structure"`

	// A summary of a template.
	Arn *string `type:"string"`

	// The last time that this template was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The last time that this template was updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// A structure containing a list of version numbers for the template summary.
	LatestVersionNumber *int64 `min:"1" type:"long"`

	// A display name for the template.
	Name *string `min:"1" type:"string"`

	// The ID of the template. This ID is unique per AWS Region for each AWS account.
	TemplateId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s TemplateSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TemplateSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedTime != nil {
		v := *s.CreatedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.LastUpdatedTime != nil {
		v := *s.LastUpdatedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastUpdatedTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.LatestVersionNumber != nil {
		v := *s.LatestVersionNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LatestVersionNumber", protocol.Int64Value(v), metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TemplateId != nil {
		v := *s.TemplateId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TemplateId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A version of a template.
type TemplateVersion struct {
	_ struct{} `type:"structure"`

	// The time that this template version was created.
	CreatedTime *time.Time `type:"timestamp"`

	// Schema of the dataset identified by the placeholder. The idea is that any
	// dashboard created from the template should be bound to new datasets matching
	// the same schema described through this API. .
	DataSetConfigurations []DataSetConfiguration `type:"list"`

	// The description of the template.
	Description *string `min:"1" type:"string"`

	// Errors associated with the template.
	Errors []TemplateError `min:"1" type:"list"`

	// The Amazon Resource Name (ARN) of the analysis or template which was used
	// to create this template.
	SourceEntityArn *string `type:"string"`

	// The HTTP status of the request.
	Status ResourceStatus `type:"string" enum:"true"`

	// The version number of the template.
	VersionNumber *int64 `min:"1" type:"long"`
}

// String returns the string representation
func (s TemplateVersion) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TemplateVersion) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreatedTime != nil {
		v := *s.CreatedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.DataSetConfigurations != nil {
		v := s.DataSetConfigurations

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "DataSetConfigurations", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Errors != nil {
		v := s.Errors

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Errors", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.SourceEntityArn != nil {
		v := *s.SourceEntityArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SourceEntityArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.VersionNumber != nil {
		v := *s.VersionNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VersionNumber", protocol.Int64Value(v), metadata)
	}
	return nil
}

// The template version.
type TemplateVersionSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the template version.
	Arn *string `type:"string"`

	// The time that this template version was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The description of the template version.
	Description *string `min:"1" type:"string"`

	// The status of the template version.
	Status ResourceStatus `type:"string" enum:"true"`

	// The version number of the template version.
	VersionNumber *int64 `min:"1" type:"long"`
}

// String returns the string representation
func (s TemplateVersionSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TemplateVersionSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedTime != nil {
		v := *s.CreatedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.VersionNumber != nil {
		v := *s.VersionNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VersionNumber", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Teradata parameters.
type TeradataParameters struct {
	_ struct{} `type:"structure"`

	// Database.
	//
	// Database is a required field
	Database *string `min:"1" type:"string" required:"true"`

	// Host.
	//
	// Host is a required field
	Host *string `min:"1" type:"string" required:"true"`

	// Port.
	//
	// Port is a required field
	Port *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s TeradataParameters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TeradataParameters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TeradataParameters"}

	if s.Database == nil {
		invalidParams.Add(aws.NewErrParamRequired("Database"))
	}
	if s.Database != nil && len(*s.Database) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Database", 1))
	}

	if s.Host == nil {
		invalidParams.Add(aws.NewErrParamRequired("Host"))
	}
	if s.Host != nil && len(*s.Host) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Host", 1))
	}

	if s.Port == nil {
		invalidParams.Add(aws.NewErrParamRequired("Port"))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Port", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TeradataParameters) MarshalFields(e protocol.FieldEncoder) error {
	if s.Database != nil {
		v := *s.Database

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Database", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Host != nil {
		v := *s.Host

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Host", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Port != nil {
		v := *s.Port

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Port", protocol.Int64Value(v), metadata)
	}
	return nil
}

type Theme struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the theme.
	Arn *string `type:"string"`

	// The date and time that the theme was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The date and time that the theme was last updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// The name that the user gives to the theme.
	Name *string `min:"1" type:"string"`

	// The identifier that the user gives to the theme.
	ThemeId *string `min:"1" type:"string"`

	// The type of theme, based on how it was created. Valid values include: QUICKSIGHT
	// and CUSTOM.
	Type ThemeType `type:"string" enum:"true"`

	// A version of a theme.
	Version *ThemeVersion `type:"structure"`
}

// String returns the string representation
func (s Theme) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Theme) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedTime != nil {
		v := *s.CreatedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.LastUpdatedTime != nil {
		v := *s.LastUpdatedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastUpdatedTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThemeId != nil {
		v := *s.ThemeId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ThemeId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Version != nil {
		v := s.Version

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Version", v, metadata)
	}
	return nil
}

// An alias for a theme.
type ThemeAlias struct {
	_ struct{} `type:"structure"`

	// The display name of the theme alias.
	AliasName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the theme alias.
	Arn *string `type:"string"`

	// The version number of the theme alias.
	ThemeVersionNumber *int64 `min:"1" type:"long"`
}

// String returns the string representation
func (s ThemeAlias) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ThemeAlias) MarshalFields(e protocol.FieldEncoder) error {
	if s.AliasName != nil {
		v := *s.AliasName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AliasName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThemeVersionNumber != nil {
		v := *s.ThemeVersionNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ThemeVersionNumber", protocol.Int64Value(v), metadata)
	}
	return nil
}

// The theme configuration. This configuration contains all of the display properties
// for a theme.
type ThemeConfiguration struct {
	_ struct{} `type:"structure"`

	// Color properties that apply to chart data colors.
	DataColorPalette *DataColorPalette `type:"structure"`

	// Display options related to sheets.
	Sheet *SheetStyle `type:"structure"`

	// Color properties that apply to the UI and to charts, excluding the colors
	// that apply to data.
	UIColorPalette *UIColorPalette `type:"structure"`
}

// String returns the string representation
func (s ThemeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ThemeConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.DataColorPalette != nil {
		v := s.DataColorPalette

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DataColorPalette", v, metadata)
	}
	if s.Sheet != nil {
		v := s.Sheet

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Sheet", v, metadata)
	}
	if s.UIColorPalette != nil {
		v := s.UIColorPalette

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "UIColorPalette", v, metadata)
	}
	return nil
}

// Theme error.
type ThemeError struct {
	_ struct{} `type:"structure"`

	// The error message.
	Message *string `type:"string"`

	// The type of error.
	Type ThemeErrorType `type:"string" enum:"true"`
}

// String returns the string representation
func (s ThemeError) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ThemeError) MarshalFields(e protocol.FieldEncoder) error {
	if s.Message != nil {
		v := *s.Message

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Message", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// The theme summary.
type ThemeSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	Arn *string `type:"string"`

	// The date and time that this theme was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The last date and time that this theme was updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// The latest version number for the theme.
	LatestVersionNumber *int64 `min:"1" type:"long"`

	// the display name for the theme.
	Name *string `min:"1" type:"string"`

	// The ID of the theme. This ID is unique per AWS Region for each AWS account.
	ThemeId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ThemeSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ThemeSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedTime != nil {
		v := *s.CreatedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.LastUpdatedTime != nil {
		v := *s.LastUpdatedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastUpdatedTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.LatestVersionNumber != nil {
		v := *s.LatestVersionNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LatestVersionNumber", protocol.Int64Value(v), metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThemeId != nil {
		v := *s.ThemeId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ThemeId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A version of a theme.
type ThemeVersion struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	Arn *string `type:"string"`

	// The Amazon QuickSight-defined ID of the theme that a custom theme inherits
	// from. All themes initially inherit from a default QuickSight theme.
	BaseThemeId *string `min:"1" type:"string"`

	// The theme configuration, which contains all the theme display properties.
	Configuration *ThemeConfiguration `type:"structure"`

	// The date and time that this theme version was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The description of the theme.
	Description *string `min:"1" type:"string"`

	// Errors associated with the theme.
	Errors []ThemeError `min:"1" type:"list"`

	// The status of the theme version.
	Status ResourceStatus `type:"string" enum:"true"`

	// The version number of the theme.
	VersionNumber *int64 `min:"1" type:"long"`
}

// String returns the string representation
func (s ThemeVersion) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ThemeVersion) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.BaseThemeId != nil {
		v := *s.BaseThemeId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BaseThemeId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Configuration != nil {
		v := s.Configuration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Configuration", v, metadata)
	}
	if s.CreatedTime != nil {
		v := *s.CreatedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Errors != nil {
		v := s.Errors

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Errors", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.VersionNumber != nil {
		v := *s.VersionNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VersionNumber", protocol.Int64Value(v), metadata)
	}
	return nil
}

// The theme version.
type ThemeVersionSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the theme version.
	Arn *string `type:"string"`

	// The date and time that this theme version was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The description of the theme version.
	Description *string `min:"1" type:"string"`

	// The status of the theme version.
	Status ResourceStatus `type:"string" enum:"true"`

	// The version number of the theme version.
	VersionNumber *int64 `min:"1" type:"long"`
}

// String returns the string representation
func (s ThemeVersionSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ThemeVersionSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedTime != nil {
		v := *s.CreatedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.VersionNumber != nil {
		v := *s.VersionNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VersionNumber", protocol.Int64Value(v), metadata)
	}
	return nil
}

// The display options for the layout of tiles on a sheet.
type TileLayoutStyle struct {
	_ struct{} `type:"structure"`

	// The gutter settings that apply between tiles.
	Gutter *GutterStyle `type:"structure"`

	// The margin settings that apply around the outside edge of sheets.
	Margin *MarginStyle `type:"structure"`
}

// String returns the string representation
func (s TileLayoutStyle) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TileLayoutStyle) MarshalFields(e protocol.FieldEncoder) error {
	if s.Gutter != nil {
		v := s.Gutter

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Gutter", v, metadata)
	}
	if s.Margin != nil {
		v := s.Margin

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Margin", v, metadata)
	}
	return nil
}

// Display options related to tiles on a sheet.
type TileStyle struct {
	_ struct{} `type:"structure"`

	// The border around a tile.
	Border *BorderStyle `type:"structure"`
}

// String returns the string representation
func (s TileStyle) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TileStyle) MarshalFields(e protocol.FieldEncoder) error {
	if s.Border != nil {
		v := s.Border

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Border", v, metadata)
	}
	return nil
}

// A data transformation on a logical table. This is a variant type structure.
// For this structure to be valid, only one of the attributes can be non-null.
type TransformOperation struct {
	_ struct{} `type:"structure"`

	// A transform operation that casts a column to a different type.
	CastColumnTypeOperation *CastColumnTypeOperation `type:"structure"`

	// An operation that creates calculated columns. Columns created in one such
	// operation form a lexical closure.
	CreateColumnsOperation *CreateColumnsOperation `type:"structure"`

	// An operation that filters rows based on some condition.
	FilterOperation *FilterOperation `type:"structure"`

	// An operation that projects columns. Operations that come after a projection
	// can only refer to projected columns.
	ProjectOperation *ProjectOperation `type:"structure"`

	// An operation that renames a column.
	RenameColumnOperation *RenameColumnOperation `type:"structure"`

	// An operation that tags a column with additional information.
	TagColumnOperation *TagColumnOperation `type:"structure"`
}

// String returns the string representation
func (s TransformOperation) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TransformOperation) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TransformOperation"}
	if s.CastColumnTypeOperation != nil {
		if err := s.CastColumnTypeOperation.Validate(); err != nil {
			invalidParams.AddNested("CastColumnTypeOperation", err.(aws.ErrInvalidParams))
		}
	}
	if s.CreateColumnsOperation != nil {
		if err := s.CreateColumnsOperation.Validate(); err != nil {
			invalidParams.AddNested("CreateColumnsOperation", err.(aws.ErrInvalidParams))
		}
	}
	if s.FilterOperation != nil {
		if err := s.FilterOperation.Validate(); err != nil {
			invalidParams.AddNested("FilterOperation", err.(aws.ErrInvalidParams))
		}
	}
	if s.ProjectOperation != nil {
		if err := s.ProjectOperation.Validate(); err != nil {
			invalidParams.AddNested("ProjectOperation", err.(aws.ErrInvalidParams))
		}
	}
	if s.RenameColumnOperation != nil {
		if err := s.RenameColumnOperation.Validate(); err != nil {
			invalidParams.AddNested("RenameColumnOperation", err.(aws.ErrInvalidParams))
		}
	}
	if s.TagColumnOperation != nil {
		if err := s.TagColumnOperation.Validate(); err != nil {
			invalidParams.AddNested("TagColumnOperation", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TransformOperation) MarshalFields(e protocol.FieldEncoder) error {
	if s.CastColumnTypeOperation != nil {
		v := s.CastColumnTypeOperation

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CastColumnTypeOperation", v, metadata)
	}
	if s.CreateColumnsOperation != nil {
		v := s.CreateColumnsOperation

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CreateColumnsOperation", v, metadata)
	}
	if s.FilterOperation != nil {
		v := s.FilterOperation

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "FilterOperation", v, metadata)
	}
	if s.ProjectOperation != nil {
		v := s.ProjectOperation

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ProjectOperation", v, metadata)
	}
	if s.RenameColumnOperation != nil {
		v := s.RenameColumnOperation

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "RenameColumnOperation", v, metadata)
	}
	if s.TagColumnOperation != nil {
		v := s.TagColumnOperation

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "TagColumnOperation", v, metadata)
	}
	return nil
}

// Twitter parameters.
type TwitterParameters struct {
	_ struct{} `type:"structure"`

	// Maximum number of rows to query Twitter.
	//
	// MaxRows is a required field
	MaxRows *int64 `min:"1" type:"integer" required:"true"`

	// Twitter query string.
	//
	// Query is a required field
	Query *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s TwitterParameters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TwitterParameters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TwitterParameters"}

	if s.MaxRows == nil {
		invalidParams.Add(aws.NewErrParamRequired("MaxRows"))
	}
	if s.MaxRows != nil && *s.MaxRows < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxRows", 1))
	}

	if s.Query == nil {
		invalidParams.Add(aws.NewErrParamRequired("Query"))
	}
	if s.Query != nil && len(*s.Query) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Query", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TwitterParameters) MarshalFields(e protocol.FieldEncoder) error {
	if s.MaxRows != nil {
		v := *s.MaxRows

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxRows", protocol.Int64Value(v), metadata)
	}
	if s.Query != nil {
		v := *s.Query

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Query", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The theme colors that apply to UI and to charts, excluding data colors. The
// colors description is a hexidecimal color code that consists of six alphanumerical
// characters, prefixed with #, for example #37BFF5. For more information, see
// Using Themes in Amazon QuickSight (https://docs.aws.amazon.com/quicksight/latest/user/themes-in-quicksight.html)
// in the Amazon QuickSight User Guide.
type UIColorPalette struct {
	_ struct{} `type:"structure"`

	// This color is that applies to selected states and buttons.
	Accent *string `type:"string"`

	// The foreground color that applies to any text or other elements that appear
	// over the accent color.
	AccentForeground *string `type:"string"`

	// The color that applies to error messages.
	Danger *string `type:"string"`

	// The foreground color that applies to any text or other elements that appear
	// over the error color.
	DangerForeground *string `type:"string"`

	// The color that applies to the names of fields that are identified as dimensions.
	Dimension *string `type:"string"`

	// The foreground color that applies to any text or other elements that appear
	// over the dimension color.
	DimensionForeground *string `type:"string"`

	// The color that applies to the names of fields that are identified as measures.
	Measure *string `type:"string"`

	// The foreground color that applies to any text or other elements that appear
	// over the measure color.
	MeasureForeground *string `type:"string"`

	// The background color that applies to visuals and other high emphasis UI.
	PrimaryBackground *string `type:"string"`

	// The color of text and other foreground elements that appear over the primary
	// background regions, such as grid lines, borders, table banding, icons, and
	// so on.
	PrimaryForeground *string `type:"string"`

	// The background color that applies to the sheet background and sheet controls.
	SecondaryBackground *string `type:"string"`

	// The foreground color that applies to any sheet title, sheet control text,
	// or UI that appears over the secondary background.
	SecondaryForeground *string `type:"string"`

	// The color that applies to success messages, for example the check mark for
	// a successful download.
	Success *string `type:"string"`

	// The foreground color that applies to any text or other elements that appear
	// over the success color.
	SuccessForeground *string `type:"string"`

	// This color that applies to warning and informational messages.
	Warning *string `type:"string"`

	// The foreground color that applies to any text or other elements that appear
	// over the warning color.
	WarningForeground *string `type:"string"`
}

// String returns the string representation
func (s UIColorPalette) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UIColorPalette) MarshalFields(e protocol.FieldEncoder) error {
	if s.Accent != nil {
		v := *s.Accent

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Accent", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AccentForeground != nil {
		v := *s.AccentForeground

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AccentForeground", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Danger != nil {
		v := *s.Danger

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Danger", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DangerForeground != nil {
		v := *s.DangerForeground

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DangerForeground", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Dimension != nil {
		v := *s.Dimension

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Dimension", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DimensionForeground != nil {
		v := *s.DimensionForeground

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DimensionForeground", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Measure != nil {
		v := *s.Measure

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Measure", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MeasureForeground != nil {
		v := *s.MeasureForeground

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MeasureForeground", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PrimaryBackground != nil {
		v := *s.PrimaryBackground

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PrimaryBackground", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PrimaryForeground != nil {
		v := *s.PrimaryForeground

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PrimaryForeground", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SecondaryBackground != nil {
		v := *s.SecondaryBackground

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SecondaryBackground", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SecondaryForeground != nil {
		v := *s.SecondaryForeground

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SecondaryForeground", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Success != nil {
		v := *s.Success

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Success", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SuccessForeground != nil {
		v := *s.SuccessForeground

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SuccessForeground", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Warning != nil {
		v := *s.Warning

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Warning", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.WarningForeground != nil {
		v := *s.WarningForeground

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "WarningForeground", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about the format for a source file or files.
type UploadSettings struct {
	_ struct{} `type:"structure"`

	// Whether the file has a header row, or the files each have a header row.
	ContainsHeader *bool `type:"boolean"`

	// The delimiter between values in the file.
	Delimiter *string `min:"1" type:"string"`

	// File format.
	Format FileFormat `type:"string" enum:"true"`

	// A row number to start reading data from.
	StartFromRow *int64 `min:"1" type:"integer"`

	// Text qualifier.
	TextQualifier TextQualifier `type:"string" enum:"true"`
}

// String returns the string representation
func (s UploadSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UploadSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UploadSettings"}
	if s.Delimiter != nil && len(*s.Delimiter) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Delimiter", 1))
	}
	if s.StartFromRow != nil && *s.StartFromRow < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("StartFromRow", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UploadSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.ContainsHeader != nil {
		v := *s.ContainsHeader

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ContainsHeader", protocol.BoolValue(v), metadata)
	}
	if s.Delimiter != nil {
		v := *s.Delimiter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Delimiter", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Format) > 0 {
		v := s.Format

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Format", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.StartFromRow != nil {
		v := *s.StartFromRow

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StartFromRow", protocol.Int64Value(v), metadata)
	}
	if len(s.TextQualifier) > 0 {
		v := s.TextQualifier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TextQualifier", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// A registered user of Amazon QuickSight. Currently, an Amazon QuickSight subscription
// can't contain more than 20 million users.
type User struct {
	_ struct{} `type:"structure"`

	// The active status of user. When you create an Amazon QuickSight user that’s
	// not an IAM user or an Active Directory user, that user is inactive until
	// they sign in and provide a password.
	Active *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) for the user.
	Arn *string `type:"string"`

	// The user's email address.
	Email *string `type:"string"`

	// The type of identity authentication used by the user.
	IdentityType IdentityType `type:"string" enum:"true"`

	// The principal ID of the user.
	PrincipalId *string `type:"string"`

	// The Amazon QuickSight role for the user. The user role can be one of the
	// following:.
	//
	//    * READER: A user who has read-only access to dashboards.
	//
	//    * AUTHOR: A user who can create data sources, datasets, analyses, and
	//    dashboards.
	//
	//    * ADMIN: A user who is an author, who can also manage Amazon QuickSight
	//    settings.
	//
	//    * RESTRICTED_READER: This role isn't currently available for use.
	//
	//    * RESTRICTED_AUTHOR: This role isn't currently available for use.
	Role UserRole `type:"string" enum:"true"`

	// The user's user name.
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s User) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s User) MarshalFields(e protocol.FieldEncoder) error {
	if s.Active != nil {
		v := *s.Active

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Active", protocol.BoolValue(v), metadata)
	}
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Email != nil {
		v := *s.Email

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Email", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.IdentityType) > 0 {
		v := s.IdentityType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IdentityType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.PrincipalId != nil {
		v := *s.PrincipalId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PrincipalId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Role) > 0 {
		v := s.Role

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Role", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.UserName != nil {
		v := *s.UserName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UserName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// VPC connection properties.
type VpcConnectionProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the VPC connection.
	//
	// VpcConnectionArn is a required field
	VpcConnectionArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s VpcConnectionProperties) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VpcConnectionProperties) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "VpcConnectionProperties"}

	if s.VpcConnectionArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("VpcConnectionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VpcConnectionProperties) MarshalFields(e protocol.FieldEncoder) error {
	if s.VpcConnectionArn != nil {
		v := *s.VpcConnectionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VpcConnectionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}
