// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package quicksight

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateThemeInput struct {
	_ struct{} `type:"structure"`

	// The ID of the AWS account that contains the theme that you're updating.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The theme ID, defined by Amazon QuickSight, that a custom theme inherits
	// from. All themes initially inherit from a default QuickSight theme.
	//
	// BaseThemeId is a required field
	BaseThemeId *string `min:"1" type:"string" required:"true"`

	// The theme configuration, which contains the theme display properties.
	Configuration *ThemeConfiguration `type:"structure"`

	// The name for the theme.
	Name *string `min:"1" type:"string"`

	// The ID for the theme.
	//
	// ThemeId is a required field
	ThemeId *string `location:"uri" locationName:"ThemeId" min:"1" type:"string" required:"true"`

	// A description of the theme version that you're updating Every time that you
	// call UpdateTheme, you create a new version of the theme. Each version of
	// the theme maintains a description of the version in VersionDescription.
	VersionDescription *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateThemeInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateThemeInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateThemeInput"}

	if s.AwsAccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("AwsAccountId", 12))
	}

	if s.BaseThemeId == nil {
		invalidParams.Add(aws.NewErrParamRequired("BaseThemeId"))
	}
	if s.BaseThemeId != nil && len(*s.BaseThemeId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("BaseThemeId", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.ThemeId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ThemeId"))
	}
	if s.ThemeId != nil && len(*s.ThemeId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ThemeId", 1))
	}
	if s.VersionDescription != nil && len(*s.VersionDescription) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VersionDescription", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateThemeInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.BaseThemeId != nil {
		v := *s.BaseThemeId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BaseThemeId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Configuration != nil {
		v := s.Configuration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Configuration", v, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VersionDescription != nil {
		v := *s.VersionDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VersionDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AwsAccountId != nil {
		v := *s.AwsAccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "AwsAccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThemeId != nil {
		v := *s.ThemeId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "ThemeId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdateThemeOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the theme.
	Arn *string `type:"string"`

	// The creation status of the theme.
	CreationStatus ResourceStatus `type:"string" enum:"true"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// The ID for the theme.
	ThemeId *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) for the new version of the theme.
	VersionArn *string `type:"string"`
}

// String returns the string representation
func (s UpdateThemeOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateThemeOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.CreationStatus) > 0 {
		v := s.CreationStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThemeId != nil {
		v := *s.ThemeId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ThemeId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VersionArn != nil {
		v := *s.VersionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VersionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	// ignoring invalid encode state, StatusCode. Status
	return nil
}

const opUpdateTheme = "UpdateTheme"

// UpdateThemeRequest returns a request value for making API operation for
// Amazon QuickSight.
//
// Updates a theme.
//
//    // Example sending a request using UpdateThemeRequest.
//    req := client.UpdateThemeRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTheme
func (c *Client) UpdateThemeRequest(input *UpdateThemeInput) UpdateThemeRequest {
	op := &aws.Operation{
		Name:       opUpdateTheme,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/themes/{ThemeId}",
	}

	if input == nil {
		input = &UpdateThemeInput{}
	}

	req := c.newRequest(op, input, &UpdateThemeOutput{})

	return UpdateThemeRequest{Request: req, Input: input, Copy: c.UpdateThemeRequest}
}

// UpdateThemeRequest is the request type for the
// UpdateTheme API operation.
type UpdateThemeRequest struct {
	*aws.Request
	Input *UpdateThemeInput
	Copy  func(*UpdateThemeInput) UpdateThemeRequest
}

// Send marshals and sends the UpdateTheme API request.
func (r UpdateThemeRequest) Send(ctx context.Context) (*UpdateThemeResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateThemeResponse{
		UpdateThemeOutput: r.Request.Data.(*UpdateThemeOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateThemeResponse is the response type for the
// UpdateTheme API operation.
type UpdateThemeResponse struct {
	*UpdateThemeOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateTheme request.
func (r *UpdateThemeResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
