// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package qldb

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

type DeleteLedgerInput struct {
	_ struct{} `type:"structure"`

	// The name of the ledger that you want to delete.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLedgerInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLedgerInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteLedgerInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteLedgerInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteLedgerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteLedgerOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteLedgerOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteLedger = "DeleteLedger"

// DeleteLedgerRequest returns a request value for making API operation for
// Amazon QLDB.
//
// Deletes a ledger and all of its contents. This action is irreversible.
//
// If deletion protection is enabled, you must first disable it before you can
// delete the ledger using the QLDB API or the AWS Command Line Interface (AWS
// CLI). You can disable it by calling the UpdateLedger operation to set the
// flag to false. The QLDB console disables deletion protection for you when
// you use it to delete a ledger.
//
//    // Example sending a request using DeleteLedgerRequest.
//    req := client.DeleteLedgerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/DeleteLedger
func (c *Client) DeleteLedgerRequest(input *DeleteLedgerInput) DeleteLedgerRequest {
	op := &aws.Operation{
		Name:       opDeleteLedger,
		HTTPMethod: "DELETE",
		HTTPPath:   "/ledgers/{name}",
	}

	if input == nil {
		input = &DeleteLedgerInput{}
	}

	req := c.newRequest(op, input, &DeleteLedgerOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DeleteLedgerRequest{Request: req, Input: input, Copy: c.DeleteLedgerRequest}
}

// DeleteLedgerRequest is the request type for the
// DeleteLedger API operation.
type DeleteLedgerRequest struct {
	*aws.Request
	Input *DeleteLedgerInput
	Copy  func(*DeleteLedgerInput) DeleteLedgerRequest
}

// Send marshals and sends the DeleteLedger API request.
func (r DeleteLedgerRequest) Send(ctx context.Context) (*DeleteLedgerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteLedgerResponse{
		DeleteLedgerOutput: r.Request.Data.(*DeleteLedgerOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteLedgerResponse is the response type for the
// DeleteLedger API operation.
type DeleteLedgerResponse struct {
	*DeleteLedgerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteLedger request.
func (r *DeleteLedgerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
