// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateRecommenderConfigurationInput struct {
	_ struct{} `type:"structure" payload:"UpdateRecommenderConfiguration"`

	// RecommenderId is a required field
	RecommenderId *string `location:"uri" locationName:"recommender-id" type:"string" required:"true"`

	// Specifies Amazon Pinpoint configuration settings for retrieving and processing
	// recommendation data from a recommender model.
	//
	// UpdateRecommenderConfiguration is a required field
	UpdateRecommenderConfiguration *UpdateRecommenderConfiguration `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateRecommenderConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRecommenderConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateRecommenderConfigurationInput"}

	if s.RecommenderId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RecommenderId"))
	}

	if s.UpdateRecommenderConfiguration == nil {
		invalidParams.Add(aws.NewErrParamRequired("UpdateRecommenderConfiguration"))
	}
	if s.UpdateRecommenderConfiguration != nil {
		if err := s.UpdateRecommenderConfiguration.Validate(); err != nil {
			invalidParams.AddNested("UpdateRecommenderConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateRecommenderConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.RecommenderId != nil {
		v := *s.RecommenderId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "recommender-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UpdateRecommenderConfiguration != nil {
		v := s.UpdateRecommenderConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "UpdateRecommenderConfiguration", v, metadata)
	}
	return nil
}

type UpdateRecommenderConfigurationOutput struct {
	_ struct{} `type:"structure" payload:"RecommenderConfigurationResponse"`

	// Provides information about Amazon Pinpoint configuration settings for retrieving
	// and processing data from a recommender model.
	//
	// RecommenderConfigurationResponse is a required field
	RecommenderConfigurationResponse *RecommenderConfigurationResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateRecommenderConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateRecommenderConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.RecommenderConfigurationResponse != nil {
		v := s.RecommenderConfigurationResponse

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "RecommenderConfigurationResponse", v, metadata)
	}
	return nil
}

const opUpdateRecommenderConfiguration = "UpdateRecommenderConfiguration"

// UpdateRecommenderConfigurationRequest returns a request value for making API operation for
// Amazon Pinpoint.
//
// Updates an Amazon Pinpoint configuration for a recommender model.
//
//    // Example sending a request using UpdateRecommenderConfigurationRequest.
//    req := client.UpdateRecommenderConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateRecommenderConfiguration
func (c *Client) UpdateRecommenderConfigurationRequest(input *UpdateRecommenderConfigurationInput) UpdateRecommenderConfigurationRequest {
	op := &aws.Operation{
		Name:       opUpdateRecommenderConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/recommenders/{recommender-id}",
	}

	if input == nil {
		input = &UpdateRecommenderConfigurationInput{}
	}

	req := c.newRequest(op, input, &UpdateRecommenderConfigurationOutput{})

	return UpdateRecommenderConfigurationRequest{Request: req, Input: input, Copy: c.UpdateRecommenderConfigurationRequest}
}

// UpdateRecommenderConfigurationRequest is the request type for the
// UpdateRecommenderConfiguration API operation.
type UpdateRecommenderConfigurationRequest struct {
	*aws.Request
	Input *UpdateRecommenderConfigurationInput
	Copy  func(*UpdateRecommenderConfigurationInput) UpdateRecommenderConfigurationRequest
}

// Send marshals and sends the UpdateRecommenderConfiguration API request.
func (r UpdateRecommenderConfigurationRequest) Send(ctx context.Context) (*UpdateRecommenderConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateRecommenderConfigurationResponse{
		UpdateRecommenderConfigurationOutput: r.Request.Data.(*UpdateRecommenderConfigurationOutput),
		response:                             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateRecommenderConfigurationResponse is the response type for the
// UpdateRecommenderConfiguration API operation.
type UpdateRecommenderConfigurationResponse struct {
	*UpdateRecommenderConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateRecommenderConfiguration request.
func (r *UpdateRecommenderConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
