// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateApnsVoipSandboxChannelInput struct {
	_ struct{} `type:"structure" payload:"APNSVoipSandboxChannelRequest"`

	// Specifies the status and settings of the APNs (Apple Push Notification service)
	// VoIP sandbox channel for an application.
	//
	// APNSVoipSandboxChannelRequest is a required field
	APNSVoipSandboxChannelRequest *APNSVoipSandboxChannelRequest `type:"structure" required:"true"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateApnsVoipSandboxChannelInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateApnsVoipSandboxChannelInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateApnsVoipSandboxChannelInput"}

	if s.APNSVoipSandboxChannelRequest == nil {
		invalidParams.Add(aws.NewErrParamRequired("APNSVoipSandboxChannelRequest"))
	}

	if s.ApplicationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateApnsVoipSandboxChannelInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "application-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.APNSVoipSandboxChannelRequest != nil {
		v := s.APNSVoipSandboxChannelRequest

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "APNSVoipSandboxChannelRequest", v, metadata)
	}
	return nil
}

type UpdateApnsVoipSandboxChannelOutput struct {
	_ struct{} `type:"structure" payload:"APNSVoipSandboxChannelResponse"`

	// Provides information about the status and settings of the APNs (Apple Push
	// Notification service) VoIP sandbox channel for an application.
	//
	// APNSVoipSandboxChannelResponse is a required field
	APNSVoipSandboxChannelResponse *APNSVoipSandboxChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateApnsVoipSandboxChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateApnsVoipSandboxChannelOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.APNSVoipSandboxChannelResponse != nil {
		v := s.APNSVoipSandboxChannelResponse

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "APNSVoipSandboxChannelResponse", v, metadata)
	}
	return nil
}

const opUpdateApnsVoipSandboxChannel = "UpdateApnsVoipSandboxChannel"

// UpdateApnsVoipSandboxChannelRequest returns a request value for making API operation for
// Amazon Pinpoint.
//
// Enables the APNs VoIP sandbox channel for an application or updates the status
// and settings of the APNs VoIP sandbox channel for an application.
//
//    // Example sending a request using UpdateApnsVoipSandboxChannelRequest.
//    req := client.UpdateApnsVoipSandboxChannelRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsVoipSandboxChannel
func (c *Client) UpdateApnsVoipSandboxChannelRequest(input *UpdateApnsVoipSandboxChannelInput) UpdateApnsVoipSandboxChannelRequest {
	op := &aws.Operation{
		Name:       opUpdateApnsVoipSandboxChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/channels/apns_voip_sandbox",
	}

	if input == nil {
		input = &UpdateApnsVoipSandboxChannelInput{}
	}

	req := c.newRequest(op, input, &UpdateApnsVoipSandboxChannelOutput{})

	return UpdateApnsVoipSandboxChannelRequest{Request: req, Input: input, Copy: c.UpdateApnsVoipSandboxChannelRequest}
}

// UpdateApnsVoipSandboxChannelRequest is the request type for the
// UpdateApnsVoipSandboxChannel API operation.
type UpdateApnsVoipSandboxChannelRequest struct {
	*aws.Request
	Input *UpdateApnsVoipSandboxChannelInput
	Copy  func(*UpdateApnsVoipSandboxChannelInput) UpdateApnsVoipSandboxChannelRequest
}

// Send marshals and sends the UpdateApnsVoipSandboxChannel API request.
func (r UpdateApnsVoipSandboxChannelRequest) Send(ctx context.Context) (*UpdateApnsVoipSandboxChannelResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateApnsVoipSandboxChannelResponse{
		UpdateApnsVoipSandboxChannelOutput: r.Request.Data.(*UpdateApnsVoipSandboxChannelOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateApnsVoipSandboxChannelResponse is the response type for the
// UpdateApnsVoipSandboxChannel API operation.
type UpdateApnsVoipSandboxChannelResponse struct {
	*UpdateApnsVoipSandboxChannelOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateApnsVoipSandboxChannel request.
func (r *UpdateApnsVoipSandboxChannelResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
