// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetUserEndpointsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// UserId is a required field
	UserId *string `location:"uri" locationName:"user-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetUserEndpointsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUserEndpointsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetUserEndpointsInput"}

	if s.ApplicationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationId"))
	}

	if s.UserId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetUserEndpointsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "application-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UserId != nil {
		v := *s.UserId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "user-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetUserEndpointsOutput struct {
	_ struct{} `type:"structure" payload:"EndpointsResponse"`

	// Provides information about all the endpoints that are associated with a user
	// ID.
	//
	// EndpointsResponse is a required field
	EndpointsResponse *EndpointsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetUserEndpointsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetUserEndpointsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.EndpointsResponse != nil {
		v := s.EndpointsResponse

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "EndpointsResponse", v, metadata)
	}
	return nil
}

const opGetUserEndpoints = "GetUserEndpoints"

// GetUserEndpointsRequest returns a request value for making API operation for
// Amazon Pinpoint.
//
// Retrieves information about all the endpoints that are associated with a
// specific user ID.
//
//    // Example sending a request using GetUserEndpointsRequest.
//    req := client.GetUserEndpointsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetUserEndpoints
func (c *Client) GetUserEndpointsRequest(input *GetUserEndpointsInput) GetUserEndpointsRequest {
	op := &aws.Operation{
		Name:       opGetUserEndpoints,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/users/{user-id}",
	}

	if input == nil {
		input = &GetUserEndpointsInput{}
	}

	req := c.newRequest(op, input, &GetUserEndpointsOutput{})

	return GetUserEndpointsRequest{Request: req, Input: input, Copy: c.GetUserEndpointsRequest}
}

// GetUserEndpointsRequest is the request type for the
// GetUserEndpoints API operation.
type GetUserEndpointsRequest struct {
	*aws.Request
	Input *GetUserEndpointsInput
	Copy  func(*GetUserEndpointsInput) GetUserEndpointsRequest
}

// Send marshals and sends the GetUserEndpoints API request.
func (r GetUserEndpointsRequest) Send(ctx context.Context) (*GetUserEndpointsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetUserEndpointsResponse{
		GetUserEndpointsOutput: r.Request.Data.(*GetUserEndpointsOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetUserEndpointsResponse is the response type for the
// GetUserEndpoints API operation.
type GetUserEndpointsResponse struct {
	*GetUserEndpointsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetUserEndpoints request.
func (r *GetUserEndpointsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
