// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package organizations

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type MoveAccountInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) of the account that you want to move.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for an account ID string
	// requires exactly 12 digits.
	//
	// AccountId is a required field
	AccountId *string `type:"string" required:"true"`

	// The unique identifier (ID) of the root or organizational unit that you want
	// to move the account to.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a parent ID string
	// requires one of the following:
	//
	//    * Root - A string that begins with "r-" followed by from 4 to 32 lowercase
	//    letters or digits.
	//
	//    * Organizational unit (OU) - A string that begins with "ou-" followed
	//    by from 4 to 32 lowercase letters or digits (the ID of the root that the
	//    OU is in). This string is followed by a second "-" dash and from 8 to
	//    32 additional lowercase letters or digits.
	//
	// DestinationParentId is a required field
	DestinationParentId *string `type:"string" required:"true"`

	// The unique identifier (ID) of the root or organizational unit that you want
	// to move the account from.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a parent ID string
	// requires one of the following:
	//
	//    * Root - A string that begins with "r-" followed by from 4 to 32 lowercase
	//    letters or digits.
	//
	//    * Organizational unit (OU) - A string that begins with "ou-" followed
	//    by from 4 to 32 lowercase letters or digits (the ID of the root that the
	//    OU is in). This string is followed by a second "-" dash and from 8 to
	//    32 additional lowercase letters or digits.
	//
	// SourceParentId is a required field
	SourceParentId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s MoveAccountInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MoveAccountInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MoveAccountInput"}

	if s.AccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountId"))
	}

	if s.DestinationParentId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DestinationParentId"))
	}

	if s.SourceParentId == nil {
		invalidParams.Add(aws.NewErrParamRequired("SourceParentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type MoveAccountOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s MoveAccountOutput) String() string {
	return awsutil.Prettify(s)
}

const opMoveAccount = "MoveAccount"

// MoveAccountRequest returns a request value for making API operation for
// AWS Organizations.
//
// Moves an account from its current source parent root or organizational unit
// (OU) to the specified destination parent root or OU.
//
// This operation can be called only from the organization's master account.
//
//    // Example sending a request using MoveAccountRequest.
//    req := client.MoveAccountRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/MoveAccount
func (c *Client) MoveAccountRequest(input *MoveAccountInput) MoveAccountRequest {
	op := &aws.Operation{
		Name:       opMoveAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &MoveAccountInput{}
	}

	req := c.newRequest(op, input, &MoveAccountOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return MoveAccountRequest{Request: req, Input: input, Copy: c.MoveAccountRequest}
}

// MoveAccountRequest is the request type for the
// MoveAccount API operation.
type MoveAccountRequest struct {
	*aws.Request
	Input *MoveAccountInput
	Copy  func(*MoveAccountInput) MoveAccountRequest
}

// Send marshals and sends the MoveAccount API request.
func (r MoveAccountRequest) Send(ctx context.Context) (*MoveAccountResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &MoveAccountResponse{
		MoveAccountOutput: r.Request.Data.(*MoveAccountOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// MoveAccountResponse is the response type for the
// MoveAccount API operation.
type MoveAccountResponse struct {
	*MoveAccountOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// MoveAccount request.
func (r *MoveAccountResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
